---
title: "MA 3: Stephanie Hurlburt on Perception of Value"
season: 2
date: "2019-04-19"
time: "55"
description: "What do we treasure? Stephanie Hurlburt (Binomial) joins again to chat about inherent vs. perceived value, success breeding success, psychology around hiding information, code versus money, a holistic/explicit view of business, everything as marketing, confidence, money as idolatry, the nature of giving, our biases around people/status, people want to see you succeed, communicating how people can help you. (recorded in February)"
episodeLink: 77418a33
embedUrl: https://share.transistor.fm/e/6f127e1c
sidebar:
    order: 3
---

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-2/value.md)

[00:06] **Stephanie**: We were talking about perceived value. We were talking about the idea that whenever you're talking to someone that's being interpreted. People value things in different ways. You can communicate value in different ways, and perceived value, the value that someone perceives something to be, can be much different than the inherent value you think it has. It's a very complicated topic in negotiation, and networking, and sales. And it's one that even applies to salary. So we were talking about that.

[00:46] **Henry**: Yeah, I guess now that you bring it up like this, it seems to be at the moment the most relevant concept in terms of open-source, right? It's like the value of open-source, I mean in my mind is like, so high, but then what we're paying for it, which is nothing usually, is not there at all. So how do we almost like even at a cultural or systematic level, and then also individually when we're talking to people at companies.

[01:17] **Stephanie**: Yeah. And one way to communicate and influence perceived value is for them to see what you're charging now, and what you think your prices or worth are now. It's interesting, because obviously money doesn't directly correlate to worth and value. It doesn't but it's one of those signals that can send a message to someone that for instance if they find out you have a massive dollar sign support agreement, they're immediately going to think like, "Wow, why was that signed? Obviously this company found that valuable if they were going to spend so much money." And if they find out you're selling support agreements for a really low amount they'll be like, "Oh well," it'll be the opposite. They'll be like, "Oh, well if they aren't selling this for a lot of money, maybe the corporation didn't find it that important," and that's the reason. So obviously we know that it can be also just be a matter of the open-source maintainer needs more sales skills, or doesn't have a strong network, but that's always going to be a bias and something in people's heads. And that influences perceived value.

[02:32] **Henry**: Right. I feel like I see this even with my own experience with trying to raise money, I suppose. It's like the more money that you have, the more money you can make. If you go to a Patreon, Open Collective page, and you see that Babble has made... Or even my own page, say it only had a dollar, then no one's going to want to donate to it. Even if they see that what I'm doing is valuable. Or when they see that, that Babble has 10,000 a year, it's like, well that's basically nothing. So that's weird because you would think that means like, "Oh they need the money. So I'm going to give them more." But in reality it feels more like when we're already successful more people are willing to give.

[03:19] **Stephanie**: Yeah, and that's something that's commonly talked about in business for selling proprietary products as well. Is like this idea, and it's easier with proprietary products. It's easier because you get to keep more information close to your chest. With open-source and with stuff like Patreon you're putting all that information out there. When you're selling a proprietary product you compute like, you don't have to lie, but you can imply that you've got deals even though you don't, and then that increases your perceived value. Doing it in open-source is hard. It's very hard, and it's almost like if you're in that boat where you're only making a dollar a month on Patreon, my advice would be to find a way to word your marketing that basically counteracts that like saying, "this is brand new," would counteract that. People would be like, "Oh, you just opened it. Okay, that makes sense." You need something to be like, "No, I'm not just worth a dollar a month."

[04:22] **Henry**: I guess that reminds me of how whenever they do something new, you ask your friends or all those people to put money in so it looks like you already have a lot in the beginning.

[04:32] **Stephanie**: Yeah, even if you're saying like, "this is brand new," you're right that, that perceived value still takes a hit.

[04:39] **Henry**: And then another thing is actually Patreon lets you not show the amount. So I think you can turn off the dollar amount, and even maybe the backer amount. So it's funny, when you're not making a lot, maybe you should not put it there. And then when you feel like it's a good amount quote-unquote, then you should put it back.

[05:02] **Stephanie**: It makes it real tricky though, because Patreon does have a very common option showing the dollar amount. So if you don't show the dollar amount people are going to wonder, "Why isn't the dollar amount shown?" And if all these maintainers making a bunch of money are showing dollar amounts they're like, "Oh, is it because you're not making money?" And it would be cool if you could come up with a reason for not showing dollar amounts that wasn't correlated with not making money. Like maybe some of the contributors want to be confidential. Stuff like that to raise the perceived value, and not have the assumption be, it's because you're not making enough.

[05:42] **Henry**: Because I know in other cases people don't show the amount because they're making too much. But that's a-

[05:48] **Stephanie**: Ah, that's good then. I didn't realize that actually, because I see a lot of Patreons making a lot of money, and they show it. That's the other problem though, is one problem of showing that you're making a lot is people can be like, "Oh, you have enough." And that is a problem that doesn't happen as much in business, because you have leverage there. You're selling a proprietary product, they see that you're rolling dough. You have a lot of money. But they aren't getting a certain benefit from you. They aren't getting a license, so you still have that leverage over them to be like, "If you want a license, you can see I'm rolling in money, so obviously this license is going to be high." That you've got leverage. With an open-source library you have to think about what your leverage is, and then if you show you're making a lot of money it shows that, okay, whatever service or extra thing you can provide them is going to be worth a lot.

[06:55] **Henry**: I mean I've seen this with more content creation even though I guess open-source is like that in a different way. Where like YouTube or Twitch, live streaming, I guess the top people, say Ninja, you have millions of subscribers or followers, and people are donating just to put a message on the stream for a few dollars. I think people know that he's making half a million dollars a month, but then people are still giving him money.

[07:25] **Stephanie**: And they give him money because they're getting something. They're getting the message on the stream, and they know that he's making a lot of money, which means that for something to be worth his time he has to... Look if he's providing something to you, you will have to give him more. Yeah, it's a weird thing. It's an exchange of services. And in open-source you might not want that exchange to be your library, but you can do products around your library, like logos, marketing, consulting, contract services, support agreements.

[08:05] **Stephanie**: One thing to think about too is that, I had a conversation with an open-source maintainer who was really concerned about how all this biases them, and really wanted to go the nonprofit route. The nonprofit route is a legitimate route too.

[08:20] **Henry**: Yeah, I guess there aren't... Well I don't know of a lot of examples of that other than through a foundation which has its own pros and cons too. And I guess there's the overhead of making a nonprofit versus making an LLC or something.

[08:35] **Stephanie**: Yeah, I've never made a nonprofit. I would strongly, if you are thinking about going that route, I would strongly encourage people to talk to people who have run nonprofits. Whenever I've asked about it, it's always been the ability to even get nonprofit status has been a little bit of a struggle to my knowledge, so it's good to be knowledgeable about what that process entails. And keep in mind that there are benefit corporate structures in the United States too, which is different from a regular corporation. It has a mission, and I believe it's easier to get approved than a nonprofit.

[09:12] **Henry**: Right. I think Kickstarter changed to be a benefit corporation actually.

[09:17] **Stephanie**: I believe so. So that means if they aren't fulfilling whatever mission they have... They get to be mission driven a little bit more.

[09:25] **Henry**: Yeah, we mentioned people paying for services, and the code can't really be the thing that they're paying for, because the whole point is that it's open, then yeah, at least say we have to build something on top. And I guess that's like before it's like people will pay for your time or your code, whether you work at a company, so that's your salary, or people will pay for features. But then, I almost feel like that in itself isn't enough value for what you can provide. So it's like, what about your own knowledge? Or just access to the maintainer itself. So that's more of a support hours kind of thing. I think that scales a lot better than just writing some features, because maybe the features don't mesh with the project, or are too specific to the company, and you want to work on things that can benefit everyone more generally. Then the support hours thing, that can be it seems like a lot less time spent to get more I guess bang for your buck.

[10:30] **Stephanie**: Yeah, and one thing to think about too, is that it highly depends on the open-source project, but some maintainers make a lot of money off of services agreements. So more somewhat of a features request, but they're not adding features to the library. They're doing services related to their open-source project that do help the open-source project. Like for instance, services around integrating the product into the stack. And through doing that, they learn how to make the product better, and make it easier to integrate and stuff, but they get to make their money that way. So depending on what your open-source project is, you can charge for services that are directly adding open-source code, but still happily coexist with maintaining the library.

[11:16] **Henry**: Yeah, that makes sense. I remember before I was feeling weird that it's like, I want to get paid to work on the code itself, versus simply implementing something for another company, because it doesn't benefit anyone else. But like what you said, getting the experience of integrating something in a company might actually help in a different way of like, "Oh that gave me more ideas on how to make the project better." And working in a real setting with other engineers on how to integrate or something could be beneficial. But I think before I had this more black and white view on just like, "Oh, that's specifically for that company." Even if it is for the project, because my thought was, "Oh I just need the money to go directly to the code itself.

[12:06] **Stephanie**: It reminds me of actually issues that you can run into in a full-time job, like when I worked for Unity working on particle system engine development. So it was basically this tool that helped game creators make particle system, like fire and water, and cool flowy things in their games. I was so obsessed with, I need to focus my efforts on researching particle engines, and researching particles, and researching this core tool, but then there was this other use of my time that could be sitting with users and seeing how they use the tool, and doing work for them to help them use the tool better. And that's not useless. In fact, I probably should have spent way more time sitting with users and helping them out. It's taking away from the core particle system development, but it's actually potentially more useful, because I actually like if you build a tool in the dark, okay. You're building a tool so that it gets used by others, and so interacting and doing services for the people who use your product can end up making your product better.

[13:15] **Henry**: Yeah, I guess it's just that assumption I had where it has to be you created or something like that, or it's like, "No we can expand that." And I think that's good, because then you won't feel as bad about... It's like it feels like you're making money on this other thing when it's not at all. And it's not that different thinking more generally of engineers learning to do the business skills, where it's like, that can help your project even more, then why are we focusing so much on the code?

[13:45] **Stephanie**: I see that a lot, like I just, you know angry people on the internet are always going to exist, but there was this one person who is an open-source maintainer got really angry at me, and they were like, "How insulting that you think that I can't make money and stuff." And it's kind of like, what was around their anger was the assumption that business skills were easy, or that projects automatically made money if they were good. And not realizing... And another maintainer mentioned this to me, they were like, "Well I could just build this project in a weekend, so clearly it's not that valuable." And they were laughing at a startup that started a company over a product that was built in a weekend. Which I get it, like I'm not saying that they're bad for thinking that, but I'm just saying that you can build a product in a weekend, and then take over a year of intense work to sell it.

[14:41] **Stephanie**: Like business skills... It also reminds me of a conversation I had with my business partner where I was like... Or we recently landed this big deal, and it's going to impact a lot of people, our work, and I was lamenting that I didn't build a lot of that product, that I focused a lot on business. My business partner was like, "If you didn't focus on business, it wouldn't be used in this way at all." So if what you care about is having a big impact on the world, the business skills arguably did that just as much as the code. People don't just use things because they're out there.

[15:17] **Henry**: Yeah, exactly. It reminds me of the whole if you build it they will come, or just the purely technical, they see that it's better, and it just means that money's going to show up. And I think we use this phrase worse is better a lot. A lot of technologies might be better, and then they fail, because I guess they didn't focus on the business side, or that wasn't as much of an emphasis. And I kind of feel the same way with [inaudible 00:15:47], it's the same exact thing. I feel guilty all the time, or I'll tell my maintainers, I wish I was doing more code, or whatever, because I feel bad, and I'm focusing on all this other stuff. But then I guess slowly realizing it's still hard to actually... Mentally I think it's right, but then maybe emotionally I still want to go back to what I'm used to. And knowing that all this other work I did is the only reason why I can even I guess sustain myself now. If I didn't go out and talk to people, I can't expect companies to just randomly show up and give us money.

[16:26] **Stephanie**: But it's interesting to be a business is more than just a way to make money. In the process of doing business, you're getting to know your users. You're seeing how it's being integrated. You're able to do better support. In the process of doing business you figure out what you need to be building and what's valuable to people, and how people use it. So that's a thought too, that it's not just about making money, you can actually make a better product by doing more business work too.

[17:06] **Henry**: I like that. Or even just trying to not separate them so much where it's like, "Oh this it's business, and this is code." Or anything like that. They both help each other. And you're right. The quality of feedback or innovation we can get from talking to people on Twitter, or GitHub issues is very low compared to meeting someone in person, and talking with them, and finding out their issues. And you know, maybe it's the in person part versus online communication, but I definitely found that... I mean it just helps me realize they're people too, because I think you don't remember who you're actually talking to online. They all think... It's like both of us, people don't see maintainers as people because it's just some black box, and the same way it's hard for us to do the same thing.

[18:03] **Stephanie**: It kind of makes me think of a thing I mention a lot, which is that people new to business tend to put their business efforts into one of two categories. They either go about their normal lives, and they essentially do business unintentionally all the time. They make friends with people. They talk to users. They fix up issues. They're always interacting with people, which is related to business. Or they go into cold money making mode where they're doing a bunch of hard sells and getting aggressive, and seeing it as just about money. But the right way to do business is in the middle of those. It's like when you talk to your users, mention that you do need to be financially supported, and how they can help you out.

[18:50] **Stephanie**: It reminds me of something my therapist said, where she was saying that you should never make someone into a perpetrator. You should never make someone into some who has this image of wanting to hurt you. And in this case it's painting someone as you don't want to help me financially. And it's no, assume people would like to, but it's your responsibility to communicate what those avenues are, and make sure those are good avenues for you.

[19:23] **Henry**: I guess the assumption, like when you're doing the cold selling thing, it kind of, I don't know, it just feels like it ruins the whole thing, where it's like you're so focused on the money that you just see this person as a way to get money. And the other side is like, "Oh, they could have"... If it is just a friend, you're not seeing it as someone that could actually help you either, so it's good to like you said to` have a balance for that.

[19:47] **Stephanie**: Yeah, your friend wants to help you financially, and the person who you might be doing this just be giving you money is a person too.

[19:55] **Henry**: Exactly.

[19:56] **Stephanie**: And they might believing in the mission too. And they might be highly motivated by that, and not just by money. So it's really important to strike a balance. It's so funny because I recently did this negotiation that was, it was just a perfect example of this. So we entered in via the programmer, and the programmer was like, "Obviously your techs valuable, I want to use it." And so we gave them an evaluation. This is for proprietary software, but you can draw parallels, and the programmer was taking the role of a business person. I could tell he was trying it on, and like you know. He was like... And it was very cold. And once we got to the actual business person, he was the most friendly guy in the world, and it was like... And this is a guy with decades of business experience. And it's clearly this business person who specializes in this knows that being friendly and warm and human is a better way to do business.

[21:04] **Henry**: So he had this on off switch, like, "Okay, I'm in selling mode."

[21:08] **Stephanie**: It's like, "no." He started off telling me about his daughter, and what she's doing. And then he's telling me he really loves our mission, and it was just very human, you know?

[21:23] **Henry**: I think it helps, because it just gives you the freedom to be more creative about how you want to meet people and prove the project right?

[21:32] **Stephanie**: Well sure. Like I own this vibe on this community. It doesn't really have a theme, but it's kind of just a general place to talk to people and network. And recently someone came in there with a cold pitch. Their icon was the logo of a company, and they just went right into selling their product. And the painful part about that to me was their product was actually relevant to the people in the community, but everyone had a really negative response to that because they completely neglected the human element to selling.

[22:07] **Henry**: Right, there's the norm of there's chatroom and people are talking and you randomly... That happens in our Slack for Babble, where the point of the Slack is to help people with their questions or maybe if they want to contribute, and then randomly they're like, "Hey, do you want to buy this thing?" It's like, "How does that have anything to do with what we're saying."

[22:26] **Stephanie**: And the members were like, "You should kick them out. They're violating the rules." And I'm like, "Actually, you all are pitching all the time." People are like, "Oh, can you review my resume?" Like, "Oh, here's what I'm up to lately. Here's a blog post I wrote." But yet they're just not pitching in such a cold way. So I was telling them it's okay to pitch here. This is a space where people pitch all the time, but maybe the cold approach isn't effective here.

[22:52] **Henry**: Yeah, that's a good way of putting it. I guess the same way you said we're always pitching ourselves. Everything we do is I guess in a sense marketing. Especially on social media. Even so, I think if we realize that, then we don't have to go into this mode of cold selling, because writing something on your Twitter, whatever it is, it's influencing what people think about you and the product.

[23:19] **Stephanie**: Exactly. Exactly. It really is. And it's like when you think about do you ever describe what your product does to someone? Do you ever describe how they can financially help you? Like, okay, so you're already doing those things, so why not put effort into making those pitches better. One interesting thing that I've actually been learning lately is that if you are confident the perceived values and the prices that you can charge change. This is something that I'm actively learning, because for many years I would approach a lot of price negotiations with what do you think about this? And this applies to open-source because you're pricing whenever you're... Whenever you're accepting money, you're pricing. Whether it be Patreon, or whether it be a logo on your page, your services, your support, whatever you're pricing.

[24:15] **Stephanie**: So, I basically for many years I would figure out what a good price was by asking them a lot of questions, and asking them what they thought of prices, and haggling, and techniques like that. And in B2B, so when you're selling to businesses the price psychology is the right price if they agree to it, and they give you the money, but they're complaining about it. And that's unique to B2B. In B2B one of the reasoning for that price psychology is that it's not their money, and it's not a necessary product, so the complaints are more around navigating the corporate bureaucracy, which is just going to be there. It's hard to describe to people who aren't used to it, but it's like that is the right price when selling to businesses. They're complaining about the price, not you, but the price and they're paying. Anyway, I would find that price through asking questions.

[25:15] **Stephanie**: Lately because I've become more confident that, that price is right, I've just been saying the price. Like here it is, this is our price. I'm going to walk. And I also have more financial security now, so I'm like, "I'm going to walk if you can't pay this." I have noticed and I have experimented with raising that, raising that to points where they would not pay me if I was posing it to a question, and they still pay. So it's weird how confidence really changes perceived value sometimes drastically.

[25:45] **Henry**: Right. Like saying it as a question, versus just the statement like, "This is how much it is."

[25:50] **Stephanie**: Yeah. And it's more than just like, "Oh, so you're open to haggling?" It's like, "Oh, if you're not even sure, you must not have much business experience." Like, "Wow, your product must not be that good." There's a whole complicated psychology to it that I'm currently figuring out.

[26:07] **Henry**: I guess that's true. If you have this ability then why even sell yourself short I suppose. But maybe there's like, when you're talking about confidence. It is the sort of attitude I would say, I think people use the word scarcity versus abundance, and showing that you have a lot means that you can... Even if you don't I guess, makes it easier to make these kinds of decisions.

[26:34] **Stephanie**: Yeah, it's interesting. It's very interesting. Another recent challenge I've been running into with business is that money means very different things. Not only between corporations and individuals, but also between different kinds of corporations. In the same way that my grocery budget used to be like \$25.00 a week. And I now spend more than that on a takeout meal. And my old self would be like, "What the hell are you doing?" But to me that's normal now. So our perceptions of money can change, but in corporations it's like that times a million. Corporations really view money in different ways. I was talking about acquisitions with someone who's very familiar with this one particular corporation, and she was like, "Oh, yeah, an acquisition worth less than 10 million is you're a piece of crap company." I'm like, "Oh, my God." Actually I will take that money. You can call me a piece of crap if you want.

[27:52] **Stephanie**: And the bar of where you lose respect, and what money means, and what money communicates is so different between companies. And also is influenced by perceived value. So it's this crazy complex equation of what they perceive your value to be, and what they view money as, and what influences perceived value and all this complex calculations to determine what price you should charge. It's crazy. It's why mathematics for economics is a mess sometimes, is because human nature is really complex more than machines are.

[28:32] **Henry**: It's almost like when you have the amount of money. That it's just like that amount of money changes how you see what you can do in the future. I was thinking about when I decided to quit, and I could have waited a long time for me to I guess, quote-unquote, have enough to quit later, but I just decided to do it now, or at the time, because I don't know I guess I thought that simply waiting wasn't going to change anything. And maybe making the decision would force me to think a little bit differently, and then when we had no money, it's like when you have a small amount of money it's weird if you're arguing how we should spend it. It's like, "Oh, we're going buy some stickers for people or t-shirts." It's like, "What are we doing?" Then when you get enough to pay someone, that fundamentally changes what you would want to do with it later like, "Oh, we can pay someone a salary, or we can spend money to go to a different conference." That kind of thing.

[29:41] **Stephanie**: Yeah, it's really interesting. One thing I've been really aware of as we've gotten more financial success is thinking, I don't ever want my perception of money to be warped. When I negotiate I kind of have to go into a different brain. I feel like adopt the mindset toward money that they have. But for me, for my personal finances, I've been really aware of how I can even now live off of a lot less than I've considered normal, and considered the bare minimum, and not losing too much perspective is really important to me on a personal level, which is kind of a different topic, but I'm highly aware of that as I learn about this whole warped view of money that people have.

[30:26] **Henry**: Oh we can go into... I feel like I mentioned this in the other podcast I did with Nadia about money. I have this fear too of, thinking about money obviously will change your perception of it. And I don't want it to go in a certain direction, right? And maybe that's the fear a lot of people have of like... I mean it's weird, you make a lot of money, and suddenly it makes me feel like I care about that only. And my goal isn't money, right? It's something else, but that helps make it happen.

[30:59] **Stephanie**: And for me, I think what I've experienced in my life, is because I used to be very poor, and live off very little, for years, and what I have seen is that it's not that I start to only value money for me, it's that I start the bar for how much I need, and my perception of what it can give me change over time. I had this big wake-up call in San Francisco where I was spending \$4,000 a month on rent. And I was making good money, but it didn't feel like it because of how high all the costs were there, but at the time I knew this. I knew that, that wasn't logical. I knew I was lighting dollar bills on fire. But I had this whole reasoning built up of, "No I need to do this. I need to be here. I need to be in the city." I had this, it was almost... I talked to other people who grew up poor, or had to be poor for a long time, where they take the survival mindset even when they're now making money, and they never lose that survival mindset. And that can make you really out of touch if you're not careful.

[32:18] **Henry**: Yeah, I guess there's both extremes. I feel like that too in I guess a different way where it's like when you do have money, it's you don't want to spend it at all, and I feel like I have to, it's weird, to learn to want to spend money, where before I would just spend all my time. It's like if I have the money I should spend it so I don't have to learn all these other skills like offsetting, or outsourcing, I guess.

[32:46] **Stephanie**: Yeah, and then when you spend it, you have to be real careful. Especially if you're spending it and giving it to other people. You have to be real careful that you don't grow cold or unethical when you do that. I cannot tell you how painful it's been to watch, because I don't have any employees, it's just me and my business partner. And contractors who work with us who run their own businesses. So the contractors are different, because they have a lot more leverage than an employee does. They literally, we're small fry clients to them. So they feel comfortable telling us to shut up, and pay more and stuff. It's different when you're hiring someone who doesn't have that much power, and a lot of people fall into like, "Oh, this is just the way it is, or this is just market rate. Or I'm being fair."

[33:40] **Stephanie**: And you have to realize that hiring... This is kind of a controversial statement, but I do believe that hiring anyone at a lower rate than an equal partner and an equal share of all the money you're making is injustice, and that's why worker's rights will always be in conflict with business owners. And you've got to recognize that. That you essentially are never treating people fairly unless they are truly equal partners. So it's like how you kind of you need to have that humility in my opinion.

[34:18] **Henry**: I guess I feel the same way where it's when we have enough money I probably shouldn't ask other people to be like, "Hey, do you want to join me in doing this full-time open-source thing?" Because there's that risk where it's like, "It's probably not going to work out." And I don't know if I want other people to go through that if they don't want to, right?

[34:37] **Stephanie**: Well that's where analyzing the business aspect can be helpful, because that's a common thing in startups is, well even the startups are known for making the more consistent money than open-source projects. It's still just what you said comes up a lot, because the fact is business is hard and a lot of startups fail. So it's like should I encourage people to do a start up even though they might fail. And I think that's where being realistic about that chance of failure, but also breaking down what worked for you. So it's not just considered all luck. So that you equip them with some tools for success.

[35:18] **Henry**: And yeah, we don't know what that is yet. But I guess that's the point of this podcast.

[35:22] **Stephanie**: That's the point. Is breaking it down and being like, people didn't just... Even the people who don't know why they made a lot of money. They didn't make it out of 100% luck. They probably made it out of some luck, but it wasn't 100%, so how can we learn for the parts that aren't just luck.

[35:44] **Henry**: Yeah, the discussion on money actually reminds me of a conversation we had a while ago I think I mentioned, I think it was the idea that people when they want to give back, you can give to charity, that kind of thing now, or you're like, "Oh, I need to use my money to make a lot of money, and then give it all later." And I guess my fear was if I don't, I guess exercise that ability now that I might forget to do it later.

[36:18] **Stephanie**: I have been thinking about that a lot since we talked about it, and I've been brainstorming with other people about that same idea. I gathered a few interesting thoughts on that. One guy told me about a science fiction story where you enter this pyramid, and it's really cool, you want to explore the pyramid. It's awesome. You're so excite, here's this adventure. But to get through the door you need to solve this math puzzle. You solve it, you go through the next one and there's an even harder math puzzle, and you start to get punished if you don't solve it right. So you start to really be motivated to solve it, because now you're trapped in the pyramid and this is your only way to get out. And the science fiction story goes that eventually the humans that went into these pyramids and started solving these puzzles, by the time they were able to exit the pyramid, they had turned into mutants who were specialized in solving math problems and had lost some of their humanity.

[37:21] **Stephanie**: I think about that when you say stuff like that, because there's first of all the matter that you can give back now, and there's also the matter that you might never be able to reach that magical point where you're comfortable to give back. But there's also the matter of do you want to turn into a mutant while you wait. And you might change so much that you don't want to give back in the way that you used to.

[37:46] **Henry**: Yeah, I think that story is a great depiction of that fear, and I don't think it's a fear that's unfounded at all, because we change all the time, and especially by the environment in ways that we don't even imagine. Especially with technology right? And I think admitting that... Well I guess even admitting we're not as good as we think, and we could potentially get there if we don't do anything is something to be cognizant of.

[38:18] **Stephanie**: I think that I'm seeing this a lot in there is a discussion in giving back that's like, be careful that you don't put the people you're serving, the people you're giving back to, in another category from your friends. Kind of the idea that it's dangerous to be giving back and volunteering, but the people you're volunteering to do not look like the people who are your equal friends, and how that can change someone, and you start to see these people in a different category than you. And that's really dangerous and that influences how much you can give back. And I think part of that is your friend group, or the people you consider equals really influence the way that you think about the world, and we want to think that's not true, but I really think it is.

[39:16] **Henry**: Yeah, it's almost like it might be more of a pity thing versus like, "I'm the same as you, I'm just in a different situation at the moment."

[39:25] **Stephanie**: And also losing touch with what the real issues are, because you can't have those equal conversations. Power dynamics are at play. All kinds of stuff. I saw that first hand the other month. I was at this networking event, and it was mentoring themes, right? So people had badges where some people wore a badge that said they were the mentor, and other people wore a badge saying they were the mentee. It was like a weird psychological experiment. So I for instance got to wear a mentor badge, and we're all labeled. This one woman she was being talked down to as if she was like very new, and very inexperienced. She needed advice on basic job hunting skills and stuff like that. So I was listening to this conversation, but she looked older. So I was like, "This is not matching up." And I talked to her, and she has a PhD in biology, and was a successful biologist for many years, and she just wants to get into code. Like that's it. And so it was like that's a perfect example of someone... And I believe the person who was talking to her, all of their friends were programmers, and they just didn't think like "oh." They don't even think about all the valuable skills that she learned as a biologist and stuff. It was really warped.

[40:49] **Henry**: I guess we have a tendency to do that especially in tech. We're going to save everyone, and we're so smart kind of thing.

[40:55] **Stephanie**: It's like, she probably knows more than you do, you know?

[41:03] **Henry**: Yeah. I guess it just goes back to humility.

[41:05] **Stephanie**: But it's interesting, because if you can use that knowledge to help yourself in business. If you realize that someone's perception of money is really warped you can realize that and put yourself in their shoes just briefly for that negotiation. And just realize that money is worth different things to different people, and influences other respect. For instance if I went back to the me a decade ago, when I didn't have a lot of money and showed them, I'm trying to think of a good example, like a $50.00 backpack. I might have been like, "Oh, that's a good investment." But now, now that I'm making more money, I look at the $50.00 backpack and I'm like, "Okay, that's a mid-range backpack." So it does influence our perception of how much things are worth as well.

[42:00] **Henry**: Right, shaped by all the people around us, because if they all buy \$50.00 backpacks then we'll think it's normal.

[42:06] **Stephanie**: Yeah, exactly. Or they all acquire startups for $10 million so they think it's normal. Or they're used to us spending $10,000 putting a logo on a website, or spending \$1,000. One of these days I want to do a podcast like this where I name numbers. The reason why I'm so hesitant to name real life examples is because it really changes based on the industry, based on what you do, based on how you sell it. So I want people to do the work of talking to people one-on-one who are in similar industries, you're selling, and get those numbers for themselves.

[42:51] **Henry**: Yeah, that would be pretty interesting. I don't know of a lot of podcasts that talk about money that specifically, so.

[42:57] **Stephanie**: Well it's because it's tough. I could tell you a price, and maybe that price will never be.

[43:03] **Henry**: Relevant or-

[43:04] **Stephanie**: Or maybe that price would be interpreted as low respect in your niche. I don't want to tell you what the price. And it's because of that complicated price psychology that we were talking about before.

[43:16] **Henry**: Right, even like you said the internal thing. Where it's like we... I think for a company it's normal for them to spend a lot of money on workshops for people or something, but then with open-source there's no history of it, so then they're like, "I don't even know where to start." Or it's worth nothing I guess, because of history.

[43:35] **Stephanie**: And it's true because some companies might compare it to the budget that they have for contractors. Some companies might compare it to the budget they have for marketing. I have experienced this with selling a product. We sell image compression. And one of the industries we sell to is the game industry, but the game industry isn't really used to buying image compression. There aren't a lot of other proprietary products that sell to them. So what they do is they try to put us in another bucket. They so, "Oh, you're like Lossless compression." We buy a lossless compression code, so you must be similar pricing to them. That happens all the time, and I have to be wary of that to direct them to what bucket to compare me to.

[44:23] **Henry**: And then you have to know what those buckets are I guess.

[44:25] **Stephanie**: So when you're selling, do you want to be compared to an advertising client that puts logos on things? Do you want to be compared to a programmer they hire as a contractor? What do you want to be compared to, and what do they spend money on now? That can help give you a jumping off point.

[44:45] **Henry**: That makes sense, because I have talked to a lot of people and they would say something like they don't have budget in the engineering section, but it's like, "Oh, for marketing it makes sense." And they're willing to spend money there.

[44:59] **Stephanie**: Exactly.

[44:59] **Henry**: Sometimes the marketing budget is bigger than the engineering budget, so.

[45:02] **Stephanie**: Often. Yeah, absolutely. Or just learning the subsets of engineering budgets. For instance, I did a sale to a large company and we were always going to be in an engineering budget. Our particular product will never be in a marketing budget. Maybe. Maybe. Maybe. But there are different sections of engineering, and some engineering departments get more money for middleware than others. So even just within engineering, navigating that, and figuring out who has more budget for you.

[45:36] **Henry**: That makes me think about, it's almost for each company, there's a person that I know in there that can be the person that represents you, and they can help you figure out, oh this works for this department, or anything like that.

[45:52] **Stephanie**: Exactly. And sometimes that's multiple people. But like Indeed, and we might have talked about it last time, in sales it's called the champion. The champion is someone that's genuinely excited about you, and is your internal advocate in the company. And they can help you navigate it. The trouble is if your champion's an engineer, they probably don't know that information, and the worst part is they might think they know it, but it's better to get that straight from someone who actually sees budgets and stuff. I run into that a lot when selling my product. Like the example I gave before. An engineer will basically act like they know the budget, or an engineering manager, and it's like, well you might get some visibility especially if you're a manger, but at the end of the day you don't approve vendor contracts in a lot of companies they wouldn't. I have to treat that very delicately, and be like, I respect that. I respect that you think you have this power, but can I just talk to the business person.

[47:00] **Henry**: I haven't had too much success with that either. I guess, it's just like I happen to know people, and I it's almost like I've been bad at doing cold email type things. I guess I realize, until recently I had a fear of doing that for some reason. I don't know why, but now I'm more willing to just see what happens.

[47:21] **Stephanie**: Yeah, and I still don't do a lot of cold email, but in the case I was mentioning, I would just have to educate them on the process. Can you introduce me to this person. Kind of not cold, but making sure I'm getting the right intros to the right people.

[47:40] **Henry**: I guess in my situation it's a little bit easier that I guess, the people that I'm talking to, they might already follow me on Twitter, or at least they're chatting in some way, because of how we're used.

[47:50] **Stephanie**: For sure. It reminds me of advice given to people looking for jobs on Twitter, is they'll often post like a job tweet. Like, "Hey, I'm looking for work." And some people might respond with, "Oh, that's cool. Tell me a little bit more about these projects." And they don't realize that if they keep up conversations with anyone who replies to the tweet, and build those relationships that could turn into a job. Sometimes people will only respond to someone if they directly have a job for them right now.

[48:22] **Henry**: And then bringing up Twitter, it's I guess I'm still figuring out what to do with that. It's funny. Obviously I can do whatever I want, but I mean that goes back to the whole feeling of feeling bad about posting things, but then going back and thinking, okay, we're all doing marketing, no matter if I don't want to. So I should not just be more intentional, but just realize I'm doing it anyway.

[48:51] **Stephanie**: And also realize that people want to help you. It's not like you're trying to force people to do something they don't want to do. They want to help.

[48:59] **Henry**: Yeah. That makes me feel really good, when I just have this feeling, "Wow, these people actually care a lot about the work that we're working in."

[49:10] **Stephanie**: Exactly. Exactly. I think there is a point where it can be done badly. I think it can be done badly if you're never promoting anyone else but yourself. Even if people want to help you, if you're in a position of power, you're kind of obligated in my opinion, to try to help others as well. And I think it can also be done badly if you're never, ever forming human relationships with people. If it's all just here's how to give me money, and there's no human element to it of gratitude, and kindness, and asking how they're doing and stuff like that.

[49:46] **Henry**: I guess that just has to do with giving. When people help me I just have a natural desire to want to help them anyways.

[49:53] **Stephanie**: Exactly. Exactly. And yeah, that's good, as long as you don't become that kind of sales account that's just like, "You've got to give me money. Here's how to give me money." And never interacting with people, and never helping other people out, then I think it's fine. As humans, we naturally want to help each other, but sales and marketing it's just telling people how they can do that for you. And one thing that's... I can't remember if we talked about this in the last one. It's like the idea that there was this story where an open-source maintainer fixed someone's bug. And the person was like, "Oh my God. I'm so grateful for you. I'm so thankful you fixed this bug for me. How can I help?" And the person was like, "Oh, I have a Patreon." And so the person donated \$20.00 per month for a few months. And in the person's eyes, they were like, "I thanked you appropriately." You told me how to thank you, the Patreon, and I donated some money, in fact I donated more than I usually donate, and I've sufficiently thanked you. And the person ended up feeling violated by that. They were like, "Oh my God. You're only paying me 60 bucks for fixing this bug for you? What an insult." But they never communicated that. It's important to communicate how people can help you.

[51:09] **Henry**: I think that's a great way of putting that. Where it's like, instead of, "I'm desperate. I need money." You say it in terms of this is how you can help me instead of, "I need help." Right?

[51:24] **Stephanie**: Exactly, and it's also, whenever you set a boundary, you're going to be disappointing some people. For instance, the person might of had this set perception of $20.00 is an appropriate amount to help you. They might have had that. So if you say, "No this bug is worth $2,000. If you want to thank me, you would have to donate at least $2,000 and then I'll be happy." The person might be disappointed, but at the end of the day you're going to be holding resentment either way. You're going to be angry at them for only donating $60.00. So it's good to be honest about what you'll genuinely appreciate. And that frees you up to be more loving and more compassionate, because then when people do meet that there's no resentment. You're genuinely appreciative.

[52:18] **Henry**: Right. Then I guess that gets into the whole your actual value versus just doing it for free, because if I guess even paying someone like a tip, and then not doing what people expect is an insult, and you'd rather just do it for free.

[52:35] **Stephanie**: That's a common thing. Yeah. It's price psychology, I don't quite understand super well yet, because I tend to negotiate in the higher numbers with corporations, but that's definitely a thing where it's important that you don't... I was talking to this business person who he commonly gives a lot of advice on social media and stuff, right? And he said that he runs into this thing where people often want to tip him. And he was saying when he gives advice for free, there's kind of this understanding that it's volunteer work, and when someone tips him, there's an understanding that they're compensating him for that. And he says he never want to make people feel like $5.00 is adequate compensation for the kind of advice that he gives. So he either gives it for free, or he gives it for a high price. Because it's just messed up. People start to disrespect him and start to treat him like his advice is worth $5.00. So they tip him $5.00, then they're like, "I want more advice." And he's like, "I don't have time now." So they hand him another $5.00, and they're like, "Now you have time." Like, you know?

[53:53] **Henry**: Even if they didn't think that at first, it's a signal to yourself that, yeah that's what they're worth.

[54:00] **Stephanie**: Yeah, it's weird, human psychology is a very weird thing.

[54:04] **Henry**: And then open-source as a whole, I think most people don't expect to pay anything. So expecting to pay anything now is, we're trying to change that whole cultural expectation.

[54:14] **Stephanie**: Yeah, for sure.

[54:16] **Henry**: Thanks for listening. Check out the website maintaintersanonomous.com for transcripts of each episode. If you have any feedback, topic ideas, or guest suggestions you can reach me on Twitter at left underscore Patton.
