---
title: "MA 15: Philip Gee (#2) on Unlisting Yourself"
season: 2
date: "2020-09-16"
time: "46"
description: "Why would you choose to leave the public internet on your own terms? Philip Gee joins Henry (for the 2nd time) to chat about his recent choice to make a minimal public web presence after being on the web for many years. We discuss the logistics of removing social media (Twitter, Facebook, YouTube), moving to longer forms of media (podcasts, essays, books), making introductory content, recognizing different stages of your career, being out of touch, freeing your mind for the next thing, not being ashamed of previous work, taking time to reflect, and friction. (recorded in May)"
episodeLink: "f86069d0"
embedUrl: https://share.transistor.fm/e/38a62493
sidebar:
    order: 15
---

### Links

- [3: Life After Digital Death)(https://hopeinsource.com/digital-death)
- [1: Growing Old with the Web](https://hopeinsource.com/growing-old)

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-2/unlisting.md)

[00:00] **Henry**: The last time we chatted for the podcast, we were just talking about whatever and to see what happens.

[00:05] **Philip**: It was randomness and it was also this theme of growing old on the web, right.

[00:09] **Philip**: I made my first webpage at 97. I mean, it wasn't anything amazing. So it was weird that I'm in that generation where as a kid I've made the early webpages.

[00:18] **Philip**: I wasn't around the beginning of the internet or beginning of computing. I'm not that old. But you know, I'm old enough in web years.

#### "He took everything down!"

[00:24] **Philip**: It's ironic that this conversation may lead to me trying to get off the web.

[00:29] **Henry**: So I asked my friend Shawn, to be on the podcast. He listened to a bunch of them and then found you. And he pinged me. He was like, Hey, he's gone from everything.

[00:40] **Philip**: Yeah, I was at this virtual academic conference, cause all the Covid stuff. The cool thing about online is that you can watch the talks and there's the kind of back channel chatter, right? There's the chats.

[00:50] **Philip**: And then some people just private chat you on zoom or something? And it was hilarious cause yesterday someone was like, Oh yeah, I recognize you. You have these blog posts about research and grad school, whatever. And then YouTube videos.

[01:02] **Philip**: Then I'm like, yeah, funny, you mentioned that. I'm trying to totally get off and you can just join my newsletter if you want any updates.

[01:07] **Philip**: So it's ironic that timing all happened now.

[01:11] **Henry**: Yeah. You mentioned this in the video, it's not like a sudden thing. You've been thinking about this for a while anyway, right.

[01:17] **Philip**: Yeah. I mean, the only YouTube video on my channel is..

[01:21] **Philip**: It's like the stereotypical thing where people quit YouTube. It wasn't even meant as clickbait, but I didn't explain anything. It wasn't like a long video. I needed a placeholder there, just so people don't freak out that my channel is gone, right. They think I like freaked out.

[01:36] **Philip**: And then I just basically linked to my newsletter and decided, if you really want more content like this, just subscribe. I'm trying to play with this more private format.

#### A Long Time Coming

[01:44] **Philip**: So, yeah it was coming for a while.

[01:48] **Philip**: I think the start of it was really maybe in February, so life in the US was pretty normal? This is before the COVID stuff, the US quarantines and lockdowns.

[01:58] **Philip**: And I just decided all of a sudden when I got up one morning or the weekend, just to delete Facebook and to delete Twitter as much as I could.

[02:06] **Philip**: I used this thing called Tweet Delete. I just payed \$10 for it, seemed good, to just delete all my tweets and I unfollowed everybody. So my account was basically inactive.

[02:15] **Philip**: I still wanted to keep Twitter because I had a good amount of followers. I had a verified account. And just for DMS and stuff in case people want to reach me.

[02:24] **Philip**: So I kept that around, but Facebook, I just completely deleted cause I hadn't really been using Facebook for many years anyway. I just kind of lurked on there, but I didn't actively participate.

[02:32] **Philip**: And then I think it deleted LinkedIn also, which I didn't really use. It was just kind of there.

[02:37] **Philip**: So that was kind of the start of the end. I mean that was February this year, and even before, maybe a year or two before, I decided to not have anything on my phone.

[02:47] **Philip**: So I try to get email off my phone and social media.

[02:52] **Philip**: I actually never bothered to install the Facebook app. Public social media, it was just Twitter on the phone, but that's already pretty addictive because it's public, it's pretty engaging.

[03:00] **Philip**: If you're on the phone, you just check it a lot and reply to people and post stuff. So I got that off my phone a few years ago, so that, you know, was already one half there.

[03:11] **Philip**: And then I tried to like, get email off my phone unsuccessfully. I've tried to hide the app or not have an email app and just use the browser. And then I would just always find myself clicking the browser, clicking on Gmail or whatever.

[03:23] **Philip**: So just not using social media or posting stuff on mobile already kind of slowed things down a lot.

[03:30] **Philip**: And then I decided to go more cold Turkey in February.

[03:33] **Philip**: And then just this month, a week ago, I decided just to delete Twitter completely.

[03:38] **Philip**: So they give you up to a year. So you can deactivate your account. So if you log in within a year, they can reactivate it. So that's nice.

[03:46] **Philip**: It also means no one takes my screenname over a year or whatever.

[03:50] **Philip**: So then I'm totally off. And then I think I went through Google just for my name and I just found random accounts that I had that I never used.

[03:58] **Philip**: Quora, I had a few posts. I had a Medium thing. I had a few videos on Vimeo, so I just deleted them. Cause I had a backed up anyways.

[04:06] **Philip**: I was not that active in any of them, but it was just nice to clean them.

#### Erasure: a minimal public web presence

[04:09] **Philip**: So basically I wanted to make it so that my public web presence was just minimal. And I think the biggest thing that we can talk about, beyond just YouTube, which I had like hundreds of videos out, was just my website, which had hundreds of articles.

[04:24] **Philip**: And I decided to basically get rid of them.

[04:26] **Philip**: So now my website is just one page. My publications and my professional info. It's like very vestigial.

[04:32] **Philip**: It has some links to like FAQs, so the articles kind of live on in some ways.

[04:37] **Philip**: The interesting thing is that because I've been accumulating all this stuff on the web for decades, there's sort of a responsibility in a way not to just ditch everything.

[04:45] **Philip**: It's kinda like if you just like pulled all your code offline. Yeah you could do that, but that's kind of like an asshole move if people were relying on it.

[04:51] **Henry**: Well, that's funny. Cause that actually..

[04:53] **Philip**: That happened. Yeah.

[04:54] **Henry**: That is left-pad!

[04:55] **Philip**: Yeah. Like the left-pad of the web!

[04:57] **Philip**: What I did was, on Google analytics, I just saw the articles that people were reading the most because they probably linked to it, right. And also videos, not as much.

[05:06] **Philip**: So most of those things we're advice about grad school and those things from Googling around. So I kept those online.

[05:13] **Philip**: But I had like a disclaimer at the top that says like, don't link to it, because this is just an archive, right.

[05:19] **Philip**: Basically an archive. I just kept the selected few there just so it wouldn't break people's links.

[05:24] **Philip**: But most things I took down.

[05:26] **Philip**: I felt pretty good about th 90/10 rule. Like that 10% of stuff, I'll keep those up and it's fine.

[05:31] **Philip**: I just won't link to them in the future, but it's sort of like my own internet archive in a sense, right. So it's the same URL. You can see the page. But it says this, this archive is not being updated. It's like, disclaimer.

[05:43] **Philip**: Of course the Internet Archive, it crawls everything.

[05:46] **Philip**: So if people really want it, they could go to the internet archive and look at my websites.

[05:50] **Philip**: That's fine. Like I'm okay with that. I'm not like I'm not trying to like erase myself completely, right.

[05:55] **Philip**: Because in practical terms, there's internet archive and there's other caches and people might take snippets of your articles.

[06:02] **Philip**: I mean, you obviously can't control stuff you put out, but to the greatest extent possible, I felt like that was like a reasonable design.

[06:11] **Philip**: And we can go to the details, but that's like the nuts and bolts of it. I guess from here on out at this point, I would not want to write new stuff as much publicly.

[06:21] **Philip**: But for the old stuff, I basically took as much of a down as possible. And then I kept the links alive for the most popular ones.

#### Unlisting Yourself

[06:29] **Philip**: So like the YouTube videos, for example. The reason why they were watched is probably because there's links to it from somewhere else, right.

[06:35] **Philip**: And it's not that people are organically discovering it. They're linked from resource pages or advice pages from other people.

[06:40] **Philip**: So I kept all those as unlisted so that when people find it it's there, but it doesn't show up on YouTube searches.

[06:45] **Philip**: So if you search for me on YouTube, none of my videos show up. There are conference talks I give, and that's fine. It's other people's videos. That's totally okay. But yeah, that's sort of the nuts and bolts of it.

[06:55] **Henry**: That's really interesting. I was going to bring that up. Essentially, you're just making all your stuff unlisted. Like if someone else found it or knows about it, they can see it, but you're not going to actively tell people, here look at my stuff.

[07:08] **Philip**: I think that's a good way to put it.

[07:09] **Philip**: Some stuff is down, right? Some stuff is private or they're deleted essentially, right.

[07:15] **Philip**: But the stuff that has been viewed the most that I want to keep up, they're basically unlisted.

[07:19] **Philip**: And also like the pages themselves, I put no index, so that in theory, the search engines would not crawl or make snippets of it.

[07:26] **Philip**: So it's not discoverable by new people, but if old people already have links to it, it's fine.

[07:31] **Philip**: It's not like they're secrets or anything.

[07:34] **Henry**: Yeah. I think that's a like important distinction because I feel like the first question that people are going to ask is just why.

[07:40] **Henry**: But it's just not what you might initially think of. I don't want to get rid of my presence on the internet, but I don't want to introduce new things, but the things that are already there, I don't want it to break.

[07:52] **Henry**: Also if you really want to dig into it, letting them.. In a way you kind of have to, because it's already on the archive.

[07:59] **Henry**: So you're not gonna like, make it harder for people that really want to know who you are.

[08:04] **Henry**: Which I think is good because those people are putting in the time to want to look into it. So it's like, I guess, go ahead.

[08:09] **Philip**: Really good or really bad.

[08:11] **Henry**: Right. It can be bad too.

[08:12] **Philip**: The people who are the most bad or the most good.

[08:14] **Philip**: Yeah. I mean, this is all good brainstorming.

[08:16] **Philip**: I talked to Nadia about this, kind of. I actually talked to her right before I did all the deletion and that episode hasn't aired yet.

[08:24] **Philip**: And I'll have to think about how do I air these episodes now that I don't have anything.

[08:26] **Philip**: I mean, I think what I do is on my homepage, I still list the podcasts.

[08:30] **Philip**: Because that's something I still want to share. I just list them so that people can direct click on them. And then if you want to share, it's fine. It's totally okay.

[08:37] **Philip**: So what I'm saying is we have one model.

[08:39] **Philip**: I mean, this whole brainstorming is good for me now. Cause I want to write this up in a newsletter of like, what is the whole point of this? So you're helping me brainstorm.

#### When I was young, I was in a rock band

[08:47] **Philip**: I guess one thing is like, there was a moment in time, not moment, a phase I had in my life, right? Like, let's say the past decade, right?

[08:55] **Philip**: I've been more visible online. I've done more stuff openly online.

[08:58] **Philip**: It's definitely helped me. Both personally and creatively, and also for my career.

[09:03] **Philip**: Probably a lot of that resonated you too, that like being a bit more public online. That helped you form your early career and mine as well.

[09:11] **Philip**: But now I'm at a farther along point in my career in life.

[09:15] **Philip**: I'm like, okay, that was a good phase. But I don't really quote unquote, need it going forward.

[09:19] **Philip**: The way to think about it is if in five years time, 10 years, whatever, the new generation of people coming up in computer science or in academia or in whatever, in my field, if they don't know me for anything that I do online, cause I haven't done anything. That's fine.

[09:34] **Philip**: I'm just a random person and that's totally fine. They might have happened to find some old stuff. Oh yeah. That's cool. Like I'm not ashamed of it, right. I'm not denying it.

[09:42] **Philip**: But going forward it's okay if people just see I have a simple webpage. Just like all professors do, they just have their professional info? Oh yeah. I'm just like another guy who just does research and teaches and has some papers.

[09:53] **Philip**: Cool. I'm totally cool with that, you know? But I had that phase where I did that.

[09:58] **Philip**: It's like, Oh yeah. When I was young, I was in a rock band for like 10 years and now I'm an accountant or something.

[10:03] **Henry**: Yeah. You're talking about this transition and even thinking of that is I could say mature in a way where it's like, you understand that there are phases in life. Nothing is forever.

#### Naturally Transitioning Out

[10:13] **Henry**: And it's good for us as we grow older or time passes by to understand where are we and what do we want? And I think it's good that you're like thinking that.

[10:23] **Henry**: A lot of us just go with the flow, or just what you're used to, or what everyone else does.

[10:28] **Philip**: Yeah. You know, there are things that are like good forcing functions, right? Barring a forcing function for anything, some people just transition out of it right.

[10:37] **Philip**: For example, use is a good example, right? There was no real turning point or anything. I started on Facebook very early, right. Cause I'm of the age where it started in my junior year of college and February, 2004 was when it started Harvard and MIT.

[10:53] **Philip**: I got my account in November, 2004, which was less than a year after it was out when it started spreading to the Northeast colleges and stuff. So that was the start of my senior year of college.

[11:04] **Philip**: Throughout college and grad school, more and more people are on it. And it was very active, right. We're all students, it was very active. And it was the place to be. And then eventually when people graduated, got jobs, had kids, started families, it became less active, right. At least for my crowd.

[11:19] **Philip**: Of course people use it a lot, right. I mean, parents use it to share pictures of kids, extended family, blah, blah. I mean obviously billions of people use it. But so for my kind of peer group, we just kind of gradually leveled out of it and didn't use it as much.

[11:31] **Philip**: And it made sense to just delete it or if I didn't do it, it's fine. It didn't have a noticeable impact on my life. So it kind of gradually went out.

[11:40] **Philip**: There are other things that have a more discreet thing. So for example, if something really bad happens to you online, then that might be a cause for like, okay, I got to like quit this or whatever, right.

[11:50] **Philip**: In all sorts of settings, so I never really had one of those.

[11:54] **Philip**: But then, like you were kind of alluding to, if you don't have a sudden event, then you could just kind of drag on with the status quo for awhile. Is this really what I want? I don't know, but let's just keep going.

[12:04] **Philip**: So I decided that, I feel like this was a good time, I guess, by the time we air this or whatever.

[12:10] **Philip**: So I've been now on this career path for six years, right, as an assistant professor.

#### Tenure as a forcing function

[12:16] **Philip**: So recently, I mean, it's not public yet until July. But I recently got tenure, which is very good.

[12:22] **Philip**: Thank you. Officially happens July 1st. So I felt like that was a good milestone, right? Okay. This is a new career phase. And I want to think about not just starting from scratch. I still have my same job.

[12:34] **Philip**: But I feel like, there was a very discrete point here that I'm like, let's just reboot. And let's just clear this out.

[12:41] **Philip**: Not that there's any like, correlation between that and deleting my website, but this is a good check point in my career.

[12:47] **Philip**: And it means that I'm more established now my career. I don't necessarily need to publicize or do the public stuff as much. Not that I actually needed to, but I think you get what I mean.

#### High School Debut

[12:56] **Philip**: It's a good excuse or a forcing function and be like, okay, let's reevaluate what I want for the next phase of my life or career.

[13:03] **Henry**: It sort of reminds me of when, you know, people go from middle school to high school or high school to college.

[13:09] **Henry**: There's a phrase where like they changed what they wear or their personality. Cause they want to restart. You know, in a way we're all doing that.

[13:16] **Philip**: That's a big one, from high school to college. Cause you're literally moving and these people are new.

[13:20] **Philip**: That's actually a pretty good analogy. Or when you graduate college, you start your first job. Like these really discreet things.

[13:26] **Philip**: I mean, I guess the other thing that's related now that I'm also getting a bit older, too.

[13:30] **Philip**: So with tenure and with me being in my late thirties now. I guess the way to think about it, is this thought experiment for like, how much longer do I keep going forward in that sense, right?

[13:38] **Philip**: Do I just keep doing videos, web stuff, social media stuff?

[13:42] **Philip**: It's fine. I mean, people can do it if, if they keep doing it.

#### Out of Touch

[13:45] **Philip**: But I just felt like I was gradually getting more and more out of tune with kind of the zeitgeist and what stuff was going on. Then you just start becoming more out of touch like an old person and trying to keep up online and stuff.

[13:58] **Philip**: How much longer do you keep going for, right?

[13:59] **Philip**: Am I going to be like 70 and like tweeting with 20 year olds and stuff. And like trying to keep up with the latest memes. I don't see myself doing that.

[14:07] **Philip**: So then it's like, all right, I'm going to extrapolate to 70. Okay, I'm not going to be like posting social media at 70. Do I do that age 60? No, probably not. At age 50? I don't know. Sometime you gotta stop doing that.

[14:19] **Philip**: So I decided, okay, why don't I just stop right now?

[14:23] **Henry**: That is fascinating, because I'm sure there are people that are like, no, I'm going to be doing this forever. You know, like sort of like, this is my career or this is my thing, you know?

[14:33] **Henry**: I don't know, maybe, yeah, we don't really want to change.

[14:36] **Henry**: It's hard for us to think what we're going to be like in X years.

[14:41] **Henry**: I was reminded of a quote where when you're 30, you look at your 20 year old self and you're like, wow, that person is really dumb. But you always do that. Whenever you go to 40 and you're like, Oh, my 30 year old self is dumb. But you never say like, Oh, that means I'm always dumb. It's in retrospect and you don't really know like how you change.

[14:57] **Henry**: I guess it's kind of interesting that you can anticipate like, okay, I don't know if I want to continue doing this, but I mean, some people probably still enjoy, you know, all that stuff you're talking about then obviously that's fine.

[15:10] **Philip**: It's everyone's personal decision. Yeah. I'm not saying that there's no age limit or anything.

#### Ownership Over Our (Digital) Selves

[15:14] **Philip**: I guess just like for myself, it's like during every phase of life you want to maybe present yourself in a certain way, right.

[15:21] **Philip**: And I mean, people talk about this a lot with, if you've been on the web or on the internet for a long time, there is this context collapse issue of stuff you wrote 10, 20 years ago, on some random forum.

[15:32] **Philip**: That's obviously not you today.

[15:33] **Philip**: But it may be embarrassing, or you may not want that to be representative. Even if people know it's from 10 years ago, it's just kind of weird and stuff. Not that I had anything that weird, but that does catch up with you, right. That if your whole life is archived online or whatever. So it's a personal decision, right?

[15:52] **Henry**: I'm actually reminded of a story.

[15:53] **Henry**: I did meet someone randomly. And this is more of content other people put about you.

[15:58] **Henry**: So I don't want to describe what happened, but essentially some organization posted something about them and they agreed to it.

[16:05] **Henry**: And it's not like bad stuff. It's just about their life. It's personal, right.

[16:09] **Henry**: And then eventually a few years later, you're like, I don't know if I want that on there.

[16:14] **Henry**: And you ask them, can you take it down? They're like, well it's ours now.

[16:17] **Henry**: And they didn't do anything bad, they just don't want that there. And you can't do anything. You don't own the content anymore. That sucks.

[16:24] **Philip**: I mean, fortunately so far, right knock on wood, most of the stuff I do is posted on my own sites and properties.

[16:31] **Philip**: So I can take that down, right.

[16:32] **Philip**: So if you search for me, there's like interviews and other stuff from other people, but that's fine. I guess I don't have any super old content that's owned by other people. Maybe it's just a sign of the times, right? Like I didn't grow up during that time where there was a lot of content created by others.

[16:47] **Philip**: And I guess a thing that was a pleasant surprise is how relatively easy it's been for me to pull down stuff, actually.

[16:55] **Philip**: So obviously my own website, it's easy. Cause I control it all.

[16:58] **Philip**: On YouTube, they make it pretty easy. You can just bulk private everything. And most good platforms, they make it pretty easy to delete your stuff like in general. That you created right?

[17:07] **Philip**: If someone else, it's their content. You can't tell them to delete stuff, obviously.

[17:11] **Henry**: Yeah, I was going to ask you that.

[17:12] **Henry**: It reminds me of the fact that like, we probably signed up for like hundreds of websites and services all the time and we just forget about them. And even if I don't have data on there, it's more of I don't want to get hacked.

[17:25] **Philip**: So I'm not doing a full digital scrub, right? I mean, this really isn't for like privacy as much, right. The full digital scrub is like every random account you've had. And then they probably sold your thing or the company got acquired, right.

[17:39] **Philip**: You know, really interesting stories are from people who are transgendered, right? They change their gender, so they change their name everywhere online. So I know some people who have done that and people've talked about that.

[17:49] **Philip**: And this goes into this whole issue of name policies and just account information, right? If you change your, you know, not just change your gender, but just changing your name, that's just a general form, right? If you want to change your name for whatever reason, whether it's a gender transition or other identity transitions, you have to change your name everywhere.

[18:07] **Philip**: You know, in legal documents and all your accounts in like, you know, Google. I heard it's really hard to change your Google name or something like that. And some places, make it easier than others, right. And so that's much harder. So for me, it was a very lightweight sort of, I'm just going to take down whatever I can and whatever I can't it's fine.

#### Posting about Quitting

[18:26] **Henry**: Right. I guess it's just going back to what I was saying earlier.

[18:29] **Henry**: It's hard to kind of differentiate between people that want to take everything down versus people like you that are saying, I just don't want to be public in the same way as before, because you don't see a lot of people doing it.

[18:42] **Henry**: I mean you don't broadcast that either.

[18:43] **Philip**: That's by definition. Yeah, I didn't do like the "I'm quitting Facebook, I'm quitting Twitter" on Twitter or Facebook, right?

[18:49] **Henry**: Ironically. Yeah. I think that gets to the heart of that being quiet or I guess, silent on social media, it doesn't work because inherently it's about posting. So it is weird to say like, I'm going to be quiet, I'm going to quit Twitter on Twitter.

[19:04] **Philip**: Yeah. It almost seems like you're attracting attention to yourself in that way, right?

[19:08] **Philip**: I mean, that's fine. I mean, people have quit Facebook before me and they post a rant about it, which is fine. I mean, that's like understandable or they're like, here's my email info, right?

[19:17] **Philip**: They just do one final post, you know, you should email me if you want to, get in touch, but I'm not going to check anymore.

[19:22] **Philip**: That has been a trend too, right. I mean, in recent years.

[19:25] **Henry**: Right. Especially now.

[19:26] **Philip**: Especially now. But you know, all throughout the last five years, you know, there's kind of a getting off of Facebook or social media sort of thing.

#### No One's Going to Cry

[19:34] **Philip**: But I mean, another thing is I'm looking through some of my YouTube videos and articles. The technical stuff I post, right. Like I have these programming tutorials.

[19:42] **Philip**: One is that they get old right. I mean, technical stuff gets old, right. They kind of get stale and outdated.

[19:47] **Philip**: And the other one is that there's so much stuff out there now tech wise, that I don't really feel like much is lost if my videos are not there because I'm not like making a career being a tech YouTuber or whatever, right. So it's like, it's fine.

[20:00] **Philip**: A lot of these videos I made early on when I was teaching, right. It's like, Oh, I would make a good tutorial. It's nothing like spectacular, but people watched it. I just put it online and they searched for it. And I just used it; I embedded in my class notes and stuff. And it's like now five, 10 years have passed and there are so many resources online for programming. If they're missing my few articles or videos, no one's going to cry. They'll find some other ones.

#### Making Introductory Content

[20:24] **Henry**: Yeah, it's interesting cause like that's an argument for people to not make YouTube videos because they think there's so many. But that's when they're getting started.

[20:32] **Philip**: Yeah. I mean, that's a distinction we talked about that like, I think that the stuff I would suggest for someone to get started is very different than someone like me who's been doing it for a long time, right.

[20:42] **Philip**: So another reason that I guess I don't care as much anymore about this is that I don't really care as much about making quote unquote introductory content anymore, right. Because I've seen so much of it. I've done so much of it.

[20:54] **Philip**: But, you know, my suggestion for people who want to get into tech blogging or YouTube again, or live streaming, whatever, it's fine to do introductory stuff, right?

[21:01] **Philip**: You have this whole like dev.to network where people mostly write introductory posts. Here's how you use pandas and Python.

[21:07] **Philip**: A lot of it is just getting practice. I'm learning, I'm excited about this. I want to share these lessons and they're very introductory for the most part.

[21:15] **Philip**: But I've encouraged people to do that because it is a form of creative expression and getting your thoughts out there.

[21:21] **Philip**: And if you're a beginner, by definition, your stuff is gonna be introductory. And that's fine. I don't want to discourage people from making stuff. I want to be very clear about that.

[21:29] **Philip**: I don't want to be like, Oh, don't make introductory stuff, cause there's so much of it.

[21:33] **Henry**: Yeah, I guess the caveat with all this is like, you're from the point of view saying I've been doing this for awhile, I'm in a different place now.

#### More Beginners in a Growing Field

[21:40] **Henry**: The other point about introductory content is that, as time goes on, there's going to be more and more new people to whatever it is, right.

[21:47] **Henry**: And so it's actually more, it's necessary for people to make new content and introductory content because the amount of people that have had X years experience gets smaller as the total pool of people in programming or whatever it is, right.

[22:03] **Philip**: Yeah. I think this dovetails really well with traditional computer science education, right? So a lot of the online textbooks, or even my Python tutor site and stuff, textbooks and courses, MOOCs, online courses, youTube videos, resources. The majority of those are aimed at beginners, right? Just getting started, kind of CS 1 sort of beginners.

[22:23] **Philip**: And if you want to have the most impact, that's what you do. Because like you're saying, by definition, most people are beginners. There's always new beginners every year learning. And then, you know, if the field is growing, then the number of beginners keeps growing.

[22:37] **Philip**: If you want to just have impact numbers wise, that's the most bang for the buck.

[22:42] **Philip**: But then I just, I don't find it as interesting. I've been offered, can you do like an introductory Python online course and I'm like, there's a bunch of other people doing that. It's great.

[22:50] **Philip**: But I don't feel like the n+1th version would be that great for the world, right.

[22:55] **Philip**: Whereas I have been thinking about for the Python tutor site. What I can do that's unique to my site or that I could provide value that's unique, I would be more motivated by, right. Even if it doesn't impact as many people, right.

[23:06] **Philip**: If you really want to impact the most people, you write a very introductory guide.

[23:10] **Henry**: Yeah. Not even like quality and quantity, but more like depth and like surface level.

#### The Business of Patrons

[23:15] **Henry**: This is similar to your approach I think of taking most of the stuff off versus with the newsletter.

[23:20] **Henry**: Even though I'm still on social media, I'm definitely posting a lot less just feeling the same thing as you. Maybe not for the same reasons. I don't even know. I just don't feel like, I want to engage as much as well.

[23:32] **Henry**: I don't want to post every week, donate to my Patreon. If you look at the graphs, which isn't public, it's only going down like every month or week another person stops donating, right.

[23:44] **Philip**: If you don't do anything, it just kind of trickles down.

[23:46] **Henry**: Which I haven't. So I kinda just leave it there. So like the first month it was like really high. And since the last two years, it just keeps slowly going.

[23:54] **Philip**: Because you haven't actively cultivated it.

[23:57] **Henry**: I don't expect anyone to continue donating for X years. If they even decided to do it at all, that's like awesome. Like the fact that someone even bothered to sign up and do all that is good.

[24:08] **Henry**: But if new people are following you and they don't know about your Patreon, like how do you do that? But I just don't want to do that cause to me it doesn't feel genuine.

[24:15] **Henry**: Even though another point is that everything we do is marketing.

[24:19] **Henry**: So, I kind of want people that really care about what I'm doing to support me. If they sorta know who I am, it's fine if they don't support.

[24:27] **Philip**: No, I totally get what you mean. It's like, I'm almost jealous in a sense of people who are unabashedly capitalistic, right? So I know people who literally their goal is to run a business, right?

[24:36] **Philip**: So they have a business newsletter. And it's like all the business hacks you have, growth marketing hacks, just like subscribe to this thing and it's just full on whatever latest research in click bait science, right. It's because that's their consulting business.

[24:49] **Philip**: I mean, you've talked a lot about this in many podcasts and talks and stuff. This sort of open source citizenship kind of, doing stuff out of altruism and a willingness to share.

[25:01] **Philip**: And I think a lot of stuff I do just in writing and videos, it's the same kind of ethos of, I'm not expecting to make a living off of it.

[25:08] **Philip**: But like there's this ethos so that it does feel a bit weird to be thinking about marketing hacks for doing an AB test of like different kinds of Patreon messages and stuff, right. Whereas if you're full on an entrepreneur building your online business, then you just go full on doing AB tests at different kinds of sponsorship.

#### Doing the Work vs. Funding It

[25:26] **Philip**: But since you're not full on that does feel a bit weird, but on the other hand you have to make a living too. So it's a hard balance.

[25:32] **Henry**: Yeah. I think you have to have a balance because you'd be kidding yourself. You're like, Oh, I'm just going to do my work. That's naive that you could just assume that people are going to support you just because you're doing good work.

[25:42] **Henry**: I mean, we all know that cause of marketing, the whole industry, but you don't want to turn into a marketing person if you don't want that. I keep saying that the more I think about marketing and money, the more I focus on it. And then eventually I'm not even doing the work I wanted to.

[25:56] **Philip**: Yeah, no, that's huge. That's the kind of old Paul Graham I saved, The Top Thing in Your Mind, right? The top thought in your head.

[26:02] **Philip**: He was talking in the context of early stage startup founders, right. If you're just two people hacking away, anytime you think about fundraising is time you're not thinking about building your product, right? So when money is on the back of your head, it easily creeps up to that you're staying up at night dreaming about like, Oh yeah, what if I do this thing for fundraising or whatever.

[26:22] **Philip**: I think it's very similar in many fields, right. That just the core creative work you want to do, whether that's code or writing or videos, or even a product you're making.

[26:31] **Philip**: Then there's the other stuff around it that's needed, I mean, funding is the main thing to sustain that. And how do you balance that creative thing with trying to keep making a living, which is hard.

[26:43] **Henry**: Yeah. And I feel that now. If you make money, you might need to spend money to get other people to do it the things that you might not want to do, that they want to do. That's a whole other skill.

[26:53] **Henry**: And this is probably why a lot of people, once they get their company bought or it gets bigger, they actually quit because they want to do the startup.

[26:59] **Philip**: Yeah, that's a lot of dreams for people in that path, right. Of achieving that financial independence of getting that one time windfall.

[27:06] **Philip**: It's not, you're just sitting on your butt, right. You're probably going to start another company, or do some philanthropy, or do some angel investing or something, but it's this idea that you've kind of made it in a sense, right?

#### Staying or Stepping Away

[27:14] **Philip**: Once you're over that hump, you don't need to worry about money as much so that then you have that freedom to think about the next thing.

[27:21] **Philip**: Or some people would just keep riding. I mean, Mark Zuckerberg is still riding, right. He could of left at anytime. I'm sure his days are pretty stressful, but it's his thing, right?

[27:28] **Philip**: All these tech companies. I mean, same thing with Jeff Bezos and Amazon, right? It's one person's thing that they carried through all these years. It's their legacy. So they're probably not going to quit, right.

[27:39] **Philip**: I mean Bill Gates left, right. That's another great analogy. He left in like 2000, at the height of his. I mean, honestly he was mired in all this antitrust stuff. Facebook's the same way, they're under all the scrutiny for everything. So like the bill Gates model being willing to step away, even though it's your company and your child, right.

[27:57] **Henry**: Yeah, it kind of reminds me. Nadia talks about this a lot, how open source and business relates to just content in general.

#### Seinfeld and Ending at the Top

[28:04] **Henry**: One example I think of is Ninja, the Twitch streamer, right? When I was reading an article about him, how he's making, I don't even know, millions or whatever a month. But he still works a really.

[28:15] **Philip**: He's still grinds.

[28:16] **Henry**: It's a momentum thing, inertia, where it's like, you don't want that thing to stop. And you know that once you stop, you're going to be irrelevant. So it's still stress filled, even though you're making like millions of dollars, and you can't not do it. So he doesn't take vacations and he works like, however, eight hours a day, just streaming.

[28:33] **Philip**: Yeah. I think Nadia had also talked about this. We just made all these comparisons to celebrities.

[28:37] **Philip**: So Jerry Seinfeld, when he had his show in the nineties, where it was like the most successful sitcom in the nineties, right. And it was eight seasons, I think.

[28:44] **Philip**: And they decided to quit after eight seasons, even though they were on top. Or they quit number one, right. They were the number one show and NBC offered them bazillions of dollars to come back, right. But they just felt like, creatively, eight seasons, they were pretty spent.

[28:57] **Philip**: Toward the end, they were like, it's fine. But if we try to squeeze out a ninth season or whatever season, we just know that the writing won't be as good.

[29:05] **Philip**: We've already played out all these ideas, so many times. We could do it and we'll just make a ton more money, but we already have enough money and let's just quit while we're on top.

#### Freeing Your Mind for the Next Thing

[29:14] **Philip**: And the other thing about, I just thought of this morning. Kind of quitting in that point, when you're on top is. Also frees up your mind for the next thing, right?

[29:21] **Philip**: They've all had, I guess, except for Kramer who had the whole racist rant controversy, they've all had successful careers afterwards, right? Their own different shows afterwards.

[29:31] **Philip**: If they just kept trying to ride Seinfeld for a bit longer, maybe they would have not thought about these opportunities. They would've been kind of washed up old stars. Oh yeah. I had this great show in the nineties, I haven't done anything.

[29:41] **Philip**: But by just kind of quitting you just free up your mind. Larry David did Curb Your Enthusiasm. Julia Lou Dreyfus, she did Veep and other shows. They all have thriving careers afterwards. They were known for Seinfeld obviously, but they also had a bunch of stuff afterwards. So I find it that's pretty admirable.

[29:56] **Philip**: Oh yeah this is obviously all very first world and then Ninja thing also, it's all very first world problem, right.They're all wealthy.

[30:02] **Philip**: But it's this idea of: at that stage, it's not really about the money.

[30:06] **Philip**: Are you willing to step away when you're on top? You have all this momentum.

[30:09] **Philip**: Seinfeld in the late nineties, they were on top of the world, right. So that discipline to be like, no, that's enough. Let's let's just think about the next phase. That's really cool.

[30:18] **Henry**: No, that resonates a lot. I think about me quitting my stable Adobe job to do this. It makes sense Nadia would bring this up because she was in VC, and then she went to open source, and then she left open source essentially, right.

[30:30] **Henry**: Knowing when you kind of did everything you wanted to, right, is really hard.

[30:36] **Henry**: It is admirable for people to know, okay, I don't want to be defined by that stuff.

[30:41] **Henry**: It doesn't mean I'm ashamed of it, but there's other things that I want to do in my life. And I think that's good to pursue that.

#### "It's all I've Known"

[30:50] **Philip**: Yeah. The other thing that I have, I have this weird morbid curiosity. Again, I'm getting older now and stuff and a lot of these musicians, right.

[30:57] **Philip**: So, you know, music is obviously another very youth centered.. Media and music. These musicians from the nineties that I was into when I was young, now that we're 10, 20 years removed, there are some that have transitioned gracefully, right?

[31:10] **Philip**: But then there are some aging musicians who like really try to hang on to their youth? And like they're much older now and they're still trying to play the same things and stuff, and it just doesn't feel as good, right.

[31:20] **Philip**: You're no longer 25 years old and just jump around the stage, you're like 45 or 50 and still trying to hang on to that nostalgia. I mean, it's fine. People like it.

[31:29] **Philip**: But I just feel like, it's a lot more admirable, if you can be like, okay, I was in this great rock band in the nineties, we made our money with our thing. That's it. And now I'm doing something else.

[31:39] **Philip**: I'm being a record producer. I'm opening a business. I'm done with that phase of my life.

[31:43] **Philip**: I don't want to be 50 years old and like trying to jump around a stage all night; cause you know, I can't do that anymore.

[31:50] **Philip**: You can see how aging musicians, they want to hold on, right. Because they're like, that's all I've known.

[31:55] **Philip**: Also athletes, right? I mean, athletics is obviously a very physical thing that is inevitable that after those years, you know that you're going to have a decline, but they just want to keep holding on as long as they can. Because that's all they know, right.

[32:09] **Henry**: Wow. Yeah, that's a really good point. I mean, honestly, it just makes me think that to do this, you need a lot of wisdom and discernment into your life and everything. And especially the physical aspects of it, knowing that you're aging. Our bodies are decaying or whatever you want to say.

[32:25] **Henry**: And it sounds bad, but it's like facing reality, essentially.

#### Graceful Degradation

[32:28] **Philip**: Yeah. And, you know, I think people can gracefully transition, right? So musician, for example, I mean, you can obviously stay in the industry, but you evolve your music, you evolve your style.

[32:37] **Philip**: Performing is a very physical thing, right? If you're performing like you are when you're young, it is a very physically demanding thing. I've seen some people transition to being record producers or working with younger artists and shaping the business and stuff. So they can still stay in that industry that they're passionate about, right.

[32:55] **Philip**: Or filmmaking, right. So people who are actors, they transition to being directors or producers and stuff. Media is another one that's like very physical and very youth driven, right. If you're no longer 20, you can't play in those movies, right. Like you gotta find other roles in the industry.

[33:10] **Henry**: Yeah. I guess it does feel like writing is one where a lot of people do that instead, out of all the other things that can be doing, right.

[33:17] **Philip**: Yeah. I mean, you can age well. Actually Nadia had the same conversation.

[33:20] **Philip**: If you're like Stephen King or like a novelist, right? Like it's fine to be older doing that, cause you're behind the scenes, right?

[33:27] **Philip**: It's your writing. It's not your face and your body kind of out there on the line. That's something that you can transition into.

[33:36] **Philip**: Other ones are like medicine, right? So in the medical field, right, you're more respected as a doctor as you get older. You want an older doctor, who's had more operations and procedures rather than someone brand new.

[33:46] **Philip**: But bringing this all back is that, you know, I feel like a lot of creative fields, tech, design research. A lot of that is very youth driven, right?

[33:54] **Philip**: These very new ideas, new frameworks coming out, new tools. It's very youth driven, right? It's has more analog to this media and pop culture industry than it does to being a doctor or writer.

[34:06] **Philip**: I think that everybody who is in a technical field thinks about that, right?

[34:10] **Philip**: Do I move into management? Do I start my own business? Do I continue down this track and stuff.

#### A Time to Reflect

[34:15] **Philip**: Because age catches up with everyone, and it's just such a depressing episode.

[34:18] **Henry**: I can see that, but I don't know. I feel good about it in a way.

[34:21] **Henry**: This pandemic reminds us of our mortality and like that, you know, it is a hundred percent certain that we're going to die at some point. This reminded us that that was true; you forgot about it, right.

[34:33] **Henry**: I think that on the surface, it's really, it sucks.

[34:37] **Henry**: But I think it helps us to question a little bit deeper. Like my roommate. It was so interesting. He kind of messaged me. He's like, we should talk about like heaven.

[34:44] **Henry**: And I was like, woah, why did that come out? And I was like, why did you even think of that? And he was like, because of the time I was just thinking, what is the meaning of life and where are we going? And I was like, that's interesting that that would cause you to think that way.

[34:56] **Philip**: Yeah, the point you brought up is interesting too. In a more normal time, it feels weird to bring that up, right. Cause then people might think, Oh, are you depressed? Is there something really serious going on?

[35:04] **Philip**: You're like, no, no, no, no. It's actually good to think about this. And it's like for someone who is, you know, relatively young and healthy, you don't think about it. I mean, people who are older, obviously think about it. You think about having a will and how they're going to manage their finances when they're gone and stuff and all the practical things.

[35:19] **Philip**: But for someone younger, yeah. We don't think about this stuff, right. Unless, you know, people have some kind of a disease and stuff, which sucks at any age, right.

[35:28] **Henry**: Yeah. I don't have any fatal issues, but I've had chronic issues for a long time. And so the idea of suffering and disease and all this stuff. It does come up a lot.

[35:38] **Henry**: And it is hard to talk about it. Everyone's just talking about like whatever, and then like this serious topic. You don't want to bring it up either, cause you don't want make their day sound bad.

[35:48] **Henry**: And then you get in this own cycle of like, why am I thinking about this and all that? I think. I mean, I'm sure now, everyone's isolated. It's probably a really bad, like just the kinds of things people are thinking about that, but don't feel like they can bring it up to anyone. A lot of mental health issues as a result.

[36:04] **Philip**: Yeah, it just kind of exacerbates things that might have been under the surface that are bearable, you know, it's just the threshold kind of changes, right. Because people are stressed about other stuff as well.

[36:16] **Philip**: I guess that's part of why this whole, like going offline thing is not coincidental either, right? Because this past few months have been stressful on everybody, and it is kind of a time of reflection as well, right?

[36:25] **Philip**: So both my career stage thing, getting tenure, being more senior in my career. And also all the pandemic stuff and current events stuff. A time to think and isolate and reflect and stuff.

[36:36] **Philip**: So it's like, okay, you know, I've been thinking about getting offline more for awhile. Another thing about being online so much; it just takes your brain away from the in person stuff. That's so cliche, right?

[36:45] **Philip**: Obviously, you want to focus more on your loved ones back home and real life relationships, blah, blah, blah.

[36:51] **Philip**: It's true, right. That if you think so much in cyberspace, it's such a nineties term. If you're thinking so much online space, you're not thinking as much in meat space, right?

#### Acting on Our Beliefs

[37:02] **Henry**: It's funny because it is cliche, but then we don't act on it, right. We're still addicted to our social media and then you're actually doing something about it.

[37:10] **Henry**: And you need more examples of people doing that. To feel like it's okay. Now people are bringing up the whole detox, whatever. Then other people are like always online and they think it's fine, you just have to learn to adapt. And it's true.

[37:21] **Henry**: It's cause we don't have, you could say the willpower, but they're designed to get us to stay on there.

[37:27] **Philip**: And it affects everyone differently.

[37:29] **Philip**: I guess a good example of this in real life and meat space is our sugar addiction, right. We all have probably more sugar than we need, and it's kind of a scientific fact. But very few people are going to be like, I'm going to drastically cut down my sugar consumption. Without any problems, right.

[37:42] **Philip**: It's like, okay. I'm like young and healthy. I know it's not the best for me. But it's fine. And if you actually have problems with diabetes and other things, you have to cut down and stuff. So I'm reminded of that, our online diets, right.

[37:55] **Philip**: I'm not saying everyone should cut down. For most people it's fine.

#### Quitting Should be Boring

[37:57] **Philip**: But the other thing that reminded me, that you just said, was that I think that having role models for people who've done this without any sort of crisis, right?

[38:06] **Philip**: You hear about these detox things like, Oh yeah, I'm like addictive gambler or addicted to social media. And it ruined my life. I'm just on social media, 24/7 and arguing with people and like neglecting my job, my relationships. And I got fired because I posted all this stuff on social media. I'm ranting at work.

[38:24] **Philip**: You can imagine the extreme cases, right? Someone has a really serious addiction to social media or online media. And it got them in trouble with their work or their personal life. And it kind of ruined their life. And I'm reforming, cold Turkey, whatever.

[38:38] **Philip**: But for myself and for some other people I know, it's not a crisis moment, but yet we choose to do that. And in a way it's harder to do right, because there is no crisis to do it, right. So I think boring examples, would be good, right. Not a very interesting example.

[38:55] **Henry**: No, that makes so much sense that you put it that way.

#### Intentionality

[38:57] **Henry**: Intentionality is like lacking in almost everything that we have, and that has a lot to do with like habits.

[39:03] **Henry**: And you brought up sugar. Same with like alcohol or coffee,

[39:06] **Philip**: I had a conversation with another podcast guest. We didn't record that one, it was just a conversation. I think this word intentional, she brought up and I think I'll use that in the newsletter.

[39:15] **Philip**: The other thing about putting all this stuff online was that I wasn't very intentional about it, right. It was cool because I could just make videos or write articles or stuff on my mind. It was all like informative and it was all around certain themes, but I would just put us a lot of stuff out there and I didn't really think about a target audience as much.

[39:33] **Philip**: Again, I think it's great for beginners to do this because you know, when you're a beginner producing content, the goal is just volume, right.

[39:39] **Philip**: Just get stuff out there, do stuff and write something every day, every week, make a video, edit some stuff. Just keep cranking as you can get better at it. And I did do a lot of that, which was great for me.

[39:51] **Philip**: But now I think I want to be more intentional about my sharing. In the sense I forced myself to be in this newsletter format, or to email people, or to have these podcasts, these long form conversations.

[40:02] **Philip**: It forces intentionality. So I think, what do I really want out of this episode or this newsletter, who do I want to share this with and why? Right.

[40:12] **Philip**: Whereas before it was just, I'm just going to throw videos over the wall and then some people might find it great. I felt good about doing that in the past. So that word intentional, I think, is really important.

[40:22] **Henry**: Yeah, I think that that does get back to how we all just scroll through our feed. So one of the reasons why you should just post anything you want is because everyone's going to forget about it anyway. So don't feel bad and no one looks at it.

[40:34] **Henry**: In that stage, you're afraid and you just need to build that muscle right. Of just posting.

[40:40] **Henry**: Now it's like, okay, we've trained that muscle. And we need to be intentional about working out or whatever that metaphor means.

[40:47] **Philip**: Yeah. It's turning into an episode where we just compare ourselves to celebrities. I think the one with Nadia, we did the same thing.

#### We Are As Athletes

[40:55] **Philip**: There's that Michael Jordan documentary that was just out, right. If you're going to be good at any sport, right. It starts off with you just playing the sport a lot. You obviously have to be passionate about it.

[41:04] **Philip**: And when you're young, I love playing basketball and just like a really competitive sport, right? You just like play basketball every day with your friends and you go shoot hoops every day.

[41:12] **Philip**: You just do it. Cause you love it.

[41:14] **Philip**: And you don't have a coach, you just are doing it. And then eventually you get kind of decently good at it.

[41:19] **Philip**: Or tennis is a great example, right? You get a coach, and then you get signed. And then it's serious, if you're going to be a professional athlete any domain, right?

[41:27] **Philip**: Like it's serious work. Like their workouts, their diet, their coaching, whole minds and bodies are a hundred percent finely tuned to be the best at that sport, right. It's completely intentional, right. They're not just messing around in their court, right.

[41:40] **Philip**: Because they might injure themselves or they might overexert. They know when the season is, when the most important games are. So they ramp up to that. They have to rest.

[41:47] **Philip**: So I think I'm moving toward more of that. Than like the very beginning, which is great; that's where you have your love for your sport.

[41:54] **Philip**: Or for like software, right. If you're just hacking on software early on, it's important to just play with stuff, right. Make replicas or clones of your favorite projects. Make a Twitter clone. Obviously your Twitter clone isn't production scale, but like just do it. Make an app for your friends just to like do it.

[42:10] **Philip**: But then when you get serious about it, if you want to make a company or you want to do research or innovate on something.

[42:15] **Philip**: You have to be really intentional about what is the value? What is the new thing here? So it's a lot of stuff I threw out there.

[42:22] **Henry**: Like you said it doesn't stop you from doing those kinds of experiments when you're older, it's just that kind of your main thing, you might have a specific goal in mind or something, right?

[42:33] **Philip**: Yeah. And I guess like to kind of wrap off that wrap up the hour, I haven't really thought about a really clear mission statement, whatever yet.

[42:39] **Philip**: But the content I want to produce is going to be longer form, right. So I think these podcasts are great. These long form sorts of thought out things.

[42:47] **Philip**: And also the stuff I want to write would be these PDFs or documents that are non-trivial. The stuff that I want to produce that I just link from my website, there'll be much fewer of them.

[42:56] **Philip**: So for example, right now, I'm working on a thing it's going to be posted to the newsletter. So preview. It's basically a reflection on the past six years working my way toward tenure and stuff.

[43:05] **Philip**: Which is very expected cause I wrote this whole thing about my PhD years ago. So it's not a surprise, but it's like that sort of writing took years to create this passage, right?

[43:14] **Philip**: It's not just some random person just holds on a camera and starts blabbering, right. It took years of experience to distill down these messages. Something that kind of is my voice rather than like, Oh, I'm just going to make a video about this or about that.

[43:26] **Philip**: So moving toward fewer things to produce. Starting anew, but definitely not the kind of tweet style, oh yeah, here's a random observation about this thing.

#### Adding Friction

[43:37] **Henry**: My friend, Chris has a newsletter as well, and he posted this phrase that I liked. He was talking about the idea of friction. And how you're actually introducing friction on purpose, because it causes better intentionality.

[43:50] **Henry**: Versus most apps and websites, they care about engagement, right? They just want you to show up and look at it passively. And I think that's what we want. We want to introduce friction on purpose, even though it seems bad. Like why would you want to make it harder to be able to consume your content?

[44:04] **Philip**: Podcasts are a great example. Someone needs to actually sit there for an hour, or half an hour if they speed it up, at most, right.

[44:10] **Philip**: They need to be dedicated. They can't just be a drive by, I'm just going to skim through this like a passage.

[44:15] **Philip**: So, yeah, that's absolutely right, introducing the friction. I like this analogy he had about the kind of user experience here. It's like apps want to decrease friction and they want to get you engaged and hooked. By definition, consumer apps want to be easy to use, you know, casual games of like, they don't want you to learn a ton because they want you to be able to play and get some value right away and incrementally get value.

[44:36] **Philip**: But for the sorts of stuff I want to write now, or put out there, it's for a very niche audience. It's not for everybody. I think that vibe is absolutely right.

[44:44] **Henry**: Like going deeper, right? I want to make actual connection and relationship. Listening to someone's podcast makes you feel closer just because it's a podcast than just reading a tweet.

[44:53] **Philip**: Yeah. I have these articles that I wrote last summer about communicating fast and slow. It all goes to the friction thing, right? So the most fast forms of communication are social media replies. You know, you're just kind of retweeting and replying to stuff, and it's very superficial, very conversational.

[45:09] **Philip**: And then like the more intentional, slower things are like recording a podcast, writing a long form article. I mean that the slowest is really writing a book, right? Like writing a old school, traditional book that takes you years of research and effort. But when you read that, it's like, wow, that's substantive, right?

[45:24] **Philip**: If you're in that audience and you read someone book and it's good, you're like, okay, clearly they didn't just make random stuff up. They distilled down years of wisdom and deep thought and editing. So I think I want to move more toward that end of the spectrum.

[45:38] **Henry**: Yeah. The phrase, the medium is the message.

[45:40] **Philip**: Yeah, it's funny. Cause like, you know, none of these are new ideas, right. But they're just reinforced today and there's a really concrete example of that.

[45:47] **Philip**: So I'll think about that in the later newsletter updates and stuff, but thanks for helping me brainstorm here that I've been having these thoughts. It just happened like a week ago.

[45:55] **Henry**: Yeah. For sure. This was fun.

[45:57] **Philip**: Cool. This was great.
