---
title: "MA 1: Omnigamer on Speedrunning as Research"
season: 2
date: "2019-04-10"
time: "87"
description: "What's beyond simply beating a video game? Henry is joined by Eric 'Omnigamer' Koziel to chat about speedruning as an optimization problem (code golf), game knowledge as discovery, access as a result of technology, issues of game preservation/archival, coordination issues, obscure/popular games, versioning/patches, and more! (recorded in January. Since then, Eric has a new book out, Speedrun Science)"
episodeLink: 174320ce
embedUrl: https://share.transistor.fm/e/8d4a63a5
sidebar:
    order: 1
---

### Links

- [Speedrun Science](https://www.fangamer.com/products/speedrun-book), Eric's new book
- [Speedrun Perspectives, A Quick Look at Fast Gaming](https://www.youtube.com/watch?v=145EqyR_MYo), Eric's talk at Google
- [Twitch: Omnigamer](https://www.twitch.tv/omnigamer), Eric's Twitch channel

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-2/speedrunning.md)

[00:00] **Henry**: Alright today I have joining with me Omnigamer, he was involved in the early competitive Super Smash Bros community and he’s currently a computer science researcher at MIT. He also just announced the release of a new book on speedrunning called “Speedrun Science.” This is how I found out about him, I watched a talk from the YouTube channel “Talks at Google.” And then personally I’m pretty into video games myself and watching speedruns on Twitch, so it felt like Omni would be the perfect guest to at least talk about how speedrunning and open source and programming are related. Thanks for being on the show with me.

[00:48] **Omnigamer**: Oh it’s my pleasure thanks for having me Henry.

[00:50] **Henry**: So I guess because most of my audience is going to be programmers, they might not understand what speeding running is. Maybe we should start with that. Would you want to maybe go into a high level view of what speedrunning is about?

[01:04] **Omnigamer**: Sure. If you ask most people out there who watch on Twitch who try to do speedruns, it’s simply just playing a game with the intention of beating it as fast as possible. There’s a couple caveats to that, in particular, you set up the rules in advance. Those rules might not necessarily align with let’s say how the game was intentionally developed, what the developers actually wanted you to do with it. So it does involve often times exploiting some variety of glitches oversight, anything that wound up in this final product that shipped as a game.

[01:34] **Omnigamer**: Put another way, it’s that you’re actually treating the game as your medium for doing an optimization problem, where you actually go through the individual steps, try to find the shortest path between from when you hit start all the way up till the end. And by itself it’s a really good challenge not only because it makes you figure out all there is to know about the game, but you really have to be creative to find out what’s this extra way that I can save just a little bit more time or maybe find out how the developers did or didn’t implement something so you can properly exploit it and gain up a couple more advantages that way.

[02:26] **Henry**: Yeah it's really interesting because I think my people might be asking how does speedrunning have anything to do with open source and I think at the very least it has a lot to do with programming, like you said. Actually I just realized that in a way it's kind of like code golfing, where you’re trying to write a piece of code with the smallest amount of code possible and try to optimize that, or optimizing a piece of code to run faster and trying to understand how that whole system works.

[02:55] **Omnigamer**: Right and a lot of times there’s a kind of strict process that I recommend people take when they actually are picking up a game and they are like “Oh I want to speed run this myself.” And it covers this three step process of first you need to understand what the heck the game is, what are its limitations, how does it actually perform different things under the hood. And I mean games are all software, so there’s a formula, an algorithm in there somewhere that controls everything that's going on. And there’s certain steps you can take to reverse engineer that, not necessarily even in the strict debugging sense of literally picking apart machine code and trying to understand that, but actually just playing through using scientific method, that kind of thing, figure out what you need to know and then once you have your tool kit assembled, so to speak, you can go through and actually make the decisions, and that’s what we call routing. So you go through, pick out “I want to take this path”, I need this much resources to be able to perform optimally, that kind of thing.

[04:03] **Omnigamer**: Of course, there’s a human side to that too, where at the end, it's somebody pressing buttons to make this happen. Another way to look at it is that the information that is gained a lot of times is shared over generations. So what starts out as basically looking at a closed product, another way to envision it is that you have a game that’s kind of its own scientific field, where it’s completely unknown at the start, it's a black box, but you can gradually start to pick away and find out what's going on with it, and then as you generate that information you’re basically building up your open knowledge on what’s going on with it. And that contributes from generation to generation of speedrunners, you have different people who will be working on it for long periods of time, doing different contributions, figuring out well hey well this is actually the best way to do it, not that other way.

[04:57] **Omnigamer**: And that starts to contribute to this pool of knowledge that exists hopefully until the game is more or less solved, which at least now there’s very very few games that can claim that mantel.

[05:10] **Henry**: Yeah that’s super cool. Would you want to go into how that came about, was there a time in speedrunning where people didn’t share what they were doing or like how did it become more open over time that people were willing to write down what they were learning. That’s the parallels I see with open source.

[05:37] **Omnigamer**: The biggest motivator there was actually probably just the marches of technology in the early years. So back in the 90’s, speedrunning was really starting to formulate as an idea, but there wasn’t any way to keep organized on it. There wasn’t any way to actually share information on what people were doing, why they would want to play a game this way, and that kind of thing.

[05:53] **Omnigamer**: Some of the first instances of directed and organized speedrunning actually show up in for example in Nintendo Power Magazines. They have certain columns every month that give out players these unique challenges and some of them were speed oriented. So it would be like “hey send us your picture that you completed Super Metroid in such and such a time” and basically that was it, that was the verification, is that you send it in and maybe your name would get listed or maybe it would get lost in the noise, but that was the big impetus for getting started, but all you have is the end result, you get a picture, and you don’t really see the process, so that just shares the basic information. That’s a limitation of the time, you didn’t really have a broad access to information sharing services at that point in time and so on.

[06:59] **Omnigamer**: Not only that but if you’re trying to compete in a space where you only have the end result to show, there’s very little incentive for you to give up any competitive advantages you might have. So people who’ve figured out something really cool, well they didn’t have any incentive to try and share that with other people.

[07:19] **Omnigamer**: And this is something that often came up at another website early on that was big into the scoring community, the arcade side of things, was Twin Galaxies. One of the mentalities there, at least as far as I’ve heard, is that whenever you perform a run, there is a verification that you performed it according to the rules, this was at least far enough out that people could record on VHS and you’d actually send in your tape to be verified by a judge who was hopefully knowledgeable in your particular game. But the only person who would ever get to see that is the judge and whatever goes up on the site is just going to be that end time, that score, that was verified.

[08:06] **Omnigamer**: And again it disincentivizes this information sharing because people don’t know, they don’t have to reveal the things that they did to accomplish something better. One of the big issues there is still that you don’t have all of these different people coming up with different strategies, some of them might be complementary, [pause] they never quite meet. So you’ve got a whole bunch of people that are trying to address the problem of how fast can you beat this game. And they’re not sharing their actual methods, so it kind of is a very slow incremental process, while somebody just enjoys basically sitting at the top, and other people work to catch up or otherwise.

[08:50] **Omnigamer**: It was certainly a closed way of doing things. It wasn’t until well into the 2000s that people started to get access to DVD recorders, they had better access to hosting sites that actually would keep up the videos, that was actually one of the original purposes of SpeedDemosArchive, which was one of the original central hubs for speedrunning.

[09:13] **Omnigamer**: As soon as you actually got to that point of the video is public, the video is your claim that you have beaten the game in this time, that’s a huge amount of information that is shared among anybody else who’d be working on that. Not only that, but you also have peer-review. In the security world, there’s a really big saying “there’s no security through obscurity”. It’s kind of the same thing here. The big point of that saying is simply you can’t really know the flaws in something until it's already out in the open, people have looked at it from all sorts of different angles. And in the same way, let's say you found something really good in the game, and you put out your video, somebody else is welcome to come and find, “you know what, that’s really good, but we can tune it a little more this way and make it even better.”

[10:05] **Omnigamer**: So it becomes a pursuit not necessarily of getting somebody to the top of the ladder, but really who can make the game the best.

[10:34] **Henry**: Yeah that’s really cool. I guess it reminds of open source in general. You can make a proprietary software that does something, but putting it in the open and getting feedback from the community creates a better product. And I guess what you’re saying is that in some ways technology was leading the way for people to be able to verify and all that. Because before if all you had was the score, anybody could have just made that up. And now you have video, and live streams, and all these ways [to verify].

[10:38] **Omnigamer**: Right. The way to kind of condense it down, is that that video artifact, that proof that you performed such a run, also contains all of the information, all of the strategies, all of the thoughts that had gone into the game prior to that point. That’s not to say that there’s all there is, and in fact, some of the most useful details take place on the forums.

[11:11] **Omnigamer**: So at that point, SpeedDemosArchive was basically the lone place that you’d go and discuss new strategies for games. There’s still very few people actually doing runs, but you had active communities that were basically helping each other “hey i found cool thing, if you do this, this, and this, you can get this effect, or I was just playing one day and I fell through the floor.” Things like that, just random reports can really help. The main thing is that by virtue of just being a forum, it's a searchable database of knowledge that sticks around for a long period of time. And that was kind of the hidden blessing of working with forums until probably about the last 5 or 6 years, that kind of fell off.

[11:55] **Omnigamer**: The march of technology can do good and bad things for different scenarios right.

[11:57] **Henry**: Right.

[11:59] **Omnigamer**: In this case, it’s simply that there’s other more convenient ways for people to communicate now. Rather than making an account, jumping on a forum and posting their thoughts, a lot of people will find it easier to make a Discord and that’s going to be the place to go for all of the discussion of this game. And that’s fine, but it really does take a hit to discoverability. Only people basically in the know would know to get to that Discord, or [to] even have lasting records of things that were discussed there is not as straightforward, but such is what it is.

[12:37] **Omnigamer**: I’m sure that there will be solutions to that down the line as we basically go through this cycle of producing knowledge, strategies, skills, all the rest of that, and then gradually having it kind of slip away, as people decentralize.

[12:55] **Henry**: I’m reminded of a similar situation in open source, where you can talk about things on Github issues, but then we end up creating - and this is before Discord, so I guess Slack - and then now a bunch of people are moving to Discord, and then people are complaining that it's not searchable, there’s no SEO, and then people are like “Oh maybe it should go on Slack Overflow” or new things like Spectrum, which is kind of like a forum as well, which actually just got bought by Github. So it's interesting to see how we’re all moving back and forth, what’s convenient, what’s helping new people, and also this idea of archival in general, just making sure the things that we talk about are saved so that people in the future can see the context.

[13:41] **Henry**: Cause I think what you were saying about the video itself is an artifact, but then it's so much more than that. It’d be cool if it could the button inputs in real time, or explaining techniques while it's going along and stuff like that. Just like with open source, it's not just the code, but the decisions behind why certain things happen.

[14:04] **Omnigamer**: There’s also a lot of negative results that are basically are hidden away there. Like if you see a video and they took a decision to go a certain way, there’s nothing basically from that video alone that details well we did all sorts of testing and we found out that going any other way is slower, and by what magnitude. And that’s usually things that do get tested out, but it's not something that will be evident from a video alone. All of those things are really important to basically the next generation for people not producing redundant work.

[14:43] **Omnigamer**: With speedrunning what you see is basically there’s so many runners and so many games out there, but the vast majority of games that are run have maybe one or two people that have worked on them ever. And if those people did not basically spend time to document what they were doing, draw up notes about what they were thinking, there’s scenarios that have happened in the past where basically nobody is able to replicate what they did in a run because they just don't know how. It needs to go through that process all over again from scratch.

[15:19] **Omnigamer**: What's going to happen more and more is basically people do what they want, they get their run and then they move on. And if there’s nothing beyond the run - and in some cases the run might even disappear - that just means that everyone else has to start from square one.

[15:35] **Henry**: Wow that’s super interesting. The idea that this knowledge can get lost because no one is willing to put in the work to write it down. That’s where the maintainer aspect that I see comes in. With open source you have users and maintainers, and I guess in speedrunning - which might be a lot smaller - you have people that run the game, but might not actually do the work to figure out anything, they just kind of learn it and then, I suppose, execute it as much as possible to get the fastest time right. And maybe those people aren’t the ones doing the research all the time.

[16:12] **Omnigamer**: Not necessarily, but everyone kind of has their own sweet spot. One of the things I like about speedrunning is that there are many facets to actually being a successful speedrunner. And what a lot of people don't realize is that you don't have to be at the top of the leaderboards to actually be a major contributor to runs.

[16:33] **Omnigamer**: So I run a lot of obscure games. For me that’s mostly fulfilling because I'm starting from scratch. I go through a game that has not been touched before, nobody actually has worked on anything related to speedrunning of it, and I get to go through and basically figure out the details, what’s going on under the hood, I get to figure out which decisions are best in terms of saving time, and then I get to perform it myself. You can find any mix of people who enjoy one or all of those aspects, but really it's still kind of a proportional thing. It’s a lot of work on one person to be able to cover all the different grounds, but in the same way, if it's not something that they are motivated to do, then it's just not going to happen.

[17:20] **Omnigamer**: A lot of the larger communities, because they are large, there’s going to be people who will pick up the slack, who will go through and do extra documentation. So if you look around, you can find just oodles of information on Super Metroid, on Zelda games, on things that are very popular for speedrunning. That’s well maintained because there is somebody in among the many people who’ve worked on it that saw the value in producing that information and documenting it and keeping it going forward. It falls proportionally with the size of the community, so if you have one person, it's a pretty good chance that they’re not going to be able to or be willing to put in the extra effort to document on top of handling all the other roles.

[18:08] **Henry**: I guess that leads to this question of how, or why are certain communities bigger than others and why do people choose a particular game to speedrun, and also what keeps them to stay in the same game.

[18:24] **Omnigamer**: There’s a bunch of different motivations for why people would want to speedrun. A lot of people think that “oh this is something that people do just to compete, they want to have bragging rights over their friends” that kind of thing. It's actually a lot deeper than that most of the time. Especially in the earlier days when there wasn't really an organized running community where you could do races, where you could actually track who’s doing better, etc. Before all that, it was just a matter of “I love this game as a kid, or I really enjoyed this game, and I want to get more out of it. I want to take it to another level that is beyond what I’ve worked with before.”

[19:08] **Omnigamer**: And speedrunning is a great avenue for that because it makes you play the game in a different way. It might be something you played a hundred times as a kid, but as soon as you start to speed run it, it means that you have to look at aspects that you took for granted before and you have to actually understand what you’re doing so you can optimize it better.

[19:26] **Omnigamer**: So it really plays out well when you have... basically people are motivated by just playing something for nostalgia and then they get hooked on this fact of discovery. That’s honestly one of the best things about video games in general, is you play something for the first time and you reach some critical point, some power up, and you get this whole new eye opening experience to be able to use it and apply it in your gameplay. It's the same thing all over again with speedrunning, it’s just now you get to find the extra hidden bits that aren't necessarily expected content.

[20:03] **Henry**: Right. It’s like you can make the game...like because normally you beat the game and most people just move on...but now you can play the game theoretically forever...and just the longevity of that.

[20:16] **Omnigamer**: It’ll basically enhance, like you said, the longevity of something that you already enjoy and that you want to continue to enjoy.

[20:23] **Henry**: Is it normal for people to speedrun multiple games at the same time?

[20:30] **Omnigamer**: Yeah I would say that most people when they jump into speed running, they kind of have something to get their toes in the water. They’ll work it out and play something that they started out with, and that’ll just give them a taste of how it's like. And if that really bites for them, then they'll go on and probably play three or four games. The ones who get really hooked will go on and they can do any number of games.

[20:56] **Omnigamer**: But it’s really about finding that value, because if you’re going to play it and you want that sense of discovery, that still will drop off at some point. You will get to a point where you’ve learned everything you need to know about that game to run it in any scenario, and you might start to lose that. In the same way, it's a trade off between the challenge of doing that, the enjoyment you get from figuring out something or getting a great run, versus the frustration of having to basically repeat it again for every new game, having to do X number of runs to be able to get something you’re satisfied with, so there’s always that trade off there.

[20:41] **Omnigamer**: I would say most people get to the point where they’ve tried out three or four games and then they find “Okay I'm happy with this as my core set, I don't’ need to expand any further.” And then there’s others who every game that they pick up now, even after playing it casually, just like alright it’s speedrun time.

[21:55] **Henry**: Yeah cause I think about it with open source...it's not very common for people to maintain multiple projects because it's just so much scope. Or I guess you might move across projects. But I think most people stick with one.

[22:09] **Omnigamer**: There are certainly people out there who have done many many speedruns. But my personal take on that is that if you start to go for quantity over quality mindset, it really does kind of defeat the purpose. You spend just a, let’s say, a week working on a game, you do one run, you get your completion, you stamp it in and load it up, and that’s it, you’re done with that game - it's not really a fulfilling practice. There’s still obviously much much more you can learn, there's better optimization that you can do. For me at least, it's not the best way to kind of approach this, that’s something will burn you out and also doesn't really produce that great of an artifact at the end either.

[22:53] **Henry**: You mentioned earlier that you appreciate the aspects of speedrunning in the sense that you get to kind of - especially if you pick a new game that no ones done before - you can do all the work that’s required. What are the kinds of roles that people can have when they're trying to speedrun a game, and if they want to get involved in the community, they obviously don't have to just do the runs, they can also, like you said, do researching or documentation, those kind of things.

[23:23] **Omnigamer**: So earlier I divided it up as kind of the three main steps. So you have investigation, you’ve got routing, and then you’ve got execution. And there’s certainly...when you jump into speedrunning, you’re going to be more attached to one versus the others. And I think that’s probably the best way to kind of draw the lines: whether you really like busting a game wide open, looking around, finding glitches, and ways to get around basically intended obstacles, you’ve got people who are very into creative number crunching, positing different scenarios, that kind of thing, those would be more of the routing type - here’s the plan we want to approach it with and I think it's going to save X frames over this over way. That can be another thing, because you're basically solving puzzles as you go through.

[24:18] **Omnigamer**: And then execution, a lot of that is associated with actually improving your response, basically getting to the point where you can show that a human is capable of pulling off something this good. And that’s where I believe a lot of people who really favor that execution path will go with it is “I want to show that, I want to push what humans are capable of, and this game is the way that I'm going to show that.”

[24:41] **Omnigamer**: There’s a lot of different room for more skill sets. If you’re familiar with reverse engineering and scientific method, maybe doing the investigation side of things is most appropriate. If you like to sit down and just handle different puzzles, and work your way through. The best way I can describe the routing piece is actually, if you're familiar with the engineering process, it's the way of designing a product through iterative improvement. If that's something that appeals, then routing is for you, and similarly what I said before for execution also follows.

[25:18] **Omnigamer**: So certainly a lot of ways that it can apply through, and even for CS, having a lot of that background knowledge and so on can help with figuring out how something is implemented under the hood. Whether they’ve set up their data structures in a specific way, whether there are certain jumps that occur when an event happens, you can use that knowledge and it’ll actually really help out in some circumstances where, lets say, that there are some typical errors that a programmer might make or simply ways that a programmer would commonly implement something that you can latch on to and figure out and asses much easier.

[25:59] **Henry**: It's funny because with programming, we’re trying to find the bugs to fix them but with speedrunning you’re trying to find the bugs to exploit them. Yeah I guess I ask that [question] about the idea of different roles because I see in open source...I’m not going to say it’s a problem, but I think when people think of open source, they think of writing code, but as I’ve spent time not just doing that as a contributor but as a maintainer, I realize there’s a lot of aspects of open source that aren’t literally making a commit. Whether it’s documenting the code, or even marketing, or writing blog posts, making tutorials, videos, triaging issues, there are so many things that people can do, but people don't know that they can do it.

[26:51] **Henry**: I think a lot of times people can come up to me or ask online “it seems like this project is so big and they don't need my help,” but on my end I’m like “no we need all the help we can [get].” But people still think that they need to write code and I think there’s a huge barrier, where they’re like I don’t think I’m good enough to do that. But you can get started in all these different ways. So I guess my question is: in speedrunning is there something like that, like people think they have to get in through this one way, but they don't know that there’s all this missing stuff that no ones working on, that’s important too.

[27:26] **Omnigamer**: Mhm. When most people are getting started, they’re watching on Twitch or something, and they just see okay all these people are doing runs over, and over, and over again, so clearly to get started, I just have to start doing runs myself. And they skip through this whole understanding process beforehand to know why they’re approaching things a certain way or, in some cases, they miss out on an opportunity to assess a different way of doing things that might actually be better.

[27:57] **Omnigamer**: But what you were saying earlier about different roles also reminded me of what I’ll call leadership, essentially. Basically people who will be advocates for the games and their runs, to the point of basically making them accessible to other people, people who will direct and basically know that, alright, we need to get documentation going, we need to actually get this going. I don’t have the skills to do that, but I know that my friend, runner number 3, really kind of enjoys that kind of thing, so I’ll poke him a little bit and see if he can get that up on a public facing website. Things like that are immensely important to making sure that the information sticks around for a long time, but also that it’s bringing in new eyes.

[28:50] **Omnigamer**: Most of the games that I’ve run, I’ve basically been the sole runner of. But from my own experience, to do a fully proper speedrunning, you really need other eyes on it, because it's very easy to settle into, well I’m doing it this way because it's the way I’ve always done it. And it really takes someone else to come in and say well that’s dumb, you should do it this way instead, it’s faster.” And you’re like “oh you're right, that is dumb. I’ll go [chuckles]...good job.” You need another pair of eyes and somebody who will be able to say that. You can't really do that if there's not really any kind of outreach, or anybody who actually who makes the case for “this is a fun game that you would enjoy if you speedrun, here are some unsolved problems that we’re trying to tackle, and here's all the information we know, and all the rest of that.”

[29:39] **Omnigamer**: So there are definitely roles beyond just doing speedruns that are available to basically anybody who's passionate about it and with a good mind for trying to make sure that the run continues to improve, that the community is happy with their game, and that kind of thing.

[29:56] **Henry**: Yeah it's really interesting because I think in that sense, there’s a coordination in, what you said, leadership role that is missing, maybe from a lot of games. And I think in open source we have that problem too, where it kind of feels like a sort of medium is messaged type of thing. When you watch the streams, you assume the only thing they do is execute and then when you think about open source, you look at their Github, it's all about code, and so you assume that all they do is write the code. There’s all these almost meta-level things that no one is thinking about because that's just the culture of how we work, it’s like how do we even advocate for advocates in the first place.

[30:41] **Omnigamer**: Mhm, yeap. It really is a difficult question to basically say you should be passionate about this because...without also having somebody really passionate to impart that on them.

[30:54] **Henry**: I guess in a similar way both of these activities are volunteer work, usually in open source, and also in speed running.

[31:04] **Omnigamer**: Yeah and that’s honestly what I believe has helped speedrunning kind of thrive. It's that people are willing to share information among themselves. There’s a bunch of reasons why I believe that could. Largely there isn't really any financial or monetary way that you can be successful with speedrunning right now. It is all for the love of the game and possibly some amount of competition. It is a significant feeling to be able to say that you are the best in the world at something, and be able to have the artifacts that attest to that ability. And it's just like if there’s somebody else out there, they got to put up too. And that actually does drive a lot of people, but I would say that that is not the major driver across the broad spectrum.

[31:53] **Henry**: You mentioned being number one and this kind of fame and popularity - I’m sure people seek that - but like you what you said, that probably doesn't sustain this pursuit. Another question is: people who don’t really understand speedrunning, they look at something, they think about “wow they spent so much time playing this game, they probably played this game a hundred times” and you would see people that like, they mess up maybe a few hours into the run and they start over, and it seems like a waste of time...I guess how are people able to continue to do that, especially if the game, the speedrun itself takes so long. Cause I guess there are games you could be in 10 minutes, but other games are 4 hours.

[32:49] **Omnigamer**: So when people are doing runs, when you get to the point of knowing a solid route and everything and you’re going through and performing run after run, trying to get a particular time, the key part in that is that people know a target in their head, what they want, what they believe they can achieve. And what you’re going through when you do run after run is kind of a zen iterative process. You know you can hit something and you’re really searching for that target: one to prove it to yourself that it can be done, but also to prove that it can be possible at all. And that’s something that is really important to really staying sane with this, cause it's not just a mindless activity, you have to focus the entire time. Whether it’s a short run or a longer run, really as you’re going through it's still something that you’re invested in, you’ve spent the time to understand the game, to practice and you want to do as good as performance as you can.

[33:43] **Omnigamer**: Another way to think about it is more like a musical performance. When you start out you're not very good, but by the end, you can really do some creative that’s impressive to yourself, something that proves that you are capable of these things. Not only that, but it feels good to be able to take your reflexes, you abilities to that next level. And that's a lot of what people are looking for. So even if they have a failure, they have something that doesn't go quite their way and they have to reset again, so long as basically the effort that you’re putting in matches up to the expected release from accomplishing that, it’ll overcome the frustrations in getting there.

[34:22] **Henry**: Yeah I guess in that sense it reminds me of sports in general. There’s the 100-meter dash and then there's marathons, and both seem like the same [in terms of process].

[34:36] **Henry**: Given that it’s something people spend so much time in, what is the right mindset you should have when going into doing speedrunning and if there's occurrences of burnout, how do people deal with that, is that something people even talk about?

[35:03] **Omnigamer**: Really the best way to approach speedrunning is that you want to have fun. So long as you are finding enjoyment in the activity and that enjoyment outweighs the frustration from following it, then it's something that is worthwhile to do. It is another form of entertainment, you are trying to produce certain artifacts and things like that, but it's not something that...when you reach a certain point, and let's say that in a lot of games there's instances where luck plays a big role - if you basically know you’re good enough, but you keep getting stopped because you don't get the luck you need, that will absolutely weigh into you on the frustration point - there are plenty of people who will burn out before they get to a point that really satisfies them and then they'll sour on the whole process.

[35:59] **Omnigamer**: The ways to avoid doing that is just like anything else. You want to make sure you practice in moderation. A lot of what you learn and what you practice will stick with you way longer than you could expect, so it relatively easy to jump back in at a later point when you’re more prepared to actually follow that pursuit. Know your limits, know when you’re too upset, or otherwise frustrated, to keep playing that game, and when to back off and let it cool down. In some cases it might never return, you might just be completely out on it. But it really is up to whatever your own standards are as well as how much you are enjoying that process.

[36:50] **Henry**: Yeah that makes sense. I feel like, especially with open source, it's really easy to have a sense of guilt, when people are making issues, like there are bugs here, and I want this feature, etc. even though you know you don't owe anyone anything, and they’re not paying you, you still feel like you have to help them. It's hard for people to get over that sense of knowing that there are people relying on you. And I know that’s not necessarily the case with speedrunning, because, at least with code, literally there are companies where their code is relying on your code, in some sense, and there’s a dependency chain. I don’t know if there’s anything like that in speedrunning.

[37:39] **Omnigamer**: I would say not necessarily with speedrunning, but it closely parallels what goes on with streaming. The two are pretty interrelated these days. You can speedrun without streaming, but most people won't, is kind of how I would put it. For a lot of people, you get into this habit where, alright, I’m going to do runs today and we’re going to try to get this new record, you will get to the point of feeling guilty if you miss out on a day, like people were expecting to watch you today doing this run, or it was part of their daily routines to either watch at work or it’s just kind of their nightly thing to watch you and you interact with them. You start to feel guilty if you don't provide them the content that they expect. So a lot of people might feel compelled to continue to run well past what they actually want to do simply to keep up those interactions.

[38:39] **Omnigamer**: So I would say that is an understandable thing for speedrunners now, but it does focus mainly in on the streaming aspect.

[38:48] **Henry**: Yeah I think you use a good word - compelled. I actually tried streaming, but this is open source, and I already had the feeling like...people were like “oh are you going to make this a weekly thing?” I think that one thing you find with open source is that you intended it, like you said, for fun, and what happens is that it turns into this obligation that you didn't expect out of nowhere. And that’s kind of why, in some ways, I almost want to tell people not to do open source, even though that’s what I do full time. And they’re like, why would you tell me to not do open source when that’s all you do. But I think it's more like we shouldn’t be naive about the downsides and problems of the culture we have in open source and we need to figure out how to work towards fixing that.

[39:40] **Henry**: And same with streaming, it’s like once you stream, people are like why aren't you here today and tomorrow. And it's weird because you would think people care about you as a person, and people do, but especially online, people say random stuff and you take it too personally or seriously.

[39:59] **Omnigamer**: I'd say a big problem with that too is that viewers might not actually realize how much it's wearing on you. Streaming is a very personal thing - you have an interaction, often times they've got a camera, you can see what they’re going through with their facial expressions and so one. On the open source side, a lot of times if you’re just interacting on the Github or Grrr??? Or something like that, you see issues, and you see that people are poking you for feature requests and things like that. You don't even get the human reaction face of it, you don't know that hey I'm placing additional burden on them, they’re stressed and so on. But in the same way, you as a maintainer or designer of a lot of these things, you don’t want to make it seem like this is such a burden on you that people can't ask for things that they want. So it is a balance of trying to put yourself out there while also keeping your own workload manageable and it's very hard thing to strike.

[41:02] **Henry**: Well it's interesting because it’s like I want more “personality” quote-unquote and showing that people are human in Github because I think the problem is that we’re still behind the screen name, no one knows who you are, and I don’t know who they are either, and I think that invites this sort of entitlement and demanding kind of thing. At the same time, introducing that human element can also have its own problems, but when I meet people at a conference or a meetup in person, I feel like it’s almost impossible for someone to actually, to your face, say something, they would never say whatever they said on Github. If anything they apologize, they’re like “I said this thing, I’m sorry.”

[41:48] **Henry**: But I guess with streaming it's weird because it is like what you said it's so personal. And maybe as a streamer, you’re trying to put on a good face. Maybe you’re feeling bad, but then you decide to do it anyway. So maybe scheduling, or having that set schedule can be beneficial in a way, but also obviously if you can’t keep up with it you're going to have to reduce it. Because in open source, I feel like it’s not common for people to batch a set of time everyday, you kind of just go on it whenever, and maybe that’s part of the problem. The whole issue with notifications, in anything, whether it’s Twitter or social media, and Github is just another form of that, we talk about stuff like inbox zero with email, and issue zero, and notification zero, and it's impossible to go through all those. And I think setting aside “Oh I'm only going to look at this once a week or this hours a day” is actually better and more healthy.

[42:55] **Henry**: Github actually just added this feature where you can add your own status. And I know some people think it's more of a social media thing, but I think it's useful to tell people, like signal that I’m busy, I’m doing something else, I need to focus. And i think that’s great when people are trying to ping you to do certain things. You’ll be like “oh they’re busy.”

[43:13] **Omnigamer**: Yeah any additional kind of communication avenue out there that people can understand where you’re at, where they’re at, however it needs to be, is honestly really important, it's just part of the human way. You got to understand where the issues are and balance out your response to them.

[43:34] **Henry**: When you were getting into speedrunning are there guides into how to do it? With open source, there aren't that many guides on how to be a maintainer and I think that’s something we’ve been trying to work on. Each project has its own readme and contributing guide, and I’m sure you can be like “hey go to our slack or discord.” Are there any norms and etiquette that people have, or is that just different per game, or it's not even a thing?

[44:03] **Omnigamer**: You know a lot of the most popular games will have a lot of supporting information for them. People who make tutorial videos, discussions of how to do this or that, I’ve even seen breakdowns of why basically they would pick a certain path over another one in a drawn out conversation because that is important to the people who run that game. And there’s enough of them that that content is reasonable to make. But as far as just doing speedrunning in general, there’s relatively little content out there. Every once in a while there will be a video production that kind of breaks down some tips, but they’re usually pretty short and not really all encompassing.

[44:48] **Omnigamer**: As far as I know, the book that I wrote kind of covers that in as good as detail, in a general case, as you can get. And I’m hoping that will really help people get started and see what's happening beyond the stream so to speak. But doing the general guidance and bring up is something really has not been brought out or taught very well at this point for speedrunning.

[45:17] **Henry**: Yeah I guess it's still like early days I suppose.

[45:23] **Omnigamer**: It’s somewhat, but people have been doing this for years and years still. It's just a matter of...let’s say that there’s 20,000 speedrunners in the world right now across all the different games and so on...there’s only so much content there that makes sense to help support that. Obviously once the content is there it’ll help to bring more people into the fold and get through that a lot better. But right now the demand isn't quite high enough that people go out and do that extra mile to make it a priority.

[46:03] **Omnigamer**: And really a lot of people don't even necessarily understand what they’re doing in speedrunning, and I don't mean that in a negative way. I mean they haven’t really thought about “oh this is the process that I go through, oh this is the steps that I follow when I pick up a new game.” They just have their own inherent way of doing it and then it's not something they want to formalize or even thought to formalize and bring out to help somebody else. So they share their tips on what they did and they leave it at that, and that’s really all a new person might have to go on.

[46:35] **Henry**: Yeah that kind of reminds me of open source too, where it’s like, maybe there’s that inflection point where it becomes...not “mainstream”...but a lot more people come in than you can handle I supposed. For example after Github, so many more people got involved into open source, not just people that were paid and now maybe it was normal for people to not have to worry about those issues but now we have issues of scale and dealing with so many people getting involved with programming in general right. I think it's only recently that we’ve been thinking about the sustainability of open source is a real problem. We have people that are spending their volunteer time working on projects that all the top companies in the world use, but there’s literally only like one person or a few people, my project included, working on these things, it’s like they should either get paid or they should invest resources into making sure this thing stays sustainable for the long run, rather than just using it and once it’s over we’ll move on to the next thing.

[47:49] **Omnigamer**: I’m reminded now too there is a more direct crossover within the speedrunning community and open source that has to do with the TAS community. What this means is Tool Assisted Speedrunning - TAS. These are the folks that rather than relying on human instincts to go through something, they actually will go through and they’ll play a game frame by frame, they’ll have complete introspection abilities into whats going in memory, they’re able to drill down exactly into what’s going on with certain interactions, so that they optimize it to the frame. And that is a pursuit that is directly an optimization problem. When somebody comes out with a new TAS, it basically is a new proof of “this is what we posit is the fastest way to beat this game.” And it provides another peer-reviewed opportunity to see the inputs that went into, where the improvements were, and that kind of thing.

[48:53] **Omnigamer**: But where it hits on the open source side is that you need pretty advance tools in order to that in the first place. So a lot of that community is contributing or at least heavily using the tools developed by emulator developers. Many emulator developers nowadays do have open source projects, you can go and contribute. One of the ones used most by the TAS community is called BizHawk and that’s a completely open source platform that incorporates a variety of different cores to handle different architectures and gaming systems.

[49:29] **Omnigamer**: That's something you can go, you can check out their Github repo, see how kind of how it’s grown and changed and it's turned into its own monolithic thing. The whole point there is that you need the accuracy, what you’re playing in the emulator should as closely as possible represent the system that it’s intending to emulate, but also the tools that go into developing that and making it better, so lets say, being able to look into the memory state of a given frame, or even having a full featured debugger associated with playing through, that’s something that’s very valuable as a developer, and that’s what those tools were originally created for, but it's also super valuable when you’re trying to actually optimize what you’re doing, finding out where you can actually save that extra couple frames as you’re going through these things.

[50:22] **Omnigamer**: And that’s a pretty significant thing. It's still actively developed, they have a new major release probably every few months. That’s something that has helped tremendously across many different games as well as just showing what is possible in some games. The point of a TAS is way different from that of what you would do in a real-time run, which is how we refer to it when handled by a human, in that you are trying to show what’s best but you also can do things that go beyond what a human is capable of. Things that might need to be: you’re pressing buttons at 30 hertz, you’re going through and you do some impossible combination of inputs that you can’t do on a physical controller, something like that. It’s honestly very entertaining and feeds back into a lot of real-time running where you have these tremendously difficult tricks and then people will get creative and find out how to pull them off in a not so humanly-impossible way.

[51:26] **Omnigamer**: So that’s really helpful. And honestly those tools I’ve gone through and used them so many times, they’re extremely helpful and I’m very gracious that we have a community that is that devoted to the archival process of preserving what made a game system, but also following the proper development practices and producing tools that enable people to do what they need to with them.

[51:56] **Henry**: That’s funny that was going to be a question I ask, like do people make tools. That’s cool so emulation itself, that task kind of helps preserve a game so that people can actually play it when the system doesn't...like when you can’t buy it anymore.

[52:16] **Omnigamer**: Yeah, it's something that we are just getting to the edge of now. We’ve got all these consoles and things that people are playing that are 20, 30 years old almost, at some point they’re going to break down, and they’re well past any kind of production date. Nowadays, there’s people who produce FPGA (field programmable gate array) cores that try to mimic them appropriately and that kind of thing. But really you need to have this documented and set up while we still have the context of the original games to compare them against.

[52:47] **Henry**: Yeah that’s a really interesting aspect of maintenance, where it’s like the actual game itself might not exist anymore and we should preserve it.

[52:55] **Omnigamer**: Mhm. And I’m very glad too there's a whole branch of people dedicated to archiving games and their original context. I’m glad it's around and I’m hoping will still be around and very capable by the time that my kids start to grow up, for example, and they can start to enjoy some of the things that I experienced as a kid when I was playing games. That’s kind of my hope in all that.

[53:24] **Henry**: I have a general question, earlier we were talking about TAS and emulation, do you know of any programmers or are there a lot of programmers in the community. I wouldn’t know how you would really know that.

[53:38] **Omnigamer**: I would say that programming ability is a common skill that overlaps with some of speedrunning, especially when you’re talking about the investigation and routing side of things. The people who tend to enjoy that side of things are already in the kind of in the engineering mindset. So they probably encountered some of that or learned it somewhere along the way. But I can’t say for sure whether, lets say, that the proportion of people that plays games and has a CS background, and the proportion of people that speedrun and have CS background, whether that’s a different portion. There are certainly a lot of people who do both, but as for whether they are more likely to speedrun as a result of that, I can't say. But there are certainly plenty of people I know who have at least dabbled in some amount of programming or computer knowledge, and that does help to contribute to a proper approach to getting through speedruns.

[54:37] **Henry**: Yeah and also maybe the opposite would be true. Well not opposite, more of getting into speedrunning might make people more interested in becoming a software engineer, or even QA.

[54:49] **Omnigamer**: Right and actually a lot of my friends who are speedrunners, they have varied backgrounds. For example one of them is a ceramics engineer and so he might have encountered programming just a bit when he was in school. But he really didn't have to understand and appreciate how a game was constructed until he started speedrunning. And it was my pleasure to hear that he was also kind of also enjoying that process of figuring out how games operate under the hood. So that’s certainly something a lot of people as they get in deeper, they’ll naturally pick up a lot of computer science and programming knowledge just by virtue of working in software.

[55:32] **Henry**: So there’s so many different kind of games you can play, it seems that there might be a big difference between speedrunning a quote-unquote “old school game” and a game that came out just this year. What do you think about that?

[55:50] **Omnigamer**: There’s certainly generational differences in games and some of it is technical, there’s something very different that happens, lets say, when you exceed the bounds of an array in a MA-6502 based system as opposed to a modern system which will be running some variety of Intel or PowerPC or otherwise. You don’t have the extra layers of basically security protections, operating systems level stuff. The old system, the 6502, is going to happily do whatever. YOu can completely break it and so long as it doesn't get into an endless loop state, you will continue to ruffle along and keep playing. Whereas now if you hit on some out of index or underflow or anything else like that, the system could just crash, and that’s that.

[56:49] **Omnigamer**: But also, there’s been a very big difference in how games progressed and are developed. You don't have this as much in the indie space, where games are more typical with their older counterparts. But when you have these big narrative-driven games, they tend to be packed with content, and the content is still things that you have to get through, whether it has the conveniences of, lets say, being able to skip through cutscenes, or being able to bypass things that are, lets say, there, but not necessarily challenging, for example like an auto-scroller - it can tend to drag things out and make it not as enjoyable as a speedrun.

[57:32] **Omnigamer**: But that doesnt mean people certainly still don’t try. There’s lots of people who invest themselves in new games, especially the Nintendo titles. Right when they came out, among the first things that people did with Legend of Zelda: Breath of the Wild and Super Mario Odyssey is just start going ham on trying to figure out what's every kind of trick and otherwise that I can do to help try an advance the speed run. And that's really good to see, it's just something that doesn't quite take hold in every game simply because the ratio of interactive time to non-interactive time starts to get kind of out of whack with more modern titles.

[58:16] **Henry**: Right and I guess the more popular a game is in general the more people want to speedrun it.

[58:21] **Omnigamer**: That’s a typical thing, and that’s what I tell people too. I’ve talked to a lot of game developers actually about what makes a good game for speedrunning. And there’s a lot of quality of life things that you can include to make games that way. But the real core of it is make a fun game. If you make a fun game, people will continue to want to play it and they will find new ways to enjoy it that you might never have envisioned. And that’s part of the reason that some of the most popular speedrun games are as popular as they are, it’s just that much fun to keep playing, then I will find more ways to play it.

[58:58] **Henry**: That’s really funny because it makes me think, like, I’m assuming that there are game developers that, now that speedrunning is becoming more of a thing, they purposely do things that make it easier to speedrun. Like what you said, make it easier to skip cutscenes, or make the dialogue go faster. Like what you said it would be weird if they purposely added exploits or something like that.

[59:24] **Omnigamer**: Yeah they certainly don't get that far, but one of things, and this is an open source concern too, is what do you prioritize when you have to issue a patch? For many developers of these games, like “oh there's this cool speedrunning exploit that they found and it’ll skip this amount of content” but it's really kind of obscure, it takes a lot of steps to set up and do. That’s not really something that should be at the top of your list to remove. It might ruin part of what you wanted for the experience to be, but youre main thing is still who is the average user. Are they going to stumble on this by themselves and is that going to ruin the experience for them? If not then it's really not something that you should put as your priority to go out of your way to fix and more so if you know that other people are still enjoying the game by virtue of having that in there, certainly it makes as an incentive to leave it there or at the very least leave it for later on the list of patches you might make.

[01:00:30] **Henry**: Yeah I was actually going to ask that exact question about patches. And that reminds me, that’s the same as open source, where like you get a thousand issues, which one are you actually going to work on? And the problem is that the person making the issue is obviously very frustrated that they found this - maybe we should congratulate them, wow you found this thing that we never expected - and it's like should we fix it and we have to weigh that against every other thing. For a game developer, if it doesn't affect everyone else, why even bother to spend the time?

[01:01:05] **Omnigamer**: Mhm. And that is a sad reality, is that, well on the speedrunning side, is that there are patches, versions do change that alter speed run routes rather significantly and then that becomes a whole resolution process, where people have to try and reconcile, ok which is the correct version to try and do runs on, if there’s still a way to basically perform it on an old patch that had this or that trick in it, do we continue to allow that, or do we separate that out as its own thing. It’s kind of messy but there’s plenty of instances where that’s kind of gone either way and that’s really up to the people playing it to decide.

[01:01:46] **Henry**: Yeah that part is really interesting, cause the messiness is reality. The convergence of packages and open source, and like one, two, three, all these different versions. I guess it’s the same, once there’s a new version of a game, now you have to re-figure out all the techniques, if they even work anymore. It’s like you have to start over in a sense. That reminds me of competitive gaming, like say Super Smash Bros, when it was an older version, like Melee, they didn't really have that and so there’s no chance of that happening. But then now, with patches online, all the things that you’ve learned acn possibly go away in the next patch. It depends on the developers, on do they even follow the community, do they listen to them.

[01:02:34] **Omnigamer**: Right and it's something that, I’ll say, especially for a competitive medium, it is always going to be a cat and mouse game. It’s that you’ve found something and you want to create an appropriate balance, where people have reasons to play this or that character, but every change you make is going to have unintended balance consequences elsewhere that might result in something else getting way more powerful. And it's kind of up to the players to figure that out, patch to patch. But it can be kind of disheartening as a developer that the things you intend aren’t always how you turn out when you release a patch.

[01:03:15] **Henry**: Yeah I guess there’s a level of humility there. Do you want to let the community go away and do all this stuff, I think it seems better because it makes your game more popular and exciting. But I guess people have a certain vision of what they want it to be.

[01:03:30] **Omnigamer**: Well especially with the way that eSports is developing, this actually was a pretty huge issue in years past with popular games like League of legends, where they might release a patch in the middle of a competitive season and it just completely upends everything about how the game is played. And players get upset, viewers get upset because things don't go their way. And then it can generally be unpleasant, depending on how quickly that patch cadence is and how long people have to kind of adjust to what's changing, it can make for some unfortunate scenarios.

[01:04:09] **Henry**: Yeah it makes me think that the game itself is like an API and the public interface is obviously the random facts and how it works. They can fix the bug somewhere else and it changes something and you have no idea. It kind of reminds me of just like testing with code in general, where you want to make sure that something does not regress, so you write a test for it, and then when you change the code it doesn't do it. But there’s no concept of that in relation to competitive gaming or speedrunning.

[01:04:49] **Omnigamer**: You can think of the runs and the matches and however else as your kind of unit tests. When a new version comes, you probably don't know everything that actually changed in it, or some of the things that changed might have been to minute to even list in the patch notes or something. But when you start doing your run and you found out “hey doesn’t interact the way it used to” well there’s your case. It's a little bit more of a long form of how to get through it. But that’s certainly something that comes up every time that there is a new patch, people will go through and see what got ruined as a result of this patch and how can we get around it.

[01:05:23] **Henry**: It’s like a bad Christmas present.

[01:05:28] **Omnigamer**: Yeah.

[01:05:30] **Henry**: Moving on to a different topic, in open source, it's possible because we have the internet and everything is online, I find it interesting that programmers like going to conferences a lot and meeting up with each other in person. Do you get the feeling that, for something like live-streaming and speedrunning, it's all like an online thing, but do people want to do more in-person things?

[01:05:59] **Omnigamer**: Oh absolutely. And really it's kind of a shame that it doesn't get more notice. But there are all sorts of community driven events. Some of them happen online, plenty of them also happen in person, where you’’ll have basically speedrunners from a certain region, they’ll get together and play games for a weekend, just together, and they’ll stream the whole thing and it’ll just be a good time to enjoy the company of somebody else.

[01:06:30] **Omnigamer**: And this is something that I experienced a lot when I was much younger and going through the Smash Brothers scene, is we would travel out to tournaments. You’d have the tournament there of course, but the main event was also just meeting up with the people who shared your same interest. Basically spending the time with them, learning from them, laughing, that’s part of the experience of getting engrossed in what you’re doing. Right now, the biggest event on the speedrunning side that fits that bill is the game site: Quickevents. Which are annual, twice annual, charity marathons, where a marathon is basically just a bunch of speedruns played according to a schedule 24/7 for an entire week.

[01:07:17] **Omnigamer**: And that's kinda like the main showcase of our community to the mainstream rest of the world. It's a bonus that we get to raise all sorts of money for awesome charities as part of that. So it gives something substantial back to the world as part of doing our activity and that’s really fulfilling for me. One of the main reasons that people will go is so that they can just see their friends, who they communicated with online, the other people in their community who helped to route things. It does kind of give them the opportunity to really live it up, to attach faces to the names, and then just to better enjoy each other’s company.

[01:08:00] **Henry**: Right I think, same with me, you know, you talk to these people online all the time but then you actually don’t - like even for the project I work on, I didn’t even meet some of the people that work on it with me for like years, until we had the opportunity. So I think that’s really awesome.

[01:08:18] **Henry**: Yeah something I’ve been thinking about a lot recently, related to meeting in person, is that individually a lot of us maybe suffer from anxiety, or what we talked about before guilt and stuff, and I think it's weird because a lot of times I feel like we don't really talk about it. I think someone might get burnt out, and it's a well known person, and they’ll write a blog post and then we’ll all feel bad. But then just in the day to day or week to week we’re not really talking to people about the issues that we have.

[01:08:52] **Henry**: And so something I’ve been thinking about recently is trying to create some kind of support group system for maintainers. All it is is just meeting up with people, maybe online or locally. It seems like an obvious thing to me, but we’re not doing it. So I’m hoping we can do more of that.

[01:09:13] **Omnigamer**: Yeah anything that can make you feel like you’re a part of something bigger is really good reinforcement as far as I see. So anytime that you do have an opportunity to meet up with somebody who is doing something similar to you, and in this case like they’re working on open source projects, they’re helping to maintain, that kind of thing, just knowing that there’s other people out there who enjoy that aspect of it or are doing that same thing is positive reinforcement on yourself to keep on doing it and keep on improving.

[01:09:47] **Henry**: Yeah a specific issue related to working on open source or when we’re talking about streaming, I found that, it's a really weird issue, but you can get known for a certain project or a certain game, and I think that can lead to its own problems. I use the word “trapped.” Like for a lot of people, I’m known as the Babel guy. And I think that can be negative in the way that, first, obviously I'm not the only person that works on the project, and so I think it does not allow visibility into the many other volunteers in the project.

[01:10:30] **Henry**: And also it kind of reinforces the idea that, for myself, my self worth is in the fact that I work on this project. And so, being seen as a leader, it makes it harder for you to - like if someone says something negative then you take it personally - or even in a different way maybe it's harder for you to leave. Maybe there are people, say in speedrunning, they are known for certain games and they can’t switch to something else for this one game.

[01:11:03] **Omnigamer**: I think there are certainly cases for that and it's unfortunate that it leaves such a big impression where you feel dedicated to a particular cause, even beyond your own enjoyment for it anymore. In my case, I’m known for a number of things, most publicly that, I would say don’t really define me, or don't define the things I like to do. It's simply that these for whatever reason got the most visibility. So thus, I’m the “Dragster” guy or the “Timecop” guy, and those are certainly projects that I’ve worked on, but those weren’t my main projects. I treated them just as much as I’ve done anything else. It's just simply those were the achievements that really stood out to people for whatever reason.

[01:12:03] **Omnigamer**: But when we get to this point of streaming, I’ll just say again, one of the issues with streaming is this expectation that you do something that is the content that people expect. And if you’ve reached the point where you’re basically done with the game, you’ve hit your goals, but that’s kind of your main viewer source is playing this one particular game, or just a couple types of games, that kind of thing, then you can definitely feel trapped. It's something that you realize if you swap to something else you might lose a lot of viewership. If streaming is something of how you make a part of your living, that’s a huge concern.

[01:12:45] **Omnigamer**: And it's something that a lot of people are still realizing as streaming is still pretty much a brand new industry. Everybody’s still kind of learning the ropes of what goes into it. But definitely getting content locked, getting stuck with the image of the person that does this or that, it is kind of a negative reinforcement of being stuck, being the only person who does that, or that has to be your thing forevermore. And that can be dangerous, especially since people do find other things that they want to do, they want to move on. But I don’t know if there’s a true way around that right now.

[01:13:25] **Henry**: Yeah I think I see that in almost any creative field. Whether it’s music, right, the artist has a certain established style, and then they decide to do something different and then their audience is like “why did you do that.” Or Youtube channels or artists. I think it's not going to be that different with streaming. But it's like, are people okay with moving on with something because people should theoretically appreciate whatever you’re doing because they like what you’re doing, not just that specific content. And they can move on to someone else instead.

[01:14:06] **Henry**: Maybe there’s also this, assuming they're doing this for their job, the other pressure is that well if I switch they have a fear that people don't like it and they won’t get paid kind of thing. So are there a lot of full time - I mean it’s new - but are there a lot of full time streamers or is it mostly a hobby for people, and do most people want it to turn into a full time thing or is it just like I want to do this for fun. Cause I think in open source most people do it for fun, some people want to do it as their job, like it's the dream to do it, like which is what I’m doing now, but I don’t think it's for everyone. And I think they kind of gloss over the negative aspects of it - maybe not negative, but like the struggles and problems.

[01:14:54] **Omnigamer**: Yeah the way I’m going to interpret that is that how many streamers who speedrun who are able to make a full time living off of that. At least from what I’ve seen there’s very few people who can provide speedrunning content as their main content, not just one of a variety of things that they do, and to be financially stable on a full time streaming platform.

[01:15:23] **Omnigamer**: And part of that is that where all the places where speedrunning and streaming match up well there’s also a kind of self-defeating point of it. It’s that, if one of the things you’re trying to do with speedrunning is get to the point where you have a run that’s so good you don't feel that you can improve it any further, and that also happens to be your main stream content...well what happens when you do get to that point of getting that perfect run...does that mean your content is just no more, are you going to grind at it even further, even though that you don't really want to improve it?

[01:15:57] **Omnigamer**: That’s one of those places where you can get trapped and being stuck in a certain content type. So a lot of streamers who do speedruns tend to mix it up with other things to keep a consistent viewership, who enjoys all the different content from them. You know streaming is just new. People are figuring out all the time what is possible for them. I would say that a lot of people kind of have too big of ideas of grandeur with streaming, it's kind of “oh boy i can play video games all day and earn a wage from it”...the reality is that it's much more related to the brand, the personality of the person playing. A lot of people might not be able to sell themselves in that way. You can be successful with a lot of effort, but to be really successful, it does require a ton of time, equivalent to or more than even a full time position elsewhere. And people need to know that that’s the kind of effort that needs to go in to it if they expect to actually earn their full living wage off of it. And then to become super successful and popular, you’re basically also rolling against luck, because there’s something that has to lead to that breakout performance where you get suddenly a bunch of interest. At this point, it does come down to luck, there’s not a whole lot of ways to turn yourself into a viral sensation.

[01:17:36] **Henry**: Right. I think it's very similar to open source in that most people are just programmers that want to share their code with other people and when you think about turning it into a full time thing, there’s so many skills, like what you said, personality and those kinds of things for streaming, that you don’t normally exercise as a developer. And then, it just - it’s a totally different set of skills that it seems only a few people are capable of doing at the moment because it's just not something that you’re learning. Even personally I'm hoping that my experience with doing this, i want to document even that, so that other people can - not copy because I’m sure every project is different, every person is different - but just saying that this is possible and we can all learn from each other.

[01:18:31] **Henry**: What are some of the biggest issues facing the community at the moment, and do you have any ideas on how to solve them?

[01:18:43] **Omnigamer**: The issues that I see are probably going to be pretty different from what a lot of people would say. I would say that right now we’re missing some very significant resources for general speedrunning. Some of these things were satisfied before, but right now there’s very little sense of quality control. When somebody does a run and they’re the only person to have done a run for a game, they get placed at the top of a leaderboard, and that’s what people see when they go and search for “hey has this game been speedrun” and “oh this one guy has a time, cool.”

[01:19:26] **Omnigamer**: You can’t tell a quality from a time alone. That might be their one and only run that they’ve ever done, it might be very poorly routed, who knows. And there’s no kind of authority or guidelines for people to really shoot for as far as what constitutes “hey this is a good run” versus “hey this needs work.” I have some thoughts on how that might be improved, but it certainly is something that I think a lot of people don't even realize is a problem.

[01:19:58] **Omnigamer**: And then on the other side, I really do see as a pretty big threat, is what we were talking about earlier, is the decentralization of information. Where it’s no longer easy and straightforward to go and find out well whats the knowledge base for this game, what’s been tried before, whats’ understood. There’s a lot of resources out there, maybe, but some of it might take place in relatively obscure or even private areas that the discussions happen, it’s gone through, and then it's never touched on again. And that’s a pretty critical thing that people need to have an easier way, a more convenient way of documenting information that actually does put it out in public and that people can find it. Whether they’re going to pick up that game tomorrow or in 10 years, it should keep that information just as valuable then and now.

[01:20:55] **Henry**: Yeah I think the resources thing is interesting because it's almost like if you’re the first person to run a game, you almost have a responsibility to kind of shape the future of this game in a sense right.

[01:21:10] **Omnigamer**: Mhm. Just my quick note on that too is that, king of the way that it happens now is that the first person who runs a game, the kind of de facto site for organizing speedrun leaderboards is Speedrun.com. If you’re the first person to run a game, you’re most likely going to be made moderator of that game. So that means you get to write the rules. I would say that there’s an increasing danger in people who do their first speedrun coming up with more and more inane rules. So things like you must run on this exact version of this emulator that is old and has kind of bugs with it that aren't practical compared to a real system, or you must do this in a run because I feel like it. Those rules tend to pop up from people who...well they should have better guidelines on what makes a proper category and things like that, they simply don’t have the reference or don’t care to follow it.

[01:22:17] **Henry**: Yeah I think that would be useful. Like, I was just thinking, it's not just techniques that can be shared across games, which I’m assuming there could be, but also that the rules in of themselves...why aren’t there like I guess “oh well we’ve ran this other game and this is the rules we have here...you don’t have to come up with it by yourself.”

[01:22:42] **Omnigamer**: In the old days this was satisfied by... Speed Demos Archive had a common submission ruleset. But obviously there's going to be exceptions. Some games that don't quite play well with those rules for one reason or another, whether it’s technical, whether it's enjoyment or entertainment purposes. But after the SDA era, that’s become less and less common. Speedrun.com does not provide any kind of template for rules, it's simply the community settles on whatever is best for them. And if the community starts out as one person, who may not have the best interest at heart, it can kind of ruin things going forward, or at the very least make it a little bit more of a sticky mess to work through and correct them.

[01:23:33] **Henry**: And then regarding decentralization, it's funny because in another sense, centralization can also be...we have this, we want more decentralization in the internet itself...but then with the information we still want it to be centralized cause then we want it to be accessible to people. So it’s funny that there’s this weird opposite thing.

[01:24:00] **Omnigamer**: Yeah there’s benefits to either way and it's just simply the pendulum is shifted one way for the time being and I’m sure that it’ll switch back at another point. So we’ll see, we’ll see where the future goes with this.

[01:24:13] **Henry**: Yeah I think that’s all the questions I have. We went through a lot. Thanks for coming onto the show.

[01:24:22] **Omnigamer**: Oh yeah it was great, thank you for having me.

[01:24:20] **Henry**: Where can people find you online?

[01:24:25] **Omnigamer**: Well now that most of my activity of writing and working on the book are done, I tend to stream a few times a week. I’ll be working on different speedruns or playing games casually. You can just find me at twitch.tv/omnigamer. On Twitter I’m @theomnigamer. You can check out my book, which has a lot on the topic we discussed today, and whole bunch more, by going to SpeedrunScience.com and that’ll take you to the product page, which should be launching. Finally I have copies in hand sometime in April, so look forward to that.

[01:25:05] **Henry**: Thanks!

[01:25:06] **Omnigamer**: Thank you so much Henry.
