---
title: "MA 14: Open Knowledge"
season: 2
date: "2020-09-02"
time: "54"
description: "What does it mean to be code adjacent? Shawn Wang joins Henry to chat about not just open code but open thinking with his experience in community managing, the idea of tumbling, moderating /r/reactjs, starting the Svelete Society meetup, documenting and learning in public, being historians of our field, fresh notes vs. awesome lists, the meta language, and adoption curves. (recorded in June)"
episodeLink: "932b52ce"
embedUrl: https://share.transistor.fm/e/4fad5d14
sidebar:
    order: 14
---

### Links

- [Shawn's blog](https://www.swyx.io)

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-2/open-knowledge.md)

#### Tumbling as an Alternative to Community Manager

[00:00] **Henry**: Hey, this is Henry. I have with me, Shawn.

[00:02] **Henry**: Tumbling. You just mentioned this to me. Do you want to explain what that is?

[00:05] **Shawn**: Yeah, okay. So hi and thanks for having me on.

[00:08] **Shawn**: This is an idea that's kind of spreading a little bit, I heard it first from Joel Hooks and Chris Biscardi from the egghead crowd. And they heard it from Alex Hillman, who runs in the Amy Hoyt circle of sell products online and stuff. So if you're in that world, you know who these people are. If you're not, you have no idea. But anyway, I think this feeling is very common among people like us.

[00:28] **Shawn**: So communities are important. We all get that. You can appoint a community manager to help to grow the community or coordinate events and stuff like that.

[00:36] **Shawn**: But it's a very like draining job. (laughs)

[00:40] **Shawn**: I've done it, right. You've done it.

[00:42] **Shawn**: And every time you like try to put together something for the community, they might participate, but then they don't seem to really carry on that momentum. It's up to you again and again, and again, to get things going.

[00:54] **Shawn**: So Alex Hillman, who wrote this blog post, was trying to popularize this idea of an alternative, which is tumbling.

[00:59] **Shawn**: He also made the analogy, if you're community manager, you're like a cruise director and a single point of failure.

[01:04] **Shawn**: Everything relies on you to get going. Everything relies on you to start and to organize schedules and stuff like that.

[01:10] **Shawn**: Whereas, his idea of a tumbler is a person who makes things happen.

[01:13] **Shawn**: In particular, a professional entertainer, a comedian whose function is to encourage an audience, guests at a resort, to participate in the entertainment activities.

[01:21] **Shawn**: So you kickstart things, but then it's like a sustainable nuclear reaction between the participants in the community.

[01:27] **Shawn**: Which is like, that's nice, right? Like I don't have to do everything.

[01:32] **Shawn**: I haven't seen this online that much.

[01:34] **Shawn**: So it really takes some talent in terms of community management to kickstart a many to many conversation, instead of many to one conversation with the community manager in the center of everything.

[01:46] **Shawn**: So this idea of tumbling. I think it's an interesting word. That's why it catches attention. It doesn't really tell you how to do it. I mean, it'd be a good idea.

[01:54] **Shawn**: I think it's a good goal though. For example, one actionable step is to remove yourself from being a blocker on things, right? Let people self-organize. Give them the power and trust them with the responsibility.

[02:04] **Shawn**: I think you've had this of other people that you chatted with. Give responsibility early right, and you see them start to take charge and grow into their roles.

#### Specific, Limited-term Maintainer Roles

[02:12] **Shawn**: One of the other things that, I think I was watching a Nadia talk. And she like started this chain of thought in me. I'm sorry, I can't remember which talk it was.

[02:20] **Shawn**: But basically, you know how we have these roles, like maintainer of an opensource repo? That's so broad, and that used to be the only role.

[02:28] **Shawn**: And now we have like write, maintain, admin, whatever. But then we also have triage and some smaller roles that only triage and do other sort of community manage-y stuff. So I think it's interesting.

[02:42] **Shawn**: What if every project had a maintainers.md and then we separated the role of a maintainer into these separate roles and then people could sign up for that. And it'd be well expected what each role would do. And there'll be like a limited term. And then once that term is over, then we kind of just vote in the new ones.

[02:58] **Shawn**: It's probably not voting. It's just like whoever wants to do it, but it's like a rotating thing. It's not the same person and you're not taking it on for the rest of their lives.

[03:06] **Shawn**: It's kind of little bit like how I guess golf clubs and social clubs run. They have limited terms and that's great. Even the president of the club, right, gets to cycle over and then you can see past presidents.

#### Separation of Maintainer Concerns

[03:17] **Shawn**: And that's a nice thing to have done, but you don't commit to it for the rest of your life.

[03:21] **Shawn**: So I've been calling this idea, separation of maintainer concerns, but then also like it has this like term limits.

[03:28] **Shawn**: What do you think?

[03:29] **Henry**: Yeah. I like that. It's sort of deals with a lot of different issues at once.

[03:33] **Henry**: One that you just pointed out now is this idea that you have to maintain something forever. And that's not necessarily a bad thing.

[03:41] **Henry**: It's just that the assumption is that you need to do that. So people that are trying to get involved, they're like, Oh, if I start, I'm going to have to do this forever. And they don't want to commit to that, right.

[03:51] **Shawn**: Well, sometimes I might not get involved because I'm just going to assume you're you're in charge forever. So I'm just going to just find something else to do.

[03:57] **Henry**: That's true too. And there's this pattern of whenever new projects come out, all these people just show up out of nowhere that were capable of contributing before, but because it's new, it seems like it needs a lot of help, but all the old projects just need as much help as before too. It doesn't seem as like cool or fun.

[04:14] **Henry**: What you said, everything's under control. Even though on the inside, it feels like everything's on fire sort of thing, right?

#### Babel W18, like YC W18

[04:20] **Shawn**: Yeah. It could be like a thing that we formalize.

[04:22] **Shawn**: You know how Y Combinator companies, they have like a batch, like I went through Y Combinator Winter 18. So for the rest of my life, I just say like YC W18.

[04:31] **Shawn**: Or recurse center, you know, like RC W18 or whatever.

[04:34] **Shawn**: What if we had like Babel W18 and I served as X of Babel for that term. And then I moved on. And someone else did that after me. And that's totally fine.

[04:45] **Henry**: Yeah, I like what you said about differentiation of roles.

[04:49] **Henry**: Maintainer is too broad and because it's so vague, people have their own assumptions on what that means. It limits what people can get involved with.

[04:57] **Henry**: I think when people are getting into programming, they don't know what's possible. So I think that causes them to not want to get started.

[05:05] **Henry**: We need to give them the concrete things, not just writing code, but all these other things and maybe giving those a name is a good thing, right?

[05:13] **Shawn**: I mean, triager. Repro-er. I haven't thought this out.

[05:18] **Shawn**: This is like a blog post that's been sitting on my mind for like a year, and I haven't done anything.

[05:23] **Henry**: I know you probably don't consider yourself a maintainer, but if you're the one managing the subreddit or if you're the one that's making videos about some project, those are all parts of maintaining the community, right.

[05:34] **Shawn**: Yeah, I mean, I don't have a name for what I do, but I think it's important. I think that code only goes so far, and I think that communities around code matters.

[05:44] **Shawn**: And I think that people who can sort of manage between both actually do very well. You know, there's an amount of self-interest in this. I'm not doing this, like for the community.

[05:52] **Shawn**: Because I've been so involved, I know everything is going on in React. If anything that I want done, I don't have to be an expert in everything. I know the experts on everything, right. So I can just call them. That's great.

[06:07] **Henry**: Yeah, that's its own like skill or just knowledge that it's important.

#### Becoming a Moderator for /r/reactjs

[06:12] **Shawn**: Yeah. Okay, so we can talk about the subreddit thing. So for those who don't know, I am one of the moderators of the /r/reactjs subreddit.

[06:21] **Shawn**: I joined when we were maybe 30, 40,000 people, and now it's coming up to 200,000.

[06:26] **Shawn**: And that's not me, right? That's that's just like the growth of React's popularity. I actually charted it once and it's round about 70% a year growth every year across GitHub, NPM and React reddit and what have you. So it's just an organic growth from people learning React. Feels like React is taking over, but actually there's tons of people who are still learning, right and still getting started.

[06:50] **Shawn**: So I was an active moderator for two years, ish. I've been on reddit for like two years before that.

[06:54] **Shawn**: And then I only got the job because there was some like framework war that was brewing.

[06:58] **Shawn**: And then Dan Abramov was telling me.. There's some like nasty comments about Vue or whatever in the React community.

[07:05] **Shawn**: And he was like, why don't you shut it down?

[07:06] **Shawn**: And I was like, Dan, I don't have.. I'm not a mod. I don't have the ability.

[07:09] **Shawn**: And then he's like, now you are.

[07:11] **Shawn**: And, I thought it was a great opportunity and I enjoyed it. I'm on reddit anyway, so that bought me into reddit even more.

[07:17] **Shawn**: The challenge has been sort of trying to get active participation.

[07:21] **Shawn**: Trying to balance beginners and advanced people, because we all share the same board. It's just one message board that's just voted.

[07:29] **Shawn**: So sometimes there are a lot more beginners in there. So you just get a lot of beginner stuff voted up.

[07:33] **Shawn**: But then the really awesome stuff, like there are very advanced people there who have really good comments and conversations, and we need to encourage them and to make them stick around.

[07:41] **Shawn**: So it's this weird balance of like are we beginner reddit today or are we like let's get deep into details, reddit, you know?

[07:47] **Shawn**: And moderators have very limited control, because the mob just votes whatever they want.

[07:52] **Shawn**: The only thing that you do, you know, you can prompt activity, right?

[07:55] **Shawn**: You can post discussion topics, you can post like surveys, you can post job boards, like who's hiring, right. That's very popular. So stuff like that.

[08:03] **Shawn**: But ultimately the conversation comes from the community and then your main job is to like shut off toxic elements.

[08:09] **Shawn**: So that's what Reddit is basically for me.

#### Learning with "I Promise to Answer Every Question"

[08:12] **Shawn**: I also started like a beginner Q and A.

[08:14] **Shawn**: Basically, it serves as a sink for all the Q&A questions that otherwise would be posted elsewhere. And then it would make the whole thing, very, very beginner.

[08:21] **Shawn**: But then also, it was a very good learning exercise for me, because I would just promise to answer every question.

[08:28] **Shawn**: And that just gets you very good at answering questions.

[08:30] **Shawn**: And then if you answer enough questions, you can see that you're repeating yourself, you make it a blog post, and then you can just like copy and paste, right.

[08:39] **Shawn**: Actually, if anyone is looking to get started in React or just any technology, you just go answer questions enough. And then the best questions become your blog post, and then you build your reputation that way. It's not that mysterious, right.

[08:51] **Henry**: That makes sense. I know Logan, who was a core Babel maintainer, basically did the same thing except with Slack. We had our just real time chat and then he just answered people's questions.

[09:02] **Henry**: And I did the same thing when I got started and it's not like we knew the answer, you just look it up and you have to figure it out yourself. So I'm a maintainer. I don't know them either. I have to look them up and then you figure it out.

[09:13] **Shawn**: Yeah. Let's say probably take like a year to know everything that people usually ask.

[09:17] **Shawn**: But I'm also very obsessed with history.

[09:20] **Shawn**: I definitely go back in time, and more than most people that I know, because I want to know origins of things and I want to know how things started and all that.

[09:27] **Shawn**: I think people should do that as well, because sometimes it makes it easier, actually.

[09:31] **Shawn**: If you look at a project from the beginning, then you're like, Oh, okay. This is the central idea. And then it just like accumulated a bunch of cruft along the way.

[09:39] **Shawn**: But it's fine. That's how that's all these things grow.

#### History and Memento Mori: A Time Before Git

[09:41] **Shawn**: But it also reminds you, you know, this like Memento Mori thing, like all things die or all things must pass.

[09:46] **Shawn**: People don't know that git is only 15 years old. There was a time before git.

[09:52] **Shawn**: And VS Code is five years old, you know, and there was a time before VS Code.

[09:59] **Shawn**: But it also means that five and 15 years from now, we would be doing completely different things.

[10:03] **Shawn**: That the presence of like, this is a special moment, but like not everything is fixed.

[10:08] **Shawn**: Things can improve. But also like things that seem like a sure thing right now may not be.

[10:14] **Shawn**: And I think I don't know what to do with that.

[10:15] **Shawn**: You know, that's just like sobering and it helps you be grounded in like everything that you do.

[10:21] **Henry**: Yeah, I think this aspect of caring about history, that's related to all this stuff I've been trying to talk about on the podcast.

[10:27] **Henry**: Like people that care about archival and preservation, even the thing we talked about with Jordan, and he's trying to preserve the aesthetic of Windows 98.

[10:36] **Henry**: Or people trying to preserve the artwork in museums, right. How do we do that in code? Are we even doing that, right?

[10:42] **Henry**: Like what you said, there's not a lot of history. I know Maggie was saying she wants to kind of do a podcast about JavaScript history.

[10:50] **Henry**: And I know there's the book, 20 years of JavaScript, but no one really cares about that stuff. You kind of move on to the next thing. And we forget like what we've learned, if we even learned it, right?

[11:00] **Shawn**: So JavaScript has a good.. Brendan Eich is still super active and he answers basically every question about JavaScript, which is amazing.

[11:07] **Shawn**: You can ask the creator.

[11:09] **Shawn**: So it's still fine. JavaScript has a lot of like institutional memory, especially everyone in TC39.

[11:14] **Shawn**: They like know things that happened before. And they're like, we were not going to repeat that again. So that's good. I don't have a problem with that.

[11:22] **Henry**: Well, I think that's what JavaScript the language, but maybe not like frameworks and libraries, those kinds of things. Tooling.

[11:29] **Shawn**: I do wish that every doc, every project had like you know, how this was made.

#### Where's the Story of How Projects Get Started?

[11:33] **Shawn**: I was thinking recently about how little code gets documented.

[11:37] **Shawn**: Like, we don't really know what Tobias Kopper's was thinking when he made Webpack.

[11:42] **Shawn**: We have some reconstructions based on like podcast interviews and stuff like that, but like nobody ever like stopped and like wrote it down.

[11:49] **Shawn**: It's just like, it just became a thing.

[11:52] **Henry**: Right. And even now I want to write down a lot of stuff, but then I don't want to put it on the docs cause I don't want it to be like official. It's just like this is what we're dealing with.

[12:01] **Shawn**: Yeah, but you can tell the story in podcasts and stuff that people pick it up, you know?

[12:06] **Shawn**: Okay then, you know, even for Babel, the primary doc for Babel's origins is Sebastian's like 2016 year in review.

[12:13] **Shawn**: It was just like, that's it? Like, it's just one of the most, you know, important..

[12:18] **Shawn**: I want to know the journey. I want to know the pain. I want to know like the things that you tried and it didn't work, and then why it didn't work.

[12:24] **Shawn**: Cause like someone else is going to try it and no one writes it down. So it's sad, but whatever.

[12:30] **Henry**: I mean, there's so many of these things.

[12:32] **Henry**: Like even us switching from GitHub to Phabricator, that was a whole thing, you know, like there's all these little, not incidents, but just events that happen that we learned something, but we don't talk about it. What you said, other people probably doing the same mistakes.

[12:47] **Shawn**: Yeah. I mean, look, everyone's busy. I don't blame them, but I just wish that there were more.

#### A Culture of "Document Yourself More"

[12:51] **Shawn**: And I feel like if we instill a culture of document yourself more, it helps historians like me, but then also it helps people get contributing. Cause they know the philosophy and all that.

[13:03] **Shawn**: Like right now, even like Sebastian is making this almost the same mistake with Rome, like everything's in his head.

[13:08] **Henry**: Yeah. What you're saying about culture is like, we're so far focused on making the new release or making it faster and less code size. Which is all good.

[13:20] **Henry**: But at the same time, that same person that's doing all that, they're not spending the time to, like you said, write down their thinking, because it's hard to write down your thinking and you kind of just want make it work. And there's only one person.

[13:34] **Henry**: Maybe it's similar to the whole community manager thing that is also a blocker on all of these different things. And not that they don't care about these things, I'm sure they want to do it, but just, you feel overwhelmed because of all the possible things to think about what's on your mind. I don't know what to prioritize all the time.

[13:51] **Shawn**: I don't know. I tend to think that solution's pretty simple.

[13:53] **Shawn**: Just like write more.

[13:55] **Shawn**: Just be okay with like, this is what I think now, I might change my mind. I don't know. But here it is.

[14:01] **Shawn**: We're always on Twitter so much. Like it's a form of sharing what I think, but like not really super committing into it that much. That's fine.

[14:07] **Henry**: Yeah. I think maybe we could talk about that a bit. Similar to code, you don't want to commit it. And it's like, why do I feel like I can't put it down on paper sort of thing.

[14:15] **Shawn**: So that's, I guess that's why I blog. I don't know. It helps you get into dev rel.

[14:19] **Shawn**: That's the other part of my life I've kinda gotten into. And then obviously that also got me into teaching mainly for egghead, but I've done some other workshops.

[14:28] **Shawn**: That's pretty good. I highly recommend people do that. It's kinda weird.

#### Learning Gears: Explorer, Connector, Miner

[14:32] **Shawn**: So I call these learning gears.

[14:34] **Shawn**: There's the explorer gear when you don't know what you don't know, and you're just going around and exploring and then taking notes for yourself.

[14:40] **Shawn**: And then there's a connector gear where you're like teaching what you know.

[14:43] **Shawn**: And then the final gear, it's either miner or builder. I think I've settled on miner. So it's like, when you struck gold, you should dig here. And then you just go.

[14:51] **Shawn**: And that's when it's like, okay, no one else is doing this. I gotta do this. I'm abnormally good at it. I'm abnormally obsessed by it. I should just go all in and do that as like a form of R&D.

[15:01] **Shawn**: When you're like a PhD student, you're like trying to push the boundaries of human knowledge, right. You know, ideally.

[15:07] **Shawn**: I'm sort of like between explorer and connector. I look for stuff that I don't know. I learned that, and then I teach it. But it's not special. Like everyone can do it.

[15:15] **Shawn**: But like some people really focus in, like Evan You, right? He found a thing. And it was like it's Vue. And he was like, I'm just going to go all in on it. And then the people like reward him by helping him right.

[15:26] **Shawn**: I think when you have something that you really want out of the world, it's almost like the universe that conspires to help you.

[15:32] **Shawn**: If you have like a general.. I wish things of just generally better, like that's not something that people can rally behind. But if you have a very specific vision, then that's something that people can get around.

[15:42] **Shawn**: That's the kind of thing that I see in Rich Harris. And they can get people to come along with that vision, with the docs and the speaking that they do.

[15:49] **Shawn**: It just seems like pretty inspiring.

#### Finding A Vision People Can Rally Around

[15:51] **Shawn**: And I'm looking for that. I haven't found that yet.

[15:55] **Shawn**: I always feel like, you know, cause I'm known for non-technical things. I'm known for like, okay, I manage the React community, whatever.

[16:01] **Shawn**: I speak a lot or whatever, but it's not really super technical. It's just like how to like, be super noisy as a dev.

[16:08] **Shawn**: So I'm looking for my thing and I still haven't found it yet, but I found a bunch of small little things along the way.

[16:15] **Henry**: And you want that specifically to be technical.

[16:18] **Shawn**: I mean, it would be nice. Just cause like, you don't feel like a real dev if it's not technical.

[16:22] **Shawn**: But like the world seems to want me to do more nontechnical stuff, especially like with this book that I'm doing, because that's definitely been the most successful thing that I've ever written or said, which is kinda sad, but like, yeah, I think it's okay.

[16:35] **Shawn**: I'm comfortable leaning into that. I also know that like, I want to do more, and I don't want to be only defined by the non technical stuff.

[16:42] **Shawn**: So that's kinda what I'm like. I want to adjust the other way now.

[16:47] **Henry**: Yeah, it's funny. I kind of.. It's sort of like the opposite for me. I've been doing all this technical and I'm trying to like, not not do technical stuff cause it's all technical in the end, but you know, how do I do sort of more on nontechnical?

#### Being Code Adjacent

[17:01] **Shawn**: to code. You need to know how to code, but then you're like next to it.

[17:04] **Henry**: That makes sense. Cause I wouldn't be able to maintain Babel if I don't know anything about compilers, I need to know something about it.

[17:12] **Henry**: Just to think out loud there, to me, it's sort of like, is it even worth our time to spend all this time trying to make all these things faster when it really doesn't really change what our product is about?

[17:23] **Henry**: Maybe the education stuff is more important in the sense, not really for Babel. It's just like, how do we get more people to understand ASTs, compilers, tooling, no matter what the tool is, right.

[17:33] **Shawn**: So I think that one of the things that I'm interested in as well, which is kind of like, anti-Babel, which is this idea of collapsing layers, right?

#### Maybe We Need a JavaScript Community Manager

[17:41] **Shawn**: We went through this phase of every tool does one, one job well.

[17:46] **Shawn**: But then it turned out that there's like 10 different config files in my repo. I don't know what they do. And they kind of don't work super well with each other.

[17:55] **Shawn**: And it's like, okay, are we due for like a consolidation where everything just gets done in one pass? Like we know what to do now, we've kind of like explored a bunch of things.

[18:04] **Shawn**: That whole Unix philosophy thing. That's good because they're small, they're easily maintainable. You can swap them out for other tools if you need to.

[18:12] **Shawn**: The downside of having small utilities that all just kind of chain together is that you need an advanced degree in modern JavaScript to know how to hook them up together, right?

[18:22] **Shawn**: A typical like production repo would have like 10 different config files in the top level of the repo. The VS Code won't really work super well with Prettier, with Babel and ESLint.

[18:31] **Shawn**: So to kind of bring it back to like the community thing, JavaScript doesn't really have a community manager or a tumbler. It just is this mess. Like maybe we should have one.

[18:41] **Henry**: Yeah. I think about that too. It's not really about your individual tool because in the end, no one's going to use it by itself. So you kind of do have to know about every other tool anyway, no matter what you maintain.

[18:54] **Henry**: What would it look like to be a maintainer of multiple projects, but then I guess the easy way out, in a way, is just make it all one.

[19:05] **Shawn**: And that's what Sebastian did. I don't know. I think it's interesting. It's definitely above my pay grade.

#### Cheat Sheets and Awesome Lists

[19:10] **Shawn**: So I think that the things that I focus on in my scale are open source knowledge. And that's probably the other thing that we can talk about, the cheat sheets that I do.

[19:20] **Henry**: I guess it's just like, why did you start doing it? Why do we call them cheat sheets in particular? Are they just awesome lists or readmes,

[19:30] **Shawn**: So, first of all, I feel like a lot of awesome lists become not awesome over time. Well, I mean, there's a process to add them, but there's no process to delete them, right. You're not going to come in like, okay, this repo is not awesome anymore.

[19:42] **Henry**: No, I think that's a super interesting point.

[19:44] **Henry**: It's almost like when we talk about like CSS, it's really hard to remove it, right? You don't want to like prevent someone from adding their awesome link.

[19:50] **Henry**: And then later you realize that it doesn't fit with this whole thing and you can't. And it just gets bigger and bigger. It sounds like any code, I guess.

[19:58] **Shawn**: Yeah. But the goal for this was actually more than just a repo of links, right? That's what awesome lists mainly are, they're good for that kind of surfacing.

[20:06] **Shawn**: So I kind of compare it to Yahoo versus Google, right.

[20:09] **Shawn**: Old Yahoo used to have humans who just like manually index the entire internet, right.

[20:15] **Shawn**: And then Google trained us that you have to type it into the search box. And then you find the top 10 blue links.

[20:20] **Shawn**: But it turns out that it's actually pretty easy to beat Google at surfacing the super relevant things, because you as a human know how to organize better to your domain. Google only has the template links.

#### Personalized Docs, Documentation Levels

[20:32] **Shawn**: So this is kind of like my way of like organizing information. But the other element I want it to reflect was that it's personalized docs, right?

[20:41] **Shawn**: So every project tends to have one set of documentation and that's fine for a certain project size. But actually I have this whole theory of documentation levels.

[20:51] **Shawn**: When it get to another level that's big enough, there's like weird use cases that the main docs will never cover. Just never, right.

[20:57] **Shawn**: So the way that I got started with the typescript thing was I got my first dev job, right. I went through boot camp. Like I graduated, I started my first day at the new job.

[21:06] **Shawn**: And then my boss was like, do you know, TypeScript?

[21:08] **Shawn**: And I said, no. And then I spent like six months, like struggling.

[21:12] **Shawn**: And then I was just like, okay, I'm going back to my old code, to other files to copy and paste and then copy it to a new file just to make a component. I should probably like pull these out and then paste it in somewhere as a cheat sheet, right. So like it's not just links.

[21:26] **Shawn**: It's also like copy and pasteable examples of common things that you're going to use. And the reason that React is never going to document in TypeScript is cause they use flow, right.

[21:37] **Shawn**: And the reason that TypeScript is never going to document React is because they serve TypeScript. The TypeScript docs serve TypeScript users who are coming over from Node.js And just general JS Land. They don't have anything React-specific.

[21:49] **Shawn**: So I found the hole where it was just like an intersection of React doesn't do this TypeScript doesn't do this, but there are a lot of me who are like React and TypeScript people.

[21:56] **Shawn**: And why not just create the docs for us? And so like it started copying pasting, and then now a whole bunch of it's like been translated into two other languages and it strikes a nerve because it's underserved.

[22:07] **Shawn**: And I think people need to get over this idea of like one single doc for that domain end those story. Like there can be different docs for different audiences and that should be totally fine.

[22:19] **Henry**: Yeah, that makes sense. I guess it's similar to note taking and your own knowledge bank. And the idea that some of that you don't even need to share, but it's good for you just to have.

[22:29] **Shawn**: Yeah. I mean, I share by default, and there's definitely a lot that I don't share.

[22:32] **Shawn**: I take a lot of notes in one note and stuff like that, but on thematic stuff that I know other people will have interest in, I might as well share it. Because they actually helped me out and improve it and stuff like that.

[22:43] **Shawn**: So I've been taught TypeScript by people at Microsoft and Uber and Airbnb and other places cause they PR stuff in, and then I have to learn from it, you know?

#### Open Source Knowledge, Proof of Work

[22:53] **Shawn**: So I kind of call it open source knowledge.

[22:55] **Shawn**: And it's the whole idea, open source code is better than closed source code because there's more people looking at it. It's easy to contribute. You know, open source has clearly eaten software, right. But the way that we treat our knowledge is very close source.

[23:08] **Shawn**: Even this recent digital garden movement. It's all closed.

[23:12] **Shawn**: No, one's sharing their knowledge.

[23:14] **Shawn**: I mean, some, but they mostly want to share like the finished products.

[23:18] **Shawn**: But for me, it's very easy to just put up a markdown file and just go like, Hey, you're all devs. This is a markdown file. You know what to do with markdown files. Just, you know, move stuff around, right.

[23:28] **Shawn**: It's very like informal. I mean, I'm the curator, right? Under my name and all that, but people get value just cause like they can contribute what they know, but then they benefit from the rest. It's exactly the same as the open source code project.

[23:39] **Shawn**: That's really good for one thing, but I find it helpful to establish expertise over time.

[23:44] **Shawn**: Like when I started out, I was a complete newb. And then people could see that I was a complete newb and then they could help me. And then over time, by the process of having answered a lot of questions, I became less of a noob.

[23:56] **Shawn**: And people could see that because all I needed to do was just drop them this cheat sheet and go, like, I made that.

[24:02] **Shawn**: And for me, that's proof of work. So I'm bringing this idea in from cryptocurrencies and blockchains and stuff like that.

[24:08] **Shawn**: The reason that the way that we interview is kind of like broken, you have to perform within a small interview window of I dunno a day, right.

[24:15] **Shawn**: And then like, hopefully you serialize your experiences down to a certain format, like on a resume or in like 30 minutes. A technical interview or like a conversation in a fit interview. And then they like deserialize it from like what you say.

[24:28] **Shawn**: And they'll be like, okay, I can see this person performing in my team. And that's it.

[24:33] **Shawn**: And that's fine. That's the normal way of doing things. But I have had people interview me and they Google me in front of me and they can just instantly see all the work that I've done and know that I'm legit and it's like not fakeable, you know?

[24:47] **Shawn**: And I'm not bragging, it just is. You can verify instantly because it's open. Whereas everyone else, if your work is closed, you cannot verify.

[24:55] **Shawn**: So you have to do like reference checks, you have to do technical tests and what have you. And it just kinda sucks in general.

[25:03] **Henry**: And it's happened over a long period of time, so it's not like people that just literally just copy paste someone's repo and then remove their attribution or increase their contributor counts.

#### Twitter as a Permanent Hallway Track

[25:13] **Shawn**: Yeah. I mean that's a little bit of like what Twitter is, right? It's a permanent hallway track.

[25:17] **Shawn**: My new job, do you know Nader Dabit?

[25:20] **Henry**: Yeah.

[25:20] **Shawn**: You probably do, he knows everybody. He knew of me. And I knew of him for two years before we started working together.

[25:26] **Shawn**: Right. Like at that point there's just nothing to hide.

[25:29] **Shawn**: I'm sure there's stuff that he didn't know about me and stuff like that. But like most of the time, you've seen each other interact, how you behave. There's there's no like question of like, this is a total stranger and I'm inviting them into my team for like two years or four years, whatever.

[25:43] **Shawn**: There's a lot less risk if everything's like open and it's instantly verifiable and you can see them work in public. And it's just a really nice thing to have. So I don't know. I have a lot of complicated thoughts about that and I try to write it down.

[25:55] **Henry**: Yeah, my job at Adobe, same thing. They found me through open source and I still had to do the interview, but I think maybe trusted that..

[26:02] **Shawn**: Like you kind of coasted through, right? You were like, they have things apart from this interview to judge me on.

#### Find the Intersection of Two Communities

[26:07] **Shawn**: So that's the TypeScript thing. I'm planning to turn that into like a course someday. I definitely got lucky with that one, didn't really do much to promote it or anything.

[26:15] **Shawn**: But I think that intersection, a pretty good formula for people if they're listening too and they want to do this, is to find the intersection of two big communities, probably underserved.

[26:24] **Shawn**: Cause like each community has their own official set of docs. They won't acknowledge the existence of the other. Go target the intersection, and that's about it.

[26:34] **Henry**: Right, you can definitely take the initiative.

[26:36] **Shawn**: They just have different priorities, right. They're trying to maintain their thing and they don't have you at heart and that's fine.

[26:43] **Shawn**: So I basically extended that approach to design. So I called it spark-joy, and that's just like a collection of design tools and that one got picked up by Addy Osmani. That one got attention, 'cause Addy just tweets really awesome stuff. So that was probably like one of the highlights of my like open source knowledge career.

[27:00] **Shawn**: My designs suck, but I think that there's a market for design, for developers like me, who know they suck at design, but they want simple tricks.

[27:08] **Shawn**: And there are other people who do that, but there's nothing stopping me from collecting my own list of stuff, right.

[27:14] **Shawn**: So that's what spark-joy is about. This one's not an intersection. This is just like my take on people like me on something that's super popular, which is designed for devs, always sells out whatever.

[27:24] **Shawn**: And anytime some designer goes like, Hey, what if I did a course on design for devs, devs just eat it up right there. And they never use any of the things that they learned.

[27:32] **Shawn**: So this one is like biased where it's for me. I know some things about front end, but I don't know design, so here's my list of things that I use all the time.

[27:39] **Henry**: Those are all things that you like personally really want to learn about. So it's not like they just came out of nowhere. It's just,

[27:45] **Shawn**: Yeah. I'd say was less serious about that. Cause like design was never like a big part of my job, but I probably try to make it more, I don't know.

#### Documenting Underlying Assumptions

[27:54] **Shawn**: And then this CLI cheat sheet. I was asked to make a CLI. I was maintaining the Netlify CLI because some guy left, then I took it on and then I didn't want to change my job to be a CLI engineer. So I asked for other people to be hired, to take over that job so that I could keep my existing job.

[28:11] **Shawn**: It's an important thing to like, look ahead to like what you're painting yourself into, in your current job. And if you don't like that, then you have to pivot. Before you have no choice. It's just like unfortunate that people are pigeonholed into undesirable things within a company. And then once you're in there, you kind of have no way to leave and it's just kind of nasty.

[28:32] **Shawn**: But anyway, like everything is a CLI and I think people don't understand that even Babel's a CLI. We all use the same set of tools and no one ever documented them, so that was CLI cheat sheet.

[28:41] **Shawn**: It's not as popular as the other ones, but no JavaScript course will tell you that chokidar is what you use for file watching, but everyone uses chokidar and it's like, where are the edge cases and you have to use something else. There's all these like, small little cross-platform nuances that like, nobody writes down, but I just wrote it down for myself, you know.

[28:59] **Henry**: Yeah. There's a lot of assumptions that people have that if you're in it, you know it, but no one writes it down.

[29:06] **Shawn**: Like, Sindre knows all this stuff, right? Like the kind of stuff that he does, he knows all of this CLI utils goodness. Right? Because he made most of that, but he doesn't write it down. He just like, open-sources yet another library. And people have to go use this library or they use a competitor library.

[29:24] **Shawn**: But then we just, I don't know why we use it. So might be a good idea to write down. I don't know.

#### "Fresh notes"

[29:31] **Shawn**: The last thing that I have you listed here is Concurrent React notes. So I'm sure you know, this like whole hoo hah about Concurrent React? It used to be Async React, covering React Suspense and time slicing, now it's just Suspense.

[29:42] **Shawn**: Used to be a super exciting thing in React. Now it's just super boring.

[29:46] **Shawn**: But I took it on myself to like be the central repo of knowledge for everything new in React, and I called it like fresh-async-react at the time.

[29:55] **Shawn**: So the fresh repo idea was like a twist on Sindre's awesome repo. So awesome repo just like lists things that are awesome and maybe less awesome over time. Right.

[30:05] **Shawn**: Whereas fresh is like for things that are new and constantly evolving. So actually chronological order is more important than alphabetical or categorical order.

[30:15] **Shawn**: Chronological means, okay, things that are three months ago, no longer relevant. So let's just delete all this stuff. So let's just like, keep it fresh. So that was essentially what I was doing there.

[30:25] **Shawn**: And then it became Concurrent React and became not so fresh anymore, so I just turned it into notes. And these were the unofficial documentation for Concurrent React, and then they actually released the beta. So then I archived it.

[30:35] **Shawn**: And it's good to have projects that end. It's good to give closure to yourself, but then also to the people who might see it in future and go like, is this still maintained?

[30:43] **Henry**: I guess that's like history as well.

[30:45] **Shawn**: It's history! It's still there.

[30:47] **Henry**: It's still useful to see like how people were thinking.

[30:49] **Shawn**: Yeah so cheat sheets are like one way where it's like collaborative. I have an open source license, anyone can fork in and contribute and whatever.

#### Starting a Meetup: Svelte Society

[30:57] **Shawn**: And then I also do a lot of real life community work. Cause like cheatsheets are kind of ad hoc on GitHub, but the real life things started with the Svelte Society stuff.

[31:05] **Shawn**: So this one was because like you, me, Rich Harris and a bunch of other people are all in New York and like we don't meet up enough.

[31:16] **Henry**: Yeah.

[31:16] **Shawn**: So there was going to be the world's first Svelte Meetup in London.

[31:20] **Shawn**: And I was like, we have Rich Harris in New York. We should have a New York meetup.

[31:23] **Shawn**: So I realized this with one week to go to the London meetup and I was like, we have to beat the London meetup.

[31:27] **Shawn**: So I just like put out a call and I was like, well, we're having a meet up on this date?

[31:31] **Shawn**: I don't have a venue. I don't have a time. I don't have people.

[31:33] **Shawn**: I don't have speakers, but we're just going to meet up and Rich is going to be there, cause I'm going to drag him there.

[31:38] **Shawn**: And then like stuff got together because like you have a specific want, right? We are going to have a meet up before London.

[31:43] **Shawn**: And people just like helped out. Tierney chipped in with the Microsoft space and people helped me promote it and get speakers and stuff like that. And it turned out really well, you can organize a 50 person meetup in one week. Just, just like that.

[31:56] **Shawn**: Yeah that was pretty fun. And then we moved online, right? I think it was more building out the Svelte community.

[32:02] **Shawn**: Cause there was some on Discord and some on GitHub, but not really like people trying it out, talking about it, and then also putting it into toy apps at work, and then eventually production apps, right?

[32:12] **Shawn**: Like if you want to grow a community, even in coding, you can write the most perfect code, but then if you don't see other people using it, you don't have a lot of confidence in this library or this framework.

[32:21] **Shawn**: So you need some social proof. Things are going, things are alive in this thing. It's not just the side project of like one crazy Brit in the New York Times.

#### Keeping it Alive

[32:29] **Henry**: What was it like, the difference between maintaining this meetup versus the first time. It's one thing to just be like, Oh, let's just meet up. But I want to continually do this.

[32:38] **Shawn**: Yeah. I mean, the excitement definitely dropped off. We probably went from like 50 to like 30, but it's still there, you know.

[32:44] **Shawn**: And then it's the classic difficulties of getting speakers and doing logistics and stuff. I was definitely kind of like one person on that for awhile.

[32:52] **Shawn**: I do the same thing that we should do in GitHub. I delegate and people want to volunteer for stuff, I give them stuff to do.

[32:57] **Shawn**: But they don't stick around. You know, they're not that super committed to it right now.

[33:00] **Shawn**: So they'll commit for one thing and then they'll leave.

[33:02] **Shawn**: I'm sure you, you know, I did that for Babel. So but that's life. And then you as the community manager, you kind of have to like stick through that.

[33:11] **Shawn**: And I think what really kind of bailed me out. It was honestly this Coronavirus, because I was already thinking, like this in person thing is really a mess.

[33:18] **Shawn**: Cause I have to organize venue and then people and then do AV and then do talks. Cause no one else speaking. So I have to be a speaker.

[33:25] **Shawn**: It's a lot, right. And it's super stressful and I don't get to enjoy it. I don't get to hang out with people and stuff like that.

[33:31] **Shawn**: So I was already thinking of going online anyway, and then this Coronavirus thing happened. So I was like, Oh yeah, now we are online.

[33:37] **Shawn**: I got really lucky in that, there are other people from Sweden and London who are, as interested in building a community.

[33:43] **Shawn**: It's weird. I'm not even like super passionate about this. I just want to see if I can do it. It's just like a interesting challenge. Can you like take this thing which is almost there and then just like give it that push to become huge. It would just be like a fun thing to do.

#### Taking Part in Category Creation

[33:56] **Shawn**: Like I don't even necessarily need to see Svelte take over the world or anything.

[33:59] **Shawn**: I just want to see how far can I push it to make it a thing?

[34:02] **Shawn**: Cause I saw it happen in Netlify where it used to be cheap, free static site generators. And now people are like, yeah, I'm the JAMstack person, right?

[34:09] **Shawn**: But I saw category creation at a company that was kind of fringe. To the point where like, I wasn't even sure about joining them because I was like, how far does this JAMStack have to go? And now it's like people writing books and creating the careers and all that. And that's amazing.

[34:23] **Shawn**: And that gives me a lot more confidence in like, things can start small. And with your help, they can get huge.

[34:29] **Shawn**: And you just got to stick it out long enough and do all the dirty work of getting things in place that need to be in place.

[34:35] **Shawn**: That's kind of what we're doing now. We had a big conference about 4,000 people attended, which is huge. I mean it's easier online, which was fun. Then we need to keep going with a site and everything.

#### The Meta Language

[34:43] **Shawn**: It's just like this, you know Cheng Lou, from the old React team? He calls it meta-language around the language.

[34:49] **Shawn**: The core thing is always the language. Whatever it is, like Svelte, React, whatever. And then the meta-language is like all the docs, community workshop, meetups, conferences, whatever.

[34:59] **Shawn**: That needs to exist too, cause that helps you get the most use onto the language. So I'm kind of building that.

[35:05] **Shawn**: I've never spoken to Cheng Lou. I'm curious what he thinks about it now. Cause they definitely have that problem for a reason.

[35:09] **Henry**: Yeah, I guess there's a difference between what we say and how it plays out. I can say a lot of things about Babel, but if it's still stuck the way it is.

[35:17] **Shawn**: Yeah sure sure. He's super intellectual. He doesn't have to be the doer.

[35:21] **Henry**: That's the interesting part of like, how do we take the theory and play it out? Like, how does it actually happen in practice and how do we live that out, those things that we actually believe are true, right?

[35:31] **Shawn**: Yeah, it's hard. And I'm not the most qualified person to do it, cause I have my own problems as well, you know?

[35:38] **Shawn**: I have my own like insecurities and need to, you know, fix my own situations and all that. So it's kinda like, you have to be a leader of people without being perfect yourself.

[35:50] **Shawn**: Like you're not done with, you know, your own problems, but then you gotta like assume the community's problems as your own, and then deal with that as well.

[35:58] **Shawn**: And it takes a certain kind of. Yeah, I'm sure. I'm sure you feel that all the time.

[36:02] **Henry**: You know, it's funny when people are always asking me for advice like, Oh, I know how to maintain this thing. There's a sense where I don't really know either.

[36:09] **Henry**: And maybe I've done it, but then I don't know how to word it. I don't even know how to express or it's hard to write down even which sucks because people want the advice. Like you kind of have to get into it and just learn through the process. Yeah.

[36:23] **Shawn**: Yeah. I actually came up with this analogy when I was writing in the book.

#### Parenting and Figuring Things Out

[36:29] **Shawn**: I don't know where I applied this, but I really liked this analogy even though like, I'm the worst person to use it.

[36:34] **Shawn**: You know how like when people are parents for the first time, they have no idea how to be a parent. They have a baby, they come home from the hospital, they have a baby in their hands and they are like, shit this is real now. And you figure it out and guess what? Like hundreds of millions of people every year, figure it out.

[36:52] **Henry**: You can read a bunch of books, you do a lot of prep work beforehand, but then when you finally get to it, you're like, Oh,

[36:59] **Shawn**: I'm sure even the prep is completely not reflective of like what it actually is like, you know, like there's all these prenatal things and you got to read about it and then, but then you're like, actually, you know, you wake up at 4:00 AM every day for like three years. And it's just really hard, you know?

[37:14] **Shawn**: It's this whole idea of like, you'll figure it out, if you commit to the thing and then you go like, this is my baby now. And it will die without me. And I can figure it out because other people figure it out. I just have to stick at it for a long time and try to do my best every day, you know.

[37:31] **Henry**: Yeah. I think there's a lot of faith, honestly, that you need.

[37:34] **Henry**: Not just in yourself, but just that this will work out, I guess. Otherwise, yeah, you kind of don't have any reason to continue, if you feel like you have to have a hundred percent confidence.

[37:45] **Henry**: I guess it's the same thing with anything, honestly, like writing and hoping that people like what you say, you kind of have to go for it, right?

[37:53] **Shawn**: Well, they're things that you can do, especially for writing in particular. I finished a book like about two weeks ago, and then now it's just like getting reviewed by people who volunteered.

#### Not Everything Needs to be in Public

[38:03] **Shawn**: And I'm glad that they're reviewing it before it goes out to like everybody, right. It's good to have a small group that you trust that will just give you a real feedback. Cause not everyone does, right?

[38:14] **Shawn**: Most people just want to see the finished products and then they'll they'll judge you good or bad based on your finished product. But your smaller group of like fans and friends and supporters and all that. They're fine with your unfinished thing and they'll tell you where you go wrong.

[38:26] **Shawn**: So you really need that separation of like, Hey, you guys are my ingroup. You get to see like the early drafts. And then you work on it.

[38:32] **Shawn**: Because as much as I tell people to like learn in public, be raw, and perfect's the enemy of good, sometimes it really counts to get it right on the launch.

[38:39] **Shawn**: Sometimes when it's meant for a general audience, you have to figure everything out before you hit them. So do need that sort of review process.

[38:47] **Henry**: I think that's good. Like there's writing, but then also just examples for our community with like Vue 3 and React Hooks.

[38:54] **Henry**: They weren't going to do that in public when they're trying to figure out how everything works, they did it after they had all the docs and planned through everything.

[39:00] **Henry**: I think a lot of people are like, why don't you do it in public? Isn't it open source, that sort of sentiment. And it's like, no, they're doing this for the benefit, because they don't even know what it is.

[39:10] **Henry**: It's hard, cause like we want to be inclusive and like you said, be in public. But then how do we balance that with things that feel like they're more experimental and we don't want to bother people with things that aren't actually going to happen.

[39:22] **Shawn**: Again, it's a question of size. If it's just you, if it's just like 10, 2,000 people who cares, you know.

[39:29] **Shawn**: But when you're hitting like hundreds of thousands, a million. The mass population are never going to contribute. They only want to see the finished product.

[39:38] **Shawn**: And they'll they'll shit on you for showing something that is like not fully worked out anyway, cause they'll just pick holes and stuff.

[39:45] **Shawn**: Like when I heard that Vue 3 was being developed in closed source or whatever, I was like, yeah, that makes a lot of sense. And Evan got so much shit for that. And I think like, geez, these people just haven't really been involved in a real nitty gritty opensource thing.

[40:02] **Shawn**: They just expect everything to be open. I don't know. I just have no sympathy for that.

[40:08] **Henry**: Yeah. I think it's very similar to TC39 proposals. When do you decide to use the feature when it's stage three. When's early too early and people are going to complain about everything. JavaScript's moving too fast or it's moving too slow. It's hard to like have a handle over the communication over any of this stuff.

[40:25] **Shawn**: Communication is important. Once you have a process with doing a thing, but then you also have to communicate it well.

[40:29] **Shawn**: I guess that's like where I'm sort of specializing because that's kind of my day job. But I think a lot of people maxed themselves out doing the code, design, and docs and stuff.

[40:40] **Shawn**: And then they don't think about the marketing and there's actually a lot of marketing to do in tech.

#### CSS 4: Does It Even Matter if No One Knows?

[40:45] **Henry**: Yeah. I was just thinking, we can add a bunch of features. And then you write a blog post about it and then nobody knows about it. And then a few months later, you're just talking to someone like, Oh, I didn't know that this was the thing I could have used it a long time ago. Like the fact that it's been there for years, it doesn't matter.

[41:01] **Shawn**: So two interesting antidotes. One supports this idea. One refutes this idea.

[41:06] **Shawn**: Okay. So the first supporting idea is this idea of CSS 4.

[41:10] **Shawn**: Do you know the CSS working group and the transition from 2.1 to 3?

[41:14] **Shawn**: So there was CSS 1, which is the original spec or whatever, then CSS 2 and 2.1, cause 2 made some mistakes.

[41:20] **Shawn**: And then CSS working group kind of like got together and said like, Hey having like these big specs is a lot of work. Like we should break out into smaller groups and then work on individual specifications for individual features.

[41:31] **Shawn**: So Grid was a separate feature. There's like CSS for voice there's CSS for more media queries and user preferences and all that. They're all these like small little, tiny groups. They splintered from one big group to individual groups.

[41:44] **Shawn**: And then they were like, we will all move at different paces. So this is CSS Grid Level 1. And then this other thing we'll have like Headings styling Level 4. And we'll just proceed at different levels.

[41:57] **Shawn**: So there actually is no CSS 3. It's just this marketing term that everyone got together and said like, here's the.. I don't even know what was in CSS 3, but here's a nice logo and everyone can upgrade their sites to CSS 3now, because it's also in line with HTML 5 and JS.

[42:13] **Shawn**: You know, those like shield things like HTML, CSS, all the numbers, right. That was like a cool, coordinated thing just to get everyone to upgrade to modern tech. And it wasn't that modern either.

[42:24] **Shawn**: And then the CSS working group was like, okay, we're done now. Now we expect you to keep watch on every single movement going on in each of our working groups. We'll just release it in separate cadences.

[42:33] **Shawn**: Which like is great for them, right? There's this tendency of maintainers to optimize for themselves and then just like completely screw it on how the external image looks. Which by the way is my problem with monorepos.

[42:45] **Shawn**: But then it just became like, I know that all these things are going on independently, but I can't keep track of them. So I'm just not going to use them ever. So they have this problem of exactly like you said, they had new features and nobody was using them cause they don't know it's ready yet.

[42:57] **Shawn**: So now, after like probably five years of denying that there was a CSS 3. Now they're saying let's actually have a move back to market ourselves as having a CSS 4, even though it's not actually going to exist, we're just going to lie to everybody and call it CSS 4. And Jen Simmons is leading this charge.

[43:15] **Shawn**: And two years ago she was like making videos about how there is no CSS 3. And so like, there's been a huge 180, purely because of marketing reasons. Just to get people to use CSS the way that its intended. They realized that, Oh, we over adjusted on how CSS is run, but not on how it's marketed and super interesting stuff.

[43:37] **Shawn**: That's a tech marketing story that like I like telling now, cause it's super cool. It's CSS, man.

#### Adoption Curves: Focusing too much on the head

[43:42] **Shawn**: So the other narrative that kind of goes against it. So it's like, okay. Design things to make it easier for the general public to consume, right. Because at the end of the day, that's what you're consuming them for. You're not consuming for the kind of people that goes to CSS conferences and know the intricacies of your spec, right.

[43:59] **Shawn**: That's not the kind of people that you want to reach. I mean, sure, you want to reach them first, but if you want real impact, you have to reach for like the person on the street who has like five minutes out of every year to care about CSS.

[44:10] **Shawn**: So then we get to Ilya Grigorik.

[44:11] **Shawn**: Do you know this guy? He wrote high performance browser networking. I've never met him, but he likes seems like a legend.

[44:17] **Shawn**: Anyway. So there's this like, you know, adoption curve in the population.

[44:20] **Shawn**: There's the head. There's the fat body. And then there's the tail, right.

[44:24] **Shawn**: And the kind of people that go to conferences are the head. The kinda people that spend their free time arguing about progressive web apps on Twitter are the head.

[44:31] **Shawn**: You know, we just talk to the head all the time, right. And then we have all these like fancy benchmarks and shit.

[44:37] **Shawn**: No one cares in the body and the tail, right? So we can create all these like really awesome feature lists and stuff.

[44:43] **Shawn**: No one cares.

[44:43] **Shawn**: No one's gonna use it until you simplify it, right. Like make it easy for them to use it. Cause they have other priorities that that is going on.

[44:49] **Shawn**: Like we are in the body and the tail in others areas of our lives, right. Like I don't know, finance and the climate. And then I dunno. Yeah.

[44:56] **Shawn**: So like, you know, we have to be humble and get out of our heads and just make it easy.

[45:00] **Shawn**: And for him it was like, okay, even a movement like CSS 4 is not enough. Because that means that implies that people have to know about CSS 4 and you've got to go reach out to them.

#### Removing the Learning Curve with Better Defaults

[45:11] **Shawn**: What's even better as far as he's concerned, is to do it for them, right.

[45:15] **Shawn**: His example was image optimization.

[45:17] **Shawn**: You can do conferences about image optimization. Hey, run your thing. There's like this SVG optimizer. And it's like 30% smaller. And everyone should do that.

[45:23] **Shawn**: Then you just like do nonstop lectures and like build, build tools.

[45:26] **Shawn**: And people still won't do it, right. They just won't.

[45:29] **Shawn**: So it's kinda. It's very depressing. Cause like any learning curve is bad.

[45:37] **Shawn**: And so for him it was like, this should be built into the platform. For him, it happens to benefit him, cause he works on Android Chrome.

[45:45] **Shawn**: Let's just like have native inputs that just optimize the image when you upload images and it would just be optimized forever, with no code. Cause it's at the earliest point of entry.

[45:55] **Shawn**: And he was like, we need to find things like that, that will really reach the body and the tail because they don't even know. They don't have to know.

[46:02] **Shawn**: We've made it simple enough that we don't tack on this universal tooling that all developers have to like learn and maintain and use, because we don't fix the things at the source.

[46:13] **Henry**: Yeah, no, that makes sense. If you don't need that feature, it should just be a default. Like that's just how it works and it doesn't even need to have a name or a concept, but then you have to figure out how to do that, I guess.

[46:25] **Henry**: And especially if it's like with the tooling, you have to make a breaking change. So, yeah, it's hard to find a trade off.

[46:33] **Shawn**: Yeah. I don't know either. These are all super new ideas to me. I just think they were fascinating. Cause I'm always looking for like, what's the paradigm shift that will just invalidate everything I'm using today.

[46:47] **Henry**: No, that's true, we're always adding. I want to remove config, not add more or at least make it so that the..

[46:53] **Henry**: What do they call it, incidental complexity versus essential.

[46:57] **Shawn**: Fred Brooks. I need to read that book.

#### Philosophy of Technology

[46:58] **Shawn**: There's so many great books. What's a great program.. You know, you read way more books than anyone I know, what's a great programming book and just like philosophy of programming or like history of programming.

[47:08] **Henry**: No, I think that was good. I mentioned this a long time ago, but programming as theory building is like an essay. It's not really a book.

[47:16] **Shawn**: Yeah, that's fine.

[47:16] **Henry**: It kind of even goes back to what you were talking about, almost life cycle of code, you know, like life and death, rebirth, if you want to use that metaphor of programs. Just thinking about people and how they relate to code and the fact that it's about mental models and stuff like that. I hadn't been reading too much about like philosophy of code in that sense, but that was the most that I've seen for that kind of thing.

[47:41] **Shawn**: Yeah. Do you think developers care? Do you think were like married to incidental complexity? It's like, we're paid to do that, right? Okay, I'm glad they're shitty tools because then you need to hire people.

[47:54] **Henry**: You keep the job. I guess they're both true. No one's like intentionally be like, "Oh, I'm going to make a tool that's hard" or anything. That that would be weird.

[48:01] **Henry**: But I think you kind of get used to how things are and how we see the things. Like our answer is the tool.

[48:09] **Henry**: Maybe another book would be Tools for Conviviality. People mentioned that one, a lot.

[48:14] **Shawn**: I've heard that one. I need to go look into that.

[48:17] **Henry**: Yeah. He's really talking about like technology in general and the idea of tools.

[48:22] **Henry**: He would differentiate tools where someone designed something specifically for someone to do versus sort of like a hammer where it's a tool where you can almost create your own ways of using this thing that the person that made it didn't even think of, right.

[48:38] **Henry**: How do you create a tool, sort of like the web it's supposed to be, right? Like supposedly anyone should be able to make their own website, but then we create all this tooling so that you have to learn it and you have to go to school or you have to go to bootcamp.

[48:51] **Henry**: In a sense he's actually arguing against like professionalization of anything, to that extreme. Or industrialization of things.

[48:59] **Henry**: Because that makes things very the same, like everything is a product.

#### Spatial Software, The Mind

[49:04] **Henry**: Have you heard of Dynamicland?

[49:06] **Shawn**: Yeah, Bret Victor's thing right?

[49:09] **Henry**: Yeah. I think for a lot of people, it seems too far off.

[49:12] **Henry**: There's a picture of a bunch of kids learning in school and they're all in a circle on the table and they're all looking at like a tablet or a laptop instead of they're all looking at the same shared space.

[49:23] **Henry**: Actually I see this now with the zoom, right? Like we're all looking at windows of people's faces. And then now seeing how people are trying to create more like spatial software is really cool.

[49:33] **Henry**: Almost like games. I've seen some demos. Being able to like move around in a space. And that kind of gives people the freedom to do things differently.

[49:42] **Henry**: Like with Google docs or Figma or even actual games like Animal Crossing and Fortnite. People are able to create something different cause they have a platform for it versus you can't do anything other than like, screen share and chat.

[49:54] **Shawn**: Sounds like you want to go into VR.

[49:56] **Henry**: I think that barrier for that just having to buy that and being expensive, you have to have another computer, you have to like wear something. I think that seems a lot far off to me than just like, at least starting off with something 2D.

[50:09] **Henry**: I dunno, like one example I saw. If say you have like a stand up or something and you want everyone to like, talk about what they're doing in a zoom call.

[50:16] **Henry**: Like everyone's face is in a different place. You can't even have an order to it, but if you're in a 2D space, you could make an actual circle and then you could just be like, Oh, let's go counterclockwise or clockwise. Just like in real life.

[50:29] **Henry**: I think that presents a better way of knowing where people are sort of thing in this virtual space versus just abstractly everywhere, right?

[50:37] **Shawn**: It's good. We kind of have that in Figma. I don't know if you play around with Figma. Like this idea of cursors that represent people. Then people can kind of move around and communicate.

[50:45] **Shawn**: We can even express like frustration with like our mouse movements, which is pretty cool.

[50:50] **Henry**: No exactly. I think it's fascinating seeing how people..

[50:54] **Henry**: You give them the freedom or just ability to kind of express themselves.

[51:00] **Henry**: Even with like the card game, where they can hover over the cards. And if you do it really fast, you can tell how they act.

[51:08] **Henry**: Actually, this reminds me of the game that I was playing a lot in-person of The Mind, which I liked.

[51:14] **Henry**: I don't know if I even talked about that before. I wanted to write something about this, but it's a very simple board game.

[51:19] **Henry**: It's just, the cards 1 through 100 and you need to play them in ascending order. It doesn't have to be one, two, three, but like 1, 10, 23.

[51:28] **Henry**: The catch is that you're not supposed to talk. So you can only use body language. And this is like an in person game. You're all in a circle.

[51:36] **Henry**: I actually played this at a lot of conferences. Just brought it in. It's very simple to learn. You just have to play the cards in order, but you don't know what other people's cards are and then you can't say I have three, so you just have to have sort of like an internal clock.

[51:49] **Henry**: And the spirit of the game is you're not supposed to like count or anything or come up with signals, but use body language.

[51:54] **Henry**: If someone is leaning backward, you know that they're probably not going to go. If they're like kind of hovering over it, they're probably wanting to go next. You kinda just have to go with your gut, right.

[52:02] **Shawn**: Yeah. And you have to learn and adjust for people who are too timid and too aggressive.

[52:08] **Henry**: The game is interesting because it helps you empathize with others and it's a cooperative game, right? We're all on the same team.

[52:15] **Henry**: Oh, this person went too fast. This person went too slow. It's hard to say. They're both true, right?

[52:20] **Henry**: Like the person that was too fast has to learn to like account for it. The person that's going slow should learn to be faster.

[52:26] **Henry**: And then the fun thing is when someone else is around and like, Hey, you should join in. And now that person changes the whole dynamic of how the timing works, right.

[52:35] **Henry**: And you're only supposed to play with like four people max. And at the conference, you know, there's like 12 people or something.

[52:40] **Shawn**: that was a good game. You brought it to React Rally and it was a lot of fun. Psychic.

[52:48] **Henry**: And it's funny cause people are like, Oh, that's some kind of cult thing, you put your hands in the middle, and say the mind, right?

[52:54] **Henry**: When we all put our hand in the middle, it's just to say that the timer starts now, but it's not like you're literally counting in your head one, two, three.

[53:00] **Henry**: I don't know, like how do we create that sort of thing online?

[53:03] **Shawn**: I mean, it's interesting that we care a lot about jumping between physical and virtual presence. A game is a very small community.

[53:11] **Shawn**: I think we always figure things out first in games, and then we bring it out to the rest of society, you know?

[53:20] **Shawn**: I always think about how game tech is always so far ahead of everything else, right.

[53:24] **Shawn**: But it's good.

[53:24] **Shawn**: Cause like, we pay for entertainment and entertainment eventually benefits us.

[53:29] **Shawn**: So you can say like when you're playing your Xbox or your Switch you're funding R&D!

[53:37] **Shawn**: Basic science. Yeah. When you buy smartphones, we are funding research into making the smallest chips and most power efficient chips in the world, right.

[53:46] **Henry**: Yeah. Just the way people think about interactivity and design.

[53:53] **Henry**: One of the problems that we have with tech is like the idea of presence and immersion and participation, then I think involving the person more is a good thing, sort of passive consumption, right. I think games help with that.

[54:06] **Henry**: I mean, a lot of times it's very trivial, right. You just kind of clicking on things, but how do we make it so that something real is happening there.

[54:12] **Henry**: Going back to open source, it's like, I don't know.

[54:14] **Shawn**: Emojis are good.

[54:15] **Shawn**: I think I was actually reflecting that probably one of the best ways of expressing without plus one everywhere is emoji. People can express a lot of things with just like five or six, whatever they give us.

[54:26] **Henry**: I guess even pictures of memes, I guess that's why people like those.

[54:31] **Shawn**: it says a lot

[54:31] **Henry**: Instead of just like typing out something like good job. That's interesting.

[54:38] **Shawn**: Yeah, cool. I mean I appreciate you having me on. We always have good chats.

[54:41] **Shawn**: And it can ramble, but I think we all like are exploring these interesting ideas. And they're all kind of related and we're just kinda mixing them up, you know?

[54:48] **Shawn**: So yeah, thanks for having me on.

[54:49] **Henry**: Yeah, thanks Shawn!
