---
title: "MA 7: Philip Gee On Growing Old with the Web"
season: 2
date: "2019-05-31"
time: "64"
description: "Do we learn in a vacuum, or does it involve our whole selves? Philip Gee (UC San Diego) joins Henry to chat about maintaining a web presence since its beginnings. We discuss some of the points made in Nadia's post on ideas carrying us forward, even beyond what we are known for, the greater intimacy of podcasts and vlogs, attaching ideas to people, science as subjective vs. purely objective and in community, knowledge as opening up possibilities, embracing whimsy and being random (haircut podcasts), embracing spontaneity and cities, understanding our bodies and mortality and it's relation to our digital lives and rest."
episodeLink: 3dc07d32
embedUrl: https://share.transistor.fm/e/b4d35677
sidebar:
    order: 7
---

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-2/growing-old.md)

[00:00] **Henry**: All right, today I have with me Philip Gee. I don't remember how we first got in contact, but I actually heard of you a long time ago because my roommate in college, I think he read your post about doing a PhD or something like that.

[00:20] **Philip**: And did he do a PhD, or did he ...

[00:22] **Henry**: Yeah, he did. Well, I guess he's about to graduate, but he's at Purdue. He's doing chemical engineering.

[00:31] **Philip**: Nice.

[00:32] **Henry**: Yeah. Thanks for joining me today.

[00:34] **Philip**: Yeah, yeah, this is really fun. I've listened to all 4.5 or whatever of the ... This is the fifth one, I guess. Is that number five?

[00:45] **Henry**: Mm-hmm (affirmative), yeah.

[00:45] **Philip**: Yeah. I listened to most of them. I mean, I didn't get through all of them because they're all super long.

[00:51] **Henry**: Yeah.

[00:52] **Philip**: But, yeah, I feel this massive impostor syndrome now.

[00:56] **Henry**: Really?

[00:56] **Philip**: I'm not nearly as epic as any of these people you've had on before. So all right, number five. I've got to think of something cool to say. Because you've had some pretty epic open-source people who are big in entrepreneurship and open-source in communities and such, and I don't have any of these credentials.

[01:18] **Henry**: Well, I mean, I feel like you have a lot to bring to the table. This podcast is not ... I guess I didn't want it to be just interviewing open-source maintainers, but anyone that stewards some kind of community, or just cares about something and does it for a long time.

[01:36] **Philip**: Yeah.

[01:36] **Henry**: And, I think you definitely do that. We talked earlier about this with Michael, his episode's about getting old in open-source, but then you were like, "Oh, what about getting old online, on the web?"

[01:49] **Philip**: Yeah, getting old on the web. Maybe that's the title, getting old on The web.

[01:54] **Henry**: You do a lot of stuff. Even though you just said you're not I guess, that prolific. I mean, I was just looking through all the papers, and the vlogs, and the podcasts, and there's so much stuff. I don't even know how to prep for talking with you, honestly.

[02:11] **Philip**: That's the fun part, you don't have to prep. I think we'll just go. I will try to, okay, maybe I'll guarantee this is the most random one. Maybe that's it. I'm looking through the bios of the four you've done so far. All right, I think my strategy here is I have to just be the most random.

[02:31] **Henry**: One thing that, since we were talking about getting on the web, I think we both liked Nadia's post on ... It was the tyranny of ideas.

[02:42] **Philip**: Yeah.

[02:43] **Henry**: And, so I was thinking that the best next thing to recording a podcast with Nadia is just talking about her work on the podcast.

[02:51] **Philip**: Yeah. That could be a drinking game, or you can drink non-alcoholic drinks because I did a podcast with this guy Shrini. I haven't posted it yet. He's a data science person at a startup. And, we were originally going to talk about Nadia's independent research, very popular independent research blog post, but we didn't end up talking about that. But two-thirds of the way in, he mentioned some Nadia other post. It's like a drinking game of how long can you go before you mention one of Nadia's blog posts? You just made two minutes, and then we already gave up.

[03:30] **Henry**: I guess it resonates pretty well, this idea that people have ideas, and we traditionally associate them with a person. But sometimes, the ideas that you have kind of take on a life of its own. And, she gave the example of, people might know you for certain things, and then you might want to do something different, and then you feel pressured to continue to do the same thing.

[03:58] **Henry**: I think she used the example of Lil Wayne or something, and then doing rock music instead of rap, or I don't know, Kanye doing whatever he wants. And, this idea that you kind of have to ... Like people expect you to do the same thing as before. I see the same thing with me, where it's like, if people know me through Babble, then you're the Babble guy. Or people are like, you got to write code. Then you're doing ...Well, and I think if you wanted to, that's totally fine. There's an alignment there. But I think it's when it gets out of alignment, where you want to do something different, but you feel like you can't, because you're trapped. You wanted to originally, and now you want to do something different.

[04:42] **Philip**: Yeah. Yeah, I mean, I relate to that a bit because, thinking about ... Or, I guess, I have these notes here that you sent me, that I didn't look over until now. But one idea is this idea of maintaining a web presence, or this getting old on the web. You know, I've had a website, a personal website, up since '97, which is 22 years, right? 22 years.

[05:08] **Philip**: And the web, early people probably had a website in '95, right? So, I'm saying, I'm pretty old in web years, because I remember the beginning of the web, right? In the very first few years, no one had it except if you're an academic or in a science lab. But I would say, 1995 was probably the time when companies started going online, right? '94, '95 was when companies started to go online, and I went online '97, so it's been over two decades, and kind of seeing my web ... What I want to do on the web evolve over time from purely personal stuff. So, my website started as just photography stuff, you know? I just liked taking pictures, doing Photoshop stuff, just whatever, just putting it online. I mean, this is before all these photo galleries. I'd just use it as a gallery. And then, it got into more writing, and then my website morphed into more of an academic webpage as I got a job and became more of a ... Building up my career as a researcher and as a professor. And in the last two years, maybe this is a Lil Wayne thing, whatever, the last two and a half years, I just went straight in into video.

[06:16] **Henry**: Right.

[06:16] **Philip**: I'm just like, "Forget all this writing. I'm just going straight into video 1000%." And I did feel some of this, you know, Lil Wayne or Kanye or whatever thing, because people knew me from writing, from both long-form writing and blog posts and research papers and stuff. Then this video thing, especially if you're in academia, it's like, who does random vlogs where you're walking around, right?

[06:39] **Philip**: Or even the podcast thing, where you're talking to people. That's just not something that, quote-unquote, "Serious academics" or serious professors or researchers do. And then I'm just like, "I'll just do it." Because I didn't ever feel that weird about it, just because I knew that 10 years ago, or 15 years ago when I started writing a lot online, that was kind of a weird thing to do, because I was supposed to be coding, right? I was a computer science student, and I was supposed to be writing code and you were supposed to be proving yourself via code, right? And via all the very macho code culture stuff back then.

[07:14] **Philip**: This was way before GitHub, right? I mean, this is free software, kind of the ... You know, people read Richard Stallman essays and stuff, this is like Richard Stallman essays and early Paul Graham essays back in the super early days. So, like it was very much this kind of macho code culture, and I was very much into photography and writing about non-code, right. A lot of my writing is non-technical, totally not about code at all. It's totally not about code. So, that was kind of a disconnect from what the expectations were. But then, after I did it for a while, I just kind of became known implicitly as a person who wrote about a lot of this stuff that's not code, and that became normal. And then, three years ago, when I switched to video, that seemed weird, because it's like, whoa, this vlogging thing, or these podcasting, this is for like ... You know, these are what kids do, like serious "Serious adults" are not doing these things.

[08:10] **Philip**: But I'm like, "Oh, let's just try it and see, and just run with it." And, I've just been really happy with pursuing this new format. I still do write stuff, obviously, but I've put a lot more energy into video just to explore that format. So, I guess there has been that change from text to video, and I felt pretty good about it so far. I mean, a big thing is, I don't need to make my living off it, and it's a hobby, and it's also like my identity isn't as much tied up into it. So, I don't have as much of that inertia or that guilt, or such. But that was just what I thought of when you reminded me of that article.

[08:46] **Henry**: Yeah. You don't have this need to have to make a new profile, or feel like you're pivoting or anything. It's just, this is a consistent movement that you've already done over the last few years of going from the white website with photos, and then writing, and video. It doesn't seem like that off, I guess.

[09:07] **Philip**: Yeah. I mean, there are pivots, yeah, and it's all, in terms of the identity thing, I don't have separate websites, right. I don't have pseudonyms, I don't have the separate persona, it's all just on my website. Which does make it kind of messy, because there's so much stuff on it. The most elegant thing is to have maybe separate presences so that each one is a cohesive unit. But just for simplicity's sake, and for discoverability, I just put everything in one place. So, it does make it more scattered, right? That's why I'm saying I hope to win the most random podcast episode. It does seem scattered, right, because I mean, literally, if you go to my homepage now ... I can read it to you. If you go my homepage, the homepage is a very academic one because the landing page, it's mostly professional, so it's targeted toward academics, and an academic audience, which was a conscious decision a few years ago. Because, after I got my first job, I needed to build up my career, the home is the academic home, so it's more academic.

[10:06] **Philip**: But then, the tabs are, you know, there's publications, there's all the PDF's of papers, which is very professional. There's summaries of papers, with blog posts that talk about research. There's a vlog section, I have over 300 just, usually, 10-minute videos of myself talking. There are podcasts, which you've been on, those are usually 30 to 45 minutes of one-on-one. Then there's a podcast hour, which is, my friend and I just do a regular thing, just the two of us. We do it every month, or whenever we feel like it, and just kind of shoot the breeze.

[10:41] **Philip**: Then there's the articles just hundreds of essentially blog posts. There's a category tab on the right, with labels, and they're pretty random. It's basically just whatever I feel like writing about, or making a video about, and it's pretty random. So, yeah, there's a lot of stuff there. More can be done to make it more coherent and discoverable and everything, but I'm a big believer in just putting content out there and just putting stuff out there, if it'll be remotely helpful to some people. Not everything needs to appeal to everybody, that's the other theme, right? The nice thing about piling everything on is that if a very small subset finds something useful or inspirational, it's great. 99% of people are not going to care about it, that's fine. Storage is cheap, right? So, it's fine to have it out there and people can search an index it how they want.

[11:33] **Henry**: Yeah, I always find like the more weird or unique the thing is ... I don't know, it makes it easy to want to engage. And, I think even though, so we were talking about this idea of like the ideas becoming the thing rather than the person. But I also find that if I'm interested in something that someone is good at, or whatever, an expert in. Specifically, I might go and learn more about what they're about because I care more about the person rather than that specific thing I found them for initially.

[12:05] **Philip**: Yeah, I think so. And, I think that the video stuff actually really helps with that because I was really thinking about, given your learning the exact same thing I imagine like ... I made a video on this, I made a video on everything. Imagine you spend 10 minutes watching a vlog on something or you spend that same 10 minutes just reading an article, a blog post about it. Same exact content, exact same content, I just think the videos' interesting because it give you a peak into that person, right. You can see how they talk, you can see little asides they make, where they're walking around, what their background is. It's like the closest approximating being there with someone and someone just telling you short story, right. Whereas if you're reading it's very sterile, it's very cold, it's very impersonal. It's almost like you're reading a book, you're reading in a different way.

[12:53] **Philip**: So if you watch 10 vlogs of me, or listen to podcasts, one of the phenomena that I see ... Like when I listen to people's podcast, there's this professor, Roger Pang, he does ... He has two podcasts. He kind of inspired me to do podcast because he's the more senior professor, and he has one podcast about life in academia. He has another one about data science. And both of them, he has a stable co-host. Like each one is two people always hosting. It's funny because I've listened to so many hours of him talk that I've only talked to him like three times in my life, but whenever ... I had him on my podcast then I talked to him about some research stuff. It turned out one of the students who used to work with him at Johns Hopkins, where he works. He became one of my PhD students, and we talked about that stuff. So it's a lot of this informal networking.

[13:46] **Philip**: The upshot is when I talk to him, I felt like I already knew how to interact with him because I've heard him speak so much, where I know his mannerisms, I know how fast or slow he talks. I know what he responds to, so I think it'll be very similar if people are listening to podcasts that we're on. Same with you, right, like before I did a podcast with you, I watched a bunch of your talk videos and listened to some podcasts. So, I knew exactly what you sounded like and your mannerisms and stuff, right. And so, I think that's such a big benefit versus reading, because if you read, you have no idea what someone is like. You know, you might get some sense by how they write and what they choose to write about, but you're often surprised when you see them in person. You're like, "Wow, you don't sound like what I thought you sound like on paper."

[14:30] **Henry**: Yeah, and I guess that's just a result of the medium. Like, I don't know, when I think about ... If you're going to read a whole book, it's like they spent a really long time going through that, versus like a vlog, it's just more like off the cuff. So, I think it depends on the content and how much time [crosstalk 00:14:47]-

[14:46] **Philip**: Oh yeah, yeah. Of course. I mean, there was obviously you'd want to look for. Yeah, you don't need to do everything on video, but I'm thinking how far can you possibly push that format. I think it's farther than most people think, right. Most people's gut reaction, especially people my age or older, the gut reaction is, "Oh, I don't want to watch a video, I don't want to listen to something. I'd rather read because I'm in control of it, I can skim it, I can go fast. I'm a fast reader, I can store it and stuff", all the usual thing which are true because people are used to reading a lot. But, I think that once they start experiencing video or audio as a format, it could be quite addictive I think.

[15:24] **Henry**: Well, how do you decide what to even talk about? Is it just that you were thinking about it? Because, that seems to be the only way I can do things, where it's like if I don't do it right when I think about it, I'm probably not going to do it.

[15:39] **Philip**: Yeah, yeah. I think that's basically it. I think that's right, I think exactly what you said which is, I think if you set up your environment in such a way that that gulf between your thoughts and your actions can be minimized and that's the awesomest thing, right? So, that's ... You know, in kind of classic user experience, or even computer action terms, they call it the gulf of execution, so like this is the classic [inaudible 00:16:07] and the design of everyday things. The gulf of execution is I want to do something, how do I do it? So, if you have a bad user interface, it's a huge gulf. It's like, oh, I want to like move this file from here to here. I'd have to click this thing, I have to like do another menu, whatever. But, if you just drag and drop it's like much easier. So, I think it's the same idea that being able to capture your thoughts in the moment. So, for some people they just write notes on their phone. For myself, I just pull my phone out, I have a little lapel mic I just put on and I can just start recording these videos that are just 10 minutes long. You know, bigger things, longer form writing, research obviously is ... It takes more time to incubate, you don't just think of it overnight.

[16:48] **Henry**: But, that might be a result of that, right. Like, doing those small conversations with yourself, leading to greater [crosstalk 00:16:55]-

[16:55] **Philip**: That's right. I think, just taking plenty of notes, like I read somewhere ... I mean, this is all apocryphal, but somebody said, you know, claimed, unsubstantiated claim that I believe in because I do is that people who come up with [inaudible 00:17:09] ideas, they're avid note takers, right. Like, they just right down everything, they just jot down things. And, I would like to believe it's true because that's what I do. But I think there's some truth to it because you're externalizing these thoughts out, right? And, you're prototyping, you're writing them out and only when you start seeing it on the whiteboard, or on your notes, or in your Google Docs or whatever, you can start seeing the shape of things. That's why like, if you see my office, or any set up I have, my home office. I think you see a bunch of podcasts and vlogs with me in my home office, it's just I have several huge whiteboards at home. I have several huge whiteboards in my office. You see San Diego, my faculty office, I have huge whiteboards and like lab space because that's just what you do. You just put up the thoughts there and then they you start ...

[17:54] **Philip**: You know, you stare at them and you write more, and they start molding into really coherent things. And, it's a magical process, but like I just can't imagine holding that all in and not externalizing it. Like, I just can't imagine how that would work.

[18:08] **Henry**: I feel like I've been dealing with this recently. It's just frustrating because you're like ... You know there's something there, like you have this initial thought, but then it's just like, I don't know, I guess self censorship. Like, you don't want to go there for some reason, even though you kind of do, and then how do I get myself to actually write it down? I was talking with my friend Devon, she just has like a voice recorder, like just-

[18:31] **Philip**: Yeah, voice recorder-

[18:32] **Henry**: Like walking on the street or whatever, just talking to yourself.

[18:34] **Philip**: Yeah. Yeah.

[18:37] **Henry**: But, I guess because I'm not used to it, I don't and I just ... Everything's in my head and it's like until I don't know, something happens where I feel like I have to do it, it doesn't normally happen. And, like I think building that practice of writing it down, or even just like asking questions if I want to go in a different direct, like sometimes there are things I want to know about but I almost feel like my mind's blank. I don't have any ... I not like curious enough to even go there.

[19:05] **Philip**: Yeah. I mean, the holding in your head, that may not be bad either because I think this idea of holding it in your head is not bad because, you know, if it gets ... Weighs heavily enough on your mind, then you will be motivated to get it out somehow. And, by that point it's already been turning so much that it's like you're forming a diamond, or a pearl, or whatever in your head.

[19:28] **Henry**: Yeah, I guess it's just how it comes out. That's true, like if you're thinking about if for so long, like I was thinking about the talks that I give, all the talks that I give are pretty non-technical, just in the context of whether it's open-source or not, and I don't really have to prepare anything because I'm just talking about my life. You know, you just have to remember through looking at certain slides and stuff like that, and I guess it's the same way, like I could go up there with nothing and I guess you could talk for a long time too.

[19:58] **Philip**: Yeah, yeah, I think so. I think this kind of improvisational skill is ... You know, I think the main constraints there was time, right. So, after doing this for a while, like both the podcasts and the vlog, and just me public speaking a lot. I mean, I give lectures, that's my job, right? I teach, I'm usually teaching classes. So, serval days a week I'm doing public speaking essentially, right. I mean teaching stuff and then I'm giving talks and stuff. And, one thing that I've gotten a good amount of experience in is being aware of time. Right, so like, if you know that you have only five minutes to tell a story, then you just tell it in five minutes. If you have only one minute, you tell the one minute version. So, you know, I think that's something that's just built up through experience.

[20:44] **Henry**: Going back to the idea thing, I almost want to challenge this idea of like, do we want to be able to separate ideas from people? Because, I feel like all the context from where an idea comes from, like I want to know how they come up with it and almost like this kind of metadata around-

[21:00] **Philip**: Yeah, I like the idea of [inaudible 00:21:03]. I like the idea of attaching it to people, or to groups of people because, like you're saying, then you can start investigating, what else are they doing? Because they must be, you know, kind of people who are creative, they must be doing related projects, or they must have done something related in the past, right? So, that gives you this web of knowledge that you're like, "Oh, I want to look into where were they when they did that". Right, they were at a certain company, or they were at a certain university. Who else were they hanging out with and what did they do, right? It's this very organic network, all right. And, I think that's right, that ideas are not just [crosstalk 00:21:38], it's embodied from people, yeah.

[21:40] **Henry**: Like, I think it's when something gets popular, it's easy to go off in different directions, but ultimately, yeah, it comes ... I guess I like the idea that it is attached in some way, and I guess this goes into like ... I was reading into the guy I mentioned earlier, Michael Polanyi, and how ... Not that ideas are attached to people, but more like ... His book is called 'Personal Knowledge', that knowledge that we have, doesn't necessarily have to be objective in the sense of like verifiable. But even as a scientist, when he did research, you're applying what you know based on everything that you've experienced.

[22:20] **Philip**: Yeah, yeah. And, taking it one step even farther. So, this idea ... I haven't read this book, but I think, from what you described, it's this idea that we are bringing our whole person into our work, right? That you know, as researchers, or as artists, or designers, you know, people who are doing generative work. We're bringing ourselves into it and that's what makes us hopefully have unique and novel work, because of our life experience and such. And, it's like it's very hard to drop someone else in to do the exact same thing.

[22:54] **Philip**: And, upping up one level farther, this guy Bruno Latour, he had this New York Times article, profile about his life's work and he is kind of socialist, an anthropologist. But, instead of studying, you know, animals, or animals socializing, or children socializing, whatever, he actually has spent many years studying how scientists work together in labs, right. And, in field work and in labs. He basically studies anthropology and the sociology of how science is made. And, he has these really detailed studies and theories about ...

[23:32] **Philip**: Basically, his big thesis is that doing scientific research which we feel as something "Really objective" and very like ... These are cold, hard facts about the universe we're discovering, it's quite subjective and social, and socially mediated experience based on the people involved, their power dynamics, their relationships to each other. All these interpersonal things because, you know, science is done by people, and it's done by teams of people. I mean, it's done by people who need to get funded, people who need to rise in political power. And, it's like we've had these stories of dominant scientific theories dominating because of strong personalities and funding, and secondary theories not really getting the ability to shine because that wasn't the dominant paradigm. And then, those older people, they kind of fade away and then a new kind of paradigm comes up and stuff. And, it's extremely social. You know, it's like memes and everything, even in this area, as in like the physical sciences that you feel like, okay we're just discovering objective truths about the universe here. Come on, it's not supposed to be art of whatever. But, he very proactively shows that even the most "Objective" thing we do, it's so socially mediated and subjective, and subjected to all of our biases and whims, and inter group relationships and everything.

[24:55] **Henry**: Yeah, I think that aligns exactly with what Polanyi says. Like, it's funny that we live our lives caring about relationships, whether it's family or friends, and all that stuff. And, for some reason, when you're in the lab you want to not be a person, and like to be objection. And, somehow just trying to detach that kind of thing and I think it's even the same with ... Even is [inaudible 00:25:20] and work, and it's like you feel like we have to dichotomize everything. But, it's like, maybe it's because it's so hard to bring it together and like holistically live a life that has all these different aspects of ourselves and our values and stuff like that. And, we don't want to-

[25:37] **Philip**: This is a part of a hope in source episode, you know, appendix episode. You're transitioning into [inaudible 00:25:42], totally a cross ... Yeah, I listened to that whole series too. See, I listen to all your stuff.

[25:47] **Henry**: Thank you.

[25:51] **Philip**: I listen to all your stuff. Yeah, yeah. Yeah, I really like that series, the hope in source series. Yeah.

[25:56] **Henry**: I guess, even off of that topic, I think something I like that he said was about ... Because I was reading in some more of ... Like, I saw this other professor, it's like Esther Meek. She's a philosopher and she interpreted his work in a more faith related way, and I think her book was like 'Contact with Reality'. He talks out like, how do we know what is real? And, his definition was something like, when you're able to see future potential opportunities or possibilities. And, what he means by this is that he has this concept, looking back a bit, called tacit knowledge, knowledge that you might not be able to explain, or understand within words, but things ... It's kind of like we know more than what we can say.

[26:46] **Henry**: And so, his example was people that can play piano, like some kind of music, or you ride a bike, but not being able to explain that to someone, teaching them. And so, in saying that, when you learn something new, it brings about in your mind ... It's basically insight and imagination into ... When you learn how to ride a bike, you see everything in terms of being able to ride that bike to all these different places in the world. Or, knowing how to program opens up possibilities for you. And, I think that's very positive versus just like, oh, I learned this fact about the world.

[27:22] **Philip**: Yeah.

[27:23] **Henry**: And, it closes in on the world, versus opening up the world.

[27:26] **Philip**: Yeah, that is really optimistic. Yeah, I like that idea that ... That's right, that have developing these core skills opens up new things. It pushes the frontier outward, right? Of what the possibilities of what you can possibly do. And, yeah, I totally see that. I mean, a more pragmatic view of this, given what we're talking about, is ... This is like very mundane, but this idea that, in my early days of making websites, it was all hand coded HTML, like everyone did. And, this was 2006 was when I started ... I basically made a static site generator, because I'm old, this was way before that was a thing. So, I was like, this is so stupid, I don't want to hand code all this stuff. And, I also didn't want to use PHP and just dynamically generate it. I mean, people had a database backed, side backed, right. You could use my sequel in PHP and be like, "oh okay, I have all my"... It's like WordPress, right? WordPress stock, all right. But, I'm like, this is so silly, and such overkill to have to host dynamic scripts just to view some static web pages.

[28:46] **Philip**: I think when I was hosting my pages at school, they had static hosting by default, right. So, you had to hand write your HTML, you could use PHP, or Pearl whatever, unless you got some special account or whatever, just for both security, and just for resources because it was like again, back in the Stone Age. So, that got me to think creatively. I'm like "Oh, I want to make something that generates my HTML for me". So then, I made a ... Essentially a static site generator, and the earliest one. I mean, I used Markdown. I think Markdown had only been out for like a year or two then, this was 2006. I think Markdown came out in like 2004, around then. And then, I used XML as the metadata, so I just kept all the tags, and all the categories or whatever in XML.

[29:26] **Henry**: Right.

[29:28] **Philip**: And, I ported that over to ... You know, all my source files are ... There is Yaml header, that's the metadata, and there's a Markdown body, which is like pretty standard. And, I just have a bunch of Python scripts I wrote over, you know, it's all crap, it's been like 15 years. Look at all these scripts that are just running every time I found my webpage. It's a long winded way of saying that when I got that ability to statically generate pages that were coherent, they had styling, they had labels, they had tags, had everything, that just opened up the doors for me to write more, right? Because, whenever I had an idea, all I would do is just I just sit down with my computer, I would just start typing on Markdown, which [inaudible 00:30:06] text I run to my Python script, and then I sync. I use this thing called Unison, but essentially it's like rsync, you just run it like an rsync command essentially, and it just pushes it to your server and you deploy it. And, it was like literally, I could write a new article and get it up at the speed of [inaudible 00:30:23] right. I'm like, "Oh, I want write something", then I stall today. Bim bim bam I'm right, run a script and it's up, right.

[30:29] **Philip**: And so, like that opened up a huge possibility. Whereas, I had friends who were like, "Oh yeah, I would love to like make a website", this was like what, the mid 2000s. They were like, "Oh yeah, that's cool", like you know, you're writing these articles about X, and Y and Z. I have all these ideas, right, it's like my friends are like, "Oh, I have these ideas about this and this, I really want to do this". But, it's just such a drag to get started, I don't know what I'm going to choose, do I have to like do this WordPress thing? And, like I have to set it up and it's like such a grind to edit in the web browser back then and stuff. And, people just don't do it because the friction's so high. So, by just building infrastructure, I mean, we can transition. By building the software infrastructure myself and having it being really catered for myself, it just pushed my friend outwards, so that I could basically write anything I want and push it online super easily.

[31:16] **Philip**: And, my last not on this is, I basically did the same thing with my video workflow, so like basically nowadays, all I have to do is record on my phone or my digital camera. I plug the SD card in, or I do wirelessly. I do a YouTube upload, and that's already on YouTube, so that's already good enough. I do a YouTube upload, that's good enough. But, if I want to also cross post it on my website and on like an iTunes podcast feed, I've got to have a script workflow. I run a script, it grabs it from YouTube, it rips out the audio, it puts the right metadata and it pushes it to my website and it pushes it my RSS feed for my podcasts. So, it's just so easy. So now, whenever I want to record an idea, I can record a video of an idea, knowing that it can be pushed on YouTube and pushed as an audio stream. Or, I can write an article and push it on my website, so like that just opens up a tremendous creative frontier because then I can just keep writing and making videos and stuff, right. It's not because I have any better ideas, or I'm smarter than other people, it's just that I've set up the infrastructure, so it's so easy for me to do, that I just do it more.

[32:23] **Philip**: And, that kind of gets to your point on your notes about, just how do you just produce more content, right? I think it's setting up the right infrastructure and environment so that, there's that gulf of execution is that small and that friction is so low.

[32:35] **Henry**: You have to build that base knowledge and so then the infrastructure ... But also, like not being scared of what people think and the feedback.

[32:44] **Philip**: Yeah. Oh, that's another one, we can get a whole-

[32:47] **Henry**: It's weird, like if you wrote it in your journal, like you're not sharing with anyone, you're still ... I don't know why, like it's that blank piece of paper, you're scared of recording a podcast because you don't like the sound of your voice, like all those things and it's like, how do we get ourselves to okay with that? Like, building that practice.

[33:04] **Philip**: Yeah. So, I have many thoughts on this. My first thought is that ... Okay, you have to title this episode like, growing super old on the web. Okay, this is going to sound like a super old, cranky guy thing to say. But, I basically grew up on the web without user generated content, right? So, there were no comments sections, there was no social media. When you published stuff on the web, the web was a static document publishing format. So, when you put up your pictures, when you put up your blog posts or whatever, in the early days, in the tech [inaudible 00:33:38] I read all the time. I read people's articles about Magic: The Gathering, or Doom, or Quake, or video games. It was all just static text, a lot of it was just like README files, or just simple HTML. You know, Usenet and forums have always been around, [inaudible 00:33:53] service and forums. There has always been a culture of discussion forms, but that was separated from the actual sites. So, all these years that I've had my website up, I've never had a comments section at all. I've never had a comments section, I've also, on YouTube, I just disable all the comments by default on all the videos.

[34:15] **Philip**: So, I've basically made it so that my public presence is a publish only static format, so that I don't actually have any of the modern things at all. And, I've found that, at least for myself, to be a big benefit and I encourage people who are getting started to adopt that, at least in the beginning because of that fear of comments and such. I mean, I obviously understand the role of them in building a community and everything. But yeah, that's just that path I've personally taken. I'm very happy to have taken that, and it's not because I had some master plan, it's just because one, I'm really old, and two, I never bothered to implement all those featured. I never bothered to implement commenting or integration with any social media or anything just because I just had a simple static website, I had nothing else on it, that you couldn't do anything on it.

[35:09] **Henry**: I mean, I think it worked out because knowing that that was how the web originally was, just publish only, you know, separate discussion form idea, like I feel we're moving back to that again. Like, everyone that has comments, they're trying so hard to get comments and then realizing they are so low quality that all of these sites are getting rid of them. And then, all of us are like, "Uh, we don't want likes and all these things now because it doesn't actually ..." Like, I think that we don't really want engagement, we want quality conversation and discussion. And, that doesn't happen in this weird, like async thing and maybe you want more of an in person type discussion, which is why maybe people like podcasts because it's more intimate and actual ... Like, you feel like there's someone on the other side rather than just like some detached random username.

[36:01] **Philip**: Yeah, wow you ... Okay, we are 37 minutes in, and assuming we'll go, you know, we'll go 60 minutes, or maybe a bit more, this is like the let's say, the halfway or two thirds point. And, you just said like the gem that we're going to start the highlights. So, all right [inaudible 00:36:18] that. When I've been doing podcasts, right, or even vlogs, I think that the beauty to ... Thinking about earlier about writing an essay or article versus doing podcasts or vlogs, I have a video about this, I have a video about everything, is that you can generate ideas or thoughts, or exchanges that you just can't do if you're just sitting in front of a blank piece of paper, or a word processor typing. Like, what you just said, you wouldn't have come up with it if you were just like, "Oh, I'm just going to sit there and write about [crosstalk 00:36:46] and identity, and blah blah blah". It's because we had this thing going.

[36:49] **Philip**: And usually I find when I do these podcasts with people, it takes around 30 to 35 minutes before it's like, all right, now it's on, you know, and I think when you were on my podcast, I think it took around that long. I think we spent the first 10 minutes talking about getting a haircut, to cutting your own hair.

[37:03] **Henry**: Yeah, yeah, that was-

[37:04] **Philip**: Cutting your own hair or something.

[37:05] **Henry**: Actually, speaking of that, this a total tangent, but my friend was going to get a haircut and I was like, "Oh, I guess I should too". And, I was like, "Do you want to cut it for me?" He's like, "Sure", and so he came to my place, he's never done it before, so I just asked him like, buzz it, or just cut it. And then, I was like, "Oh, we should record a podcast while you're-"

[37:24] **Philip**: Oh, nice.

[37:25] **Henry**: Cutting my haircut, because I thought it'd be funny.

[37:28] **Philip**: Is that going to be part of Maintainers Anonymous, or something else?

[37:30] **Henry**: I didn't publish it, I just recorded it, so it's almost like no one's going to [crosstalk 00:37:35] ...

[37:34] **Philip**: You recorded it. That's a great idea, like I love this idea of, let's just record it and see what happens. Like, it may suck, that doesn't matter if it sucks, who cares? And if there's a nugget that's great, great. If we're just going to put it online, that's great, maybe this is the start of a new ... It's like, what's his name? Lebron James has some podcast series where he's in the barbershop talking with athletes or celebrities, right.

[37:56] **Henry**: Oh really? Oh, wow, I didn't ... I was like, I wonder If someone's done ...

[37:59] **Philip**: Yeah, Lebron James has something I think, and think they have ... I mean, this is like ... Lebron James was in the first [inaudible 00:38:05] so like, the African American community, the barbershop theme is like a big community scene for that community. So, you know, he's obviously a big celebrity, so he took that vibe and then tried to replicate that in that format and stuff. So, you can have the Henry getting a haircut, you know. Everyone goes over and just tries to give you a haircut, and then you talk to them.

[38:29] **Henry**: Nah, I think it'd be funny because it's like, it only happens every once in a while.

[38:33] **Philip**: Yeah, I think it's great. It's like a rare gem, and then people are like all self conscious, like "Oh, I don't know what I would". You're like, "Don't worry, let's just do it and it's okay". Hair will grow back.

[38:43] **Henry**: Yes, exactly. And, if it doesn't work out, you can just buzz the whole thing.

[38:47] **Philip**: Yeah, I like this attitude, in that ... You know, my dad, he cut my hair when I was little. My mom also kind of did too, but my dad learned to cut hair because he cut his little brother's hair, and also they lived in China back in the 60s or whenever, and like a bunch of people lived in an apartment complex. So, he would just practice cutting other kids hair because no one had any money, it's like, "Ah, I just need to get a haircut". So, then he would just volunteer to do it and he would learn from other people and he got pretty good at cutting hair. And, I think it's the same thing with you, it's just like, if you're willing to just try it and consequences aren't that bad, right. It just grows back, it's fine. So, I think that kind of philosophy applied to things can be really powerful.

[39:34] **Henry**: Having the freedom to just try things and think things is hard and I think ... I've been struggling with that until ... Well, no, I'm still struggling with it, especially this past year, of doing open-source like "Full-time", and what that means and how you want to define it, and not having a set schedule. And, just like embracing trying new things, like being okay with experimenting. Like, I think if you do have the time and the freedom to do it, then why wouldn't I be doing this, rather than continuing to do the same thing, where I know the result. Going back to, those future possibilities, like I don't know what [inaudible 00:40:13] happen, and so that's exciting to me.

[40:14] **Philip**: Yeah, totally. Yeah, and sometimes I'm thinking about things that I have to do and I'm like, all right, the best case outcome is that this thing gets done, and the train keeps on the track, and it's fine. And then it's like, I have to do it, its fine, right? It's like you have to, I don't know, you have to take shower or take out the trash or whatever. It's like any errands, right. You've got to do it, right? The best case outcome is the trash gets taken out, right? But, if you don't do it, then the trash smells. But yeah, but very rarely in life do we get this chance to open up new possibilities, and you're in a situation where you can and it's pretty awesome. Yeah.

[40:49] **Henry**: Yeah, even this trip back to ... Or, I went to Boston for like a week, and I was like, "Well, I don't ..." I didn't really care about the [inaudible 00:40:59] thing, so I just tried to meet up with people. And then, I went to like a sister church like prayer meeting on Monday, when I came in on the train. And, I met someone there, and then on Wednesday, I was just walking to lunch with another friend and I just saw him on the street, and I was like, "That's so cool".

[41:16] **Philip**: Yeah.

[41:17] **Henry**: I've been like ... I don't know, I want to write about this, I don't know what I would say, it's just so cool to have those kind of spontaneous chance encounters with people, where I don't know, you schedules just happen to line up. And then, you might see someone ... You weren't planning on seeing them, but you just happen to ... They're there. And, I feel like that happens so often in the city, especially in New York, like on the subway. Just like every once in a while, like every few weeks, someone you know, maybe even from high school, they just came to visit their friends or whatever it was.

[41:48] **Philip**: Yeah, it's a cool thing. And, it's kind of like riding a wave, right? Like, when you're in a certain time when there's a high amount of stimulation, a lot of people kind of colliding into each. And, you know, school is one of those times, right? I mean, that's why the college experience, in certain situations, can be this time where a lot of like minded people of similar age and interest are colliding together in very random sort of spontaneous ways. And, there can be good and there can be bad that comes out of it. But, it's much harder if you're say, working and commuting from the suburbs and you have an office job. And, you live in the suburbs, you're driving in your car, and you go to work, you see the same 10 people in your group. You're in your cubicle, then you know, it's five o'clock, you go back to your car, you drive. On the way home, you have the same commute and then you have your home. Like, yeah, that's a fine life, but you don't get that sort of collision, [inaudible 00:42:43] in motion sort of thing, right.

[42:45] **Henry**: Yeah, and it's like, how do you balance those two things? Because, part of me is also ... Like, a lot of people are like, "Wow, you have such a great life, you go to conferences and travel the world and stuff". But, I don't like traveling that much, and I think it's important to like have that stable community, like people that you go back to, whether it's your ... I guess, not workplace at this point, but your family, your friends, or your church, like this local place that you can consistently see the same people, versus feeling like you have to like do the whole ... What was it? Digital nomad, where you're like going everywhere and you don't really ... You're not like tied anywhere and then I feel like if you keep doing that, you're going to feel like ... You don't know what you're doing, you don't know where you're going, like that direction, there is no direction.

[43:28] **Philip**: Yeah, I think that is a tough balance to strike. And, it's funny because when I was in college, my internships ... I interned for two summers in college. I have a video about this, I've got a video about everything. At this company that was right near my parents' house, and for various family reasons I wanted to stay close to home. So, I lived at home. Many of my friends in college then were interning at like the hippest companies, which back then, was Microsoft. And, I guess it's now kind of Microsoft again. For many years it wasn't Microsoft, right? So, it's like when I was in college, the beginning of college, Microsoft was like the big company that you really wanted to get an internship at. And then, for many years, it wasn't the top company, and now with all this open-source and the revival of open-source, now it's becoming more appealing for internships.

[44:14] **Philip**: But anyways, so while my friends are at places like Microsoft or other kinds of companies, I was at home, living at home, not in any major metropolitan areas, in the suburbs. And, I drover literally five minutes to this gigantic cube farm of an office. It was gigantic and then it was endless rows and rows of cubicles. I got in my cubicle, sat there for eight hours, I didn't talk to anybody. I was the only intern there because it was like a remote office, and there were other people who did the exact same thing and then as five o'clock came around and everyone just kind of left one by one, the building. We all just drove home, and then I was like ... I was what, 20 years old, and I was like, "Yeah, I don't think I want to do this for the rest of my life". I experienced this for two summers. I'm like, "Wow, yeah, I don't think I'm feeling this for the rest of my life". So, that's why I pursued grad school and research, and doing all these other kinds of odd, unusual things. But, I think having that experience first was key because, otherwise, I didn't know how that felt, right.

[45:13] **Philip**: Well, it was this idea that there is a great amount of freedom, but then there's a lot of burden on you to put structure around it, right. I mean, it's not really the tyranny or ideas thing, but it's similar. It's like people are expecting to have a certain lifestyle, they're like, "Oh, Henry, you have so much freedom, you'd better take advantage of it". And you're like, "Oh, am I taking advantage of it?". And, the problem is I don't really like to travel that much, But should I maximize my travel now because later I'll have to settle down, I can't travel as much. And you're like, yeah, yeah.

[45:44] **Henry**: Yeah, and then also there's this ... We're not completely fixed either, so maybe I don't like to travel, and I maybe I should do it more so I do like it, maybe I should do it more because that would be bad if I liked it too much. It's just like, then I'll go back to like, okay, I'm just ... Too much anxiety again. I thought the point of having the freedom is so that you shouldn't have to worry about all this stuff, and I'm just doing it against myself. Okay, so getting back to freedom it's like you're actually free to do whatever you want, but then yous till trap yourself. I remember reading this study, well I read this book in this book club with Stephanie. She was in the other two, the first or second [inaudible 00:46:27] episode. We read this book called 'The Body Keeps the Score'.

[46:30] **Philip**: This is a remote book club, or in person? Or, are you meeting remotely?

[46:33] **Henry**: Google Hangout.

[46:34] **Philip**: Oh, cool.

[46:34] **Henry**: I mean, that's not the easiest book to read because it's very ... There's a lot of like studies, and also it's about trauma, it's not like fun to read or anything. But, a lot of it talks about this idea that people that'd do go experience trauma ... I think a lot of people understand that it's almost like they're stuck in the past, that there's ... but then, the title itself right, 'The Body Keeps the Score', that this trauma leaves a mark on these people, not just in their mind, but maybe even literally in their body, that the body has some "memory". And, it remembers and so, how do we get people to live in the present and look toward the future rather than like recreating, or re-remembering that past event like because they're frozen in time almost.

[47:23] **Philip**: Yeah, and that's a super serious issue. And, I mean, it's totally ... I mean, I don't know the science behind this too much, but I mean, it's totally plausible right? Like your body's stress response to thing. If you had a traumatic upbringing or stuff, like you're physiologically different, right? You get more tense, you have more of a stress response, your blood pressure, you know ... All that stuff, whereas someone who didn't have a traumatic upbringing, or people who go to war, right. I mean that's a very typical thing, if you've been in a war situation or genocide or something, even facing normal, everyday things, your body physiologically reacts differently than someone who grew up without those traumas. Yeah, I mean it's totally ... It's a real thing.

[48:06] **Henry**: Yeah, and I think part of the problem is that we tend to think a lot of the issues in the mind. So, you've got to just like think differently, or whatever, stuff like that. And, it's like some of the solution is, there talking about how there's multiple aspects of this, so there's like top down approach, a bottom up approach, and then, I would say medicine. So top down is more like the talking, you know, how do you tell a different story of what happened and the future of your life. And then, bottom up is more something people are looking to [inaudible 00:48:36], you know, actually moving, like doing yoga or massage or acupressure, like those kinds of things. And, how that affects our bodies versus all like talking to people and getting them to think differently. And, I think that applies really well, not just for trauma, but just like in general. Like, we tend to make this huge distinction. We've been talking about this a lot in this podcast, like this distinction between body and mind, and you know, those kinds of things.

[49:06] **Philip**: I think it's interesting, I mean going ... Well, first of all, I have no expertise in any of this stuff. This stuff is like way, several levels way too serious than anything I know stuff about. I mean, there are people obviously, who are professionals who study this stuff and who practice this stuff. And, you know, I would encourage people to get professional advice on this, and you know, not listen to me blabber on a podcast about any of this, so I won't [crosstalk 00:49:31]-

[49:32] **Henry**: [inaudible 00:49:32] definitely not going to give advice on-

[49:34] **Philip**: The thought there that I had was, this whole mind, body thing is, I think again, just going with this theme of, more light hearted theme of getting older on the web, is that I think as you get older, this mind, body connection I think becomes more concrete. Because, you physiologically feel the effects of stress or fatigue, or if you're multitasking too much, being overwhelmed, overstimulated. It's like I remember this because 10 years ago, I'm 35 now, 10 years ago I was 25, I could do the Henry ... I mean, I did exactly the Henry thing, I went to Boston to visit friends, I was in graduate school in the summer. I would just backpack around, sleep on people's couches and like each junk food late at night and stuff. And, it was all good, and now, if I attempted to do even a tenth of that, I would like just roll over, right. Like, I very acutely feel the effects of fatigue and the need to rest and that stuff. And so, I feel like, as I'm getting older, my mind and my body are getting more connected because if my mind is more tired and more irritated, I actually feel it in my body. Whereas, when I was younger, it's like your body can just do whatever, right.

[50:46] **Henry**: That's funny you say that because it's like ... Well, my question is, how do we design infrastructure, systems, websites, so that we do feel that? And, I think the reason why I'm more cautious about it I guess now that I'm thinking about it, even now is because I do have physical issues, like it's like I have my own health problems. And, that lead me to be more aware, and it's not like I want people to have health problems, but like having issues helps you understand your fragility, or mortality in life. Like, it helps you appreciate everything more and it's a huge struggle to I guess, go through that when you're younger, but somehow I can see it as a blessing, even though I would have wanted that. It's like learning hard lessons through these sufferings or whatever, but-

[51:38] **Philip**: Yeah, I mean that goes with the theme. I don't want to go too deep into this, because it's ... I mean, but it goes with the theme of telling the story thing, right? It's like you're telling yourself a different story about, reinterpret it ... There's real terms of this that I don't know, right. It's like reinterpretation or something, right. And, you know, a light hearted example of this is like last year, or a year and a half ago, I broke my foot for a stupid reason because I fell over trying to move some boxes. It was like totally unwarranted, I like didn't put my shoe on properly and I just like tripped. And, I had a hairline fracture on my foot.

[52:15] **Philip**: But, long story short, I couldn't walk for like two months, I had to be on like a scooter thing and I had limited mobility. So, as a consequence, I actually just slowed ... You know, this is the mind, body thing. I just ended up slowing down what I did, like I couldn't run from meeting to meeting, or blah, blah, blah. I had to plan out stuff, I had to space out things. And then, I realized, I was like, "Wow, this is a blessing in disguise", in that if I didn't have my foot break, I would just try to keep accelerating and go, go go, and more stuff. And then I'm like, "I actually kind of like slowing down, you know".

[52:48] **Henry**: Yeah.

[52:49] **Philip**: Yeah, I actually liked slowing down. And then, after my foot's recovered, I've kept ... Try to keep that philosophy as much as possible and it's like just as a very simple thing, like what if you did everything 10% slower, right. Like, walk 10% slower, space out your stuff 10% more, you know, put a 10 minute break between when you're talking to people or whatever. You know, type slower even, right. Just don't be in a rush and just like slam on the keyboard and just like do everything and click, click, click, click, click. You know, stuff still gets done, you know.

[53:21] **Henry**: Yeah, I think it's important. I think you talked about this on a recent, about rest and ...

[53:26] **Philip**: Yeah, I talk about everything on recently, that's right.

[53:32] **Henry**: I feel like the progress of like just ourselves and culture's all about efficiency and like this idea that technology's going to save us. And, everything's about going faster and so, because we know that, then we know that we're going to have to be very intentional about rest because we're just not going to do it.

[53:49] **Philip**: Yeah.

[53:50] **Henry**: And so, how do we, for ourselves, and for everyone, like how do we encourage that kind of behavior to think that way? Because, I don't ... You don't have to tell someone to go faster, but I think it's really ... Like, we all want to tell each other to go slower, so ...

[54:09] **Philip**: Yeah, that's an interesting topic because like growing up, you know, I was very self driven and I did all this stuff on my own accord, and my parents and relatives were always like, "Oh yeah, yeah. That's cool, yeah it's good you were working hard on this stuff and stuff, but you should slow down and get better sleep and whatever". Yeah, I don't think my health habits were terrible, but it's stuff that parents say, right? They're like, "Oh, you should eat well and sleep better, and just take it easy. And, like enjoy life or whatever". And I always saw that as an older generation telling you [inaudible 00:54:42], right? It's like okay, yeah, you're middle aged or older, it's like your grandparents or whatever telling you like, "Okay ..." Yeah, that's just what parents and grandparents say. And, I guess the challenge there is, how can we convey this message to people who are younger, or not even younger, who are our peers, but give them the confidence and say, "Look, you can still accomplish really interesting and creative things, you can do what you want to do, but you can have a more sustainable way of doing it".

[55:08] **Philip**: This is not like telling you you have to retire now and quit whatever ambitions you have, you can still do all that and it's actually better for you to have a more sustainable mindset. And, part of that is modeling the behavior, part of it is talking to people one-on-one. But, it's hard, I think it's really hard because I remember being in that mindset when I was younger I'm like, "Oh, I don't want to listen to my parents or grandparents saying I should slow down because that's just what they say".

[55:34] **Henry**: Yeah, I mean, I almost feel like now part of the solution is remembering the whole, like how our mind and body are connected because ... I mean, yeah, we were talking about health, I think understanding our health better would help us. But, I think the thing is like, because everything is becoming more digital, it makes us not have to think about our body, that we could just-

[55:57] **Philip**: Yeah, I think that's a real thing. Yeah, that's a real concern. Right, so I remember this because there were times when it's like my brain gets so fried right, but my body's fine because I'm just sitting there in a chair all day being on the computer and like doing all these things that are like exhausting for my mind. But, my body doesn't feel it as much, right. Whereas, if you're like ... You know, the other analog is, if you're outside doing construction work all day, no one has to convince you to take a break, right. If you're outside hammering on stuff and this doing hard work all day, you put in a hard day of work, you know, however many hours. You can take a break guilt free, like no one's going to fault you for taking a break, or resting your body because, like yeah, you have to do that, otherwise you'll like break your back and you can't go and work and make a livelihood.

[56:47] **Philip**: But, you know, with mental work, more kinds of work on the computer, people can just do it all day and all night, and you may feel guilty. I mean, this is the whole 24/7 thing, you might feel guilty if you're not working because you're like, "Oh yeah, I can do it, I can just stay up a little more, and just fix one more thing", and then it just ... But, it's like if you were in construction or in some kind of physical job, no one would ever think to say something like, "Oh, you should stay overnight and keep building this thing for like a 20 hour shift while we all go home". Right, no one would ever do that.

[57:18] **Henry**: Yeah, and then, just thinking about athletes, right, they're professionals and rest is super important. They have [inaudible 00:57:26] to teach them how they should sleep and eat and everything and then we're technically professional programmers and we don't do any of these things.

[57:34] **Philip**: Yeah, yeah, it's terrible.

[57:35] **Henry**: We're known for like everything that is wrong with us. Like, we have hackathons which we encourage during college, ann then you stay up late and you eat pizza, and it's like what are we doing, you know?

[57:47] **Philip**: Yeah, and it is interesting because ... That's right, so I mean, the athletes, my friend Jing Yang, she tweets about this, about kind of trying to treat ... She was a professor at [inaudible 00:57:59] and she's now doing a computer security, data security type startup. And, she talked a lot about the intensity of research and also building a company from scratch, but how its so important to say, learn from what high level athletes do. Right, these people are doing harder stuff than most of us will ever do, yet they prioritize rest, they prioritize nutrition, recovery. And, if you actually look at how much they practice, yeah they practice a good amount, but they are not actually working at high peak intensity for that many hours, right, because you just physically can't do that, right? No matter who you are, it's actually detrimental at physical intensity for too long because you're just going to, you know ... Like, it's all physiological.

[58:42] **Henry**: I think I remember on my podcast with [inaudible 00:58:44], and he was talking about recovery being like super important, like first class, right.

[58:50] **Philip**: Yeah, so it's Tim Ferris and Lebron, and his coach. It's like Lebron's conditioning coach or somethIng. Yeah, yeah, and it was like this ... His coach rarely gave interviews and they talked about their strategy for making sure to keep him in good shape because the thing with Lebron is like, he's not young, right? I mean, he's been doing it for a while and to keep at peak shape, knowing that as you get older in sports, just physiologically, you're not going to be in the same shape as you were five years ago, but how do you keep on top. I mean, actually if we want to circle back in the last few minutes, this theme of maintenance or sustainability. I think that's a great way to think about it, like sustainability and maintenance of just your own mind and body.

[59:34] **Henry**: Yeah, it's so funny because I remember I was telling my mom like, "Hey, I'm going to quit my job and do this thing, open-source, full-time". And, she was like, "Hey, before you maintain anything, you go to maintain yourself and your health".

[59:47] **Philip**: That's a great ... There we go, that could be the slogan for your podcast, your mom's quote is, I mean, it's so right.

[59:53] **Henry**: And, of course, going back to not listening to your parents, of course I understood, yeah, that makes sense but I'm not going to do it.

[59:59] **Philip**: Yeah, but now you see your parents were right.

[01:00:03] **Henry**: Yeah, always. Yeah.

[01:00:05] **Philip**: Yeah, I think the sustainability ... I mean, just longer term, thinking about what we've talked about this hour, sustainability is really on my mind nowadays. I think that would be the big difference between myself at aged 35 and at, you know 20 or 25, that I think a lot about the kinds of work I like doing, the kinds of stuff I enjoy doing, both personally and professionally. How do I sustain this long term? It could morph, right? It could change into different things over time, right. It's like not just a flash in the pan, how do you sustain a career? You know, or sustain a long running hobby and things? And, I do think a good amount about that because you only have one life and you want to sustain doing the stuff that you want to do as much as you can.

[01:00:54] **Henry**: I guess that's a good place to end there. If people want to know more about what you're up to ... I guess you posted that article recently about research design patterns which-

[01:01:04] **Philip**: Oh, yeah.

[01:01:05] **Henry**: I wanted to talk about that earlier, but then we never got into it, I just say my-

[01:01:07] **Philip**: Yeah, there's so much there. You can just link to it and people can ... Yeah, I feel like it's probably not worthwhile to summarize a blog post and rehash it. You can link to it. I mean, just put a link to my website, just like PGBovine.net and my website has a bunch of stuff on it.

[01:01:26] **Henry**: I mean, I just liked it because I didn't think it was specific to research, I was just thinking about coming up with ideas for myself on like open-source or just life, and like thinking through those things, like trying different ways of doing that.

[01:01:40] **Philip**: Yeah, they are really kind of creativity design patterns. You could rename that creativity patterns or something, right, it's just kind of ways to get your brain to think outside the box and stuff. And, I think like I don't want to go too broad because like there are people in the brainstorming, and the design sign who have a lot of these exercises, right, for like diversion thinking and ... There was a lot of these sort of design exercises that you can do to help you kind of reach different space in design. So, I like my article being more specifically about academic research because it's something that's more ground. And that's another meta theme that I think came up a lot during this hour is like, when do you go meta and think really broadly and when do you just go with specific? And, if you notice, I like having really specific examples, right, I'm like ... Especially from my own experience, right, it's like super specific example, and then you can use that as a case study for a broader theme. So, I would not be able to write a philosophy paper or something, right, because I can't think at that high level.

[01:02:37] **Henry**: Well, I mean I get it, that's more like finding all the specific things and then seeing patterns. But, not everything has this unifying theory or whatever.

[01:02:45] **Philip**: That's right. I mean the world is messy, right? The conclusion is that the world is messy.

[01:02:50] **Henry**: Yeah, I think that's a good end.

[01:02:51] **Philip**: All right man, well thank you so much for hanging out. And, I hope that this was random enough, so I would look forward to your summary of this and hope that you cover the [inaudible 01:03:04] of the randomness that we covered.

[01:03:07] **Henry**: Yeah, I need to think through the title. Cool.

[01:03:08] **Philip**: Yeah. All right, I'm looking forward to it.

[01:03:12] **Henry**: Thanks for listening, check out our website, maintainersanonymous.com for show news and transcripts. If you have any feedback, ideas, or guest suggestions, you can reach me on Twitter @left_pat. If you'd like to support the show, you can visit patreon.com/henryzuu.
