---
title: "MA 11: Maggie Appleton on Open Source as a Gift Economy"
season: 2
date: "2020-03-05"
time: "55"
description: "Is the open source community a gift economy? What even is a gift? Maggie Appleton joins Henry to discuss open source as a gift economy (versus a market economy), why we participate in open source and exchange gifts, rituals and habits, patronage and crowdfunding, quantified self and disembodiment, our role in tech"
episodeLink: 0114ded5
embedUrl: https://share.transistor.fm/e/9d389287
sidebar:
    order: 11
---

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-2/gift.md)

[00:09] **Henry**: All right. Hey, this is Henry and this is the Maintainers Anonymous Podcast. I have with me and Maggie Appleton. I don't know, I forgot how we met each other but I know that you had a background in anthropology and also studying open source and now you're, I think pretty involved in the AJAX JavaScript and tech industry in general. So I thought it'd be cool to kind of talk about maybe how you perceive open source before and then now how you see it, being a part of it now.

[00:41] **Maggie**: Yeah, so I think we met for the first time at Joel's house. So I work for Egghead and it's run by Joel and it was in Portland, Oregon. And then we hung out for a couple of days after that and got to chat quite a bit. And I remember just asking lots of questions because I was fascinated by the open source community. I was, vaguely knew about it but not really in depth. And this is, would have been back in the summer and between then and now I've ended up researching it quite a bit, very much as an outsider, layman sort of vaguely curious about this sort of odd world that if you're not in open source and you sort of learn the intricacies of it for the first time.

[01:21] **Maggie**: So I was an anthropologist yet for my undergraduate degree and sort of never let go of it, even though I work as an illustration now. And, it's the most wonderful culture to explore because it's so nichey and weird and subculturey and has so many of its own rules and norms and I think most normal people don't know about. So yeah, so I've just sort of stumbled into it as an incredibly interesting research project for a couple months now.

[01:46] **Henry**: And also it is very niche, but then maybe it's also interesting because it's so impactful right, in the rest of society.

[01:54] **Maggie**: Yeah. That's the ridiculous thing is if you ask normal people about it, they would assume it's small. And then when you realize about Linux, you realize about Babel even, right? Running the whole of compiling all JavaScript that runs on the web, it gets a bit mind blowing. It's so invisible and everything. Mostly, I had stumbled across first, which I guess is the obvious cultural angle that a lot of people take on open source. Is to point out the fact that it in certain ways operates like a gift economy. Well, if we give it a basic definition, this is one where people in open source, we've heard this a thousand times. In anthropology, gift economies are a thing we love to talk about.

[02:32] **Maggie**: It's one of the favorite anthropological subjects that we bring out all the time.

[02:36] **Henry**: Don't I know that.

[02:39] **Maggie**: It's one of those, that gets taught in anthropology 101 very early on. And it's more as a way to discuss different economic structures that you can, when we say an economic structure, just the way that people exchange goods, services, anything of value. And there's multiple ways to do that. And it's not one single system. So gifted economies is simply that the way one thing value moves to another person is through a gift. And we might traditionally contrast that with a market economy, which is of course when you exchange something of value for money or barter economy, right? Thing of value for things value. And these sort of set up as the three basic ones. But really, there's myriad ways to intertwine those in different configurations in a sense.

[03:24] **Maggie**: It's not like we have only a gift economy or only a market economy. So that's one thing I was kind of curious whether open source people sort of, thought that when they talk about gift economies it's as if open source is all a gift economy. Because the way I look at it, it's very much, a mix of both market and gift in a way that's very compatible and reciprocal with each other.

[03:49] **Henry**: Yeah, I guess I see what you mean where it's, it's not just those three archetypes but the combination of those. And not to get too complicated, but I guess maybe individual projects could be different. Right? And different communities. It's just almost a hierarchy of these things are at different levels, a programming language or a framework or a individual library. Those all might have different economies I suppose.

[04:16] **Maggie**: Yeah. Because gift economy systems, it's mostly about the ideas, right? If I give you a gift, the point is not really the object moving from me to you. It's more that it establishes a social bond between us. And that's the important thing that we want to emphasize in the exchange. Whereas in a market economy, we really are, we're trying to make sure that we're paying the right amount of money and the person selling it is trying to make sure they get the right amount of money. So the emphasis is on equal exchange value and yeah. So gift economies, the emphasis is on establishing strong social bonds. And also it works in a way that's a bit of a positive debt.

[04:57] **Maggie**: So if I give you something, I want to make sure I give you something of higher value than whatever you last gave me and that sort of in debts you to me in a certain way and it sounds a bit negative but it's not meant to be. So now you next time would have to give something back to me that is more valuable than what I first gave you and it, and what it does is it just means we are constantly in relationship with one another. Yeah. So I sort of read open source a bit in that way where, not the people competing to contribute more than one another. But you're doing it because-

[05:32] **Henry**: That would be great.

[05:36] **Maggie**: Is that not how it works?

[05:36] **Henry**: I don't know.

[05:36] **Maggie**: When you ask a normal personal working in open source why do you think people contribute to projects? Or are those sort of bog standard answers people rail off?

[05:52] **Henry**: I would say maybe one of them is, people might realize how much they have been given, I guess through open source, how much they're using and they want to give back. So that does sound like the, well exactly what you're saying. Right? They, but that's kind of maybe it took a lot of times to become aware of that thing. It's going back to the fact that it's visible in some sense. You're using it all the time, it becomes infrastructure. And so you don't really think about it. And so that causes you to not really need to feel like you're giving back.

[06:27] **Henry**: And maybe talking about the gift thing, when I think of a gift, I think of an individual person giving to another person and usually in person, right?

[06:37] **Maggie**: Mm-hmm (affirmative).

[06:37] **Henry**: And so you kind of picture that person, you know them. With open source you might not even know who works on the projects that you use. And this is really true. Just, personal experience with, you can give talks. I've done that and then people have no idea who I am but they know Babel. Not that they need to, but it's just that these two I think, this thinking that sort of with online discourse, everyone has a username, you don't really know them. It's just some black box.

[07:05] **Maggie**: Right. So then it is if the thing that makes gift exchange means something to us, if we lose that direct social relationship, that's what threatens it maybe. That's what makes the economy not quite function the way we wish it would.

[07:20] **Henry**: It feels that way. I don't know if that's always true. Because people, example I just thought of is, people will look at stuff on social media all the time of people doing amazing things, or just the example of you've buy something online and then they put it on your porch and then the, they put it so that no one will steal it because they take it out of view. And someone recorded that because they had that, what's the camera? I forgot the name of the, but they tweet out to a bunch of people and then everyone sees that and they feel good about themselves. They're like, "Oh, I want to do that. I want to pay it forward." But, so they can be good. But I don't know if that's just, you just feel good about yourself or you're actually going to do something.

[08:08] **Maggie**: Right, right, right. Because it ties into this concept. So part of gift economies is, there's a principle called the, the no free gift principle. There's no such thing as you can never just give someone a gift and then it's free and no one has any obligations to one another. Right? That negates the whole point of the gift. That if you've been given something, you feel that internal obligation to give back and there's lots of theories is that human nature is that, who knows it's just something we don't understand.

[08:41] **Henry**: What are some examples? because I can think of when you, I guess families give other families gifts or when you visit someone's house, you give them a gift. Christmas I guess.

[08:53] **Maggie**: So for sure at Christmas and birthdays, presents are always classics that people refer to. There's two good examples that are specifically British, but hopefully I assume they might be American equivalents, but you can tell me one is rounds of beer at the pub. So, when you go out with friends to the pub here, it's like you will buy everyone at your table a beer and then the next person does it and the next person does it. And so there's three types of gift giving. One's called generalized, which is parents to children where you don't keep track. It's all just sort of, all comes out in the wash all a bit fuzzy. We all trust that we our parents fed and clothed us and we'll feed and clothe them when they're old. So that's generalized and there's balance, which is the pub drinking example where you loosely keep track, no one's writing it down on paper, you're not that bothered, but you're sort of keeping tabs on whose turn it is to buy beer.

[09:47] **Maggie**: And then there's, negative is the last one, which is where the, each party is trying to get more than the other person. So that, examples would be gambling. Or when companies give out free coupons, but they're really hoping you're just going to, yeah, exactly, two for one sort of deal. So that's where it's negative because it as you're pretending to give a gift, but really you're trying to get one up on the other person. So those are the sorts of the three main categories. But when we talk about, examples of gift giving it certainly ones like even just buying friends dinner, you tend to do it in one for one. No one's keeping track, but you need to kind of know.

[10:28] **Henry**: Right? Like when someone visits where you live, you post them or pay for them and then when you go to their place they'll do the same thing for you. So it's kind of, balanced.

[10:43] **Maggie**: Yes, there's all sorts of ways that, it's kind of funny, we always assume we live in a market economy, right? We speak that way. Economists always, talk about the market and are obsessed about the market and we hold the economist in rather high regard and in our culture. But when you start to look around, you realize there's tiny gift economies operating all over the place. Very intertwined with our market exchanges because actually, fun anthropology history story is, we've always found in other cultures that have really strong gift economies, They always have market economies that are symbiotic with them, that exist alongside them and help them.

[11:23] **Maggie**: So the sort of classic example it gets sort of rolled out in every anthropology undergraduate course is from the Trobriand Islands, which are these set of islands that are, I think it's over a hundred that are scattered. And the people on the islands have a gift economy that doesn't operate just on a one to one level, but operates between villages and, on each Island. So they have special necklaces made of shells that travel to the right, so they go, it's a clockwise direction around these islands. And so, families will give necklaces to people who live on the islands to their right. And then those, these shell bracelets that people also value that are given to families, to the left of them.

[12:09] **Maggie**: And every single time they would travel to one of the other islands, they would have this big ritual ceremony of giving the gifts of either the necklaces or the bracelets. And these objects had strong histories. You knew who had owned it and you had this storied lineage. So certain ones were more valuable than others and they would do the gift exchange and then afterwards they would do the standard market barterings, they would trade wood for fish or this and that. But they sort of had a reciprocal gift economy going where it didn't matter, you weren't going to give directly back to the person that gave to you. You were giving in this really large circle and you just trusted that it was going to come back to you at some point by whoever was trading to your left or your right.

[12:51] **Henry**: So that's the whole pay it forward concept?

[12:53] **Maggie**: Yes. Yeah. But you do understand that it's in a closed system at least. So the people giving, they know it's not really a free gift. They know they're going to get something back from people who are coming around the other side of the circle. So as long as I think, I don't know if that, that really could relate to open source, that if you don't trust that the other end of the circle is coming back towards you, maybe you're not as willing to give.

[13:16] **Henry**: And maybe that's part of the issue where you need to talk about this closed system and communities having boundaries. Maybe part of the problem is that the scope is so high and everything is very vague. You don't have an incentive to do that.

[13:32] **Maggie**: Right. Because if the, if you imagine community is every developer on the internet that's a bit large. I wonder if there's, I don't know if it works more if you're a small open source community. I'm thinking of something specific like Vue, right? That if they all really know each other and they're all building things specific for people who they at least can recognize their user name, they know them on Twitter. Maybe there's more, or have you actually seen more active open source communities when there's a smaller imagined group?

[14:02] **Henry**: Yeah. You could bring it all the way down to your, the team, the Babel team or something. If you're on a team you would want to trust everyone there. And so, and if I think about governance, then I don't want to micromanage anyone, even if I'm the lead for the project because I trust that they know what's best for, what they want to do. As long as we have the same, I guess guiding vision or that kind of broader scope thing, I think that works really well where it's, actually I was thinking about this recently where, with an opensource project, sometimes you kind of, especially if you've worked already, you wonder, should we have more meetings?

[14:48] **Henry**: Stuff like that. Most things are asynchronous and there's this feeling inside like, "Oh, I need to do meetings just because that's what I'm used to." And I think it's good to do the meetings because I would like to see people face to face. I guess not in person unless we want to, I guess spend the money for that. But doing, a video chat and just to getting to know these people as people. But that doesn't mean we're doing a meeting. Right? So I think that's more of a, just what you're saying, social bonds versus feeling like, with those company you have the one on ones and performance reviews and all that stuff. And I'm, maybe open source should be different then maybe we shouldn't try to copy all these things from the normal "company" just because we're used to it.

[15:41] **Maggie**: Yeah. I mean, it even ties in a bit to open source culture of the more I started reading about it, the more sort of impressed I was by the sincerity with which the community is really trying to invent new ways of doing an economic model. I mean, it is quite impressive when, when you think about how the model of, strict capitalist market culture, we all assume we live in it and that it's inevitable at this point. And it's just very refreshing to watch people very sincerely actively play out an alternative type of way of doing things. It speaks to a genuine kind of sort of optimism and imagination that we are not at the optimal system and we all recognize that. And to actually try and move it forward in practice is, kind of a beautiful thing.

[16:29] **Henry**: Yeah. And I think maybe that's what draws people to open source. That, similar to, if you think about Wikipedia, I tried to explain to some friends that are not in tech, I just say open source is sort of like Wikipedia for code.

[16:44] **Maggie**: Right, right.

[16:45] **Henry**: That's glossing over a lot of things. But I think that's kind of the, the gist of it.

[16:49] **Maggie**: Does that analogy resonate with people? Is that sort of the best touchstone for people who aren't in the community? Do they sort of go, "Oh, okay. I think I understand."

[16:57] **Henry**: I don't know. I think so because I think I need to explain something in two or three words. Then Wikipedia is probably one of the most visited sites in the world, right? Top 10. I forgot what it was. And then people understand code because they're using apps and they think they know about programming. So I think, and they also know that theoretically anyone could contribute to Wikipedia. Maybe if they've actually tried it, they know that there's admins and there's even bots and there's a process to it, but it's supposed to be, I guess ideally more democratic than just the official one encyclopedia.

[17:39] **Maggie**: I mean, yeah, Wikipedia, it is good classic example for most people. But then I even think of, well I mean you would know, right? The open source way of doing things. It's so much more sophisticated and evolved in terms of how I've, I've seen certain open source practices. I love what's the plugin on GitHub that shows the emoji for who did what?

[17:58] **Henry**: Oh, there is a, are you talking about the reactions or?

[18:03] **Maggie**: I think so. It's when people contribute to an open source project, it will list, show images of who did what and say they did copywriting, what they did, code or-

[18:17] **Henry**: So, I think you're referring to Kent C. Dodds. He made this thing all contributors essentially. So, before or I guess now still, GitHub doesn't have a good way of expressing who's done what other than through commits because it's the easiest thing to measure. And they focused a lot about the code. And so, a lot of maintainers realize that open source is not about just code. Clearly there's a lot of other things, not just docs and tests, but managing things. And so he was thinking, all right, we can't really, a lot of these things aren't really measurable, so, he asked essentially, it's crowdsourcing this stuff or you yourself can define like, "Oh, I contributed art. So then I'm going to put a piece of a picture of art." And then now everyone can say that they did that.

[19:06] **Maggie**: Oh, okay. Yeah, I really liked that. I didn't realize, Kent build it. That's great. Because just seeing that, made me think that that is the right, if gift giving us so much about, you're just getting a social status and power in a certain way. But again, it doesn't necessarily have to be a negative way. There's lots of ways you can have social status and it's not that you're an awful person. It's just a recognition that gives back in a way that I'd think editing a Wikipedia article doesn't give you any sort of reflection back that you've contributed.

[19:43] **Henry**: Right.

[19:46] **Maggie**: Is it, I don't know if you guys have done this, but Gatsby, I mean they're definitely an open and then also market commercialized blend of an open source project. We're sending out swagged people that contributed and obviously that's not sustainable for a true community sourced, community funded open source project. Though that was an interesting example of, acknowledging contribution in some sense.

[20:13] **Henry**: Cause I guess with that, it gets into just how logistics and shipping things and all that. And, I actually got a t-shirt for one of the first projects that I contributed to was just Angular 1. I did a bunch of, essentially it just linting fixes, spaces and stuff. And I got an email from one of the maintainers like, "Hey, thanks for your work, here's a tee shirt." And I was like, "Whoa." And that super, it really did encourage me. That definitely does work. But we haven't done that ourselves.

[20:45] **Maggie**: And it's probably less about the tee shirt then this thing of the idea that you now belong to a certain community.

[20:50] **Henry**: It does, I mean the small version of that is stickers. Companies can print out thousands of stickers and they kind of leave them on the table which is fine for them. But for me it's like, "No, I, it costs money." And I also feel weird when it's, if I just leave it out there, they don't even know me or if they get to talk with me or something, I'd rather get to know someone and talk to them and then at the end like, "Hey, if you want a sticker, I'll give it to you" kind of thing.

[21:20] **Maggie**: Because it's kind of just, socially meaningful gift as opposed to actually the free sticker on the table is the exact idea of the free gift that then becomes, isn't valuable to us because there's no human attached to it.

[21:37] **Henry**: Yeah, I guess that does remind me of what you're saying about gifts where it's not really about the sticker or the tee shirt, it's about, it's almost a reminder that we had that interaction or something. Right? Versus the thing itself. It doesn't really matter what that was. And meeting someone and having a good conversation is the takeaway.

[21:56] **Maggie**: I was just curious whether OSS projects had thought whether it's a discussion in the community about creating ritual around, contributors and acknowledging contributors.

[22:08] **Henry**: Yeah, I think that would be, that's something that we should be thinking about. I mean this ties into my experiences in, a religious setting where it's, everything is about ritual. They got me thinking, I actually did a discussion at the maintainers conference in DC a few months ago and I called about open source as liturgy and liturgy is just another word for ritual in a way with other people. And it's kind of, what are the rituals that we participate in? And it is kind of hard to think about what those are if you've never thought of it that way. But some of the ones I thought of are, we do have more, there are ratios of, they're all different sizes, right? So one would be a yearly thing that would be like Hacktoberfest, like every year GitHub and Digital Ocean, they do that thing where they try to get new people to get involved and there's a, that day.

[23:02] **Henry**: Which is good and bad because from the maintainer point of view, that's the day where you're going to get a hundred PRs that you have to review, which is not necessarily something you want. So, it kind of reminds me of this thing of, I would like an opportunity for people that use open source to think the people that do maintainers, so like, "Why is, why are they called GitHub issues?" It almost has a negative connotation already. And so some people suggested maybe we should have a thanks tab. But if we had a day where we just thank people, would the maintainers feel overwhelmed by the thanks. It's kind of funny to think that. When it's all coordinated that way, it doesn't feel as genuine I suppose, even though it is.

[23:49] **Henry**: So it's kind of funny how it kind of, it's a lot more nuance. You can't just create this sense of, people actually being thankful. But when you get that random email from someone, you're like, "Wow, I really feel it."

[24:04] **Maggie**: Right, right. Because that is with, especially with ritual. You need to open up the space for someone to have the option to say thanks but not in some sort of like "Here's a meeting time and you're going to get on and say thanks." Right? Because that's when it feels manufactured to us. But yeah, you would know through lived experience more as well, actually participating in rituals where there's, there's open space for what you can and can't do. And there's not strict rules, but they're sort of, sort of gives you an opportunity to explore giving thanks, or acknowledging certain things in a way that's a balance of agency and social control.

[24:46] **Henry**: Yeah. And actually now I think about it, with church or this kind of thing, a lot of rituals are fixed, in a way. So, like we go to worship on Sunday or something or you have your small group every week and I'm just talking from my own experience. We have a prayer meeting on Wednesday. These are all very fixed things and you would think that would be my bad thing. But it's actually, sometimes we need the rituals because we're not in, we're not in the mood to feel a certain way. And one of the most important things I'm trying to learn is kind of this thing of, changing our behaviors through these rituals and actions rather than just thinking our way to changing ourselves, right? The act of doing, going through these motions essentially can lead you to belief.

[25:39] **Henry**: Even, you don't want to stay there cause obviously, going through the motions is not the most, it's a negative thing. But I think we should acknowledge that the motions help us to feel a certain way when we're not feeling well. Right?

[25:51] **Maggie**: Right, right. Cause it is just that the ritual sets a loose structure where, going to church every Sunday it's, you don't have a set not every Sunday is exactly the same and you have certain structures that will always happen, but then there's still sort of, your own agency to play within those.

[26:09] **Henry**: Yeah. And I think for me it reminds me of this idea of, and maybe this is related to gift-giving too, surrender. So that is something none of us really want to do because we want to feel in control. And part of that is doing something over and over is kind of, you're not in control in that moment. Right? You have to kind of surrender to whatever this thing is. And that for me is actually a source of freedom. And I think that's difficult to realize because we tend to think of freedom in terms of, you kind of use the term negative freedom versus positive freedom. Negative freedom meaning no one's forcing me to do stuff and I want to be able to have the agency to choose versus freedom where it's, within this boundary, this limitation I am free to, what you said, explore that space.

[27:00] **Maggie**: It's similar to even, to creativity, but especially with design, you always say the best design happens within confined boundaries. You set yourself up a grid and then you work within it, but a completely blank page is, the worst. It's unhelpful and you're never going to get anything good out of it.

[27:20] **Henry**: Exactly.

[27:20] **Maggie**: So I was thinking of other things related to, this I suppose gets more into the broader economics of open source and not necessarily, there's the gift economy aspect, right? Which you kind of get, if it's, it works. Is there still an opinion in the industry of, not bafflement but confusion about why it exists? Is that still a thing? Because in researching I stumbled across, research papers by probably more economist or political scientists who would very sincerely write academic papers going open source is such a confusing, contradictory thing. Why would people give away their free labor? This makes no sense. And treating it as if it's some sort of mystery which reading those, I sort of snarkly read them in that anthropological way of being like, "It's obvious why they do it. Social meaning means more to us than money. Everything we do proves that all the time." I was curious whether within the industry, it did, would they read those papers and think they would daft or sort of is everyone a bit confused as to why it works?

[28:35] **Henry**: I mean, I guess I can't speak for everyone even though I guess I'm a lot more involved than most people. I don't know. I can say it's both in a way, where maybe firstly, I want to say that there's a difference between what people say they believe and what they actually believe. So maybe all of us are like, "Oh yeah, I think open sources a thing." But the way we act, we don't actually maybe appreciate or I guess I don't know the right word, but it's, I think, it's kind of like everyone has an awareness of open source because at this point, literally 99% of all software is going to use open source. But that doesn't mean that their behavior is different because they know that fact are that belief. They just, like I was saying before, it's just there. And so it's kind of acknowledgement of, if this is a thing that open source is by volunteers and all that stuff, maybe we should do something about it.

[29:34] **Maggie**: So, you have the idea that maybe it's, this is not the right not tools, that sounds a bit, you know but like Patreon, right? Is one of the only platforms that, of that kind. And what is it? The open source collective is the other one? Or what's GitHub's version?

[29:51] **Henry**: GitHub Sponsors.

[29:52] **Maggie**: That just came out last year though, right?

[29:54] **Henry**: This year. Oh yeah, you're right. Sorry. Yeah. I guess last year because 2020.

[29:58] **Maggie**: It's still 2019 technically in my head. That is also so incredibly new. It's sort of all the structures for, just being invented off the cuff that, maybe this shouldn't that awkward transition phase.

[30:13] **Henry**: Like what you said, I think a lot of this stuff isn't necessarily new if we think about the gift economy thing. But actually I remember, I saw a tweet from somebody that was talking about how, I mean, the idea of Patreon and comes from patron and so there are people that they wrote books or are able to create music or art because people have sponsored them. So that idea is definitely there. But the difference I think with Patreon and these things is that it's online. So with them, it's probably they know all those people, right? That are sponsoring them. But with this, it's kind of almost one way where you don't know these people but they know you.

[30:54] **Maggie**: Right.

[30:54] **Henry**: And that is very different I think. And obviously global where it's in the world and they could stop at any point as well, every month. Which could be kind of part of the problem where you kind of feel people are always asking me, aren't you scared that at any moment, all the money could be going away because of the economy or whatever or something that happened in their lives. There's definitely a psychology of Patreonage if you want to call it that. That I have thought about a lot as well.

[31:23] **Maggie**: But now it does seem the Patreon model. I mean I always, let's sort of a little bit talk about right, internet culture as it's also so brand new. The internet is still a complete baby and we have yet to figure it out obviously given the sort of all the awful things that sometimes play out on the internet. And Patreon also seems like it's very much part of that. It's very much like we realize that this isn't really working, right? Because someone who subscribes to your Patreon doesn't really get a meaningful social interaction with you, which is probably what they want in some consents through their monthly payment. And you don't know who these people are in any meaningful human sense of having a social interaction with them and a bond. So on a fundamental level, this whole, this whole system is not doing what we need it to.

[32:16] **Henry**: I have a lot of thoughts with that because even Patreon, I think they tried to, it used to be, there was Kickstarter, right? And that was a big thing. And you got all these different things even GoFundMe. And so with Patreon, they essentially were going to call themselves a crowd funding platform too. It just happened to be monthly, right? Instead of one time. That's a big difference. But I think they've changed their motto to be more of a membership platform, which is kind of speaking to what you were trying to say with, it's not really about funding but about creating a community or a group of people that kind of align on the same thing. At the same time, it is kind of interesting how, you could say in a way the market will affect the product. And so, most of these platforms are all focused on, I mean, I guess maybe you could say rightly or wrongly, a lot more money, right?

[33:11] **Henry**: So the UI is focused on that and so it's not really about making relationship, it's about extracting money from people. It feels, and you can say the same with GitHub. I feel like GitHub is also, even though it's about open source, a lot of times it feels transactional in a way as well. It's efficiency of code and project management versus dealing with burnout or mentorship or onboarding or off-boarding, even all these different concepts that are not in the product because you have to do all these things outside. So, you kind of have to work around the system, example in Patreon. And I'll get help sponsors for me. What I did was they have this idea of tiers, and that is just, I guess told totally from Kickstarter. Right? If you give this much, you get this thing back and then you can say that is an economy kind of thing.

[34:08] **Henry**: But, I think in practice, it leads to, it's some form of entitlement possibly. Right? Because before it was free. People are already very entitled they're like, "Fix my bug background." That kind of thing. And then now it's like, "Well I gave you a dollar, so now you should talk to me for an hour," or something like that. And so, the value of who you are becomes nothing. And this is why, it kind of reminds me of the busking thing where it's like "Are you actually worth that much?" And so I tried to purposely change my tiers so that, there's not a easy way to monetize or put a value to the thing that you're essentially paying for on the tiers. So I thought of things that are very personal. And, I tried to make the whole thing more personal. So, for me I like board games and video games. So I thought of a number that was tied to that. So Seven Wonders is a board game. So I said $7 I'll play board games with you. And it's not, it doesn't mean playing board games with me is equal to that, but this is kind of arbitrary thing I thought it would be funny. And then you have to be in the same place as me, right? I either have to go to your city or you come to me. It's kind of a special park. I would do it for free. I don't need that to play games or anything, but I think that it's a good way to kind of get people to think a little bit differently about supporting what I'm doing.

[35:35] **Maggie**: Your Patreon rewards was some of my favorites of all the ones I've seen. Isn't one of them "I'll play ping pong with you"?

[35:40] **Henry**: Yeah.

[35:44] **Maggie**: Now you're making think of it, Patreon in a way is running under the guise of being a gift economy. Right? All their marketing language and the way they pitch themselves is very much that we are supporting the new internet gift economy, but on the actual functional level they are pure, the way their tools are designed and built is for a market economy, right? They're like $5 and, everyone else is tee shirts and posters and they'll do this and that for that amount of money. And so it's sort of just using the gift economy staff to sell the thing and then definitely not following through on it on the way it works.

[36:19] **Henry**: I mean this is probably similar. I think it's the same as design and everything else. It's like we don't know how to not think in the market economy. So when we make a website, there's that joke about how there's only two layouts. And so I think it's similar. It's like when we make to say, "Oh, of course we need tiers, of course we need this." It's just a fundamentally different way of seeing the world. And in some way, maybe, I'm not going to say it's possible, but it's just, I don't know, we don't know how to even start thinking about how that works. Because it does slowly turn into this consumerism sort of thing. Right? You become a brand. you're selling tee shirts and stickers and it's just like, "I don't want to be a corporate whatever." Right?

[37:08] **Maggie**: Yeah, yeah. I mean, I think it is a little bit inevitable simply that, we, us now, in this historical moment are born into a period where capitalism is sort of the overarching worldview. But anyone who's done the slightest bit of reading about history there's been all sorts of different ways of organizing society over time, and organizing economies and markets and that, it's certainly not the end all, be all thing that will always be. So, I like to have the optimistic hope that we're just sort of muddling through it and that things like Patreon are a sort of good signal that we like the ideals of the gift economy. We're not playing them out yet, but it's sort of like we've, we've said we want to go running every morning, whether we will or not is still waiting to be determined. Sort of putting it, as a goal but very much not doing it yet.

[38:10] **Maggie**: So I'm, I don't know, I'm really hopeful that in the next, decade or whatever of the internet that we would find more ways to preference that actual social interaction element over $5 for a tee shirt sort of functionality.

[38:27] **Henry**: How do you think we'll get there?

[38:28] **Maggie**: Well, a lot of this, is related to developers in open source really, right? When you  think about the power that programmers have in the world and their ability to define the way that the internet works and what tools do and don't get built. I think this is what fascinates me mostly about looking at programming from an anthropological point of view. Is that the cultural power that programmers have is enormous. And yet that's never spoken about in the community, right? If you think of everyone who's building apps all the time or building tools and they of course build tools that will be useful to them and they think will be valuable to society.

[39:04] **Maggie**: So then it makes you think, well, what they think is that valuable to society it's the core belief that sort of becomes the engine for what gets built. And so you see a lot of, sort of maybe very quantitative numerical self-improvement tools go around a lot, which tells you that that's something that programmers think is a good, valuable thing. And not that it's not, but that's a very overly represented app group. Right?

[39:33] **Henry**: Right. The idea that we're going to solve all our problems from some app or something.

[39:37] **Maggie**: A to do list app specifically. Preferably one with charts in it, and graphs. And that has an API to everything else.

[39:47] **Henry**: I guess I struggle with that. I have this engineering background but then I have this faith background and I feel like, it's not that it's in conflict, it's more of I don't want to measure everything and I don't think it's maybe even a good idea to measure some things. If you think about something like a prayer or something or, I don't know, is that something you want to really make efficient? It doesn't make sense to me.

[40:18] **Maggie**: Right. I will say, I'll preface this by saying I've thought about this way, way too much because I wrote my undergraduate thesis about the quantified self movement, if you've heard of that. So yeah, the people that enthusiastic, they track everything about themselves in a very hobbyist way. And so I looked at that anthropologically, how do we, why did that become a thing that's valuable? How do we become the age of the Fitbit? But this was back in 2012, 2013 so it was even before sort of the giant wave of it. Sort of wish I had written it this year, because it's gotten so much better.

[40:54] **Maggie**: But yeah, it comes out of a very specific belief system about what's valuable. Specifically the scientific revolution. The enlightenment that we very much, our brains and our bodies are two distinct separate things and that the brain is best body. And so we have to constantly be using our rationality to keep the body in check and obsessively amass numbers on it to make sure that it's in line and we're being good, productive capitalists all the time, the most we can possibly be. It comes out of very specific historical ideas that are not part of human nature, if that's even a thing. And are not inevitable and we don't have to sort of value these things.

[41:40] **Henry**: Yeah. And I guess that's kind of the water we swim in thing, where it's, we are born into it, so we can't not think that way until you kind of realized that wasn't how it was until that moment. And I, that's something I've been reading a lot about recently. That whole, I guess that essentially epistemology, right? Seeing how we learn, how we know, and this very specific way of truth being this, the most abstract thing. But then, I think inexperience, it's like, the more abstract something is, the more it doesn't really help in a way. Right? It doesn't help reality. And so, yeah, how do we move beyond this rationalist view of everything.

[42:33] **Maggie**: I think you've maybe spoken about that on another episode. I'm trying to remember who it was with on the value of subjective truth being something you've realized is so much more important.

[42:47] **Henry**: I specifically mentioning this book called *Personal Knowledge* and I mean, I mention it all the time now, I'm not tired of it yet. But, it's hard to talk about it because I don't want to come across as saying that everything is relative and that the whole, there is only or there is no truth, then you kind of just do whatever you want. Because I don't actually believe that, but it's just an addition that even if there is some kind of truth out there, the only way we can experience that that is through our own personal life, which is subjective and that trying to remove your personal bias, which is not always bad because obviously bias is not necessarily good. That if we get rid of it, that would lead to a lot of issues as well.

[43:36] **Henry**: Because this idea of being detached from reality, not experiencing the world. Like what you said, brain in a vat, right? That kind of thing. The, and this actually ties a lot to I think faith and religion too, because in my reading, especially Christian, we kind of bought into this rationalist mode of thinking such that, if you think about the old church or even just Catholic church there was an emphasis on ritual and liturgy, which involves the body. We think about Baptism is immersion into the water or communion is eating the body, and the bread and the wine. And so, if we slowly become more and more mental, let me remove all liturgy and then church and religion becomes just belief and, and now the most reductive version of church is, you sing some songs and then you listen to, a survey, which is just a TED Talk or something. And so, is that really what church is about?

[44:41] **Henry**: And so, you don't want to go the other way where it's too much into the liturgy where it's the problem was, people thought that focusing on that ritual was idology because we're not focusing on God, we're focusing on the things of this world. But the other way around is, we think that the mind is more important than the body.

[45:01] **Maggie**: Right. Right. Like the tech onset and historical beliefs. Interesting.

[45:07] **Henry**: I think that affects everything.

[45:10] **Maggie**: I like what you said though about the whole thing of the subjectivity in the, maybe an objective truth outside and apart from ourselves. Of course there are atoms and protons and sure. We know that chemistry, we get it there. There are certain scientific truths about that stuff and yet, it probably isn't as important or relevant or interesting to us as however we're experiencing the world in an embodied person in a culture and a historical place in time that, that experience is always going to be more important than whatever facts are in a textbook about science. But the denial of that, has been such an impressive project of Western culture I hope for the last couple hundred years is.

[45:57] **Henry**: Yeah. I think that that's definitely a part of that philosophy where it's, the more abstract and mental and rational you become, the more the history doesn't actually matter actually. Right? Anthropology doesn't matter and thinking about those sorts of aspects don't matter because truth becomes disembodied, right? It becomes a abstract, out there, not relating to ourselves. And I think that-

[46:22] **Maggie**: I've always been, I mean found that curious, or intriguing to about, when you just talk about a program, a culture, the whole obsession and glorification of disembodiment. In the sense of the whole thing of hack all night, drink Soylent, you are not a living being, you're just a mind in the machine and you're just completely cerebral. And that you don't need to be in your body and you don't need to work out, you don't need to move and you don't need to eat real food. And even the whole, the singularity is. All right. Upload your brain into the cloud. And these narratives feel very present. If you get on hacker news any of these days, there's for sure at least one link that's glorifying this exact sort of philosophy about the world. That it's very alive and well.

[47:16] **Henry**: I feel like, I don't know if I bought into it, but I definitely felt it a lot. And then I think I had to realize, at least in my faith as a Christian, there is aspect of, "Oh, if you think you're going to go to heaven, it's a spiritual thing." But we talk about this idea of the incarnation of God becoming a person, that's a spiritual being, becoming a physical being, then that would at least say that that's important.

[47:38] **Henry**: The resurrection is also the fact that, body is important, right? And so, from those kinds of, you can say doctrines about the faith, and it's, I don't think that is compatible then. And it's embracing of the fact that we are within a body and that physicality matters. Even though I think a lot of religions actually also emphasize the spirit and the mind of the body as well.

[48:06] **Maggie**: This is even, I'm not sure if we should even get onto it on this episode of the podcast. But at some point, if we want to dig into embodiment and metaphor. So, I know you just spoke about *Metaphors We Live By* on one of your recent talks and that, that book is probably my favorite book in the whole world that I can't get over and I'm obsessed with it. But its relationship to how we talk about metaphors of, of programming and the internet is, is very, kind of tangential to what we're going on here. That embodiment is, is the water we swim in. And even if we don't think it, when you really look at set specific examples, it makes you realize the way we speak about everything and the way we experience everything is inherently embodies.

[48:49] **Henry**: I see, the hunger and all these different kinds of bodily things. Yeah, that's true. I think as people in tech and using tech more and more, it does cause us to forget that, right? We're on our screens all day and now there's VR and AR and, is it matrix type stuff? It does help us to forget.

[49:15] **Maggie**: That's again the hopefully see as, it's just sort of a glitch in the matrix moment or growing pains moment or we haven't figured out how to make the internet embodied yet. Or we haven't figured out how to make tech embodied. And so, it's like we're just operating in the mindset of enlightenment, mind over body, philosophy as a whole thing. So we just think, we can just make everything a screen and make people stare into it and just pat it with their hands and that we don't need to use the whole body. But I would hope that as things evolve in the coming decades, we'll realize that's obviously not working for us. And two things to fix, embodiment and social bonds, not working right now.

[50:00] **Henry**: I feel like they have to be related. Right?

[50:03] **Maggie**: Yeah. It's certainly one and the same. Yeah. This is sort of big design problems that I do hope some high minded think tanks somewhere in Silicon Valley is taking seriously and working out in the next generation of the personal computer or the internet or whatever it is.

[50:20] **Henry**: I mean, there's also a sense where, if the majority of Silicon Valley thinks this way, then maybe the way out is not, the Silicon Valley.

[50:30] **Maggie**: I mean to be honest it's probably not Silicon Valley. Perhaps it's, the idealistic world of the democratization or teaching other people to program who are from different cultures and thinking other ways and we'll build different things with the tools we give them.

[50:49] **Henry**: I don't know how we're going to make it [inaudible 00:50:52] like that. I just read a book called *Tools for Conviviality*. It's by this guy Ivan Illich and he, it's a really difficult read for me. But a lot of it, I think about this in terms of programming where I guess he was an anarchist and he thought that all institutions at some point kind of have a lot of issues. So having the idea of school, he does not like that or even professions.

[51:24] **Henry**: And I think it's mostly because he thinks that, kind of like this, if there are a group of people, elite group of people, they get to decide what the future of this thing is. Then normal people don't have the chance to learn how things work because you have to go to school for five years like a doctor, stuff like that. And so, I mean, his view is rather, I think for most people, very extreme. But it's interesting to hear something about how, in a way, the more professionalized something becomes, the harder it is for anyone to get into it.

[52:02] **Maggie**: Yeah. Well, I mean of all professions at the moment, programming is probably the most impressive in it's openness. And for the amount of gate keeping that we complain about, it actually is rather impressive, the welcoming and open, or tries to be in its best efforts. We know far, far more so than, than being a doctor or a lawyer or whatever it is chemical engineer. We at least have the narrative that anyone can be a programmer, whether they can or not, that is another question. But when you get into material issues, do they actually have a laptop? Do they really have internet connection? That sort of thing.

[52:42] **Henry**: From that point of view, it does feel a lot more accessible. You just need the, some sort of computer or you can go to the library, have the internet and now we have all these free resources. I guess even open source in a way is part of that.

[52:57] **Maggie**: Yeah, because then it's the open invitation to actually build meaningful things. Right? That's one of the most valuable entry points where you, it's one thing to be like, "Okay, just do all these program and puzzles that will matter", versus "Do this one specific task that will go into a product that people are really using." I imagine that a huge tipping point for a lot of people.

[53:18] **Henry**: And I guess, for all the issues of boot camps I guess they have their place in terms of instead of going into a school.

[53:28] **Maggie**: There another one where I'm, maybe the current imagination of what a bootcamp is is just, it's just a bit rubbish right now and it just needs to evolve into something actually functional and not just something exploitative "We'll take 20% of your salary for 10 years." So I know we had some other things that, topics, but I'm wondering if it's better save for another one.

[53:53] **Henry**: You could probably go on for-

[53:56] **Maggie**: I don't embodiment and metaphors, it'll go for a while.

[54:04] **Henry**: Yeah, I think that could be a good next one then. We can end it there then. Thanks for chatting.

[54:06] **Maggie**: Yeah. Thanks so much for having me on. I so appreciate that you run this podcast and talk about things that aren't just, "What framework do I need to learn." And "What's the new animation library for React." This is needed interesting cultural conversation around program.

[54:23] **Henry**: Thank you. That makes me feel good too because I know, when I first, I was thinking about it, I think I bought into that mindset too of, "It has to be about code." What I said, my belief is that it's not, but then I think inside in my body I still feel that way. So it's, maybe going back to what I was saying about practice, it's like doing this podcast helped me to embrace that more.

[54:48] **Maggie**: Yeah. And I mean, nowadays everything leads back to code. You can tie anything in.

[54:54] **Henry**: That's what my friends tell me all the time, because I keep saying it and they're like, "Oh yeah, Henry, you probably think this way." It's like, "Oh."

[55:05] **Henry**: Thanks for listening. Check out our website @maintainersanonymous.com for show notes and transcripts. If you have any feedback, ideas or guest suggestions, you can reach me on Twitter @left_pat. If you'd like to support the show, you can visit patreon.com/henryzhu.
