---
title: "MA 16: Philip Gee (#3) on Life After Digital Death"
season: 2
date: "2020-09-23"
time: "33"
description: "What's life after removing yourself from social media? Philip Gee joins Henry (the last in the trilogy) to chat about LAT, life after Twitter. We discuss being irrelevant, forcing yourself to think about different things, treating a newsletter like email, restraining your growth, moving to the digital suburbs, engaging with the past, directing your attention and production, being particular and local, making it normal again to not have to create. (recorded in July)"
episodeLink: "aa1d84f7"
embedUrl: https://share.transistor.fm/e/a2900112
sidebar:
    order: 16
---

### Links

- [1: Growing Old with the Web](https://hopeinsource.com/growing-old)
- [2: Unlisiting Yourself](https://hopeinsource.com/growing-old)

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-2/digital-death.md)

#### The Trilogy

[00:00] **Henry**: I have Phillip Gee with me, again. The second podcast we just did was about wanting to leave the public internet. And then now it's sort of like what happens after?

[00:09] **Philip**: Life after death. Yeah, I don't want to get too morbid or too sacreligious, right? There are so many analogies you can make, but I don't want to push the boundaries too much.

[00:17] **Henry**: I was going to just bring up rebirth or something too, or resurrection. But you can say that cause you're just not online in the same way, right?

[00:25] **Philip**: Just feeding into my narcissism and Messiah complex here. Just terrible!

[00:31] **Philip**: So the recap is we did one podcast, like a year ago, and it was about growing old with the web. And that I've maintained a personal website for over 20 years and this Python tutor software for over 10 years. And just thinking about long term sustainability of maintaining an online public presence over decades.

[00:51] **Philip**: And the second one was about a month ago, when you found out that I started taking some of my stuff off YouTube. And you email me, Oh, what's up with you taking stuff off. And then we did a podcast, just brainstorming my plans to kind of quit the public internet.

[01:05] **Philip**: So now I have quit. I kinda officially quit July 1st. It's been two or three weeks of no public internet stuff for me and it's a good third episode.

#### A Movie Review By a Random Person

[01:16] **Henry**: There's different ways to look at getting offline. There's not producing new content and then also removing old content.

[01:23] **Henry**: It's not as straightforward as if you just deleted yourself, cause you acknowledge that you can't really delete anything. You're not pretending. I mean, you could do some detective work and find this stuff. You found the popular links and they're just unlisted, right?

[01:36] **Philip**: Yeah. I think that the most popular articles I've had, maybe a dozen or so. And then some of the YouTube videos, I just made them unlisted essentially. So new people probably will not stumble on them. But if people already have the link from their own website, it's fine. And I still have a few things on my home page that I keep up, like the most recent things, basically advice about academic life.

[01:58] **Philip**: But I kinda drew the line at like, anything that's not really part of my main job, I just take off because I don't think the internet needs to care what I think about. You know, not that I had a movie review, but one movie review by a random person who has nothing to do with movies, right.

[02:14] **Henry**: I see. The way a lot of people use social media is sort of, I just want to broadcast my thoughts cause you want to express yourself, right.

[02:21] **Philip**: Yeah. If I don't have any specific expertise, I probably will not post about it. So, this does mean no social media. Even if social media is used for work and professional things a lot, which is very beneficial. But I just kind of drew the line at no social media and also really no public blogging or YouTube videos.

[02:40] **Philip**: I think I will still write some stuff up and just link to it from my website, but very relevant to research.

[02:46] **Henry**: I think we went over some of the reasons. You've been on there for such a long time. It's not as fun anymore. You said you're feeling older, so you feel like not as relevant.

[02:56] **Henry**: In the end it can be distilled to quality over quantity. Maybe for you personally, it might be that freedom, being able to move on to whatever you want to do next. Kind of close that chapter.

#### Forcing Your Own Hand

[03:07] **Philip**: Yeah. I think that's a big part of it. I mean, all this stuff is extra curricular. You know, if someone forced me to quit all of this against my own will, it would still be fine because my livelihood doesn't depend on it, right. So all of the online activities are all for fun or entertainment or for helping others or whatever, right.

[03:25] **Philip**: So given that framing, the status quo is I just keep everything up, keep doing stuff maybe at a lesser rate. And the most extreme is to delete everything. And I'm kind of near that extreme there. And I think one advantage of thinking about that extreme is that it kind of frees up my mind to think, okay, what else can I do in the future?

[03:45] **Philip**: It's kind of like I forced my own hand, right? That if I stay with the status quo, I know how to make videos or do podcasts or write up things on social media. It's like all the stuff I've known how to do.

#### Email Is a Newsletter without an Archive

[03:54] **Philip**: And, you know, by forcing myself to be more semi-private, the one main benefit right now is that the newsletter that I have, which also is not public. So people wouldn't know what I'm talking about. I focus much more of my efforts on that, right.

[04:12] **Philip**: I'm thinking about what does it mean to distribute something in someone's inbox? And I've been sending out semi-private email news groups as well, and like focusing on targeting that message better rather than just broadcasting to the general public.

[04:27] **Henry**: A lot of newsletters, they have an archive feature, right? If you want to, you can basically look at all of the previous ones, which functionally, it's the same as a blog, right? But then for this if you haven't subscribed at the time that you sent that newsletter, then no one else would get it, right?

[04:45] **Philip**: Yeah. It's really like an email. Yeah I purposely don't archive it because otherwise it would just be like a public blog, but probably maybe a little less discoverable. Because it feels a little bit less indexed, but it's all still public. It's sort of like, once you're on that train, you're getting a regular dose.

#### Restrained Growth

[05:01] **Philip**: You know, I tell people you can forward it to your friends and stuff. That's fine, but just don't post it publicly.

[05:06] **Philip**: I basically don't want this sort of growth in terms of the newsletter subscriber base to the point where it's like social media, where it just kind of grows unrestrained, right? So there's a certain population or audience, which is great. And then it will increase a little bit over time as people forward it to friends, but it won't increase exponentially or anything.

[05:27] **Philip**: I actually purposely want it so that between episodes, people have that context. So it almost feels like episodes of a TV show where you're assuming that people for the most part have read the previous one, which you can't really assume when you're on the public internet because people come in at any time.

[05:43] **Henry**: Right. So that helps you write more intentionally because the assumed audience could be like literally anyone.

[05:49] **Philip**: That's right. Intentionally is a very good word and deliberately, yeah.

[05:53] **Henry**: Oh yeah. This reminds me of Patreon in general, right. A lot of the perks is just that you get private updates.

### Pay Once, Leak it Somewhere

[06:01] **Henry**: It does come with the concern of a private artwork or music or something, someone could just leak that cause they want to. One thing you can do is you pay once, get all the archived stuff and then stop paying. And then you just ruined it.

[06:16] **Philip**: You pay once, get all the archived stuff, leak it somewhere.

[06:20] **Henry**: So you can't really get around that, but I've heard of people complaining about that kind of thing. You're saying, I don't want to be viral essentially.

[06:26] **Philip**: That's right. You know, this is the whole age old story of digital media, right. That you can't really prevent people from copying and distributing stuff. So this is age old, starting with MP3s and music was coming about twenty or so years ago to movies, to artwork, to photos. There was no practical way to prevent that.

[06:46] **Philip**: So what is the value delivered? The value delivered is timeliness, engagement with the community, you might host a live stream.

[06:54] **Philip**: I mean, I don't do these things personally, right. But you can imagine hosting a live stream and they only invite the community members. In a way it's like the idea of paid newsletters.

[07:04] **Philip**: If someone pays a little bit, they're kind of bought in, right. They sort of have a psychological incentive to behave better in a sense, right. Because you know, they're bought into you as a person, as a creator, so they probably don't want to leak out some URL or invite a bunch of people from 4chan to crash their livestream, right.

[07:21] **Philip**: There's not really a motivation unless you have some rivals somewhere, right. And they purposely sabotage you. But that could happen to anyone, right.

[07:28] **Henry**: That's true. Yeah. We have found ways around it.

#### Convenience Over Everything

[07:30] **Henry**: I think about a lot of the services people use now, Spotify or Netflix, right. You could illegally do stuff. But there's the convenience factor. Make it so it's so easy, you'd rather just pay. At this point, people are kind of concerned a little bit more about privacy and ads. Even me, I find myself more willing to pay for things.

[07:51] **Philip**: Yeah. You know, in the early days of say movie file sharing, when Netflix or iTunes, whoever started coming by, you're right. It was absolutely a convenience thing.

[07:59] **Philip**: So if you're a kid and you had plenty of time, you could just stay up all night, looking on BitTorrent or Kazaa and Limewire, all those services, you know, trying to reconnect and download something. It takes forever because your internet was slow then, and they would like break after, you know, 95%. You wake up in the morning and like the movies corrupt, or you download the whole movie, and you start watching it and it's like corrupted or something, right. If you're a kid, it's fine. You're tying up your parents' internet or whatever. So they're mad, but whatever you're a kid, you have plenty of time.

[08:29] **Philip**: But that's like when you're an adult, I'll just pay \$3. That sort of calculation really flips because it's absolutely a convenience thing. When you're an adult, you don't want to just spend all this time tinkering around. Unless, you know, it's your hobby, right? If it's your hobby to play with this technology, that's fine. But for most people they make it so easy, to do the right thing in a sense.

[08:48] **Henry**: Yeah. I also think about how it's so easy to re-upload stuff. So say you wanted to listen to some music. You could just watch the YouTube video.

[08:57] **Philip**: That's true. Yep. Well now people are wise to that right? So musicians put up their music videos officially on YouTube, right? I mean, they officially put it up and then they have an ad in the front. So they recoup some of that money, cause they know people are gonna pirate it or whatever.

[09:10] **Philip**: And then with YouTube, the content ID system is so strong for music, especially. Essentially what happens is if they flag it, then if you monetize, the money goes to the original creator anyways. So as a user, you just see ads, which you're used to, but the record companies still recoup a lot of that money.

[09:25] **Philip**: And there's all this brouhaha in the YouTube world, right. Of what it means to have music, right. So if you just have two seconds of some song, your whole video is going to be flagged and that record company is going to get all your profits, right. Or you have to demonetize your videos. So the music industry and movie industries are still very strong, right, in terms of lobbying for copyright and everything. That's a whole other issue.

[09:44] **Henry**: Yeah. I mean the whole governance by algorithm. Yeah. I think we got off track a little bit.

[09:49] **Philip**: That's the point of these, you know, off-track.

[09:51] **Henry**: Maybe I'm just thinking too religiously, but yeah life after death. It is interesting to think about what that looks like.

#### Quitting and Twitter Brouhaha

[09:57] **Henry**: You said that it's been two weeks. I guess a simple question is like, how are you feeling?

[10:01] **Philip**: Yeah, no, this is good. I mean, the meandering is good. The podcast benefits.

[10:06] **Philip**: You know, I made the announcement quote, unquote, on the newsletter, July 1st, even though I had taken myself offline a little before. But that newsletter kind of laid out the rationale, right. And I won't repeat it here because either people have read it or they haven't so whatever.

[10:20] **Philip**: But because of that, right, even though I said in the newsletter, I'd rather have this not be public or whatever, you know, it was the first time I announced it so that understandably people were interested in it.

[10:31] **Philip**: So some people email me personally about it. I kind of talked to them a little more. And then other people unsurprisingly took to Twitter and kind of talked about how I was so active on Twitter and now all of a sudden off, and then there's this like brouhaha pretty much where like.

[10:46] **Philip**: I mean, I haven't been on Twitter in months, right. I deleted my account. But then like, people were just emailing me. I think there were threads going down speculating on like, did he say something terrible on the internet and stuff? Or who did he get in a fight with? Did you get canceled? Was there some like controversy? And I think some people deleted their tweets afterwards because I had told them I wanted this to be a private thing.

[11:06] **Philip**: So if I hadn't made an announcement in the newsletter, and I just went away quietly then I don't think any of that would have happened.

[11:14] **Philip**: And on the other hand, I didn't want to make a public tweet or a Facebook post saying, Oh, I'm quitting for these reasons. Because the point of doing this leaving is not to be public about it. I didn't want this to be performative, oh, I'm leaving because of these five reasons, on Twitter, as my last tweet. And like a mic drop.

[11:31] **Philip**: I purposely didn't want to do that. But because I didn't do that, people had a lot of speculation. So after that died down after a week or so.

#### From City to Suburbs

[11:38] **Philip**: I guess the feeling has just been kind of this quiet. There is this sort of, you know, I don't know if it's like a FOMO, but it's a feeling that this sort of low grade stimulation and gossip and activity is kind of like a background noise in our lives. And without that, it does feel kind of eerily quiet, right?

[11:57] **Philip**: You're used to being in a city, right? It's like you're living in New York City or whatever. You always hear a background hum, of cars and honking and whatever. If all that was suddenly gone, you'd be like, well, it's kind of weirdly quiet. That's I think the feeling,

[12:08] **Henry**: Okay. So it's like an awareness. I felt that when I went back home, but now I'm back in New York.

[12:15] **Philip**: Now there's a bustle. And then just like that sense of.. I don't know. it's a relief, but there's a sense that I didn't have to think about making new content on a regular basis. And that sense that given these tools were taken away or I took them away from myself, so I wouldn't be able to write tweets or make YouTube videos.

[12:33] **Philip**: Before I left, I was making daily vlogs for like several months since the quarantine. There were just five minute little things, right. They weren't edited at all, they're very impromptu. But still, it was like everyday I have to think of something to talk about. Or I would think, what should I write for my website or let's record a podcast.

[12:48] **Philip**: It wasn't that I had to do any of that stuff, but because all that stuff was available in front of me, I could think about doing it. Oh yeah. Maybe this thing would make for an interesting blog post or video.

[12:57] **Philip**: But now none of that's available. So I don't have to think about the possibility of producing anything. I can just focus on just doing what I do without thinking externally at all. I don't know if that makes sense.

[13:07] **Henry**: Eventually it became a burden. Because saying all those things and enjoying it, I think everyone would be like, awesome, keep doing more.

[13:13] **Henry**: But if you feel like that's the default, because your mindset is just thinking about those things and now it's not there anymore. I would say it could sound like a freedom or almost a sense of like, what do I do, right. Like what's left. Cause that was maybe how you define yourself in a certain way. Cause the way we spend our time is maybe how we define ourselves. That's gone, right?

#### Stepping Back By Not Producing

[13:38] **Philip**: Yeah. I would add an addendum that I feel like I'm offline and that I'm not a producer, right. Most people are not creators, right, in that sense. So most people, their notion of being online is as a consumer. So like when I tell most people, I just tell them for my own mental health where I'm just trying to disconnect and get offline more, which means quitting social media. And I think that's what most people can understand. They're like, okay, social media, I get it. It's too much stimulation.

[14:01] **Philip**: So that might've implied that I don't waste time on the web. Which is not the case, right. I'm not like a totally offline person. So I still spend a lot of my time consuming. Just like YouTube, podcasts, whatever. So that side hasn't really gone away, but the producer side has, right.

[14:19] **Philip**: It's unique in that sense, that most people think about stepping back as not consuming as much. Don't watch the news as much. Don't watch YouTube as much. But I can still do all that because I'm not interacting with people or producing content. I'm just consuming.

[14:32] **Henry**: Okay. So, one way I'm thinking about is like you are a creator and now you're back to being a lurker.

[14:38] **Philip**: Back to being a consumer. In terms of just pure consumption, I haven't really cut back. I do mindless consuming on YouTube with recommendations, which is just as mindless, right.

[14:47] **Henry**: Yeah. There's almost like a sense of obligation where.. I mean, there's so many ways to put this, but almost like a responsibility to be online. Maybe the word is informed. And if you're not then maybe there's something wrong with you.

[15:01] **Philip**: Well, that point's super interesting. I think the reason why is because when you interact with other people, say online, you need to be kind of in the loop. Else you say something wrong or you are just tone deaf in terms of what's going on, right.

#### Conflating Consumption and Production

[15:13] **Philip**: I mean, the thing with social media. It conflates consumption and production, right?

[15:17] **Philip**: So actually I was wrong in saying most people aren't producers. If you're addicted to social media, you are producing, right. You're producing replies, posts, pictures, arguing with people, whatever.

[15:26] **Philip**: So in that sense, if you're not tapped in well to the online stream, then when you're producing on social media, you're just going to say the wrong thing, or you're going to get a bad response. You're not in tune.

[15:37] **Philip**: But because I cut off that producing part, I don't actually have to be up to date on everything that's going on, right. Because if I'm not up to date, nobody knows because I'm not producing or interacting online. Does that make sense?

[15:50] **Henry**: Yeah. I guess with social media, there's always something that's happening. Like the zeitgeist.

[15:54] **Philip**: That's right. I feel even like, I can't even get back on that. If like tomorrow I had to get back on social media and post a bunch of stuff, I would probably be quote unquote bad at it, right. Because I just don't know what happened in the last few weeks.

[16:07] **Henry**: Yeah. I mean, it doesn't even have to be that long. I feel like if you're not on Twitter for like one day. This also depends on who you follow and who follows you, but I'm actually not really on as much either. I didn't remove anything and I'm still trying to post things.

[16:23] **Philip**: I think these semi-private formats, these small group chats, you know, a lot of the old school stuff, right, that is less than the view of declaring public. Again, all this stuff has been well-trodden ground before.

[16:34] **Philip**: If it's public, you don't have that same context. A public sphere has so many different contexts that just intersect. Your words may be transferred to other contexts where people don't get it as well. Or it might be co-opted to mean something else, right. Even if you're like, I'm just talking about JavaScript or whatever.

[16:51] **Henry**: Yeah. And Twitter tried adding all these different features, being able to only allow replies from people that you follow, something like that. It still assumes that the form in which Twitter works is okay, right.

[17:05] **Henry**: And some people are thinking maybe we need to change like the whole thing. People have had thoughts about different ways of thinking about things. In particular, philosophy of technology and just like reading more into that stuff.

#### Engaging with The Distant Past

[17:17] **Henry**: It's almost like for me, I want to engage with the past more. Like people that have written books, stuff like that. And also talking to people now about how that affects how we think about current events too.

[17:30] **Philip**: Yeah. Engaging with the present versus engaging with a past.

[17:33] **Philip**: I like this framing that, you know, when you're reading books, you're engaging with the past, right. And also things that have probably lived on longer, right?

[17:39] **Philip**: There were a bunch of terrible books written 50 years ago, but the ones that lived on, you know, they had impact and they had some kind of longevity. Whereas if you're on social media or just engaging with the present. Literally watching the news, right. Social media is very much news driven. You're literally engaging with the present all the time.

[17:57] **Philip**:And a lot of the thinking is about the present or the recent past. So again, it's like where you put your mind to, right. So if you cut off thinking about the present and you're deeply engaged with the distant past, that's obviously religion and philosophy and these, you know, ancient texts are very appealing, because of that reason, right. That it's the opposite of whatever's on Twitter today.

[18:20] **Henry**: Yeah. That does remind me of a newsletter from Michael Sacasas. He was writing about free speech. We brought up books, right?

[18:28] **Henry**: And a lot of these philosophy of tech people talk about the difference between different media, right? So like print media and digital media.

[18:37] **Henry**: In print, it's a lot easier to separate the author from the content. Because it's detached in so many different ways. One is that they wrote this probably like a while ago, right. Even if they finished the book and you bought it on the day of publication, they still wrote it like a few months ago, right. Or you read it and it's been many years.

#### Getting the Last Word

[18:57] **Henry**: Versus like what you said. On social media, when you're writing back to someone, it's almost like, even though we're not in the same place, you kind of assume that they're there, you know, like online or they're about to respond to you, right.

[19:09] **Henry**: Instead of the book, you don't expect the author to respond to you.

[19:13] **Philip**: Yeah, there's no comment section on the book.

[19:16] **Henry**: Other than actually your own notes. You highlight things and if you ever sell that book, right. They'll read that, but it's someone else.

[19:24] **Philip**: Yeah. There's external forums, right? There's goodreads or review sites or fan fiction where people post their own secondary sources. The engagement with the present thing is interesting, right?

[19:32] **Philip**: Oh yeah. I had this article about this and I'm like, Oh, I can't reference it anymore. But, I had one about different speeds of communication.

[19:38] **Philip**: So like the fastest is social media replies on your phone, right. So you're on the go. You reply to someone, and like you were mentioning, it's as though they are there, so you expect them to reply on Slack or whatever. And it's to the point where if they reply to something and you're in the middle of being out, doing something, you have this compulsion to reply back, right.

[19:56] **Philip**: Because it's incomplete, right? I need to get the last word. And that I feel like can be very unhealthy, right. And I took Twitter off my phone probably two or three years ago to avoid that. So I already started making steps several years ago. If you don't have that on your phone, at least you have to get back to your computer before you check or reply to stuff.

[20:14] **Henry**: Right. And even if it's not like random people, it can be bad even just in your own relationships with friends, right? The whole read receipt thing where like, you know that someone saw it, but they didn't respond. And then you start thinking all these bad things about why they didn't respond. People ask me like, Hey Henry, how come you don't respond to the texts? You know.

[20:32] **Philip**: Yeah, no, it's true. And it's like, because digitally we don't have that contact, people naturally assume the worst, right. They assume that you don't like 'em or they assume that I go, what did I say to piss them off?

[20:43] **Henry**: Yeah. Well I think it's kind of weird because if you are friends with someone for a while and they kind of act differently online, then I dunno. I guess that's the thing, do we have different personalities online?

[20:56] **Philip**: Yeah. I mean, that's so interesting. There are people who study all this stuff for just digital communication.

[21:01] The typical thing here is that the etiquette for texting is you have to be more enthusiastic or use more exclamation marks. Oh my God, is this guy mad or something. He just flat out said no with a period.

[21:11] **Henry**: There's that whole thing about like, how many exclamation points mean what? Yeah, and I guess the less that you've want to be online, then the more you're not going to be in tune with how people usually like to interpret those.

[21:25] **Philip**: That's right. The tuneness, it's a big thing. Obviously if you're in the public sphere with. Facebook or Twitter, I feel you have to be very in tune because as your audience size grows, if you're not in tune, then you are more likely to commit just weird faux pas, right. It's a big deal to whatever fraction of your audience.

[21:42] **Philip**: So I think limiting where you're interacting, you know, like if it's just your friend, it's fine. They might either tell you, Hey, this is not the great emoji now or they don't care because it's not in some public sphere. But if it's broadcast publicly, you know, some people might care.

#### Showing Charity to Those Things

[21:58] **Henry**: I guess I'm just kind of thinking now of the idea of character, where it's like with friends, they kind of understand who you are. So they would show charity to those things, right. Or at least they'll remind you like, Hey, this isn't okay anymore.

[22:12] **Philip**: Yeah. That word charity is really good.

[22:14] **Philip**: That's also with the newsletter, right? So given that my audience size is fairly constant, right. Every two weeks when I do a newsletter, a few more people join, which is fine. The thing is those few people join because somebody forwarded a past newsletter to them. So they kind of have a little bit more context.

[22:30] **Philip**: The goal is to have a fairly constant audience size so that whatever I end up posting in the future, people have that context. And they kind of know who I am already. So they are more forgiving, charitable or whatever.

[22:42] **Philip**: That also makes you more comfortable being more candid, right. So it's like just approximating these human scale interactions, right? You never think about this with your family or close friends or whatever. Like, Oh, how am I presenting myself? Cause you know that they know you, right.

[22:56] **Henry**: It is word of mouth, right? Like literally, instead of buying ads.

[23:00] **Philip**: Right, right. It's kinda like, how do you approach these human scale interactions that we've evolved tens of thousands of years of civilization to have, right. Obviously civilizations didn't evolve super peacefully, but there was a lot of tribalism and a lot of bad stuff.

[23:13] **Philip**: But the good behaviors that people agree on, conventions and stuff have established over time. I think online is just so hard because the audience size is so big and disconnected without context.

[23:25] **Philip**: That's not even that big of an audience, right. So at my stage, it was the low tens of thousands let's say, right. So if you were in the hundreds of thousands, that's another level or if you're the millions, it's another level and so forth, right.

[23:37] **Henry**: Yeah. It's just weird. All of us want to kind of spread the message, right. Evangelism of yourself or your ideas. And then you find that maybe you don't really want to do that because you want people to understand things, but then they need to have the context for it.

[23:53] **Henry**: So it'd be better, not that they would fully understand anything or you fully understand anything, but how close are you to what the thing that you really want to say is.

#### Spewing Out Stuff Undirected

[24:00] **Henry**: And I guess that just means like, it's just a problem of communication in the end, right? It's like, how do we make sure that people actually understand what you're saying? On your end and their end.

[24:09] **Philip**: Yeah, one way is to scale this down. I felt like one of the issues with being public so much is that you're just kind of spewing out stuff undirected, right? It's like you're a, you know, oil fountain or gusher, whatever, it's just going everywhere, right.

[24:23] **Philip**: And it's like, some people might catch some oil or whatever. Bad analogy, but it's undirected, it's completely undirected. And because of that one, maybe the people who really would benefit from it, don't find it, right.

[24:36] **Philip**: Because content online is so saturated and so SEO'd and so many scammers and people just filling up pages full of crap. If you search for something, the top results are probably going to be just paid for, not great things, right. Your mom and pop small indie blog will probably not show up very well.

[24:54] **Philip**: And then the people who you might not want to find it, like random scammers and stuff, will find it, because they were crawling the internet.

[25:01] **Philip**: If I could just direct that output more, then actually that's probably going to do more good, even if the audience is smaller, right. So it's like if I had an audience of 10,000 or a hundred thousand, if it's just spewing oil everywhere, and only 10 people could benefit from it, rather than I have say a mailing list or private referrals, right.

[25:20] **Philip**: Maybe that audience is only a hundred people, but most of those hundred people will get the benefit. That's still a better win than just spewing out the tens of thousands of people online.

#### After Influence, Staying Niche?

[25:29] **Henry**: Yeah, maybe what you're getting at is trying to be more niche.

[25:33] **Philip**: Yeah.

[25:33] **Henry**: There's some kind of aphorism where like the more followers you have, the more that your tweets turn into just like

[25:39] **Philip**: fortune cookie?

[25:40] **Henry**: Because you have more of an audience, you will maybe unconsciously cater whatever your message is to the lowest common denominator of person.

[25:49] **Philip**: Yeah, I think there was some of that. Maybe you don't want to offend people or alienate people.

[25:53] **Philip**: I feel like people who come up in the online world, they came up because of a niche, right? Like you were a really good Linux programmer and you're well known because you maintain some part of the memory subsystem deep into the kernel. And your early communications on the mailing list is all about this part of the kernel. Then you got all these followers and most just know you as some technology entrepreneur person who started a company.

[26:17] **Philip**: And then all of a sudden you start posting this giant thing about deep memory subsystems and screenshots of code and you laughing maniacally while compiling code. It feels kind of weird, cause most of your audience doesn't even know what you're talking about, right.

[26:30] **Henry**: I guess it can go both ways. You find out maybe you like teaching these concepts to people and you're really good at that.

[26:37] **Henry**: It's really like a test of your, I don't want to use the word integrity, but just like what do you actually want to do when you get popular? And you've always been able to decide what you want to do. But at that point, are you going to continue those things or change?

[26:54] **Philip**: Yeah, I think that's a great way of framing where I'm at right now, right. It's not big by any means. But if you're active on social media, unless you're known for something, you probably don't have the 10 thousands range. So I don't feel like there's anything I want to do with that to grow it or anything.

[27:07] **Philip**: Again, because my own career doesn't depend on it directly. And my personal enjoyment doesn't depend on that much either. So why don't we get rid of that and see what happens, right? It's like there's no harm to get rid of it, right.

#### Generality (Mega Church) and Particularity (House Church)

[27:18] **Henry**: Speaking more generally, I guess there's this dichotomy between generality and particularity. Where it's like, we feel like the general, the more abstract is like more right in a way, instead of being specific. That's what I mean by like catering the message.

[27:35] **Henry**: One particular example I think of is in the church context.

[27:40] **Henry**: So on one end, I would say there's the mega church model. Giant church with thousands of people coming in. And you probably in that case would have to say a generic message. The sermon, right. Maybe it makes people feel good or something. That could be because you don't want to offend or you want to welcome.

[27:57] **Henry**: And then the other side there would be this local church or at the very extreme would be a house church, right. You just meet in someone's home and it's like four or five people. In that case, you have to know the people individually. You have to know what they're going through. The things that you talk about are very specific to their issues, right.

[28:15] **Henry**: How do those things compare? I was reading about this as like, we don't want to turn the message into like this franchise of McDonald's, right.

[28:23] **Philip**: No, that's great. And thinking about that, the five people at a house church. If you just stood up and gave a megachurch sermon in that context..

[28:30] **Philip**: Like rhetorically, it's weird. Why is this person talking so loud? Content wise, it's like, we know you, why are you just saying super generic things?

[28:39] **Philip**: Whereas in the mega church context, another analogy of this is like musicians, right? So if you're performing at a small secret house show somewhere, it's going to be very intimate and like you can take requests and you tell little stories between your songs.

[28:50] **Philip**: But if you're performing in a giant stadium performance, it's like a stage show, right? It's very choreographed. You can't have that sort of personalization. Just totally sacreligious making all these different analogies, but people just want this sort of connection.

[29:06] **Philip**: You know, people can have that sort of collective experience, right? It is cool to go to a mega church or a Taylor Swift concert, because you, you experienced this with thousands of other people who are like minded and you get into this sort of state, right. And when you're five people, you can get into a very different kind of engaged state as well. They both can be good.

[29:23] **Henry**: Right. It could be a football game, I guess there's like burning man, all that stuff, right. Maybe I do feel like we are tending toward the general case. The Internet is sort of like that where we're kind of all trying to become the same thing.

#### The Small Scale is the Only Scale

[29:36] **Philip**: I feel like this is the scale issue, right? That there's this tendency toward thinking about scale, and if you don't think about that, it frees you a lot, right. So I purposely have not thought about scale, right? Like the whole point is not to grow and the point is actually shrink, right.

[29:51] **Philip**: And you know, I talked to family and friends who aren't online. For them the small scale is the only scale, right? So I'm like, let me go back to doing that. It's like, wait, nobody says I can't go back to doing that.

[30:03] **Henry**: Yeah, it kind of reinforces its own view of the world of scaling. This is so obvious in tech, right, everything is about scale. In terms of like a startup scaling up or a technology and your backend system scaling for all these users, cause we were trying to grow.

[30:19] **Henry**: Maybe that's why there's this reaction to wanting to go back to localism.

[30:25] **Philip**: It's ironic because, when companies take over this kind of localism, then it becomes like this franchise. How do we make money off of giving people this authentic local experience?

[30:35] **Henry**: Yeah, I talked about this on a recent podcast too. You can't really escape this commercialization of anything.

[30:40] **Philip**: Yeah, unless you are super off the grid, which is very hard. I'm not suggesting that I want to be off the grid. Not even to the point where it's like, Oh, I don't want to use Google anymore, so I need to run my own mail server and pipe all my searches through a bunch of other things. As a consumer, I'm still just as mainstream as everybody else, right. And I'm not like generating my own electricity.

[31:01] **Henry**: For sure. I guess I'm sympathetic to the idea, but because we're in this environment, I'm not going to just run away from it. Because I want to criticize the way we live now, it doesn't mean that people that are saying something different about technology are Luddites and don't want to use technology. It's just we are questioning the current thinking around it.

[31:23] **Philip**: Yeah. And bringing it back to, you know, life after digital death or whatever. If I frame it in terms of me getting off social media, everyone understands that there. It totally makes sense.

#### It's Not Weird To Not Make Anything

[31:32] **Philip**: I've been more hesitant to frame it in terms of me deleting the past, because if I tell people I deleted all my past stuff, it feels a little suspicious. Why don't you just leave it up and just not do anything? Why would you proactively do that?

[31:44] **Henry**: That might even be my initial reaction.

[31:46] **Philip**: Right, everyone's suspicious!

[31:47] **Henry**: But I think that's where, depending on your relationship with that person, then you could ask about it instead of assuming certain things.

[31:54] **Philip**: Right. Right. And I think the issue is that with scale, it may not be easy to explain to a lot of people. There are some people I want to reach out to, but I don't want to do it proactively because it feels kind of egocentric, right?

[32:04] **Philip**: It's like, by the way, did you know I went offline and I want to tell you about it, right? They probably have different concerns in their life and they don't wanna hear it about this, right.

[32:11] **Philip**: But because I don't talk about it, there's probably a lot more people who are speculating not online, right. Maybe something did go really haywire. Maybe I had a giant breakdown or something, and they don't want to bring up the topic because they don't know me that well, and they don't want to rock the boat or anything.

[32:26] **Philip**: So it's like this weird silence, right. Where I don't want to bring it up because I don't want to be presumptuous and assume people want to know. And if my acquaintances or colleagues want to know, maybe they don't want to bring up to me cause they are afraid. Especially now with all the Covid stuff, maybe something really bad happened to me personally.

[32:41] **Henry**: Right. People are on edge, mental health is certainly an issue right now.

[32:45] **Philip**: That's right. Everything is sort of an issue. Some people have emailed me genuinely concerned. Which is great, I'm glad people did. And then I give a somewhat brief explanation on things.

[32:55] **Philip**: But it's like, I don't want to make it into a big deal either, right. Because I feel like for the majority of people who were never creating content online, it doesn't feel weird for them not to be, right. I just want to be like one of those people.

[33:06] **Henry**: Yeah, most people wouldn't even think twice of that because they weren't in that world.

[33:12] **Philip**: Thanks a lot for just framing this discussion and everything. I'm looking forward to the final posted trilogy. Thank you so much, Henry. This was really fun and yeah, keep me updated!
