---
title: "MA 2: Stephanie Hurlburt on Boundaries"
season: 2
date: "2019-04-12"
time: "49"
description: "How is business development relevant to open source? Stephanie Hurlburt (Binomial) joins Henry to chat about understanding learnings from success, setting health boundaries, what 'networking' really means, conversations/pitching, and more! (recorded in February)"
episodeLink: da0b436a
embedUrl: https://share.transistor.fm/e/30b0ab32
sidebar:
    order: 2
---

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-2/boundaries.md)

[00:07] **Henry**: Today, I have with me Stephanie Hurlburt. She is a developer, but also does a lot of work on the business side. I'd like to talk to her about open source and her experience with networking, sales. A lot of things that I think a lot of open source developers don't have a lot of experience with, or even almost a willingness to learn. Thanks for joining me today.

[00:31] **Stephanie**: Yeah. I'm happy to. Before this, we were chatting about business and stuff. Henry, you were mentioning you've been able to be really successful and are hesitant to call it success because it's only been a few months or less than a year. You're not really sure exactly how you got there. I was saying that you know bits and pieces, but to replicate it is hard. I was saying that I noticed that in indie games as well because I'm in the game industry. Indie game developers will often get successes. They'll make a ton of money, but they won't really know how that happened. It's worthwhile to try to analyze it, learn business skills so that you can replicate what you're already doing right.

[01:25] **Henry**: It's just funny. I think it was Indie Game, the movie. I'm actually pretty into game myself and I guess interested in how people make games as a developer. Design wise too. It's interesting hearing their story. I was just wondering, why don't we have documentaries on open source maintainers? I feel like there's a missing thing where we talk about the impact of open source and what it does. Stuff like Linux and stuff, but I feel like there's not a lot of talk on the people behind it or even the history and that kind of thing. That's why I want to make this podcast about interviewing the people, not just what they work on, but more of how. Just like, “What's it like?” Because I feel like so many people use open source. They might hear about certain stories, but they don't know what it's like to be a maintainer.

[02:22] **Stephanie**: Yeah, absolutely. I think part of that is because indie devs are... I don't know how to put this. I don't know the full answer, obviously. But I think indie devs are... It's recognized that they own their studios. That they make a living off of this. That it's their project whereas I wonder if that's as true in open source.

[02:49] **Henry**: That's a good point because I guess in the end, you're still selling your game. People can look up like, “Oh, the studio made it.” Then you're paying for it. With open source, it's not like... I guess a game is more like any other kind of content like a movie. Right? People know the directors. Or YouTube videos. They're in your face, and you see them. With open source, you don't have to know anyone that works on it. I guess supposedly that's the whole point or the beauty of open source. Is that you don't have to know who works on it. I don't have to know who uses it. You're freely able to do whatever. But from a sustainability point of view, it's like, “I actually do need people to know that I'm working on it because otherwise, why would they give me money?” Right? It's like the, I guess, more emotional side to it. It's like if it's just some black box... Or I think the problem is people then assume that you're either making money or that you work at a company.

[03:50] **Henry**: I don't think people care enough to look into it. I've said this all the time. People think that I work at Facebook. Maybe not as much anymore, but originally just because the creator of Babel works there now, Sebastian. Maybe Facebook was the one promoting usage of it. But in terms of like who's getting paid to work on this thing, people don't know. You feel like you're talking about it all the time, but then if I'm not talking about enough.

[04:20] **Stephanie**: It's so true. I feel like there's this multiple kinds of cultures at play. There's the one where they think, okay, a lot of people who maintain open source libraries already work at corporations. Or they don't see the benefit of not working at a large corporation and maintaining an open source library. They assume that it's the same kind of ethics and the same kind of philosophy towards open source when in reality, your attention and focus and the way you approach it does shift. It can be beneficial to make money outside of working a full-time job at a corporation. I think there's the other end of it where there's a culture around anyone could contribute to this. Whereas an indie dev, they're like, “This is the creator's vision. Only they can make this game.” In a way, it's good not to go too far in that direction. But it's also good to value labor and to value the people who are creating the library and not just view people as completely replaceable.

[05:26] **Henry**: Yeah, I think I definitely struggle with that. I think there's a good quality in making yourself replaceable even as a leader. Right? You want people to feel empowered to make any change that seems good that you weren't thinking about. But at the same time, not every contributor cares about the same thing as you, or even has spent that much time thinking about it. You can't say that some random person that shows up in an open source project has the same say as a maintainer. Maybe I've been working on it for two years. There's a lot of people that come into issues. They're like, “Why didn't you do X, Y, Z?” Or, “Why didn't you do it fast enough?” All these different questions. They weren't willing to put in the time to think about or look at why. That's more like the whole entitlement demand kind of thing.

[06:19] **Stephanie**: It also reminds me a lot of when I first started selling middleware in the game industry. My background is, right now, I do open source work that isn't completely open source yet. We're still standardizing it. I also do proprietary products that I sell to try to fund this project. In the future, I'll have more ways of funding and more ways of doing open source, but I can't talk about that quite yet. But anyway, when we first started selling this product, we met a lot of similar resistance in industries that weren't used to buying middleware in the game industry. Industries that were used to making a lot of things themselves, they would say, “We can just build this ourself. Your skill sets aren't that special.” A lot of people can write image compressors even though, yes, in theory, but also 25 years of experience building image compressors is not invaluable.

[07:22] **Stephanie**: We get a lot of resistance of like, “Oh, well, if we just put an engineer on this for a year, we could just make the same thing.” That kind of mentality of being really replaceable. I've noticed that that's not present in all industries. In some industries, they recognize the value of having a third party vendor make something. Not just in technical specialty, but also in liability, in support, in basically getting to utilize a specialized skill set and a specialized team that doesn't fit in with your budget and schedules and can independently make sure something is healthy.

[08:00] **Henry**: It's really funny because I'm reminded of that now just even doing this podcast. It's like, should I spend the time to learn how to edit it and all the stuff? Or should I just pay someone? It's like am I willing to spend money on it for quality or all these trade-offs? I think it's not that different with open source. Trying to normalize that behavior of paying for open source. Like what you said, you can pay an engineer, say, by the project, I work on Babel, to make a whole version of the Babel themselves. But there are a lot of other things. You could definitely do it because you have enough money to, but it's like, do people want to work on that? Are you going to maintain this thing for the foreseeable future? Is your use case that specific that you need to make your own thing? It's not as simple as just like, “Oh, let's just pay for it.”

[08:53] **Henry**: Also, starting from scratch is a lot more... Maybe it's just a little bit of arrogance when you say, “Oh, we can make a whole new thing just because we have the talent and the money.” It's like you could pay maintainers a lot less than a whole full-time salary anyway, and you will get a lot of benefits.

[09:10] **Stephanie**: Exactly. It's kind of like I bought a couch. I also took a woodworking class this summer. I could learn to build a couch. I absolutely could. If someone was like, “No, you can't do it.” I was like, “No, I can study to build a couch.” But having something that's already built that doesn't break, that has a warranty, I would rather just do that. It's really interesting how people don't apply this attitude they have in so many other areas of their life to software. I think that instead of blaming the other person, and instead of saying, “Oh, it just sucks that this culture exists,” we should take responsibility for that and be like, “How are we impacting the way we're being treated? How can we up our sales and marketing skills?” So that instead of just going, “Oh, woe is us. This sucks. I wish culture would improve?” How can we say, “Okay, what are the marketing and sales skills to actually get the money and change this perception?”

[10:07] **Henry**: Totally agreed.

[10:09] **Stephanie**: I faced that as well. In the beginning, I was like, “God, you guys don't appreciate this.” Then I learned techniques to sell the middleware nonetheless. Some people, I just had to let go. Some people were just not going to change from their mentality. Actually letting them go was one of the best sales tactics I could have done. I just finished this book called Boundaries by Cloud and Townsend. I think you would actually really like it. It's this book about setting healthy boundaries in all of relationships. Essentially, you define what you're okay with and what you're not. One thing that we decided is there's a level of that like, “We could build it anyway,” that's just flat out disrespectful and we're not okay with. Setting that boundary of like, “This is inappropriate to talk about,” is way more powerful and alluring than just saying like, “Hey, stop doing that. We can build it. Let me explain myself.” Sometimes it's better to just be like, “That's inappropriate. You shouldn't [inaudible 00:11:22]. Talk to me when you realize it.” There's different strategies to handle that.

[11:27] **Henry**: I guess yeah. Personally and also in business, I like the whole like it's really hard for me to say no to things. Right?

[11:37] **Stephanie**: That is exactly what this book covers. It's interesting because I started it because of personal life. Then I realized it completely applies to business. The point is if you can say no well, they say that you will be a more loving and kind person.

[12:00] **Henry**: Yeah. It's funny because I guess it seems very unintuitive. But I think there's a lot of assumptions in being able to say... Obviously saying yes all the time means that you believe you have no limits. Right? Whether it's time or effort and all these things. I think in the end, to me, it's ultimately just pride. Right? It's feeling like, “I'm capable of doing all these things,” when clearly it's not. That's leading to all these issues of burnout and anxiety, which is what I do feel. Yeah.

[12:35] **Stephanie**: It causes several issues. I can relate to this as well. It causes you to feel resentful of the other person regardless of whether you want to or not. Like, “Oh, why are you putting this all on me?” Our previous conversation even reflects that. Like, “Oh, why are they treating us this way?” We get angry or upset at people. It also causes us to put this attitude on others and get upset when others say no to us. It's depleting and energy draining. According to this book, it also makes us less compassionate people to everybody.

[13:13] **Henry**: I find that I have... I guess personally, it's easier for me to just... I guess I'm too hard on myself. I have high expectations in that way. I understand the other person's point of view more. I guess I don't usually get angry like that. But it also means I put all the burden on myself. That's just as bad in a different way.

[13:41] **Stephanie**: Yeah. It's kind of like your anger is directed at yourself instead of the other person. It's interesting because the first step to setting healthy boundaries, you can't just immediately start saying no. The first step is allowing yourself to feel a little bit angry at the other person.

[13:57] **Henry**: Feels definitely like a lifelong thing.

[14:01] **Stephanie**: I feel that. I struggle with this as well. For instance, I was in this negotiation a few months ago where I was basically... We were in this negotiation. We wanted to do a paid agreement. They basically wanted a lower cost or free option before they launched into the big agreement to get it through bureaucracy faster and stuff. I was like, “Okay, I want to be paid for this.” They were like, “No, we can't pay you yet.” I immediately got on the defensive and angry and I was like... I responded with like, “Gosh. Well, I guess we'll put a limit on like 60 days for how long this could last.” He responded with, “No, no, no. We can make it 15 days. We just need to get past this humping bureaucracy.” I did not expect him to be so generous with that because he could have just taken my 60 days. I was painting the person as a hostile person. That's not right.

[15:12] **Stephanie**: If I had clear boundaries, I would have been able to assume that he was generous and just decide how I wanted to operate. It's tricky, but I can relate is what I'm saying.

[15:22] **Henry**: Yeah. I think I've definitely heard of maintainers. I try to do this too with the whole... I mean, I don't like this phrase, but killing them with kindness and whatever. But like what you said. I think being charitable, which is probably very important on any online communication, not just GitHub. But it's like when people make those issues, they're mad and all that. I think that's a problem. Being mad makes you feel like they're entitled, and it makes me feel entitled. Responding back compassionately, and then they respond back compassionately maybe. Right? I think one of us has to do it. Otherwise, it's going to be this cycle of negativity. Right?

[16:07] **Stephanie**: Well, it's interesting because I was talking to an open source maintainer the other day who was ranting super angrily in this semi-private chat. I was like, “Oh my goodness.” He was like, “I'm sorry. I have to rant angrily here because I have to be super polite in these waters.” I was thinking like, “Why can't you just be firm with the people?” Like I'll respond to you in two weeks instead of constantly caving in. He was expressing concern that like anything that wasn't caving in was going to be interpreted as being rude. He didn't want a scandal about rudeness in his community. I think it's really important to note that being firm allows you to not have that pent up aggression and be kinder overall.

[16:58] **Henry**: Yeah. I'm still learning that too. I think that's really good because I think people have this fear that if you say something sort of firm, I guess, that people will say something online and be like, “This maintainer did X, Y, Z.” They don't want that. They want to be as nice as possible. But then people just treat you like that anyway. Right? I guess over time, it just gets worse. This is why I wanted... It's like the idea of maintainers talking to each other and just, I don't know, hang out or even in person would be helpful as a support group. Because I feel like most people don't talk to each other a lot. Maybe on the same team, they do, but within open source itself. Yeah, you gave a talk about open source or podcast and someone messaged me, and they'll be like, “Oh, that was really helpful in the sense that I found someone that is feeling the same things as me. I feel better just because I heard a similar story.” It's like, “We should have those conversations more often.”

[18:01] **Henry**: Not because not any of us knows what to do, but at least we can understand that you're not the only one feeling that way.

[18:10] **Stephanie**: I also think open source would benefit from not thinking that its problems are unique to open source. Business people especially B2C businesses, so business to consumer, they sell to lots of people, like a mass audience. Nike is a B2C business. They deal a lot with the same exact problems. If they respond rudely on a customer support line, that could turn into a media scandal. But somehow, their solution is not to cave in to all the demands. Their solution is to set firm boundaries. Learning how they do it instead of just cave into these demands and then venting in a support group would be so beneficial. Taking that agency and self-responsibility, I think, would be really good. I think it's one of those things where it's not true that it would happen anyway. If you're firm, you're going to get more people being initially angry at you. But hopefully in the long-term, that will lead to a healthier community.

[19:14] **Henry**: Yeah, agree. Maybe it's just like the culture of open source. Even just the expectations that people have, which there are a lot of weird things that we have in this where it's like we have this expectation that 100% of the people have to like what you do. Obviously, that's impossible in any aspect of... Or any discipline. I don't know. Maybe we carry the same expectations across different projects. If this project does this, then when you... Because with GitHub, it looks the same, I guess, from the UI point of view. Even though people have like read mes and contributing code of conduct, those kinds of things, not everyone reads them. Maybe it's like this.

[20:02] **Henry**: Then adding that stuff, then people would get frustrated because like, “Oh, you're not reinforcing things.” When it's like, “No, we have like, I guess, norms and just that culture that's just unsaid.” We need to figure out how to make it more, I guess, sustainable from the maintainers' point of view. Because I don't know why we just feel like we have so much pressure and burden. It's completely volunteer for most people. The guilt or whatever that you feel is like... I just tweeted this earlier, but it's like self-imposed. I guess legally or technically, I can leave at any point. But then there's like this social thing where I feel like I can't.

[20:48] **Stephanie**: It's important to note that it's not all self-imposed. It is people making you feel guilty for leaving. That hasn't happened yet, but you are smart. You know it's going to happen. You're not just guilty for no reason. For instance, I don't feel guilty for not responding to customers right away. But it's because I know that none of my customers are going to get angry at me for not responding right away because I've set the right expectations. But you know that if you don't answer a request right away, there will be people getting angry. That in many ways is your doing. You can create this community.

[21:28] **Stephanie**: There are larger problems in open source. For instance, one unfortunate side of business is that to get money, you need leverage. I was talking to this well-known open source maintainer. He was on the cusp of getting some support agreements and feature agreements with this corporation. He was really struggling. It was just not happening. They kept putting it off and off and off. I asked him, “What's your leverage?” He was like, “Gosh, I don't know.” It's like, “Can you stop maintaining it for a while? Can you not respond speedily to people?” He was like, “Oh, God. I can't do that.” I was like, “If you're not willing to do that, making money is going to be very hard.” All of these problems tie into why it's hard to make money.

[22:20] **Henry**: It's so funny. That's so real because even in my situation, I'm making enough to have a salary. It's so weird. I guess I don't have to do any work because the work that I do doesn't... If you have the whole crowdfunding kind of thing, the way I'm doing it. Right? The work that I do has nothing to do with making more money. If you're doing contracting, the more companies or features you're working on, the more money you get. But with mine, it's like if I fix a bug or add a feature, it doesn't directly translate to people donating anymore. The only way I'm going to get more money is by doing the networking and talking to companies.

[23:00] **Henry**: I guess it's bad and good. It's good in that that means I can literally do whatever I want that helps the project. If I want to make this podcast, I should feel free to do it. But for some reason, I still like have my own view of not mentally, but based on experience of the habit of what I think a maintainer is or what they do. I think the typical maintainer, you think of them as just someone that writes code, makes releases, and triages issues. I don't want to do any of that anymore. But it doesn't mean I'm not contributing to the project. Right?

[23:36] **Henry**: Speaking or going to conferences, creating content, talking about open source and how we solve these problems, those are all valuable things. But maybe it's because I don't see it that much. I don't know how to measure success in the same way as knowing I wrote some code and made some commits. It makes it hard for me to know if I'm doing the right thing. Maybe when I quit or said I was going to do open source full-time, people expected a certain thing even though I wanted something else. It's hard to change.

[24:04] **Stephanie**: Well, there are two angles to this. There's two purposes here. There's one, which is like what, independent of money, you're expected to do as an open source maintainer. That's influenced by culture. That's influenced by all kinds of things. Then there's the second matter, which is what do you need to be doing to make more money? It's a really common problem in business to not know the answer to that second question. It's really common in the B2C space because you don't get to interact with all the people who buy Nike shoes, for instance, or whatever your B2C company is. You don't really know why they suddenly love the purple shoe. You're like, “Oh, God. Okay. Why do you like purple now?” It can be hard to interpret. Or in B2C, I ran into this where sometimes I get influxes of new customer requests. I'm like, “Whoa, where did this come from?”

[25:04] **Stephanie**: I think that you're legitimately feeling pressure because I am sure that there are things that you could do that would make people stop wanting to donate to you or stop wanting to give you money. It's worth analyzing why people are giving you money and what will make them stop so that you can release some of that pressure. It's not all on you to feel this pressure. You're feeling it for a very good reason. People might stop giving you money. It is not guaranteed. You can't just start doing nothing. But it's worth actually analyzing that and defining it.

[25:40] **Stephanie**: In my case, I had this rule for many years where I would have at least three networking conversations a week. That ended up... After trying that for a few months and experimenting with what I did, I realized that networking was a good base for getting new inbound requests. Experimenting and figuring out like, what is that key element that keeps the money flowing from a business angle is useful.

[26:08] **Henry**: Yeah, I guess another point is like... Well, this is more for me, I guess, because I'm the only one doing this full-time. But it's hard to get other people to want to work on that kind of work if all we know is the coding side, which is why I want to talk to you. I'm glad that you're interested in this space because maybe there's this expectation in open source where it's like I'm doing the coding. As long as I'm doing that, money is just going to magically show up. That doesn't work. I was willing to just put in the work, I guess, to learn things I'm not that interested in or I'm good at. But I know that that's going to lead to something different than what we're doing before. Like what you said, experimenting with different things, it can be enjoyable. I think one way of networking can be through this podcast. Actually something that I want to learn more about anyway and then sharing with people. Then people will understand the kind of work that we want to do.

[27:27] **Stephanie**: Exactly. I found this is especially true of engineers, people who aren't super experienced in business but definitely in communities, tend to view business as one of two things. It's like they either think business is like cold sales pitches. Like, “Hi, I'm Henry. Give me money.” There's a lot of very casual conversations that people understand might lead to getting the job. I think there's not as much of that middle ground where you have a pitch and you have an ask, but you're not throwing it in people's face. But you're still actively talking to lots of people and mentioning that. I want to see more of that middle ground with people doing business.

[28:28] **Stephanie**: I think people lean towards the casual side because they're like, “We'll see that as more enjoyable. It's like making friends.” Of course, it is. Business is not separate from making friends. But making sure to cultivate a pitch and throwing that ask is not out of place even in a friendship context either.

[28:46] **Henry**: Right. I think I haven't really developed that part. It's exactly what you said at first. I don't know. It's not really fair. You just don't want to be in that whole space because like money, that thing. I like talking with people. You get in conversation. I don't even have to bring up money. It's like, “Well.” It's kind of implied. I'm talking with them. They know that I don't work on a company. I work on Babel. What else is this going to be about other than how we can help you and open source in general? That's what I talk about. It doesn't have to come up explicitly like what you just said. Like, “Hey, give me money.” Just talking about our struggles, what they need, and just seeing what happens. I think you mentioned in the video, your goal isn't getting money from them right now for that one meeting. It's just having a relationship, meeting people.

[29:44] **Henry**: I think most people I meet are people that I already know online, or they are friends, or they can be friends. It's just building that relationship. I think it's even interesting. That person, they might leave that company but they go to a different company and they can still help me at the other place too.

[30:00] **Stephanie**: Yeah, absolutely. You cut out for a second when you were saying it doesn't... Were you saying it doesn't have to be about money?

[30:07] **Henry**: Oh, yeah. The intent. It doesn't have to be starting off the conversation like, “All right, we're talking about money right now.” It's just like, “We're just talking about open source because all of us care about it.” Then that might come up or something.

[30:20] **Stephanie**: Yeah. I think one thing worth noting is that you are unusually naturally gifted at pitching yourself. Not everybody has that skill. I've seen it firsthand. I've talked to hundreds and hundreds and hundreds of people and networked with thousands, a lot of people in networking organizations. You are like unusually good at describing what Babel is, why it's important. It's important to note that not everyone's good at that. You are naturally gifted at pitching even though you don't realize it. You can't give the advice of like, “Just talk about your product.” Because actually pitching is a skill and not everybody is good. It's worth noting like you might have to learn a bit about pitching.

[31:05] **Stephanie**: It's all about what we were talking about, about how to recreate success. Sometimes, you do things on accident or unintentionally that others need to know how to recreate. That's the skill of pitching. One thing I'm really passionate about is programming in general has this culture of like... It's either cold business, or we're best buddies and friends and a family. It's really important to have that middle ground. One example I ran into on Saturday is we were... I was at a book club. I do book clubs every Saturday. The topic got off of the book. People were like, “Oh, let's keep it to the book. That's why we're here.” They're not being cold by doing that. We all have limited time and honestly, we don't want to be best friends with everybody. That's okay. You can still have a warm relationship with someone.

[32:07] **Stephanie**: I love hanging out with my book club members without being best friends with all of them. I think that concept is really important to absorb. Dating is another good example. You might go out on a date. If you don't click romantically, you may not keep in touch with the person. That's not because you're an evil cold person. It's just like you're looking for... You know what I mean? It's important to think about business in terms of that middle ground of relationship.

[32:38] **Henry**: It was just funny when you brought up that I have a skill. I guess that's true. How would I even...? I'm just assuming that everyone is doing it and I'm like, “Oh, yeah. Just talk to people.”

[32:51] **Stephanie**: Pitching is a hard skill for some people. It comes naturally to others. It's useful to read up on what the components of a good pitch are if you're unsure which category you're in and improve that skill. I sucked at pitching when I started the business. I sucked at it. It was so bad. I read my own slides. I'm like, “No, Stephanie. It sucks.” I have been through the pain of learning how to pitch well. Yeah, it's hard.

[33:25] **Henry**: Yeah. Because people ask me like, “Where did you learn how to do sales?” I was like, “I definitely didn't learn that anywhere. I'm just a programmer and then just figuring it out.” Part of me is like... A lot of the reason why I got more interested in open source over time was at first, I just wanted to be a contributor. Code was cool. I wanted to put my name on the top of the list and all that stuff. But I think that's where... Why did I make that podcast about faith? It's like the part that attracted me more over time as I became a maintainer which wasn't about like individual features or issues, but about the overall whole scope of what we're doing. It reminded me more of the community aspect, which is something I'm very passionate about in even my own church, that kind of thing. I think being able to talk about what we do in a way that someone that isn't technical or isn't in your whole field is important to me.

[34:26] **Henry**: Maybe that helps translate because maybe the people you talk to don't know anything about your project, or aren't versed in the language or the framework or any of that stuff. Trying to talk about something so high level is important. I think I talked to my friend. He was asking about, how would you know someone is more senior? Being able to explain something in a simple way is actually... Instead of using all these fancy words and stuff like that can be a lot more helpful.

[35:00] **Stephanie**: Yeah. It's interesting how these business skills can end up actually just being accessibility skills like being able to communicate with a wide variety of people. If a business person who knows nothing about programming and looks at your website and can understand what you do, a junior programmer will probably be able to understand it too. One thing to note though, it's really interesting that you brought up the meaning or purpose or the good nature and community in open source. Because it is important to note that business and money does bias you and you can do it in bad ways. Business is unlike programming. Well, programming honestly is like this too. You can write pretty freaking unethical software, but it's not talked about as much. In business, it's more talked about in that you can do business in a bad way. You can also do business in a good way. Being aware of social impact and how the impact of your business decisions are affecting others is critical.

[36:11] **Stephanie**: I was dealing with this today. Someone wrote a comment on my post and they were like, “By the way, all open source projects that take money are evil.” That's in many ways saying all businesses are evil. If you believe that, if that's your ethical framework, I actually have respect for that. I get it. I wish we lived in a world without money too. But think about it. Is your local pizza shop evil? Is the mom-and-pop store near you evil? No, of course not. There are shades of gray. You might think, “Oh, money is just unethical for whatever reason.” But at least acknowledge that there are good ways to do business. Sometimes, you have to pull outside of the software realm to be reminded of that.

[37:01] **Stephanie**: I am saying this as a startup owner who is entrenched in Silicon Valley VC culture. I'm like, “Oh, God. I have to look outside software sometimes to remember where the good places are.” No offense if you take VC funding and are listening to this.

[37:16] **Henry**: Yeah. Even the mom-and-pop shop thing, I don't think you could get mad at the pizza shop for wanting more money and wanting to expand their business. I guess the norm is that, or it feels like the norm is that open source should be free. Maybe that has to do with the name and the history about like it's free. Then people think money. It shouldn't. But I think I've heard a lot of this before where if open source can... You shouldn't get paid for open source. I guess it implies that there's no cost in making it which obviously there is because people have to spend time working on it. People are normally just thinking about the code, how much it cost to write some code. I almost feel like I should be paid as a maintainer to just... Even just the thinking and the mental, I guess, load that you have to take to, I don't know, just put it all in your head. That is a lot of work even if you didn't write anything because there's thinking about, where's this project going? What's the vision?

[38:22] **Henry**: For something that's more infrastructure-based like Babel, it's not just some component in your library or UI thing. It's literally shaping the whole language of JavaScript itself and every single dependency that relies on that in each of their dependencies. I mean, not that we have to, but I think it's part of how it works that we should care about how it affects the whole ecosystem. Simply saying I want to pay someone because they wrote a commit is not capturing, I guess, the value of what we're doing.

[38:55] **Stephanie**: Again, this is something that's talked about a lot, but it's often not talked about with putting the responsibility on yourself. How can we put the responsibility on ourselves? Well, we can use leverage. We can show people... If you told the pizza shop owners, “I'm sorry, but we're not going to give you money. We want you to operate your pizza shop for free in your spare time and get a full-time job somewhere else and make pizza and give it to me on the side.” The implications of that are obvious because we're very well aware that they need equipment. They need to hire chefs and all these things. We aren't aware of that leverage in open source. If we say, “I'm not going to pay you. People keep maintaining it. We don't understand that.” But this gets into where business can get unethical. You can abuse this. You can at the drop of the hat stop maintaining everything in order to demonstrate this leverage that you have. I don't think you need to go to extremes. But I think it is worthwhile to consider leverage and to basically set healthy boundaries. It comes back to that.

[40:11] **Stephanie**: It's kind of like setting healthy boundaries in a healthy relationship. If you have a friend who is always asking you to hang out and getting upset when you don't want to hang out with them. They're just very clingy, very clingy. You could assert your power aggressively by yelling at them or by never wanting to hang out with them. But there's a middle ground of maybe not hanging out with them on Sunday. Maybe politely explaining why. I feel like we can hit that middle ground in open source.

[40:44] **Henry**: Yes, I agree. I think that gets into the whole... it's kind of like when you're independent, weekends don't really feel like weekends. On Sunday, everyone's like, “Oh, I don't want to go to work because of Monday.” But then when you're independent, either every day is a holiday or every day is a work day. I feel like in open source, it feels like literally every minute, you have to do something. Learning to be okay with not working. Because the whole problem is that we feel like we have to do all this work. Just simply stopping. Maybe it's once a week, or you take... Just being able to take vacation. Right? It's like, why do we feel like we can't take a vacation?

[41:32] **Henry**: It's funny. I was like, “Oh, I don't want to do dev ops because you have to be on call.” But then I realized like open source, I'm always on call in a way. I'm like, “I just subjected myself to all that.” Not learning what you said about being able to set boundaries, being able to take breaks and not actually work.

[41:52] **Stephanie**: It's interesting to think about it in terms of the clingy friend example because, what if that friend has all good intentions? What a lot of open source maintainers do is they essentially keep hanging out with the clingy friend. The clingy friend isn't trying to be evil, they genuinely think you're cool with hanging out with them all the time. You start to build up this resentment and be like, “This is so exhausting.” But you're not telling. Then the clingy friend gets so used to it that when you tell them to stop, they get really confused and upset because this is the first time you've expressed any sort of disappointment to them. It's going to be like a harsh break because you've set all these expectations with them. But at the end of the day, you are damaging the relationship by caving into something that you don't want to do. You're being a loving, compassionate person by saying, “Listen, these are my limits. I'm setting them because I don't want to become resentful of you.”

[42:49] **Stephanie**: Another thing open source maintainers will do is they will ignore the clingy friend. When the clingy friend finally gets through, they'll be like, “Oh, I'm sorry. I was just really busy.” They'll tell a white lie like that. That's essentially the equivalent of an open source maintainer. Getting a full-time job, drowning in that work. But wanting to maintain the library too and not being honest about the fact that they are essentially using leverage. They're essentially saying, “Listen, if you give me money, I'll be able to quit my job.” But there's this passive aggressiveness that I see a lot of the time.

[43:25] **Henry**: It's similar to just mental health in general of not being okay with just being alone and thinking about the problems that you have. Just distracting yourself with other things. Not asking yourself those hard questions of, why are you feeling this way? I think in the open source, yeah, you're right. It's almost like it's inevitable if we look at how open source works of just increasing users which is increasing support or needing help. Then you have limited time. There's some point where you're not going to be able to handle it anymore. Being, I guess, naive and thinking that it will just work out is not effective. Like what you said, we should be more proactive to say this is going to happen eventually. I might as well start setting some limitations or boundaries right now so that it won't blow out later. Right?

[44:23] **Stephanie**: Exactly. Boundaries are always most compassionate if set early. That's the problem, is that if it's too late and you're deep in it, then setting that boundary is going to cause anger and discomfort at first. But it's important to note that you're eroding the relationship by not doing it. Again, you can get extreme. You can start becoming a very controlling person or a very aggressive or very unethical. But there is a healthy balance to strike that actually allows you to be most compassionate. I highly recommend that everybody look up Brené Brown. She's this researcher that talks specifically about shame and setting boundaries and leadership. She talks about this at length. It actually really relates to open source.

[45:13] **Henry**: Then I guess another point on the people getting mad that people are trying to make money in open source. The other aspect is, who are the people working on open source now and what allows them to do it? That means it's only people that are able to support themselves or are willing to spend their free time doing it. Being able to pay people for open source can open up the opportunity for a lot more people to get involved. Not that everyone has to get paid, but I think it's more... It should be okay for people to be paid. I don't think 100% of people need to be paid for every single thing they do in open source. It's just that we shouldn't be mad that people are trying to make money or are making money in open source.

[45:55] **Stephanie**: I think part of this transition is going to involve being very open and honest about yes, money does bias people. There are unethical ways to do business. Yes, that is true. While that's also true, it also brings a lot of good. Instead of just like ignoring it or just looking at the bad, let's look at it from a balanced perspective of pros and cons and see whether it could genuinely help this project and how to go about it.

[46:24] **Henry**: Right. Exactly. I think that's the discussion we want. That we should acknowledge, like what you said, that money can be used in wrong ways. I mean, that's how the world works, I guess. We're going to be able to do a lot more in the long run. But we have to go through this, I guess, pain of figuring out how we're going to use it in the right ways. It's going to be very difficult, but it's worth working on. I mean, at least I want to work on it.

[46:58] **Stephanie**: It's amazing how much of business... There are some things in business that only happen in groups. There are some phenomena that only happen when groups of people get together. But there are others that feel very parallel to individual relationships. In fact, if you can be healthy in business and do that compassionately, it will come back to benefit all aspects of your life. Likewise, if you are really good in your relationships, maybe you can think of applying some of that to business. It's interesting how the two overlap.

[47:31] **Henry**: Yeah. Even recently, I've been just enjoying reading about people that are interdisciplinary or just have different, I guess, hobbies in tech. It's funny that before, I was so attracted to tech and all the technical aspects. I'm like, “Oh, all this other stuff helps a lot.” Not more, but it's just different. I think we can learn a lot from various people. Like what you said about business and open source, but also the thing I want to do on this podcast is also interview and just talk with people that are maintainers of anything. Right? They don't even have to be an open source maintainer. They can maintain like a YouTube channel or a live stream. They could be a gardener, a librarian. I mean, in that sense, it's almost like everyone's a maintainer. But I think being able to learn from people that can steward a community or has shared a public thing I think can be valuable to us where like you said, we feel like we're unique in our situation and where we're not.

[48:41] **Henry**: Thanks for listening. Check out the website, maintainersanonymous.com for transcripts of each episode. If you have any feedback, topic ideas, or guest suggestions, you can reach me on twitter @left_pad.
