---
title: "10: Trust"
season: 1
date: "2018-10-16"
time: "34"
description: Why do we trust anyone? We talk about trust as an act of faith, trusting people versus trusting code, and the relationship between trust and work.
episodeLink: "5b9ca809"
embedUrl: https://share.transistor.fm/e/30b20eda
sidebar:
    order: 10
---

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-1/trust.md)

[00:00] **Nadia**: So, this is our last episode. And we figured for our last episode we would kinda get back to the definition of faith itself and talk about faith as an act of trust in other people. Um, which is something that is also super relevant to software both at the social level of open source being the act of trusting random people to submit code or whatever else to your project. Um, and then also even on a more technical level of how- what are ways that people sort of like try to enforce trust on the code level or not, and does that make sense. Um, but yeah kinda zooming out, I guess just to faith itself and how it relates to trust.

[00:38] **Henry**: Yes, I think we were just discussing before that it- it feels like faith is ... I guess you can think of faith as like a noun and trust as the verb. And so, faith is um ... Or trust is faith in action. And it's like how we apply that. And yeah, when you face certain ... Especially in faith, it's like you're facing certain struggles in your life and you- you- you know, are you gonna have faith in yourself or in God or something, um, that you're able to get through this? Like do you have hope, um, for what's gonna happen in the future? Even though you have no idea what's gonna happen.

[01:11] **Nadia**: I actually have a story around this.

[01:14] **Henry**: Okay.

[01:15] **Nadia**: That like it's- it's a little bit of an anecdote, but um, it embodied like ... It was like, I think just like a great metaphor for me around understanding what that concept of faith or trust was. Um, I was at a friend's wedding a couple years ago, and the bride's father made the bride and the groom this like box that- Or no, it was like this ... He was like a magician. So, he did this whole like crazy magic trick, which was really cool at the- at the rehearsal dinner, um, where he had them like pick a card (clears throat) and then he like, you know ...

[01:46] **Nadia**: It was a typical like pick a card trick, and then he had- he went through like the entire deck and like you know, said like, "Is this your card?" No, no. And so, they- he still didn't pick their card. And then he handed them this wooden box and said, "The card is inside this box." Um, and like it's locked or something and they can only ever open it once. And then it's like, that's it.

[02:08] **Nadia**: Um, and so you'll never really know that the card is inside this box, but you just need to sort of trust me that I magically (laughs) got it in here somehow. Um, and was sort of like if you ever uh, are feeling low on faith or on trust or something like that, um, you know here's a key and you can always open the box and see that it's in there. But, the idea I guess was that like you would go years and years not really knowing the end of this card trick, and that whether he ever really did find the card (laughs) and put it in the box. Um, but you sorta just had to like trust it.

[02:38] **Nadia**: And of course, this is at a wedding, so it was like a very like ... Everyone was like crying and (laughs) whatever. Um, but I remember just being like, oh this is like a really concrete way to embody the idea of like this is what trust is. Or when people talk about like faith in God or like is God real or not? It's sort of like you ... I think, um, skeptics of religion tend to say, "Well, how do you really pr- How can you really prove it? How can you really know it?"

[03:00] **Nadia**: And I think the whole point is that it's like almost this more like beautiful idea to say you- Well, you don't. (laughs) And yet you keep doing this even though you actually don't really know whether, uh, whether the- any of this is real or worth it or anything like that. Um, and I think it's a really nice way to think about just like people in general. Where um, I guess like in my understanding of God, like I don't think of God as a person, so I don't really struggle with this idea of like is God real or not, 'cause I'm just sort of like well, God is a metaphor to me anyway, so like of course it's real, because it's a construct in my own head.

[03:32] **Nadia**: Um, but I do think like the part of like individual people where I think of like there being a bit of God in each person. Um, like that- that like, the way I would ... The closest way I can get to like defining what that is, is by saying it's the part of people that is like inherently unknowable or inherently undefinable. Um, which I think is consistent with this idea of God being something that you just like can't ever really like pin down or know.

[03:58] **Nadia**: Um, and I- I sort of like ... I- I think it's like a really nice thing that there's some like parts of people that we just like can't understand, and that are just sort of like undefinable. Um, and just like trusting that like I'm gonna have to interact with this person, I'm gonna have to work with people and just like trust them regardless.

[04:18] **Henry**: Wow. I think you brought that up before about like kinda like the mystery of faith and like God. And you know, I think that's ... I think it makes even more sense as someone that does believe that God is a person. Where it's like, in all of our relationships i- in that relationship you're trying to figure out more about the person to know them more, right? And to know someone isn't to know like you know, not necessarily like what they like or like who they are as in like these like attributes, quote/unquote.

[04:50] **Henry**: But um ... 'Cause then it's like, oh, I know this, you know, this room or this table, right? And with a person it's a little bit deeper than that. Or with like maybe your dog. And then with a person it's like, okay, they have their own thoughts that you don't know. And the only way to really know them is if they reveal that to you, right? 'Cause they have to respond back. And I think seeing God in that way is ... It just feels ... I mean, I guess in Christianity it- it- it just makes it all that it is, really.

[05:20] **Henry**: That um, that God isn't simply a metaphor, but um it was ... It's like, I think a lot of people have a concept of God, right? In their minds, like and you were saying. Um, but then in Christianity God became quote/unquote real, in that it became like ... I- It turned from a concept into an actual person in the body of Christ. And it- it kinda turns this like story or like um ... You know, like I- I think I mentioned this before, like you know like, there's like ... Everyone's so into like- like you know, like the Venom and all these heroes and superheroes and stuff like that.

[05:58] **Henry**: It's like, why do we seek after that so much? Um, and it's like in- in the person of Christ, it's like okay, we turned this myth into something that's reality. At least for some people. Um, and yeah, it just ... I don't know, for me it just, it makes it feel a lot more real, yeah.

[06:17] **Nadia**: Do you think there's some inherent concept that ... I guess like, if I was- if I were thinking about like trusting a God, I think I would assume that um, there's some aspect of fallibility about them. Or like to me, that's a big part of trust-

[06:33] **Henry**: Hm.

[06:34] **Nadia**: Is that like you know there's always the possibility of something happening that you don't expect or that you don't like, um or that's out of character, and that you continue to trust that person anyway. Um, but I feel like people usually talk about God as like a perfect being. So-

[06:48] **Henry**: Right.

[06:48] **Nadia**: Do you- Yeah. If someone were perfect, then why would you need to trust them at all?

[06:52] **Henry**: Yeah. Um-

[06:53] **Nadia**: (clears throat)

[06:54] **Henry**: I guess I would say that it's not that ... So ... Um, I guess that I would say the default is that we wanna trust ourselves. Um, and that makes a lot of sense, because if you can't um ... I mean, just going through life or whatever, like it feels like the way we should do things is like at least I should believe in me. Uh, and so believing in God is very weird in the sense that you're kind of going against that. And it's really hard.

[07:25] **Henry**: Um, and so you can still ... Like mentally, you can believe in your mind like, oh my God is perfect and all that, and I should trust in him. But, in reality it's ... That's why it's ... It is a daily practice, and it's something that it's almost like a, you know, we talk about like a spiritual formation or spiritual muscle. It's like trusting in something else is very difficult to do. Yeah.

[07:50] **Nadia**: Yeah. I think it applies to like relationships in general, too. And in particular I think like long-term partnerships and stuff. Um, where like I- I've heard a lot of people say that like- like the secret to like a very long-lasting relationship is having ... Is there always being some part of that person that you don't fully know. Um, which didn't make sense to me when I was younger, 'cause I just figured like well, you're with this person all the time, and isn't the whole point ... Isn't- isn't the sign of trust that like you're sharing everything with each other?

[08:20] **Nadia**: Um, but I think that I've started to understand that a lot better. Um, a friend actually said this to me recently about his parents. He said something like his- his dad uh, turned over and made this like offhand comment at some point that like I- you know, "I've been married to your mother for whatever, 30, 40 years. Um, and I still feel like I don't know everything about her."

[08:41] **Henry**: Mm.

[08:41] **Nadia**: And my first reaction was like, oh that's kinda sad. Like was that like a bad (laughs) a bad context or bad comment? And he said, "No. The point was that it was almost like this- this bit of awe."

[08:50] **Henry**: Mm.

[08:50] **Nadia**: Where like you could be so close to someone for so long and like have you know, turned over every facet of them in your mind, and still like accepting that there's just some part of them that will always be hidden off to you. And I think that's actually a really nice thing.

[09:02] **Henry**: Yeah. I- I think that really applies to God himself, too. It's like if this God is a perfect being, um and all-knowing, all that stuff, then in some sense you're always gonna not know. And there's that desire to wanna know him more. Um, that there is some sense of mystery. And you can't ... It's kinda the opposite. I would say that God knows everything about ourselves, but we might not know about him. And it's you know, almost like a purpose of our life to kind of learn, discover more of him.

[09:35] **Henry**: And not just to know him, but to we would say, enjoy him. And so, like enjoy God for who he is by himself. And I think that's really hard, because what happens is you- you tend to trust someone because of what they give you. Um, or what they can provide for you. Right? So, it's like I, like when people pray about things, they're praying for like um, certain blessings. Like hey, give me this job, or like so I make more money or whatever it is.

[10:02] **Henry**: Um, or like deliver me from some thing. But then, in the- in the midst of that you might lose the fact that you're trying to- Especially in your faith, it's like to desire God for God himself. Um, which just feels weird, but that's like what we do in our relationships, right? It's like we care about that person, not like that they're giving us X, Y, Z. And especially in Christianity, in some sense it makes sense because he's already given us everything. And in our faith we believe that God has shown us his desire to be with us, his love for us through, um, through Jesus.

[10:40] **Henry**: Um, and- and his- in that case it's through the sacrifice of his son. And so, a lot- It feels weird, 'cause it's like that's such a like negative thing. But it's saying that um, you know- you know l- love is about sacrifice as well. And so, I think if that's the ultimate act, or the- the core of the faith, then how else are we gonna live our lives so we can do that too? Not just for him, but for everyone around us.

[11:08] **Nadia**: So, how does this all transfer over to managing an open source project? (laughs)

[11:14] **Henry**: (laughs) Um, (laughs) ... I mean-

[11:17] **Nadia**: Smooth segue here.

[11:18] **Henry**: Yeah. Smooth segue. I- I guess at least in terms of like doing the maintenance part, um I don't know, this is kinda like why- why'd I do this at all. Um, I think the way you know, you- you wanna go about maintaining or leaving your project is through that I guess you could use the word like servant leadership. And I think it's like God is in a position where if we believe that God is like all-powerful and whatever, why would he like do- like why would he sacrifice his son? Why would he do all these things where it feels like if you're in a position of power, you should like have that, right?

[11:52] **Henry**: But he reigns through weakness. And I think in our sense, maintainers um, you know, we ... It looks like on the outside we have every- we, like we know what we're doing, but we're just trying to help other people. And I think for me it's like, how do I learn to you know, empower others to get involved? Which is, I guess Evangelism. But then there's also like being vulnerable and saying like hey, I have ... "I'm a flawed person. But yet, I'm still working toward this goal. And do you wanna be a part of that?"

[12:20] **Henry**: Because there's something bigger than ourselves that we can be a part of. Versus just giving people like random like issues, and expecting that they're gonna be inspired to wanna stay for this in the long-term, right? It's like, if you have a vision for what this is gonna be, um, then let's move toward that. And I think in faith we talk about like bring the kingdom of God here. Um, or in the kingdom of heaven. And that, uh, yeah, our allegiance is- isn't to this world or this city, but the city of God.

[12:53] **Henry**: I think it's ... And I- I think it's funny, 'cause some people might be like, oh that's kind of like ... That means you don't care about the world, this current place. But it's- it's saying that we do care about it, but it's not our ultimate goal. Um, and that through helping people hear, we're helping bring the kingdom here, too.

[13:12] **Nadia**: Hm. How do you know ... I guess like, how do you like ... Measure's not the right word, but like how do you intuitively know what level of trust you feel for someone? So, I was thinking like there's trust between like at one extreme, like uh, between a maintainer and like someone who's contributing for the first time. They've never heard of-

[13:32] **Henry**: Mm.

[13:32] **Nadia**: There's like no other reputation that you're aware of. And then all the way in the other extreme you also still need to trust like someone you've given commit access to, or just like your other maintainers. Um, where like they could easily just take over the project, do something crazy, kick you out of the org, whatever. Um ... Uh, and so there's some level of trust required.

[13:53] **Nadia**: Like, no matter how well you get to know someone, there's still like ... There's always some level where like you just need to trust them. Um, so how do you like sort of think about that gradient of like- Yeah. On- on some level you're just like not really ever trusting- Or, you're never able to fully know that someone is you know, perfect or something.

[14:11] **Henry**: Yeah. I kinda, especially in open source, it's really hard. Like if someone just makes a PR emersion and it's good, doesn't necessarily mean you're gonna immediately go in to add them as a collaborator. And, although I guess some projects do that. It almost feels like a ramping up kind of- Like not exponential, but like it just ... Like once- once they've gotten to the point where like, oh, you feel like they ... It seems like they care about the project, not just their own thing or whatever, it feels easier to trust them.

[14:39] **Henry**: And maybe it's just I feel like it's way easier to trust them if like maybe you met them in person, or like you saw them at a conference. Or- or maybe you've seen them do other things and different projects. So, um, if it's just purely based on like that one act, you have no idea. And maybe that's another important point, that it's not a singular thing. Just like maintaining a project is about doing it over time, just like software changes over time. Um, your level of trust for someone will grow. And I guess it could decline based on what happens.

[15:11] **Nadia**: An probably for like different tasks and stuff, too. Like yeah, you might trust people to do one thing, but not another. To what extent do you expect them to kinda like know their own level of trust, if that makes sense? 'Cause I imagine for some people, it's sorta like (laughs) they think they should be more trusted than they are. Or they think they've earned a certain level of trust or something, or- Yeah. And then like, how do you- how do you negotiate that conversation?

[15:35] **Henry**: No, that's a really interesting question. I'm not sure. I feel like, at least in my experience, the people that think they deserve more trust, um ... I don't know. I guess, you're always gonna be biased. So, like I feel like if you're in that position, I don't know if you do (laughs)-

[15:57] **Nadia**: It's like a weird thing to ask for, right?

[15:59] **Henry**: Yeah.

[15:59] **Nadia**: Like it's, I don't know. Um, like at the same time I also think like it's good to ask for things that you want or think you'd earned or deserved, and maybe people like haven't noticed.

[16:08] **Henry**: Haven't seen it.

[16:09] **Nadia**: Yeah.

[16:10] **Henry**: Right, yeah.

[16:10] **Nadia**: There's a-

[16:10] **Henry**: For sure.

[16:11] **Nadia**: A, uh Python maintainer who like didn't have commit access for a very, very long time and then just like at some point Guido's like, "Oh, we haven't give- given access to this person? Like of course." You know, but it was because just like no one had really brought it up yet.

[16:24] **Henry**: Ah.

[16:24] **Nadia**: Um, but like yeah. I don't know when it's like premature to ask for (laughs) someone's trust, versus not.

[16:31] **Henry**: May- Actually maybe it does, maybe it just depends on the maintainer of that, because I feel like we don't have this problem 'cause I spend a lot of time trying to figure out who is actually involved. Um, and so it's pretty easy. And then you know, maybe you make tools and you just track that thing and you just- I understand that. But, thinking back, this actually happened to me, where (laughs) when I was working on Babble, um, I did a lot of things without being a collaborator, and it was like way later when I asked um, the original creator, Sebastian, like, "Hey, can you give me collaborator access?" He's like, "Oh, I thought I gave it to you like months ago."

[17:04] **Nadia**: (laughs)

[17:05] **Henry**: And I never bothered to ask, 'cause I was scared. So, I guess that's very true. So, it kinda depends on like your situation with your project. Like are you actively like looking for that? If you're not, then it's possible there are a lot of people that should or could be added, but they aren't. Yeah.

[17:22] **Nadia**: So, I wanna talk about this a little bit, as um, also this question of like are- uh, whether you need to like trust someone's code, or trust someone as a person. And like when that is different, right? Like I imagine when you're talking about like maintainers or like very regular contributors, it starts to be really about trusting that person.

[17:39] **Henry**: Yeah.

[17:40] **Nadia**: Whereas when like it's the- some- someone's first time contribution, like it really doesn't matter who the person is behind it, you can kinda just like review the code and- and decide whether it's useful or not, right?

[17:48] **Henry**: Hm. That's a really good point, I think.

[17:50] **Nadia**: Is that true? (laughs)

[17:51] **Henry**: Yeah, I- I think that ... I think so. 'Cause like if you have no context on the person, then at some point you're- you're really just looking at the code. But, if you wanna be a little bit more responsible (laughs) I guess, I mean, every single person you look at you can look at their background or check on their profile.

[18:08] **Nadia**: Yes.

[18:08] **Henry**: You don't have to, but yeah.

[18:09] **Nadia**: Yeah, I mean, I was thinking like it almost seems like an uh ... Like thinking ... Making the switch from like trusting code to trusting people is, like an extra investment of your brain time also, right? Like why ... I don't know. Like you- you probably don't wanna go around like tracking their whole story on the internet if like at the extreme let's say, it was like a really simple change and you're like, "Alright. This change looks fine."

[18:30] **Henry**: Right.

[18:31] **Nadia**: Um, but there's some point where it's like alright, maybe I do wanna like invest more to understanding who this person is, 'cause they keep coming back or (laughs) whatever.

[18:37] **Henry**: Hm.

[18:37] **Nadia**: Um-

[18:38] **Henry**: Yeah, like if it's a typo, like you don't- you don't even- You're probably not even gonna look at them, it's just kinda like, oh, that was cool.

[18:43] **Nadia**: (laughs)

[18:44] **Henry**: But you're like, if you want them to like continue to stay, then you'll probably wanna be like, "Hey, what are you interested in?" That- that's more of like an onboarding process.

[18:50] **Nadia**: Hm.

[18:51] **Henry**: But yeah, if it is like a huge core change or something, then you're like, what's your motivation for doing this? Are you just trying to like add your thing in, or do you care about like the sustainability of this project? It's like, yeah, in some sense it is- it does feel like it's more important about the person, because if they had- don't have the shared vision of this project, then they should either fork it or do something else, because- Unless they're able to convince people.

[19:15] **Henry**: And usually, maybe they're just you know, mad or angry and it's like, okay if you're not gonna have like a civil discussion about this change, then we're not going to do it. Um, and I think it's people that can stick through that, um ... It's just I guess, maybe up- up front they kinda expect like, oh they're asking for help, and I made a PR, so then you kind of have to merge it for me or something.

[19:38] **Henry**: And then this is very true in anything, and especially in, I was just thinking about like [TC39](https://github.com/tc39). So like, the standards committee for JavaScript and like moving those syntax proposals forward. And like I think if you wanna do that, you might expect to spend like maybe you know, two years of your life trying to like make one of those things merge.

[19:59] **Henry**: But, if you told someone that upfront, then I think no one would wanna do it, because they're like, "That's a really, really long time." But, if you're able to explain like the process and then also that language, like it's 20 years old. You know, two years out of 20 years is not quote/unquote that bad. And how long is JavaScript gonna stay around? And like, and languages in general, right?

[20:22] **Nadia**: Hm. That's like another trust thing of like trusting in like future legacy. (laughs) Or like how, yeah, is this- is this a worthy investment for a long time? Because we expect this is gonna be around or it's worth spending our time on, even if you don't really know. Yeah. I- I- I like ... It's so just strange to see is just in the rise and fall of like programming languages or ecosystems over time. Where like how much do you decide to like deeply invest in a new language or ecosystem? Um, because it seems that it sorta like turns over every couple years.

[20:57] **Henry**: Hm.

[20:58] **Nadia**: But then there is some continuity that you see. Or like some- some language might like make a comeback after a few years or something like that. And so, yeah, like on a broader level it's like, how much are you trying to design things for like way off in the future, versus maybe just the next three to five years?

[21:12] **Henry**: Right. I guess that goes into the whole like (sighs) tooling fatigue and all that. Even though, it's very exaggerated, as someone that works on tools, but-

[21:23] **Nadia**: (laughs)

[21:24] **Henry**: Yeah.

[21:26] **Nadia**: When does it make sense to, uh ... Or when is it ever even really possible to uh, encode trust versus just trying to like trust people and accept that sometimes you're gonna be wrong? Um, 'cause I was thinking this comes up a lot in uh, crypto space space around this idea of like on-chain governance, which is (laughs) the idea that you can like basically enforce governance algorithmically in some shape or form.

[21:52] **Henry**: Mm.

[21:52] **Nadia**: Um, or that you- you ... Yeah, you want it to be a part of the code. Um, as opposed to off-chain governance which is like governance that's managed just like between people, um, that doesn't touch the code. And I'm generally like very anti on-chain governance, um, just 'cause I think it's like ... There is just no way to really um ... Yeah, I mean like I- I don't even wanna live in a world where like ruling of people is governed by code versus (laughs) by like human actions that are a lot, um, just a lot more malleable. Um, but then I was thinking like, on a much, much smaller level, like we do like things like tests.

[22:30] **Nadia**: Um, and like testing is like a really important piece of, it seems like, reducing the um, mental overhead for like random contributions that are coming into your projects, and just sorta like make the button go green, like you know. Uh, it's less work for the maintainer to have to think about. So, there is some level of saying like, "I don't have to trust you as much when I know that like your tests are passing." Um, so to me that feels like a very small way to say like, there is some sort of trust that can be like encoded into the projects.

[23:01] **Henry**: Hm.

[23:01] **Nadia**: Um, but then on the other extreme, the thought of like managing like the actual governance of a project on-chain seems like really off to me. Um, so yeah, where is that- where is that line between like- And- and- and on the other extreme, like is it even- is it even really sensible to say that, to like you know, not really deeply look at someone's code because the tests are passing, because like what if the tests are wrong?

[23:23] **Henry**: Wow. That was a lot. (laughs)

[23:25] **Nadia**: That was a lot. (laughs)

[23:28] **Henry**: Hm. That's interesting, though. Like, 'cause I always- I guess I always think of trust as being between people, but obviously it's ... You can, I guess and this is 'cause you're deferring it to something that's not a person.

[23:42] **Nadia**: It's between like, yeah, people, and code I guess, which is not that different ... I guess you could say, well, code is just written by people, so you're- you're trusting some person. Um-

[23:50] **Henry**: But you're just- Like, it's another level-

[23:54] **Nadia**: Yeah.

[23:54] **Henry**: Higher or down or whatever.

[23:56] **Nadia**: And there's like this idea of I guess, code is an institution ... If I- if I were thinking about an equivalent in not in software world, like we sort of just like trust the law or we all-

[24:08] **Henry**: Mm.

[24:08] **Nadia**: Have a shared trust in our government. Um, even if you (laughs) don't like the government, like we- we've all bought into this system where we agree that if you do something that's a crime, like there is some course of action through the law. And like, yeah we've all just sort of like bought into that idea. Or even like money is like an act of-

[24:25] **Henry**: Mm-hmm (affirmative).

[24:26] **Nadia**: Buying into the- The system of money is an act of trust. Um, so yeah, it's not- it's not ... But I guess it is also like, it's not really about ... I feel like that- that's still about trust between people. Um, because-

[24:37] **Henry**: It's always people all the way down, I guess.

[24:38] **Nadia**: Yeah. Like in the end, it's- it's a- it's agreeing that we're all gonna coordinate around this one system that we've ... Yeah, decided upon. Um, and if enough people defect from that system, then you've also ... That system doesn't mean anything anymore. So, I guess that's like to go back to like testing, maybe a similar thing of if people were to like really mess with the system or not respect it or not like take it seriously, um, or write bad tests or whatever-

[25:09] **Henry**: Yeah.

[25:09] **Nadia**: Um, then yeah, we- we've lost space in that system just 'cause we- we- we had agreed we were all like buying into it. Um, and if enough people aren't buying into it, then it's no longer a useful system to trust.

[25:20] **Henry**: Hm. I guess that just makes me think about like ... Well, we talked about like authority and leadership importance. Like, you're- you're trusting in some kind of authority. And then that gets to me to think about the other side which is responsibility. And I think there's this weird um, I don't know, dichotomy or parallel of where it's like, you wanna trust in other things, but then you also have your own responsibility, and especially like since we're using the example of testing, it's really ... It's easy to sometimes just be like, oh, I had the test so now I don't have to think about it as much.

[25:57] **Henry**: Or- or I don't have to be as responsible 'cause the test covered what I'm doing. And so, you have this false sense of security where it's like, oh, just 'cause I have thousands of tests, that means I covered everything and it's good. Or that- And then maybe, yeah. You don't get into the nitty gritty of like is this test even correct? And so, it's just like levels on- Now you have to have like tests for your tests or something. It's like-

[26:18] **Nadia**: (laughs)

[26:18] **Henry**: (laughs)

[26:19] **Nadia**: Yeah, it's like playing whack-a-mole. I think going back to um, the idea of trust and faith, it makes me think that like similarly you could say ... I-I-if originally we were talking about the story like how- how trust is about not fully knowing the other person or God or whomever, um and just sort of like accepting that you're not gonna know everything and that things might go in- in different ways, and that you might not have planned. And, um, and that's okay.

[26:49] **Henry**: That's okay, yeah.

[26:49] **Nadia**: Um, but I think like the- the flip side of that is to also acknowledge that it doesn't give you license to just like-

[26:55] **Henry**: Mm-hmm (affirmative).

[26:55] **Nadia**: Not care or not do anything. Like, I guess an extreme of that would be like someone who just like doesn't work or at all. Or, doesn't try or anything. It's just like oh, God will provide for me.

[27:07] **Henry**: Yes.

[27:07] **Nadia**: Um, but like obviously you need to go do something (laughs) in the world and like make some sort of like luck for yourself, or like do some of the work yourself. Um, and same in like relationships where like you can't just say like, "Oh, it's just gonna work out somehow." Like you have to actually like put a lot of work into a relationship to make it work. Um-

[27:22] **Henry**: Mm-hmm (affirmative).

[27:23] **Nadia**: But it seems like almost contradictory to say those two things. To say like, isn't the whole point that you should just like not know and accept that you don't know? But then also you're asking me to do work?

[27:32] **Henry**: No, yeah I think this is like literally one of the- the biggest I don't know, I guess paradoxes of faith. Um, but it's also I would call it, a healthy struggle. So, um what we think about is this idea that God is like sovereign, he's in control. And because he's in control, that's why we should trust in him at all. If he wasn't in control, why would we put our trust in this person?

[27:56] **Henry**: Um, but at the same time, like what you said, it doesn't mean we don't do anything. And so, we have simultaneously this idea that God is in control, but yet he has called us to be responsible for what we should do. And somehow those things have to align, and then we kind of believe in both at the same time. If it was all on responsibility, then we have no hope that- that we're ever gonna get anything done, because we're just ourselves.

[28:20] **Henry**: But at the same time, yeah, we're- we should do it. And I think this is a struggle that um, that you just have throughout your whole life. But um, yeah I think it's ... Yeah. I don't know. In some ways it's just like, I don't know, it's kinda cool (laughs) in a way too.

[28:35] **Nadia**: (laughs) Yeah. I think in like a- in a non-God context for me-

[28:41] **Henry**: Mm-hmm (affirmative).

[28:42] **Nadia**: Like, the way I think about it is, there's some- there's some per- Like if- if you're think- like modeling your outcome or something. Let's say it's like 95% work, or it's on you, or things that you can control. I don't know what the actual percentage is, but let's just say it's like 95%. And there's like some five percent like randomness factor, like a randomness beacon.

[28:59] **Henry**: Hm.

[28:59] **Nadia**: Um, that like you just ... You don't know what the inputs are, you have no idea how it's gonna change things, and you just sorta have to accept that it's like part of it. And like you wouldn't say, just because there is that five percent randomness that could like totally change your outcomes, like it doesn't mean you don't do the other 95% of the work. Like, you wanna- you wanna be able to affect your outcome as much as possible. And so, you wanna like put in as much as you can.

[29:20] **Henry**: Hm.

[29:21] **Nadia**: But you're also accepting that even if you do like the 95% perfectly, there's still some like randomness where someone's gonna just roll dice and like change your outcome enormously. And like that's just part of the game, or part of the system. And yeah. And so, if that happens you don't just say, "Well, I- I did all this work like why did that happen?" You just say, "Okay, that- that's part of the game."

[29:42] **Henry**: Yeah. Um, yeah I think we brought this up before, but um, especially in faith we ... When we talk about trust, it's not just like uh, how ... 'Cause we're talking about like how much do you trust a certain person. But uh- uh, just thinking back to stuff I've read where uh, the Bible talks about how it's not really about how much faith you have in God. Although that obviously still matters. But, that it's about like what or who you're putting your trust in.

[30:11] **Henry**: And so, this is an example that talks about how like if you have the faith of a mustard seed, which is a very small little, tiny thing. Um, even that amount of faith can move mountains. And the reason why you can say that is, because it's not because of you, it's the thing that you're trusting in. And so, if you believe in a God that is powerful, then even the smallest amount of trust means something to you.

[30:33] **Henry**: Um, and this is- I guess this is true for in other aspects as well. Like um, you know, when you're going on a- a plane ride to fly somewhere, you're trusting that the pilot knows what he's doing, or he or she, and then like the plane itself is gonna work and all that stuff. Or you go to the dentist, and you- you- you like, maybe you're really trusting that they're not gonna screw up everything. Um, and maybe you don't trust 'em a lot, right? (laughs) But, uh, but you know like, oh okay (laughs) they- they got a degree in whatever it is. Um, yeah.

[31:09] **Nadia**: It's sorta crazy to think about like ... You're describing as a mustard seed, but as (laughs) you're going through those kinds of examples like pilots and dentist and stuff, it's kinda like everything we're doing is ... Like you really just don't know anything (laughs) about anything.

[31:23] **Henry**: Mm.

[31:24] **Nadia**: Or I don't know, it's like walking outside is an enormous act of trust. (laughs)

[31:28] **Henry**: Yeah. That's true. Um, that's ... Yeah, like waking up ... I mean, talking about just like breathing and like all those things. Like, and I think that's pretty like well-embodied in open source. Like, when you actually work on code or you're a maintainer, you're like how does this even work at all? People are like, "Oh good job for like doing this thing." It's like, well it's only like one or two people, and then like millions of people are using it. And somehow it's still working. And you're just like, I guess you're living in trust, too. 'Cause like there's no way that you could even handle the amount of things you have to think about.

[32:04] **Nadia**: Yeah, so is like ... I feel like I also have this like mixed reaction to the- the deeper I dig into um, how open source works, because on the one hand you're just like, how is this functioning? This is like Popsicle sticks. Um-

[32:18] **Henry**: Yeah.

[32:18] **Nadia**: It's crazy. And then on the other hand, you're like, but it is functioning somehow, and has continued to function. Um, which I think actually again goes back with this question of like, well how much work do you do versus just sitting back and trusting? Because like I have definitely also had the thought of, "Well, if it is working-

[32:33] **Henry**: Mm.

[32:33] **Nadia**: Then maybe I should just, you know-"

[32:34] **Henry**: Chill.

[32:35] **Nadia**: Yeah. It's fine. Um, but then it's like, no. It could still be better even if- even if we can also trust that it's gonna function regardless. Like I think the healthcare system in the US is another example of this. Where like, sure it's still like working, I guess (laughs) in the sense that we have healthcare. Um, but it's like widely considered to be not great, either. It doesn't mean that we shouldn't try to improve these systems.

[32:55] **Henry**: Mm.

[32:56] **Nadia**: It just means that um, there's also some like, if you zoom out, some- some level of like magic and appreciation of that like just how much does function in this world. Um, despite like so many reasons why (laughs) it shouldn't.

[33:10] **Henry**: Right. And so, it's like you can appreciate and almost in awe of like that it works at all. We're not like celebrating how awesome it is.

[33:16] **Nadia**: Right. (laughs)

[33:17] **Henry**: We're trying to like make it better. And, yeah- It kinda- it kinda speaks to me in like- Yeah, just like the fragility of like all the systems that we have and you know, ourselves. And it's, I think it's really cool that when I read in the Bible about how like- like it says that like God uses the- the weak to oppose the proud. And like um, it's just interesting that he would use what you think is like people that are not in power to be able to affect that kinda change.

[33:46] **Henry**: And yeah, going back- even back to Evangelism. Like, it's like you're really scared of talking about any of this stuff. Um, and you have no idea what you're doing, but you kind of in that sense you're also trusting that something's gonna- something that um, that God will like kind of use you even though you are weak, or you have no idea what you are doing, and you'll still be able to make change. And I think that's like amazing in the sense that you don't have to be the you know, the greatest person in any aspect, right? And yet, um things still move forward.

[34:18] **Henry**: Um, and I think that's so true in open source. That you know, you have people that are unpaid, that probably most maintainers are accidental. Um, they didn't- They haven't- didn't have experience in maintaining before. Even for me personally I didn't have any experience in compilers or the thing I was working on. And yet, somehow you know like you- you actually are able to make things happen. Um, and in that sense ... This is almost like surreal in a way. Um, like how is this possible?

[34:46] **Nadia**: Thanks for listening. If you'd like to continue the conversation, you can find us on Twitter at [@left_pad](https://twitter.com/left_pad) or [@nayafia](https://twitter.com/nayafia) or on our website [hopeinsource.com](https://hopeinsource.com).
