---
title: "07: Mythology and Symbolism"
season: 1
date: "2018-10-16"
time: "35"
description: How do symbols and stories foster culture? We talk about stories as a way to onboard new contributors, the mythology of leadership, when leaders step down, and how traditions evolve over time.
episodeLink: "e46514ab"
embedUrl: https://share.transistor.fm/e/3f03502f
sidebar:
    order: 7
---

### Links

- Babel and Guy Fieri ("Favorite Moments" section): https://github.com/open-source/stories/hzoo#favorite-moments
- On Fairy Stories (Tolkien): https://en.wikipedia.org/wiki/On_Fairy-Stories
- "Time to Leave" blog post: https://medium.com/@mikeal/time-to-leave-a68294ccb2af

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-1/myth.md)

[00:00] **Nadia**: Today we're gonna talk about stories and myths and narratives and open source and how they build the history and community of our projects. And, I remember, when I first met you, Henry, you were talking about [Babel], and I think it was because I was asking you for an [interview](https://github.com/open-source/stories/hzoo) for GitHub and I asked you something about, like, what's something funny or memorable that happened in open source and you gave this story that, that was definitely more interesting than anyone (laughs), any other story I got.. about the whole like Guy Fieri thing and sort of like a, you know, [pull request](https://github.com/babel/babel/pull/3641) that went in and, uh, that was started as a joke and became a real thing, and then, like I don't know, there was like, a [sweater](https://twitter.com/jdan/status/819602334263152644) involved or something? It was just like a very elaborate story.

[00:50] **Nadia**: Um, but I remember thinking when I heard that story that like, like "Wow, Babel is like a really interesting project (laughs), or a really interesting community." And yeah. Just like the role of like stories a- as a way of um socializing people into what a culture is like very quickly.

[01:08] **Henry**: Hm, (laughing) that's really interesting. Because I guess coming into it, if you might have thoughts like, oh, this is a really technical project and it's like a compiler but then if you hear stories about like, you know, something as random as Guy Fieri then it kind of like what you said, it gives you context on what the community's about or the maintainers. In that sense maybe it's like a sense of like having fun instead of just, you know, doing work.

[01:36] **Nadia**: That was definitely my takeaway. And then I kind of like, after hearing that story, looked back at the like logo and the branding a little bit. I was like, "Oh. This is like a fun project." I remember digging around on like, I think one of the PRs related to that whole Guy Fieri thing and someone had commented being like, "These people are so unprofessional." (laughs) Uh which is funny 'cause like I didn't have that takeaway at all and I don't think a lot of other people did but um it sort of suggests to me like people have different ways that they wanna experience open source, and for some people it's like, yeah, they wanna feel like it's ... I don't know. It's like a very professional thing.

[02:08] **Nadia**: Um I've definitely talked to maintainers of projects where they think professionalism really matters. Um not to say that Babel isn't like a professional project, but I guess for some people, having fun on a project or doing something kinda like jokey would be um considered not professional. So it's just kind of interesting to see like I think, that plays a big role into which projects people end up spending time on in terms of getting involved with the community.

[02:31] **Henry**: Right. That's true. Thanks. (laughs) I guess I would hope that we are still professional. But I think, like what you said, it's like I would hope that, you know, we would like to be a, you know, welcoming community as well so especially given the fact that the type of project that it is, it kind of might scare away people? So I think having that is helpful.

[02:56] **Henry**: And maybe like also that kind of goes into sharing more about yourself personally as a maintainer, and then hopefully in that kind of, you know, expressing your feelings or whatever it, you know, showing vulnerability in that way to show that, you know, you're approachable and you don't have to be some kind of like genius or something like that. I think that's really helpful.

[03:18] **Nadia**: Mm-hmm (affirmative). It's definetely my takeaway. And even more broadly in open source, because I'm not involved in a specific project, I just, I feel like I've, for me, like a distinct positive association with spending time around open source developers is when I, you know, if I'm at like a conference or I'm talking to a maintainer and they're like really excited to share stories about like their culture, their community. Um 'cause it feels like you're sorta like being let in on this thing and I think in particular for someone like me that, you know, isn't actually involved with the community, it's sort of like this ... I don't know. It's almost like some version of small talk or something but you're kind of socializing people into making you feel really welcome and feel like they're like in on something or they're part of something.

[04:01] **Nadia**: Yeah, I mean getting that sort of cultural lore or background on people that are involved in the project, or just like odd jokes, or yeah, I don't know, symbols, logos, things like that that people use in projects, is a really easy way to make someone feel like they're part of it very quickly.

[04:20] **Henry**: Yeah. I think I find that it's almost (laughs) maybe easier, better to do that than necessarily convince someone to like get involved because of the technical aspects or things like that. Like there are lots of projects that you can get involved in that have high impact or are related to what you do but that doesn't necessarily mean that you want to be a part of it and I guess one way to differentiate is through those kind of things.

[04:48] **Nadia**: I wonder if that's one reason why ... like I feel like open source projects that, you know, as they get more popular, like a lot of them really invest in branding and naming. Not in like a ... I don't know, not in like a "fancy professional hire a firm" kind of way but just like, I feel like naming really matters and it gives people something really distinctive to associate that project with and if you just go like look at readmes of websites of open source projects, it's clear like people like having like mascots and like little jokes and stuff. I wonder if that just kinda goes hand in hand with the feeling of wanting to f- like, because Open Source is so community driven like we wanna foster that feeling of a community. Or just like making your project feel distinct in some sort of like intangible way, as quickly as possible.

[05:34] **Henry**: Yeah, I think (laughs) especially in the JS community, there's like this whole joke where like you're project's not real until you have like a logo. Um, and it is true. I think it- they're all just random little things that seem like they don't matter but um, you know, coming up with a name is important and like quote on quote branding and like what your website looks like. It'skinda like when you go to the readme and then you can tell when a project is kind of the old school version versus like they have all this stuff. You know, like videos and, you know, like logos and all this stuff um 'cause they're trying to get new people uh that might've not really gotten involved before to look at it. Um and I mean I don't think it's like a bait and switch or anything, it's just a certain presentation that maybe uh ... you know.

[06:28] **Henry**: Just like the way with companies, uh, I think of it the same way.

[06:32] **Nadia**: Hallmark's starting a cult. Or a religion. (laughs) I don't know.

[06:37] **Henry**: Yeah.

[06:37] **Nadia**: Yeah.

[06:38] **Henry**: That's interesting.

[06:39] **Nadia**: Just the idea of like um, I don't know. I think sometimes people have a very literal approach to religion where, I don't know. Like especially ... there are a lot of traditions in religions that sometimes don't really make sense today and I think there's a temptation for people who aren't involved to kind of look at it and be like, "Oh, well, you know, the only reason we don't eat shellfish is because ..." whatever. Um and to sort of come up with a sorta like literal historic reason why this tradition is sort of outdated?

[07:19] **Henry**: Mm-hmm (affirmative).

[07:19] **Nadia**: But I think that sort of discounts the value of symbolism and of like ... like I think a lot of religions are very strengthened because you're doing this thing and yeah, it's not because you have to do it in modern times today, but because it connects you to sort of like a longer past, and I think that's true for any sort of community where you want people to feel like part of something really quickly. If you're doing the ritual then you kind of just feel like you're part of something that's bigger than yourself.

[07:46] **Henry**: Right. I guess for a lot of traditions and rituals, there's a certain context that I think needs to be understood, especially- even if like it makes like quote unquote sense to do it in our current, I guess, time, or it doesn't, like knowing why they did it before instead of just simply just saying like, "Oh that doesn't make sense to me now." I mean you're kind of- then- then you're kind of just looking, you know, from the outside, not really understanding at all what's going on. Um and I think for a lot of uh traditions and rituals, most of those are ways to kind of ... it's like living out what you believe. So- or like a reminder of what- what you know or what you've read or something like that.

[08:38] **Henry**: So an example would be like um, in Christianity where you have communion. Um, or they also call it the Lord's Supper, where you know people, in different ways,they- they take some kind of, like they eat the bread and they drink some wine or I guess you can substitute that for grape juice or something and it's like, that seems like it's such a weird thing to do but in the New Testament, Jesus asks everyone to do that. And so they don't just do it just because he said it but like it's a reminder of what he did and then, it also points back to just like, I guess, um ... yeah.

[09:24] **Henry**: That, you know, if we- maybe certain churches do it like every week or they do it every month but, instead of just telling yourself like, "Oh, I already know that this happened," you know, we are creatures of habit and we forget things and we spend most of our times at work or doing other things, and if we are people that care about what we believe and our faith's important to our lives, then it should basically be a daily thing or it's a thing that you have to remind yourself. And I think doing something physical is important instead of just everything like kind of being like in your head.

[10:05] **Henry**: And also important is that it's done in community. And so you know, that way it's you- you're doing it as part of a group. And you're- you know, like you said, it's something that binds people together and especially if you're not like feeling up to it. I think there's a lot of emphasis now on like having to feel like, you know, the right way or feeling good, but it's kind of, in a sense, the opposite, where sometimes the act of doing it can make you feel the way you should versus trying to feel your way through doing things.

[10:41] **Nadia**: I want to separate out two things you said. One is sort of doing symbolism as a way of keeping yourself in a daily habit or reminding yourself of what the value is of what you're doing, and the other is doing it because it sort of like connects you to a community. It makes you feel like you're part of something bigger than yourself. And I wonder if those two things are sort of just like inter-related. Of like why do we do- why does symbolism help us stay in the habit of something? And it's I think because it connects you back to a longer tradition. It's almost like you're forgetting yourself, by reminding yourself that there's something bigger than yourself, if that makes sense.

[11:25] **Nadia**: I guess I was trying to say, is it about bringing yourself back to the ... back to the place where you are or is it about uh, I don't really know what I'm trying to say. But there's some aspect of like, it sort of like clears away I guess the, like, whatever you might be fretting about, and so you're... On like a very individual level, if symbolism and tradition can kinda help you just feel like a smaller part of something big, and by kind of losing yourself in that community then it kind of brings you back to where you should be.

[12:03] **Henry**: Hm. Yeah I like that. I think a lot of being in a faith community is about being a part of community. Especially in our current, I guess, age where it's- there's a lot of focus on individualism and there's and, you know, everything that we do in our lives is like kind of making us forced to think about ourselves more. You know, whether it's our phones or, you know ... all those things remind us of what we need to do and what's going to happen to us.

[12:37] **Henry**: I think getting reminded of being in a group and then especially, specifically what those things represent, that it's not about ourselves. And in the case of, you know, faith it's about God. And that's to remind ourselves that, you know, like, why are we worrying about ourselves when, you know, you could say that God is um, looking over us or something like that, and it's like we shouldn't have that anxious feeling and it's like, you can tell yourself that all day but you can't think your way out of it really. And so maybe the act of doing that thing is just something, maybe you could say special about that, that does change how you think.

[13:23] **Nadia**: Yeah, there's like something sort of like willfully illogical (laughs) about it. But I think it's kind of a nice thing because even though it's not something that we can really reason our way into, it seems to be something that a lot of people connect to. I mean outside of religion like the experience of going to a wedding or something, where like, yeah. I'm not a super like tradition loving kind of person, but if I go to like a friend's wedding, like you just sort of feel something that's um ... yeah. Something very visceral and it's not really about like them but it's about like the tradition that what they're doing is rooted in, or that ritual.

[14:04] **Henry**: Yeah. I remember, I don't know, I guess, like most people I think (laughs) especially now we tend to dislike tradition and kind of question the idea of most of them at all, and I'm kind of finding myself appreciating certain things a lot more, just ... um yeah.

[14:26] **Henry**: Like what you said. Just, there is something mysterious almost, I don't know, maybe supernatural, about some of those kinds of aspects and I think um, I think it's almost a sense of humility too, where you know, like I feel like a part of me just wants to just believe that my mind is gonna be able to, like is capable of you know, dealing with all these things. But you know, I need to rely on others and- and a lot of faith is about surrendering, like giving up your will for um others or God's will, and knowing that, yeah, you can't solve it all. So, I guess that's what faith is, right?

[15:10] **Nadia**: What about like symbols that are people? In a community? Like, leaders or figureheads or like BDFLs? Um, I feel like it's like a slightly different relationship 'cause it's like a real person, right? (laughs) It's not like a logo or yeah, an interesting meme or story or something like that, but it's like an actual person that's involved and I think people still look to leaders to provide that sort of like symbolism and meaning. I continue to just be sort of amused that there is even a concept of the "BDFL". Like whenever I have to explain that concept to someone outside of open source they're like, "I don't understand. They're called dictators but they're benevolent?"

[15:51] **Henry**: (laughs) I know.

[15:51] **Nadia**: It's a really wacky concept. But yeah, I mean, I think it becomes harder. Like I was trying to think, when we were talking about this earlier, of like what happens when symbols need to evolve or change, but I feel like I can't think of that many conflicts, at least not off the top of my head, in and around, you know. Like, "our logo is a gopher and it should really be like a rabbit or something". That's not really a conflict, but there are conflicts I think around leaders as symbols when like a leader represents something that you want the project to be, or that you, yeah. Or, looking up to and if that leader starts to not represent the project in a way that you want to, then it becomes a sort of question of, yeah, of like, how- to what extent does this person continue to embody like the myth of our community or our project or whatever?

[16:42] **Henry**: Yeah, (laughs) that's really hard. And I don't think, that's obviously not any different from, not like other industries or projects. Like I think you could think about like authors that people really respected, but then they're like, "Oh, they had certain views that we don't agree," and then they like change. Like maybe there was an award for that person and they used that person's name and they decided to rename it. It's like, is that- is that worth changing or is that, or is that okay and all that. Um.

[17:14] **Nadia**: It feels slightly different in- well maybe it's not. I feel like it should be slightly different in open source because it's like- it's supposed to be this like decentralized, self organizing community kinda thing, um where- like there is such beyond any one specific project I feel like there's this broader ethos in open source that like, there shouldn't be leaders or something like that. Like this is supposed to be this totally participatory thing. But at the same time, like it's obvious that people coalesce around leaders, whether we like it or not. So maybe it's just not actually that different, but um, it does seem just like ... I don't know. If someone founded their company and they're the CEO it's like, most people don't come in ... most companies are not organized in like a non hierarchical way. As I'm saying that, I'm realizing every company I've worked for is non hierarchical, but most companies don't have that- yeah, they accept that hierarchy. But I think like in open source community, um it's harder because people don't want to necessarily feel like they're being told what to do.

[18:22] **Henry**: Right. And then even from the maintainer point of view, like I don't, well, that's not everyone, but I don't do necessarily want to be the BDFL. And there's always like, because it's not really a company and- and it should, it'll hopefully grow beyond, you know, what you've created or maintained, that you can walk away and other people can take over kind of thing, right? It's like the project stays alive but you know, people can come and go kind of thing. I think that's what you're trying to get at with decentralized, right?

[18:50] **Nadia**: Yeah, it's like this very interesting test of, if a leader does step down, does a project move on? Um 'cause we saw this with Guido and stepping down from Python recently, um and I don't know enough about that situation to have deep thoughts on like how that's gonna survive or not, but when I heard about that it made me think about Django where Jacob and Adrian had stepped down.

[19:14] **Henry**: Yeah.

[19:14] **Nadia**: And they had stepped down 'cause they were sort of like ... at least the way it was publicly phrased I think was, um, like, "You- you guys don't really need a BDFL anymore." Like "There's a very, very strong Django community and we don't want to be that center point anymore." Like, "This community has grown so much that we don't really need to be the person to make decisions anymore."

[19:33] **Henry**: Right.

[19:34] **Nadia**: Which I think, yeah, it's like a nice evolution for, I think, other projects to maybe aspire to. And not every project is gonna be able to be as big as what they're doing.

[19:48] **Henry**: Right. I think that's really interesting to read about. Like I don't know that much about the context behind either, but I, from what I hear of these kind of things, it always feels like the people that step down, they usually say something like, "I haven't been involved for like a year, and so you've already basically been able to work without me. It's just that I'm officially saying that I'm not working on it." Um, which is really (laughs) interesting. Like it takes a long time for someone to feel like they can actually leave, even if they haven't been working on it. So there's like that almost like just um ... like they feel like they have to stay on even though they're not actively involved, and I think that's part of the anxiety of just doing open source. You have that sense of ownership that turns into burden, that you can't really step away.

[20:41] **Henry**: And that's like a long, like a higher scope thing, versus like, even for me like, I took a one week vacation, you know, before. I was like, oh, should I even do that or is that okay? You know, stuff like that.

[20:56] **Nadia**: Mm-hmm (affirmative). It reminds me of [Brett Cannon](https://twitter.com/brettsky), who's a Python person. He took like a month long vacation and wrote about it um and I think felt, yeah, this almost sort of like, is it okay to even be able to take vacation from open source and then it's like, well why shouldn't it be? (laughs) 'Cause like, yeah. You can take a vacation from work but you can't take a vacation from something that isn't even ... yeah. It's just a strange thing.

[21:22] **Henry**: Yeah. It's uh, like at work you wouldn't ... (laughs) You wouldn't question it at all. You would just do it 'cause that's normal, and you're always fighting this like messed up expectation that you have, that I guess we've all really created. Like that's our culture. Um and it's kind of up to us to take the action to actually, you know, take breaks and maybe even announce it, just so like everyone knows that that's a thing, and just to tell yourself and other maintainers, like that's normal and you should do it. (laughs)

[21:52] **Nadia**: Mm-hmm (affirmative).

[21:52] **Henry**: And then we won't have this problem. (laughs)

[21:54] **Nadia**: I wonder if there is like an optimal time for a maintainer to step down or not- just in terms of like the trajectory of the life of the project. 'Cause I feel like on the one extreme, there are maintainers that just straight up like ghosted a project and that's problematic, mostly because if they're the only people with like commit access then (laughs) um ... or they own the project or something like that there's just like permissions issues. So it seems problematic for a maintainer to just like straight up disappear.

[22:18] **Nadia**: Then on the other hand, you have maintainers who just like won't let go and won't step down even though maybe a project would benefit from that not having as strong of a present. But then there's like this whole gray middle area where I think like there are maintainers who would like to step down but worry that um if they do, like who's gonna take up the project?

[22:40] **Nadia**: I remember Mikeal writing something, [Mikeal Rogers
](https://twitter.com/mikeal). He was writing something about this a few years ago when [Nolan Lawson](https://nolanlawson.com/) wrote that [post](https://nolanlawson.com/2017/03/05/what-it-feels-like-to-be-an-open-source-maintainer/) about like what it feels like to be ...

[22:48] **Henry**: Mmm.

[22:49] **Nadia**: ... an open source maintainer. I think, I think it was Mikeal that like wrote a response to that being like, "You just gotta step down (laughs) if you're feeling it." Um.

[22:57] **Henry**: Yeah, I think I read that. He said that, yeah.

[23:00] **Nadia**: Yeah and he was like, "You just need to trust that like someone is gonna take up the mantle." But yeah. That's a very scary thing where it's like, it seems like a really nice sweet spot is that time where you were sort of talking about, where you're sort of like defective, haven't even been involved for a while, so it's easy to kind of be like, "I'm not even doing anything. Like I've kind of been silently fading into the background. You're gonna be fine without me."

[23:23] **Henry**: But yeah, I think ... but I feel like for that it's like, for a lot of people, at that point they just- they're at the point where they don't want to be involved and so they're at their limit where they just can't help not working (laughs) on it, and then slowly they're like, "Okay, I should just leave." (laughs)

[23:38] **Nadia**: I guess it's not a great ... yeah, it looks good on paper in terms of how you're announcing it, but probably I guess the feelings leading up to that are just sort of burn out, right, which is not a ...

[23:47] **Henry**: Yes.

[23:47] **Nadia**: ... a great way (laughs).

[23:49] **Henry**: Yeah, I'm sure there's like existential dread on all that when- like that's for them, and no one knows about that and they don't- like just regular people that are using it, they have no idea. So like they're just like, "Oh, okay. They stepped down." (laughs)

[24:01] **Nadia**: I wonder about like- this is making me think about like the difference too between authors and maintainers and an author ... 'cause I mean we were kind of originally talking about like narratives and this and symbols and things like that, and like authors that are serve as like the symbol of the project or are most closely associated with the project, even if they're not super involved anymore, and other people are maintaining it and like, yeah. I don't know. Like is it useful to have the author as a symbol? (laughs) Um ...

[24:34] **Henry**: Yeah.

[24:35] **Nadia**: If it's like a very well known author. Or does it end up becoming detrimental when like they're not involved with the project anymore?

[24:43] **Henry**: Right. I uh, I guess I've had experience with that because [Sebastian](https://twitter.com/sebmck) was the creator of Babel and then he stepped down. But then I think people pinged him like you know, for, you know maybe even years later 'cause they thought that he was still working on it and there's probably still people that think he still works on it. Um and (laughs) I guess it's funny. Like when you're the creator and you step down, you're probably gonna get people that ask you about things for a really long time. I guess that could be annoying and then you have to tell people and then that transition is really hard um and I guess, in some sense, it seems nice to have a like a point person for people to talk to, but then that's also like a point of failure where, if they're not there then no one's gonna respond, and they're probably gonna get overwhelmed and that's- to me it just feels like uh the most important thing you can do as a maintainer is make sure that you always have more people.

[25:37] **Henry**: Um you're all- I don't think there is an optimal time to leave because there's always a feeling of you could be doing more. There's a fire here. You know like I even took the break like right after we released Babel 7, and maybe that could've been the worse time to leave but I did it anyway. (laughs) Um, yeah. I think uh, yeah. You just can't. I guess yeah, you just can't rely on one person and I don't think you'd even want to, so.

[26:04] **Nadia**: It seems like there's like a couple different roles that an author's fulfilling, that's sort of like, an author being considered a maintainer seems like problematic um because if they're not involved in the project (laughs), they don't want people pinging them all the time and ah, it's just confusing for people. And also, when a relevant author has uh- and their influence on I guess the culture of the project? Like do you feel like, I don't know, both technical, decision, cultural decisions Sebastian made early on, do they continue to live on even though Sebastian isn't literally involved in the project anymore?

[26:42] **Henry**: Yeah. I think that, well maybe it's different for projects or people but we- I think I definitely uh- I think you definitely learn form whoever started it. Like it's really hard to actually change things unless you rewrite the whole thing and it's unlikely that you'd be willing to do that especially if you weren't the creator, 'cause you might even feel like it's out of your place to do that. I know that I felt like that, even in terms of like making and breaking change or making a major inversion because I thought- I even thought that he was gonna come back. So there's that and then it takes, you know, maybe a year or so and you're like, "Oh okay, I guess we're the only ones working on this now. If- we should probably figure out how to make this better versus just fixing issues."

[27:29] **Henry**: I don't think it's just technical. It's definitely cultural, too. Um you know, the things that you start off with you kind of just, I guess, evolve or enhance. Um, I think it's really hard to just suddenly change a shift in community or culture. I know even like- I even noticed that habits that he had, I would kind of pick up on. Like the way he maintained things was like, say, someone would made an issue, and he would like make a commit to fix it without a PR and just like immediately close it within like five minutes? Um and so I think when you are- especially if you are new to a project, you kind of just- you pick up on things. It wasn't like written anywhere that you- you have to do this. It's just I noticed like, oh. He was really responsive. I guess I should be responsive 'cause I don't know how to do it either.

[28:23] **Henry**: And then I guess it leads to a lot of people doing that, um until you look back and you're like, "Okay was that ... is that a good idea? Is that healthy? Um should we change it." And then maybe, hopefully, we actually write it down, otherwise people are just learning, picking up things without us actually explicitly saying that's a good idea or what we recommend.

[28:45] **Nadia**: Yeah. That's um ... there must just be like a lot of points where people are like, "Well why do you do this thing?" And it's like, "Well, I guess because, you know, I was told to," or, "The original maintainer liked doing it this way," or something like that. And then how does the community decide which of those decisions makes sense to continue doing and that they're gonna sorta like incorporate into their culture and their history, and even if it doesn't make sense, just be like, "Well, that's the way he wanted it." Um versus saying, "Well, maybe this rule doesn't actually make sense anymore and we should move on." I feel like that's where it comes up against this tension of like tradition um or history or theism or whatever, where how do you know which traditions are worth changing, and how do you know when they're not? And yeah, my guess is just it has to reflect whatever people like ... I hate to say, just some sort of like majority consensus or something (laughing) like that. If that's the general sentiment, then it changes. I don't know.

[29:42] **Henry**: Mm. Right. I think for- I guess for both, not- even for faith and open source like it's, there is the majority thing. That's probably just what's gonna happen. But um maybe that's why it's important to almost have ... (laughs) It's weird to use the word "historians" but like to write down what those processes are? Um 'cause so many things are in your head as a maintainer that you just do and then you feel like you're too busy doing all this other stuff but no one else is gonna write it down 'cause they don't know what it is. So I think writing down what those processes are, maybe with a date, and then explaining why we did this thing would be good because then if you give the reasons, then people can be able to actually like I guess, uh, argue for it or against, versus just saying, "Oh, this is tradition. I don't wanna do it anymore." 'Cause maybe there was a good reason. Um and maybe there wasn't, so.

[30:35] **Nadia**: I was just thinking about um, in Ruby, there's like this acronym- I'm gonna screw it up, uh, ["Matz is nice so we are nice"](https://en.wikipedia.org/wiki/Yukihiro_Matsumoto).

[30:44] **Henry**: Mm-hmm (affirmative).

[30:44] **Nadia**: Something like that.

[30:44] **Henry**: Yeah, yeah.

[30:47] **Nadia**: Really like encoding of culture that came from an author or was kind of like handed down from someone else (laughs) that they like turned into an acronym of like, we're nice people because like this person was a nice person. Um, which is like, I don't know. Yeah. And I was just thinking about like cultural things that are encoded from maintainers, and I guess conversely there are other- other projects that shall not be named that kind of take an opposite approach of we're abrasive because our original (laughs) author is abrasive and that's what, yeah.

[31:25] **Henry**: I think that kind of shows the influence of the original person, and also just like having like slogans and logos and things like that. Like those things are, you know, like they could be catchy or things that people will remember. And I think of even just words we use. Like I was- I think we talked about this before. Like we have different acronyms like YOLO and FOMO and all those things and it becomes not just a word we use but it literally changes like how we think. Um.

[31:52] **Nadia**: Mm-hmm (affirmative).

[31:52] **Henry**: And I think it's important to, like the habits and the traditions are really good to reinforce maybe the values that wanted to be I guess encouraged. But then I guess it gets to a point where like, the people doing them don't even know why that existed in the first place. So I think even with faith like, uh, when tradition just becomes a habit that you kind of just do just because, then that's when it becomes- like it might- it might even become useless or detrimental because people don't know why they're doing them and it's just for the sake of doing it. And so, understanding why is, I feel like, just as important as doing it, but you need both, I think.

[32:40] **Nadia**: Yeah. There's like some concept in there that's interesting. Like the idea that even though tradition is maybe old, (laughs) or it started from some time that might feel totally foreign to where you are today, um tradition is also like participatory. Like you have to connect to it or less it doesn't really work. Like, it's more that you're joining a long line of people that are doing this thing versus like, you're not just aping whatever someone did 300 years ago or thousands of years ago or whatever. But you have to actually feel like you are like carrying something on and to feel like, I guess like ownership in whatever that thing is, otherwise it's just meaningless.

[33:24] **Henry**: Yeah, and I think because it's usually like uh a bodily act, it's almost important to actually do it versus ... 'cause it's easy to just be like, "Oh, I don't think that's good," but- or, "That doesn't make sense at all," but like I think going through the motions can also be useful, just so you actually feel it. And I think um there's- there's no substitute for actually doing it, right? Um you can't think your way to knowing what, you know, feeling X, Y, Z, and like feeling love or feeling whatever is um if you've never actually done it.

[33:59] **Nadia**: Mm-hmm (affirmative). That's true for a lot of, just a- even just a lot of like axioms or wisdom or whatever that gets passed down. If you don't actually understand it, then ... if you can't- if you aren't actually like living and embodying it then it's ... it's just words. (laughs)

[34:15] **Henry**: Yeah. I think that's what I would say, it's people like that, I wanna invite to church. It's like going, actually going there, actually is different. 'Cause you can like picture it in your mind. Like, "Oh." And you can list out the, you know, like I guess quote on quote tasks, or activities that things are, but like being in- in a part of it is a different, I guess, you know, you just want to experience. Like that worship service has something um that you have to be a part of. Like what you said, being a participant. Um (laughs) stories are important. (laughs) I don't know.

[34:50] **Nadia**: Yes. Tell stories.

[34:56] **Nadia**: Thanks for listening. If you'd like to continue the conversation, you can find us on Twitter at [@left_pad](https://twitter.com/left_pad) or [@nayafia](https://twitter.com/nayafia) or on our website [hopeinsource.com]
