---
title: "03: Intrinsic Motivation"
season: 1
date: "2018-10-16"
time: "43"
description: Why do we do what we do? We talk about intrinsic motivation, the role it plays in creative work with uncertain outcomes, motivating new contributors, and sustaining motivation over time.
episodeLink: "500f9b42"
embedUrl: https://share.transistor.fm/e/02593e58
sidebar:
    order: 3
---

### Links

- [Call to Commitment](https://www.amazon.com/Call-commitment-Church-Saviour-Washington/dp/B0006AYJSS) (book)

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-1/motivation.md)

#### Finding Your Inner Quiet

[00:00] **Henry**: So, in this episode, I want to bring up topics around work, burnout, and why we do what we do. And motivations and goals that we have when we're working in open source or anything in life.

[00:17] **Henry**: The last weeks, I've been feeling kind of burnt out in terms of the burden of doing something in public. Not being able to release a major version (of Babel) for a year. Everyday it's like, "Oh, I still haven't finished,".

[00:39] **Henry**: There's a similar issue in faith too where you're working and maybe you've lost sight of the vision.

[00:52] **Nadia**: Hmm. I wonder ... it seems like this is sort of relevant to my work in research. And I was just thinking about that with relation to faith and open source.. sometimes I think what makes it hard is your timeline is not super clear and you don't always have these measures of how do you know you're doing something well or not.

[01:20] **Nadia**: I was just thinking maybe this is also why people in non-profit work or just social sector work can also get burned out because there's kind of no end to it. I mean, the definition of faith is that you don't know what you're having faith in, that what you're doing makes sense or this is the right thing to be doing. And it's a lot about just sort of just trusting yourself and being very inwardly focused instead of looking for external indicators of how well you're doing.

[01:47] **Nadia**: And I think maybe that's also true for a lot of open source work where it's not clear when a product is ever done, right? If it's not ever done or there's always something else I could be doing, then how do I find a way to sort of find my own inner quiet and be able to sort of stand still and say, "I'm doing this for me and not because I'm chasing after whatever extrinsic reward there is.

[02:16] **Henry**: Yeah. I think that's something that's even just for software itself. I talked about this on a different podcast, but if you're writing a book, a paper, a movie, a piece of artwork, there is a point where it's done, and you're not really ever gonna go back and make it better. But with software, you can always make a new version. In some sense, it never ends, which can be helpful and also not helpful if you're feeling burned out (laughs).

#### Being in the Present Moment

[02:46] **Nadia**: Yeah. It's finding some, some way to just be happy and be in the moment versus chasing towards some end, right?

[03:00] **Henry**: Yeah. I guess with faith, it's kind of it's a lifelong commitment really. And so, there is a sense where we all wanna have some kind of validation, but if we're all seeking that and we're never really always gonna have it, it does have to come internally where it's like, "Yeah, I'm internally motivated to continue moving on." What you said, being in the moment and enjoying what's happening right now, even if it's not going well at at the current time, but like having hope for what the future holds, I guess.

[03:58] **Nadia**: I think it's part of why community becomes so important in these situations 'cause community can bring you back to the present moment in that you're thinking about the connections you're feeling to the people around you. I generally notice that I'm much, much happier when I feel connected to other people and that's like a very present thing, right? Like community isn't really so much about-

[04:25] **Nadia**: I mean, yes, it's less about the past or the future and it's more about in this moment, I feel like I'm part of something. I'm wondering if that just like helps draw our mental eye back to the present instead of trying to project into the future.

[04:37] **Henry**: Yeah 'cause the future and the past, it's all about worry, "What's gonna happen to me?" or "What's gonna happen to this project?" versus being in the present. And even, a similar word, presence, the presence of other people, and like we were talking earlier about how like if you're doing something that's hard or difficult with other people or there's like a sense of bonding that you get.

[05:08] **Henry**: Struggling through something together can definitely help. And so with faith, maybe you're not feeling great, but other people can build you up. In the same way with open source, when you're feeling burnt out, talking to other people on your team or other maintainers...

[05:31] **Henry**: I know when I was feeling like that just like this last week, I don't know, just talking about it with friends, it really helps at least to get you out of that place so that you can continue to move forward from getting stuck.

#### Natural Spaces for Encouragement

[05:53] **Nadia**: What are the ways in which those conversations happen naturally in like a faith-based community? Is there space for that?

[06:06] **Henry**: Right. That's a really good point, because if you're feeling this way, you might feel weird about telling someone about something you're dealing with. In a community or Christian community, there's almost explicit structures for that. It's helpful, yesterday we had a prayer meeting and that's literally a time where you can go and talk to someone about what you're dealing with. And so we have a worship session and then we pray. And we use the word intercede, so praying on behalf of other people like what's going on in the country or the city or the church, and then afterward just with the people that are there. And we're called to talk to people that we don't know and people that we do know.

[07:15] **Henry**: And this is just after work and you know people are tired, but they're willing to be there for one another ... and it's like in a smaller environment so it's pretty intimate. It's not out in the open.

[07:36] **Henry**: And so that's like, every week that you could have that opportunity, we call them small groups. When you join a church, it's hard to meet people if maybe there's hundreds of people or something, you're never going to be able to meet everyone, and be able to go deeper, right? And so, having a group ... and then we have our own group chat, and everyone has their own contacts. You can message people directly, if you're dealing with something.

[08:17] **Henry**: Like my friend, he just called me the other day 'cause he was dealing with some issues with work and job stuff. And so, I was able to talk about it with him ... but it would be interesting to think about how would we have that in open source.

[08:41] **Nadia**: 'Cause I feel like ... I mean, even as you describe that, it sounds like there's almost two purposes in being able to share what you're feeling with the rest of the community and one is almost having other people just bear witness to something you're experiencing, which-

[08:57] **Nadia**: ...because I mean, saying you're having a hard time, it gets very different in a context of... I don't know the size of the small groups you're talking about. But even if it were five people, it's very different to have a conversation in that context versus one-on-one. And it sounds like there is one thing to be able to say publicly why you're just kind of having a hard time so that people know that that's true. And then it's another to kind of go off in that side channel, like what you're talking about with your friend, and having a more one-on-one conversation about what's going on. But those are different channels, right?

[09:31] **Henry**: Right. So in a small group setting, you might share with the whole group. And maybe individual people can speak up. But then,there is intentional kind of breaking up into one-on-ones, 'cause yeah, it's just a different dynamic around different people, you know? Maybe not everyone can understand what you're dealing with, so.

[10:02] **Henry**: And I guess it's what you said about bearing witness, you wanna be known. You want people to know what you're going through. And that time requires a more personal one-on-one situation.

[10:23] **Nadia**: Do you feel like there are explicit spaces for that in like... not even just open source, but any sort of largely asynchronous work context? I felt this... I worked at two completely, or mostly distributed companies now. And when you don't have that sort of casual watercooler topic, if the only time we talk to each other is about a work or a task-oriented thing, then where do you find the space to have those side conversations? And I found it comes just from forming personal relationships and then be able to talk to that person, but it's hard to find that space.

[11:03] **Henry**: Yeah. It comes naturally then. You find someone that just happens to, that just feels like you're able to share with that person. So maybe it's not like a company per se has to create those kinds of spaces, but provide the environment in which you can feel comfortable doing that. I don't think it means that you necessarily have to make meetings or that kind of thing, but through conversations at lunch, or outside of work, it's like that's when you kind of get to know people outside of the work context. And then, people will bring up what they do outside of that and what they're dealing with sometimes.

[11:54] **Henry**: I've had people that even at work asked about, "You're talking about faith a lot," so that conversation comes up. And through that, you might talk about things that we're dealing with and how I handle that.

#### One Way Communication

[12:16] **Nadia**: I think I brought this up last time we talked. But it just brings up this question for me of how much do you share with fellow maintainers versus how much do you share with the general public and how much do you kind of filter it to be like, "Oh, everything is going great" versus a smaller set of people where you can be honest?

[12:33] **Nadia**: And I saw that you like tweeted a few days ago about being like, "Hey, I'm feeling like not so ..." (laughs) and clearly you didn't do that at all in how.. like when do you feel comfortable sharing that stuff super publicly versus in a more intimate context. And what was your reaction to being able to say something like that publicly?

[12:09] **Henry**: Yeah, that was a struggle and I didn't even wanna say anything at all because you don't really ... well, that's the thing, right? Part of the point of the community is so that you can bring your burdens to people to know about. But I don't wanna just like be all negative all the time. Obviously, everyone's going through stuff all the time. And I don't know if tweeting a thing that just says, "I'm not feeling well," is that even that helpful 'cause there's really no context. I almost feel like I have to bring all this stuff so that people understand. Otherwise it's just like, "Why do I even need to say it if I'm not saying anything then that means something is up" (laughs).

[12:54] **Henry**: I don't know. In a more private conversation it's easy 'cause maybe you have a private Slack channel just for the maintainers and you just talk about it like, "Hey, I'm not feeling well. I don't think I can work today," or stuff like that. Publicly, it's so weird. I don't want people to have the impression that like I'm like some like superhuman that doesn't have these issues. But I also don't wanna.. I don't know. It's hard (laughs).

[13:24] **Henry**: And I feel like it's better if I wrote a blog that's about that, it would feel better to me even as there's more context.

[13:35] **Nadia**: Hmm. And maybe more distance too... so I think of it more as like you might write a blog post as a reflection to work out your feelings, which doesn't necessarily necessitate a response.

[13:52] **Henry**: Yeah. I'm not looking for someone to help me. It would be weird to ask... I'm asking random people online for support in that way versus I know there's people that are more close to you locally that you probably wanna share with.

[14:08] **Henry**: Not that I wouldn't accept that help. It's just that there's, there's no connection there really, so. It's kind of one-way usually.

#### Fear Driven Development

[14:17] **Nadia**: Mm-hmm (affirmative). So shifting a little bit, how do you find that level of intrinsic motivation, when if you are feeling that way, find that sort of inner peace and inner calm?

[14:37] **Henry**: Yeah, 'cause I think in the end when you start feeling the sense of dread and not wanting to even look at it. 'cause a lot of it for me was that we haven't released this major version (of Babel) in over a year. And so everyday someone's gonna be like, "Hey, how is it going?". And each time if you're already feeling bad, you don't even wanna think about it. You just wanna do stuff, and that everything is a distraction to that.

[15:11] **Henry**: It makes you think about, "Yeah, why are you doing this in the first place? How did I even get to this point?" And what happens ism you put so much pressure on yourself, which in the end feels like pride because that means I don't wanna actually say that I either messed up or don't know what I'm doing, because if I finally realize that, then I should feel free to just get the work done.

[15:40] **Henry**: And there's this weird internal pressure to keep moving. So I think if you're new, it's good to have that kind of thing 'cause it pushes you to go forward, but when you're already doing it, I don't know if you need to feel like you have to continue to output. If I don't have a consistent thing then I'm not doing well, and I have to continue to satisfy people's wants, but that's all perceived.

[16:12] **Nadia**: It seems like so much of the unhappiness or discontent that I've noticed in myself and in other people on these situations is less about what you're doing and more about a fear around how are you being perceived for what you're doing. It's like only when you have this sort of external measure that you're worried about, "what will people think if we haven't like done this release yet?" that then people get upset and like tuning that out is a pretty like fast way to stop feeling shitty about (laughs) it.

[16:44] **Henry**: Yeah. That's why I was telling you I wanted to write that blog post about fear-driven development (laughs). Because that's what I was feeling. It just paralyzes you in everything.

#### Working Through a One-Way Mirror

[16:54] **Nadia**: It's hard to find that perfect balance between... to some extent, I think I generally skew towards I'm doing the things I'm doing because I wanna do them. But if no one ever paid attention to anything I did, I would also be like kind of sad, I think. I'd kind of feel like (laughs) does anyone care?

[17:18] **Henry**: Yeah. Does what we do matter? Yeah.

[17:20] **Nadia**: You wanna feel like you're contributing to something, to the world. So there is some version of like fear-related (laughs) development that is probably a good forcing function to you. You don't wanna feel like it just doesn't matter at all what other people think. But then, on the other hand, like you said it will just become paralyzing if you think about it too much. And finding that in-between is really hard.

[17:45] **Nadia**: I was thinking about this with writing recently just 'cause like now that I'm working in research, what is my output and my output is probably just documenting and publishing a lot of knowledge and it led me to surveys and in some of the tools I've been using, in the past couple years when I wasn't working in research. Medium and Twitter are two things that sometimes, when I use them, I feel really good, and sometimes I just feel stressed out about it because it needs me to tailor to an audience.

[18:18] **Nadia**: And when I think about doing research in particular, it's about doing things that aren't well understood in that people might not understand at first, and the thought of publishing that where I'm worried about how many people are responding to it is just a very stressful non-productive environment for me and makes me not wanna write at all. And I feel like I've only just in the last week or so, figured out how to resolve that for myself.

[18:46] **Nadia**: Like ideally, I'm just gonna not publish on Medium at all and I start publishing my private notes just on my own website so that it's not on Twitter. It's just, if you wanna read it, it's out there, but it's not something that I need validation for. And yeah, just finding a place where I can say, "I'm doing my work over here and you can watch if you want." But I'm not doing this in order to get your approval. It's like working in a semi-public context, being able to just like tune out what other people are saying.

[19:24] **Henry**: Yeah, I guess that's the issue with doing anything in public, which all of open source is. It becomes about thinking about what people think versus even doing it in the first place. And then, like you said, I don't even wanna do it anymore (laughs).

#### When Do You Open the Floodgates?

[19:39] **Nadia**: Right. I was talking to a friend about this, who's also an open source developer. And he was saying, "I don't understand why, companies are so protective about wanting to build everything privately before they open source it." I was like I kind of get it because sometimes if you have a strong visionary idea for something, you kind of just wanna develop it and because you need to get this thing out that's inside of you, before you start having other people kind of poking around and looking at it.

[20:12] **Nadia**: And he had challenged me to think, had there been any super negative examples of an open source project that was open sourced too early and turned into some sort of PR disaster. And I said, "Yeah, I can't really think of one," and it's true, it is sort of considered to be this worst-case scenario if you open source too soon. But like has it actually like hurt anyone? But I don't think it's necessarily about that worst-case scenario of something is shared that's too private or whatever. But it's more just about... the reason why I'm more in favor of doing some things privately or at least not advertising them at first is because I feel like you need that quiet space in order to do something really creative.

[20:57] **Henry**: No, I hear you. I don't even think there can really be a disaster if you do it. It's just that what happens is you're inviting other people to get involved. So that will change how the project's gonna move going forward.

[21:17] **Henry**: And so, if you have that vision, not that you don't want people's opinions, but you wanna figure out what the core is yourself, and you haven't even found that. And someone's gonna move in a different direction.

[21:29] **Henry**: Or you're going to have to spend more of your time just doing open source. Maybe everyone just keeps forgetting how much work it takes to maintain a project, especially in the beginning, because you're going to find that like once you do your tweet or blog post. That 20,000 people star in your repo and now you're going to have all these people like, "Hey, I wanna contribute here and here" and then you don't even do the work anymore.

[21:53] **Henry**: So maybe it's not that it's a worst-case scenario where it makes it worse, but it's more it just delays the release actually.

[22:02] **Nadia**: Yeah. It's almost what's the uncaptured potential that got derailed. It's less about something super negative happened or more that maybe you didn't get to do all the things you would have been able to do if tons of people weren't paying attention.

[22:18] **Henry**: So I guess it's like at what point do you do the release? It's like if you're still trying to figure out what the point of this project is then I (laughs) don't think you should do it, unless you want like certain people to be involved.

[22:30] **Nadia**: I mean, the reason why he brought up was he was saying the flip side of taking too long to release ... and I definitely think there is a flip side where there are some projects that should have been released earlier that weren't.

[22:44] **Nadia**: He said, the flip side is that people's enthusiasm might wane and you're not capturing the potential of this group that could have been your evangelists, but instead they got kind of bored because you took too long to release something and they walked away disappointed. And so, his approach was sort of saying, "Can you engage those people as early as possible and have them contribute?"

[23:09] **Nadia**: But I think, even by that same reasoning, it's another reason not to open source too early because if you have someone come in super early and like you said, you haven't figure out the core of the thing you're trying to do yet. And they're excited to contribute, but you're not even sure how to direct them, then they'll still be I think disappointed and walk away. So, I don't think bringing them earlier necessarily even gives them an opportunity to participate.

[23:38] **Henry**: That's interesting 'cause you're inviting in the floodgates of people. That makes me think how is that different from after it's released because whereas the floodgates are still open and we're still trying to figure out what we're doing later. And there's still all these people that can come in 24/7 at any point in time from anywhere around the world, which is really great, but that is a recipe for disaster.

[24:06] **Nadia**: It sounds horrifying to me (laughs).

[24:09] **Henry**: And then I think about it, that's exactly what we did (laughs).

[24:11] **Nadia**: Yeah. That is what open source actually is.

[24:15] **Henry**: And so I'm not opposed to "putting barriers", not because I don't want people to be in, but it's like the fact that we allow everyone just means everyone has a bad experience. So for our own sake and for new people's sakes, so that they don't leave, we should figure out a way ... kind of like what we said last episode about finding committed people that wanna be a part of this project in depth versus some surface-level thing.

[24:47] **Nadia**: Right. Actually, I just had a conversation with someone else about that. I was like, what are your heuristics for being able to tell when someone is not just in it ... they're not just gonna peace out for the project, but they're actually a little bit more interested in sticking around.

#### How Do I Know You Care?

[25:06] **Nadia**: Like I'm curious for you, how do you know, either in a faith or open source context, when someone isn't just sort of there to do their thing and leave.

[25:13] **Henry**: Yeah, I don't even know if there's a way to really know whether it's open source or faith. And even my friend (laughs) that was just asking me today, what's the best way for me to start learning how to code? And I'm like, "Wow, that's a really simple question, but I feel like I don't have an answer." (laughs)

[25:34] **Henry**: And, then I was like, maybe you guys should start up a fun little group of people that I can teach them and stuff. But then, I'm doing the same thing again. I can invite anyone. I don't know if they're committed. I don't know if they're gonna stay. And obviously, the first suggestion he has, "Oh, then we can pay you for it." And so, maybe that's how some people think about it. It's like, "Oh, there's a barrier in terms of cost. The fact that there's a cost at all means that certain people won't wanna do it."

[26:02] **Henry**: But it doesn't have to be a monetary cost. It made sense to me that they have to provide some level of something that says that they're willing to sacrifice to be a part of this thing versus.. I mean, they can leave whenever they want, but then we wanna know that they're able to invest ... 'cause I wanna spend all this time to help you, then I wanna know that you're in it.

[26:33] **Nadia**: It's really interesting. I think that's an interesting example because, I think we've historically used money to help commit people. There's studies about how if even you pay one dollar for an event, they're more likely to show up than if you had zero dollars. And that's I guess one way of motivating people through an extrinsic reward, but learning to code in particular is interesting just because there are so many public resources at this stage for someone who's learning to code. And the tension I struggle with at least is there's a part of me that wants to say, "Well, how about you go learn on your own for a bit, and then if you're still interested, then, cool, we'll go deeper."

[27:17] **Nadia**: But the trade-off with that is, you don't wanna make the barrier to entry so high up that people aren't learning who otherwise would have. Maybe some people would learn better in a setting that's super structured with a teacher who's kinda walking them through something and then for other people they can just kinda read through things and figure out their own. Unless you're doing it as your job or because you just love the act of teaching someone how to code.

[27:51] **Nadia**: I would think about it as, "Well, I wanna know that you care." And the best way for me to know whether you actually care is if you've done a little bit of the work yourself before bringing me in.

#### Mutual Benefit

[28:03] **Henry**: Yeah. That was my thinking, but it'd be funny thinking about it in terms of faith context, it's like, "Hey, I wanna, learn about what does it mean to be a Christian or come to your church" and then you tell them, "Oh, you should do it by yourself" (laughs)

[28:20] **Henry**: That sounds crazy. But then with coding, it's the same. So many people are like, "Oh, check out the issues." I never thought that was a good idea because I just don't see how they're really gonna get it. I happened to learn it that way, but I don't know. I just happen to be super motivated to do it anyway and go through all that pain or struggle. But I don't see that being a normal way of doing it.

[28:53] **Nadia**: I think this is why it is sort of different from a faith example, in that there's a more obvious mutuality to that relationship if someone comes to church and says they wanna be part of it because you worshipping and learning alongside another person kind of strengthens your own practice. I think that's similar to like learn the code where if you just love teaching someone how to code, then you'll just happily teach them regardless of whatever they've been doing because it just feels good to you to teach someone and then they're learning. And there is again that mutuality.

[29:33] **Nadia**: If you're not super excited about spending your time teaching someone how to code, but you would be if they were really, really psyched about it, then I do think it makes sense to have a little bit more friction there. I guess it really just depends on the particular person and what's incentivizing them to be there.

[29:57] **Nadia**: I get a lot of inbound around people asking about how to structure the community around a project they wanna open source, which is always kind of funny because I'm like, I don't know. Sometimes actually I'm like, "I'm not the person you should ask about that," (laughs) because I'm not a maintainer. I don't know. It's always like a little bit bizarre for me. But I get a lot of inbound, right? At some point it's not that fun for me to sit and regurgitate, "Here are all the things you should think about," because it's public and you should ...

[30:34] **Nadia**: I'm only gonna engage in those conversations if I feel like it will be fun for me too. And that's not me being selfish, but I only have so much time in my life (laughs), I'm not gonna spend it just repeating mindlessly something that you can find out on your own.

[30:50] **Nadia**: But if I do feel there's some other reason why I would wanna talk to that person or that I'm capable of learning something too, then I might be more likely to talk to them.

[31:00] **Henry**: Yeah. It's a lot of just the environment in which they're asking it. If it's like an email or open source, I feel less inclined to wanna help even though I'm doing it, now. But maybe that's just 'cause I'm used to it. I feel like now I don't really wanna do as much because it's digital.

[31:121] **Henry**: When someone's asking you for help, like my friend, they're my friend. So maybe I'll just do it anyway or I'm doing it in person. When someone comes to our church, well, I'm already like committed to being there anyway. And they went out of their way to come here on a certain day at a certain time at this place. And so there's almost a level of commitment that I can see, just from them asking. But when it's online, they could have just did this randomly. So I can't know from that.

[31:53] **Nadia**: Right. It doesn't really actually cost you anything if someone just wants to come and worship with you in the same place. It's only really additive I think as long as we're not like, I don't know-

[32:07] **Henry**: Weird, yeah.

[32:07] **Nadia**: Yeah, weird (laughs).

[32:09] **Henry**: Yeah. Whatever that is.

[32:10] **Nadia**: Yeah, I don't know what that would mean (laughs). I think a more equivalent analogy would be if you just had like tons and tons of people coming into the church all the time, that were asking about the same thing and that required your personal touch. Then at some point, you'll probably start to filter ... and I think you're right, taking the time to come all the way to church or just showing up to a physical setting is such a higher level of commitment than firing off an email.

[32:40] **Henry**: Right. And like, it's almost so much that we're like, "Wow, like someone actually came." Okay, were really gonna help you (laughs).

[32:47] **Henry**: And another thing we do is, if they are new, in the announcements, we'll be like, "Hey, if you're new, then you can come to like this info table," where there are people that their role is to be there for people that are new and give them more information about what the church is about.

[33:07] **Henry**: Usually, there're people that stay back, "We'll get lunch with you and we'll talk about XYZ with you." So it's not just like ... because otherwise you go there and you leave, it's weird like a mall where you're shopping or something, "Hey, I went to the store. I got something out of it. Now I'm leaving." And then I don't need me to come here when I happen to stop by or whenever. No, we wanna be intentional.

[33:32] **Henry**: And then we'll try to follow up either through the email or doing a lunch thing one-on-one later. And that's like so different from open source space. It's just like, "Oh yeah, they showed up and then maybe they'll have another PR, right. It's (laughs) so different.

#### Intentional, Consistent Help

[33:47] **Nadia**: Well, I think that's where I'm wondering what are your ... can you tell from the first contact whether someone is more intrinsically motivated? And how would you be able to feel that out, just to know ... 'cause there are some people in church or at open source who are just gonna... I think we had talked about this last time too, I think it is okay if you wanna just kind of show up, enjoy it once and leave. But then you also wouldn't wanna spend too much time on someone like that. You wanna just let them have their experience and then you're not gonna follow up a ton.

[34:28] **Nadia**: Are there ways to sort of just know through your experience of, this person might care a little bit more than the average?

[34:37] **Henry**: Yeah. So we're not preventing people from going or for whatever they wanna do. But can we provide an option or opportunities for people to commit more. Even just like, "Oh, am I gonna see you next week? Or like, "Do you wanna get involved in this activity?" Or whatever that is. And that was another level of, "Okay, I need to be there," kind of thing.

[35:07] **Henry**: And maybe that's part of the fact that in a church setting, there is a consistency and schedule to things. And that is good. They're having a structure. Actually, it's funny, even coming to church, they know there's a time. Well, assuming they found it on the website or they just happened to pass by, there's a time and place for it. Whereas in open source, unless we have some kind of office hours type thing, people are just asking at random times and they're expecting an answer or not, and then they don't do it. And so maybe it's about making open source maintainers more available at specific times consistently. I know of certain projects do that.

[35:52] **Nadia**: Yeah, they'll do like an office hours kind of thing.

[35:54] **Henry**: Yeah. maybe that's helpful. And this is kind of like why I want to do like a in-person office hours kind of thing to people that are in New York. That would be more fun for me because then it just feels more real versus just doing it online or something.

[36:16] **Henry**: But then if it hasn't started figuring out logistics and all that stuff, it might be difficult. For me, personally, I need to talk to them. Just the question of "How do I learn programming? I wanna be involved in the open source?" The fact that I feel like open source is so big and maybe they think it's like specific thing, I wanna know what they think it is and what they wanna be involved in. And they don't really know, then I have to basically provide them with all these different opportunities and help them figure out which one they're most interested in.

#### General vs. Specific Questions as a Signal

[37:07] **Nadia**: Do you think that's a worthy investment of time? It gets back to the same question of like, well, how much should you expect them to just come to sense it on their own versus you telling them?

[37:24] **Henry**: Yeah (laughs).

[37:25] **Nadia**: That's not a leading question. I'm like actually curious (laughs).

[37:28] **Henry**: No, I think that's the trade-off 'cause as a programmer, we all want like this automated solution. Maybe it's like, "Oh, we have like these forms that you fill out." Do you really wanna do it that way just because we think we need to scale or something? I think maybe in the end, having a short conversation... maybe we need to figure out what to ask for whether it's like 5 minutes or 10 minutes. From that, we'll learn what it is versus just like forms. I don't know, 'cause then it's just automating, and is inviting more people that you can handle, then maybe purposely limiting it in terms of just speaking one-on-one is better 'cause then it's a different context.

[38:18] **Nadia**: I think there's an in-between too. I was just thinking you can say ... this is something I realize that I actually do quite a bit with inbound. "Here are a bunch of resources, and I think they're good resources, I actually highly recommend these if you wanna dig through them and then let me know if you have questions." Is like a pretty good filter because then if you actually cared about learning more, you'll be excited to dig through the resources. And if you don't care, then I don't waste my time like trying to dive into your needs.

[38:52] **Nadia**: It's hard though. Like the other part I struggle with is like, sometimes it's like having a conversation with someone that just sparks something in you. I wanna like, moreso than just reading a thing about the topic, sometimes it's just a good conversation, and it's perfect. Then just you synthesize something in a certain way that you wouldn't have otherwise... but I think it's also just not realistic for me to have to do that for everyone else because then I don't get to do the things that I wanna do with my life (laughs) if I'm constantly doing it for everyone else.

[39:28] **Henry**: Right. People ask all the time. I'll be like, "You should read our contributing guide," which is like a pretty standard thing, but most people don't. I remember thinking about how I would ask my boss or other coworkers for help and they would know whether I looked into the problem or not, he could tell based on the questions I asked him (laughs).

[40:00] **Henry**: So then later I learned, what are the kind of questions that are helpful versus just like, "I don't get it, help me." Because that tells him that I am just frustrated and I don't know how to do it. And it's not really based on time, right? It's just like, "Did you actually look into it?"

[40:20] **Nadia**: Yep.

[40:21] **Henry**: And so, maybe it's a similar thing, the fact that they're asking something so vague means they didn't really look into it. And maybe all we have to do is give them those resources and then they'll come back and be like, "I saw that you had this and I wanna work on this specific thing." I think a lot of people do that, right? When people ask them for questions, they want a specific concise thing versus, "Help me."

[40:46] **Nadia**: Yeah. That's also a filter I use for email also, if it's clear to me you haven't done any... if someone's like, "Hey, what are you up to," or something. It's like, "My life is pretty much on the internet," you can tell where I work or (laughs) what I do or the last thing that I wrote. Or another one is if people on Twitter ask for my email address, I'm like, "I make my email address really public and if you can't figure out where that is, then that's a filter for me of like, "You didn't put in a little bit of effort, so why would I put in more effort on you?" So there's little things like that where you could just sort of be like, "Okay, this is a basic level."

#### Fear as a Habit of Mind

[41:25] **Henry**: Yeah. That makes sense. We were talking about fear and stuff, right? And how you can have a healthy amount of fear. But I was thinking more on the faith side, there's a quote by Marilyn Robinson. She was saying that fear is not a Christian habit of a mind which is really interesting quote. It's not just that fear is not Christian. It's a habit, like being in fear is a continual thing, and it's not Christian.

[42:06] **Henry**: I would say that in terms of work and fear, it's not really that we have a little bit of fear and that could make us move forward. We should turn that around basically, it's the opposite. Where does our hope come from? Because of that hope, we continue to move forward, versus being scared a little bit, Oh, I need to continue to do more, right? If we actually have that vision of whatever it is and usually it'll be able to make a difference, right?

[42:42] **Nadia**: I really like that. Fear and hope are both really strong motivators, and they're sort of like two sides of the same coin but it seems a lot healthier and happier to think about, how do I take fear and turn it into hope and excitement for the future?

[43:01] **Henry**: Yeah. It's weird 'cause in the Bible, it does use fear, but it doesn't use it in the way that people usually think about. It says you should fear God. But it doesn't mean be scared (laughs) of God. It's more of a respect or honor or worship God. And worship itself is a positive thing. It's something that's not just what we're called to do, but something that we enjoy. It's if you treasure and cherish who God is, then you're gonna wanna worship Him. And some people think that the way that we are most satisfied in who God is by worship.

[43:45] **Nadia**: Thanks for listening. If you'd like to continue the conversation, you can find us on Twitter at [@left_pad](https://twitter.com/left_pad) or [@nayafia](https://twitter.com/nayafia) or on our website [hopeinsource.com](https://hopeinsource.com).
