---
title: "06: Money"
season: 1
date: "2018-10-16"
time: "44"
description: How do communities handle money? We talk about money and centralization, tithing systems, how much funding is too much, and when to contribute money versus time.
episodeLink: "f1ade31a"
embedUrl: https://share.transistor.fm/e/e4627cff
sidebar:
    order: 6
---

### Links

- Tithe: https://en.wikipedia.org/wiki/Tithe

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-1/money.md)

[00:00] **Nadia**: So this episode, we're gonna talk about money and there's a lot of crossover between open source and religion when it comes to money, I think, because religion is this inherently decentralized concept. Anyone can participate, get up and leave, um, there's no central person organizing whether you choose to be religious or not but, churches would be examples of a more, I think, centralized organization within religion that helps, enable people to do more things with it. So yeah, I wanna talk about when is money needed in a decentralized context and how do you know that money is necessary or not? Like, why can't people just practice religion by themselves and not have resources for anything?

[00:50] **Henry**: I mean, I guess I would say that churches are part of the decentralization, at least in a certain religion, right? It's like the local church, I guess it is centralized in that, you know, but it is, it probably doesn't affect that many people or just that group within that, you know, area or city if, if you're thinking about, like, the overall picture.

[01:16] **Nadia**: I guess, fundamentally, if you think of churches as, like, these are just places where certain groups of people who adhere to the same concepts have decided to cluster, then I guess, like, churches can come up really organically but there's some point where, like, a church wants to become more formalized, right? Like, they register as an organization legally, um. They have a physical space that people meet in and yeah, all those things require more resources, I guess.

[01:51] **Henry**: Yeah, exactly. And then, I guess that's kinda like what I was saying before about like, what if, what's the difference between, a house church which is just a few people, maybe it isn't as formal and then just, another extreme is like a [mega church](https://en.wikipedia.org/wiki/Megachurch) where they're like huge, they might have, like lots or millions of dollars.

[02:15] **Nadia**: So yeah, I know, what's the point of which a church has too much money or too many resources? And is that even, like, possible? I mean, you could say, like ... I mean, depending on what you subscribe to, maybe a mega church is just maximizing its impact and reach, right? Whereas a much smaller church might only reach, I don't know, like, 30 people.

[02:38] **Nadia**: Maybe a mega church is able to spread its message to thousands of people, um, and make thousands of people feel like they're part of something. So if you're just looking at it in this, like, dollar and cents kind of way, it's like, "Well, why not just, like, grow and grow and grow?" But then I think we kind of intuitively feel like somehow it goes against the spirit of what a spiritual practice should be, um, which I think is, like, really similar to open source in that, like ...

[03:08] **Nadia**: I think to some extent, people are, especially now, more comfortable with the idea of projects having more resources or funding or volunteers or whatever but there are still some feeling or expectation that, like, well, you don't really get too big either and same with, like, the non-profits sector and so, like, I don't really know, like, where that, that line falls where suddenly it's, somehow just doesn't feel right anymore.

[03:34] **Henry**: Yeah (laughs). That's really hard to ... I don't, I don't think we'll ever really have like a, rule on what that really is or maybe it's like, oh, you, like you kinda, like you said, you feel weird about it but it's hard to be like, "Oh, that, they're not doing it right or they're taking too much." And I guess even if you say that, you'll feel bad about, like, calling people out.

[03:57] **Henry**: Yeah, I think with the mega churches, it, I guess, yeah, really, you're saying it makes sense that, like, you know, you can be more efficient with money if you're able to pull it together but that's also why we have, like, issues with, you know, people not really understanding the, like, needs of the people that they serve and it's too, in some sense, it might be too generalized.

[04:21] **Henry**: I think the advantage of having a small local church is that they understand the needs of the area that they're in, um, and they can be more effective in that way 'cause they're closer to the people versus like a huge organization, it's just not easy or maybe in some case, impossible for them to really know what, you know, what's needed.

[04:44] **Nadia**: I think there's a good question about like, where should decentralization and centralization exist, like, at what tier of organization? So even a small local church, most of them ascribe to some concept, some branch or sect of that religion that is like a much higher thing, right? Like, it's in, it might be a small church but it's an Episcopal church or whatever or a Protestant church and so, like, in that sense, the, the concepts that you're ascribing to in that everyone is their ...

[05:22] **Nadia**: Like everyone has this shared understanding of something that is, like, much, much bigger than that church but the manifestation of it comes in this, like, very small organization, um, whereas ... Like, we're talking about these sort of like very, very large churches where maybe there's, maybe they're just, like, centralizing at the wrong level where maybe churches themselves function better when they're smaller and more agile but, like, they're still part of this, like, much bigger centralized concept, if that makes sense.

[05:54] **Henry**: Yeah, I think that's true that, um, it's not like they're all kind of isolated and ... I mean, definitely don't want that to be the case that, you know, churches either partner together or if they're, yeah, like you're saying, in the same denomination or something like that then they are aligned and there are people, maybe the leaders that work together, um, to talk about, like, high level, "what's going on" type of thing, uh, but it's like, the way you're effective is that you're kind of sent out, um, and where you're at, um, instead of ... Yeah, just I guess you don't have enough context into what's going on, so you kind of have to, like what you said, have that level of centralization and decentralization.

[06:39] **Nadia**: Yeah. I wonder if there ... Well, I don't know. Do you know any examples of, like, churches in the same physical location that kind of split off into two sep-, or two different churches? Um, and I'm sure there are a lot of examples of that but I don't, I don't know any personally but, um, I guess I was just trying to think, like, do they split off because there's a difference in beliefs or philosophies between those two churches or just because the church got, like, had too many members and they had to start a second chapter of it in the same area? Like, what's the natural limiting factor in a church splitting off? Is it ... Basically, like when is the, when's the right time to fork?

[07:19] **Henry**: It's a good open source term.

[07:22] **Nadia**: Yeah, like, is it, is it because you have a difference in the way that you wanna carry on your operations or is it because there are just, like, too many people and you can't organize that many people efficiently in church?

[07:33] **Henry**: So you're just talking about if a church, uh, wants to split, um, and s-, and why, I guess?

[07:39] **Nadia**: Yeah. Not, like, denomination or anything but just, like, the actual church where people would go to, like, you hit, like, 100 people. Do they ever split into 50 'cause it's just easier? I feel like they wouldn't unless there was a difference, like, they're an actual split in community philosophy.

[07:55] **Henry**: Um, well, I, um ... churches definitely will split in terms of the, I guess, philosophy or theology, um, that ... I mean, but even that, it's not like it, it takes, you know, a long time for people to be like, "Okay, I'm willing to ..." 'Cause that's gonna cause, you know, a lot of, um, issues with the members and everything about it, right? So it's like a ha- ...

[08:19] **Henry**: It's a difficult decision that, you know, that people might have to make, um, or something, like, happens, uh, like, some event, um, where it's like, "Okay, maybe one leader decides to do their own thing." Uh, but it's also, it actually is kinda common for churches to split up if quote, unquote, "it gets too big," um, and maybe it depends on, like, the location, um, like, maybe if it's in New York and then it's, there's no enough space.

[08:48] **Henry**: Well, you know, you could decide a few things really. Like, you could either figure out if you can expand the existing building, um, or you should figure out if you can, you know, get a lease or a rent for a, a bigger building somewhere else and you have to move the whole congregation somewhere else, um, or like what you were saying is yeah, you would actually split it up and have two places or, you know, multiple, I guess, quote unquote, "campuses" or something.

[09:19] **Nadia**: Yeah. Interesting to think about. Um, going back to money stuff. I know I went down this other track (laughs). Um, can you talk a-, as much as you know, like, what the fundraising process looks like in religion or, like, especially the concept of [tithing](https://en.wikipedia.org/wiki/Tithe) but even besides tithing? Like, how do churches raise money for stuff they need to get done?

[09:43] **Henry**: Yeah (laughs). There's a lot to talk about and I probably don't know that much but, um, so I guess first, we can say that tithing, like, the word comes from, like, um, an old term that basically means 10% and so that's where we get the idea that people that, uh, I guess, attend a local church to give 10% of their income to that church, um.

[10:08] **Henry**: And it comes from, uh, the Old Testament and I think the background is basically that if, let's say, like, God appoints people to be, you know, staff on a church, like, say, pastors or different leaders, that kind of thing, that, um, they can be focused on, you know, serving the people that go to that church and everyone else that is, you know, the lay people, they work and they can, uh, basically pay part of their income to support those people, um.

[10:39] **Henry**: And so that carries over, uh, now where there's no, like, maybe before, it was, like, required, like, a law where it's like, "Okay, you have to give this much of your money." Now, it's more, it's the same thing, but it's not a rule where it's more about like they'll say something more about, like, you should have a cheerful, like, heart in giving and that there's no like, "Oh, you have to give 10% kind of thing," but it's more give that of, you know, abundance that you've been given.

[11:10] **Nadia**: It's sort of.. that's basically like a tax system, right?

[11:14] **Henry**: Yeah (laughs).

[11:16] **Nadia**: Sort of like ... I don't know. I find the other part interesting. There's like an implicit assumption there that some people pay and then, like, other people can enjoy and benefit it, like, people that casually come in because other people are paying, right?

[11:29] **Henry**: Oh, yeah. It's true. I mean, yeah. Not everyone is going to do that, um. You know, one thing that people might suggest is that, we talked about, uh, church membership a few episodes ago and some churches will say like, if you're a member, then you're not, like, required either but they highly suggest that you, um, you also give the tithe.

[11:48] **Henry**: And I think it goes back to, like, where we were talking about context before, it's like if you're, you know, committed to a church, you know, over a year's time, I think it's ... Like, I don't see why you wouldn't wanna, um, support the thing that you're a part of, right? And so, um, I, I think it's not, you know, out of the question for you to be like, "Okay, I'm going to invest my time and also my money into this, in this community."

[12:16] **Nadia**: Yeah. It, it's, I mean, there's really, like, no one who's giving to a church that doesn't have some personal stake in the church, right? I mean, I can't even imagine what that would be, like, a random sponsor (laughs) or something.

[12:31] **Henry**: Um, so the way that would work would be more like maybe, you know, um, some, something happened, like, maybe it was an environmental thing, like, you know, hurricane or something and you might decide to donate to a different church, maybe it's a sister church of yours, um, and you have, like, a loose connection but it's not like you go there or anything.

[12:51] **Nadia**: Still a member of that same faith or ...

[12:54] **Henry**: Right.

[12:54] **Nadia**: ... Other community. I feel like it's so much harder to do that online because then like you can't see who your community is, right? Like, with churches, you're, like, coming into physical space on a regular basis and, like, forming, yeah, in-person connections ...

[13:13] **Henry**: Mm-hmm (affirmative).

[13:14] **Nadia**: ... Um, and I think, like, a problem that's more unique to open source and, like, a lot of other things around funding online is, like you don't actually really know who your users are, um, who your users are or who's benefiting from it, who's participating or anything until someone actually tries to, like, make a contribution or something, um.

[13:33] **Nadia**: And it's just like, it feels like ... Yeah, I don't know whether this solution is to try to make your community more visible somehow or reveal themselves or whether it's that maybe they just aren't ... I don't know whether there's actually a way to, like, transfer what works with in-person communities to online communities, um.

[13:55] **Henry**: Yeah.

[13:56] **Nadia**: I was thinking about this post that [Feross](https://twitter.com/feross) did, like, a while ago. I think it was for [WebTorrent](https://webtorrent.io), um, where he just like [opened an issue](https://github.com/standard/standard/issues/744) and said like, "If you're using this ..." I think specifically, "If you are a company using this, um, just like post on this thread," and got, like, a whole bunch of people that posted saying, "Hey, our company is this," which I thought was, like, a really simple but, like, (laughs) great idea to, like, I don't know. If you're a project and you don't know which companies are using you, why not just ask and see who responds. And I think he used that to help inform, like, where to get sponsorships for his work.

[14:33] **Henry**: Yeah, that makes sense. That's why a lot of open source projects, we have that [users page](https://babeljs.io/users), uh, for, like branding or whatever. It, it's funny 'cause I remember joking before, like, technically that page is a good ... Like, we could rename that page to say "all the companies that don't pay us money", um, but (laughs) ...

[14:50] **Nadia**: But that would not be great if ...

[14:51] **Henry**: Yeah, it wouldn't be great, um. No, I think that's, uh, there's so much to say that (laughs) ... Um, I, I think there's, that's kind of an issue even with, in church too where, like, you know, they're trying to embrace technology but then, there might not be a lot of people that are, like, I guess, in, I guess the leadership of the church to understand technology well and then they're maybe like, "Oh," some people are like, "Oh, we gotta, like, you know, add online giving." Other people are like, "No, that kind of takes away from, like, giving because you wanna feel like ..."

[15:25] **Henry**: Kinda like how, like, now we have, like, digital bibles and then there's a physical one and then there's something about reading a physical book that's different from the digital one and, like, giving out your check or your money, it's like, that physical act, um, says something differently than just, like, kind of, what if you did, like, the automated, like, "Every month, I give this much," and you kind of forget about it, um.

[15:48] **Henry**: That kind of defeats the purpose where the point of the tithing is to help people but it's also to help yourself whether you're like, it's an opportunity for you to kind of act out that belief that, you know, your money is not yours, um, say, in, in, in the sense of church, it's like, it's God's money than even though all of it is his, it, to give that act as a way for te-, you telling yourself that you actually believe that.

[16:14] **Nadia**: How do they collect the money if it's not online? Is it, like, an in-person check?

[16:20] **Henry**: Yeah (laughs).

[16:21] **Nadia**: Really?

[16:21] **Henry**: Um, wait, so, so, um ... This is probably, you know, when, when you attend a church, there's always, like, there's like a worship service and a sermon and in some, sometime in between, they do that whole, like, offering, uh, offertory, uh, where they, they have, like, some kind of, I don't know-

[16:39] **Nadia**: Like, the plate?

[16:40] **Henry**: Yeah, whatever it is, the plate or a bag or something like that, um, and then you have your welcoming team that kind of is there and then you kinda pass it down the aisles kind of thing, um, (laughs) which is always interesting 'cause I'll, I think people have a lot of opinions on how that works. But yeah, that's, every week, you can, you know, give money through that, um.

[17:01] **Nadia**: That's not, like, the major source of funding though, right? I mean, like, if you're giving 10% of your income, you're not putting that on a plate.

[17:09] **Henry**: Uh, well, yeah, that's where you would just put in a check, yeah.

[17:12] **Nadia**: Oh, wow. That's crazy.

[17:14] **Henry**: Yeah (laughs). That is pretty normal.

[17:18] **Nadia**: Just picturing these, like, churches laundering just, like, massive amounts of cash and checks.

[17:23] **Henry**: Well, that's the thing. I think most people don't do it, so (laughs) ...

[17:28] **Nadia**: Yeah. It would be curious for a church that.. I'm sure there are churches that do online giving or ...

[17:34] **Henry**: Mm-hmm (affirmative).

[17:34] **Nadia**: ... That's, like, a regular subscription, so you don't have to think about it or whatever, I'm sure would unlock, like, more people that are comfortable giving in that way versus in person, but it would just be really different. I like your analogy about just, like, digital versus physical books also 'cause ... I just switched back to.. side tangent. I just switched back to, like, physical books for the most part, um, after using Kindle for a few years and I can't, like, put my finger on why, like, the Kindle has done everything right. It's like I can't point to something that I don't have.

[18:03] **Henry**: (laughs)

[18:03] **Nadia**: But it's just like, it's just not the same as holding a physical book and maybe, like, people like me will eventually die off and everyone will use Kindles but, like, there is just something irreplaceable about is, so, um, yeah.

[18:14] **Henry**: Ah, yeah.

[18:14] **Nadia**: (laughs) Fundraising.

[18:18] **Henry**: I don't think that's true. I don't know if, like, "our kind of people" ever die off. I kinda feel like every time we add a new medium, it, like books, you know, they don't really go away and I feel like even if, you know, you're used to, like, digital, you always go back to physical for some reason. I think it's maybe, you know, we've kind of got caught up in this whole, like, everything is about, like, your mental state and psychology and you forget we're actually people in a body and that actually affects, like, how we perceive the world, um, and so, like, that sense of physical touch really means something, um ...

[18:54] **Nadia**: Yeah.

[18:55] **Henry**: ... Maybe.

[18:57] **Nadia**: It's, it's interesting to think about, uh. There is, like, a dad who is telling me that, like, apparently among kids right now, like, super tactile clothing is, like, all the rage, like, things that are, like, really ...

[19:08] **Henry**: Oh.

[19:08] **Nadia**: ... Fluffy and, like, things you can touch and, like, his hypothesis was because, like, people aren't touching enough in real life, which I thought it was kind of interesting, um. Yeah, that's what it turned out but anyhow, more, more unconfirmed things I've heard, uh, that, like, apparently bookstores and physical book sales are, like, way up in our generation which I guess is the idea that people want physical books for whatever reason.

[19:34] **Nadia**: So yeah, maybe they're not going to die off, um, but you're right. Like, we kind of underestimate the, we are, like, human beings and maybe there's sort of like a backlash response where, like, you do wanna have more physical things, um, in your life and maybe it will be one of those things too, like physical, physical sense of community.

[19:53] **Henry**: Yeah. I think it would be interesting when we get to, like, VR and AR and all that 'cause, like, it kinda loses the sense of touch, um, but ...

[20:00] **Nadia**: Yeah, really relying on visual and your ears. I mean, there's something with haptic feedback but yeah, it's very, it's not very tactile at all.

[20:08] **Henry**: It, it kinda reminds me of, I think I was talking to someone and they were talking about how, like, all the new cars, they have touchscreens for all the buttons but then a lot of, uh, older folks, they kinda, like, they have this muscle memory with the buttons on the car, like, how do you turn on the AC and all that stuff, but now it's all just a screen and they have lost, like, the memory of, like, where things are 'cause it could be anywhere on the screen and maybe you have a UI update and then now everything's different again.

[20:38] **Nadia**: That'd be so disorienting. I feel like such a luddite saying that but that would be very disorienting, also, I don't drive, so maybe not (laughs).

[20:44] **Henry**: Yeah, I'm glad I don't drive anymore too (laughs).

[20:48] **Nadia**: Um, okay. Go back to fundraising stuff, uh. I was thinking about, like, like, why do people give in a church context versus why would someone give in an open source context and, like ... Yeah, what are, what are they looking for? What do they care about? And it seems like in a church context, like, there's just this ...

[21:17] **Nadia**: It's sort of like a more deeply ingrained cultural obligation almost that like you're doing this because there is already an expectation that that's what you do, like, I think most people, if you've been to, like, one church service, you're familiar with the idea of, like, an offering being passed around and, like, that's kind of just like a thing you do.

[21:35] **Henry**: Mm-hmm (affirmative).

[21:37] **Nadia**: Whereas, like, I think something that I'm afraid of with, um, open source sustainability stuff is that people that are giving out of this sense of, like, charity because that's never anything ... I never wanted it to really, like, be about that (laughs). Like, I want it to that you're doing this because you rely on it and you should but I guess it was like a really fine line between like, "Are you giving this because you feel bad for the project?" Because I think they're just like, you know, there's only an upper limit to how much money people are gonna give when they're doing it out of this sense of like ...

[22:09] **Henry**: Mm-hmm (affirmative).

[22:09] **Nadia**: ... altruism, um, but it's different to do it if you feel like, "Well, this is just what I do." Like with tithing, I mean, if, if 10% is the expectation, then, like, that's a very high percent but it's just like a thing that is kind of like, it's knowledge that it's just sort of like known and distributed and, like, understood, um.

[22:27] **Nadia**: And so yeah, I guess, like, I'm wondering, like, what are the actual takeaways for open source around, like, what does that message look like, um, like, if, if the funders are people that are coming from your community, they are people that, like, maybe companies that use or rely on your project, like, why would you ideally want them to be giving or not? And then part two, are they interested in your views on this given that Babel.. like people give for lots of different reasons, I'm sure.

[22:58] **Henry**: I mean, even if, like, the church setting, like, there's a huge expectation, um, and I think that would be great if we had that, an open source 'cause clearly it's not there and maybe now it's, like, kind of getting there or at least people are like, "Oh, open source projects are actually getting money," even though it's, like, basically nothing.

[23:17] **Henry**: But then they also, it kind of goes, like, in the wo-, in the, in the other way for church where it's like because there's an expectation, people do it out of obligation and we don't want to, like, guilt people into, like, giving, um, which kind of, like, it is about, like, you wanna give because, not because, like, it's a good idea or you feel bad but, like, no, this is, like, important to me. And I think that should be the same mindset in open source. Like, um ...

[23:46] **Nadia**: How do you, how do you encourage someone to do that for the, like, quote unquote, "right reasons?"

[23:53] **Henry**: Um, yeah, I think that's really challenging and I feel like that is kinda almost a, almost like a lifelong journey that you have to go on. And it's the same thing with church itself. Like, people think like, "Oh, if I, you know, go to church or if I give money or, like, do good things that somehow I'm like, it's good, right?"

[24:15] **Henry**: And I think then you're expecting something out of giving, um, and you kinda have to ... I know it might be different than what you think but, like, giving out of, like, not expecting anything back but knowing that, um, the process of doing that will, you'll oversee that. It's kind of like you have to do it in faith in a way, um. It's hard because there's always that struggle between, like, knowing, like, you're doing the right thing and then not expecting anything out of it.

[24:47] **Henry**: Like, you should, like even in, in work, like, we should strive to be the best person that we can be, um, but then we can't derive our identity from, and our worth from that, the outcome of the work. And I basically talked about that in my talk. It's like, you know, you can spoil your life out and doing open source and then people don't appreciate you and then now you suddenly feel like you're not worthy anymore.

[25:11] **Henry**: And I guess it's the same with giving. It's like if you give expecting all the stuff and then ... Say you gave all this money to open source and then they didn't, like, release the thing in the time that you expected and now you start feeling like, like now they owe you, um.

[25:28] **Nadia**: Or that's why it's different in open source 'cause I mean, like, you have companies that are relying on this for their work, right? Like, it is, it is fundamentally just a different kind of relationship than a spiritual private practice, um. And so, I guess, yeah, I'm wondering, like, longterm, if we see project being well-supported financially when they need it, um, is it gonna look, is that gonna happen because projects have gotten good at, you know, building this relationship with companies and kind of suggesting that, like, your participation in this is a way for you to be closer to the project.

[26:10] **Nadia**: Like, I think that's what [Sean Larkin](https://twitter.com/TheLarkInn) has done really well with Webpack of, like, they have office hours and, like, companies see these, like, tangible benefits to giving and that's why they keep giving, um, or is it gonna just kind of be this, you know, it will take years and years to kind of have this be ingrained but the idea then maybe it's just a thing that you do the same way that, like, tithing is something that you do because you're not expecting anything out of it but you're doing it because it's just the right thing to do.

[26:39] **Nadia**: But it's, like, very hard for me to think of, like, a company doing that because (laughs) I don't know, like ... I mean, it's hard enough to justify sponsorships even when there are, you know, tangible tactical benefits, um. It's a lot har-, you can't really go to your boss and say like, "Can we add this line item to our budget because it's just kind of what we do?" Maybe. Maybe for certain companies but, um ... And maybe just different messages will appeal to different kinds of funders but, to me, those are, like, two kind of distinct visions and then I'm wondering how much can open source really take from, like, uh, from religion in that sense.

[27:17] **Henry**: Right. Um, no, I think what Sean does is, seems to be the way to go, like, um ... I don't know if, like, if they don't see anything from it, um, then at some point, someone's gonna question, you know, like, they look at the account and they're like, "Why are we giving this for nothing back?" Um, and it's, as much as we would like to say like, "Oh, we're, like, investing in the future, whatever," no one's gonna believe that and so, um, yeah.

[27:45] **Henry**: Creating, like, being creative with the kinds of things that you kind of offer back, um, helps although in another way, like, I don't know if you can ever really, like, put, like a monetary factor on things where it's like, "Oh," like, say, a lot of people sponsor open source for marketing and, like, hiring and it's hard to measure like, "Oh, we gave to this project and somehow that led to, like, X people," unless you said like, "Oh, how did you find out?" And they're like, "Oh, it's 'cause I saw it on the website," or something.

[28:16] **Nadia**: Right. That's hard for a lot of marketing budgets in outside of open source.

[28:21] **Henry**: Right, and so it's like, you know, and we can say things like, "Oh, you sponsored a conference for, like X thousand dollars and instead, you could just donate to this open source project and get the same visibility or something." And Sean does a lot of interesting things, not just the office hours but, like, (laughs) like, we could even, like, for the next Babel 7 release if I, if we wanted to, you find a company and it's like, "We're gonna name this release after yours or your company," and then now you get a lot of, like, buzz or branding.

[28:48] **Nadia**: Like-

[28:48] **Henry**: I don't really wanna do that but (laughs) ... Yeah.

[28:54] **Nadia**: The other thing I wanted to touch on was, like, uh, people in a church that are giving not just money but giving their time, like you mentioned that you volunteer on the welcoming committee at your church, uh ...

[29:10] **Henry**: Mm-hmm (affirmative).

[29:11] **Nadia**: ... And, like, and it's not even ... Yeah, I don't even volunteer is right or, like, I mean, you're participating in the production of this whole thing in a very serious way and yeah, like, for people that want to give back to church, like, do they face this either or question of like, "Do I give my money or do I give my time?" 'Cause that seems really similar to me with open source of, like, on the one hand, it's sometimes it's like, you know, encouraging companies to give money to projects but then it's also, like, your engineers should also donate their time or, you know, give back to projects during work hours with things like that, so it seems like too similar ... It, it's two kinds of resources that someone else can give back to a project.

[29:56] **Henry**: Yeah, I think they are very similar, um. I guess for church, it would, I would say it is an "and" like, it should be both (laughs), um. I don't know if you can expect that from random people on open source, um. No, I think, like, in the church, everyone is actually called to serve in some way, um, and we would say that, like, God has given everyone we'd say spiritual gifts and, you know, maybe it's teaching or, you know, welcoming or hospitality or giving money to all those different ways that people can help, um, and encourage everyone to serve and, you know ...

[30:32] **Henry**: I don't know if it's that different from open source too. Like, I think everyone should be able to. It doesn't mean we can expect that to happen, um, but it doesn't mean we don't try, uh, to incorporate that and even so (laughs) ... It's funnily enough. This year, I, like, finally decided to, like, be a, quote unquote, "leader" for our, like, bible study family group, um, and it took me a really long time to wanna to say "okay" to this, um.

[31:00] **Henry**: You know, there's, like, all this responsibility and burden and I figured that if, you know, if I'm already kind of doing this in my regular work with open source, I didn't intend to be a leader, um, but here it's like it's not that different and I feel like I can learn a lot from both, um. And I think in the same way ...

[31:22] **Henry**: I don't know. It's, we wanna encourage people to, like, be involved in a project because, you know, they can give us all this money but in the end, I'm just one person and there's no way for me to handle all the kind of responsibility and things that we could be doing, um, and I think it's a way for people to step up and I think it calls for leaders to learn how to, you know, delegate and to inspire people to, like, be a part of it knowing that they are capable of giving back.

[31:54] **Nadia**: That's cool. I like this idea of, like, money and time being an "and" and not an "or" thing 'cause it is true in both directions. I think I mostly thought of it in the direction of if people give a lot of time but there's enough money, like, well, you still need money for some things at time, just can't make up for ... But it definitely goes in the other direction too of if you had all the money in the world but you're one person, like, that's also, like, you just can't even deliver on all the things you wanna do. So you need other people to help out.

[32:27] **Henry**: Yeah and, I mean, I think time is ... At least in open source, I feel like that's way better than, uh, money because it's like not, like you don't necessarily have to work on, like, open source full-time, like, if, you know, if we had enough volunteers where, like, everything just worked, yeah, you wouldn't even need money because you're getting money from somewhere else.

[32:49] **Henry**: But I do think kind of similar to a church where they have, like, like a pastor or whatever and they, uh, they're paid full-time to manage this organization, I think it is great that a project could have someone full-time because you need someone to be thinking about, like, the vision and all that stuff, right? And I think it's hard to do that when you're just trying to juggle all these things in your life.

[33:14] **Nadia**: Do you have anything else you want to talk about?

[33:17] **Henry**: I think, uh, we talked about church health, um, and project health a while ago and just a very basic point is that, the way that money is related to that is that the more people that attend, the more money that you might potentially get because more people might tithe. And so people like to use, like, the numbers in church growth to signify whether a church is doing well, even though that doesn't necessarily mean anything 'cause I could say, like, same with open source, like, we raise a lot of money, uh, that doesn't mean we're doing well because maybe that person's burnt out, they don't know what to do with the money or they don't know how to, like, find people to, um, I guess, quote unquote, "hire" to help.

[34:00] **Nadia**: Is the equivalent, I guess, it will show ... It's not necessarily number of contributors but it's number of users to a project.

[34:11] **Henry**: Uh, for, like, attendance, I suppose.

[34:14] **Nadia**: Yeah, as an attendant, a contributor or user.

[34:20] **Henry**: (laughs) Um, well, for them is more that, because there's more people and more people will give back, so that would be probably, like, how many companies are giving back. Yeah, 'cause I think number of people helping is more, like, burden in some sense.

[34:34] **Nadia**: Right.

[34:35] **Henry**: I don't know if we touched on this but, like, yeah. What happens when you have money, um, and how are you supposed to use it, uh, in, in church, like, we use the word "stewarding," right? It's like, um, when you do have money, you can, you know, be generous and give it away and, and help other people or you can kind of waste it and, like, squander it, um.

[34:59] **Henry**: And I think one of the hardest things to do is when you do have money, whether it's personally or in church or an open source, it's like making sure that you use it well. And the word "stewarding," I think is great because it's saying, at least in a church setting, um, it's saying that that money is not yours and it's been given to you, uh, and so you have a, like a responsibility to, um, use it well.

[35:26] **Nadia**: It's definitely a concern with that in non-profits, including some tech non-profits where ... Like, I know that there's been criticisms of Wikipedia during their annual campaign, and I don't know how true this is or not. I should probably stop sharing things on this podcast but (laughs) ... I don't know whether that's true or not but I just heard from multiple people that they at least felt like, "Well, what is Wikipedia really doing with my money?" Like, there's not that much product development, um, but they do this huge fundraising campaign every year and, um, yeah, like, I think it is a question of ...

[36:06] **Nadia**: Like, I think that's where those sort of like help metrics you were talking about can come into conflict where they're just so many people that use Wikipedia that raising money at this point I'm sure it's just, like, trivial for them even though they do the whole, like, you know, blocking out your page and Jimmy Wales' face and everything. In the end, I think it's probably not hard from them to raise the money they need just because there's, like, a lot of people that go to it. Although I think Google is cutting into that traffic now, but anyway, yeah.

[36:34] **Henry**: I think it's funny. I just, I just, I just saw that today, like, I was on Wikipedia, and I was like, "Wow, this whole page of (laughs) telling me to donate." I guess it goes into that, yeah.

[36:43] **Nadia**: I think some people do because it's such a feel good thing of like, "Well, yeah. I love Wikipedia. It's this random thing, and it's, seems like it's just kind of run by volunteers or something," um, but they end up having, like, a pretty large budget and maybe it's larger than they need but how do they, like, how should, like, it would also just be weird to say, "Oh, we're not gonna raise money if we don't ..."

[37:02] **Nadia**: Like, we're gonna only raise a finite set of money, right? 'Cause, like, more money is more freedom to be able to plan ahead or do things that you might want to, I don't know, it just gives you more options, so it's also hard for me to imagine someone like Wikipedia saying, like, "We're only gonna raise, like, a million dollars this year instead of, like, 10 million or whatever it is," um, like, why would you wanna, why would you turn away money if so many people are willing to give it to you? And I think that's, like, a hard thing to know how to regulate.

[37:29] **Henry**: Yeah. And even just going into, like, kind of the ethics of fundraising and asking or ... And even now, people complain that in open source, like, for, say, npm, you have that post install message where, like, every time you install, at the bottom, it says like, "Hey, you should donate to our Patreon or open collective," and like, if every open source project did that, then you, like, gets spammed with, like, all the stuff and so I did not decide to do that for our project, um, but I can see that other people feel like they have to.

[37:59] **Nadia**: This is a huge controversy and, um, [Bundler](https://bundler.io), I don't know if you have followed that but like, they're just like, I think there are just two different factions within the Ruby/Rails community of people who think that kind of fundraising makes sense and people that don't, um, some kind of bubble to the surface publicly but, um, they had an install message that, I guess, like, the criticism was that it had sort of, like, inflated the problem in ways that weren't totally accurate or something like that.

[38:29] **Nadia**: But I think there was also just a criticism of, "You shouldn't have an install message 'cause tons of people work on this that aren't getting directly paid by these donations to do it, um." There are a lot of ... Like, I think that is sort of the ethical problem when you have volunteers working on your organization where, like, some people are getting paid but, like, what if I feel like I should get paid, and I'm just contributing for free and now I don't want to 'cause I can see that this maintainer over here gets paid to work on it, um, and that can be, like, yeah, just really difficult.

[38:58] **Henry**: Hm, that's really interesting because, like, I feel like at, um, in a church setting, I don't, I think anyone would feel that way, right? It's like we're all volunteering our time but we're definitely not expecting to get paid, um. I wouldn't, we wouldn't, we wouldn't want to have that responsibility anyway (laughs).

[39:17] **Nadia**: Yeah. I, yeah, I wonder, like, I think it makes it even more complicated in open source that ... See, if people that are completely volunteers, like, they just kinda do it 'cause they feel like it, there are people that are getting, that work at a company that allows them to work on open source, which is kinda different and then there are people that might get funded independently to work on the projects. And so, like, I'm guessing a lot of the criticism also comes from employees who are, like, they're being paid full-time somehow to work on this thing, but it's like, "Yeah, but not everyone has that same situation as you," or like, I don't know. I think the problem lies when sometimes you're not ...

[39:52] **Nadia**: Just because you're not being paid to work on the project by the project doesn't mean you're not being paid somehow to work on the project and, like, you're not a volunteer if ... In my view, you're not a volunteer if you're a company employee and your company is, like, essentially encouraging you to work on it all day long. Like, that doesn't make you a volunteer. That, that just means you have a corporate patron.

[40:14] **Henry**: Yeah, exactly.

[40:14] **Nadia**: And so yeah, I don't know. I think, I kinda look side-eyed at people that are criticizing (laughs) fundraising efforts in that way 'cause it's like, I don't know, you're in a very special situation that allows you to do that.

[40:23] **Henry**: I agree.

[40:23] **Nadia**: Yeah (laughs).

[40:30] **Henry**: As the one that doesn't work on a company, I agree (laughs).

[40:31] **Nadia**: Yeah. I'm sure you got feels on that. So yeah, it makes the whole fundraising really hard 'cause it's like, "Well, who are you fundraising for? Are you fundraising for yourself? And are you, like using the project as a platform to raise money for yourself and is that okay or not?" Yeah. How has it developed into more open source things than church things but ...

[40:47] **Henry**: (laughs) It's hard to talk about money without being very negative because ...

[40:53] **Nadia**: Yeah, we'll it involves a lot of ... Yeah. It just involves a lot of ... It's, it's because it's like quantifying a thing that you didn't think about quantifying beforehand, I think (laughs). Or I think that's what makes it especially hard in, um, stuff like open source or religion where ...

[41:11] **Henry**: Yeah, everything.

[41:12] **Nadia**: Maybe you didn't come into it thinking about money at all. I mean, you probably didn't 'cause it's not like you can make a ton of money (laughs) and either of these situations ... Yeah, once you do have different reasons for being in it or you just need to, like, sustain the work that you're doing then it just leads to a lot of difficult conversations.

[41:29] **Henry**: Yeah. It's just a lot of pressure really. You wanna sustain yourself but then you're like, "Well, should I limit how much that I make?" And all those questions, and feeling guilty almost. I felt like that a lot when, you know, I was trying to raise money on Patreon where it's like you feel bad that, like, people are giving you money but you should feel free but you, you don't. You almost feel trapped, um, and maybe you don't wanna feel like you need to give more or, like, do more, uh, because they're giving you money, uh. So that, I think, like, the incentive of, like, all the different reward systems isn't necessarily great either.

[42:04] **Nadia**: Yeah. I've heard that from people that are hired by companies to contribute also where it, it, in some cases, that works really well and in other cases, it's like, "Well, suddenly this thing that I could choose to work on or not, I now feel like I have this obligation to work on," um. So yeah, I think it's hard for everyone.

[42:23] **Henry**: Yeah. I feel like, um, now I feel more like ... I don't know what word is. Not strongly but, like, I understand that there are people that, like ... I think we all have this dream of doing open source full-time but, um, now that I'm actually living it, it's like yeah, I don't think it's for everyone, and I'm sure there are a lot of people that just like doing it for fun, and they wouldn't want it to, to worry about all this, you know, stuff that they have to deal with, um.

[42:51] **Henry**: And I think if we can encourage people to, like, be able to work on open source in the ways that they are able to, you know, maybe they can only do it an hour a day but they see, like, all these people doing it full-time, they're like, "Oh, I'm not actually doing open source," um. I think we should figure out how to, like, showcase the different ways that you can contribute.

[43:12] **Nadia**: Something I came to realize a while ago that has just made me so much less angsty about all of this is just accepting that, like, there are gonna be so many different ways for people to do a thing that they like to do and there's never gonna be this, like, one correct path that will solve everything for everyone because everyone is different, everyone has different motivations, um.

[43:33] **Nadia**: And you could say the same about religion too, right? Like, be, like, spiritual but not religious. You can, like, practice privately and not go to a church at all. Some people want to be really, really active in church. Like, none of that is, like, right or wrong. It's just, like, different people have different behaviors and the, the goal is just to give people lots of different options and to know what their options are but not to force people choose one thing or another.

[43:55] **Henry**: Yeah. Going back to [evangelism](/evangelism).

[43:58] **Nadia**: Thanks for listening. If you'd like to continue the conversation, you can find us on Twitter at [@left_pad](https://twitter.com/left_pad) or [@nayafia](https://twitter.com/nayafia) or on our website [hopeinsource.com](https://hopeinsource.com)
