---
title: "02: Community Membership"
season: 1
date: "2018-10-16"
time: "34"
description: What does it mean to join a community? We talk about casual versus committed membership, and how maintainers and leaders manage expectations around trust and collaboration.
episodeLink: "892ed7d4"
embedUrl: https://share.transistor.fm/e/1ca166c4
sidebar:
    order: 2
---

### Links

- [Call to Commitment](https://www.amazon.com/Call-commitment-Church-Saviour-Washington/dp/B0006AYJSS) (book)

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-1/membership.md)

#### A Call to Commitment

[00:00] **Nadia**: So today we're gonna be talking about the concept of membership in a church. What it means to commit or not commit to attending. I think that's it, right?

[00:13] **Henry**: Yeah, Sounds good. Or how that relates to how we might see that in open source.

[00:18] **Nadia**: So I was thinking about this topic because I was reading this book called Call to Commitment, about a church that kind of took the approach of drawing these very clear lines around who was a member of the church and who isn't.

> [Call to Commitment](https://www.amazon.com/Call-commitment-Church-Saviour-Washington/dp/B0006AYJSS) is by Elizabeth O'Connor, who wrote about her membership at [Church of the Saviour](<https://en.wikipedia.org/wiki/Church_of_the_Saviour_(Washington,_D.C.)>), with a focus on lay (not professional) ministry, accountability, and intimacy. They emphasized small groups over what has become mega churches, and influenced movements such as the emergent church.

[00:33] **Nadia**: The idea being that if you wanna show up and attend, you're always welcome to attend, welcome to take part and enjoy the services. But if you really wanna be a part of the church, they wanna know that you're super, super committed. And that means saying no to people that might just sort of be casually committed. And just taught me about what it means to have a smaller group of people that are actually at that level of commitment.

[00:59] **Henry**: Yeah, I go to a church that has membership. And they're plenty of churches that don't. I think this is something that was traditionally implied already, that most churches have it. But then recently, I think there's been long trend of wanting church to be more friendly and welcoming people. They use the word "seeker-friendly". And what that means is that there's someone trying to seek God, and it's like, "Oh, we want to cater to that."

> "Seeker-friendly" can mean a positive emphasis on welcoming and inclusion, though I think it's tend to be used pejoratively to emphasize creating an overly watered-down environment that doesn't challenge, and rather caters to current tastes. It might be a change in aesthetics (form), so that it's music sounds more like pop music than hymns, the attire seems more casual rather than ornate, the sermon like a ted talk than convicting, or the building feels like a mall/concert instead of a cathedral. The idea of "meeting people where they are" can be helpful but sometimes it can remove the distinctives of what the church even represents. I think this kind of thinking believes that the content (Jesus) takes precendence over the medium to a fault, disregarding what might make church distinctive.

[01:26] **Henry**: In certain churches, maybe the majority of people are people that might not actually believe in God, but they're looking. Maybe they think that having membership turns people off. But with membership you can see what it's like to be a member, to be committed, to have responsibility, to be in a greater community with people.

[01:49] **Henry**: It's like the depth of community versus just like, "I'm there". Or for a lot of people, maybe they only go on like Christmas or Easter or something like that.

#### Membership as an Affirmation

[02:02] **Nadia**: So what does it mean to be a member? What do you get if you are a member? And also what do you have to give to be a member?

[02:08] **Henry**: Yeah, so I think for (laughs) a lot of places, I think the get is not like a material, well maybe they'll give you a certificate. Hey, you're a member now. But it's more of a sense of responsibility, it could be a lot of things. So like maybe you're expected to participate, or to be there every week for people to join a certain type of ministry to serve people in the skills that God is giving you.

[02:44] **Henry**: Or maybe it's tithing. Or maybe it's other kinds of responsibilities in the church. And I think the way a lot of people think about it is... my old pastor used the word, not like a Costco membership. Where you kind of pay a fee every year, and then you get these nice benefits or sales on things. No, you're committed. And I think even in the book, you're committed to this local group where you live for the foreseeable future. Instead of just like, I can come and go whenever I please, where people wanna know what's going on and you care about what's going on.

[03:35] **Nadia**: Sounds like it's almost more of like a declaration/affirmation of a level of commitment you already have, versus you sign up and then grow into it.

[03:47] **Henry**: Right, exactly. Unless you just feel like you've been to this church one week, and you're like, "Oh, this is already for me." A lot of people, they might wait a whole year to decide to be a member. Because you could think of it like a marriage, or we would use the word covenant. It's like you're signing something to say, "Yeah, I'm committed to this church, and the church is in turn also committed to me in the same way."

#### On Rejection

[04:20] **Nadia**: Do you know if anyone have ever turned down someone who wanted to be a member, but they thought weren't ready for it?

[04:28] **Henry**: Oh yeah. So you might have certain... you wouldn't call them hard requirements, but a lot of membership, they have like a class you have to take. Maybe every week, someone will teach something about what does this church believe, or what they do, or the history. So anything like that.

[04:49] **Henry**: So you know what you're getting into, and then at the end, maybe you have the interview with the pastor or the elders there, just to talk about why you're doing this and and where you can help out, that kind of thing.

[05:03] **Henry**: So I don't know if people would necessarily reject someone. Because if you're gonna go through all those classes and all that, you get a really good sense of why they're doing this and what they're doing it for.

#### Membership Composition

[05:23] **Nadia**: And how many people are members versus how many people would just say, just attend a service and aren't members?

[05:36] **Henry**: It could be like half. It kind of depends on the composition of the church. Maybe if it's you know... I guess it really depends.

[05:46] **Nadia**: But like, for your church.

[05:48] **Henry**: Yeah, I'd say like, half or so. Yeah. Does your church have a lot of families, or maybe it's like college students, or kids, all those things kind of change the composition too.

#### From Contributor to Maintainer

[06:06] **Nadia**: Interesting. So, we're talking about this in relation to open source, and the idea of casual contributors versus longer term contributors and maintainers, and how to create an environment where the casual contributor is welcome, or anyone who wants to participate or wants to do more, can do more. But doesn't necessarily just sort of jump and then say, I'm gonna be a long-term contributor. You kind of have to do certain things to show a level of dedication, but how do you do that without being like elitist about it, right?

[06:41] **Henry**: Yeah. I think it's weird with churches. You don't have to show anything about like how you know good you are at x, y, z, right? So it's different with open source. Our level of trust is like, we actually do wanna see that you committed code or reviewing pull requests kind of thing. But in church it's not like, "Oh, like read the Bible like five times a day or something," and then now you're a member, right. (Laughs) We're not looking for that kind of-

[07:07] **Nadia**: I think they are like sorta similar, though. Or, just in the sense that the goal is to not document, but like, you already are internally committed or interested, and you're kinda just like doing the thing that you normally would wanna do anyway. It's not about like a test or proving yourself, I think there's some way that you set up a level of expectation that, if you're this active or committed, you are doing this kind of work already.

[07:42] **Henry**: Yeah, exactly. I think that's a really good way of putting it. You're not taking a test or proving something. You've already done work or you've already shown something before, but you're telling the group of maintainers or the church, that you are committed now. It's kind of like, you might do volunteer work just because, but later it's like, "Oh, I am, I'm committing to this." Or even me, where I'm like, "Hey, I was already doing open source, and it's fine. But if I quit, and I say I'm doing this full time, I'm telling everybody that I'm committing to this." And it's kind of like a declaration to people, in public, in the community as a whole, that I'm doing this. Instead of just personally, or individually.

[08:35] **Nadia**: Has that worked out in practice on Babel, in terms of like how maintainers became maintainers, or more active contributors?

[08:49] **Henry**: So I definitely have not like made a... I've never really thought about what exactly it takes to do that. We don't definitely don't have like classes on it (laughs), being a maintainer. I don't even have the right thoughts for that right now, which I wanna do. It would be interesting to make that more formal. I feel like a lot of open source is very informal, especially if you're not like a huge project. With, a large company backing and they're all paid to do that. And you have people that are all thinking about organization, right?

[09:24] **Henry**: But in open source, with just volunteers, they're maybe the ones doing it all, or one person's trying to think about that stuff. So it's more like, "Hey, I found this person that has been contributing for awhile, and they seem committed." You ask the rest of the group, and they're like, "Oh, that's cool," and then you add them. And that's it. And then you have to figure out what that onboarding looks like. You don't even have it all I think in most cases. So it would be better to make it more explicit.

#### Definitions are Hard

[09:56] **Nadia**: Yeah. So how does this play out with the sort of like, more casual or one-off contributors in terms of, making it seem obvious that they can join, but they can contribute however they want to contribute, but not necessarily... you serve them, but I guess in a different way than you would serve a fellow maintainer, right?

[10:22] **Henry**: Yeah, I guess it's almost like they might not even know they wanna be a maintainer, they don't know what it looks like. We should write down kind of what are the responsibilities of being a maintainer explicitly. What are the kind of things we, you should care about. And then that way they'll have a better sense of, "Oh, is this something I wanna move toward?" Same with mentorship. You'll find people, they're like, "Oh, you're a member," and say what does that mean? And you can talk about it in the same way. I'm just saying right now, maybe they don't even know that it's a thing, or it's very vague. It's like, "Oh, I'm a maintainer." Everyone has their own definition of what that means.

[11:03] **Nadia**: We were talking about this with church, right? Where I was like, I'd gone to church here and there, but I didn't even know there was a concept of (laughs) membership. I thought then everyone agrees to show up sometimes, and sometimes people were there more often than others. And if that is a thing, then it's interesting to think about. Oh, yeah I didn't even know that was possible, so maybe I do.

#### Not Everyone Will Be a Member

[11:26] **Nadia**: But I guess what I also would like is to call out that there are people who are just gonna be casual contributors, right? And there are people who are just gonna attend church every once in a while. And I've gotten very real pleasure out of attending church not as like, I am a member of this congreations or something, but just because it was exactly what I needed at that moment with my family or something like that.

[11:53] **Nadia**: And so there is like a separate experience to be had, where there is no expectation that you're gonna a member, but you still feel welcome just the same. I guess I'm wondering, like as a maintainer, how do you think about catering to that experience of like, we're just glad you're here, we're glad you're doing this once, but the level of maybe attention I'm gonna give you or level of commitment that I expect is just gonna be different. And how does that play out for you?

[12:18] **Henry**: Yeah I guess, even with open source, my expectation on people becoming maintainers is a lot lower than I feel like at church, I guess there's a goal of making everyone a member. Even though you might not have to turn everyone.. you're not you're forcing people to turn into members or anything. But I feel like with open source, it's even more so it's like, "Oh, they're probably just gonna contribute. Maybe they don't wanna be on this project, and that's fine."

#### Beyond the In-Group

[12:49] **Henry**: But actually, there is another thing that's interesting, the goal isn't just for people to come to your church. Maybe if it doesn't work for them, then you could recommend other churches. And in the same way, they're just trying to do open source in general. Maybe they don't actually care that much about the particular project, and then you can lead them on to other projects like, "Oh, you might be interested in this as well."

[13:20] **Nadia**: Have you ever done that with a contributor?

[13:23] **Henry**: Yeah, 'cause maybe they're like, "Oh, I'm not into compilers, or maybe my language isn't JavaScript," so I could say, "Oh, like you should contribute to webpack or React or something else." Yeah, I've definitely done that before. And other people have done that for me as well.

[13:41] **Nadia**: I'm curious, does that tend to happen within the context of the projects itself, or is that like a conversation at an event? Where does that sort of meta-conversation happen?

[13:53] **Henry**: Yeah, I think events definitely I think. 'Cause you know, people will come up and say, "Oh, I wanna contribute to open source, how do I get involved?" I'm not gonna assume that just 'cause they're talking to me that means they wanna contribute to Babel. Maybe it's just, about open source in general. Or if someone recommends someone that they wanna get involved in open source. In the same way, there's no like straight answer you can give them, "Oh, how you should get started." You have to really listen to what they're looking for. What is their commitment level, do they just wanna try it out, or do they have a specific thing in mind, all that kind of stuff.

[14:36] **Nadia**: How much... I don't really know how to ask this question, but to what extent do you think you should expect them to know and to learn that stuff themselves versus you're being helpful by giving them extra information?

[14:53] **Henry**: Yeah, that's really hard. I can't say we should put all the burden on them, but then at the same time we can't really put the whole burden on us, too. I don't know, I think that's just where you have to work with somebody. And I feel it's so much easier in church, where it's like, they're coming and they usually have a reason for going, right? And you can talk to them about what's going on in their life, and it's also in person.

[15:25] **Henry**: After the service or whatever you can get lunch with them, you can chat, you can talk, you can do activities, but in open source, it's kind of just like, oh they showed up and it's online. You have no idea about them, they have no idea about you either. Unless it's like at like a conference, I find myself not really (laughs) wanting to do all that work online just 'cause it doesn't feel effective.

[15:53] **Nadia**: I feel like I've heard something like that from other people, that they'll sign future long-term contributors or maintainers by meeting them at an event first, whether it's like a workshop or a conference or whatever. I guess my theory on that would be that you just have more context for someone who took the time to go to a conference, then you have some level of interest, some level of buy-in that's higher than someone who just put the URL into their browser.

[16:20] **Nadia**: And yeah, I was just trying to think what an extreme version of what would be like with church. I guess if some just sort of like walked into church, and was like, "What's this all about?" I'm guessing that people would talk to them, just because that would probably be a pretty rare circumstances.

[16:32] **Nadia**: Um, but if you'd had people coming into church like multiple times every few minutes, being like, "Hey, what's this all about?" You'd probably be like, all right, we need to put up a sign or something so people know what this church is about without disrupting our services.

[16:46] **Henry**: Right, well I'm on the welcoming team. And we switch off and all that stuff. And you'll have people at the front where you can greet people, and the hard part is that sometimes you don't know who's new (laughs), and so you have to like learn everyone's face and all that, and be like, "Oh, are you new?" And they'll be like, "No, I've been here for awhile," and say, "Oh, I guess this church is a lot bigger than I thought."

[17:10] **Henry**: But you know, if you notice that they're kind of like looking around or something, then maybe they're new, and chat with them. I think it's different because when you're at church, there's a focused specific time to be there, right. And you know that they're coming, or at least you're open for it. But in open source it's funny, technically they could show up at any point in time, in any time zone, you might be sleeping, they show up. And that is a very different experience, right?

[17:43] **Nadia**: Yeah, or if they're like, emailing you or tweeting at you, and yeah. (Laughs) It's much more personal space.

### What Defines a Maintainer?

[17:53] **Nadia**: I did wanna talk a little bit about this idea of, what is a maintainer or what distinguishes a maintainer's level of commitment from that of a regular contributor. And are there people who contribute in very specific ways to a project, but wouldn't be considered a maintainer, and if so, why?

[18:17] **Henry**: Right, I think you were talking earlier that, we tend to want to broaden the definition of maintainer. If there are specific people that only care about those things, so for Babel, it's like they care about this package, or this specific implementation, and in some sense they are a maintainer, they just maintain that small thing.

[18:40] **Henry**: And if you made that in another repo, would you call them the maintainer of that repo, just 'cause it's in the same project? It's kind of hard to distinguish. But then, do they only care about that one thing, do they have to care about every aspect? Does it depend on like how many people are working on it?

[19:00] **Nadia**: Mm-hmm (affirmative). So we definitely struggled with this at GitHub, of trying to figure out how to define a maintainer, in a way that was fair and objective. And I think while I was there, I erred more on the side of.. I think the definition I was pretty much trying to work with was, if you're having to deal with non-code aspects of the project, you're probably a maintainer. Like if you're thinking about triaging issues, or reviewing people's codes, then you're probably a maintainer, or you've moved into some different realm there.

[19:28] **Nadia**: But I don't actually think that definition holds, partly because there's such different sizes of projects, so that there might be a project where you do just kind of mostly write code all day. There can also be on the other spectrum, a really, really big project, where you just end up focusing on your specific area.

[19:48] **Nadia**: And so we would get maintainers coming to GitHub who would say, "I'm a maintainer because I maintain the documentation of the project." And I think there is probably some realm where someone could say that, and also be a maintainer, but I don't think it's maintaining the documentation that makes them a maintainer, it's are you kind of like worried about the overall aspect of the project? (Laughs)

[20:10] **Nadia**: If there are high level governmental decisions being made, would you feel like you had a really strong stake in them? Even that's like not a great definition, but there's something intangible about a maintainer, where I feel like your level of commitment is strong enough that you're going up or down with the ship.

[20:26] **Nadia**: Whereas you could still be a very regular, active, and valuable contributor, but if you're only concerned about your one area, and like you were saying, you might ping someone if you had React questions, like a specific person, and they kind of come in and talk about that or work on that, or whatever. And they're otherwise not super involved. I don't know that I would call that person a maintainer.

[20:49] **Henry**: Right. 'Cause it's just the one area, and especially if you're only pinging them for that one thing. I tend to think, are they thinking very high level and meta, also maybe when they think, when they see a PR, whatever it is, are they thinking of the greater whole or vision of the project, instead of just I wanna get this finished. 'Cause someone that makes a PR that they just want it to be in there, they might not be thinking, how does this relate to everything else.

[21:14] **Henry**: The maintainer is like, "I've seen every other PR that's related to this, I'll even do the research to figure out like, how does this affect X, Y, Z, or even not the project itself, but projects outside of it," thinking way bigger than people can even perceive maybe. I think that might be helpful.

[21:36] **Nadia**: Yeah, I think that's useful. The idea that you're someone who's seeing the big picture or sort of connecting the dots between different parts of the project, or can just sort of like hold that entire vision and all its tradeoffs in your head.

[21:55] **Henry**: Yeah, which is really hard to do (laughs).

[21:57] **Nadia**: (Laughs) I'm trying to do that in my head right now. And I think the reason I think we're talking about this is just the idea that, at least I feel like there's sort of been this historical.. in the early days of source there was very much this focus on a BDFL, benevolent dictator for life, and the maintainer was the authority, and then there was kind of this swing in a different direction more recently around going very far to the other side of being super sort of welcoming, and bringing everyone in. Everyone can participate however they wanna participate. And I'm struggling to find that like happy medium between the two, because there are tradeoffs on both, right?

[22:37] **Nadia**: When you're too authoritarian, then people are unhappy (laughs). They don't enjoy working on the project, everyone's in this very, difficult situation where it's just like not at all democratic. But then if you go too far on the other side, you find that it becomes really overwhelming to cater to the needs to lots of people who might not necessarily be that committed.

[22:58] **Nadia**: And yeah, trying to find that line between keeping the doors open, but also requiring some level of commitment, and that's why I'm sort of feeling more recently in favor of, can you draw a line around what a maintainer is a little more narrowly. To say if you're a maintainer, you are committed to this level. We don't want you to say you're a maintainer and then you just leave the project and don't even think twice about it next week. Then how can I rely on you?

[23:30] **Henry**: Right. Maybe that's a good word, relying on people. Expecting that they're going to show up again. And even when they're not, 'cause it's not like every day doing open source you're really excited or happy about it, same with going to church. Not every day you're feeling like devoted or whatever.

[23:48] **Henry**: I think I've said this before, but I went to a prayer meeting yesterday and I was talking to my roommate, and he was like, "Oh, wow you're so devoted for going to church on Wednesday." And I'm like, it's not because I'm devoted that I'm going. It's 'cause going will make me more devoted as well. Same with open source. Continuing to do it will make me continue to want to do it. 'Cause, if I already believe that it's good..

#### Maintainer Therapy

[24:14] **Nadia**: I think we talk about how maintainers serve contributors a lot. But I'm also curious to learn how do maintainers serve each other in that way. How do you sort of like show up for, if you have other maintainers, how do you show up for those other maintainers and how do you motivate each other or make each other, strengthen each other's commitment?

[24:40] **Henry**: Yeah, I feel like in personal experience with Babel, it's different then with church. Well we can tell when people aren't like involved as much, and you try to encourage them on like, how they're dealing with stuff in their life, and maybe it's a little more like, "Hey, I appreciate what you're doing," that kind of thing.

[24:58] **Henry**: But it's still not as personalized as it is in church. It's like, I'm not like doing video calls with people all the time on how's it going. I mean, maybe I'd like to, I don't know if they'd want to do that (laughs).

[25:09] **Henry**: Then with church it's like, you know, we have whether it's this prayer meeting, or on Friday nights I have Bible study, at the end we talk about what's going on in your life, and you're sharing, being able to talk about the issues that you're dealing with.

[25:28] **Henry**: And even with open source, we have like the "maintainers" repo, but that's just a repo. And maybe you don't really know everyone that well. And having events, I forgot the name of the event, like Maintainerati or those kind of things. I think those could be, I haven't been to any of them, but those seem pretty useful. So just be able to be with people that are maybe dealing with the same issues.

[25:57] **Nadia**: Yeah, within projects too, right. There's so many maintainers I've talked to who've like never met their fellow maintainers, which I just think is really funny. It's just like internet friends.

[26:13] **Henry**: Yeah that just happened to me, right. Like I went to San Francisco, like a month ago? And I finally met like Sebastian, who's the creator of the project. And it's been, I don't know, like three years or something, so.

#### Building Trust Through Professionalism

[26:25] **Nadia**: I guess, then I wonder where does the trust come from? You do have to trust each other when you have fellow maintainers that.. everyone's gonna be showing up and doing the work that they said they would do, and they're not just gonna totally disappear on you, and I think that's much easier when you have in-person contacts. You're at the same church or something, you're seeing each other face to face. And you're seeing each other regularly.

[26:52] **Nadia**: Do you think that motivation just more internal and assumed with open source, that if you put in this much work already, then I feel like I can trust you. Or does the trust come from within, like a shared bond between people?

[27:09] **Henry**: You know, I think maybe it's both. But maybe you can't really expect that much out of them, either. Mybe you don't know them that well, and you just trust because they've done all this work before. If you don't have that personal relationship it's gonna be hard to really understand what's going on with anyone.

[27:28] **Henry**: Or maybe you almost feel weird. Maybe I shouldn't learn that much about who they are. And a lot of people think open source is just about code. But especially as a maintainer, if you're gonna have a team of people, whether you're a company and you learn about what's going on in people's lives, you're probably gonna do that too in open source.

[27:50] **Nadia**: Not gonna lie, I've found that kind of oddly refreshing. And I guess the flip side is maybe you just don't know someone and that's a problem. But, I've been thinking about this in relation to work in general. And I've worked in different environments, had different managers where in some settings you're just super super candid with each other, you know everything about each other, you're just like close personal friends on top of working together.

[28:20] **Nadia**: And then there's like another style that's much more like (laughs), you show up, you do your work, you talk to each other, and there is a sense of like camaraderie and trust, but you don't really go like super deep into each other's personal lives and whatever. And I've actually found that I think I prefer the latter. Not to the point that there is this medium where it's.. it's not like you're so not connected that you don't even really like each other, or this person means nothing to you.

[28:45] **Nadia**: But I do like the sense that there's, I guess some level of, I hate to use this term, but I can't think of a better term, professionalism, that when you show up, you're kind of there to do the thing that is bonding you together. Which might be this shared work. But when it becomes too personal, then I just feel like it can kind of kind of muddy the mission or the purpose. You can't really separate out work from personal anymore.

[29:09] **Nadia**: I definitely noticed that working with people in open source. I don't work on open source projects in the same way, so obviously maybe it's just different, and I am just more of an outsider. But something I notice that I like about spending time with open source folks versus, I don't know, even just like the tech industry, being in San Francisco where I am now. It is a little more depersonalized, but it doesn't feel any less close. I feel like there are a lot of people that I really like and trust and enjoy spending time with, but I really don't know anything about their personal lives and they don't know anything about mine, and I'm kind of okay with that. I just feel like it just makes it easier to focus on the stuff that we do care about and we do share.

[29:51] **Henry**: Yeah, work doesn't have to be family, or same with open source. It works that way.

[29:58] **Nadia**: Yeah, and you can still build a lot of trust. You could still be in the trenches together and work on something really meaningful together. It's not that there isn't any level of trust or commitment, but it happens somehow without the overly personal touch.

#### Church as a Hospital

[30:16] **Nadia**: Do you feel that way about church stuff? Is church like family, or is church like church?

[30:24] **Henry**: Yeah, maybe that's something that's different about it then. Because I feel like if church was just work or just like a structure, it's almost like, what are we doing, what is the purpose?

[30:37] **Henry**: I guess the purpose in open source and other things is to make a good product, but with church how do you increase your faith in God together? It's such a personal thing. I don't see how it would even work without being able to share what's going on.

[30:53] **Henry**: Because most of the struggle with faith is about what happens in your life and how you deal with that. And if you don't share any of that, everything is going to be vague. The only way we can really solve these issues is being specific about what's going on and being vulnerable. Doing all those things is hard because you don't wanna talk about what's wrong with your life or what's wrong with you even.

[31:22] **Henry**: So that's the weird part. Because it's like in tech, we don't really wanna do that. We don't even wanna be perceived as being wrong. But then in church, some people like to say it's like a hospital. It's like for people that know that they need help, and that people are there to help each other. But yeah, I can understand why that also is the reason why people don't wanna go. 'Cause it's like, I don't wanna talk about those things.

[31:50] **Nadia**: I'm trying to think.. hearing that is clarifying my own thinking of it. In that, I think vulnerability is good and should be encouraged because that's how you build trust. I think the difference that I was trying to identify earlier is.. we're all trying to show up and bring our best selves, and best self doesn't mean my most perfect, put together self, but we're all trying to be constructive in the work that we're doing. And doing things with the group in mind, versus sort of making it all about like, 'cause everyone has problems, right?

[32:39] **Nadia**: But how do I know how to respect your journey while also going through my own. And I know, I brought this up last time too, because I'm not religious, I guess my workout community is the closest thing I have to church, which is sad but true. But what I really like about that community is everyone's trying to improve themselves, everyone's trying to become their own personal best,

[33:05] **Nadia**: but there's also kind of a respect that we're all trying to do that at the same time, and we're there together. There's camaraderie that we're all trying to get there, but I'm not gonna spend half an hour talking to my other workout buddy about (laughs) how hard it is, or (laughs) how this is so difficult, 'cause I know that they're going through the exact same thing. And if something hurts or is difficult, I will say something, but we're sort of sharing that moment without having to derail the conversation or derail the focus of the group. Does that make any sense?

[33:36] **Henry**: No, it definitely makes sense. Yeah.

[33:40] **Nadia**: Yeah. I think that's a nice thing about church being a place where you can bring your truest self, or your problems or whatever. But, but you're all kind of there, focused on something greater than just yourself, which I think is the nice thing about God being part of that conversation.

[34:02] **Henry**: Yeah, 'cause it, it's, and also that you know, it's not just, maybe we're all feeling that we can't do anything, but it's kind of the whole point, where it's not you internally figuring it all out. But you're learning something about who you are and all that stuff. So, it's way more encouraging than just like, oh, it's gonna work out. It's like where is the specifics and where is it all going?

[34:28] **Nadia**: Yeah.

[34:30] **Nadia**: Thanks for listening. If you'd like to continue the conversation, you can find us on Twitter at [@left_pad](https://twitter.com/left_pad) or [@nayafia](https://twitter.com/nayafia) or on our website [hopeinsource.com](https://hopeinsource.com).
