---
title: "09: Liturgy"
season: 1
date: "2018-10-16"
time: "32"
description: How do our rituals shape us? We talk about where habits come from, why we use them, and whether they strengthen our belief systems.
episodeLink: "0ac2c89d"
embedUrl: https://share.transistor.fm/e/a77b8490
sidebar:
    order: 9
---

### Links

- Liturgy: https://en.wikipedia.org/wiki/Liturgy
- Approaching God through negation: https://en.wikipedia.org/wiki/Apophatic_theology
- Communion: https://en.wikipedia.org/wiki/Eucharist
- The Medium is the Message: https://en.wikipedia.org/wiki/The_medium_is_the_message
- Liturgy of the Ordinary: https://www.amazon.com/Liturgy-Ordinary-Sacred-Practices-Everyday/dp/0830846239
- You Are What You Love: https://www.amazon.com/You-Are-What-Love-Spiritual/dp/158743380X

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-1/liturgy.md)

[00:00] **Henry**: All right. In this episode, we're going to be discussing ritual and liturgy and maybe the role that that has in faith and open source.

[00:09] **Nadia**: Okay. I still don't really know what [liturgy](https://en.wikipedia.org/wiki/Liturgy) is, so we should talk about what that is first.

[00:15] **Henry**: So I think we've (laughing) chatted about it before, but I think one way of thinking about it- well it's- it's used in a religious context and so it's like practices or habits or things that uh you engage in as a group of people, um that uh- I don't know. I guess they could say like bringing you closer to God or something like that. But you can apply it more generally to be more just things that you do as a community that bring you towards like the goals or visions that you have of that group.

[00:47] **Nadia**: So what's the difference between liturgy and rituals?

[00:52] **Henry**: Oh, I think they're basically synonymous.

[00:55] **Nadia**: Okay. Liturgy's a cooler word.

[00:57] **Henry**: Yeah. I think you know one maybe distinction might be that, not that it has to be as a community, but you know, you can have your own individual rituals and liturgies but I think there's something to be said about doing it together in a group. So I say like worship or communally worshipping has its own like benefits. And so I guess the first thing we can talk about is like why we do these things in the first place, um, yeah?

[01:25] **Nadia**: Oh, I was- yeah. I have a thought on that, no doubt I meant something else. So I went to this like dinner conversation thing with this game developer yesterday who was talking about religion as- and sort of like religious- I don't know. We just got into like a big long conversation about religion, 'cause I guess the game he made is related to religion, and one of the interesting things we were talking about um as it relates to both religion and like the research creative process um, 'cause it was a group of research people, was this feeling that like for some people in religion, they are seeking an answer? So he had this like image of like a labyrinth and like you're kinda going around this labyrinth and eventually you get to the middle and you've like found the answer.

[02:07] **Nadia**: He's like, "For other people what's really exciting about religion is that you get- you go through this labyrinth, and inside the middle labyrinth is another labyrinth is another labyrinth," or whatever, so like goes on into infinity. Um, that you mean that like, yeah, for some people they're very intrigued by religion as a thing that can never be fully understood and that's like, I guess codified to some philosophy he was talking about of people who like only- can only [define God by what it is not](https://en.wikipedia.org/wiki/Apophatic_theology) and not what God um- that idea of just being like, you can kind of like, if you can ever really define God then you've like confined God into reality? But you are always kind of like seeking this like infinite, ineffable thing. Which really resonated with me, both in terms of like spirituality but also um in terms of like my day to day work.

[02:56] **Nadia**: So anyway, I was thinking about that in relation to, well then like given that you're on this like very long, uncertain process and you like never know what the answer is going to be and there's no endpoint and that's kind of the point of religion, is that you're not supposed to ever be able to find an endpoint, at least in the way that I like to think about it, I was thinking about the role of liturgy and rituals and habits as a- and the act of doing that collectively with other people, as a way to sort of like ground yourself in reality or find something concrete in a world that is inherently not at all concrete. Does that make sense or am I like totally stretching the logic here?

[03:37] **Henry**: Um, no. (laughs) Not at all.

[03:40] **Nadia**: Like you're in this process that is like ongoing forever and ever and like it may never end so like the one way to like bring yourself back into the moment is to like have habits that you're doing. And then like doing those habits with other people is also like an extra way of grounding yourself, and this sense of like, you're in it with someone else. You're like walking the labyrinth with someone else besides yourself.

[04:02] **Henry**: Yeah. I totally resonate with the like, it's kind of like making what you believe or- like you're making that concrete. You're like doing something bodily instead of- 'cause you know how research or thinking about God, it's mostly intellectual, but like having a habit, it turns it into something that involves your body and with other people.

[04:24] **Nadia**: I was thinking even in like- it made me think about, is open source a pr- (laughs) the act of like maintaining an open source product or participating in community. Like there's no- there is no endpoint to it and I feel like open source gets caught in this metaphor between like is it like a job or is it like a hobby? Um and I know that like it can be useful sometimes to frame it as a job to show that like, yeah you're- you're doing all this work, but unlike a job there's- you're not getting paid and there's no like endpoint or whatever. Um but I think like a hobby, you're not really thinking about like, am I doing this for the next, you know, two to three years or something? I feel- I feel like people kinda like think that a little bit about their jobs, of like, how long am I gonna be there and whether that timeframe is long or short, you kinda have a sense of it? But I don't think people often think that um about an open source project. You're just kinda like doing it because it's what you do.

[05:18] **Nadia**: Um and maybe like religion being the same. Like you're not like, you know, how long am I gonna be a Christian for? (laughs) It's just kinda like, well I'm in it, doing it.

[05:26] **Henry**: (laughs)

[05:27] **Nadia**: And so yeah, like that, I think, maintaining open source can be like this sort of like- not even just maintaining, but participating in open source, community can be sort of like this things that goes on forever until maybe there's a moment where you're suddenly disillusioned or you just wanna kinda like move on and do something else. Um, but you don't really know when that moment is coming.

[05:47] **Henry**: Yeah, I think that's a good observation. And I guess maybe that goes back to that episode we had about [commitment](https://hopeinsource.com/membership). It's like when you're doing open source, you're not thinking like, oh, I'm only gonna commit- or work on this for like a few weeks or months. It's like, I am not really sure about what that future looks like. I'm just, right now I'm gonna work on this and even for what I'm doing now it's like, you know, in flux. And maybe it's a lifetime, maybe it's a few years, you don't know.

[06:12] **Henry**: And especially in faith, yeah, you're not going into it trying to think like, I'm gonna- unless you're starting off, you're like, "Oh, I'm gonna try this thing." Once you've committed you're like, "Okay, this is something for life." And I really like what you said about like how the pursuit of it can be like mysterious and infinite and yeah, it is interesting. I've heard that before of like people trying to define God by what He isn't? Or religion and stuff like that, it's more of a mystery? Yeah, I'm not sure, but it is interesting to think of it in that way.

[06:47] **Henry**: I guess, as a Christian, a lot of is that we- we can't really know God fully, but He- we can know Him truly, and so we do have what we need to know about Him but it's kind of like a- our whole lives can be devoted to learning more and more, like to get like deeper and deeper into who He is and who we are.

[07:14] **Nadia**: So what are like how it's- or, what do you think about liturgy and open source, or in your faith, like what are examples of things that you would do?

[07:22] **Henry**: Yeah. Um, so I mean, I guess we can just start with even like, I would say like habits in and of themselves are just, they're everywhere, right? So um it doesn't even have to be an open source or faith but like, you know, if you're trying to- you have a goal at becoming better at something. You know, maybe it's sports. So then you practice playing a certain- like soccer or something. Or if you're trying to do music or art, you're practicing drawing or playing an instrument and I think people recognize that it takes practice, it takes habit, it takes a certain level of commitment and it doesn't seem that it should be any different in spirituality or in open source.

[08:02] **Henry**: Um, it's interesting because, especially in, I guess seems like North American Christianity, there's like a- almost like an allergic reaction to this idea of ritual where the problem with habit is that we tend to think of it as a form like obedience which we don't really like, and submission, and this idea of repeating things seems very vain and like dead and lifeless because you know, you're not like- maybe you're not really into it or maybe you feel like you're earning something and it's insincere? And so I guess it's interesting to kind of push back on that and be like, well it's an opportunity for you to be involved with people and that act itself kind of changes and shapes wh- like who you are and what you think. Um ...

[08:56] **Nadia**: Is there a way to be with people without a sense of ritual or habit?

[09:00] **Henry**: Hm. I guess I would say that it's implicit or maybe you don't think about it but I think the things that we do turn into traditions. Like maybe, I think um uh, especially with like kids, once you do something two times, they want it, it turns into its own tradition. Um and- and I don't think it's any different with yeah, well what we're doing now. So an example of something in religion, so in Christianity you know, a common thing that happens at least in a worship service is we- we call it a call to confession. And so you know, during a service um, whoever's up there will ask the whole congregation, all the people there, to kind of confess their sins to God, and then after that there's also this thing called an [assurance of pardon](http://www.citieschurch.com/journal/why-the-assurance-of-pardon).

[09:55] **Henry**: And so it's an opportunity for everyone there to kind of think about what's been going on that week or things that they've done that they shouldn't do or things they haven't done that they should do and just reflect upon that, because it's like kind of throughout the week, maybe you just don't have an opportunity to do that, or you're just so busy you can't? And I think it's like a space, it's a time where everyone can like basically act the same where like, we're not saying that we're better than anyone. Um and then after that of course there's, you know, simply just saying that I did all this bad stuff, you know, maybe you feel guilty. Um you know, after that is the assurance of pardon, that God forgives um what you've done, and I think after that it's a sense that, you know, forgiveness is possible. Um and doing that every week or in the, you know, that kind of sense is important to your spirituality.

[10:56] **Nadia**: So I don't know how to phrase this. Um, I'll think about it but at what point do- can rituals become almost like counter productive, in the sense of like- as someone who's not a practicing Christian um, I think I've felt pretty skeptical of the idea of a regular confession practice because it seems like I should- because I worry that it could become an excuse to just do things and then ask for forgiveness?

[11:30] **Henry**: Oh.

[11:30] **Nadia**: And so I guess I'm just thinking, more generally beyond that of um what happens when habits start out as a sort of like comforting thing that you do to ground yourself or make, you know, the undefinable feel real, uh but at some point become counterproductive in some shape or form. And even open source, I was thinking about like, and I know like some maintainers who are like stressed out about the- maybe like community or governance aspects or just something contentious and they'll kind of like just merge small pull requests to feel better about themselves which is like a nice thing to do. Or I guess even beyond faith or open source you know, you don't feel like doing your big work project so instead you like do your email or something like that. Maybe I'm stretching the metaphor a little bit far here but yeah.

[12:21] **Nadia**: I guess like, sometimes habit, the feeling of a habit or being in a ritual can feel comforting but then um at what point does it feel like maybe, yeah, maybe you're- it does- it does start to feel like dead or fake or something like that?

[12:39] **Henry**: Yeah that's really good and even what you said, I literally did that and I think at my first talk I said that (laughs) I did that, where I was so scared of like doing like what I should be doing that I decided instead [I'll just do the easy things](https://hzoo.github.io/maintaining-an-oss-project/assets/player/KeynoteDHTMLPlayer.html#28) just so I could like feel like I'm doing something. I guess it kind of feels like a, like a throwing out the baby with the bathwater kinda thing, where like we under- I think most of us understand that habits can lead to like the sense of just doing- you're going through the motions kind of thing and that that is bad and it feels insincere. But I don't think it should make us turn away from engaging in habits, just because it can turn badly. It's like we should learn how to embrace them in a way that helps us.

[13:35] **Henry**: I think maybe it's discovering that, whether or not we believe that, we are engaging in habits anyway and so it makes more- it makes sense to me that we should intentionally um be aware of the habits that we have and then create or um engage in habits that shape us in- in ways that we want to be, or the people that we want to become. Um and maybe- oh, sorry.

[14:05] **Nadia**: I guess, my question's more like in terms of like heuristics, like how would you know that a habit that maybe started out great is not actually beneficial?

[14:13] **Henry**: Hm. Yeah, I think that, yeah, that takes um ... I guess it simply just takes reflection and looking back on like why you're doing this habit in the first place, um and maybe doing it in community will help because people can keep you accountable. They're like, "Hey, I noticed that ..." Or, you know, sometimes it's, maybe it's obvious to other people that you're just going because, just because. I think another part of it is we have this sense that, oh, bad- uh habits are truly about obedience and kind of this thing that we do from the bottom up, that it has to come out of us, and that means that is a sense of like effort and duty. And I think, especially in the faith context, that we should think about, you know, our worship and our liturgy in a top down kinda thing. And so what we can say there is like, um God is giving us these practices so that we are shaped into His image.

[15:17] **Henry**: In a similar way, for any habit we have to believe that those things actually, if they're forming us and shaping us then it's not just expressive where we're like the primary actor, but we're being acted upon. We're being shaped and formed. And so if we think- otherwise it- it is a form of like what am I doing, and having to feel like, you know. It's almost like a sense of control in that way and I think learning to kind of let go and being okay with um, you know, if the outcome isn't what you thought of, that you continue to stay committed to that. Um 'cause like I guess I'm saying that the habit itself helps you believe what you wanna believe. Like, the act of doing it. If that makes sense.

[16:09] **Nadia**: Mmm, say more.

[16:13] **Henry**: Yeah, so instead of believing our way to becoming good people and just thinking through it, or thinking like ... we do habits because they, doing them helps us to do something, and I guess it's just an admission that you can't think your way to being a good person, or think your way to accomplishing these things. You have to do them, and so I think the act of going through that habit will make you like want to do it more.

[16:49] **Henry**: So like in open source, you know, we have this initial motivation to contribute for that reason, but the only way that's sustained is if you're continuing to do it. And so I think, through the practice of doing open source I learned to love it more. If it was just me thinking about it I don't- or maybe there's something different about just, like if you told someone about doing open source versus them actually engaging in it, or telling people about Christianity but then them not actually being there in that worship service.

[17:23] **Nadia**: Okay, yeah. I think- so from everything that you just said, I think I have a similar takeaway but a slightly different way of phrasing it. Um, which is that, yeah, habits can't- or rituals or just even like culture, like it's not something you can really think your way into so it's not bottom up in- in the sense, bottom up meaning like it originates in my individual desire and then I like decide to do it. But I also don't think it's necessarily top down and I think this is maybe just a difference in like spiritual beliefs or philosophies where I don't- I guess I just don't really believe there is a top down, but more that like, if God is something that is within everyone then it's more of like a truth that is held self-evident. Um and yeah like, God or like a higher authority or whatever is something that we've all sort of like collectively created through our actions. Like it's almost like (laughs) - it's almost like an efficient market or something where like- yeah, like a market based God.

[18:34] **Nadia**: That's a heretical, odd statement to make, but um yeah. Just the idea that like we've all sort of like collectively created it. Maybe like software is a better example of this (laughs) of this like, yeah, the code base is the collection of all the different contributions, but it's not that like the maintainer decided to make it, and it's also not one contributor decided to make it. Um, I think the distinction is important for me because my fear of a top- any sort of top down is that like a bottom up individual can leverage the idea of top down to say, well, I'm the ultimate authority here, which I think we've talked about in the [authority](/authority) episode. So I want it to be this sort of like, I guess more decentralized self evident behavior where no one can say, I am the one. Like we do this habit because God said so, but really it's that I personally kind of said so and I'm just like picking and choosing.

[19:32] **Nadia**: But if enough people buy into the concept then- if enough people are doing the thing because they all find it valuable and it all brings them together then like that's really the answer. Is like, do enough people want to do it besides yourself and besides any other one individual?

[19:46] **Henry**: Yeah. I mean I can see top down that way, not that it means that literally it's top down, but just that it's not just you, right? It's what you said, like it's shared between multiple people.

[19:58] **Nadia**: Yeah. My definition.

[20:03] **Henry**: Yeah so thinking about it in open source is kind of just asking the question, like what are we engaging in, what, like what behaviors and, what does that, what kind of people are we inviting in, and like what kind of people are we turning into based on what habits that we have? I don't know- I haven't really thought that much about that, like in terms of open source, other then just things that I've seen in terms of how we like use GitHub and stuff like that and that would be like, you know, how we have to- you know, we use GitHub for identifications and Twitter for communication, and like how that changes um how we interact with people.

[20:50] **Nadia**: Is that a form of liturgy? Like, the norms around communication?

[20:52] **Henry**: Yeah, I think. I mean not that- maybe it seems like I'm looking into it but it's kind of like the phrase, ["The medium is the message."](https://en.wikipedia.org/wiki/The_medium_is_the_message) Um and what that's saying is that it's not just the actual message itself that you're communicating but the way that you're doing it, the environment that you're doing it in, shapes the community and shapes what you do. And in terms of like notifications and Twitter, it's um, you know it's in synchronous, it's instantaneous you're always online and it's like those kinds of qualities, what does that lead to? And I think when we talk about expectations, it leads to like people expecting maintainers to respond immediately or that you're always there available to talk to people and it's like, is that something that we want to encourage?

[21:44] **Henry**: And, there's no practice that we have that encourages the opposite, which is like rest. And this is- maybe this is why it's so- why people feel so guilty about taking breaks, and it's like, maybe we should make that a quote unquote ritual. Like what does that mean, to like be-, so that people will feel like it's normal to not be there.

[22:09] **Nadia**: Okay. To the point of our- the conversation we just had, how would you start a new shared habit, and then kinda like more importantly, how do you know that the habit you personally want is a good habit if, I guess like, my takeaway from the conversation we just had was that habits don't start from the bottom up. Wherever else they start is fine but they don't start from like within. You can't just like decide to do a thing. It kinda is like a thing people are either doing or not doing. Um and so people are just not doing a habit of rest, then how- like how would you start that and how would you also know that, just to play kind of obnoxious devil's advocate, like how would you even know that's a good habit?

[22:56] **Henry**: Since we're talking about rest, I don't think it's that hard to argue for that, right? (laughs) Um it's not that different from our work culture in the Western world, right? It's like all about ... and I think that's more just like I realized that we've absorbed certain practices from that and it's kind of in open source as well, and so when I think about like- well in the church it's like, if you go and you're not like, you're not feeling it that day but you go anyway and they're asking you to pray and you're not ... I mean, you can just be silent but then you realize the church is praying for you. They're singing for you, they're worshiping for you and it's, when you're there, you realize that, you know, I can just be here and listen and be a part of this community and that's like, in that sense, that's also taking a break too. That it's okay if you're not feeling that day.

[23:53] **Henry**: And so in open source, well maybe you're sick or you know, you wanna go on vacation but then you feel like this pressure um ... I don't know what it means to like literally just ... I don't think you can just say like, hey. We're gonna suddenly start doing this. And maybe it is like uh um, it's like something you decide to do individually and it turns into like, oh, like I notice that people are doing this. Maybe we should turn this into a quote unquote habit. But I don't know if it has to necessarily be like oh, this is like a rule now 'cause that, maybe it just could- it can be natural too.

[24:31] **Nadia**: What's the relationships between habits and values? 'Cause I was thinking like, well the value- this- like- most communities, I hope, would value like rest or like, you know, "don't overexert yourself" (laughs). Um and so maybe it's like, habits are derived from values, but then ...

[24:45] **Henry**: Mm-hmm (affirmative).

[24:46] **Nadia**: ... where are values derived from?

[24:48] **Henry**: Yeah, so I would even say that like a liturgy or habit is- it's a practice that helps you embody the value you believe in. So, or it turns you into the person that you wanna be or what you desire and so I think the habits themselves are the way that those values play out in our lives.

[25:17] **Nadia**: Yeah, it's like the execution arm. (laughs)

[25:18] **Henry**: Yeah, and so in terms of like religion it's like, we have our faith um and then the way we express that faith is through like what we do in our works. Um and so that relationship is weird because you know, we need both and same with like our habits and knowledge. We need to know things but we have to act them out to actually show that that's what we believe. Um but it's really easy for either you to kind of only get into this knowledge mode, where everything is head knowledge, which is necessary, but then also you don't live it out. Or all you do is just do it and then you don't even realize why you're doing it in the first place. So I think it's kind of this merging of the two.

[26:03] **Henry**: Yeah. Um so I'll give you an example in faith. And so one of the, I guess, rituals that Christians practice is called [communion](<https://en.wikipedia.org/wiki/Communion_(religion)>). Um people think of it- another word for it is the [Lord's Supper](https://en.wikipedia.org/wiki/Eucharist). And in that practice uh the congregation comes together, you know, it could be weekly or maybe even monthly or once a year depending on how they do it, and you come together and you share the bread and the wine. And so you literally and I think some people what they do is they take one loaf of bread and then they break it off and they give to everyone. And it's supposed to represent uh Jesus' body and his blood. Um and so all- like, it's just like, you know, this ordinary piece of bread or this ordinary ... like people are eating together.

[26:52] **Henry**: But all those things kind of point back to remembering of what he did, and so even the idea of splitting a loaf of bread is interesting because that is instilling a sense of like unity and community, where we're not just doing this as one people, but we're taking from the one piece of bread. And so when we call the church like a [Body of Christ](https://en.wikipedia.org/wiki/Body_of_Christ), we're doing it as one body. Um and I think that's good 'cause that kind of pushes against the values of individualism in our society, where we wanna stay as individuals but we're also connected together. Um and, you know, it's- and then also because it's a habit, it's- the whole point of a habit is to like bring us closer to our values, and especially in communion it's like, hey, Jesus said [do this and remember this with me](https://www.biblegateway.com/passage/?search=Luke+22%3A19&version=NIV), then we're supposed to use that to reflect back on what Christ's sacrifice was.

[27:53] **Henry**: And so it's not just like some thing that we do, but that thing should remind us of the uh the historical or previous things that happened, um and it's like a way of tying your head knowledge with like something that you actually do with your body. Um and then you can start questioning yourself. You're like, you know, are we actually united as one body as we do this practice? Uh do I actually believe what this is saying? Um, so it's not just uh doing it.

[28:23] **Nadia**: It sort of strikes me that the role of a lot of rituals is to specifically kind of get out your individual brain and give yourself over to like a group or just a collective mindset. Um and I guess I hadn't thought of the ritual of communion as really being like, almost like a literal form of that, um where you're like giving your body over. I kinda like it. I like the idea that like we have ... I mean, I just, I feel like collective thinking can get a bad rep?

[28:52] **Henry**: Mm-hmm (affirmative).

[28:52] **Nadia**: But I think there is value in doing it in this sort of like ritualistic, intentional way, to say ... I mean I was thinking even just in like other religions where there might not be as defined of an authority or something like that but there's still this idea that you're giving yourself over to oneness or to something greater than yourself or whatever, and I feel like that's often the role of religion, is to just kinda get you out of your head in general (laughs) and feel connected to something bigger than yourself.

[29:24] **Nadia**: Um, and yeah. I think like we have to balance both, like an individual and a collective mindset, but a collective mindset is how we actually get things done in the world, by learning how to like coordinate and work together, um and so there is something valuable to remembering that it's not just all about you and it is about like what you're doing with other people.

[29:45] **Henry**: Yeah I think it's, throughout the week, in everything that we do I think most of the rituals in society and like the habits that we have enforce this idea of that we are the most important person, that it's about us. And I think it's- that's why it's so important for us to have those habits. 'Cause if I didn't have those, everything's telling me that it is about me, though. Even this like ... otherwise that religion is basically consumerism and that is just marketing, right? Like everything is trying to sell me something. It's telling me that, you know, if I buy this my life will be better or that X, Y, Z like about my life will be better and in that sense it's interesting to think of like all these things as quote unquote liturgies, and that things that we think are kind of like neutral? It's just like a product or something. But the whole point of marketing is to get you to feel this thing that like, you know, this is important to your flourishing or your thriving in the world and in that sense it's kind of religious in that way. It's pointing you to something bigger and it just happens to be it's through paying for this stuff.

[30:58] **Nadia**: Mm-hmm (affirmative). Yeah. I don't think one is necessarily good or bad. I mean, at the extremes, both sides kinda such (laughs) um but yeah, I mean the role of an individual as an agent is to sorta like help push the group into a certain direction, and I think like that's a really important role to have. Um, like a sense of agency is really important because if you're- if you completely give yourself over to collective mindset then you have no sense of agency and that's not good. And then if you're- but if you give yourself over completely to the idea of individual agency um, like it's- it's actually just really lonely. Like I don't even think there's ... like I just think inherently, most people would agree that feeling super, super on your own with like not tethered to anything whatsoever is like a pretty lonely, depressing state to be in.

[31:48] **Nadia**: So um yeah, like when I think about the role of giving yourself to a group mindset, I think it's also almost even just like a comforting thing of like you're not alone. Um, yeah. Like the comfort part and then also just kinda like the coordination, efficiency kind of part of like, me too, we- when people work together like more things happen.

[32:12] **Henry**: Yeah. I think it's like freedom not because you're alone, but freedom 'cause you're in that group and you're free within that group to make those decisions that you need to do.

[32:29] **Nadia**: Thanks for listening. If you'd like to continue the conversation, you can find us on Twitter at [@left_pad](https://twitter.com/left_pad) or [@nayafia](https://twitter.com/nayafia) or on our website [hopeinsource.com](https://hopeinsource.com)
