---
title: "04: Holy Inefficiency"
season: 1
date: "2018-10-16"
time: "37"
description: Can everything that matters be measured? We talk about measuring the output and health of a community, competition between groups, growing a community without losing authenticity, and embracing "holy inefficiency".
episodeLink: "87edfd5f"
embedUrl: https://share.transistor.fm/e/5e76ec9f
sidebar:
    order: 4
---

### Links

- Nadia's post: [Methodologies for measuring project health](https://nadia.xyz/project-health)

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-1/inefficiency.md)

#### What makes an organization healthy?

[00:00] **Henry**: Alright, so in this episode, I wanted to talk about organizational health. Nadia just wrote a post about the health of an open source project and how we measure it, whether it's by contributors, activity, or output. It just got me thinking about how we measure that in a church. What's the relationship between church growth and health, the popularity of open source projects versus health or sustainability.

[00:31] **Nadia**: It's interesting, 'cause even though I believe that we should be measuring a project's activity and output over number of contributors, it's just an easier thing to visualize when you talk about people coming to your project or leaving your project as a sign of health. We've talked about this with church stuff, of bringing people into your congregation and who's attending. How many people are there? It's such an easy visual to fall back on that. The stuff I was writing about was trying to make the case that number of contributors or attendees doesn't really matter. What matters more is what are you actually producing and putting out.

#### What Is a Church's Output?

[01:07] **Nadia**: Which actually relates to Call to Commitment. They purposely kept a really small congregation because they were like, "We don't need to inflate this with a bunch of fake numbers." But for church stuff, what would output even really be in a church if it's not the number of people attending?

[01:29] **Henry**: Yeah. I guess they just cared a lot about the individual people. It's all about how well are they doing, mentally or spiritually. So we don't want shallowness or just numbers, what you said. Even though it's an easy way to think about it. "Oh, as long as we have more people, that means probably more people are tithing, and that means that we're gonna sustain this thing 'cause if we don't have money then it's not gonna work anymore."

[02:08] **Henry**: But I think for output, I think it's really hard to quantify, which is why I don't know if we can use attendance. Because people can go to church every week, that doesn't mean they're any closer to God or other people.

[02:28] **Nadia**: But what is a church's output? For an open source project it's easier to make the argument and say code is ultimately your output and that's why you can measure it based on PRs or commits versus number of people contributing. What's the equivalent that a church is trying to put out if not trying to, I don't know, touch people basically?

[02:47] **Henry**: I mean, even with open source, just because we're adding more code doesn't mean... Well, I guess there's the mission of the project versus is it still going? We can make PRs all day that all they do is update dependencies and it looks like it's really active (laughs), but are people actually getting benefit from it? That's more of a measure of how useful something is. I don't know if those are conflated or it's hard to know the difference sometimes, and at church it's the same, where you would think that if there are more people coming then maybe that means that more people can serve or more people can help the community that that church is a part of.

[03:26] **Henry**: I think our output is hard, because it shouldn't be about, "Oh, people attended this much, they gave this much money," 'cause then it becomes about themselves and how is it about helping others or how are they growing in Christ? So how do we differentiate between knowing God, an academic point of view versus actually knowing him from a relational view?

[03:59] **Henry**: And so the problem is it's hard to measure. Basically it's saying how well is your relationship with your church or God or other people and that's hard to measure in any relationship, right?

#### Latest Activity (Commit) As Heuristic

[04:11] **Nadia**: Yeah, I don't know that there is a metric in that way. I was thinking with open source projects, I talked about some of this in my post of the latest commit as being this really quick heuristic. When's the last time this thing was updated? And I'm trying to think of what would the equivalent be if someone walked into a church they'd never been to before. "Oh, I know this is the place for me," but it's kind of an intangible thing, right? It just feels right or you like the vibe of it or whatever. I don't really know if it's the same.

[04:44] **Henry**: Yeah, it's almost like doing an interview for someone, like getting a job or whether you should work at that company. All I did was look at their website and now I'm gonna figure out what I want to be there from that, same as people decide whether to use a project based on so many random things, right? How many stars they have or if the last commit was an hour ago versus a month ago and in a church you just go in, then you see certain people or you heard something.

[05:16] **Henry**: But I feel like you have to spend more time to know that. To be there for the whole service, if they're talking about church.

#### Church Hopping: What's in It for Me?

[05:22] **Henry**: It's weird because, (laughs) it kinda reminds me, now there's this term that people use called "church hopping", which is a negative term of people not being willing to commit to something 'cause it doesn't fit them.

[05:42] **Henry**: And not that trying to find a fit is bad, but it's really easy for people to say, "I don't think anywhere fits me, so I'm just gonna keep going place to place," and you're never actually committed to a local body. It's kinda just, "I want to keep getting from it," versus at that point you're probably not even thinking about, "How am I gonna give back?" It's just, "I need something that makes me feel good about myself."

[06:09] **Nadia**: Is that a new behavior, church hopping?

[06:11] **Henry**: I think the term is pretty relatively recent. I'm not gonna say last years or something. It's been for a little while.

[06:20] **Nadia**: Like is it like trending towards more people doing it and if so.

[06:23] **Henry**: Especially if you're moving to a new city, but you should be diligent about finding a good church for you, maybe you go to one or two or three, but if it becomes a behavior of: this week, I'll go here and then (laughs) this week I'll go here, and you're doing that for like a whole year or something.

[06:45] **Henry**: Maybe that's normal and I don't think it that's healthy, right? 'Cause that means that everyone is kinda loosely connected, and we're trying to find deeper connections with each other, the church, or open source project, and I think the symptom is this consumerist mentality, like joining a club, buying something, or going to the mall, those kind of ideas. And that kind of almost got caught up in the church where people are, "I do these things in my rest my life like this, and so at church I'm gonna do the same thing." Go here and there.

[07:24] **Nadia**: Yeah, I mean it feels like that's a thing that people are experiencing beyond church or open source, just sort of how does the world around you serve you versus how do you be a part of it or be an active participant in it? I think it's a really hard question everyone is grappling right now. We were talking about this a little bit.

#### The Internet: One Big Happy Family?

[07:44] **Nadia**: How to bring that feeling of localization or local communities to an internet context, where it feels like the early promise of the internet was that you're connected to this global community and borders are gonna break down and we're just gonna be part of this one big happy family on the internet and there's peace on earth.

[08:06] **Nadia**: And I feel like in reality we're coming to this hard realization that a more localized community is actually really, really important for people to feel grounded and some shape or form and you can't just scale this thing to some massive global scale.

[08:21] **Nadia**: Yeah. It's interesting that people are church hopping 'cause I feel like church would be an example of something where people could feel a little bit more localized. It makes sense in an open source context just because you're using so many more projects than you did before and so many more choices. I feel like GitHub in particular has just made it so easy to hop around from one product to another, that I think that's some of the conflict between
earlier open source and now.

#### On Losing a Coherent Story with Growth

[08:52] **Nadia**: The earlier ones had smaller groups of developers that knew each other better and had more context for each other and now you can just use things or hop in, say something, and go onto the next project. But I don't know if it's realistic for open source at least to expect that people will find a community to settle into, that might just be the way it is.

[09:18] **Henry**: Yeah, I guess that's different. I wouldn't expect someone to be committed to multiple churches, that seems kind of counterintuitive or just doesn't make sense, but open source... I'm a maintainer of multiple projects or you're a contributor to multiple projects and then also those projects are related to each other and not every project is a huge thing that you have to spend all your time in, right? You could have smaller..

[09:43] **Nadia**: And there's a meta-community maybe there, right? You're part of a JavaScript community within JavaScript.

[09:48] **Nadia**: There's other smaller subcultures. I was musing with someone about this with open source in general. Sort of why has earlier open source kinda had this coherent sense of what open source was and now there aren't that many people thinking about open source on a meta level. You see this actually with open source conferences. Conferences that are just about open source in general are kind of declining in popularity because people are going to conferences that are about a specific ecosystem or language or framework or whatever.

[10:25] **Nadia**: And so yeah, I feel like open source has become so popular now that it's become just so much more nuanced. There isn't a giant open source community, 'cause well everything is open source. But now you have these smaller things. But then there are some behaviors that are pervasive across open source, like around community management or project management, things like that and no one is really thinking about it because no one really affiliates with it anymore, you have open source in general. Even though that's probably a good thing long-term.

[10:59] **Henry**: Yeah, I think that's really interesting. When something, not splits up, but it gets so big that there are subgroups, they kind of focus on their own thing because they have different goals. But then there are also people that want to bring that back, that we can all learn from each other. With church it's the same, each church is its own little community, and it should be local.

#### McDonaldization of Church

[11:38] **Henry**: I don't think it makes sense to kind of have the same "message" to every church. Like it is the same, we all have the same values or goals or whatever, but then the way you present that to people has to be local. I was reading this tweet from James K.A. Smith. Say you have a pastor who's preaching, he doesn't give a generic message to the person. Basically 'cause then I would assume that you don't even have to be there. You could do a livestream sermon online, anyone in the world can listen to you.

[12:12] **Henry**: But that person should know all the people in their congregation what they're dealing with. Who are these people, where are they at, what time period is this in? And so that's super highly contextal, right? All those things matter in what you're trying to say to people versus some generic saying ... I think he mentioned, we don't wanna turn church into this McDonald's franchise where anywhere you go it's the same thing. It all roots back to the same overall goal, but then specifically it needs to cater to those people that are there.

[13:01] **Nadia**: Hmm. It's a hard balance. 'Cause I think, I don't know, there are some benefits to feeling like you can be home wherever you are. There's something I really like about having internet friends (laughs) where, I've been traveling a bunch this month, any city I go to, I know people there and I can always feel kind of at home. My social group is bigger than just the physical city I live in.

[13:25] **Nadia**: But at the same time, I know that going back to San Francisco is going home and that's a really nice thing. I wasn't raised in a very... well, I don't know if that's true. I guess it's sort of baffled me a little bit with Christianity, you can identify as a Christian, but you also identify with your denomination.

#### Balancing Local and Global Affiliation

[13:46] **Nadia**: You also might identify with your church and so you do have these multiple layers of community. So I went to Quaker high school and I've gone to Quaker meetings in other cities, in other countries and it's nice to do 'cause I can find a meeting for worship in some other country, but it's not the same at all.

[14:09] **Nadia**: I think maybe because people practice Quakerism in very different ways around the world, but it's also not your people. In particular, in Quakerism, meeting for worship, at least the way that I did it in Pennsylvania, you sit in silence and you only stand when you're moved to speak and there's no pastor, no program or anything.

[14:35] **Nadia**: Everyone is basically meditating in silence for an hour, and you just stand, you reflect on something and then you sit back down, and it makes it a very intimate thing that you're doing with other people in your community 'cause if someone stands and speaks you're like, "Oh, I know that person. I know why they're thinking about the thing they're thinking about," but if you're in another country and some random person stands up and reflects on their week, you're just kinda like, "I don't really know." I mean it's nice to hear, but it's just not the same.

[15:00] **Nadia**: But at the same time I still feel an affiliation if I went to another country and I'm like, "Oh, you're Quaker, I know Quakers." I don't know where you always draw that dividing line between, how do we share the same affiliation in one way, but in other ways I know that we're not really the same community.

[15:17] **Henry**: Yeah those are good points. I think that's the benefit of a denomination or something like that structure. Maybe there's a network of churches that you're part of and when you do travel you can kind of vaguely know that they either believe the same things or do service in the same way and that's that's good. I guess it's just saying that it shouldn't literally be the same everywhere.

[15:48] **Henry**: And what you said, people that you actually know versus just some random anonymous person.

[15:58] **Nadia**: Yeah, it's not literally (laughs) the same friends or something in every city, but its own flavor wherever you go. I feel like it's such a hard balance to achieve 'cause there is some values to an universality of experience, but you don't want it to be so universal that it doesn't even feel special.

[16:15] **Henry**: I think the word we use is ecumenical.

[16:19] **Nadia**: What does that mean?

[16:20] **Henry**: There's also like catholic and so there's differentiating between Catholic like the Catholic Church versus catholic, which is more universal. The idea that we should even if we have different maybe secondary values that we all kind of agree on the core things. We should work together.

[16:42] **Henry**: And that's important because otherwise you're kind of just isolated. There's always gonna be that conflict because some people are gonna be like, "Well, they believe this thing and we don't, so should we even engage?" Some people are more willing to engage.

[16:52] **Nadia**: We were talking about this with relation to evangelism, right? I mean you can make the same argument that in some ways all developers have some shared sense of identity because you're all software developers at the highest level. But then there's always these weird turf wars about people and the best tool to use, the best language, or whatever. They can really put down other people's choices and opinions (laughs) because they feel so strongly about whatever tool they use. That's kind of weird because it's like why would you not... I don't know. We're all kinda the same here, but then also not...

[17:36] **Henry**: Yeah, it is really interesting 'cause, whether it's programming language or tab/spaces, all that stuff, I don't know why we end up... The more you go specific or local, there's also the same opportunity for you to start pushing people away, but then it's good to know what you like and it's good to know what you believe in as well. And so there's that balance, you shouldn't let your appreciation for what you actually believe take over your level of grace that you should show people, when you're engaging and talking with people. That shouldn't go beyond that.

[18:22] **Nadia**: Yep. We can agree to disagree.

[18:25] **Henry**: Agree to disagree, yeah.

#### Narcissism of Small Differences

[18:28] **Nadia**: I wonder if it's sort of the uncanny valley. When theoretically two developers will do really, really similar stuff, they're gonna argue more violently about the very small differences than people from two totally different... there's more in-fighting between Christian denominations than there would be between-

[18:49] **Henry**: Non-Christian.

[18:50] **Nadia**: Yeah, someone totally different.

[18:52] **Henry**: Actually that's really interesting. This is kind of like church health that goes into spiritual health or spiritual formation, so how you develop into being a Christian or a disciple of Christ.

[19:10] **Henry**: And so the problem there is the same thing, it's a question of measuring and so people want to, "I go to church more than you," or they start comparing, "I'm serving more," or "I know more about Christianity," "I've been a Christian for X years," so it's about experience.

[19:31] **Henry**: Actually that's not true at all, because you could even be a pastor and in some ways you don't know Christ as much as other people, 'cause you haven't experienced it. Experiencing God is different from reading about God or spending all your time doing it. It's really hard to just think about when it's something you have to live out.

[20:03] **Henry**: Even in the Bible we talk about the Pharisees, which are people that know a lot about the Bible, they know a lot about laws, but they ended up caring so much about laws that all they would do is call out people that they didn't follow the rule, that kind of thing.

[20:20] **Henry**: This is obviously true in anything. Even now, how do we learn to kind of show that we're just like everyone else too. So when you end up knowing more than someone, you're not gonna look down on people for not knowing it, but you're gonna help them get to where they are versus only say negative things about what people are dealing with.

#### Eternal Students: On Showing vs. Telling

[20:44] **Nadia**: It kinda goes back to this idea of being an eternal student or committing yourself to the process versus being like, "I figured it out and now I'm gonna go tell everyone else what I think," which is just a good practice for humans in general (laughs).

[21:00] **Henry**: Yeah, practicing humility.

[21:02] **Henry**: Especially for spirituality, the whole point of being Christian is to say that it wasn't you and so it's funny because the more you learn, there's that, not risk, but there's a chance that if you don't actually understand that well, then you're gonna look back and be like, "I learned all this. I'm so good,". And it'll come out in those ways even through evangelism. And when you're doing evangelism and two people are talking about it and then people are like, "All you're doing is telling me that I'm bad and that you're good," and that's not the point, but it can be hard for people to like know that and understand that.

[21:47] **Nadia**: I really like what you had said to me, that you don't need to actively convince somebody, you should just be the model person that you're aspiring to, just live it out through the things that you're doing versus telling someone that they should be doing something that way. That's so much more effective I think when you're showing versus telling.

[22:14] **Henry**: Yeah, I guess I wouldn't say that telling is necessarily wrong 'cause maybe that's what that person needs, but I think that's where we would use the word discernment. You have to know that person, and in order to know that person you should actually know that person (laughs) through relationship. There's street evangelism and all that stuff, they don't know who you are, they're probably never gonna see you ever again.

[22:37] **Henry**: And maybe that is okay for those people, but for me personally, I would rather develop a relationship with someone over time. I mean it's gonna be way harder 'cause you're basically saying that for the foreseeable future you're gonna be engaging with someone, just knowing them and just helping them or whatever that it is for your whole life I guess, and that's just something you have to commit to. But you're right, it's gonna be way more effective because it shows that you actually care about them versus just saying words.

[23:13] **Nadia**: I think it also lowers these barriers around in-group, out-group thinking because if you're telling someone that means you're also sort of acknowledging that they're not the same as you. That's why I need to tell you why my way is so much better, but if it's more about developing a relationship or just sort of living your values and your principles then there's some underlying subtle thing there I think that suggests we're all kind of the same and I'm not any better than you, I'm not doing anything really, anything differently.

[23:46] **Nadia**: Yeah, this is something I've always liked about Quakerism 'cause there was just never any hard lines between who is or isn't, it was more about if everyone has God within them. I think the values in Quakersism were just very egalitarian for that reason. And that's what I like also about just the idea of being an eternal student and never really thinking of yourself as having mastered anything.

[24:17] **Henry**: Yeah. I guess even with studying Christianity, we even have colleges for studying God, there's seminary and all those things. It is a lifelong pursuit, and even being okay with reading the same thing over and over because you're gonna gain new insight from the same thing or talking about the same things over and over 'cause a lot of those problems might not go away.

[24:45] **Henry**: And I think you mentioned this in previous conversations. About how there's a certain mystery to it. And even though in our age, it's all about knowledge and science and instant wanting to know the answer, I think there's something special or interesting about not knowing and maybe never really understanding completely, but knowing it truly and that we can know, but we might not know exhaustively. I think that's really good.

#### Working in Public!

[25:19] **Nadia**: That's the value of documenting everything you're learning in public to me also 'cause, I don't know, it just seems like it almost makes it necessary to be like, if the whole point is the process and everything is a lifelong process, then it's really important that I'm documenting that process in a way that other people can learn from wherever they're at because I'm never gonna just be done and then publish a thing where I'm like, "Look, I figured it out (laughs) here it is."

[25:49] **Nadia**: I really struggle with just all the open source research that I'm doing now 'cause I think when I came in, I just felt like, "All right, the problem is really obvious," we should have just figured out an answer, but the more I dig into it the more I'm like, "Oh, that's just like really, really complicated," and in general I think with research not just mine, but just in general it's like you're kinda exploring these questions that you just don't really have answers to and you're just gonna have to keep probing at.

[26:20] **Nadia**: So if you're never gonna arrive at the answer, then it's all you can really do to show progress or to show that you are actively thinking about things is to record it, but that's also something I think I've lifted from open source and just the importance of, you don't have to make a thing, you don't have to make the best tool ever and then put it out there just along the way, just put yourself out there and publish it.

[26:45] **Henry**: Yeah, I think that goes back to what we said about how with software in general or open source it's never done. I think people forget that the maintainers are just people that are trying to improve on something, versus having a finished product. Same thing with your faith as well, it is never gonna be done, and we should look to that as a source of inspiration and versus a sense of dread.

#### Holy Inefficiency: A Pokémon Story

[27:16] **Henry**: It kinda reminds me, I heard this sermon in our church like two weeks ago, the title was actually Holy Inefficiency, which is a really interesting title. But it was just talking about in our current age it's all about information, you know notifications and overload of too much information, not too less.

[27:35] **Henry**: And so there's a rush to know everything and we kind of lost a sense of what does it mean to rest and to take breaks, to just enjoy being alive and learning things? In the process of all this efficiency and doing things with an algorithmic way, it almost feels non-human, like we're trying to into robots.

[28:05] **Henry**: And so, he used this analogy, which is really funny 'cause it works for people that are our generation (laughs). He mentioned Pokémon. So he grew up playing Pokémon. In the game, you start off by walking everywhere and the first time you encounter a Pokémon you're like, "Wow, there's a Pidgey," and you catch it. Everything that you do in the beginning is very awe inspiring or just cool.

[28:34] **Henry**: But eventually you get a bike. And after that you'll never go back to walking ever again because, "I want to get to the end." It turns into wanting to complete the game versus just having fun during the game.

[28:49] **Henry**: Every time you exit a house you'll turn on the bike button, you'd zoom off to wherever you're going. Even funnier is later, you learn the fly ability and so now you don't have to bike anywhere, you'll just fly directly to the place that you're trying to go to.

[29:05] **Henry**: And that reminds me of all the new video games where there's a fast travel mode where you can kinda teleport wherever you want. And then the game is literally is just grinding through the game. Same with life, it's like all we're doing is just trying to get to this end. And at the end of it, you feel really empty actually. You lost the sense of enjoyment and wonder of doing something that you enjoy and same with open source. So maybe it's all about how many downloads you have and how many PRs and how many contributors. And at the end you're like, "I don't even know if I want to do this anymore."

[29:44] **Nadia**: That's deep (laughs).

[29:47] **Henry**: Yeah, it's too real, that's why (laughs)-

[29:48] **Nadia**: Too real, too real. The Pokémon in particular. Is the term holy inefficiency the idea that it's almost like a holy day of rest or intentionality about being inefficient?

#### Intimacy with Martha and Mary

[29:58] **Henry**: I think there are multiple parts to it. He used this passage where it's talking about Mary and Martha, and so one of them washing the dishes basically and the other one was washing Jesus's feet. And so she was like, "Hey, why don't you help me in the kitchen 'cause we have to like get stuff done?" And the other person is just being with Jesus, like in relationship.

[30:21] **Henry**: And so his point was that, you can spend your whole life, this is for spirituality. You can go to a seminary and study about God, you can read about God, you can listen to podcasts about God, you can talk about it, all these things. And yet in the end, you might not actually know him at all, because you turned it into this kind of game where there's a number attached to it versus like washing someone's feet, that's a very like different thing from accomplishing all these things.

[30:56] **Henry**: So how do we remember what it means to know someone? And to know them, we would use the word intimacy, right? So that's something that that we should be doing. I think his point with the inefficiency part is that to be in a relationship is actually to be inefficient.

[31:16] **Henry**: You don't want to meet someone, and then only talk to them for five minutes because you're like, "Oh, I need to go on with the rest of my day." But if you like them and you want to know them more, if it's God or another person, then you're gonna wanna be inefficient, right? You wanna stay there as long as possible, you wanna just talk about whatever, maybe like what you said, in silence, you're just like there waiting.

#### Relationship Building

[31:43] **Henry**: I think one of the most important things that we can do as a Christian is to wait. I think it's really interesting because that is the opposite of what we would want to do as people, and if you don't know God, same thing. We have this urge to wanna do something 'cause we feel guilty or "If I don't do anything nothing is gonna happen." But your implying that God can't move, that he can't work in your life.

[32:14] **Henry**: And so we're called to be people that wait, on a king which is very weird metaphors to talk about, but the phrase that we would use is "awaiting the king" yeah.

[32:35] **Nadia**: Hmm. I like that. I definitely noticed that with just relationship building and with work stuff. I think maybe this is just to some extent a natural trajectory as you start to get to know more people and just feel more comfortable with the people you do and don't want to talk to, but if you just have a day filled with one hour meetings with a zillion people, it's actually pretty exhausting (laughs) in the end. And you could say by this one measure is to meet as many people as possible and you have all these meetings, but it doesn't actually feel that good in the end and you don't feel deep lasting relationships.

[33:13] **Nadia**: So now I try to be just a lot more unstructured. It means saying "no" to more people, which is I guess a tradeoff, but then also if there is someone that I'm really looking forward to getting to know or talking to, not having it feel like this has to be a one hour thing and at the end of this coffee, I need to go off and go to my other one hour thing, but instead just have it be a little bit more open, a little more unstructured.

[33:39] **Nadia**: And yeah, when you're not thinking about it as like, "Oh it's 11:59 and I need to go," (laughs) all the interesting chatter comes about more naturally when you're willing to just give it up. I mean if you asked me that a few years ago it would have been like, "Ugh, I can't, I don't have time to spend two-and-a-half hours talking to someone (laughs), I need to go do other things." And I still struggle with this a lot, but just trying to be more comfortable with the idea that, just don't look at the clock and just enjoy the person that you're spending time with, but it's harder.

#### Learning to Be (Not Do)

[34:15] **Nadia**: I was thinking about that, and a friend of mine has a friend who's known for being, as he put it, very good at resting.

[34:27] **Nadia**: And it's such a weird way to describe someone. Like he's good at resting, not in terms of meditating or doing some active thing, but just literally sitting there with his eyes closed and not doing anything, which is like a funny thing for me to imagine. But I've been trying to think about it and the stuff I do day-to-day now too, where sometimes I'll have a good couple hours where I'm getting stuff done and I can kinda wrap up my big thing and then I kinda take a little break before I do something else. Normally I think I would just go on Twitter or something or check my email or something, but now I'm just like, "I want to be good at resting too," and I'm just sitting there (laughs) and just being in the moment. It's really, really nice.

[35:09] **Nadia**: Yeah, I don't know. It's like we also have to find a reason, something you have to be doing while you're waiting or something. You have an active resting activity, but to just actually sit there and stare out the window for a little bit is like really, really nice.

[35:26] **Henry**: Yeah, that's really cool. We want to learn to push back on this sense of hustling and especially in a city like New York or San Francisco. But in the startup culture it's all about doing all this stuff, and in open source it might not be like that from other people but internally it might be like, "Oh, I need to keep moving forward."

[35:56] **Henry**: I remember when I was doing it outside of work, for some reason I always felt like it was another job to me. I have a certain expectation for how this should move forward. Even though I obviously knew that I didn't have a lot of time. I don't know why I just felt like I assumed I had like eight hours a day to do it, and that we're not getting there so I always had to push myself. So it's not bad to wanna move forward and you know professionism and all that stuff can be helpful, but when it turns into just restlessness, I think that can be really detrimental and that's why we have burnout and all that.

[36:42] **Henry**: I think what you said, learning to not do anything is good. And it really is a skill, especially in our day where if you're in line for something or you're on subway, you always have to do something, learn something, get better at something, but maybe we should get better at not doing anything.

[36:59] **Henry**: That is something to value. And I think that is expressed well, at least in Christianity, where literally God when we read about the creation story and the seventh day he rested. And if we believe that God is a powerful God that can do whatever, he still decided to rest, so it doesn't mean that he was tired. He actually rested 'cause he enjoyed it. He wanted to enjoy what he made. There's a sense of pride that he had in that, and so we can do that too. We should have a sense of enjoyment in the thing that we've done over in the past week, where you shouldn't have to work.

[37:36] **Nadia**: Thanks for listening. If you'd like to continue the conversation, you can find us on Twitter at [@left_pad](https://twitter.com/left_pad) or [@nayafia](https://twitter.com/nayafia) or on our website [hopeinsource.com](https://hopeinsource.com).
