---
title: "01: Faith and Open Source"
season: 1
date: "2018-10-16"
time: "33"
description: We talk about our backgrounds and motivation for doing this podcast, and why the practice of faith seems so prevalent among open source developers.
episodeLink: "a2bfec15"
embedUrl: https://share.transistor.fm/e/2bb32fae
sidebar:
    order: 1
---

### Links

- Henry's ZEIT Day talk: [In Pursuit of Open Source](https://www.youtube.com/watch?v=9sPDcVYX3g8)
- Nadia's Grant: [Helium Grant](https://www.heliumgrant.org)

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-1/faith.md)

#### What is your faith background?

[00:00] **Nadia**: So we decided to start recording some conversations about open source and faith, because both of us have noticed in our work around open source, there are a lot of open source developers that had some sort of connection to faith. Often, Christian faith.

[00:17] **Nadia**: For both of us were sort of wondering why that was. We have pretty different backgrounds in terms of our personal connection to faith.

[00:25] **Nadia**: Henry, do you want to talk a little bit about yours first and then I'll talk about mine?

[00:29] **Henry**: Yeah, real short, I am a Christian. I didn't grow up Christian, but I mostly started pursuing it after college and going into working.

[00:42] **Henry**: I've just noticed through getting involved in open source, just a lot of parallels with what we do in church and our faith background.

[00:53] **Henry**: I didn't hear a lot of people talking about it but it does seem like it's kind of underlying a lot of stuff. So it would be really interesting to talk more about it explicitly.

[01:05] **Nadia**: I'm not religious, but I guess I've had a background of just being maybe more like academically interested in it since I don't even know when.

[01:15] **Nadia**: I went to a Quaker high school, which was definitely really influential for me. Quakers have a really strong background in public service, community service, activism, and things like that. So that definitely has fed into my understanding of faith and religion and community.

#### Faith as restorative

[01:37] **Nadia**: I guess I'm sort of weirdly interested in this topic because it's just fascinated me that especially for me working in tech in San Francisco, I feel like I almost never interact with faith or religion among my peers at all, in my sort of geographic location.

[01:54] **Nadia**: But it seems like in open source for some reason, it's a much more prominent theme.

[02:00] **Henry**: Yeah. That's really interesting that you said that... because open source could be global then maybe you see a lot different kind of people and not just like tech in San Francisco but in New York or all of these other places. It's spread out all over.

[02:16] **Nadia**: Yeah. It's sort of nice and restorative almost to get to talk about these topics in open source more than I feel like I do day-to-day in San Francisco. And I don't really know why that is. Maybe you're right, that it's just a geographic difference. I thought of it as also just people might be attracted to open source for similar reasons that they might be attracted to some sort of faith or spiritual practice.

#### Giving without expectations

[02:41] **Nadia**: I feel like I'm sort of mixing all these terms of faith, spirituality, religion, and those are all each, actually, kind of different things, but the aspects of faith that I think are really present in open source are around community organizing, and also just a sense of service, giving something to other people without expecting anything in return, for the benefit of some sort of greater good.

[03:08] **Henry**: Well I gave a talk on this in SF, at Zeit Day, but the way I got started in open source wasn't because I thought it was about community or serving people.

[03:19] **Henry**: I thought it was just cool that people are working together and I use stuff and it would be nice to be able say that you worked on some project. So it came from a pretty selfish point of view of wanting to be involved in something bigger.

[03:34] **Henry**: But later growing into not just being a contributor, but a maintainer, I realized how fundamentally it's all about people, and the maintainers themselves is a big part of that. Not just the code stuff.

[03:54] **Nadia**: What's the reaction been like when you've given talks in that realm or just talked to other people about it?

[04:01] **Henry**: Actually, so that's funny because in my mind, it's maybe like what you said. It's really surprising at the positive feedback I've gotten. I haven't really gotten anything negative from anyone about it.

[04:17] **Henry**: And maybe this is just because I'm just sharing my story and sharing personal thoughts. I'm not like trying to convince anyone of anything. It's just recognizing what shared, agreed values or parallels are in both. I really like the word you used, restorative. I don't know. It's just a different aspect of technology and programming that I don't see other than in open source, right?

#### What drives us?

[04:51] **Henry**: It feels like all this stuff in technology's about making things better for yourself or making money, and just very materialistic and robotic, in a sense. And yet this is more about helping others, and not necessarily thinking about yourself.

[05:19] **Nadia**: Yeah, I think it ties really closely to that sense of instrinsic motivation that we see a lot in open source. I feel like, for both of us, we've had these experiences of not being sure how other people will take it if we talk about faith in and I guess a more like not professional context, but just not among very close friends. I wonder why that is. Why does this perceive to be such an uncomfortable topic when it's also something that seems to really drive a lot of people in some shape or form or it's something that they do and care and believe in?

[06:00] **Henry**: I guess it's that people have their own experiences, other perceptions, and it's hard to differentiate. The kind of faith that's shown in open source which is very different from what you might see in media or that kind of stuff. It definitely feels weird, but I don't know. I feel like the more I talk about it, I feel more, not confident, just more willing to share. The more talks I've given, I try to share more about that. I'm not going up there and telling about my faith. It's just I find whether it's different quotes, books, or things I'm learning in my own journey there with my community. It's like, "Oh, they're very similar."

#### The conflicts of public service and sustainability

[06:53] **Nadia**: One of the reasons I'm hesitant to talk about it is because of this intrinsic motivation thing and the idea of public service, which sort of stands in conflict sometimes with the work that I'm interested in at open source, which is around sustainability and saying you can't really rely on the goodwill of developers to continue to maintain the infrastructure that we're all relying on. So for me sometimes, I worry that if I kind of dig into the faith thing of... There's some sense you're doing it for reasons other than something material. You're doing it because you really believe in this thing, and that sometimes I worry that if I focus on that side then it might invalidate this belief that also we need some sort of support for people that are doing this work, and how do they avoid getting burned out by the work that they're doing.

[07:44] **Henry**: Right. That's a really good point and I definitely am not on the side of you should do everything for free. Obviously, because I left to... and I have to sustain myself too. (laughs) So I am living out that struggle right now where there's this sense of "I want to be able to give everything away", but you don't want to limit access to things because you have to make money for it, but you have to sustain yourself and the idea that only people that can have the free time to do open source are the only people that should do it is seems pretty wrong to me as well. I don't know. It's a healthy struggle to have.

[08:28] **Nadia**: It seems like we don't hold our day to day work to that same standard. It's great to be intrinsically motivated by the work that you do as your day job, but that doesn't negate the need to have a salary or sustain yourself. And so why would that be any different for open source?

[08:50] **Henry**: Right. It shouldn't be in conflict. I had a conversation with someone about work. If we're all trying to help people you can make a for-profit company and then decide to donate it away or use that wealth or influence to help, or you can spend your time serving people more directly, (and maybe you won't ever make a lot of money) but you're having impact. Maybe some people believe one is more impactful than the other. It's hard to say. I think it's where you're placed at in the current time.

[09:35] **Nadia**: What do you mean by that?

[09:36] **Henry**: So, if you're in a position where you can influence others, then I think that's the best thing you can do, but if you're able make a lot of money, then maybe you don't have to be the one doing the direct help. You can fund other people to do it. And if you have a heart to help people directly, then you should do that. I guess I'm just saying that it shouldn't matter which one. But I would say that a lot of people would want to move everything long term, so "I'm going to make a business and then give it all away once I make it," and it's a good attitude, but also you might realize later that you might not ever get there and doing the giving now will help build that sense of giving in the future, because over time you might lose that, even though in your mind you believe that that's true.

#### Giving as a habit

[10:49] **Nadia**: Hmm. I guess I was just thinking too, within the concept of spiritual practice. I mean, there's a lot of overlap there too of... I mean, there are religions that are based around mega-churches and they are all sort of about fundraising, selling some sort of a product, or a promise to people. And there's also faith that's extremely personal and private and sometimes it's not even connected to community at all but it's sort of just about yourself and your own self-discovery. And so it's like the money question is sort of a separate thing from your personal level or connection to whatever you practice. And so maybe it's like similar... you can't within open source there's a million different reasons how you might end up sustaining it or not, but that doesn't invalidate the sort of underlying motivation.

[11:51] **Henry**: Yeah. I guess I was talking more from a personal point of view of what you were saying about like almost a discipline in giving. Just like everything else, we have habits that affect how we actually live and what we believe and that sometimes what we think we believe isn't what we're end up gonna be doing because we don't practice it. Even what you're doing with the [grant](https://www.heliumgrant.org), right? It's a really cool way of doing it. I mean, you could talk all day about giving, but if we're not actually doing it in the day-to-day, that might kind of lead us away, and then you find out maybe years later, you're like, "Oh, I've lost that sense," if you even realize that.

[12:35] **Nadia**: Hmm. Yeah. Giving in really small ways every day is, I think, a really important practice.

[12:42] **Henry**: Right. And, it's kind of funny cause it's in some sense, you're like, "Oh, I want to help people," but in another sense it maybe it can help you just as much for you to be able to realize that that's what's good for you to. To have that sense of giving through the practice.

#### Self-sacrifice and accountability

[13:02] **Nadia**: How do you balance that in open source where you could theoretically say helping someone is good for you or feeds you spiritually, but there's some point where it's like too much, right? Like, how do you know when it's depleting. (laughs)

[13:15] **Henry**: Yeah. I think that's a really hard question of... I don't know if there's a line there because... I think about people of faith... we are asked to sacrifice but also there's grace and there's a need to rest. At the extreme you could even be martyred for your faith, but are we all called to do that kind of thing and it's hard to really know per se. I'm not really sure. (laughs)

[13:55] **Henry**: Because you have to think about your physical health and your mental health, and maybe you are healthy and you're able to go more all in than other people, but if you're dealing with issues, then you have to understand more of yourself. And I don't know if you can look to people to, "Oh, I'm going to copy what they do," but you kind of have to learn on your own what that is. Like more awareness, and maybe that means talking with others and seeing how they see how you're doing too.

[14:34] **Nadia**: Like for them to evaluate you almost?

[14:38] **Henry**: Yeah. So a sense of accountability in the community. I think that's super important. Definitely in faith, cause you want people to let you know when you're getting off track, stuff like that. And I think in the same way with either working too much or serving too much it's pretty similar.

#### Tithing and a sense of ownership

[15:00] **Nadia**: This is making me think about tithing a little bit, but in a different way...

[15:05] **Nadia**: Yeah. I'm interested in tithing at a bunch of different levels but in particular I guess I'm thinking about it right now, how do you know whether you can afford to tithe or not. And I guess similarly, how do you know when you can afford to give of yourself in any shape or form, if you don't have a lot yourself.

[15:24] **Nadia**: The feedback I've seen has been... if you can't afford to tithe or it's gonna cause you some really serious undue hardship, that's a decision for you to make. It's not up to anyone else to judge whether you do it or not. But there's no one right answer to it. If you wanna give anyway because you believe it'll be good for you, that's fine. If not, then don't. But it's not prescriptive, you must always be giving this amount no matter what. You kind of have to check in with yourself, is this something I can realistically do or not?

[15:58] **Henry**: Yeah. I would agree. So I think it's interesting even in the church, right? It depends on the composition of the church, right? It's like how many people are members of the church and how many members actually tithe, the same way with open source. You have millions of users. How many people are giving back in through money or time, it's always going to be a way smaller amount. And it's not like we need everyone to be doing it. Maybe they don't realize it either.

[16:32] **Nadia**: That's sort of where I've kind of been interested in tithing as it corollary to open source. Should we expect that anyone who is closely involved in an open source project should be giving of their time or money or whatever? But I mean, the whole point of tithing is just to feel like you're giving something substantially back to this shared community. Is that a realistic expectation of an open source project?

[16:59] **Henry**: I guess it doesn't seem like it cause at least with tithing in your church, maybe you're going every week and you're in fellowship with people... I don't know. It feels more like a community cause it's in person, and when it's open source the attitude is very consumer like, right? It's very transactional, even though there's no payment. It's just like, I'm using it or it doesn't even exist, but in church you see people all the time. You know who all the people in the congregation are and you're willing to give back cause you have a shared sense of ownership.

[17:38] **Henry**: But with code and open source, people don't even know who the maintainers are. Like say with Babel, people think it's a company or it's a part of a company like Facebook, and there's that perception that still hasn't been changed.

[17:54] **Nadia**: I wonder whether that's a good evolution or whether that's actually a sign of a problem, right? Cause I think historically in open source... When I talked to open source developers that were from projects that are a bit older, there's this belief that all the users are potential contributors and there shouldn't even be a concept of users, because if you are using the project, you have the potential to be able to theoretically give back and I think in some of the older projects I've seen, there's just much more of a sense of: if you have a problem it's... sure, you can report a bug or something so that other people can see it, but it's kind of on you to contribute if you really, really need that fix that badly, then it's kind of on you to figure out how to solve it. And I think that worked because when projects are smaller, there're just fewer people using open source in general.

#### Seeing faces regularly

[18:50] **Nadia**: There was that higher level of community, right? Where you kind of did feel like there are fewer people that are working on this project and there can be this shared expectation that everyone needs to pitch in. And now with a project Babel, it's impossible. Of course, there are just people who are users and that aren't going to ever be contributors but maybe from within that there's still a smaller core of people that are somewhat active or contributing and of those people, there might be more of a shared context of pitching in and helping each other out. I don't know, would you say there is a sizable contributor community of faces that you see regularly, similar to how you would see people regularly in like a congregation or whatever?

[19:30] **Henry**: Yeah. I guess I would agree that before, there weren't a lot of people. So there's that assumption that anyone can get involved. But now it's like with GitHub and anyone getting involved in open source cause the barrier to entry is so low and all these people are trying to learn programming, you can't really expect that, right? And people just don't have enough education around how things work, and we need to do a lot more work to build on that.

[20:02] **Henry**: Yeah, I think the amount of contributors... there might be two or three or four core people on a team, and then maybe ten times more people that you might see regularly. And then maybe like a thousand times more for users.

[20:21] **Nadia**: And do you feel like the people that you see regularly, do they interact with each other at all, or do they only really interact with you or some other core maintainer? Is there a community for contributors?

[20:37] **Henry**: I think that's one of the issues that we've had is maybe before it was their email, and then now it's through these chat apps like Slack and Discord and all that. And it's kind of like the community itself is outside of GitHub, or everything is about the issues and the pull request, but then in the day-to-day, it's not really there. And it's hard to foster community when you allow anyone to join and then half of the stuff is just questions about usage, and then no one's really talking about development in the day-to-day.

[21:19] **Henry**: And not everyone has time to do that anyway, but it's hard to coordinate and get people on the same page. If you don't have meetings, then it's really hard and people don't like meetings... But that's what leads to what we have now where if there's no direction or no one knows what's going to go, what's moving forward, there's no vision, it's hard to move forward. And no one teaches you how to do that, and I guess that's my role now, but it's interesting.

[22:03] **Nadia**: Do people ever run into each other physically at events that are regular contributors?

[22:13] **Henry**: Oh. I don't think we have enough regular contributors for that, but I've always had a great time being able to either go to a conference, or a city, and then being able to meet maintainers... Well, that's more rare. It's more like meeting users. That's always cool.

[22:30] **Nadia**: Do you think it's even realistic? I'm thinking for very big projects, what works really well for them is that they have these really strong contributor communities, where there is a lot of context being preserved and there is a lot of this sense of people pitching in and helping each other out. But is that even realistic for a project that is... I guess there's just a lot of projects now where they just don't have that kind of a setup. Because it's not going to be as large.

[23:05] **Henry**: Yeah. Right. Like the scope of it is just never going to be that big. And we don't have enough people... Well, I think another thing is just we're not really thinking about it that much, right? My assumption is that most people just want to work on code and community is there but it's kind of implicit. I don't think anyone's going out of their way to set up these kinds of things. Now I'm thinking, "Oh, what is we made a Babel meetup." It's not where you give talks. It's just where you contribute or we have a conference even. That seems kind of crazy for a small project like us, that's not even a company, but maybe?

#### "Everyone else is going to be there"

[23:47] **Nadia**: Yeah. I guess I'm going back to faith stuff again. Well why do people go to church regularly? And I think there's some sort of sense of purpose and community that doesn't have to be this super designed out conference and a meetup kind of thing, maybe it's also the accountability thing? So like... I'm not religious.

[24:18] **Nadia**: But I guess the closest thing that I have to this is that I do aerial circus stuff, and a big reason a lot of people feel this way about their workouts, where the reason you might keep coming back to it is partly for the community and I think Crossfit is maybe like an extreme example of this. But part of like why I would go regularly is because there is a little bit of that accountability thing. You're kind of showing up not just for you, but you're showing up for other people, and you expect to see these faces regularly... I don't know. I just wonder if there's some level of that can make people feel, not obligated, but just sort of give them more of a purpose in contributing regularly. I don't know if this is all just extremely naïve and optimistic, but just that sense of you're showing up for a reason, right?

[25:05] **Henry**: Yeah. I don't think that's naïve. I think that's at the core of it, a sense of consistency. Why church is every Sunday or Saturday for people. And they go every week. It's not even because, you go there to learn about God or faith or something, but another reason to go is because you're struggling. And so every person of faith has doubt, and maybe every person that's a non-believer has some kind of longing for something greater, and there's kind of that tension that we all have, and part of the reason of going is to encourage others in the faith. Maybe I'm not going because I'm trying to express my devotion.

[25:47] **Henry**: That's part of it, but a lot of it is that maybe I'm not feeling up to it, but I know that all the other people in the congregation, they're there because they are. Maybe we kind of switch off, where it's like "Oh, I'm not feeling it today", but being involved in the practices (or I'm using the word liturgy) of the church, you kind of get restored into what it's all about when you might have forgotten it through the week, right? Maybe if you're only going that one day it's like... it's funny. On Monday, suddenly now you're back to... what they think is just like, "Oh, it's just work again," but how do we instill a sense that the whole week, whether you're at work or in church, it's all the same.

[26:41] **Nadia**: Yeah. I definitely feel that way about (laughs) about workouts too. Of sometimes you really just don't want to go but I go because I know everyone else is going to be there, and then afterwards I'm really glad that I went. Again, I think it's a really fine line to toe with open source and wanting to be respectful that it is people's volunteer time and it should be something that feels fun to them and not an obligation. And so how do you respect that while also... ideally they go not out of a sense of "Ugh, I have to do this obligation," but more because it actually does give them a sense of purpose of happiness or fulfillment.

[27:21] **Henry**: Right. Exactly. (laughs) I would say the same thing about going to church. It's not about feeling guilty or somehow going to church every week means that you're a good person or anything like that. Even going there for that reason might be a negative? Same way as continuing to do open source cause you feel guilty is just gonna lead to more burnout. So we need to think deeply about, "Why are we doing this in the first place," and whether it's good for you or other people. And not putting all the burden on yourself because you're like, "I'm the only person that can do this."

[27:59] **Henry**: Which is also the same issue in the church too. Everyone there are all serving and trying to do different things and it might lead to burnout there. It's also an issue.

#### Learning when to step away

[28:15] **Nadia**: Are there people that will step away from the church for a while and then come back? And if so, why?

[28:21] **Henry**: Yeah. That could be for a lot of reasons. So I also have a bible study or small group on Fridays. And so after work, every Friday I would go there. Maybe I'm super tired from work and everyone else is too, but I'm going there to be renewed and restored. Not because I'm tired and I was like, "Oh, I don't want to go anymore." It's something completely different from work and we're able to share with one another the struggles or encourage one another and the things that's happening in our lives. I think that's where the church is.

[29:01] **Henry**: I don't know if that's true for open source for everyone, but I think it can be. I think service is hard because sometimes the idea of serving versus serving itself, it kind of competes. I have this really good quote. This is more really specific to faith but I think it's kind of relevant. It says, "Beware of anything that competes with our loyalty to Jesus. The greatest comparator of true devotion to Jesus is the service we do for him. It's easier to serve than to pour out our lives for him. The goal of the call of God is the satisfaction, not simply that we should do something for him. We're not sent to do battle for God, but to be used by God in his battles. Are we more devoted to service than we are to Jesus himself?"

[29:58] **Henry**: And so for the faith thing, maybe serving becomes your own God, and feeling like you're so important and the sense of service trumps the point of faith in the first place. Which is interesting, where your work becomes your God, rather than working to serve because you already have God.

[30:25] **Nadia**: So the idea being that you almost don't need to have faith, which would imply trust that something is important because you already feel it so intrinsically yourself?

[30:38] **Henry**: Well, it's the sense that you shouldn't have to work for it, right? I guess it's kind of nuanced where... God already loves you, so you shouldn't have to work to get his approval, but because he loves you, you work. So you're doing it out of a sense of joy or love already, instead of trying to gain it. And that sense of wanting to gain it and to serve, that's the thing that leads to burn out because you're like, "I'm not doing enough. I'm not serving enough. I'm not helping enough. I can always be doing more," and you have more guilt versus doing it out of a sense of I already have, and because of that, I will give.

[31:26] **Nadia**: When you think someone feels that way in open source... we'll see people that'll step away either just because they don't have time anymore. They have other things they care about. Whatever the case, but I guess if you do that sort of self-inquiry, and you realize that this isn't bringing you the joy that you wish it did, do you think... There's two paths, right? It's either like you step away and you say, "All right, I'm going to go find something that does bring me joy," or, "I need to change what I'm doing or how I'm doing it, so that it does bring back that sense of joy, right?"

[32:06] **Henry**: Yeah. I don't know if it's just two options. Cause there is, what you were saying before, temporarily going away, right? It's not either I quit entirely or I kind of do something else in the same space. Maybe it's just that all you've been doing is working on it and you never took a vacation. that's definitely a issue in open source where you always feel like you're on call. You're always needing to be there, especially in our current age with Twitter.

[32:38] **Nadia**: Yeah. Definitely putting boundaries. I mean, that's something that even outside of open source a lot of people feel. I try not to use Twitter on the weekends just cause it feels like, ugh. What I found even with my work outside of open source, just setting up those kinds of boundaries can help you feel that sense of excitement about the work that you're doing cause you're not always on and you're not always responsive.

[33:07] **Henry**: I guess the concern is that when you're so involved and all that... say I'm doing open source full time, I still don't want to be so into it that I'm consumed but everything that's there, all you do is think about worry and all that. And you don't do your best work there.

[33:29] **Nadia**: Thanks for listening. If you'd like to continue the conversation, you can find us on Twitter at [@left_pad](https://twitter.com/left_pad) or [@nayafia](https://twitter.com/nayafia) or on our website [hopeinsource.com](https://hopeinsource.com).
