---
title: "05: Evangelism"
season: 1
date: "2018-10-16"
time: "34"
description: How do we evangelize our ideas? We talk about evangelism in religion and tech, meeting people where they're at, living one's values in public, and maintaining humility in the face of conviction.
episodeLink: "0dc379ed"
embedUrl: https://share.transistor.fm/e/0fdced2e
sidebar:
    order: 5
---

### Links

- 2017 Open Source Survey: http://opensourcesurvey.org/

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-1/evangelism.md)

[00:00] **Henry**: I think we mentioned evangelism in the last episode, so we thought it would be a good idea to go into that topic in more detail. About how evangelism in the faith context might not be that different in open source ‘cause we're also trying to get people to either do open source as a whole or get involved in your project.

[00:22] **Nadia**: I was talking to a friend about this who pointed out that the term evangelism in tech is like evangelism from religion which sounds obvious but I hadn't really thought of before. That's kind of weird that we use this term evangelism, which has a religious context to it. So yeah, we're gonna talk about the relationship between the two.

[00:47] **Henry**: Yeah, it is interesting ‘cause I know there are positions.. I'm a dev evangelist or we're looking for an evangelist for our software.

[00:58] **Nadia**: I don't even know, it's like a term that people are trying to use less now. It seems sort of weird that I was like oh, it's kind of weird (laughs).

[01:08] **Henry**: Yeah, I think so. Um, maybe before they did an analysis like "Uh..." (laughs).

[01:14] **Nadia**: Yeah, but anyway we're gonna talk about what I guess maybe not as bad as it sounds (laughs).

[01:19] **Henry**: Well, I, I guess first, uh, I would say that like in, in tech for some reason people can be very adamant about what they believe as well and, and it is pretty obvious in terms of even open source where like I was just talking to my friend, and he was saying how like I, when I got really into Linux I, I really wanted everyone to, everyone needs to use Linux instead of Windows and that's like the right moral ethical thing to do, it's open source. And then looking back it's like oh, I was kind of like pushing that on other people, and that kind of helped him to think about how he evangelizes in terms of his faith as well.

[01:59] **Nadia**: Yeah, that was like programming languages and just tribes in general, um, people can get very territorial about the technology that they're most excited about or best product and I guess like in the, on the one hand it can come from a good place if you're just really excited about what you're using and you wanna tell other people about it, but then where does that line go, where you're kind of just pushing an idea on someone else or not respecting someone else's views.

[02:28] **Henry**: I think there is an importance in like, the, you know, in the public sphere we have, you know, we show people charity and having the civility to be able to talk about those differences versus just like oh, I think you're a bad person ‘cause you think that this language is better or this editor or this thing and way of doing whatever you're doing is worse.

[02:53] **Nadia**: So is like the difference between evangelism and proselytizing, right? Proselytizing like officially part of Christianity also?

[03:03] **Henry**: I th- I think even these words have been kind of, uh, I guess changed over time and some people might think they're the same exact thing. I guess most people would think that proselytizing has a really negative connotation and then even recently I guess evangelism does have a negative connotation in the generic sense of the term. But I, I think usually I would see proselytizing as more of like yeah, like kind of like you're pushing your, quote, beliefs on people and it's like very aggressive and I guess that means that, that you're coming from a position of like I know what's better for you and everyone, like a position of power.

[03:43] **Henry**: But then the generic term for evangelism is more, I mean you're still talking about what you think is good but you're not necessarily like pushing it on anyone, you're not like I would say you didn't come up beforehand. You have like this prepackaged answer in terms of like arguing with someone but kind of like humbly coming before them, presenting something different, and saying that this is what I, um I guess believe or adhere to and maybe you might wanna consider it.

[04:13] **Nadia**: Hmm, it's sort of like it, it kind of reminds me of sales tactics not to make it all, uh, business-like or whatever, but, um, people talking about how I guess the best kind of sales is where you don't just have this prepackaged message that you're pushing on someone else but you're kind of letting them come to you or you're tailoring it to like that specific person you're talking to. Um, I guess it is kind of a sales thing.

[04:40] **Henry**: No, I, I, actually I totally think it is (laughs). It's funny in some ways like people think that religious people are so evangelistic but like that's what all of marketing is about and business is about selling something to someone and convincing them that it's good. But maybe it's not. They're like just intellectually but through a story or through some kind of thing and that's why when you watch like advertisements when you go to the mall and all these things, everyone is always convincing you or trying to convince you that something is worth buying or believing in.

[05:16] **Nadia**: I think it's different or I guess when it's something that feels like a really personal choice to people. I guess that's where I've struggled with it. I think much too like Quakers as far as I know don't proselytize or at least like I went to a Quaker school where there was never any like, well, I don't know, I guess there was never any expectation to like convert or, you know, you had to participate and meeting for worship like anyone else but you could, it was expected that you could do that or not be Quaker but I guess in the end, now that I'm thinking about it, it was almost that.

[05:48] **Nadia**: Like I still consider myself to live a lot of Quaker values and even though I don't consider myself to be Quaker. And I guess that kind of comes through just because no one is really aggressively pushing it on you. I mean I guess the point I was originally trying to make is that it's I think I'm more wary of situations where like, yeah my, it's, it's like my personal choice and so I don't wanna feel like I'm having something being sold to me, which is different from buying like, I don't know, a SaaS product or something.

[06:23] **Nadia**: But then I guess like where do any of our views and beliefs come from? Like people are always kind of, I don't know. I saw something recently that was like, I can't remember what this, it was like everyone is doubting someone else's philosophies or something like that which like the, the most, uh, the people that are like most aggressive about their messages it's not even like their own view, it's someone else's view. So I guess, I don't know, there is no like really pure person choice anyway. You're all influenced by someone else.

[06:57] **Henry**: Yeah, um, I guess going back to the, the business thing, I think what happens is a lot of messages they want it to be personal because it's like oh, like if you buy these, I don't know, these, these cloths or this food you're gonna have a better life kind of thing. So they try to make it as personal as possible sometimes. Um, and I think what you said about, um, not pushing anything is important because we don't want, at least in faith too, we don't wanna like reduce what we believe in to just the idea and the message. It is a message but it's not solely what it is and what we're trying to say is that we don't wanna like kind of extract that way from the reality of just living life and you have to embody what that is too not just like, say, those words.

[07:50] **Nadia**: Mm-hmm (affirmative).

[07:53] **Henry**: And, um, I guess that's what you're saying about how, you know, it's kind of, it's not just one package thing. I think a phrase that we like, a lot of people use is like meeting them where they're at, and I think it's like how do you make that thing contextual to what they're going through. You can't really just say the same thing to every person. You wanna listen to them, uh, and maybe that's probably most of the work that you have to be doing instead of talking all the time.

[08:25] **Nadia**: I think in the end if someone didn't convert I guess I don't really know the right ter- I don't mean that literally, I just mean like if someone didn't come over to your way of thinking would you think of that as failure in the end or is it? I'm trying to extend this analogy further to advertising I guess where there is like brand advertising and then there is like, um, advertising with the intent to make someone buy something and sometime, like Coca-Cola does like brand advertising or like they're not literally trying to sell you Coca-Cola in the moment but they're selling you like this warm fuzzy feeling so that whenever you think of Coke, like you just think of these like fizzy little bubbles and happiness and whatever.

[09:02] **Nadia**: And that's kind of the point of it and I wonder if there is an analogy there with just like personal lifestyles and like, I don't know, it's not necessarily about making someone be what you are, but it's more about seeing like that what your lifestyle is like if that makes sense?

[09:23] **Henry**: Yeah, no, that definitely makes sense. I don't know if like it's I think it's pretty similar because, yeah, I don't think you can expect you're gonna talk to someone and then that moment they're gonna like believe in what you believe or say you talked to someone about doing open source and then suddenly they wanna do it. I think it's i- yeah we're asking for a certain level of commitment, and it is pretty personal I think. I don't know if it's, it's like you can talk to a whole group of people about something but, uh, your ge- you're message is so generic, it won't really make sense to them.

[09:59] **Henry**: And so I think I mentioned this before even talking about like spiritual health. It's like you wanna walk with those people, through whatever they're going through, and it's like it takes time. I don't know if it's really about like, you know, making, making them have good feelings per se but, yeah, I think it's kind of like over time it's like oh, this is a viable option for me to look into.

[10:26] **Nadia**: I feel like this kind of relates the idea of what, like the idea of just learning in public with open source or everything you're doing you put it out in the public, because you never really know who's gonna see it and who's gonna like who it might affect and it just makes more sense that you might as well do it publicly versus privately which is in itself I think a form of evangelism, even if it's not evangelism towards like doing open source but it's evangelism towards like whatever it is you're putting out into the world or for yourself, for your reputation or whatever. But like yeah, why do we default to public and they think like it's that, it's that idea that you're trying to like live by example or, I don't know, show something.

[11:11] **Henry**: No, yeah, I like that. I think it's living in the public is kind of, uh, it's not just like where you're saying like we're just trying to convince them with the open source but maybe it's more like we're trying to convince them of the values behind open source. So maybe they don't code or they don't know anything about open source but they're like oh, in my field, yeah, maybe is research or something else you're like oh, I wanna like make what I'm doing open as well. I think that's really valuable because then people can kind of take what that is, and take it to where they have a lot more knowledge than we do.

[11:48] **Nadia**: It is funny. I mean open source in particular like, I mean it start as a software thing but you hear people sort of misusing the term but like just applying to like everything that means open.

[11:57] **Henry**: Yeah.

[11:58] **Nadia**: Which is not necessarily maybe like ideal but, uh, but it does speak to the idea that like the concept of open source is so powerful that it kind of spreads to these other places. It's been fine for me to consider over the fa- past couple of years ‘cause like I didn't come into open source but, you know, then I was just sort of like reading around and studying it, and at this point I feel like it's like really seeped into I think about working in general and I, it took me a little while, like a couple of years to realize like oh, this thing has actually changed me without intending to kind of somewhat, I guess, like Quaker school.

[12:36] **Nadia**: Where it's not like I was like intending to ever really contribute or do anything or whatever, but now like I think of it almost like it's just like a really deeply held belief of mine now that like everything I do I need to like put into public or record somehow or have up somewhere. And yeah and just like a lot of other things from, from open source. So I feel like those values kind of seep in unintentionally if you spend enough time around it.

[13:06] **Henry**: Yeah, I, I think it kind of shows the value and I guess almost power of like habits and things that we do day-to-day. And yeah, I think a lot of yeah, I guess you would say effective evangelism might come from not kind of like telling people and not even just leaving it out but your own personal, uh, reflection on what you believe. Like it's like if you don't actually truly believe it yourself and live it out, then how are you gonna be able to like show or convince that in anyone else? And I think one of the … And that, if you think about like that it's you're gonna come from a place of humility because you realize that I know I'm not what, you know, these values are and I'm trying to work towards that, and I, and I think it's when people see like it being lived out, then people are more willing to wanna chat about it or even, you know, ask about that.

[14:13] **Nadia**: Yeah, and ultimately I guess the decision falls on them which is maybe the important difference between ... I mean in the end it's always someone's decision but I feel like that makes it kind of different from evangelism versus proselytizing where it feels like proselytizing is like an intent to convert whereas evangelism is like in the end it's kind of like up to that person if they are inspired by what you're doing and wanna learn more or wanna like, I don't know, yeah, explore it.

[14:44] **Nadia**: But it's not, no one is like aggressively trying to tell you to do something. It's like, it's, it's like anything else where like if I spend ti- enough time around any of my friends or coworkers or whatever, like you start to just be changed by them. That's just like more subtle I guess.

[15:03] **Henry**: Yeah, yeah, maybe, yeah, you still have the intent for that, it's just that you understand that, you know, obviously everyone's their own person and you wanna respect, uh, that they, that they aren't that. You don't, you're not forcing anything on anyone, and I think doing it in that way, you know, it's kind of you're putting yourself out there and so it is a I think the posture that we wanna have with evangelism is basically being venerable and I think a lot of times the best thing you can do is just tell your story, which is why testimony is so important in faith but also I think in open source.

[15:43] **Henry**: Like I think about like all the talks I've given which I've none of them have been that technical per se but just sharing about like oh how I got started in doing open source, you know, starting from not knowing anything about it and then somehow like becoming a maintainer and I think it's like oh, people realize that you're not like that special that, you know, they could have had that happen to them too or they can relate to your struggles or whatever that is.

[16:12] **Nadia**: Yeah, I, I was thinking about this, in relation to like community values. Like we're talking about as like an individual but also sort of like how does a community embody values and how does, yeah, how does the community collectively evangelize I guess. And I was thinking about this open source survey we did at GitHub I think two years ago now and one of the things we had found- we were sort of like randomly sampling people on, on GitHub who were on open source repositories about their behavior and, and things they witnessed and one of the things that came out of it was a lot of people had witnessed a negative interaction on a project and that made them not wanna participate.

[16:58] **Nadia**: And I guess the insight being that it's not even about whether you're … It wasn't even about whether someone did something negative to you but even if you witnessed a negative interaction happen, it would make people wanna leave. And the takeaway for me on that was like it's really important for a community to act as though everyone is watching because like you don' know who might have stumbled upon your project and was thinking about contributing and then they saw something and then it just put them off and then they left.

[17:29] **Nadia**: And yeah I guess it's, it goes back to this idea of like it's not even about who you're directly interacting with but it's about like living through example or, um, yeah just being em- embodying like whatever it is you wanna embody all the time when people are watching or when you're in public and, and people will pick up on that and choose to sort of engage or not engage.

[17:56] **Henry**: Yeah, that is, uh, too real (laughs). I feel that so much in, well, both in my faith and in open source because I think the problem is you know that's true but then that also may lead to like a sense of, you know, anxiousness ‘cause you know that everyone's watching. Um, and that's just the, the issue with doing anything in public, um, and even as people of faith, you're called to, yeah, it says in the Bible that we're called to be ambassadors for Christ and witnesses. I think those are good words to explain that, you know, it's not what we believe or our story but it's like God's story of how we should act and we shouldn't, you know, you know, cater to in necessarily like dumb it down kind of thing but like represent what that is and we can't compromise on that either.

[18:51] **Henry**: And that's what makes it, uh, so hard because it's so easy for you to just say things right, but to live it out is, is different and I don't, yeah, like I wanna be a person of integrity and to not be a hypocrite but like what you said, anyone that says they are part of your group and they do something quote, bad or wrong and then it makes like the trust and all of it worse for everyone. And so like when you see like people calling out maintainers or saying they, they're bad and all that stuff, you feel really bad ‘cause you know that it's not just that person getting mad or that person feeling bad but everyone that sees him, that could be so many people.

[19:38] **Nadia**: I feel like everybody, even outside of open source, outside of religion whatever, I mean we're all living in very like increasingly public lives, whether you know it or not (laughs). And so it is a lot of pressure to be like well, sometimes people slip up or sometimes you don't wanna always be thinking about like, you know, what happens if someone puts this on the internet (laughs) and, and I'm suddenly like the center of attention and I didn't want to be. And so, I mean I guess there is sort of like a two-way relationship there too right, of like what do you expect the other person to believe about you or like is it okay to be fallible sometimes, is it okay to make mistakes?

[20:19] **Nadia**: I feel like with evangelism what I was talking about like what you're sort of projecting out to others but like what's the experience of the person receiving it and like what are the expectations for their behavior and like how they should engage with you if that makes sense.

[20:35] **Henry**: Yeah, I, I think that's where posture of just listing to people is so important. Like if you go in, yeah, I think it's you go into it expecting certain things out of a person, so then maybe that's why you're so, you know, aggressive on saying these things ‘cause you know they're gonna respond a certain way. And so if you don't have that assumption, then you'll probably, you know, not, you're not gonna like bring up all these things immediately ‘cause it's not, like that's just not relevant to getting to know them or they're like having a relationship with this person at all.

[21:07] **Henry**: It's kind of just like yeah, I don't, there's no, it's like, it's kin- if I was gonna bring someone to church I'm not gonna just ask them immediately right. That I have no reason to do that, but, you know, it's just like how do you get to know this person, what they're dealing with, all that stuff, and just being able to and it's so much harder ‘cause you have to actually know what's going on with them. And a lot of times yeah, maybe you don't have to do anything. It's kind of just the right timing I think.

[21:40] **Nadia**: Yeah. It seems to me that we're always more forgiving of people who show some level of like realness or vulnerability. Kind of going back to what you were just saying about like the posture being vulnerability and I was trying to think like I think like people are much more gleeful to take someone down when there is someone who's been like espousing, you know, very strict values or just like really aggressively pushing their ideas or something.

[22:10] **Nadia**: Like I don't know if we find some sort of scandal about like a conservative politician and that's like, we just like love to see them go down. But I think like coming at it, coming at like everything in life from that position of, um, vulnerability like it that almost like helps create those contracts between you and the people that you interact with, where if you're coming at it from like I'm not perfect and I don't know everything, and I'm just sort of being open and listening to you and asking you to listen, then people are just much more forgiving I think. Just kind of interesting.

[22:50] **Henry**: Yeah, I think it's important because I, I don't think like coming off as like, you know, self righteous that kind of thing is definitely not gonna bring anything helpful, and even, you know, what you're saying about like yeah, when people do something bad, it's so easy for us especially now ‘cause everything is public and instant, that it's so easy for us to just say like oh, like this person is so bad and like it, it makes us feel like we're so much better, and I think it, it has this weird negative effect where like the more bad things happen or that people do, you, you think yourself that you're not capable of doing that either.

[23:31] **Nadia**: Weird, isn't it?

[23:33] **Henry**: Yeah.

[23:33] **Nadia**: It becomes a sort of like downward spiral into, I don't know. It maybe goes back to what I was saying about the witnessing community interactions, like when you feel like that behavior is okay then you kind of engage more deeply in that negative behavior and then it kind of spirals down which I think makes it all the more important that people try to go higher instead of lower.

[23:54] **Henry**: Yeah, I know sort of like the whole mob mentality of like oh, this person sucks so I'm gonna also say they suck and then like you're not ever looking at yourself to see if you're, they, you know, having those same behaviors and it actually reminds me of that quote from Batman about how like, what was it, like you die a hero or you live long enough to see yourself become the villain. Um, I think that's pretty applicable in a lot of areas.

[24:30] **Nadia**: Work (laughs). I guess I was just wondering of like, I mean I, I just kind of, this may be a cheesy thought but just like everyone in some sense is evangelizing something, right and so it was sort of odd to me I guess that like religious evangelism gets a bad rep. I think maybe because there are people who have done it in more extreme ways that is like not desirable, but in the end like sort of I guess the way we described it like it doesn't seem any different to me than like how anyone is trying to live their life and be a positive example for others, right? Like is there some other piece of it that I'm missing or is it really just no different from any other kind of evangelism?

[25:19] **Henry**: I guess I would say there is, yes and no. Like I think some people would say it is different because we're talking about something that is like ultimate, right. Which is like something that you commit yourself to which like your whole life should be based around. But in another sense I would say no because a lot of the things that we believe and want people to believe are things that are of ultimate concern, that do matter in the long run. And I think in a lot of, in a lot of ways things that we think are insignificant like small whatever things that happen in our lives, they do affect us in a big way.

[26:00] **Henry**: And so it's kind of just saying that like these small, little, I don't know, pieces of information or habits, those things change us in a way that helps us think about like, what, you know, the purpose of life is or, or how do we deal with suffering or what does it mean to be happy and stuff like that. Another thing was, in evangelism, a lot of times if you are not having that, like doing the listening first, you will probably use your own terminology, that they probably won't- that they don't understand and so especially in like Christianity we'll, we'll say like a lot of things that people might not get at all, especially now where it's kind of we're in this post Christian world where maybe before you're like oh, we talk about like, just like grace and mercy and sin and all these words, uh, sanctification.

[27:00] **Henry**: Like all these things and then if you say that now people have either they don't know what it is or they have a different picture of what that is. And so it's important to be able to talk to people in a way that it's just normal language. And I think that important espe- like even in open source, where we'll say all these things like Git and all that and they're like what is that, right.

[27:21] **Henry**: And so I think it's good for us ‘cause it helps us to understand more deeply like what this is actually about. Um, I know I've been talking a lot with my friends that they're like oh, ‘cause what happens is you meet someone new and they'll be like, “What do you do?” And now, it was so easier before ‘cause I just say like, “Oh, I work at, you know, this company” like Adobe or something and now it's like, “Oh, do you like have your own start up or, or a young company or what, what is that?” So I be like, “Oh yeah, I do open source” and then you go into this whole thing trying to explain what that means, and try to find different analogies a lot.

[27:57] **Nadia**: I'm so unfortunate ‘cause yeah, I mean I, like it goes back to the friends where I like avoid jargon in general I think but like even the term open source sounds jargony and it's really hard to avoid. Like it's, it's kind of hard to ex- I found it's hard to explain what open source is or what I work on to someone who like does not know anything about software. So like I'll usually talk about doing it in public, um, yeah, it's like collectively created among like, you know, a bunch of different people all over but it's really hard to explain it.

[28:35] **Nadia**: And I, I've never, I, I really like to, I really do like not like the term open source for this reason. I just think it sounds so jargony and it's so like, I don't know. I just, I think it just like puts people off ‘cause it's just ... Even if you work in software, even if you are familiar with open source, I think if you say that you work on open source stuff people still have this preconceived notion of what that is and like I don't like that either, because the term means a lot of different things to different people and yeah I, I really struggle with that of like finding the right, the right way to talk about what I do or what I'm interested in. I try to go as long as possible without using the term open source, unless I'm lazy and then I just kind of say it.

[29:23] **Henry**: (laughs) That's so funny.

[29:23] **Nadia**: Yeah.

[29:26] **Henry**: Yeah, I think I end up just saying like oh, it's the opposite of closed source and I have to say what source is and source code and I'll probably use an analogy of like Wikipedia, uh, ‘cause people know what that is. So it's kind of like based on what I think they know or they've told me. Even actually if there is someone from church I'll actually just say like I'll talk about how it's like a community, and people are doing volunteer work and they're giving away for free kind of thing. It is funny that people end up asking like oh, how do you make money and then we can go into that.

[30:01] **Nadia**: I think it's the cultural part that I struggle with of like I can, I could explain what it is but not necessarily what it means and then that sounds maybe sometimes like worse to talk to people in software versus outside of software about it because they do just have an idea of what it culturally means to do open source and the, the weird part I guess is like there is just such a wide range. Like for some people they assume it's like super like, I don't know, like hippy stuff, and then some people would assume it is very like corporate thing ‘cause like that's the open source project they know and everyone just have like a different idea of what it means and so it's like I, I think I hesitate to talk about ‘cause I'm just like I'm not sure what that other, what's going on in that other person's head when I say it and then once I say it I feel like I can't unsay it or change it. It's actually similar now working for a company in like, the crypto space that like-

[30:53] **Henry**: Hmm.

[30:54] **Nadia**: ... I really try not to use that word unless I'm feeling lazy and then sure whatever, but like I don't like that that sets of so many different ideas in someone's head about like what it means or what kind of company it is or what I do and, um, yeah, it's like hard to kind of have control of that message or story I guess. And I imagine it's similar for ... Like I am actually surprised at how many open source developers are open about their faith publicly because I feel like if I were a Christian I would worry about people just, you know, if you say that then just they're putting on a lot of assumptions about who you are or what you care about or, yeah, I don't know. I don't know if you-

[31:40] **Henry**: Oh, I totally agree (laughs) everything that you said.

[31:44] **Nadia**: Like especially it's not and like I mean ‘cause you're in New York know, right and I, I don't know maybe it was different, where you grew up or something but like, like yeah, I don't know like any religious people in my life really like in San Francisco, um, and like urban places. So it's like even harder to, you know, being religious at all is one thing and then another thing to kind of say like you're Christian or anything like that.

[32:06] **Henry**: Yeah, no, that's definitely a issue, and that why I'm so encouraged that we're doing this podcast I guess (laughing) in the first place.

[32:14] **Nadia**: We can talk about it here.

[32:16] **Henry**: Yeah, I, I, I think that's part of a really good, like it's like oh, we're talking about all these terms for open source. Like Christianity, like if you say you're a Christian it means so many things, and so that's same thing. I think people actually don't say that as much. They, they won't they're Christian, they'll say like some other form of what that like oh, I follow Jesus or something (laughs) ‘cause it says something different. Or a lot of people they don't, yeah, and even there is like evangelicalism, being evangelical which is more of a political thing and so you probably don't wanna say that either ‘cause it's like that says certain things about or stereotype about what you believe or who you are as a person, you know, right people just start judging you on those kind of things, yeah.

[33:01] **Nadia**: That makes the whole evangelism thing even harder than it looks like. You almost don't even wanna ... If it, if it's hard to even talk about being the thing much less I don't know everything else that comes with it like it just seems, seems very difficult.

[33:17] **Henry**: Yeah, I think it just changes based on the time. You know, maybe like 500 years ago, you could say that and everyone was Christian or whatever everyone was religious.

[33:27] **Nadia**: Yeah, if you weren't though.

[33:28] **Henry**: Yeah, it would be weird if you weren't guess and then now it's almost like the opposite and it's only perceived as pretty negative. So it's just a different situation to be in.

[33:39] **Nadia**: Thanks for listening. If you'd like to continue the conversation, you can find us on Twitter at [@left_pad](https://twitter.com/left_pad) or [@nayafia](https://twitter.com/nayafia) or on our website [hopeinsource.com](https://hopeinsource.com).
