---
title: "11: City as Liturgy (Bonus)"
season: 1
date: "2019-03-21"
time: "54"
description: Is the city a toaster (an object) or a cat (a living organism)? We are joined by Dr. Timothy Patitsis to talk about how our physical and digital spaces, like liturgy, can be understood as "the work of the people". We discuss science as organized complexity, the meaning of knowledge, recursive societies, fractal hierarchies, and implications for governance.
episodeLink: "1e2b2d17"
embedUrl: https://share.transistor.fm/e/9935e8af
sidebar:
    order: 11
---

### Guest

Dr. Timothy Patitsas has been Assistant Professor of Orthodox Christian Ethics at the Holy Cross Greek Orthodox School of Theology in Boston, Massachusetts
since 2005. His dissertation, The King Returns to His City: An Interpretation of the Great Week and Bright Week Cycle of the Orthodox Church,
combined interests in complexity theory, liturgy, urbanism, and the economic and political writings of Jane Jacobs.

### Links

- ["The Death and Life of Great American Cities"] (Jane Jacobs)
- Timothy's paper: ["The City as Liturgy"]
- ["Reclaiming public life"](https://nadia.xyz/public-life): Nadia's post after reading Jane Jacobs' book on cities
- ["After Writing"]: On the Liturgical Consummation of Philosophy (Catherine Pickstock). The article that linked liturgy with cities for Timothy. The author accused Descartes of substituting a "mode of knowing" that was impersonal, visual, timeless; similar to Jacobs' accusation of urban planners
- [Cartesianism](https://en.wikipedia.org/wiki/Cartesianism): philsophy of René Descartes
- ["An Exploration of Hierarchy as Fractal in the Theology of Dionysios the Areopagite"]: Article about governance from a friend that Timothy recommends. Can't throw away hierarchy entirely, but it can be fractal
- [Subsidiarity]
- [_Governing The Commons_](https://www.amazon.com/Governing-Commons-Evolution-Institutions-Collective/dp/0521405998) by Elinor Ostrom
- ["Governance without foundations"](https://nadia.xyz/foundations): Nadia's post on foundations
- Organic order isn't known all at once, is recursive/algorithmic (think of our relationships)
- We cope with perennial issues, like death, through liturgy (ritual)
- ["Science and Complexity"](http://people.physics.anu.edu.au/~tas110/Teaching/Lectures/L1/Material/WEAVER1947.pdf) (Warren Weaver)
- ["Letters to a Young Poet"]: Particularly Letter #4: "Don't search for the answers, which could not be given to you now, because you would not be able to live them."
- [Desire lines]
- ["The Cat and the Toaster"]: Living System Ministry in a Technological Age (book)
  - Many references to the [church as a body](https://en.wikipedia.org/wiki/Body_of_Christ) (1 Corinthians 12:12-31), also reminded of being farmers/stewards/shepards.
- _The Ethics of Beauty_: Timothy's upcoming new book
- [paperclip maximization]

["the death and life of great american cities"]: https://en.wikipedia.org/wiki/The_Death_and_Life_of_Great_American_Cities
["the city as liturgy"]: https://www.academia.edu/12035222/The_City_as_Liturgy_An_Orthodox_Theologian_Corresponds_with_Jane_Jacobs_About_a_Gentle_Reconciliation_of_Science_and_Religion
["after writing"]: https://www.amazon.com/After-Writing-Liturgical-Cosummation-Philosophy/dp/0631206728
[urban renewal act]: https://en.wikipedia.org/wiki/Housing_Act_of_1949
["an exploration of hierarchy as fractal in the theology of dionysios the areopagite"]: https://academiccommons.columbia.edu/doi/10.7916/D832055Z
[subsidiarity]: https://en.wikipedia.org/wiki/Subsidiarity_(Catholicism)
["letters to a young poet"]: https://www.carrothers.com/rilke_main.htm
[desire lines]: https://en.wikipedia.org/wiki/Desire_path
["the cat and the toaster"]: https://www.amazon.com/Cat-Toaster-Living-Ministry-Technological/dp/1608992705
[paperclip maximization]: https://en.wikipedia.org/wiki/Instrumental_convergence#Paperclip_maximizer

### Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-1/city.md)

[00:00] **Henry**: All right. We decided to make a bonus episode. So Nadia wrote a post a month ago about her reading of a book called ["The Death and Life of Great American Cities"]. It talks about cities and how that relates to open source and communities online, that open source is kind of like a digital city. Same with the internet.

[00:21] **Henry**: That got me looking into my own research on the topic. I found a paper called ["The City as Liturgy"]. And so I thought it'd be cool to bring on the author. So right now we have Dr. Timothy Patitsas, with us. He's a Assistant Professor of Orthodox Christian Ethics at Holy Cross Greek Orthodox School of Theology in Boston. And he wrote a dissertation called, "The King Returns to His City, an Interpretation of the Great Week and Bright Week Cycle of the Orthodox Church". Thanks for joining us today.

[00:57] **Timothy**: Thank you, Henry. And thank you, Nadia. Thanks for bringing me on.

[01:02] **Nadia**: That'll be good if we start just by talking a little bit about this theory that you had about City as Liturgy and your reading of Jane Jacobs' work just for the benefit of everyone who hasn't read her work and, also just as a refresher of what liturgy is and how that relates to cities in your mind.

[01:19] **Timothy**: So to start with Jane Jacobs, she did not finish college. She did do a couple of years at Columbia in the 1930s. And when she got to a point where they insisted that she choose a major she quit. She wanted to be free to organize her education any way she saw fit. And I mean to follow the intellectual leads as they came to her.

[01:44] **Timothy**: She was a journalist in New York City. And she covered the effects of the [Urban Renewal Act]. I think there's a more official name for it, of 1949, which really devastated American cities. It replaced what was the living order of the old city with this very abstract, very visual kind of formal, pretty order that was underneath all that was lifeless and dead.

[02:13] **Timothy**: In 1961 she published her book, ["The Death and Life of Great American Cities"]. It was an instant hit. I don't know how much impact it had on the field of urban planning initially or even still today. I certainly wish there was more evidence that what she wrote there is being followed.

[02:33] **Timothy**: But I came to her book many years later just as a side thing while I was working on my dissertation in theology. And one day I just happened to notice, she was describing cities as if they were liturgies. So there's a book that helped me to understand Jane Jacobs.

[02:50] **Timothy**: I mean of course, the moment I read The Death and Life of Great American Cities I was in love with that book. I was in love with just her writing style, her insight, and her rebellious nature against what was the accepted reasoning of the day. And also it's really a text about racial injustice because of the over 2,000 American city neighborhoods that were completely dynamited down to the rubble to make way for urban renewal. 1700 of them were largely African-American neighborhoods.

[03:29] **Timothy**: So a huge blow to the African-American urban communities. And no one talks about that. Still today. There's like one other book you hear about. So on many levels I loved Death and Life. But there's another theologian in England named Catherine Pickstock. And she wrote a book called, ["After Writing"]. And the subtitle is On the Liturgical Consummation of Philosophy.

[03:56] **Timothy**: And I didn't read that book super closely 'cause it was kind of technical and dense. But, her basic point was that she thought that Descartes had aspired for, aspired to, to bring us to a mode of knowing that was impersonal and visual and outside of time. And, it was during actually my comprehensive exams for the dissertation at Catholic U in Washington that it just hit me that what Pickstock was accusing Descartes of doing, is what Jane Jacobs had accused the urban planners of her day of doing.

[04:34] **Timothy**: They substituted a living, very sophisticated, rich and subtle order, with something that was visually flashy and comprehensible, but that was outside of time and therefore dead.

[04:50] **Timothy**: So when I first had that insight I just said, "You know what, maybe I'll write my dissertation about the role of time as an actual raw material in city building in death and life." And it was a few months later when the title of the book itself finally hit me with its full force and I realized actually in many levels, you know, cities for her are liturgies.

[05:18] **Nadia**: Just to like round out the city aspect before we move to the liturgy part. I had a similar just sort of bowled over reaction when I read Death and Life as you ... I mean, it's just really worth re-emphasizing that her style of writing is just incredible. She's very openly rebellious and openly like pissed off with the way that urban planning is being treated today.

[05:42] **Nadia**: And she bases all of this research on not stepping outside of, you know, academia or industry and the way things are being done. And bases it off of like she's just looking at cities and observing what's happening and sort of using this common sense logic that she's very explicitly trying to democratize our understanding of urban planning by saying, "Look. Anyone can look around at a city if you talk to the citizens. You talk to people living in cities. They're not gonna agree with the way that we talk about urban planning on a grand scale."

[06:15] **Nadia**: If I could summarize a little bit of what the establishment was like back before she published this. It seemed like it was sort of your classic like, let's plan a city from scratch. The sort of thing that led to like the creation of suburbs as a place for well to do people to move to, to move out of the city and it was kind of leading to these issues that we saw around inner city kind of problems where everyone else was being left behind and there was just sort of this grand vision of, if only we could like design all the houses in exactly the right locations then everything would just look perfect.

[06:56] **Nadia**: Just to sort of oversimplify a little bit. To her that was like the city being this sort of dead artifact kind of thing where you just put a bunch of houses down and everything stays exactly the same for the next 100 years or whatever. And in her view, city treating cities more as these living organisms that kind of grown and shaped, are really shaped by the people and their environment there isn't really an objective reality of what a city is. And it certainly does change over time and produce a completely different set of observations and recommendations around urban planning. So that's kind of what I got out of it.

[07:35] **Nadia**: Then I think when I read it I was kind of taken in the direction of her description of cities being a lot like the internet as a city. That we have this sort of like digital lives that are also very like organic and complex, and separate from ... or yeah, similar to the way that cities are. I totally am on the same page about her impacts on cities. The idea of like city as liturgy I wanted to unpack a little bit more.

[08:07] **Nadia**: We had an [episode on liturgy](https://hopeinsource.com/liturgy/) and I'm kind of a theological newb here. I remember we talked about liturgy as sort of like religious rituals or habits or things that you do that sort of like reinforce, I guess your practice. I wanted to just sort of unpack a little bit more from your side. Like what ... is that, is that right? (laughs). What is liturgy, and then yeah how did you see the parallels being drawn to the way Jane Jacobs describes cities?

[08:38] **Timothy**: Yeah, these are all great questions. You know, let's see. What is liturgy? I mean as a mode of knowing liturgy revolves around the idea that organic order is not meant to be known all at once. Or like think of it as a person. You're not meant to know a person all at once. We don't introduce ourselves with, you know, a biography or the full life story, but rather living systems are meant to be known recursively.

[09:16] **Timothy**: And that's a little off the topic. But, I guess recursion is a way to think about or algorithmic is a way to think about liturgy. It's a system that's running some basic equation, you know, one time and then using the results from that first time running the same equation again and again. It's doing that potentially infinitely and as it's doing so it's generating a fractal order.

[09:49] **Timothy**: And so the city for Jacobs is something like running an algorithm. It's solving certain problems that are perennial problems of city life and it's resolving them in patterned ways that are also perennial. And in that sense there's an algorithm running there. And that's what liturgy does as well.

[10:12] **Timothy**: I mean, think about like rituals around death. Well that is a perennial problem. Someone you love dies. I mean this, this has happened, you know, since humans existed. And how do you cope with that? How do you incorporate that back into life and overcome the shock, overcome that challenge? And we turn to religious rituals to do so ... memorial services, or funerals or what have you. Different ways of memorizing a person or you know, teaching about the person to the next generation.

[10:47] **Timothy**: So the details are infinitely varied, but the patterns and the challenges are the same. And that's a basic sense in which cities are like liturgies. Of course the other one is just the word liturgy in Greek just means the work of the people. And that's the whole darned point of Death and Life is that these planners thought the city was the work of, you know, 50 smart men. And she was saying, "No, the city is created by the plans and dreams and efforts of many people." And in fact, the reason we have slums is because the inhabitants of those places are denied access to credit, of financial credit with which they could start businesses, repair their homes, improve their homes, basically if credit isn't available widely then the liturgy ceases, the liturgy of the city. The algorithm stops.

[11:48] **Timothy**: ... Did I get kind of too far astray there?

[11:52] **Nadia**: Yeah, no, that's beautiful. It actually relates really well I think to the the software (laughs), like mentioning workers. For me I like listening that I hear such a clear crossover to the way we talk about the web today. You had done for this Cartesian read of cities or of the Cartesian read of digital spaces too where, we think of the tools that we have now being sort of static or being sort of fixed. And losing the aspects digital spaces being built by the work of the people, which I think is just a really nice, succinct way of describing liturgy.

[12:30] **Nadia**: I'm wondering what the ... just to get super clear on it, what is the Cartesian read of liturgy then or is there one here?

[12:40] **Timothy**: Oh, I mean the Cartesian read of liturgy is, ditch it and salvation is not a recur- , it's not a ... there isn't that recursive element of getting to know Christ, let's say for a Christian. It is just you're saved or you're not. And, at the same time services are just lectures. Right, so that it's just mind to mind. It isn't anymore that sense of that the entire person, body, soul, unconscious, psyche, emotions, everything.

[13:17] **Timothy**: What's the point of worshiping if there's no insense? I mean ... speaking again to Christians or Jews because you know they have a biblical vision that in heavenly worship there's incense. Like if you're not gonna impact the most basic and ancient senses, one of the five senses, then why are you bothering? What are you really doing in the end? So, I think in the Cartesian sense religion is a doctrine. You know it, you assent to it intellectually. Game over. Get on with your life.

[13:55] **Timothy**: Now, that doesn't mean, 'cause this goes back to the final chapter of Death and Life and that's really the crucial chapter that there are three kinds of science that we know how to do. And in two of 'em that kind of Cartesian approach really works. And Jacobs was not an anti-Cartesian at that level. In fact, what I try to say is that she saves the enlightenment because she gives us a post-modern science that respects the role of modern science. The first two kinds of scientific problem solving.

[14:30] **Timothy**: So I think there is a sense, speaking of now back to the theological side, in which you're either saved or you're not, right? There is that digital sense that, you know, binary, yes, no. But, you cannot lose sight of the two other kinds of, scientific problem solving that we have.

[14:50] **Nadia**: What are the ... as I'm just sort of thinking about this, what are the policy implications for taking the more organized complexity approach that she advocates. So like if, we wanna really emphasize that rituals or cities or our spaces around this are built by people, what does that imply about, like in religion what does that imply? Does it mean that we can't have a centralized figure to rally around? Or does it mean that the people should be reflected better in nthe rituals that we take on?

[15:25] **Timothy**: Well, I think I, I ... Can I put in a plug for an article by a friend?

[15:29] **Nadia**: Yes.

[15:29] **Timothy**: It's called, ["An Exploration of Hierarchy as Fractal in the Theology of Dionysios the Areopagite"]. And it's by a friend of mine named Georgia J. Williams. Georgia Williams. And, this word hierarchy was first coined, I mean as a noun, a proper noun like that in maybe the 500s A.D.

[15:54] **Timothy**: And what it meant in the theology of this saint of the early church, Dionysius, was what we mean by fractal. So you kind of just have to read ... you can't dispense with hierarchy, but you have to understand it fractally. And I think, Henry, you were saying that that relates to this whole notion of subsidiarity, which I haven't really read about.

[16:21] **Timothy**: But just to give you an example that I used to discuss with Jane Jacobs in person when I was visiting her and talking to her on the phone, the answer to the currency issue is that we need currencies at many fractal scales. And those currencies should be related ... I mean as you go down the scale there should be more of them covering less area. Like there ought to be in the United States county currencies and state currencies at, you know, 50 of those and then one national currency.

[16:53] **Timothy**: And so, this issue of how you get people involved, first of all, you have to empower them to get involved. You know, to control their own lives like right where they are. But, then of course they will be in these nested networks.

[17:08] **Henry**: Yeah, speaking of [subsidiarity], it's a term from Catholic church. It says it's organizing principle that matters should be handled by the smallest or lowest, least centralized authority. And so all decisions should be taken at the local level if possible and kind of like moving up.

[17:27] **Henry**: So it kind of reminds me of doing things only when necessary or like a lazy way of thinking where it's not everything has to be handled by the people that have the most context around what they're handling. And it even reminds me of a post that Nadia did about foundations and whether open source projects should join a foundation for their own governance and when to add more people and add governance. And it's kind of like do it when it requires it to be happening rather than beforehand.

[17:58] **Nadia**: It's very strange 'cause I get a lot of pushback on ... I have this sort of emerging view about governance related to that post I wrote about foundations that you should be attempting minimum viable governance, like don't over-engineer governance. Do the minimum amount that's necessary to prevent I guess like further conflict. And in some cases you might not actually need to formalize governance at all if everyone is ... if it's a small enough group and everyone's getting along great.

[18:29] **Nadia**: I get pushback on it because people think that's how if we don't talk about ... it, that it can lead to the tyranny of structurelessness of we're not defining governance at all and therefore everyone's kind of running wild and terrible things are happening. I think neither end of the spectrum is great, but the idea that if we over-engineer governance I think it leads to that sort of like Cartesian look that we were talking about of like you just have these objective principles that came from somewhere else besides being derived from the people. And they're not actually meaningful to anyone.

[19:10] **Nadia**: And yeah, that's the part that I wanna kind of try to avoid.

[19:16] **Timothy**: Put in the American context it's tricky because if you sort of speak for this idea of subsidiarity or localism, whatever, then that kind of gets hijacked by the more conservative voice to a laissez-faire attitude about a lotta things, which in practice means that merchants or corporations that have some first mover advantage will dictate structures.

[19:53] **Timothy**: I think it takes work to preserve a genuine local ... and in any case maybe our political discussion in the United States is hopelessly broken because our economics is broken. And unless we really understood why local currencies in the Jane Jacobs vision are so crucial, well then we're really trying to govern ourselves in a vacuum independently of our economic lives and that just can't work.

[20:35] **Nadia**: Right. This has a lot of crossover. Henry and I were talking about this with Elinor Ostrom's work. I don't know if you've also read her stuff.

[20:46] **Timothy**: I've only heard of her from you guys. So that's ... Forgive me for that, yeah.

[20:48] **Nadia**: Yeah, big fan. If you loved Jane Jacobs you should also read Elinor Ostrom.

[20:51] **Timothy**: Okay.

[20:52] **Nadia**: But she I think had a similar methodological approach of trying to ignore ... she was basically trying to resolve the issue of tragedy in the commons and prisoner's dilemma and talking about these sort of game theory approaches that say ... that essentially assume that people are gonna act in their own self interest until they destroy the communities around them.

[21:13] **Nadia**: And she went and looked at fisheries and water management and things like that and looked at these smaller communities to say and using that to make an argument for governance that is highly localized where you retain sort of boundaries of membership and bring context and meaning to the people that are being, quote/unquote, governed and saying that her thesis being that you don't necessarily need to rely on the market or the state or these sort of outside actors to intervene to prevent people from destroying each other. With the right conditions people will self organize and not destroy themselves.

[21:50] **Nadia**: So yeah, there's a lot of I think crossover there around the idea of keeping governance as localized as possible.

[21:58] **Timothy**: Right. But there's some confusion in the American context. It's like the thought that the government shouldn't intervene then becomes, almost becomes then like a spiritual attitude that I shouldn't care about the commons and work in other ways to like you just said there. I mean in a bottom-up organic way to resolve these issues. You know, things just get resolved very simply at some national level of like, oh, should the government or shouldn't it.

[22:31] **Timothy**: But that's really not the point. The point is we have to live in this society in this world and we're gonna have to fix what needs to be fixed one way or another.

[22:40] **Nadia**: Can't see it as like if one end the fear is tyranny and structurelessness where we don't define anything and then strange things come out of it. Then the other end being I guess being like Cartesian government, I don't exactly know the right term for that, but where everything is so objectively handed down from above and it's so hierarchical that it means nothing to people.

[23:01] **Nadia**: Do you wanna talk a little ... I realize we didn't actually kind of break down a little bit the differences between she talks about like simplicity, disorganized complexity, and then her focus being around this idea of organized complexity and I know we touched on it kind of broadly, but, do you wanna like go on a little bit on what those differences are and how she manages to tie these sort of like more scientific methodological approaches to her style of doing things?

[23:31] **Timothy**: Yeah. So, Jacobs starts, with the idea that for her modern science begins roughly around 1600 and the idea that we're gonna have generate falsifiable hypotheses and the experimental method, and really be dedicated to reality and reason. And she says just, the fact of it is that, in the first three centuries of science from 1600 to 1900 in her opinion ... well, I'll say where she gets that opinion from in a second, we could only be one of the three kinds of science and that was what she calls problems in simplicity, which are two variable problems where the dependence of one factor depends wholly on the dependence of some other single factor.

[24:20] **Timothy**: And actually it's just serendipity that when she was writing her Death and Life, through this grant from the Rockefeller Foundation there was a guy there named Warren Weaver, who was retiring after 27, 28 years as head of kind of deciding who got the research money from Rockefeller. Warren Weaver wrote this report on what are these three kinds of science. And that's what she used. And she could show pretty clearly that her opponents were using the second kind of science, a statistical approach. And then looking for ways to reduce it to the first kind of science, the simplicity approach.

[25:05] **Timothy**: And she was, and she just said, it turns out, cities are something else. They're like biological life forms. And they're living organisms. And those two kinds of science are just not appropriate. When you're studying something living you have to use this third kind of science that's only been discovered in the last 30 years called the problem in organized complexity.

[25:28] **Timothy**: And I try to argue to my students that this chapter 22 of Death and Life, and really the Warren Weaver report itself, that report should be governing the university. That every child should be learning those three, that those three kinds of science exist from the time they're in elementary school, but certainly in college. And, we should be very explicit about when we're doing which kind of science. The reductive, the statistical, or the biological.

[26:02] **Timothy**: And, so she's saying, "What I've tried to do in this book is reinvent urban planning as if it were, you know, a species of biology essentially." And then she spends the rest of her life trying to do the same thing for economics, for which, by the way, she's been completely ignored. I mean it's in my estimation because I think she really did reinvent the science of economics. I think she replaced Adam Smith as the founder of economic science.

[26:29] **Timothy**: And, so that's what she's about.

26:38 **Nadia**: That was-

[26:38] **Timothy**: I think I missed the thread though. What was the, the-

[26:42] **Nadia**: When I read Death and Life, that last chapter really stood out to me. It was sort of making these points that were even beyond anything about her thesis around cities but trying to say like there is this other style of approach understanding that we're just ignoring. And having read Elinor Ostrom's stuff beforehand, I think it took a similar approach where something that really stood out to me about Ostrom's work was she specifically said that she wasn't trying to come up with a formula or a model for predicting what the right thing was to do. All she could do was come up with a framework and a set of conditions.

[27:19] **Nadia**: It was very impactful for me to read that because I always feel this sort of tug of ... in my research where people wanna be able to just like predict something. And, feeling like, if I'm sort of observing something or I'm just talking about the conditions or the framework like is that enough, is that okay.

[27:39] **Nadia**: And so I feel like the work of Jane Jacobs and Elinor Ostrom and others, Stewart Brand she mentions in that letter to you, are all these sort of people that are dealing with problems of organized complexity.

[27:53] **Nadia**: One of my questions 'cause you've mentioned a few times that you feel like Jacobs has been, in my world at least she's been largely appreciated and noticed. But, certainly I think your point about her crossing over to economics like her economics work being less appreciated or noticed.

[28:12] **Nadia**: And when I read Elinor Ostrom's stuff, like she got the Nobel Prize for her work in economics, but we still talk about the tragedy in the commons and we don't talk about her framework. And so, I'm kind of wondering from your perspective like why is it that like we see these clear examples of people that are working on organized complexity and making really important points about the world. Why do those frameworks not really seem to hold in our minds?

[28:39] **Timothy**: I think, you know, with this ... we respect, psychopaths for some reason. If you remember like at the end of chapter 22 of Death and Life when she's talking about these three kinds of science, you know, the final meditation is somewhat bitter. She talks about this park in Upstate New York that has been statistically augmented but the production of clay dogs is now no longer possible. Some kind of a natural process on the beach there. And she asks, "What kind of a mind, what kind of a person really was comfortable with this simpler form of order when it destroyed of statistically expanding the park, when it destroyed organic order?"

[29:26] **Timothy**: And I think the academy tends to reward people who do the first two kinds of science and we think that is science. And we think ... and everything that our culture valorizes, you know, power, I think maybe the third kind of science is more feminine and that's one reason why, although it's a higher science, it's neglected.

[29:53] **Timothy**: And, so there's a lot of factors like that where you're just not quite sure why. And then it's partly like the first mover advantage like the other two kinds of science were discovered first. But, the three kinds of science also work ... I mean, let me put this another way. The simplicity science, it's to use the [Socratic transcendentals](https://en.wikipedia.org/wiki/Transcendentals), that's the study of the good in the sense of what's useful, utility. And statistical science is the science of the true.

[30:29] **Timothy**: But organic science is the science of the beautiful. And that was your original point of this interview. You said, "She showed that ordinary people opening their eyes, looking around, feeling, uh, sensing," because what I call organic complexity, it's the beauty first approach to science. And that is the thing that we just cannot accept as a society is the centrality of beauty and that is the thing which the modern period and the rejection of liturgy and worship and all that was supposed to free us from was the bewitching power of beauty. And we were supposed to be truth firsters.

[31:09] **Timothy**: But there's, like I said there's something pathological about that in the wrong context and pushed too far. I hope I haven't been too violent in my statements here. (laughs).

[31:22] **Nadia**: No. I'm sitting here just like, "Wow, that's, yeah, it's, that's really beautiful." I think that you made a quick reference and sort of the idea that being more feminine is it think something I feel really strongly about as well. And that maybe like that is sort of, that we just sort of have a complicated relationship with the feminine, and maybe we're sort of afraid of it or it makes us uncomfortable.

[31:47] **Nadia**: In this context for me feminine meaning sort of like discerning I guess. And, maybe also beautiful. But yeah that sort of like ... the sort of approach that is very observant and sort of sitting back and taking a lot of things in and then analyzing and then putting it, an idea out there is I think fundamentally different from the approach ... the more I guess deductive ... I think of it as like deductive versus inductive, work where and the deductive approach by contrast being more like, "Here's an idea I have and I'm gonna go out and like, like prove or disprove it, kind of in a sort of, um, falsifiable manner."

[32:25] **Nadia**: Maybe when things are a little bit less falsifiable or they're kind of, they're weaving in a lotta different threads in complex ways that it just makes people uncomfortable.

[32:33] **Timothy**: You know the real vindication of the beauty first approach to science and really of Jacobs I think is, although people wouldn't think of this, it's Warren Buffett because all these truth firsters and stock market investing with all their data, you know, I mean they're ... statistically they don't do anything, but they, they command so much information.

[32:59] **Timothy**: And then these derivatives traders, they're your simplicity theorists. I mean many of us sank our economy in 2007 and 2008. Whereas Warren Buffett, I mean he ... that's the beauty first approach to investing. He looks at each business as if it were a living organism. He's asking questions about the health of a company, in such a way. And then, and they he even says that he lets, each CEO work on their, it's their work of art. He doesn't wanna get involved in the management of the company.

[33:30] **Timothy**: And, you know, he's doubling the market rate of return every year since 1960 or whatever it is. And, it's the revenge of Jacobs because what he's doing is the organic, complexity approach to investing.

[33:47] **Nadia**: It's a really good example. (laughs). I would not have thought of that.

[33:52] **Timothy**: You know what's interesting is you know who also was a beauty first investor was Keynes. And, Keyne's, he managed apparently the endowment for Cambridge. I don't think of him much of him as an economist at all, whereas he's more of a simplicity theorist. But as an investor he had the kind of a value investor Warren Buffett approach. And apparently he did very, very well for Cambridge. (laughs).

[34:17] **Timothy**: But yeah.

[34:18] **Nadia**: All right. This is making me wanna try out an idea. And we'll see if I can figure out how to articulate it, 'cause I mean like when you're mentioning these names I think of, "Wow, they, they sort of have been elevated to this like mythological status," and I think part of it is that ... part of what people are so fascinated by is that it seems almost like ... the strategy seems so simple on its surface and yet so hard to replicate.

[34:40] **Nadia**: And, I wonder whether I guess like a ... the simplicity approach is maybe just easier to for people to pick up because it is more objectively falsifiable. Like if, it's something that like anybody can kind of pick up and take on and repeat. So it lends itself to sort of spreading very virally I guess, because everyone is kind of observing it in the same sort of fashion.

[35:08] **Nadia**: Whereas with problems of organized complexity it really is so tied to the lens of the ... if humans are sort of like vessels for ideas it's so tied to the human that is viewing that. And like maybe Warren Buffett can't really, you know, teach someone exactly the way that he sees the world. And maybe that's what makes it really difficult for some of these ideas to spread.

[35:30] **Henry**: Yeah. I think that kind of just ties back into liturgy itself. It's like, it's easy to tell people things that like the ideas in your mind, even if you say them it's do people actually understand what you're saying and I think living that out is a better way of understanding what they're getting at.

[35:50] **Henry**: It kind of even reminds me of the ["Letters to a Young Poet"] that I sent you. Not being out, not being able to like live out the answers and so like the idea is to live out the questions. And I think that's hard for people because we just want an answer and we just wanna figure it out now.

[36:09] **Henry**: And this idea of having patience, I think that's hard for people.

[36:15] **Timothy**: The young can access information but wisdom comes with time because the whole thing about learning and an organic system is that it's gonna get to know you as you get to know it and it's gonna leave its mark on you. So certain things have to just come with age.

[36:39] **Timothy**: You know, there's certain mistakes or regrets that are part of wisdom that just really cannot be skipped. I supposed that skipped with some kind of like, you know, miraculous humility or something. But that's just not most people. That's not me.

[36:57] **Henry**: Yeah, I really like how she talks about how she loves the city and the people that were doing the work before. It just seemed like they had their own plan. And, I like what you said about it being two way. You know, if we were talking about a relationship then it is two-way and I think even with knowing God it's like, it's not just reading some stuff, but understanding the other side.

[37:24] **Henry**: And I've heard this saying where it's like, we don't just read the bible, but The Bible reads us. That, it's not just intellectual, but living it out through liturgy.

[37:36] **Nadia**: Kind of touching this idea of, that you mentioned about wisdom being something that you can't just always automatically transfer. And something I've been thinking about a lot recently is the difference between information and knowledge. And I think it parallels ... I hadn't really put this all together. But, I think it parallels the way Jane Jacobs was talking about, cities being a function of time or, like I think of information as being sort of like artifacts or things that are easily, repable, falsifiable, sort of like a more objective like piece of data.

[38:18] **Nadia**: And then I think of knowledge as being, sort of like the ... maybe there's that sort of like active, collective wisdom reflected by a society that you were just talking about, and sort of like how do we know when we're dealing with one versus the other. Like how do you know when ... I mean and similar even with cities. Like how do you know when you're looking at an artifact versus looking at a piece of knowledge or something that is a living organism.

[38:47] **Nadia**: And specifically for me and Henry, when we're talking about open source like I think about how like code itself is just an artifact. Like there's no requirement to maintain code, if you're just kind of like looking at the code itself. But when we think of code as infrastructure or we think of it as something that someone else is using in their software, suddenly there's like a relationship between the code that I might have published and the code that you're using 'cause it's and now we have this sort of ... now that I think a- , yeah, once you think of code as more than artifact and you think of it as part of, of the living organic infrastructure then suddenly that time function exists because you're thinking not just about right now, but you're thinking about the future and there's sort of like an implied need for maintenance or tending to that.

[39:34] **Nadia**: I don't really know if I have a question. But I guess the question is just sort of like, yeah, how do you know when you're dealing with an artifact versus dealing with like a living organism?

[39:42] **Timothy**: Hmm. I mean, I think really one of the benefits of Death and Life is that we should appreciate the Cartesian approach. We should appreciate these reductive approaches. I think we should learn to, in our schooling to get good at each. And so I don't think it's ... Like Jane Jacobs is a holist, I would say. She's holistic, but she's not a holistic who dismisses the reductive. And it's really only in the right, in the light of reading that book, Death and Life, that I can speak of, you know, a reductive approach in a positive way.

[40:23] **Timothy**: Like sometimes you need just that simplistic, I mean, either the electricity is working or it's not. I mean there's certain situations, right? But having said that I hope that to answer your question, Nadia, that I hope it makes us feel like, we can have our eyes open for when things might be, you know, acting in unpredictable ways. (laughs).

[40:51] **Timothy**: Where the whole is greater than some of its parts. Or, just in the case of software where it would really benefit from the plans and dreams of many people coming into play around it.

[41:06] **Timothy**: I don't know if that's a ... That's not a great answer, but whatever. (laughs).

[41:10] **Nadia**: Yeah. No, I think it's ... well and, and it keeps making me come back to that, the function of time that you were talking about of ... because there's cer- , that and the sort of like implied ... or what I'm hearing and what you're saying is there's once you're sort of in a relationship with something beyond just that objective thing and there's sort of like a second order thing that happens.

[41:31] **Timothy**: Yeah that's, and it's really nice the way some people seem to do that even like for their machines or for, or ... I mean and the equi- , in an equivalent way like how some people can do it with like with a very young child, which to my mind, you know, there's no personality or there's very little or something. I don't, wouldn't know how to relate to it, but someone who knows the child is able to see the more and bring it out.

[41:58] **Timothy**: But like you said, it's second order effects. I think that's a better answer than anything I would've given. I think that's ... when you see these second order effects at work then you're like, "Uh-oh." You know, "What's going on here?" Now there's not gonna be a Y, a linear connection between my acting on this things, what comes out the other end.

[42:16] **Nadia**: Right. I think that is what was really nice about Jacobs wa- , Jacobs is (laughs) and, perception of this world is ... like I think of her as sort of like taking all this sort of like objective pieces and then weaving them together into something that like the sum of all the parts is its own organism. Or it is it's own way of understanding it.

[42:37] **Nadia**: But like each of those pieces still exist as their own thing. Like a road is just a road. But a road when people are on it is now like, becomes a problem of organized complexity. Um, and so she's not saying that the artifact is transforming into something living, but more that it is now participating in a system that is a separate thing.

[42:56] **Timothy**: That's a good point. Yeah. And now it's, and now it will ... like, I think sometimes they call 'em [desire lines] in cities [inaudible 00:43:05] purposes.

[43:06] **Nadia**: Yes.

[43:06] **Timothy**: Like, "Hey, okay. This thing is ... ," essentially a ritual has made that rode and the ritual is everyone is, you know, going that way. That's the way that makes sense. It's collective wisdom. You know, that's how, that's how we're gonna get across campus so let's put the road there. You know?

[43:25] **Nadia**: How do you think about those religious rituals evolving over time because like in my participation in religion I find sort of a comfort in doing something that I know other people have done for centuries or millennia (laughs) before me. But at the same time then, you have these sort of desire lines where, like what if we wanna kind of shape it into something different and how do you know when it's right to shape it into something else versus like it's right to feel that connection to your ancestors or whatever?

[43:52] **Timothy**: It just it's very hard to shift. You know, it's hard to invent something, a new ritual that will catch. And, um, so the sign that it should catch is usually that it has caught and, something ... it, you know, it's, it's kind of the collective affirmation around it that, you know, lets you know that, "Okay, this is ... I tried it and, uh, other people caught on and here we are."

[44:21] **Timothy**: But, yeah, I think, yeah, that that feeling of antiquity ... By the way in Boston at the Emmanuel Gosp- , there's something called the Emmanuel Gospel Center and it is the do Urban Christian Ministry, but their whole approach is this, organized complexity approach and I'm trying to find ... oh, I just remembered the name of their book. It's something like, ["The Cat and the Toaster"]. And, it's or The Toaster and the Cat or one of those.

[44:51] **Timothy**: And it, the question is if you're dealing with are you dealing with a toaster or a cat? You know, ... and that has to do with time. Can you take it apart and put it back together? It's a toaster. If you take it apart are you, do you belong in jail? That's a cat.

[45:07] **Henry**: (laughs).

[45:10] **Nadia**: (laughs). That's a good thesis. (laughs).

[45:11] **Henry**: (laughs).

[45:12] **Timothy**: It is. (laughs). And that's the Emmanuel Gospel Center, like you should see what they, like what they'll do for homelessness, for example, is they've got like, my gosh, a whole metabolic pathway of how, it's not just some linear you're homeless or not. It's this whole ... you know, it's like how close are you to being homeless? How much resilience is in, is there in your life now? What's separating you from homelessness? And then what are the, what's like the metabolic pathway by which a person becomes street involved and what keeps them there, what gets them out. And it's really like, you know, your biology, your high school biology textbook and you look at what they've done and you think, "Ah, yes. Now we're talking. Someone's thinking." Jane Jacobs was like this. (laughs). She really was. (laughs).

[46:04] **Nadia**: And what was cat toaster toast, I'm just thinking about it now. (laughs).

[46:07] **Timothy**: And, the thing about the antiquity of liturgies or rituals is that they are cats and not toasters. So the idea that you could take them apart and put them back together, unless in putting them back together you do hit up, hit upon the ancient patterns. I mean the perennial, not ancient in time, but the timeless forms. Just not gonna happen. You know, it just isn't gonna happen. They just, they won't, they won't survive the transition. You'll lose your, your church or religion if you do it wrong. It'll just, it'll just go away underneath you.

[46:45] **Nadia**: Here's something I'm sort of wondering about. Going back to sort of like the recursive fractal nature of organized systems. There's this, I can't even really remember where it comes from. The whole idea of like paper, [paperclip maximization] where like you have a factory that's making paperclips and then all it knows is to make paperclips and then it sort of just like, it's so focused on the thing. (laughs). And you end up just sort of like destroying everything for the sake of paperclips.

[47:10] **Nadia**: Yeah just trying to think a little bit about that like maybe symbiotic relationship between systems of organized complexity but also respecting the more objective, and like how do you know when a system is trying to optimize for something and everyone is kind of talking it through and then but like it's taking us into like a worse direction in some shape or form.

[47:32] **Nadia**: Like how does that system self correct? Does, do we trust that ... can, will the people, quote/unquote, the people like always end up in doing the right things for themselves within their own bounded system or does sometimes like is out- outside intervention required.

[47:47] **Timothy**: Yeah, I mean outside from where though? I mean, you know.

[47:52] **Nadia**: Right. (laughs).

[47:52] **Timothy**: (laughs). You know, we are the outside. I think for Jacobs we are the outside in the sense that we're, we can think and we can make up, we can innovate. So we've got to be, you know, at it. But yeah, systems, you know, get, essential- functionally addicted and then it just, you know, crush themselves.

[48:10] **Timothy**: Well, you know, Jacobs had those, something very hopeful about that and, and I don't know if this relates to religion or open source or what, but she said she thought that if you looked historically at economies that had declined the way the linergy, you know, she didn't use that term, but the way the linergy failed there and then of course the cities failed as a result, was an increasing proportion of the work was being done by slaves. That's how she puts it.

[48:39] **Timothy**: In other words people who were not free to develop their own work, to resolve the problems and innovate. And, what's interesting about that is that as our society gets richer the definition of slavery functionally, I mean it, to make this liturgy work is the standard is rising.

[49:01] **Timothy**: In other words I think slavery for us, what's hurting our economy is that your healthcare is neither guaranteed by the government nor portable. So no, people can't leave their job because they're gonna lose their healthcare. Or it could be regulations. Or maybe in Silicon Valley it's at such a high level of development that slavery is I can't bring my dog to work.

[49:25] **Nadia**: (laughs).

[49:25] **Timothy**: And, (laughs) I think there is a sliding scale, in her terms. And so that's what's crucial is the work being done by slaves or is it being done by free people. So that's her thing.

[49:43] **Timothy**: So it could be just the security of a unioniz- , a well paying unionized job in Detroit that is the slavery. It's not a real slavery, but I mean it functionally you can't leave now. You just can't imagine stepping away from it to start your own, take your own risk or work for a startup.

[50:03] **Nadia**: Or and also like the idea that, for me like a very important, I don't know, organizing principle is just really like maximizing, access to opportunity and so, yeah, if like, if slaves ... quote/unquote slaves, if they can't participate in the system or they're not actually part of this organic, the organic system that is affecting them but they can't actually participate back in it then something is not working correctly.

[50:28] **Timothy**: Right. And you think, okay, opportunities for women, immigrants, the banking system and there's just ... the fact that somehow public education isn't really working well. I think, that this is a lot of areas where you can say we've got to raise our game but I don't know what the limit to that is.

[50:50] **Timothy**: You know, as Jane Jacobs said somewhere, from the time we invented fire we've been riding on the back of a tiger and we can't get off. And we're just gonna have to (laughs) go further. I mean obviously, right, at some level the Protestant Reformation, you know, was a political ... had a ... a political thing, but it was about liturgy in that sense.

[51:15] **Timothy**: What is, what are the lay people doing and what role are they playing in their own religious life? And Printing Press and scripture and all those things. I mean, there was some kind of a sense now this, we can recapture the, the meaning of liturgy here.

[51:34] **Timothy**: Of course, I'm sure when we Catholics look at it from a different perspective. But I'm just saying that it is, there's some commonality there. My book, The Ethics (laughs) of Beauty is coming out this summer from, St. Nicholas Press in Missouri and, the final chapter is the Jane Jacobs chapter. So you can skip the rest and go straight to that.

[51:59] **Timothy**: But, um-

[52:00] **Nadia**: Fantastic.

[52:01] **Timothy**: But there is something else, in there and it has to do with I think we need to think about in terms of the three kinds of science we need to think about information in terms of its quantity, its potency, and its quality. And I think that its problems in simplicity gives us really potent information. And its statistics gives us high quantity. But only organic complexity gives us quality information and I try in the book to define what I mean by quality. But I think, the old definition of wisdom is something like ... or being wise is to have a preference for high quality over high quantity or high potency information about other people, about situations, about systems, you know.

[52:58] **Timothy**: And obviously, one thing about the internet is a flood, it's a high quantity information and then some people are trying to mine that in potent ways to sell or control. Merchants and traders. But the challenge of being human is to learn to prefer whenever possible high quality information, right? We should be reading more poetry as we get older. (laughs). At some, point. (laughs). There should be reading more of The Bible. Reading more of, you know, the ancient wisdom texts.

[53:35] **Nadia**: More fiction too.

[53:36] **Timothy**: More fiction. Yes. Yes.

[53:40] **Henry**: Yeah, in desiring beauty what is it that we can say or do that helps us be captured by a spirit of awe and wonder like Jacobs' love for the city. Makes me think of how we seek God in intimacy. To seek a who rather than a what.

53:53 **Nadia**: Thanks for listening. If you'd like to continue the conversation, you can find us on Twitter at [@left_pad](https://twitter.com/left_pad) or [@nayafia](https://twitter.com/nayafia) or on our website [hopeinsource.com](https://hopeinsource.com).
