---
title: "08: Authority and Leadership"
season: 1
date: "2018-10-16"
time: "26"
description: Does authority have a place in religion? We talk about authority in decentralized organizations, listening to others versus trying something new, and when to fork or leave a community.
episodeLink: "36c194d2"
embedUrl: https://share.transistor.fm/e/44735894
sidebar:
    order: 8
---

## Links

- Universal Priesthood: https://en.wikipedia.org/wiki/Priesthood_of_all_believers
- Exit, Voice, and Loyalty: https://www.amazon.com/Exit-Voice-Loyalty-Responses-Organizations/dp/0674276604

## Transcript

> Conversations may be edited for clarity. [(edit)](https://github.com/hzoo/hopeinsource.com/edit/master/season-1/authority.md)

[00:00] **Henry**: Alright, this podcast, we're gonna be talking about governance, leaderships, authority. And I know the [last podcast](/myth) we talked a bit about narrative and it ended up being a discussion about people and kind of the stories that we talk about for people, it was interesting. Just think about maybe the role of authority in general, especially in terms of faith. I think it's interesting, 'cause in, in most religions you know, you're submitting to you know, not just maybe it's rules but you know, a God or a person and that's inherently about the authority.

[00:31] **Nadia**: Yeah. We, we just started talking about this and realized I think we kind of have different views on the role of authority in religion. Um, because I guess my closest like interactions with religion have been [Quakerism](https://en.wikipedia.org/wiki/Quakers), and I think Quakerism is like weird within Christianity, if I understand correctly and that it is a little bit more anti-authority, um and so like my takeaway from having spent time in like Quaker communities has been like question authority (laughs) and, and trust yourself and like just a very like [Socratic way](https://en.wikipedia.org/wiki/Socratic_method) of looking at the world.

[01:01] **Nadia**: Uh and so I would say like not, I don't, I don't think that the idea of authority is inherent in religion or if it is like, again, there's an idea of a higher, there's always an idea of like, well is it a higher power or just sort of like ... like I think of it more as like a power that binds us. Um, like a human spirit, but that's sort of different I guess from like other religions that are much more authority oriented than say like you know, you are submitting to God or you are ... but yeah. I don't know if it's just sort of like a metaphor for the same thing, like I think I submit to the idea of great- something a concept that is greater than myself, but I'm not submitting to an authority as a sort of like anthropomorphized figure.

[01:42] **Henry**: Okay. Makes sense. I guess even in Christianity, I mean, you can say that like our authority is Jesus as a person, but I understand what you mean by like, this idea that like God is in us, and I guess that's different from like, you know you could say like we could think about like the Catholic Church versus like Protestants and like that's very hierarchical, and like the Pope is like the main like one person. In Protestantism, there's this one idea called the [Priesthood of All Believers](https://en.wikipedia.org/wiki/Universal_priesthood), and I'm pretty sure that might be what you're talking about um, for Quakerism.

[02:17] **Nadia**: What's that?

[02:17] **Henry**: And it's basically claiming that there's this idea of a priest, which is you know, it could just simply just say it's someone that could talk to God or speaks to God and that we would say that we don't, we wouldn't divide like if you are a priest, like the position of a priest versus like a layperson. Um, and that because, we would just say like you can talk to God directly or that God lives in you or that God thing. You don't need someone else to be between you and God.

[02:52] **Nadia**: Yeah, that's super Quaker 'cause like they're in, at least in the Pennsylvania interpretation of it, I've learned that's not true, but like, yeah. There's no, there's nobody leading the congregation. Like, you go to meet worship and anyone can stand up if they feel moved to speak, and just that concept I remember was like really influential for me growing up 'cause I was like oh, no one needs to organize this. No one needs to lead this. Like, if I feel moved to speak, I can stand up and now I am leading it and that was like really empowering for me to think about.

[03:21] **Henry**: Yeah, and this was like not, that's well, obviously maybe there's different like ways of thinking about it, but that idea isn't specific to Quakerism, I think. I mean, I think I just read about it (laughs) in, in one of the passages of the Bible, where it talks about ["you are a royal priesthood"](https://www.biblegateway.com/passage/?search=1+Peter+2%3A9&version=NIV). So it's just talking about how you know, basically what we just said. And so, like before in the Old Testament, it was like okay, priests have to act as like a mediator between God and the people you know, like and He would have to like sacrifice things or you have to go into this you know like holy place and then they represent the people.

[03:57] **Henry**: Um, and then after- well this is specific to Christianity, but like after Jesus came in, we would say that everyone has the [Holy Spirit inside of them](https://en.wikipedia.org/wiki/Holy_Spirit_in_Christianity#Procession_of_the_Holy_Spirit), and it's like that way, you know you don't have to like go somewhere. When we talk about people having to go into this like [holy tent](https://en.wikipedia.org/wiki/Tabernacle) or something, we would say that you are the tent, or ["your body is a temple"](https://www.biblegateway.com/passage/?search=1+Corinthians+6%3A19-20&version=NIV) or I don't know if you heard that phrase before, but yeah. The idea that like, um you don't need this other authority figure to talk to God.

[04:31] **Henry**: Um, which is interesting and I think like when you said Christianity isn't like- I think it's kinda both in my view. Like there's authority in that I would say that we should submit to God when there's an idea you know surrendering your will to His kind of thing, and growing into His you know, we would say like image or likeness. But at the same time um, that's more of the we submit to a higher power thing versus like submitting to a person, you know like the Pope or someone here 'cause we would say that because God is perfect, we should submit to Him but other people, we should all, we should learn from them, but they're all like, they have flaws right, were not perfect.

[05:18] **Nadia**: Yeah, it's sort of this um, yeah. Sort of like I guess it just feels a distinction between are you, like I guess rejecting the idea of authority and religion because you're not a human or whatever. Some external thing is not the right authority that you should be submitting to, but in the end, I guess like isn't everyone ... like I mean the concept of religion is being moved by some sort of spirit, and I think that's true for I mean even like Buddhism or religion that really don't have so much of like a central kind of like authority, but there's still this sort of implied idea that you're submitting to some feeling that is like moving you in some direction and like that is still authority, I guess although the term authority doesn't, I guess I was thinking about this in relation to open source as, [intrinsic versus extrinsic motivations](/motivation).

[06:11] **Nadia**: Or mostly just intrinsic motivations of like are you when you do something for an open source project, like I mean, we often sort of gravitate towards there's maintainers who are holding the vision of the project. There's the people who like might be the original authors, and so there's some like individual person that you're probably kind of looking to for guidance um in, in what you should be doing in the project but like ultimately, if you take the most like literal definition of an open source project, it is totally like this decentralized thing that like, if you can persuade people that you wanna do a thing then you can do the thing.

[06:49] **Nadia**: But like being guided by your own intrinsic motivation to contribute at whatever level feels right is sort of like, the ultimate authority that you're submitting to or letting yourself be guided by. Like you're not being, you're not necessarily being guided by the maintainers, you're being guided by like what do I feel most intrinsically motivated to contribute to this project? And that's I think sort of the equivalent of like, a spiritual motivation.

[07:18] **Henry**: Hm, that's really interesting. Yeah, 'cause that in terms of like the faith side, that reminds me of like kind of you know, doing things for approval or performance of like kind of ... you could say I wanna get God's approval, so you're gonna do X, Y, and Z. And it's like, or is it like you're just doing it because you think it's good? And I guess that's similar to open source.

[07:44] **Nadia**: I don't think anyone has to accept your contribution if they don't like it or they don't want to, but I think you have the right to be moved by whatever you're moved to at least try to contribute.

[07:54] **Henry**: Yeah, 'cause then it's um, I know that most people think religion is like a bunch of rules and that obeying them, so it's more of like a, it seems like an external thing. Like, I want to obey these rules so I'm gonna do it. At least in Christianity, it's um, a lot of it is recognizing what God did for us and then if He's showing us love, then we show love back 'cause He's shown us love first. I mean, in that way it's, it is more of an internal thing or it becomes an internal thing, so before I wanted to do good things to obey laws or because I think that that will give me something, right? And then if later, then it's like okay, if I've been showing love then I wanna give that back. I think I mentioned this before, but like the idea of like you're filled with love and so you wanna like overflow and then you kind of um, do it out of just internal like your heart.

[08:54] **Nadia**: Yeah. It's um, I was just thinking it's hard to, it's hard to really know sometimes what you're, why you're doing the thing or sometimes you think you're doing a thing for all the right reasons, but you're not. (laughs)

[09:04] **Henry**: That is very true. I think it's really um, I think that kind of speaks to just you know, how there's all, there could be a huge gap between like what we believe and what we think and then what we actually do. This is kinda unrelated.. but we could talk about like serving too, uh 'cause were talking about authority and like leadership and I would say that the leader of Christianity is Jesus, and for even people that aren't religious, they know about stories about him, and I think it's interesting that it's somebody that claims to be God or is a quote unquote like you know, people that some of that people look up to.

[09:46] **Henry**: And He lived his life in a way that um, sacrificed for people so I think that's really interesting as a leader, where you know maybe most people think that you know when you have power, then it corrupts or it's hard to kind of or you wouldn't help other people, but what He did is he helped people that, needed help and he did that by you know sacrificing himself uh by you know, of being like you know representing the people and all that stuff. But ultimately, in terms of Christianity, He sacrificed Himself on the cross too, and so I think in terms of like leaders and kind of listening and all that, I think it's really interesting that our, our biggest example is someone that kind of gave up uh everything even though He had it all, and I think that's a really good example to live by.

[10:48] **Nadia**: 'Cause I still think there's this question of like, how do you balance this idea that like I'm doing the thing that I feel I absolutely have to do because it comes from this like intrinsic motivation. I'm balancing that against the need for like coordination, especially as like a movement or whatever, as a community grows. Um, so like yeah. I mean, Jesus is your canonical example of someone who was at the time, defying everything to do something he really, really believed was right and because he was moved by God or however you wanna interpret that. Um, but yeah. If you're coming into something that is like by definition, like because he started the (laughs) like he was doing something that like no one else around him was really doing, right?

[11:36] **Nadia**: He didn't have to like coordinate necessarily with anyone, but if, if you're coming into a community and you want to do, and you're coming in with like your own intrinsic motivation that was like I think this is the thing that I am, should most be doing and I think like to me, personally like that's the kernel of, like spirituality that I personally feel is like whenever I, I like see or feel that from someone that like, they're like really obsessed with a certain idea, like to me that's like spiritual evidence or whatever. Um-

[12:09] **Henry**: Mm-hmm (affirmative).

[12:09] **Nadia**: But but yeah. What happens if what you wanna do is like not at all what, like does not at all match like what the community actually needs or what you should be doing? Um, and like yeah. How do you balance this thing of like, well I feel so moved to do it inside of me versus like yeah, but can you look at what everyone else around you needs from you? Um, and yeah. Which, which is the authority that I guess that you submit to? Is it the, like the thing inside yourself or is it what other people are trying to tell you? Um, and like other people. Does that make sense?

[12:43] **Henry**: Yeah. Yeah, so you're saying like maybe you have this desire to make some change but the community around you might not see that or or even seems opposed to that.

[12:58] **Nadia**: Yeah, I mean I think this is like the fine line between someone being really inspiring as a leader versus just kind of being a crazy person, right?

[13:06] **Henry**: Right.

[13:06] **Nadia**: Like and like, I think we can, we can kinda like feel that difference sometimes, but honestly sometimes crazy people are just people who like or sorry, the other way around, sometimes leaders are people who are just like, crazy people who happen to get enough people to believe in them, so how do we really know what the difference is? And as like a leader, how do you encourage someone who might be really enthusiastic to do something for you or for your community? Um, how do you encourage them to like follow your heart while also being like yeah, but don't do that? (laughs)

[13:36] **Henry**: Yeah, um-

[13:38] **Nadia**: Like have you ever gotten a contribution that you didn't really want, but someone was really enthusiastic about?

[13:43] **Henry**: Oh, yeah. I guess all the time. (laughs) Definitely. I think you know, they might be really enthusiastic but then that wasn't part of your vision or maybe the opposite thing or they misunderstood what the issue was and you have to kind of tell them that you appreciate their effort and the contribution, but you don't, we might not necessarily merge for a change. And I think, okay in terms of that then, it makes me think that the way we might go about doing that is you know, we do want to inspire people instead of just telling them what to do, and it reminds me of this, I guess it's about authority, where we say we don't wanna like divvy up the tasks or kinda give away necessarily like those kind of tasks, but we wanna give away authority because giving out tasks is not inspiring. It's like hey, can you just like, look at these issues or something instead of like hey, I'll give you this role and I'll give you access on getting up to be able to like label things or whatever. Having a sense of responsibility in that and inspiring them to be like hey, they if, they are giving me ownership over this and I should, I should take that.

[14:49] **Nadia**: You still need to like trust someone to give them that authority, right?

[14:52] **Henry**: Definitely.

[14:52] **Nadia**: And trust is found by I think there's some level of expectation of coordination or alignment, which is somewhat antithetical to the idea of people following whatever they wanna do, I guess. I mean, a little bit pedantically philosophical right now, but (laughs) may, maybe I've been thinking on like two different levels of contribution. Like one is someone could turn their back to the project. Maybe that's not the, the right analogy. Maybe the analogy is just like someone who feels like they have a mult-, uh like a fundamental difference um, between them and the project and then they go off and [fork](<https://en.wikipedia.org/wiki/Fork_(software_development)>) it, right? And maybe that is, I mean we were talking about this a little bit with um like how different [branches and sects of Christianity](https://en.wikipedia.org/wiki/List_of_Christian_denominations) are formed, where yeah. Maybe if you're just not down with the whatever form of Christianity is around you, then you go off and you start some other version of it. Um, and that's the answer is like if you feel that strongly about it and you can get other people to believe you or follow you or whatever, then you just, that's why we have forking.

[15:55] **Henry**: I feel like for that that it's like, you have to really (laughs) believe in whatever that is, and I think about someone contributing and they're like oh, I don't fundamentally agree with what you're doing and they probably wouldn't make a pull request and I think most people don't care enough about any project to want to decide to become an open source maintainer, and that's probably why we don't have a fork for that, that often, right? 'Cause it's like you get it, I mean unless you're willing to put in all that time and then eventually get more people, it's just, just seems like a bad idea and I guess-

[16:31] **Nadia**: Well, even like semi-private forks I guess are kind of a solution to this, right? Where like I guess originally I was thinking in terms of forks of like yeah. Massive, new projects being started or something, but there's also a lot of people who would just say alright, that's fine. I'm just gonna fork this and do my own version of it over here. Um, and that's okay, right? Like they're not trying to get everyone to follow them. They're just saying well, I'm gonna go do it this way which is I guess equivalent to saying like maybe don't agree with everything the church tells you you should be doing, but privately you just practice it differently and you just don't really talk about it.

[17:04] **Henry**: I mean, I guess that's just in some sense, that's everybody, right? Because we all have-

[17:07] **Nadia**: Right. (laughs)

[17:07] **Henry**: There's probably um, small things that probably doesn't even come up and you just, you just believe something different and I guess that's why, a lot of places they, they kinda have those explicit core I guess beliefs or something so that we all, we can all align on like things but then all these other, hopefully our secondary issues it's kind of you have, you just give people the liberty to believe in those things 'cause it's not as important.

[17:36] **Nadia**: And there's, there's like a weird cool thing that happens there that's sort of like a, a silent movement sometimes. It's like, like when the [Overton window](https://en.wikipedia.org/wiki/Overton_window) allows for us to talk about some taboo thing, like a lot of people might privately believe that the church does not or whatever in the example, um like the, the dominant mainstream view is like not okay and would, I'll just go practice this by myself, and then you suddenly realize like enough people are doing that by themselves somehow and I don't really know how that happens, but everyone just sort of like senses that or you have enough private conversations that start building into something bigger, um and then that's enough to sort of like force this massive change, but it's not a change that's happening. Like, that conversation isn't happening in public.

[18:20] **Nadia**: It almost seems like it comes out of nowhere, but it had been silently building for a long time. And I think it happens a lot with like leadership change in open source, too where like it seems like this thing where it's like oh, I can't believe this person is stepping down or leadership change in general, right? But really those conversations had been happening for a long time quietly and then it's like yeah, this is, it's like everyone has been maintaining their own private version of what they believe and then you kinda all realize that and then kinda can quickly effect change.

[18:49] **Henry**: Yeah. I guess in terms of both like faith and open source, what that tells me is that you should be having those conversations in public because it sounds like we're gonna have them anyway in private and it just kinda bubbles up, and then eventually it just feels like it was like a one day, everything just happens uh and then I think that's why especially in church, we encourage people if they don't understand something or if they disagree, we should talk about it.

[19:16] **Nadia**: Yeah.

[19:16] **Henry**: And I think that's better for everyone because then a lot of times especially in faith, right and I don't think it's any different with open source, people don't really understand why they believe what they believe, or they forgot about it because it becomes just like a what you do. I think that's important.

[19:34] **Nadia**: It's hard to I think create the environment where people feel comfortable. I guess depending on what the topic is, but yeah. Like it would be really, I don't know ...

[19:42] **Henry**: In a reality, I guess that's how it plays out. I would hope that that's the environment that we're trying to create, you know whether in a church or in open source that people are free to do that, and I think for that kinda goes back to I think a few things I would think about is you know humility that you know we don't, we don't really know what we're doing and, and not, and that we should tell, tell ourselves that we're not perfect and we don't know everything, especially as leaders um, so whether you're a leader in the church or in open source, to show that to people. Um, 'cause then I think they're more willing to talk about it because then they're, they're not gonna be like oh, this person's gonna shut me down. Um, and even like I think we mentioned before like vulnerability of like hey, I'm struggling with these issues too or-

[20:28] **Nadia**: I think it'd be h-, hard to, like I wanna believe that that's how things could work, but I think it could be really hard to structure like massive cultural shifts in public and I don't really know why that is. I don't know if I'm just being cynical about it or something (laughs) um ... but like it's, I think it's almost because yeah. If you're leading something, if you're leading the status quo and someone asks you, even if it's an open, honest conversation of like well why do we do this this way? And like you're, you're gonna probably try to come up with an answer I think and you're gonna try and explain it, and even if that, that explanation isn't even like the right one, like your job is to sort of like preserve the status quo and keep people together and keep people feeling like they're, and so it's, it's hard to like if you have a serious difference in opinion or view of how the project is being run, like, like I feel like it's almost like, this is very cynical maybe ... but like it's sort of like HR companies or something where like yeah, technically they're the department that's supposed to help you sort out problems, but like their job is kinda to preserve the status quo. Um, and so it's, change is never really gonna happen in like the full open.

[21:40] **Henry**: Yeah, I guess that would assume that that change is good in the first place, right? Um, and then also that I mean, if that's their job then then that means it's their job to help that person and find out like, do you still wanna be a part of this project if this is a fundamental difference? And if this is how we decided that this is, this is the view then maybe they should do a different project. Um, if it's that important. If it's not, then you can just talk about it and be like hey, you can believe that. That's fine. I guess it depends on what the issue is really.

[22:14] **Nadia**: Yeah.

[22:16] **Henry**: Um, and then it makes me think also that another important thing is like the idea of like commitment and staying as a part of something for a long time, right? So if it's an open source project, like you know if that difference is ... you can't even let it go but you still have a, a different view it's because you believe that I wanna be a part of this for the long term and it's okay that we have that difference. Same thing with the church, right? You're gonna, maybe you're gonna stay with that for years or your whole life or something. Um, and it's fine. Otherwise, yeah. You would find a different church.

[22:50] **Nadia**: Mm-hmm (affirmative). It's true for relationships. I mean, these are organizational relationships, but I think individual ones, too. How do you know how much you're just gonna grow with some, someone or an organization or whatever, and how, when do you know that like there's just a difference and you need to kind of work or move away or whatever?

[23:11] **Henry**: And I think it's funny, 'cause like you can think about it in terms of like marriage or even family. Like, we- it's funny with family. You can't really run away, but then you end up with all these differences, right? Um, and then you have to deal with them. And it's funny thinking about like church or open source where you have that choice so then it makes it easier to kind of leave, but maybe it would be better if we worked it out. Kinda depends, though.

[23:40] **Nadia**: Yeah I mean, it's, they're very like- I don't know. I mean, some people's relationships with open source projects is like family of just very deep, long, sometimes like multi-decade relationships that, can make it really hard to leave, even if you have strong differences of opinions or views or people's behavior.

[24:02] **Henry**: Yeah, I guess that's not unlike church too, 'cause I'm sure that's the same. I mean, I guess since we're talking about you know relationships and authority and community, it's just in the end, it's just a complex subject. It's not like you have there is no like right answer per se, right? It's kinda like all depends on the situation 'cause you're dealing with people and like you know, should you compromise on this thing or should you leave? Should you stay? Should you argue about it? Should you just you know, wait? It's not easy to figure it out.

[24:38] **Nadia**: No. I think it's ultimately just going back to the beginning of like you gotta do whatever is that like intrinsic desire and some, and I guess there's just like a lot of different options, right? Like you can use that to try to affect change within the community or you can use it to kind of divert, go somewhere else either by yourself or with other people.

[25:01] **Henry**: Yeah. And I think it's like you know, I could be wrong and then I could be right and I think having this I feel like if you're going for the long term, then you're willing to work with that person. Like, if you, if they are family then you're willing to work through that whatever that issue is, right? Otherwise, you would just cut off or or something.

[25:24] **Nadia**: This actually reminds me of the uh, what's his name? The [exit versus voice thing](https://en.wikipedia.org/wiki/Exit,_Voice,_and_Loyalty). It's kinda this, right, like you can ... in, in any like political organization or society, I guess but this also applies to everything else we've been talking about. You can either yeah, use your voice to affect change internally or you can exit if you're unhappy. Thanks for listening. If you'd like to continue the conversation, you can find us on Twitter at [@left_pad](https://twitter.com/left_pad) or [@nayafia](https://twitter.com/nayafia) or on our website [hopeinsource.com]
