/*
 * Copyright (c) 2020. Frankie Fan.
 * All rights reserved.
 */

import {Component, OnInit} from "@angular/core";
import PerfectScrollbar from "perfect-scrollbar";

declare const $:any;

//Metadata
export interface RouteInfo {
    path:string;
    title:string;
    type:string;
    icontype:string;
    collapse?:string;
    children?:ChildrenItems[];
}

export interface ChildrenItems {
    path:string;
    title:string;
    ab:string;
    type?:string;
}

//Menu Items
export const ROUTES:RouteInfo[] = [{
    path: '/dashboard',
    title: 'Dashboard',
    type: 'link',
    icontype: 'dashboard'
}, {
    path: '/analysis',
    title: 'Analysis',
    type: 'link',
    icontype: 'blur_circular'
}, {
    path: '/statistic',
    title: 'Statistic',
    type: 'link',
    icontype: 'bar_chart'
}, {
    path: '/dump',
    title: 'Dump',
    type: 'link',
    icontype: 'history'
}
];

@Component({
    selector: 'app-sidebar-cmp',
    templateUrl: 'sidebar.component.html',
})

export class SidebarComponent implements OnInit {
    public menuItems:any[];

    isMobileMenu() {
        if ($(window).width() > 991) {
            return false;
        }
        return true;
    };

    ngOnInit() {
        this.menuItems = ROUTES.filter(menuItem => menuItem);
    }

    updatePS():void {
        if (window.matchMedia(`(min-width: 960px)`).matches && !this.isMac()) {
            const elemSidebar = <HTMLElement>document.querySelector('.sidebar .sidebar-wrapper');
            let ps = new PerfectScrollbar(elemSidebar, {wheelSpeed: 2, suppressScrollX: true});
        }
    }

    isMac():boolean {
        let bool = false;
        if (navigator.platform.toUpperCase().indexOf('MAC') >= 0 || navigator.platform.toUpperCase().indexOf('IPAD') >= 0) {
            bool = true;
        }
        return bool;
    }
}
