/*
 * Decompiled with CFR 0.152.
 */
package com.jpcap.mitm.service;

import com.jpcap.mitm.dao.GenericDao;
import com.jpcap.mitm.entity.Domain;
import com.jpcap.mitm.utils.PingUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class NsLookupService {
    private static final Logger logger = LoggerFactory.getLogger(NsLookupService.class);
    @Autowired
    private GenericDao genericDao;

    public void nsLookup(String filterDomain) {
        String[] domains;
        if (StringUtils.isEmpty((Object)filterDomain)) {
            return;
        }
        this.genericDao.clean(Domain.class);
        for (String domain : domains = filterDomain.split(",")) {
            List lookupedDomains = PingUtils.lookup((String)domain);
            this.genericDao.insertAll(lookupedDomains);
        }
    }

    public List<String> getAllIps() {
        List allDomains = this.genericDao.findAll(Domain.class);
        ArrayList<String> ips = new ArrayList<String>();
        for (Domain domain : allDomains) {
            ips.add(domain.getIp());
        }
        return ips;
    }
}

