/*
 * Decompiled with CFR 0.152.
 */
package com.jpcap.mitm.service;

import com.jpcap.mitm.analysis.HttpContentTypeEnum;
import com.jpcap.mitm.analysis.IAnalysisRealm;
import com.jpcap.mitm.analysis.arp.ArpAnalysisRealm;
import com.jpcap.mitm.analysis.arp.ArpPacketModelFilter;
import com.jpcap.mitm.analysis.http.EncryptedHttpsAnalysisRealm;
import com.jpcap.mitm.analysis.http.HttpAnalysisRealm;
import com.jpcap.mitm.analysis.http.HttpPacketModelFilter;
import com.jpcap.mitm.analysis.http.HttpsPacketModelFilter;
import com.jpcap.mitm.analysis.icmp.IcmpAnalysisRealm;
import com.jpcap.mitm.analysis.icmp.IcmpPacketModelFilter;
import com.jpcap.mitm.analysis.tcp.TcpAnalysisRealm;
import com.jpcap.mitm.analysis.tcp.TcpPacketModelFilter;
import com.jpcap.mitm.analysis.udp.UdpAnalysisRealm;
import com.jpcap.mitm.analysis.udp.UdpPacketModelFilter;
import com.jpcap.mitm.dao.GenericDao;
import com.jpcap.mitm.dto.AnalysisTimelineStatisticDTO;
import com.jpcap.mitm.entity.AnalyzedArpPacket;
import com.jpcap.mitm.entity.AnalyzedHttpPacket;
import com.jpcap.mitm.entity.AnalyzedHttpsPacket;
import com.jpcap.mitm.entity.AnalyzedIcmpPacket;
import com.jpcap.mitm.entity.AnalyzedTcpPacket;
import com.jpcap.mitm.entity.AnalyzedUdpPacket;
import com.jpcap.mitm.entity.CapturedPacket;
import com.jpcap.mitm.model.ARPPacketModel;
import com.jpcap.mitm.model.AbsAnalyzedPacket;
import com.jpcap.mitm.model.DistinctPacketCount;
import com.jpcap.mitm.model.DistinctTimelinePacketCount;
import com.jpcap.mitm.model.DistinctTimelinePacketItem;
import com.jpcap.mitm.model.ICMPPacketModel;
import com.jpcap.mitm.model.PacketModel;
import com.jpcap.mitm.model.TCPPacketModel;
import com.jpcap.mitm.model.UDPPacketModel;
import com.jpcap.mitm.utils.Helper;
import com.jpcap.mitm.utils.NetworkUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bson.BsonSerializationException;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AnalysisService {
    private static final Logger logger = LoggerFactory.getLogger(AnalysisService.class);
    private static String TAG_HTTP = "HTTP";
    @Autowired
    private GenericDao genericDao;
    @Autowired
    @Qualifier(value="mongoTemplate")
    private MongoTemplate mongoTemplate;
    private boolean analyzing = false;

    public void cleanAnalysisHttpHis() {
        this.genericDao.clean(AnalyzedHttpPacket.class);
    }

    public void cleanAnalysisHttpsHis() {
        this.genericDao.clean(AnalyzedHttpsPacket.class);
    }

    public void cleanAnalysisTcpHis() {
        this.genericDao.clean(AnalyzedTcpPacket.class);
    }

    public void cleanAnalysisUdpHis() {
        this.genericDao.clean(AnalyzedUdpPacket.class);
    }

    public void cleanAnalysisIcmpHis() {
        this.genericDao.clean(AnalyzedIcmpPacket.class);
    }

    public void cleanAnalysisArpHis() {
        this.genericDao.clean(AnalyzedArpPacket.class);
    }

    public void cleanByBatchId(Long batchId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"batchId").is((Object)batchId));
        this.genericDao.delete(query, AnalyzedHttpPacket.class);
        this.genericDao.delete(query, AnalyzedHttpsPacket.class);
        this.genericDao.delete(query, AnalyzedTcpPacket.class);
        this.genericDao.delete(query, AnalyzedUdpPacket.class);
        this.genericDao.delete(query, AnalyzedIcmpPacket.class);
        this.genericDao.delete(query, AnalyzedArpPacket.class);
    }

    public boolean isAnalyzing() {
        return this.analyzing;
    }

    public long analysisAll() {
        this.analyzing = true;
        long size = 0L;
        List capturedPackets = this.genericDao.findAll(CapturedPacket.class);
        size += this.analysisHttp(capturedPackets);
        size += this.analysisHttps(capturedPackets);
        size += this.analysisTcp(capturedPackets);
        size += this.analysisUdp(capturedPackets);
        size += this.analysisIcmp(capturedPackets);
        this.analyzing = false;
        return size += this.analysisArp(capturedPackets);
    }

    public long analysisByBatchId(Long batchId) {
        this.analyzing = true;
        long size = 0L;
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"batchId").is((Object)batchId));
        List capturedPackets = this.genericDao.find(query, CapturedPacket.class);
        size += this.analysisHttp(capturedPackets);
        size += this.analysisHttps(capturedPackets);
        size += this.analysisTcp(capturedPackets);
        size += this.analysisUdp(capturedPackets);
        size += this.analysisIcmp(capturedPackets);
        this.analyzing = false;
        return size += this.analysisArp(capturedPackets);
    }

    public long analysisHttp(List<CapturedPacket> capturedPackets) {
        this.analyzing = true;
        HashMap<Long, HttpAnalysisRealm> analysisRealms = new HashMap<Long, HttpAnalysisRealm>();
        HttpPacketModelFilter httpPacketModelFilter = new HttpPacketModelFilter();
        for (CapturedPacket packet : capturedPackets) {
            TCPPacketModel tcpPacketModel;
            PacketModel packetModel = packet.getPacket();
            if (httpPacketModelFilter.filter(packetModel) || (tcpPacketModel = (TCPPacketModel)packetModel).getData().length <= 0) continue;
            if (!analysisRealms.containsKey(tcpPacketModel.getAck_num())) {
                HttpAnalysisRealm httpAnalysisRealm = new HttpAnalysisRealm();
                httpAnalysisRealm.initPacket(packet.getBatchId(), packet.getId(), packet.isUpstream(), (PacketModel)tcpPacketModel);
                analysisRealms.put(tcpPacketModel.getAck_num(), httpAnalysisRealm);
                continue;
            }
            ((IAnalysisRealm)analysisRealms.get(tcpPacketModel.getAck_num())).appendPacket(packet.getId(), (PacketModel)tcpPacketModel);
        }
        this.saveRealmPackets(analysisRealms);
        this.analyzing = false;
        return analysisRealms.size();
    }

    public long analysisHttps(List<CapturedPacket> capturedPackets) {
        this.analyzing = true;
        HashMap<Long, EncryptedHttpsAnalysisRealm> analysisRealms = new HashMap<Long, EncryptedHttpsAnalysisRealm>();
        HttpsPacketModelFilter httpsPacketModelFilter = new HttpsPacketModelFilter();
        for (CapturedPacket packet : capturedPackets) {
            TCPPacketModel tcpPacketModel;
            PacketModel packetModel = packet.getPacket();
            if (httpsPacketModelFilter.filter(packetModel) || (tcpPacketModel = (TCPPacketModel)packetModel).getData().length <= 0) continue;
            if (!analysisRealms.containsKey(tcpPacketModel.getAck_num())) {
                EncryptedHttpsAnalysisRealm httpAnalysisRealm = new EncryptedHttpsAnalysisRealm();
                httpAnalysisRealm.initPacket(packet.getBatchId(), packet.getId(), packet.isUpstream(), (PacketModel)tcpPacketModel);
                analysisRealms.put(tcpPacketModel.getAck_num(), httpAnalysisRealm);
                continue;
            }
            ((IAnalysisRealm)analysisRealms.get(tcpPacketModel.getAck_num())).appendPacket(packet.getId(), (PacketModel)tcpPacketModel);
        }
        this.saveRealmPackets(analysisRealms);
        this.analyzing = false;
        return analysisRealms.size();
    }

    public long analysisTcp(List<CapturedPacket> capturedPackets) {
        this.analyzing = true;
        HashMap<Long, TcpAnalysisRealm> analysisRealms = new HashMap<Long, TcpAnalysisRealm>();
        TcpPacketModelFilter tcpPacketModelFilter = new TcpPacketModelFilter();
        for (CapturedPacket packet : capturedPackets) {
            TCPPacketModel tcpPacketModel;
            PacketModel packetModel = packet.getPacket();
            if (tcpPacketModelFilter.filter(packetModel) || (tcpPacketModel = (TCPPacketModel)packetModel).getData().length <= 0) continue;
            if (!analysisRealms.containsKey(tcpPacketModel.getAck_num())) {
                TcpAnalysisRealm tcpAnalysisRealm = new TcpAnalysisRealm();
                tcpAnalysisRealm.initPacket(packet.getBatchId(), packet.getId(), packet.isUpstream(), (PacketModel)tcpPacketModel);
                analysisRealms.put(tcpPacketModel.getAck_num(), tcpAnalysisRealm);
                continue;
            }
            ((IAnalysisRealm)analysisRealms.get(tcpPacketModel.getAck_num())).appendPacket(packet.getId(), (PacketModel)tcpPacketModel);
        }
        this.saveRealmPackets(analysisRealms);
        this.analyzing = false;
        return analysisRealms.size();
    }

    public long analysisIcmp(List<CapturedPacket> capturedPackets) {
        this.analyzing = true;
        IcmpPacketModelFilter icmpPacketModelFilter = new IcmpPacketModelFilter();
        long size = 0L;
        for (CapturedPacket packet : capturedPackets) {
            PacketModel packetModel = packet.getPacket();
            if (icmpPacketModelFilter.filter(packetModel)) continue;
            ICMPPacketModel icmpPacketModel = (ICMPPacketModel)packetModel;
            IcmpAnalysisRealm icmpAnalysisRealm = new IcmpAnalysisRealm();
            icmpAnalysisRealm.initPacket(packet.getBatchId(), packet.getId(), packet.isUpstream(), (PacketModel)icmpPacketModel);
            AbsAnalyzedPacket toSavePacket = icmpAnalysisRealm.makePacket4Save();
            if (toSavePacket != null) {
                this.genericDao.save((Object)toSavePacket);
            }
            ++size;
        }
        this.analyzing = false;
        return size;
    }

    public long analysisUdp(List<CapturedPacket> capturedPackets) {
        this.analyzing = true;
        UdpPacketModelFilter udpPacketModelFilter = new UdpPacketModelFilter();
        long size = 0L;
        for (CapturedPacket packet : capturedPackets) {
            PacketModel packetModel = packet.getPacket();
            if (udpPacketModelFilter.filter(packetModel)) continue;
            UDPPacketModel udpPacketModel = (UDPPacketModel)packetModel;
            UdpAnalysisRealm udpAnalysisRealm = new UdpAnalysisRealm();
            udpAnalysisRealm.initPacket(packet.getBatchId(), packet.getId(), packet.isUpstream(), (PacketModel)udpPacketModel);
            AbsAnalyzedPacket toSavePacket = udpAnalysisRealm.makePacket4Save();
            if (toSavePacket != null) {
                this.genericDao.save((Object)toSavePacket);
            }
            ++size;
        }
        this.analyzing = false;
        return size;
    }

    public long analysisArp(List<CapturedPacket> capturedPackets) {
        this.analyzing = true;
        ArpPacketModelFilter arpPacketModelFilter = new ArpPacketModelFilter();
        long size = 0L;
        for (CapturedPacket packet : capturedPackets) {
            PacketModel packetModel = packet.getPacket();
            if (arpPacketModelFilter.filter(packetModel)) continue;
            ARPPacketModel arpPacketModel = (ARPPacketModel)packetModel;
            ArpAnalysisRealm arpAnalysisRealm = new ArpAnalysisRealm();
            arpAnalysisRealm.initPacket(packet.getBatchId(), packet.getId(), packet.isUpstream(), (PacketModel)arpPacketModel);
            AbsAnalyzedPacket toSavePacket = arpAnalysisRealm.makePacket4Save();
            if (toSavePacket != null) {
                this.genericDao.save((Object)toSavePacket);
            }
            ++size;
        }
        this.analyzing = false;
        return size;
    }

    public long analysisOthers(List<CapturedPacket> capturedPackets) {
        this.analyzing = true;
        HttpPacketModelFilter httpPacketModelFilter = new HttpPacketModelFilter();
        HttpsPacketModelFilter httpsPacketModelFilter = new HttpsPacketModelFilter();
        TcpPacketModelFilter tcpPacketModelFilter = new TcpPacketModelFilter();
        IcmpPacketModelFilter icmpPacketModelFilter = new IcmpPacketModelFilter();
        UdpPacketModelFilter udpPacketModelFilter = new UdpPacketModelFilter();
        ArpPacketModelFilter arpPacketModelFilter = new ArpPacketModelFilter();
        long size = 0L;
        for (CapturedPacket packet : capturedPackets) {
            PacketModel packetModel = packet.getPacket();
            if (!httpPacketModelFilter.filter(packetModel) || !httpsPacketModelFilter.filter(packetModel) || !tcpPacketModelFilter.filter(packetModel) || !icmpPacketModelFilter.filter(packetModel) || !udpPacketModelFilter.filter(packetModel) || !arpPacketModelFilter.filter(packetModel)) continue;
            ++size;
        }
        this.analyzing = false;
        return size;
    }

    public List<DistinctPacketCount> aggregatePacketsByProperty(List<Long> batchIds, String property, Class clazz) {
        try {
            Criteria criteria = new Criteria();
            if (!CollectionUtils.isEmpty(batchIds)) {
                criteria = criteria.and("batchId").in(batchIds);
            }
            Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((Fields)Fields.fields((String[])new String[]{"upstream", property})).count().as("count"), Aggregation.project((String[])new String[]{"upstream", property, "count"})});
            AggregationResults groupResults = this.mongoTemplate.aggregate(agg, clazz, Document.class);
            List result = groupResults.getMappedResults();
            ArrayList<DistinctPacketCount> counts = new ArrayList<DistinctPacketCount>();
            for (Document doc : result) {
                Boolean upstream = doc.getBoolean((Object)"upstream");
                Object propertyValue = doc.get((Object)property);
                Integer count = doc.getInteger((Object)"count");
                DistinctPacketCount distinctPacketCount = new DistinctPacketCount();
                distinctPacketCount.setUpstream(upstream);
                distinctPacketCount.setPropertyName(property);
                distinctPacketCount.setPropertyValue(propertyValue);
                distinctPacketCount.setCount(count);
                counts.add(distinctPacketCount);
            }
            return counts;
        }
        catch (PropertyReferenceException e) {
            logger.warn(e.getMessage());
            return new ArrayList<DistinctPacketCount>();
        }
    }

    public List<DistinctTimelinePacketCount> aggregatePacketsTimeline(List<Boolean> upstreams, List<Long> batchIds, String property, Class clazz) {
        try {
            Criteria criteria = new Criteria();
            if (!CollectionUtils.isEmpty(batchIds)) {
                criteria = criteria.and("batchId").in(batchIds);
            }
            if (!CollectionUtils.isEmpty(upstreams)) {
                criteria = criteria.and("upstream").in(upstreams);
            }
            Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((Fields)Fields.fields((String[])new String[]{"minuteTimeStr", "upstream", property})).count().as("count"), Aggregation.project((String[])new String[]{"minuteTimeStr", "upstream", property, "count"}), Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"minuteTimeStr"})});
            AggregationResults groupResults = this.mongoTemplate.aggregate(agg, clazz, Document.class);
            List result = groupResults.getMappedResults();
            ArrayList<DistinctTimelinePacketCount> counts = new ArrayList<DistinctTimelinePacketCount>();
            for (Document doc : result) {
                String minuteTimeStr = doc.getString((Object)"minuteTimeStr");
                Boolean upstream = doc.getBoolean((Object)"upstream");
                Object propertyValue = doc.get((Object)property);
                Integer count = doc.getInteger((Object)"count");
                DistinctTimelinePacketCount distinctPacketCount = new DistinctTimelinePacketCount();
                distinctPacketCount.setMinuteTimeStr(minuteTimeStr);
                distinctPacketCount.setUpstream(upstream);
                distinctPacketCount.setPropertyName(property);
                distinctPacketCount.setPropertyValue(propertyValue);
                distinctPacketCount.setCount(count);
                counts.add(distinctPacketCount);
            }
            return counts;
        }
        catch (PropertyReferenceException e) {
            logger.warn(e.getMessage());
            return new ArrayList<DistinctTimelinePacketCount>();
        }
    }

    public List<String> distinctPacketsMinutes(List<Boolean> upstreams, List<Long> batchIds, Class clazz) {
        try {
            Criteria criteria = new Criteria();
            if (!CollectionUtils.isEmpty(batchIds)) {
                criteria = criteria.and("batchId").in(batchIds);
            }
            if (!CollectionUtils.isEmpty(upstreams)) {
                criteria = criteria.and("upstream").in(upstreams);
            }
            Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((Fields)Fields.fields((String[])new String[]{"minuteTimeStr"})), Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"})});
            AggregationResults groupResults = this.mongoTemplate.aggregate(agg, clazz, Document.class);
            List result = groupResults.getMappedResults();
            ArrayList<String> minutes = new ArrayList<String>();
            for (Document doc : result) {
                String minuteTimeStr = doc.getString((Object)"_id");
                minutes.add(minuteTimeStr);
            }
            return minutes;
        }
        catch (PropertyReferenceException e) {
            logger.warn(e.getMessage());
            return new ArrayList<String>();
        }
    }

    public AnalysisTimelineStatisticDTO calculateTimelineData(List<Long> batchIds) {
        AnalysisTimelineStatisticDTO dto = new AnalysisTimelineStatisticDTO();
        try {
            this.calculateUpstreamTimelineData(batchIds, dto);
            this.calculateDownstreamTimelineData(batchIds, dto);
            return dto;
        }
        catch (Exception e) {
            logger.error("Error to calculate timeline data: " + e.getMessage());
            return null;
        }
    }

    public void calculateUpstreamTimelineData(List<Long> batchIds, AnalysisTimelineStatisticDTO dto) {
        HashMap time2ItemMap = new HashMap();
        this.accumulateByUpstream(true, batchIds, time2ItemMap);
        ArrayList minutesList = new ArrayList(time2ItemMap.keySet());
        Collections.sort(minutesList);
        String[] timeArray = minutesList.toArray(new String[0]);
        String[] timeTitle = new String[]{"times"};
        String[] timesData = NetworkUtils.concatStrings((String[])timeTitle, (String[])timeArray);
        int length = timesData.length;
        Object[] htmlData = new Object[length];
        Object[] plainData = new Object[length];
        Object[] xmlData = new Object[length];
        Object[] jsonData = new Object[length];
        Object[] attachmentData = new Object[length];
        Object[] webpData = new Object[length];
        Object[] jpegData = new Object[length];
        Object[] mp4Data = new Object[length];
        Object[] flvData = new Object[length];
        Object[] otherData = new Object[length];
        htmlData[0] = HttpContentTypeEnum.HTML.name();
        plainData[0] = HttpContentTypeEnum.PLAIN.name();
        xmlData[0] = HttpContentTypeEnum.XML.name();
        jsonData[0] = HttpContentTypeEnum.JSON.name();
        attachmentData[0] = HttpContentTypeEnum.ATTACHMENT.name();
        webpData[0] = HttpContentTypeEnum.WEBP.name();
        jpegData[0] = HttpContentTypeEnum.JPEG.name();
        mp4Data[0] = HttpContentTypeEnum.MP4.name();
        flvData[0] = HttpContentTypeEnum.FLV.name();
        otherData[0] = HttpContentTypeEnum.OTHER.name();
        for (int i = 1; i < length; ++i) {
            htmlData[i] = ((DistinctTimelinePacketItem)time2ItemMap.get(timesData[i])).getUpHtmlNum();
            plainData[i] = ((DistinctTimelinePacketItem)time2ItemMap.get(timesData[i])).getUpPlainNum();
            xmlData[i] = ((DistinctTimelinePacketItem)time2ItemMap.get(timesData[i])).getUpXmlNum();
            jsonData[i] = ((DistinctTimelinePacketItem)time2ItemMap.get(timesData[i])).getUpJsonNum();
            attachmentData[i] = ((DistinctTimelinePacketItem)time2ItemMap.get(timesData[i])).getUpAttachmentNum();
            webpData[i] = ((DistinctTimelinePacketItem)time2ItemMap.get(timesData[i])).getUpWebpNum();
            jpegData[i] = ((DistinctTimelinePacketItem)time2ItemMap.get(timesData[i])).getUpJpegNum();
            mp4Data[i] = ((DistinctTimelinePacketItem)time2ItemMap.get(timesData[i])).getUpMp4Num();
            flvData[i] = ((DistinctTimelinePacketItem)time2ItemMap.get(timesData[i])).getUpFlvNum();
            otherData[i] = ((DistinctTimelinePacketItem)time2ItemMap.get(timesData[i])).getUpOtherNum();
        }
        Object[] upData = new Object[]{timesData, htmlData, plainData, xmlData, jsonData, attachmentData, webpData, jpegData, mp4Data, flvData, otherData};
        dto.setUpstreamData(upData);
        dto.setUpFirstMinute(timeArray[0]);
    }

    public void calculateDownstreamTimelineData(List<Long> batchIds, AnalysisTimelineStatisticDTO dto) {
        HashMap time2ItemMap = new HashMap();
        this.accumulateByUpstream(false, batchIds, time2ItemMap);
        ArrayList minutesList = new ArrayList(time2ItemMap.keySet());
        Collections.sort(minutesList);
        String[] timeArray = minutesList.toArray(new String[0]);
        String[] timeTitle = new String[]{"times"};
        String[] timesData = NetworkUtils.concatStrings((String[])timeTitle, (String[])timeArray);
        int length = timesData.length;
        Object[] htmlData = new Object[length];
        Object[] plainData = new Object[length];
        Object[] xmlData = new Object[length];
        Object[] jsonData = new Object[length];
        Object[] attachmentData = new Object[length];
        Object[] webpData = new Object[length];
        Object[] jpegData = new Object[length];
        Object[] mp4Data = new Object[length];
        Object[] flvData = new Object[length];
        Object[] otherData = new Object[length];
        htmlData[0] = HttpContentTypeEnum.HTML.name();
        plainData[0] = HttpContentTypeEnum.PLAIN.name();
        xmlData[0] = HttpContentTypeEnum.XML.name();
        jsonData[0] = HttpContentTypeEnum.JSON.name();
        attachmentData[0] = HttpContentTypeEnum.ATTACHMENT.name();
        webpData[0] = HttpContentTypeEnum.WEBP.name();
        jpegData[0] = HttpContentTypeEnum.JPEG.name();
        mp4Data[0] = HttpContentTypeEnum.MP4.name();
        flvData[0] = HttpContentTypeEnum.FLV.name();
        otherData[0] = HttpContentTypeEnum.OTHER.name();
        for (int i = 1; i < length; ++i) {
            htmlData[i] = ((DistinctTimelinePacketItem)time2ItemMap.get(timesData[i])).getDownHtmlNum();
            plainData[i] = ((DistinctTimelinePacketItem)time2ItemMap.get(timesData[i])).getDownPlainNum();
            xmlData[i] = ((DistinctTimelinePacketItem)time2ItemMap.get(timesData[i])).getDownXmlNum();
            jsonData[i] = ((DistinctTimelinePacketItem)time2ItemMap.get(timesData[i])).getDownJsonNum();
            attachmentData[i] = ((DistinctTimelinePacketItem)time2ItemMap.get(timesData[i])).getDownAttachmentNum();
            webpData[i] = ((DistinctTimelinePacketItem)time2ItemMap.get(timesData[i])).getDownWebpNum();
            jpegData[i] = ((DistinctTimelinePacketItem)time2ItemMap.get(timesData[i])).getDownJpegNum();
            mp4Data[i] = ((DistinctTimelinePacketItem)time2ItemMap.get(timesData[i])).getDownMp4Num();
            flvData[i] = ((DistinctTimelinePacketItem)time2ItemMap.get(timesData[i])).getDownFlvNum();
            otherData[i] = ((DistinctTimelinePacketItem)time2ItemMap.get(timesData[i])).getDownOtherNum();
        }
        Object[] downData = new Object[]{timesData, htmlData, plainData, xmlData, jsonData, attachmentData, webpData, jpegData, mp4Data, flvData, otherData};
        dto.setDownstreamData(downData);
        dto.setDownFirstMinute(timeArray[0]);
    }

    private void accumulateByUpstream(boolean upstream, List<Long> batchIds, HashMap<String, DistinctTimelinePacketItem> time2ItemMap) {
        List httpDistincts = this.aggregatePacketsTimeline(Arrays.asList(upstream), batchIds, "contentType", AnalyzedHttpPacket.class);
        for (Object httpDistinct : httpDistincts) {
            this.accumulateDistinctTimelineItem(time2ItemMap, (DistinctTimelinePacketCount)httpDistinct, null);
        }
        List httpsDistincts = this.aggregatePacketsTimeline(Arrays.asList(upstream), batchIds, "protocol", AnalyzedHttpsPacket.class);
        for (Object httpsDistinct : httpsDistincts) {
            this.accumulateDistinctTimelineItem(time2ItemMap, (DistinctTimelinePacketCount)httpsDistinct, HttpContentTypeEnum.OTHER.name());
        }
        List tcpDistincts = this.aggregatePacketsTimeline(Arrays.asList(upstream), batchIds, "protocol", AnalyzedTcpPacket.class);
        for (Object tcpDistinct : tcpDistincts) {
            this.accumulateDistinctTimelineItem(time2ItemMap, (DistinctTimelinePacketCount)tcpDistinct, HttpContentTypeEnum.OTHER.name());
        }
        List udpDistincts = this.aggregatePacketsTimeline(Arrays.asList(upstream), batchIds, "protocol", AnalyzedUdpPacket.class);
        for (Object udpDistinct : udpDistincts) {
            this.accumulateDistinctTimelineItem(time2ItemMap, (DistinctTimelinePacketCount)udpDistinct, HttpContentTypeEnum.OTHER.name());
        }
        List icmpDistincts = this.aggregatePacketsTimeline(Arrays.asList(upstream), batchIds, "protocol", AnalyzedIcmpPacket.class);
        for (DistinctTimelinePacketCount icmpDistinct : icmpDistincts) {
            this.accumulateDistinctTimelineItem(time2ItemMap, icmpDistinct, HttpContentTypeEnum.OTHER.name());
        }
        List arpDistincts = this.aggregatePacketsTimeline(Arrays.asList(upstream), batchIds, "protocol", AnalyzedArpPacket.class);
        for (DistinctTimelinePacketCount arpDistinct : arpDistincts) {
            this.accumulateDistinctTimelineItem(time2ItemMap, arpDistinct, HttpContentTypeEnum.OTHER.name());
        }
    }

    private void accumulateDistinctTimelineItem(HashMap<String, DistinctTimelinePacketItem> time2ItemMap, DistinctTimelinePacketCount httpsDistinct, String propertyValue) {
        if (time2ItemMap.get(httpsDistinct.getMinuteTimeStr()) == null) {
            DistinctTimelinePacketItem item = new DistinctTimelinePacketItem();
            item.setMinuteTimeStr(httpsDistinct.getMinuteTimeStr());
            time2ItemMap.put(httpsDistinct.getMinuteTimeStr(), item);
        }
        if (propertyValue == null) {
            time2ItemMap.get(httpsDistinct.getMinuteTimeStr()).accumulate(httpsDistinct.getUpstream().booleanValue(), (String)httpsDistinct.getPropertyValue(), (long)httpsDistinct.getCount().intValue());
        } else {
            time2ItemMap.get(httpsDistinct.getMinuteTimeStr()).accumulate(httpsDistinct.getUpstream().booleanValue(), propertyValue, (long)httpsDistinct.getCount().intValue());
        }
    }

    public List<String> distinctPacketsMinutesForAll(List<Boolean> upstreams, List<Long> batchIds) {
        List httpMinutes = this.distinctPacketsMinutes(upstreams, batchIds, AnalyzedHttpPacket.class);
        List httpsMinutes = this.distinctPacketsMinutes(upstreams, batchIds, AnalyzedHttpsPacket.class);
        List tcpMinutes = this.distinctPacketsMinutes(upstreams, batchIds, AnalyzedTcpPacket.class);
        List udpMinutes = this.distinctPacketsMinutes(upstreams, batchIds, AnalyzedUdpPacket.class);
        List icmpMinutes = this.distinctPacketsMinutes(upstreams, batchIds, AnalyzedIcmpPacket.class);
        List arpMinutes = this.distinctPacketsMinutes(upstreams, batchIds, AnalyzedArpPacket.class);
        HashSet minutes = new HashSet();
        minutes.addAll(httpMinutes);
        minutes.addAll(httpsMinutes);
        minutes.addAll(tcpMinutes);
        minutes.addAll(udpMinutes);
        minutes.addAll(icmpMinutes);
        minutes.addAll(arpMinutes);
        ArrayList<String> minutesList = new ArrayList<String>(minutes);
        Collections.sort(minutesList);
        return minutesList;
    }

    public Object[][] getUpstreamTimelinePacketsData() {
        List upMinutes = this.distinctPacketsMinutesForAll(Arrays.asList(true), null);
        List distinctTimelinePacketCounts = this.aggregatePacketsTimeline(Arrays.asList(false), null, "contentType", AnalyzedHttpPacket.class);
        for (DistinctTimelinePacketCount distinctTimelinePacketCount : distinctTimelinePacketCounts) {
            Helper.println((Object[])new Object[]{distinctTimelinePacketCount});
        }
        return null;
    }

    private void saveRealmPackets(Map<Long, IAnalysisRealm> analysisRealms) {
        for (Map.Entry<Long, IAnalysisRealm> entry : analysisRealms.entrySet()) {
            IAnalysisRealm realm = entry.getValue();
            AbsAnalyzedPacket toSavePacket = realm.makePacket4Save();
            if (toSavePacket == null) continue;
            try {
                this.genericDao.save((Object)toSavePacket);
            }
            catch (BsonSerializationException e) {
                toSavePacket.minimizeContent();
                this.genericDao.save((Object)toSavePacket);
            }
        }
    }
}

