/*
 * Decompiled with CFR 0.152.
 */
package com.jpcap.mitm.dto;

import com.jpcap.mitm.model.ARPPacketModel;
import com.jpcap.mitm.model.ICMPPacketModel;
import com.jpcap.mitm.model.IPPacketModel;
import com.jpcap.mitm.model.PacketModel;
import com.jpcap.mitm.model.TCPPacketModel;
import com.jpcap.mitm.model.UDPPacketModel;
import com.jpcap.mitm.utils.NetworkUtils;
import java.io.Serializable;

public class OriginalPacketDTO
implements Serializable {
    private Integer capLen;
    private Integer len;
    private String hexHeader;
    private Integer headerLen;
    private String hexData;
    private Integer dataLen;
    private String srcMac;
    private String dstMac;
    private Short frameType;
    private Short hardwareType;
    private Short prototype;
    private Short hardwareAddressLen;
    private Short protocolAddressLen;
    private Short operation;
    private String senderHardwareAddress;
    private String senderProtocolAddress;
    private String targetHardwareAddress;
    private String targetProtocolAddress;
    private Byte version;
    private Byte rsvTos;
    private String srcIp;
    private String dstIp;
    private byte[] option;
    private Byte priority;
    private Integer length;
    private Integer ident;
    private Boolean dontFrag;
    private Boolean moreFrag;
    private Short offset;
    private Short hopLimit;
    private Short protocol;
    private Byte type;
    private Short aliveTime;
    private Long sequence;
    private Long ackNum;
    private Boolean urg;
    private Boolean ack;
    private Boolean psh;
    private Boolean rst;
    private Boolean syn;
    private Boolean fin;
    private Integer window;
    private Short urgentPointer;
    private Integer srcPort;
    private Integer dstPort;

    public static OriginalPacketDTO readFrom(PacketModel packet) {
        OriginalPacketDTO dto = new OriginalPacketDTO();
        dto.setCapLen(Integer.valueOf(packet.getCaplen()));
        dto.setLen(Integer.valueOf(packet.getLen()));
        dto.setHexHeader(NetworkUtils.bytesToHexString((byte[])packet.getHeader()));
        dto.setHeaderLen(Integer.valueOf(packet.getHeader() != null ? packet.getHeader().length : 0));
        dto.setHexData(NetworkUtils.bytesToHexString((byte[])packet.getData()));
        dto.setDataLen(Integer.valueOf(packet.getData() != null ? packet.getData().length : 0));
        if (packet.getDatalink() != null) {
            dto.setSrcMac(packet.getDatalink().getSourceAddress());
            dto.setDstMac(packet.getDatalink().getDestinationAddress());
            dto.setFrameType(Short.valueOf(packet.getDatalink().getFrametype()));
        }
        if (packet instanceof ARPPacketModel) {
            ARPPacketModel arpPacketModel = (ARPPacketModel)packet;
            dto.setHardwareType(Short.valueOf(arpPacketModel.getHardtype()));
            dto.setPrototype(Short.valueOf(arpPacketModel.getPrototype()));
            dto.setHardwareAddressLen(Short.valueOf(arpPacketModel.getHlen()));
            dto.setProtocolAddressLen(Short.valueOf(arpPacketModel.getPlen()));
            dto.setOperation(Short.valueOf(arpPacketModel.getOperation()));
            dto.setSenderHardwareAddress(NetworkUtils.bytesToMac((byte[])arpPacketModel.getSender_hardaddr()));
            dto.setSenderProtocolAddress(NetworkUtils.bytesToIp((byte[])arpPacketModel.getSender_protoaddr()));
            dto.setTargetHardwareAddress(NetworkUtils.bytesToMac((byte[])arpPacketModel.getTarget_hardaddr()));
            dto.setTargetProtocolAddress(NetworkUtils.bytesToIp((byte[])arpPacketModel.getTarget_protoaddr()));
        }
        if (packet instanceof IPPacketModel) {
            IPPacketModel ipPacketModel = (IPPacketModel)packet;
            dto.setVersion(Byte.valueOf(ipPacketModel.getVersion()));
            dto.setRsvTos(Byte.valueOf(ipPacketModel.getRsv_tos()));
            dto.setSrcIp(ipPacketModel.getSrc_ip());
            dto.setDstIp(ipPacketModel.getDst_ip());
            dto.setOption(ipPacketModel.getOption());
            dto.setPriority(Byte.valueOf(ipPacketModel.getPriority()));
            dto.setLength(Integer.valueOf(ipPacketModel.getLength()));
            dto.setIdent(Integer.valueOf(ipPacketModel.getIdent()));
            dto.setDontFrag(Boolean.valueOf(ipPacketModel.isDont_frag()));
            dto.setMoreFrag(Boolean.valueOf(ipPacketModel.isMore_frag()));
            dto.setOffset(Short.valueOf(ipPacketModel.getOffset()));
            dto.setHopLimit(Short.valueOf(ipPacketModel.getHop_limit()));
            dto.setProtocol(Short.valueOf(ipPacketModel.getProtocol()));
            if (ipPacketModel instanceof ICMPPacketModel) {
                ICMPPacketModel icmpPacketModel = (ICMPPacketModel)ipPacketModel;
                dto.setType(Byte.valueOf(icmpPacketModel.getType()));
                dto.setAliveTime(Short.valueOf(icmpPacketModel.getAlive_time()));
            } else if (ipPacketModel instanceof TCPPacketModel) {
                TCPPacketModel tcpPacketModel = (TCPPacketModel)ipPacketModel;
                dto.setSequence(Long.valueOf(tcpPacketModel.getSequence()));
                dto.setAckNum(Long.valueOf(tcpPacketModel.getAck_num()));
                dto.setUrg(Boolean.valueOf(tcpPacketModel.isUrg()));
                dto.setAck(Boolean.valueOf(tcpPacketModel.isAck()));
                dto.setPsh(Boolean.valueOf(tcpPacketModel.isPsh()));
                dto.setRst(Boolean.valueOf(tcpPacketModel.isRst()));
                dto.setSyn(Boolean.valueOf(tcpPacketModel.isSyn()));
                dto.setFin(Boolean.valueOf(tcpPacketModel.isFin()));
                dto.setWindow(Integer.valueOf(tcpPacketModel.getWindow()));
                dto.setUrgentPointer(Short.valueOf(tcpPacketModel.getUrgent_pointer()));
                dto.setSrcPort(Integer.valueOf(tcpPacketModel.getSrc_port()));
                dto.setDstPort(Integer.valueOf(tcpPacketModel.getDst_port()));
            } else if (ipPacketModel instanceof UDPPacketModel) {
                UDPPacketModel udpPacketModel = (UDPPacketModel)ipPacketModel;
                dto.setSrcPort(Integer.valueOf(udpPacketModel.getSrc_port()));
                dto.setDstPort(Integer.valueOf(udpPacketModel.getDst_port()));
            }
        }
        return dto;
    }

    public Integer getCapLen() {
        return this.capLen;
    }

    public void setCapLen(Integer capLen) {
        this.capLen = capLen;
    }

    public Integer getLen() {
        return this.len;
    }

    public void setLen(Integer len) {
        this.len = len;
    }

    public String getHexHeader() {
        return this.hexHeader;
    }

    public void setHexHeader(String hexHeader) {
        this.hexHeader = hexHeader;
    }

    public Integer getHeaderLen() {
        return this.headerLen;
    }

    public void setHeaderLen(Integer headerLen) {
        this.headerLen = headerLen;
    }

    public String getHexData() {
        return this.hexData;
    }

    public void setHexData(String hexData) {
        this.hexData = hexData;
    }

    public Integer getDataLen() {
        return this.dataLen;
    }

    public void setDataLen(Integer dataLen) {
        this.dataLen = dataLen;
    }

    public String getSrcMac() {
        return this.srcMac;
    }

    public void setSrcMac(String srcMac) {
        this.srcMac = srcMac;
    }

    public String getDstMac() {
        return this.dstMac;
    }

    public void setDstMac(String dstMac) {
        this.dstMac = dstMac;
    }

    public Short getFrameType() {
        return this.frameType;
    }

    public void setFrameType(Short frameType) {
        this.frameType = frameType;
    }

    public Short getHardwareType() {
        return this.hardwareType;
    }

    public void setHardwareType(Short hardwareType) {
        this.hardwareType = hardwareType;
    }

    public Byte getRsvTos() {
        return this.rsvTos;
    }

    public void setRsvTos(Byte rsvTos) {
        this.rsvTos = rsvTos;
    }

    public Short getPrototype() {
        return this.prototype;
    }

    public void setPrototype(Short prototype) {
        this.prototype = prototype;
    }

    public Short getHardwareAddressLen() {
        return this.hardwareAddressLen;
    }

    public void setHardwareAddressLen(Short hardwareAddressLen) {
        this.hardwareAddressLen = hardwareAddressLen;
    }

    public Short getProtocolAddressLen() {
        return this.protocolAddressLen;
    }

    public void setProtocolAddressLen(Short protocolAddressLen) {
        this.protocolAddressLen = protocolAddressLen;
    }

    public Short getOperation() {
        return this.operation;
    }

    public void setOperation(Short operation) {
        this.operation = operation;
    }

    public String getSenderHardwareAddress() {
        return this.senderHardwareAddress;
    }

    public void setSenderHardwareAddress(String senderHardwareAddress) {
        this.senderHardwareAddress = senderHardwareAddress;
    }

    public String getSenderProtocolAddress() {
        return this.senderProtocolAddress;
    }

    public void setSenderProtocolAddress(String senderProtocolAddress) {
        this.senderProtocolAddress = senderProtocolAddress;
    }

    public String getTargetHardwareAddress() {
        return this.targetHardwareAddress;
    }

    public void setTargetHardwareAddress(String targetHardwareAddress) {
        this.targetHardwareAddress = targetHardwareAddress;
    }

    public String getTargetProtocolAddress() {
        return this.targetProtocolAddress;
    }

    public void setTargetProtocolAddress(String targetProtocolAddress) {
        this.targetProtocolAddress = targetProtocolAddress;
    }

    public Byte getVersion() {
        return this.version;
    }

    public void setVersion(Byte version) {
        this.version = version;
    }

    public String getSrcIp() {
        return this.srcIp;
    }

    public void setSrcIp(String srcIp) {
        this.srcIp = srcIp;
    }

    public String getDstIp() {
        return this.dstIp;
    }

    public void setDstIp(String dstIp) {
        this.dstIp = dstIp;
    }

    public byte[] getOption() {
        return this.option;
    }

    public void setOption(byte[] option) {
        this.option = option;
    }

    public Byte getPriority() {
        return this.priority;
    }

    public void setPriority(Byte priority) {
        this.priority = priority;
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public Integer getIdent() {
        return this.ident;
    }

    public void setIdent(Integer ident) {
        this.ident = ident;
    }

    public Boolean getDontFrag() {
        return this.dontFrag;
    }

    public void setDontFrag(Boolean dontFrag) {
        this.dontFrag = dontFrag;
    }

    public Boolean getMoreFrag() {
        return this.moreFrag;
    }

    public void setMoreFrag(Boolean moreFrag) {
        this.moreFrag = moreFrag;
    }

    public Short getOffset() {
        return this.offset;
    }

    public void setOffset(Short offset) {
        this.offset = offset;
    }

    public Short getHopLimit() {
        return this.hopLimit;
    }

    public void setHopLimit(Short hopLimit) {
        this.hopLimit = hopLimit;
    }

    public Short getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Short protocol) {
        this.protocol = protocol;
    }

    public Byte getType() {
        return this.type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public Short getAliveTime() {
        return this.aliveTime;
    }

    public void setAliveTime(Short aliveTime) {
        this.aliveTime = aliveTime;
    }

    public Long getSequence() {
        return this.sequence;
    }

    public void setSequence(Long sequence) {
        this.sequence = sequence;
    }

    public Long getAckNum() {
        return this.ackNum;
    }

    public void setAckNum(Long ackNum) {
        this.ackNum = ackNum;
    }

    public Boolean getUrg() {
        return this.urg;
    }

    public void setUrg(Boolean urg) {
        this.urg = urg;
    }

    public Boolean getAck() {
        return this.ack;
    }

    public void setAck(Boolean ack) {
        this.ack = ack;
    }

    public Boolean getPsh() {
        return this.psh;
    }

    public void setPsh(Boolean psh) {
        this.psh = psh;
    }

    public Boolean getRst() {
        return this.rst;
    }

    public void setRst(Boolean rst) {
        this.rst = rst;
    }

    public Boolean getSyn() {
        return this.syn;
    }

    public void setSyn(Boolean syn) {
        this.syn = syn;
    }

    public Boolean getFin() {
        return this.fin;
    }

    public void setFin(Boolean fin) {
        this.fin = fin;
    }

    public Integer getWindow() {
        return this.window;
    }

    public void setWindow(Integer window) {
        this.window = window;
    }

    public Short getUrgentPointer() {
        return this.urgentPointer;
    }

    public void setUrgentPointer(Short urgentPointer) {
        this.urgentPointer = urgentPointer;
    }

    public Integer getSrcPort() {
        return this.srcPort;
    }

    public void setSrcPort(Integer srcPort) {
        this.srcPort = srcPort;
    }

    public Integer getDstPort() {
        return this.dstPort;
    }

    public void setDstPort(Integer dstPort) {
        this.dstPort = dstPort;
    }
}

