/*
 * Decompiled with CFR 0.152.
 */
package com.jpcap.mitm.dao;

import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Repository;

@Repository
public class GenericDao<T> {
    @Autowired
    @Qualifier(value="mongoTemplate")
    private MongoTemplate mongoTemplate;

    public void insert(T t) {
        this.mongoTemplate.insert(t);
    }

    public void save(T t) {
        this.mongoTemplate.save(t);
    }

    public void insertAll(List<T> ts) {
        this.mongoTemplate.insertAll(ts);
    }

    public <T> T findById(String id, Class<T> clazz) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
        Object t = this.mongoTemplate.findOne(query, clazz);
        return (T)t;
    }

    public List<T> findAll(Class<T> clazz) {
        List ts = this.mongoTemplate.findAll(clazz);
        return ts;
    }

    public <T> T findOne(Query query, Class<T> clazz) {
        Object t = this.mongoTemplate.findOne(query, clazz);
        return (T)t;
    }

    public List<T> find(Query query, Class<T> clazz) {
        List ts = this.mongoTemplate.find(query, clazz);
        return ts;
    }

    public long count(Query query, Class<T> clazz) {
        long count = this.mongoTemplate.count(query, clazz);
        return count;
    }

    public boolean exist(Query query, Class<T> clazz) {
        return this.mongoTemplate.exists(query, clazz);
    }

    public long updateColumnById(String id, String column, Object value, Class<T> clazz) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
        Update update = Update.update((String)"updated", (Object)new Date());
        update.set(column, value);
        UpdateResult rs = this.mongoTemplate.updateFirst(query, update, clazz);
        return rs.getModifiedCount();
    }

    public long updateById(String id, Update update, Class<T> clazz) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
        update.set("updated", (Object)new Date());
        UpdateResult rs = this.mongoTemplate.updateFirst(query, update, clazz);
        return rs.getModifiedCount();
    }

    public long deleteById(String id, Class<T> clazz) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id));
        DeleteResult rs = this.mongoTemplate.remove(query, clazz);
        return rs.getDeletedCount();
    }

    public long deleteByOid(String id, Class<T> clazz) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
        DeleteResult rs = this.mongoTemplate.remove(query, clazz);
        return rs.getDeletedCount();
    }

    public long delete(Query query, Class<T> clazz) {
        DeleteResult rs = this.mongoTemplate.remove(query, clazz);
        return rs.getDeletedCount();
    }

    public void clean(Class<T> clazz) {
        this.mongoTemplate.dropCollection(clazz);
    }
}

