/*
 * Decompiled with CFR 0.152.
 */
package com.jpcap.mitm.controller;

import com.jpcap.mitm.analysis.HttpContentTypeEnum;
import com.jpcap.mitm.analysis.ProtocolEnum;
import com.jpcap.mitm.dao.GenericDao;
import com.jpcap.mitm.dto.AnalysisContentTypeStatisticDTO;
import com.jpcap.mitm.dto.AnalysisStatisticDTO;
import com.jpcap.mitm.dto.AnalysisTimelineStatisticDTO;
import com.jpcap.mitm.dto.AttackStatisticDTO;
import com.jpcap.mitm.dto.OriginalPacketDTO;
import com.jpcap.mitm.dto.ResultDTO;
import com.jpcap.mitm.entity.AnalyzedArpPacket;
import com.jpcap.mitm.entity.AnalyzedHttpPacket;
import com.jpcap.mitm.entity.AnalyzedHttpsPacket;
import com.jpcap.mitm.entity.AnalyzedIcmpPacket;
import com.jpcap.mitm.entity.AnalyzedTcpPacket;
import com.jpcap.mitm.entity.AnalyzedUdpPacket;
import com.jpcap.mitm.entity.AttackConfig;
import com.jpcap.mitm.entity.CapturedPacket;
import com.jpcap.mitm.model.AbsAnalyzedPacket;
import com.jpcap.mitm.model.DistinctPacketCount;
import com.jpcap.mitm.model.DumpRecord;
import com.jpcap.mitm.model.NetworkInterfaceModel;
import com.jpcap.mitm.model.PacketModel;
import com.jpcap.mitm.req.DeleteAttackHisReq;
import com.jpcap.mitm.req.PacketFilterParamsReq;
import com.jpcap.mitm.req.PacketStatisticFilterParamsReq;
import com.jpcap.mitm.service.AnalysisService;
import com.jpcap.mitm.service.AttackService;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import jpcap.NetworkInterface;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/api"})
public class ApiController {
    private static final Logger logger = LoggerFactory.getLogger(ApiController.class);
    @Autowired
    private AttackService attackService;
    @Autowired
    private AnalysisService analysisService;
    @Autowired
    private GenericDao genericDao;
    @Autowired
    @Qualifier(value="mongoTemplate")
    private MongoTemplate mongoTemplate;
    private boolean deviceOpened = false;

    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    @ResponseBody
    public String test() {
        return "Hello world!";
    }

    @RequestMapping(value={"/getDevicelist"}, method={RequestMethod.GET})
    @ResponseBody
    public List<NetworkInterfaceModel> getDevicelist() {
        ArrayList<NetworkInterfaceModel> devices = new ArrayList<NetworkInterfaceModel>();
        NetworkInterface[] interfaces = this.attackService.getDevices();
        if (interfaces != null) {
            for (NetworkInterface networkInterface : interfaces) {
                NetworkInterfaceModel model = new NetworkInterfaceModel();
                model.setName(networkInterface.name);
                model.setDescription(networkInterface.description);
                model.setDatalinkName(networkInterface.datalink_name);
                model.setDatalinkDescription(networkInterface.datalink_description);
                devices.add(model);
            }
        }
        return devices;
    }

    @RequestMapping(value={"/getAttackConfig"}, method={RequestMethod.GET})
    @ResponseBody
    public ResultDTO getAttackConfig() {
        List configs = this.genericDao.findAll(AttackConfig.class);
        if (configs != null && configs.size() > 0) {
            AttackConfig config = (AttackConfig)configs.get(0);
            return new ResultDTO((Serializable)config);
        }
        AttackConfig config = new AttackConfig();
        return new ResultDTO((Serializable)config);
    }

    @RequestMapping(value={"/isDeviceOpened"}, method={RequestMethod.GET})
    @ResponseBody
    public ResultDTO isDeviceOpened() {
        return new ResultDTO((Serializable)Boolean.valueOf(this.deviceOpened));
    }

    @RequestMapping(value={"/updateConfigAndOpenDevice"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultDTO updateConfigAndOpenDevice(@RequestBody AttackConfig req) throws IOException {
        if (req.getSrcIp() != null && req.getSrcMac() != null && req.getDestIp() != null && req.getDestMac() != null && req.getGateIp() != null && req.getGateMac() != null && req.getFilterDomain() != null) {
            if (req.getSrcMac() != null) {
                req.setSrcMac(req.getSrcMac().replace('-', ':').toLowerCase());
            }
            if (req.getDestMac() != null) {
                req.setDestMac(req.getDestMac().replace('-', ':').toLowerCase());
            }
            if (req.getGateMac() != null) {
                req.setGateMac(req.getGateMac().replace('-', ':').toLowerCase());
            }
            this.attackService.updateConfigAndOpenDevice(req.getDeviceName(), req.getDestIp(), req.getDestMac(), req.getSrcIp(), req.getSrcMac(), req.getGateIp(), req.getGateMac(), req.getFilterDomain());
            this.deviceOpened = true;
            List configs = this.genericDao.findAll(AttackConfig.class);
            if (configs != null && configs.size() > 0) {
                req.setId(((AttackConfig)configs.get(0)).getId());
            }
            this.genericDao.save((Object)req);
            return new ResultDTO((Serializable)Boolean.valueOf(true));
        }
        return new ResultDTO((Serializable)Boolean.valueOf(false));
    }

    @RequestMapping(value={"/startAttack"}, method={RequestMethod.GET})
    @ResponseBody
    public ResultDTO startAttack() {
        logger.info("Start attacking...");
        this.attackService.attack();
        return new ResultDTO((Serializable)Boolean.valueOf(true));
    }

    @RequestMapping(value={"/stopAttack"}, method={RequestMethod.GET})
    @ResponseBody
    public ResultDTO stopAttack() {
        logger.info("Stop attacking...");
        Long batchId = this.attackService.stopAttack();
        return new ResultDTO((Serializable)batchId);
    }

    @RequestMapping(value={"/isAttacking"}, method={RequestMethod.GET})
    @ResponseBody
    public ResultDTO isAttacking() {
        ResultDTO dto = new ResultDTO();
        dto.setResult((Serializable)Boolean.valueOf(this.attackService.isAttacking()));
        return dto;
    }

    @RequestMapping(value={"/getAttackStatistic"}, method={RequestMethod.GET})
    @ResponseBody
    public AttackStatisticDTO getAttackStatistic() {
        AttackStatisticDTO dto = new AttackStatisticDTO();
        dto.setUpStreamNum(this.attackService.getUpStreamNum());
        dto.setDownStreamNum(this.attackService.getDownStreamNum());
        dto.setUpTcpNum(this.attackService.getUpTcpNum());
        dto.setUpUdpNum(this.attackService.getUpUdpNum());
        dto.setUpIcmpNum(this.attackService.getUpIcmpNum());
        dto.setUpArpNum(this.attackService.getUpArpNum());
        dto.setDownTcpNum(this.attackService.getDownTcpNum());
        dto.setDownUdpNum(this.attackService.getDownUdpNum());
        dto.setDownIcmpNum(this.attackService.getDownIcmpNum());
        dto.setDownArpNum(this.attackService.getDownArpNum());
        return dto;
    }

    @RequestMapping(value={"/getDumpRecords"}, method={RequestMethod.GET})
    @ResponseBody
    public List<DumpRecord> getDumpRecords() {
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.group((Fields)Fields.fields((String[])new String[]{"batchId"})).first("batchId").as("batchId").first("upstream").as("upstream").first("startAttackTime").as("startAttackTime"), Aggregation.project((String[])new String[]{"batchId", "upstream", "startAttackTime"}), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"batchId"})});
        AggregationResults groupResults = this.mongoTemplate.aggregate(agg, CapturedPacket.class, DumpRecord.class);
        List dumpRecords = groupResults.getMappedResults();
        for (DumpRecord dumpRecord : dumpRecords) {
            Query upQuery = new Query((CriteriaDefinition)Criteria.where((String)"batchId").is((Object)dumpRecord.getBatchId()).and("upstream").is((Object)true));
            long upCount = this.genericDao.count(upQuery, CapturedPacket.class);
            Query downQuery = new Query((CriteriaDefinition)Criteria.where((String)"batchId").is((Object)dumpRecord.getBatchId()).and("upstream").is((Object)false));
            long downCount = this.genericDao.count(downQuery, CapturedPacket.class);
            dumpRecord.setUpstreamPackets(upCount);
            dumpRecord.setDownstreamPackets(downCount);
        }
        return dumpRecords;
    }

    @RequestMapping(value={"/deleteAttackHis"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultDTO deleteAttackHis(@RequestBody DeleteAttackHisReq req) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"batchId").is((Object)req.getBatchId()));
        long n = this.genericDao.delete(query, CapturedPacket.class);
        this.analysisService.cleanByBatchId(req.getBatchId());
        ResultDTO dto = new ResultDTO((Serializable)Long.valueOf(n));
        return dto;
    }

    @RequestMapping(value={"/analysisByBatchId"}, method={RequestMethod.GET})
    @ResponseBody
    public ResultDTO analysisByBatchId(@RequestParam(value="batchId") Long batchId) {
        logger.info("Begin to analysis packets for batchId: " + batchId);
        this.analysisService.cleanByBatchId(batchId);
        long size = this.analysisService.analysisByBatchId(batchId);
        logger.info("Finish the analysis packets for batchId: " + batchId + ", n: " + size);
        ResultDTO dto = new ResultDTO((Serializable)Long.valueOf(size));
        return dto;
    }

    @RequestMapping(value={"/isAnalyzing"}, method={RequestMethod.GET})
    @ResponseBody
    public ResultDTO isAnalyzing() {
        ResultDTO dto = new ResultDTO();
        dto.setResult((Serializable)Boolean.valueOf(this.analysisService.isAnalyzing()));
        return dto;
    }

    @RequestMapping(value={"/distinctBatchIds"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Long> distinctBatchIds() {
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.group((Fields)Fields.fields((String[])new String[]{"batchId"})).first("batchId").as("batchId"), Aggregation.project((String[])new String[]{"batchId"}), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"batchId"})});
        AggregationResults groupResults = this.mongoTemplate.aggregate(agg, CapturedPacket.class, Document.class);
        List results = groupResults.getMappedResults();
        ArrayList<Long> batchIds = new ArrayList<Long>();
        for (Document doc : results) {
            Long batchId = (Long)doc.get((Object)"batchId");
            batchIds.add(batchId);
        }
        return batchIds;
    }

    @RequestMapping(value={"/filterPackets"}, method={RequestMethod.POST})
    @ResponseBody
    public List<AbsAnalyzedPacket> filterPackets(@RequestBody PacketFilterParamsReq req) {
        ArrayList<AbsAnalyzedPacket> packets = new ArrayList<AbsAnalyzedPacket>();
        Criteria criteria = new Criteria();
        if (!CollectionUtils.isEmpty((Collection)req.getBatchIds())) {
            criteria = criteria.and("batchId").in((Collection)req.getBatchIds());
        }
        if (!CollectionUtils.isEmpty((Collection)req.getDirections())) {
            criteria = criteria.and("upstream").in((Collection)req.getDirections());
        }
        if (!CollectionUtils.isEmpty((Collection)req.getContentTypes())) {
            criteria = criteria.and("contentType").in((Collection)req.getContentTypes());
        }
        Query query = new Query((CriteriaDefinition)criteria);
        if (!CollectionUtils.isEmpty((Collection)req.getProtocols())) {
            for (String protocol : req.getProtocols()) {
                if (ProtocolEnum.HTTP.name().equals(protocol)) {
                    List httpPackets = this.genericDao.find(query, AnalyzedHttpPacket.class);
                    packets.addAll(httpPackets);
                    continue;
                }
                if (ProtocolEnum.HTTPS.name().equals(protocol)) {
                    List httpsPackets = this.genericDao.find(query, AnalyzedHttpsPacket.class);
                    packets.addAll(httpsPackets);
                    continue;
                }
                if (ProtocolEnum.TCP.name().equals(protocol)) {
                    List tcpPackets = this.genericDao.find(query, AnalyzedTcpPacket.class);
                    packets.addAll(tcpPackets);
                    continue;
                }
                if (ProtocolEnum.UDP.name().equals(protocol)) {
                    List udpPackets = this.genericDao.find(query, AnalyzedUdpPacket.class);
                    packets.addAll(udpPackets);
                    continue;
                }
                if (ProtocolEnum.ICMP.name().equals(protocol)) {
                    List icmpPackets = this.genericDao.find(query, AnalyzedIcmpPacket.class);
                    packets.addAll(icmpPackets);
                    continue;
                }
                if (!ProtocolEnum.ARP.name().equals(protocol)) continue;
                List arpPackets = this.genericDao.find(query, AnalyzedArpPacket.class);
                packets.addAll(arpPackets);
            }
        } else {
            List httpPackets = this.genericDao.find(query, AnalyzedHttpPacket.class);
            packets.addAll(httpPackets);
            List httpsPackets = this.genericDao.find(query, AnalyzedHttpsPacket.class);
            packets.addAll(httpsPackets);
            List tcpPackets = this.genericDao.find(query, AnalyzedTcpPacket.class);
            packets.addAll(tcpPackets);
            List udpPackets = this.genericDao.find(query, AnalyzedUdpPacket.class);
            packets.addAll(udpPackets);
            List icmpPackets = this.genericDao.find(query, AnalyzedIcmpPacket.class);
            packets.addAll(icmpPackets);
            List arpPackets = this.genericDao.find(query, AnalyzedArpPacket.class);
            packets.addAll(arpPackets);
        }
        return packets;
    }

    @RequestMapping(value={"/statisticPackets"}, method={RequestMethod.POST})
    @ResponseBody
    public AnalysisStatisticDTO statisticPackets(@RequestBody PacketStatisticFilterParamsReq req) {
        Criteria upCriteria = new Criteria();
        Criteria downCriteria = new Criteria();
        if (!CollectionUtils.isEmpty((Collection)req.getBatchIds())) {
            upCriteria = upCriteria.and("batchId").in((Collection)req.getBatchIds());
            downCriteria = downCriteria.and("batchId").in((Collection)req.getBatchIds());
        }
        upCriteria = upCriteria.and("upstream").is((Object)true);
        downCriteria = downCriteria.and("upstream").is((Object)false);
        Query upQuery = new Query((CriteriaDefinition)upCriteria);
        Query downQuery = new Query((CriteriaDefinition)downCriteria);
        long upHttpNum = this.genericDao.count(upQuery, AnalyzedHttpPacket.class);
        long upHttpsNum = this.genericDao.count(upQuery, AnalyzedHttpsPacket.class);
        long upTcpNum = this.genericDao.count(upQuery, AnalyzedTcpPacket.class);
        long upUdpNum = this.genericDao.count(upQuery, AnalyzedUdpPacket.class);
        long upIcmpNum = this.genericDao.count(upQuery, AnalyzedIcmpPacket.class);
        long upArpNum = this.genericDao.count(upQuery, AnalyzedArpPacket.class);
        long downHttpNum = this.genericDao.count(downQuery, AnalyzedHttpPacket.class);
        long downHttpsNum = this.genericDao.count(downQuery, AnalyzedHttpsPacket.class);
        long downTcpNum = this.genericDao.count(downQuery, AnalyzedTcpPacket.class);
        long downUdpNum = this.genericDao.count(downQuery, AnalyzedUdpPacket.class);
        long downIcmpNum = this.genericDao.count(downQuery, AnalyzedIcmpPacket.class);
        long downArpNum = this.genericDao.count(downQuery, AnalyzedArpPacket.class);
        long upStreamNum = upHttpNum + upHttpsNum + upTcpNum + upUdpNum + upIcmpNum + upArpNum;
        long downStreamNum = downHttpNum + downHttpsNum + downTcpNum + downUdpNum + downIcmpNum + downArpNum;
        AnalysisStatisticDTO dto = new AnalysisStatisticDTO();
        dto.setUpStreamNum(upStreamNum);
        dto.setDownStreamNum(downStreamNum);
        dto.setUpHttpNum(upHttpNum);
        dto.setUpHttpsNum(upHttpsNum);
        dto.setUpTcpNum(upTcpNum);
        dto.setUpUdpNum(upUdpNum);
        dto.setUpIcmpNum(upIcmpNum);
        dto.setUpArpNum(upArpNum);
        dto.setDownHttpNum(downHttpNum);
        dto.setDownHttpsNum(downHttpsNum);
        dto.setDownTcpNum(downTcpNum);
        dto.setDownUdpNum(downUdpNum);
        dto.setDownIcmpNum(downIcmpNum);
        dto.setDownArpNum(downArpNum);
        return dto;
    }

    @RequestMapping(value={"/statisticPacketsContentType"}, method={RequestMethod.POST})
    @ResponseBody
    public AnalysisContentTypeStatisticDTO statisticPacketsContentType(@RequestBody PacketStatisticFilterParamsReq req) {
        Criteria upCriteria = new Criteria();
        Criteria downCriteria = new Criteria();
        if (!CollectionUtils.isEmpty((Collection)req.getBatchIds())) {
            upCriteria = upCriteria.and("batchId").in((Collection)req.getBatchIds());
            downCriteria = downCriteria.and("batchId").in((Collection)req.getBatchIds());
        }
        upCriteria = upCriteria.and("upstream").is((Object)true);
        downCriteria = downCriteria.and("upstream").is((Object)false);
        Query upQuery = new Query((CriteriaDefinition)upCriteria);
        Query downQuery = new Query((CriteriaDefinition)downCriteria);
        long upHttpsNum = this.genericDao.count(upQuery, AnalyzedHttpsPacket.class);
        long upTcpNum = this.genericDao.count(upQuery, AnalyzedTcpPacket.class);
        long upUdpNum = this.genericDao.count(upQuery, AnalyzedUdpPacket.class);
        long upIcmpNum = this.genericDao.count(upQuery, AnalyzedIcmpPacket.class);
        long upArpNum = this.genericDao.count(upQuery, AnalyzedArpPacket.class);
        long downHttpsNum = this.genericDao.count(downQuery, AnalyzedHttpsPacket.class);
        long downTcpNum = this.genericDao.count(downQuery, AnalyzedTcpPacket.class);
        long downUdpNum = this.genericDao.count(downQuery, AnalyzedUdpPacket.class);
        long downIcmpNum = this.genericDao.count(downQuery, AnalyzedIcmpPacket.class);
        long downArpNum = this.genericDao.count(downQuery, AnalyzedArpPacket.class);
        long upStreamOtherNum = upHttpsNum + upTcpNum + upUdpNum + upIcmpNum + upArpNum;
        long downStreamOtherNum = downHttpsNum + downTcpNum + downUdpNum + downIcmpNum + downArpNum;
        AnalysisContentTypeStatisticDTO dto = new AnalysisContentTypeStatisticDTO();
        dto.setUpOtherNum(upStreamOtherNum);
        dto.setDownOtherNum(downStreamOtherNum);
        List distinctPacketCounts = this.analysisService.aggregatePacketsByProperty(req.getBatchIds(), "contentType", AnalyzedHttpPacket.class);
        for (DistinctPacketCount distinctPacketCount : distinctPacketCounts) {
            if (HttpContentTypeEnum.HTML.name().equals(distinctPacketCount.getPropertyValue())) {
                if (distinctPacketCount.getUpstream().booleanValue()) {
                    dto.setUpHtmlNum((long)distinctPacketCount.getCount().intValue());
                    continue;
                }
                dto.setDownHtmlNum((long)distinctPacketCount.getCount().intValue());
                continue;
            }
            if (HttpContentTypeEnum.PLAIN.name().equals(distinctPacketCount.getPropertyValue())) {
                if (distinctPacketCount.getUpstream().booleanValue()) {
                    dto.setUpPlainNum((long)distinctPacketCount.getCount().intValue());
                    continue;
                }
                dto.setDownPlainNum((long)distinctPacketCount.getCount().intValue());
                continue;
            }
            if (HttpContentTypeEnum.XML.name().equals(distinctPacketCount.getPropertyValue())) {
                if (distinctPacketCount.getUpstream().booleanValue()) {
                    dto.setUpXmlNum((long)distinctPacketCount.getCount().intValue());
                    continue;
                }
                dto.setDownXmlNum((long)distinctPacketCount.getCount().intValue());
                continue;
            }
            if (HttpContentTypeEnum.JSON.name().equals(distinctPacketCount.getPropertyValue())) {
                if (distinctPacketCount.getUpstream().booleanValue()) {
                    dto.setUpJsonNum((long)distinctPacketCount.getCount().intValue());
                    continue;
                }
                dto.setDownJsonNum((long)distinctPacketCount.getCount().intValue());
                continue;
            }
            if (HttpContentTypeEnum.ATTACHMENT.name().equals(distinctPacketCount.getPropertyValue())) {
                if (distinctPacketCount.getUpstream().booleanValue()) {
                    dto.setUpAttachmentNum((long)distinctPacketCount.getCount().intValue());
                    continue;
                }
                dto.setDownAttachmentNum((long)distinctPacketCount.getCount().intValue());
                continue;
            }
            if (HttpContentTypeEnum.WEBP.name().equals(distinctPacketCount.getPropertyValue())) {
                if (distinctPacketCount.getUpstream().booleanValue()) {
                    dto.setUpWebpNum((long)distinctPacketCount.getCount().intValue());
                    continue;
                }
                dto.setDownWebpNum((long)distinctPacketCount.getCount().intValue());
                continue;
            }
            if (HttpContentTypeEnum.JPEG.name().equals(distinctPacketCount.getPropertyValue())) {
                if (distinctPacketCount.getUpstream().booleanValue()) {
                    dto.setUpJpegNum((long)distinctPacketCount.getCount().intValue());
                    continue;
                }
                dto.setDownJpegNum((long)distinctPacketCount.getCount().intValue());
                continue;
            }
            if (HttpContentTypeEnum.MP4.name().equals(distinctPacketCount.getPropertyValue())) {
                if (distinctPacketCount.getUpstream().booleanValue()) {
                    dto.setUpMp4Num((long)distinctPacketCount.getCount().intValue());
                    continue;
                }
                dto.setDownMp4Num((long)distinctPacketCount.getCount().intValue());
                continue;
            }
            if (!HttpContentTypeEnum.FLV.name().equals(distinctPacketCount.getPropertyValue())) continue;
            if (distinctPacketCount.getUpstream().booleanValue()) {
                dto.setUpFlvNum((long)distinctPacketCount.getCount().intValue());
                continue;
            }
            dto.setDownFlvNum((long)distinctPacketCount.getCount().intValue());
        }
        return dto;
    }

    @RequestMapping(value={"/statisticTimelinePackets"}, method={RequestMethod.POST})
    @ResponseBody
    public AnalysisTimelineStatisticDTO statisticTimelinePackets(@RequestBody PacketStatisticFilterParamsReq req) {
        AnalysisTimelineStatisticDTO dto = this.analysisService.calculateTimelineData(req.getBatchIds());
        return dto;
    }

    @RequestMapping(value={"/getOriginalPackets"}, method={RequestMethod.GET})
    @ResponseBody
    public List<OriginalPacketDTO> getOriginalPackets(@RequestParam(value="originalIds") List<String> originalIds) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").in(originalIds));
        List capturedPackets = this.genericDao.find(query, CapturedPacket.class);
        ArrayList<OriginalPacketDTO> dtos = new ArrayList<OriginalPacketDTO>();
        for (CapturedPacket packet : capturedPackets) {
            OriginalPacketDTO dto = OriginalPacketDTO.readFrom((PacketModel)packet.getPacket());
            dtos.add(dto);
        }
        return dtos;
    }

    @RequestMapping(value={"/capture"}, method={RequestMethod.GET})
    @ResponseBody
    public ResultDTO capture(HttpServletRequest request) {
        String ip = ApiController.getIpAddr((HttpServletRequest)request);
        System.out.println("================" + ip);
        ResultDTO dto = new ResultDTO();
        dto.setResult((Serializable)((Object)ip));
        return dto;
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("X-Real-IP");
        if (ip != null && !"".equals(ip) && !"unknown".equalsIgnoreCase(ip)) {
            return ip;
        }
        ip = request.getHeader("X-Forwarded-For");
        if (ip != null && !"".equals(ip) && !"unknown".equalsIgnoreCase(ip)) {
            int index = ip.indexOf(44);
            if (index != -1) {
                return ip.substring(0, index);
            }
            return ip;
        }
        return request.getRemoteAddr();
    }
}

