/*
 * Decompiled with CFR 0.152.
 */
package com.jpcap.mitm.analysis;

/*
 * Exception performing whole class analysis ignored.
 */
public enum HttpContentTypeEnum {
    HTML("text/html"),
    PLAIN("text/plain"),
    XML("text/xml"),
    JSON("application/json"),
    ATTACHMENT("application/octet-stream"),
    WEBP("image/webp"),
    JPEG("image/jpeg"),
    MP4("video/mp4"),
    FLV("video/x-flv"),
    OTHER("other");

    private String contentType;

    private HttpContentTypeEnum(String contentType) {
        this.contentType = contentType;
    }

    public static HttpContentTypeEnum extract(String contentType) {
        if (contentType == null) {
            return null;
        }
        if (contentType.startsWith(HTML.value())) {
            return HTML;
        }
        if (contentType.startsWith(PLAIN.value())) {
            return PLAIN;
        }
        if (contentType.startsWith(XML.value())) {
            return XML;
        }
        if (contentType.startsWith(JSON.value())) {
            return JSON;
        }
        if (contentType.startsWith(ATTACHMENT.value())) {
            return ATTACHMENT;
        }
        if (contentType.startsWith(WEBP.value())) {
            return WEBP;
        }
        if (contentType.startsWith(JPEG.value())) {
            return JPEG;
        }
        if (contentType.startsWith(MP4.value())) {
            return MP4;
        }
        if (contentType.startsWith(FLV.value())) {
            return FLV;
        }
        return null;
    }

    public static boolean isSupport(String contentType) {
        HttpContentTypeEnum contentTypeEnum = HttpContentTypeEnum.extract((String)contentType);
        return contentTypeEnum != null;
    }

    public String value() {
        return this.contentType;
    }
}

