<p align="center">
	<img alt="logo" src="https://public.huanghanlian.com/blog/article/3ce26e55-1e14-4e51-aec1-1c18533f953c.png" width="300">
</p>
<h1 align="center" style="margin: 30px 0 30px; font-weight: bold;">C-Shopping v1.0.0</h1>

## README.md
- en [English](README.md)
- zh_CN [Simplified Chinese](README.zh_CN.md)

Hello, everyone! Welcome to C-Shopping, a journey into the world of e-commerce unveiling the technological wonders. I am "Ji Xiaopeng," the open-source author of C-Shopping, and today, I will introduce you to an open-source e-commerce platform based on the latest technologies. Let's explore together!

**Project Live Demo Links:**

- Docker Deployment Address: [http://shop.huanghanlian.com/](http://shop.huanghanlian.com/)
- Vercel Address: [https://c-shopping-three.vercel.app/](https://c-shopping-three.vercel.app/)


Project gateway: [https://github.com/huanghanzhilian/c-shopping](https://github.com/huanghanzhilian/c-shopping).


**React Native mobile app application:**

Project gateway: [https://github.com/huanghanzhilian/c-shopping-rn](https://github.com/huanghanzhilian/c-shopping-rn).

If you find this helpful, please give me a Star. It will be a great encouragement.

---

## Project Background

![Project Background](https://public.huanghanlian.com/blog/article/c1f2d5ba-6fa9-4994-9f9d-c4f49497fd0c.jpeg)

**Background:**
- Traditional front-end UI frameworks have long been constrained by fixed forms (limited by traditional UI frameworks), leading to visual fatigue. When developing highly customized projects, there is often a sense of powerlessness.
- Excellent web projects with multi-device adaptation are rare, with high learning and maintenance costs.
- As projects become complex, dealing with multiple API calls in components can become complicated. For example, managing multiple loading and error states can lead to a declaration of numerous states. Issues like request cancellation and request race conditions are also prone to being overlooked.
- As the project complexity grows, the development and maintenance of styles become extensive and cumbersome.

**Intent:**

Address the issues mentioned in the background.

**Objective:**

Build a complete, well-designed ecosystem suitable for the web.

---

Firstly, let's delve into the technology behind C-Shopping. I have adopted a series of cutting-edge technologies, including Next.js, Tailwind CSS, Headless UI, Redux-Toolkit-RTK Query, JWT, and Docker, among others. This ensures that this project is not only efficient but also highly scalable. We are committed to addressing some pain points of traditional e-commerce platforms: lack of aesthetics, inadequate adaptation to different devices, and a monotonous interface, among others. By adopting the latest technologies and design principles, C-Shopping creates a fully responsive technical development experience for users.

C-Shopping prioritizes user experience. Our interface is not only beautiful but also responsive, allowing users to enjoy shopping easily on any device. The personal center and order management functions also make your shopping experience more personalized and convenient.

---

## Project Highlights

One of the highlights of C-Shopping is the adoption of a series of advanced technologies, including Next.js, Tailwind CSS, Headless UI, Redux-Toolkit-RTK Query, etc., providing users with an ultimate performance and experience. We not only focus on aesthetics but also strive for excellence in technology.

 **Next.js Driven Lightning-Fast Experience**

C-Shopping uses Next.js, meaning not only is the webpage loading speed incredibly fast, but it also supports server-side rendering, providing an unprecedented level of smoothness.

🎨 **Tailwind CSS Stylish Design**

By using Tailwind CSS, C-Shopping injects a sense of style. Each interface is exquisite, making shopping a visual feast.

🔧 **Headless UI Freedom and Flexibility**

C-Shopping opts for the Headless UI style, giving users more freedom during the shopping process. No longer confined to traditional UI frameworks, it opens more doors for customization.

🔐 **JWT Security Without Worries**

Security is paramount! JWT is used for user authentication, providing the strongest guarantee for your shopping behavior, allowing you to shop with confidence.

🐳 **Docker Perfect Deployment**

C-Shopping embraces Docker, making project deployment incredibly simple. Containerization allows the entire project to run seamlessly in different environments.

🔄 **Redux Toolkit and RTK Query State Management Art**

C-Shopping uses Redux Toolkit and RTK Query, making state management more relaxed and enjoyable. You can better track data flow in the application, ensuring the stability of the shopping experience.

---

## Feature Demo

Now, let's take a look at some basic features of C-Shopping. From clear navigation and product displays to convenient search and shopping cart features, every detail has been carefully designed to provide users with a pleasant shopping experience.

**User-side**

| Module| Desktop devices| Mobile devices|
|--|------------|--|
| Home| <img src="https://public.huanghanlian.com/blog/article/901edcbd-b143-4f33-9d35-74fda6dbcb0d.gif" /> | <img src="https://public.huanghanlian.com/blog/article/cb1e4f8f-aab4-4b83-8cf5-13558bb8f6dc.gif" /> |
| Secondary Category | <img src="https://public.huanghanlian.com/blog/article/6b53db16-d55b-4c7b-8088-fb637aad3921.png" /> | <img src="https://public.huanghanlian.com/blog/article/542c8bf9-344a-4c19-a9e3-27bc0ec92bd5.png" /> |
| Third-level Category | <img src="https://public.huanghanlian.com/blog/article/94ca43fa-3381-45a5-a5bf-80499533f3d5.png" /> | <img src="https://public.huanghanlian.com/blog/article/f90b95ba-4b43-48fa-bf70-7736fcc7f9c5.png" /> |
| Product Details  | <img src="https://public.huanghanlian.com/blog/article/183dd238-2f33-48b3-85f6-d917bf78ba01.png" /> | <img src="https://public.huanghanlian.com/blog/article/eb4ae7db-c490-4af2-a99c-d0b10fd6c01e.png" /> |
| Login | <img src="https://public.huanghanlian.com/blog/article/e9a0ce6a-f1e9-4b5d-a03e-236338243e48.png" /> | <img src="https://public.huanghanlian.com/blog/article/3ec1a909-294c-40d5-98dd-8c890cd8eba2.png" /> |
| Register | <img src="https://public.huanghanlian.com/blog/article/5070ac14-4ae8-4eae-9491-27dc33db693f.png" /> | <img src="https://public.huanghanlian.com/blog/article/88d32659-0a3d-453c-8f2d-daa8e4ee1b14.png" /> |
| Search | <img src="https://public.huanghanlian.com/blog/article/375b23ff-c493-498a-9ca5-e42d1e15e4c9.png" /> | <img src="https://public.huanghanlian.com/blog/article/52518186-e141-4614-8da8-c38a31c7895b.png" /> |
| Shopping Cart | <img src="https://public.huanghanlian.com/blog/article/233ee4fb-e1ca-4716-ba5f-17224bb252bf.png" /> | <img src="https://public.huanghanlian.com/blog/article/17578ef8-1af0-4b03-9942-f5f805d9045b.png" /> |
| Checkout | <img src="https://public.huanghanlian.com/blog/article/2cc56a0c-f2b1-4f4c-9bd0-1aea5d4a36a5.png" /> | <img src="https://public.huanghanlian.com/blog/article/334c73aa-db17-4624-8e0f-c7ea44236974.png" /> |
| User Profile | <img src="https://public.huanghanlian.com/blog/article/3d1db865-9b6b-4c4d-8803-9b94444def73.png" /> | <img src="https://public.huanghanlian.com/blog/article/a671fef1-401c-4c3d-9a1d-6cd59ecb9d63.png" /> |
| My Orders | <img src="https://public.huanghanlian.com/blog/article/aab4ff6f-50ea-48b8-a74b-dbb6fe178810.png" /> | <img src="https://public.huanghanlian.com/blog/article/8114f995-495c-4044-8b6b-2ef2a746d125.png" /> |
| My Reviews | <img src="https://public.huanghanlian.com/blog/article/dfa14b9e-2c19-4ea1-b4c9-45483bbc52fe.png" /> | <img src="https://public.huanghanlian.com/blog/article/686c0dd9-d9a0-4ff3-9953-eef499349930.png" /> |
| Address Management | <img src="https://public.huanghanlian.com/blog/article/1c214382-d281-43b8-87c6-159b9b10e965.png" /> | <img src="https://public.huanghanlian.com/blog/article/d4448bfc-40b0-4b18-ae47-c3a9f9884918.png" /> |
| Recent Visits | <img src="https://public.huanghanlian.com/blog/article/c375fe8d-fb49-45a3-bdfc-8a90de031b25.png" /> | <img src="https://public.huanghanlian.com/blog/article/73a67a1d-a9ae-4ded-990a-4ef172671d34.png" /> |

**Admin-side**

| Module           | Desktop devices | Mobile devices|
|--|------------|--|
| Login            | <img src="https://public.huanghanlian.com/blog/article/10fc1ee3-44ec-4380-ba90-6b2d809fb625.png" /> | <img src="https://public.huanghanlian.com/blog/article/d3995bbe-df4f-490a-b8df-998932840ab6.png" /> |
| Admin Center     | <img src="https://public.huanghanlian.com/blog/article/ae09d053-e2df-4176-8470-b063f556069e.png" /> | <img src="https://public.huanghanlian.com/blog/article/633169d7-a616-40fc-8970-d79748734873.png" /> |
| User Management  | <img src="https://public.huanghanlian.com/blog/article/250ee952-3757-42db-8828-60d8142edd4a.png" /> | <img src="https://public.huanghanlian.com/blog/article/ad6fa92c-2bda-4391-9c93-e59fdeff59c3.png" /> |
| Category Management | <img src="https://public.huanghanlian.com/blog/article/f644d10f-bda4-4309-944c-587dbe3e8931.png" /> | <img src="https://public.huanghanlian.com/blog/article/458eb6ab-2c88-4654-8262-81dffe0b3c66.png" /> |
| Category Management Tree | <img src="https://public.huanghanlian.com/blog/article/8eef2702-c06b-4996-bd15-229a3ccb6e2d.png" /> | <img src="https://public.huanghanlian.com/blog/article/27516b00-c0e0-4a12-aedc-a9f64f64db1b.png" /> |
| Specification Management | <img src="https://public.huanghanlian.com/blog/article/50eb69ce-0545-4def-91e2-ceac09b1222d.png" /> | <img src="https://public.huanghanlian.com/blog/article/b96bc0fe-ad45-4b1c-b4d9-945e675cc7b9.png" /> |
| Product Management | <img src="https://public.huanghanlian.com/blog/article/893128e7-06e3-47b5-9fb8-8757faf28941.png" /> | <img src="https://public.huanghanlian.com/blog/article/1d9b03aa-8673-4405-ad2f-2d61e413c114.png" /> |
| Order Management | <img src="https://public.huanghanlian.com/blog/article/e5473ac2-859c-4774-8879-f31516da956a.png" /> | <img src="https://public.huanghanlian.com/blog/article/7ac7850b-798c-4954-95ad-3fab562bf418.png" /> |
| Review Management | <img src="https://public.huanghanlian.com/blog/article/3979c2fc-87ca-4604-8258-5be1e5af97b9.png" /> | <img src="https://public.huanghanlian.com/blog/article/0df0021a-626f-452c-b4dc-d9b0c927d4e3.png" /> |
| Slider Management | <img src="https://public.huanghanlian.com/blog/article/6419e018-3322-40f6-b796-105e125d7052.png" /> | <img src="https://public.huanghanlian.com/blog/article/b695af32-cd0e-4009-a278-adb2a4f22b2f.png" /> |
| Banner Management | <img src="https://public.huanghanlian.com/blog/article/c8fd0a19-f020-41b1-8590-8e88d7d4f659.png" /> | <img src="https://public.huanghanlian.com/blog/article/7bc682e2-60c2-45f3-80c3-e94ade1223b2.png" /> |

---


## Project Structure

🏗️ **C-Shopping Project Structure:**

**Key structure explanation:**

- 📁 **app**: Main code of the application
  - 📁 **main**: Main application components
    - 📁 **client-layout**: Common layout pages for the user side
    - 📁 **empty-layout**: Common blank layout pages
    - 📁 **admin**: Admin pages
    - 📄 **layout.js**: Main layout configuration
    - 📁 **profile**: User profile page
  - 📄 **StoreProvider.js**: Global state management provider
  - 📁 **api**: API request-related routes
    - 📁 **auth**: User authentication API
    - 📁 **banner**: Advertisement banner API
    - 📁 **category**: Product category API
    - ...

- 📁 **components**: Reusable React components
- 📁 **helpers**: Helper functions and tools
  - 📁 **api**: API request-related helper functions
  - 📄 **auth.js**: Helper functions related to user authentication
  - ...

- 📁 **hooks**: Custom React hooks
- 📁 **models**: Data model definitions
- 📁 **public**: Static resources, such as images, fonts, etc.
- 📁 **store**: Configuration related to Redux state management
   - 📁 **services**: RTK Query
   - 📁 **slices**: Redux Toolkit
- 📁 **styles**: Style files
- 📁 **utils**: General utilities
- ...

This structure is designed to make the project organized, easy to maintain, and scalable. Each section is divided based on

functionality and responsibilities, making it easier for team members to understand and collaborate.

---

## Deployment and Usage

**Development Environment**

1. Clone or download the repository by running the following command in the terminal:

    ```
    git clone https://github.com/huanghanzhilian/c-shopping.git
    ```

2. Install project dependencies using npm or yarn:

    ```
    npm install
    ```

    or

    ```
    yarn
    ```

3. Please create a new `.env` file from `.env.example` file in the project root directory to define the required environment variables. This step is crucial (for image upload to OSS):

    ```
    NEXT_PUBLIC_ACCESS_TOKEN_SECRET=<your token secret>
    NEXT_PUBLIC_ALI_REGION=<your ali endpoint>
    NEXT_PUBLIC_ALI_BUCKET_NAME=<your ali bucket name>
    NEXT_PUBLIC_ALI_ACCESS_KEY=<your ali access key>
    NEXT_PUBLIC_ALI_SECRET_KEY=<your ali secret key>
    NEXT_PUBLIC_ALI_ACS_RAM_NAME=<your ali acs:ram name>
    NEXT_PUBLIC_ALI_FILES_PATH=<your ali files pathname>
    ```

4. Install MongoDB on your local machine.

5. Run the project:

    ```
    npm run dev 
    ```

6. Register an account:

    ```
    http://localhost:3000/register
    ```

7. After creating an account, find your account in the database and modify the `root` field to true and the `role` field to admin. This grants you access to all admin dashboard features:
    ```
    mongo
    ```
    ```
    use choiceshop
    ```
    ```
    db.users.update({name:"admin"},{$set:{role:"admin"}})
    db.users.update({name:"admin"},{$set:{root:true}})
    ```

    Administrator entrance: http://localhost:3000/admin

8. In MongoDB, create the root category:

    ```
    mongo
    ```

    ```
    use choiceshop
    ```

    ```
    db.categories.insert({
        "name" : "Featured Items",
        "slug" : "choiceshop",
        "image" : "http://huanghanzhilian-test.oss-cn-beijing.aliyuncs.com/shop/upload/image//icons/zHle_bmdM_dhu2K938MMM.webp",
        "colors" : {
            "start" : "#EF394E",
            "end" : "#EF3F55"
        },
        "level" : 0
    })
    ```

**Docker Deployment**

The project root directory is already configured with Docker Compose. After installing Docker, simply run the deployment:

```
docker compose up -d --build
```

---

## Contact Me

I am a technology explorer, a eager learner, and a problem solver.
<br/>
我是一个技术的探索者，一个渴望学习的人，一个解决问题的人。

- Email: [h1319639755@gmail.com](mailto:h1319639755@gmail.com)
- Twitter: [继小鹏](https://twitter.com/Huanghanzhilian)
- Github: [Github](https://github.com/huanghanzhilian)
- Blog: [继小鹏](https://blog.huanghanlian.com/)
- 我的中文渠道:
  - 微博：[继小鹏1](https://weibo.com/u/5653497957)
  - 微信公众号：「继小鹏的博客」
  - 掘金：[继小鹏](https://juejin.cn/user/2119514150414686)
  - 知乎：[继小鹏](https://www.zhihu.com/people/huang-han-zhi-lian)
  - 即刻：[继小鹏](https://web.okjike.com/u/BA3424F7-4D6E-4A2C-BA7E-138B616EED05)
  - bilibili：[继小鹏](https://space.bilibili.com/191128853)

### WeChat Official Account | My WeChat

Follow our WeChat Official Account for more information. Feel free to provide any feedback or suggestions by opening an issue or leaving a message on the Official Account. You're also welcome to add me on WeChat for further communication.

| My WeChat Official Account | My WeChat |
| -------------------------- | --------- |
| <img alt="Ji Xiao Peng Official Account" src="https://public.huanghanlian.com/blog/article/4632461d-0d43-4378-bcf7-bb32bf0de950.jpeg" width="150"> | <img alt="My WeChat" src="https://public.huanghanlian.com/blog/article/6f041fb6-2141-49d8-b20b-6e989687bf9a.png" width="150"> |

---

## License

[MIT](https://github.com/huanghanzhilian/c-shopping/blob/main/LICENSE)

Copyright (c) 2024 Jipeng Huang

---

## Call to Action

C-Shopping is an open-source project, and we welcome more developers to join our community. You can find the project source code on our GitHub repository, suggest improvements, or contribute to development.

If you're interested in the project, feel free to join our community and contribute to the project's growth.