namespace Comanda.WebApi.Handlers;

public sealed class DecrementCartItemQuantityHandler(
    ICartRepository cartRepository,
    ICustomerRepository customerRepository,
    IUserContextService userContextService
) : IRequestHandler<DecrementCartItemQuantityRequest, Response>
{
    public async Task<Response> Handle(
        DecrementCartItemQuantityRequest request,
        CancellationToken cancellationToken
    )
    {
        var userIdentifier = userContextService.GetCurrentUserIdentifier();

        /*
            It is impossible for the 'userIdentifier' to be null at this point
            since the 'CartController' restricts access only to authenticated customers.
        */
        #pragma warning disable CS8604, CS8602

        var customer = await customerRepository.FindCustomerByUserIdAsync(userIdentifier);

        /*
            Even here it can't be null because when we create an account
            we have already created and associated a customer with it.
        */

        var cart = await cartRepository.FindCartWithItemsAsync(customer.Id);

        var itemToDecrement = cart.Items
            .FirstOrDefault(item => item.Id == request.ItemId);

        if (itemToDecrement is null)
            return new Response(
                statusCode: StatusCodes.Status404NotFound,
                message: "Cart item not found."
            );

        if (itemToDecrement.Quantity == 1)
            return new Response(
                statusCode: StatusCodes.Status400BadRequest,
                message: "Cannot decrement quantity below 1."
            );

        itemToDecrement.Quantity--;

        await cartRepository.UpdateItemAsync(itemToDecrement);

        return new Response(
            statusCode: StatusCodes.Status200OK,
            message: "Cart item quantity updated successfully."
        );
    }
}