<?php
namespace app\index\controller;
use think\Controller;
use app\index\controller\Common;

class Show extends Common
{
    public function index()
    {
		$id = input('id','','intval');
		$tpl = $this->doIndex($id);	
		return $this->fetch('index@'.config('webthemes').'/show'.$tpl);		
    }
	
	/***详情处理方法
	* @params id 文章ID, mbispc 0 电脑端 1 移动端	
	***/
	public function doindex($id,$mbispc=0){
		$aid = $id ? intval($id) : exit('error');
		$one  = db('article')->where(array('id'=>$aid))->find();
		if(empty($one)){ exit('error');}
		$navrow = db('nav')->where('id',$one['nid'])->find();		
		$data['showcate'] = $navrow['showcate'];		
		$data['entitle']  = $navrow['entitle'];
		$data['columnName'] = $navrow['title'];
		$data["banner"]	 = isMobile() ? $navrow['img1'] : $navrow['img'];
		$data['id'] = $aid;
		$view['views'] = $one['views']+1;
		db('article')->where('id',$aid)->update($view);//浏览次数				
		//无分类
		if($data['showcate']==0){ 			
			$data["leftlist"] = db('article')->field('id,title')->where('nid',$one['nid'])->order("sort,id")->select();						
		}		
		//有分类
		if($data['showcate']==1){			
			$data['cid'] = $one['cid'];	
			$data["leftlist"] = webtreelist('cate','title,id,entitle',['nid'=>$one['nid']]);			
			if($one['imgs']!=""){
				$image = explode('|',$one['imgs']);				
			}else{
				$one['img'] = _getbigimg($one['img']);
				$image[0]   = $one['img'];
			}					
			$data['image'] = $image;
			$data['cateName'] = getCateName($one['cid'],$one['nid']);
			$data['pn'] = prevNext($aid,$navrow['entitle'],$one,$mbispc);		
		}		
		$data['one'] = $one;
		$data['nid'] = $one['nid'];
		$data['site'] = getseo($one['nid'],$aid,$one['cid']);
		$this->assign($data);
		
		//模板定义 
		$ntpl  = $navrow['showcate']==1?$navrow['msg_tpl']:$navrow['msg_tpl'];
		$mtpl  = db('module')->where('id',$navrow['mid'])->value('tpl');
		$tpl   = $ntpl ? $ntpl : $mtpl;	
		return $tpl;		
	}

	
	//保存表单@发送邮件
	public function sendemail(){
		if($this->request->isPost()){
		  $data = input("post.");
		  $time = session('booktime');
		  if(time() - $time > 60 ){
			  $data['datetime'] = time();
			  $issend = config('email_issend');
			  if($issend==1){
				sendemail($data);	//发送邮件	 
			  }
			  if(db('book')->insert($data)){
				session('booktime',time());  
				return json(['code'=>'1','msg'=>'留言成功']);				
			  }else{
			  	return json(['code'=>'0','msg'=>'留言失败']);
			  }
		  }else{
		  	return json(['code'=>'0','msg'=>'请稍后再试-_-']);
		  }
	   }
	}
	
	//获取token
	public function getToken(){
		session('token',request()->token());
		return json(['code'=>'0','__token__'=>session('token')]);
	}
	
}
