<?php
namespace app\index\controller;
use think\Controller;
use think\Request;
use SimpleXMLElement;


define('RE_NO_LOGIN', 100); //未登录
define('RE_LOGIN_INVALID', 101); //登录失效
define('RE_ERROR', 1);      //通用错误
define('RE_SUCCESS', 0);	   //成功

class Common extends Controller
{	
	public function _initialize(){
			if (!is_file(APP_PATH.'common/install.lock')) {	
				header("Location: /index.php/install/index");
				exit;
			}			
			//设置配置文件
			$config = model("common/Config")->getConfig();			
			config($config);					
				
			//站点状态	
			if(config('webstatus')==0){
				exit(config('webclosedesc'));
			}			
			      		
			//判断是否移动端
			$url = $_SERVER['HTTP_HOST'];
			if(config('webmstatus') == 1){
				if($url == config('webmurl') && config('weburltype')){
					header('Location:http://'.config('webmurl').'/m');	
                    exit;
				}
				if($url == config('webmurl') && !config('weburltype')){
					config('webthemes',config('webmthemes'));	
				}
				if(isMobile()){
					if(config('webmurl') != ""  && config('weburltype')){
						header('Location:http://'.config('webmurl'));
                      	exit;
					}
					config('webthemes',config('webmthemes'));
				}
			}	
			
			//获取登录信息
			$meminfo = array();
			$uid = \think\Cookie::get('uid');
			$token = \think\Cookie::get('token');
			if($uid!=null&&$token!=null){$meminfo = db('member')->where(['id'=>$uid,'token'=>$token])->find();}
			$this->assign("meminfo",$meminfo);	
			
			spider(); //蜘蛛爬虫	
			$this->assign('weburltype',config('weburltype'));
			$this->assign('webmurl',config('webmurl'));	
			$this->assign("nav",nav());		
   }
}
