#!/home/freundt/usr/bin/Rscript --vanilla

library(httr)
library(data.table)
library(rvest)

set_config(config(ssl_verifypeer = 0L))

.hijri_m <- setkey(fread("h	n
محرم	1
صفر	2
ربيع الأول	3
ربيع الثاني	4
جمادى الأولى	5
جمادى الآخرة	6
رجب	7
شعبان	8
رمضان	9
شوال	10
ذو القعدة	11
ذو الحجة	12
", sep="\t"))
.greg_m <- setkey(fread("m	n
يناير	1
فبراير	2
مارس	3
إبريل	4
مايو	5
يونيو	6
يوليو	7
أغسطس	8
سبتمبر	9
أكتوبر	10
نوفمبر	11
ديسمبر	12
", sep="\t"))

anal_year <- function(y)
{
	if (!is.finite(as.integer(y))) {
		warning("Year number is not integral")
	}
	GET(paste0('https://www.ummulqura.org.sa/yearcalender.aspx?y=',y,'&l=True')) -> x
	x <- content(x)
	cal <- html_element(x, xpath='//table//table[count(tr)=4 and count(tr/td)=12]')
	mos <- html_elements(cal, xpath='tr/td//td[count(table)=2]')

	## ym_hijri <- html_text(html_element(mos[12L], xpath='table[1]//span'))
	## ym_greg <- html_text(html_element(mos[1L], xpath='table[2]/tr[2]//span'))

	anal_month <- function(nod)
	{
		ym_hijri <- html_text(html_element(nod, xpath='table[1]//span'))
		ym_greg <- html_text(html_element(nod, xpath='table[2]/tr[2]//span'))
		mon <- html_element(nod, xpath='table[2]/tr[4]/td/table')
		d_hijri <- html_text(html_elements(mon, xpath='tr/td/table/tr[1]/td/span/text()'))
		d_greg <- html_text(html_elements(mon, xpath='tr/td/table/tr[2]/td/span/text()'))

		r <- data.table(hd=d_hijri,
				hm=.hijri_m[sub(" [0-9].*","",ym_hijri),n],
				hy=sub(".*?([0-9]+).*","\\1",ym_hijri),
				gd=d_greg,
				gm=.greg_m[sub(" [0-9].*","",ym_greg),n],
				gy=sub(".*?([0-9]+).*","\\1",ym_greg))
		r[hd=="1"]
	}

	rbindlist(lapply((1L:12L), function(i) anal_month(mos[i])))
}

if (sys.nframe() == 0L) {
	args <- commandArgs(trailingOnly=TRUE)
	outf <- ""

	if ("--help" %in% args || "-h" %in% args) {
		sink(stderr())
		cat("Usage: snarf-ummulqura.R [-o OUTFILE] [--as.c] YEAR...\n");
		sink()
		quit();
	}
	if (!is.na(tmp <- match("-o", args))) {
		args <- args[-tmp]
		outf <- args[tmp]
		args <- args[-tmp]
	}
	if (as.c <- !is.na(tmp <- match("--as.c", args))) {
		args <- args[-tmp]
	}

	r <- rbindlist(lapply(args, anal_year))
	## as a service calculate the ldn
	r[, ldn := as.integer(as.IDate(paste(gy,gm,gd,sep='-')))+141427L]
	r <- unique(setkey(r, ldn))
	if (!as.c) {
		fwrite(r, outf, sep="\t", na="", quote=FALSE)
	} else {
		r <- r[, .(ldn=paste0(ldn,'U',collapse=',')), by="hy"]

		sink(outf)
		cat('/* auto-generated by snarf-ummulqura.R */\n\n')
		cat('#define UMMULQURA_BASE (',r[,min(hy)],')\n\n');
		cat('static uint32_t _bom[][12] = {\n')
		cat(r[, paste0('\t[',hy,' - UMMULQURA_BASE] = {',ldn,'},')],sep='\n')
		cat('};\n')
		sink()
	}
}
