# Japanese Conjugation Helper

## ⚠ This project has been been retired ⚠

**A console application that will conjugate Japanese verbs, adjectives and nouns. Get kanji infomation, download audio of pronunciations, various tests and practice, a translator & sentence breakdown and more!**

### [Here](https://imgur.com/a/DUNexpG) you can see the program performing its main functions.

**Download the program [here](https://github.com/hopto-dot/Japanese-Conjugation-Helper/releases).**
**For the main functionality of bringing up conjugations of a word, simple type the word on it's own (in Japanese, Romaji or the English word). Find out more about how this and other commands work in [the Wiki](https://github.com/hopto-dot/Japanese-Conjugation-Helper/wiki/How-to-use).**

## **Main [Functions](https://github.com/hopto-dot/Japanese-Conjugation-Helper/wiki/How-to-use#list-of-commands):**
#### *Useful things are in bold*
* **[Word Lookup](https://github.com/hopto-dot/Japanese-Conjugation-Helper/wiki/How-to-use#word-lookup)** - Looks up any word, phrase or sentence
* **[Last Requests](https://github.com/hopto-dot/Japanese-Conjugation-Helper/wiki/How-to-use#last-requests)** - Things you can do after searching a word
* **[S parameter](https://github.com/hopto-dot/Japanese-Conjugation-Helper/wiki/How-to-use#s-parameter)** - A parameter that determines how much information about a word is displayed
* **[Kanji Information](https://github.com/hopto-dot/Japanese-Conjugation-Helper/wiki/How-to-use#kanji-information)** - Enter Japanese text and detailed information on all the kanji
* **[/count](https://github.com/hopto-dot/Japanese-Conjugation-Helper/wiki/How-to-use#count)** - Accurately translate numbers (with or without counters) into its furigana reading
* **[Preferences](https://github.com/hopto-dot/Japanese-Conjugation-Helper/wiki/How-to-use#prefs-command)** - Lets you change program settings, these are saved for the next time you use the program.
* [Audio](https://github.com/hopto-dot/Japanese-Conjugation-Helper/wiki/How-to-use#audio) - Downloads audio of various conjugations of a verb or adjective
* Download subtitles - Download anime subtitles in either Japanese or English (specify the language after you've typed '/subtitles')
* [Conjugator Practice](https://github.com/hopto-dot/Japanese-Conjugation-Helper/wiki/How-to-use#conjugation-practice) - Conjugation practice (practice conjugating a word of your choice into different forms)
* [Translator](https://github.com/hopto-dot/Japanese-Conjugation-Helper/wiki/How-to-use#translator) - Translates English into Japanese, or Japanese into English (type '!' in front of a sentence)
* [Listening](https://github.com/hopto-dot/Japanese-Conjugation-Helper/wiki/How-to-use#listening) - Start a listening test for a verb or adjective
* [Kanji Test](https://github.com/hopto-dot/Japanese-Conjugation-Helper/wiki/How-to-use#kanji-test) - Enter Japanese text and get tested on all the kanji
* HeyLingo Audio Downloader (/heylingo) - Downloads audio from [Hey! Lingo](https://www.heylingo.com/) courses. This command is broken.

## Extra Commands
* /dsp - change the default [S parameter](https://github.com/hopto-dot/Japanese-Conjugation-Helper/wiki/How-to-use#s-parameter) that is used when you search for a word (same functionality as going into [Preferences](https://github.com/hopto-dot/Japanese-Conjugation-Helper/wiki/How-to-use#prefs-command) and changing it)
* /history - See your last 40 searches
* /b - Instantly go back to your last search (no internet connection needed)
* /saves - Shows all the words you've saved (to save a word, first search for one then type 'save')
* [/h or /help](https://github.com/hopto-dot/Japanese-Conjugation-Helper/wiki/How-to-use#help-command) - Brings up more information about a command, no longer updated
* Offline Searching - do '//[search]' to search for a word offline (not very effective)

***
## **If you see "⍰" being displayed where Japanese characters are meant to be then follow the steps shown below:**
1. Click the ConjugationHelper icon in the very top left corner of the console window
2. Then click "properties" at the bottom
3. Lastly, make sure you are on the "Font" tab and select the "MS Mincho" font, there are a few other fonts that work too such as MS Gothic
![Japanese Characters](https://i.imgur.com/x7gDhB9.png)
***
