module.exports = {
	'image expando': browser => {
		if (browser.options.desiredCapabilities.browserName === 'firefox') {
			// firefox is not able to perform the tab switch part of the test
			browser.end();
			return;
		}

		let oldWindowHandles;

		browser
			.url('https://en.reddit.com/r/RESIntegrationTests/comments/drz1sx/image_expando/')
			.waitForElementVisible('.expando-button')
			.assert.cssClassPresent('.expando-button', 'image')
			.assert.cssClassPresent('.expando-button', 'collapsed')
			.assert.attributeEquals('.expando-button', 'data-host', 'default')

			.click('.expando-button')
			.waitForElementVisible('.res-expando-box')
			.assert.attributeEquals('.res-expando-box', 'data-host', 'default')
			.assert.attributeEquals('.res-expando-box img', 'src', 'https://upload.wikimedia.org/wikipedia/commons/b/b1/Joe_Exotic_%28Santa_Rose_County_Jail%29.png')
			.assert.attributeEquals('.res-expando-box a', 'href', 'https://upload.wikimedia.org/wikipedia/commons/b/b1/Joe_Exotic_%28Santa_Rose_County_Jail%29.png')

			.pause(1000)
			.windowHandles(result => {
				// store old window handles, to keep track of, e.g. beta release notes
				oldWindowHandles = result.value;
			})
			.click('.res-expando-box img')
			// old tab didn't navigate
			.assert.urlContains('https://en.reddit.com/r/RESIntegrationTests/comments/drz1sx/image_expando/')
			// image opened in new tab, focused
			.windowHandles(result => {
				browser.switchWindow(result.value.find(win => !oldWindowHandles.includes(win)));
			})
			.pause(1000)
			.assert.urlContains('https://upload.wikimedia.org/wikipedia/commons/b/b1/Joe_Exotic_%28Santa_Rose_County_Jail%29.png')

			.end();
	},
	'video expando': browser => {
		browser
			.url('https://en.reddit.com/r/RESIntegrationTests/comments/60ef59/video_expando/')
			.waitForElementVisible('.expando-button')
			.assert.cssClassPresent('.expando-button', 'video')
			.assert.not.cssClassPresent('.expando-button', 'video-muted')
			.assert.cssClassPresent('.expando-button', 'collapsed')
			.assert.attributeEquals('.expando-button', 'data-host', 'defaultVideo')
			.click('.expando-button')
			.waitForElementVisible('.res-expando-box')
			.assert.attributeEquals('.res-expando-box', 'data-host', 'defaultVideo')
			.assert.attributeEquals('.res-expando-box video > source', 'src', 'http://mediadownloads.mlb.com/mlbam/mp4/2016/04/13/586892283/1460516257186/asset_1800K.mp4')
			.end();
	},
	'audio expando': browser => {
		browser
			.url('https://en.reddit.com/r/RESIntegrationTests/comments/60efz8/audio_expando/')
			.waitForElementVisible('.expando-button')
			.assert.cssClassPresent('.expando-button', 'video')
			.assert.cssClassPresent('.expando-button', 'collapsed')
			.assert.attributeEquals('.expando-button', 'data-host', 'defaultAudio')
			.click('.expando-button')
			.waitForElementVisible('.res-expando-box')
			.assert.attributeEquals('.res-expando-box', 'data-host', 'defaultAudio')
			.assert.attributeEquals('.res-expando-box audio > source', 'src', 'https://wiki.teamfortress.com/w/images/8/85/Scout_stunballhit11.wav?t=20100625234511')
			.end();
	},
	'iframe expando': browser => {
		browser
			.url('https://en.reddit.com/r/RESIntegrationTests/comments/60egvo/iframe_expando/')
			.waitForElementVisible('.expando-button')
			.assert.cssClassPresent('.expando-button', 'video')
			.assert.cssClassPresent('.expando-button', 'collapsed')
			.assert.attributeEquals('.expando-button', 'data-host', 'youtube')
			.click('.expando-button')
			.waitForElementVisible('.res-expando-box')
			.assert.attributeEquals('.res-expando-box', 'data-host', 'youtube')
			.assert.attributeContains('.res-expando-box iframe', 'src', 'https://www.youtube.com/embed/iwGFalTRHDA')
			.assert.visible('.res-iframe-expando-drag-handle', 'resize handle visible')
			.end();
	},
	'generic expando': browser => {
		browser
			.url('https://en.reddit.com/r/RESIntegrationTests/comments/a2pudd/generic_expando/')
			.waitForElementVisible('.expando-button')
			.assert.cssClassPresent('.expando-button', 'selftext')
			.assert.cssClassPresent('.expando-button', 'collapsed')
			.assert.attributeEquals('.expando-button', 'data-host', 'codepen')
			.click('.expando-button')
			.waitForElementVisible('.res-expando-box')
			.assert.attributeEquals('.res-expando-box', 'data-host', 'codepen')
			.end();
	},
	'gallery expando': browser => {
		browser
			.url('https://en.reddit.com/r/RESIntegrationTests/comments/60ehhc/gallery_expando/')
			.waitForElementVisible('.expando-button')
			.assert.cssClassPresent('.expando-button', 'image')
			.assert.cssClassPresent('.expando-button', 'gallery')
			.assert.cssClassPresent('.expando-button', 'collapsed')
			.assert.attributeEquals('.expando-button', 'data-host', 'imgur')
			.assert.attributeEquals('.expando-button', 'title', '2 items in gallery')
			.click('.expando-button')
			.waitForElementVisible('.res-expando-box')
			.assert.attributeEquals('.res-expando-box', 'data-host', 'imgur')
			.assert.containsText('.res-expando-box', '1 of 2')
			.assert.attributeEquals('.res-expando-box .res-gallery-pieces > div:not([hidden]) img', 'src', 'https://i.imgur.com/rXZWEIB.jpg')
			.assert.attributeEquals('.res-expando-box .res-gallery-pieces > div:not([hidden]) a', 'href', 'https://imgur.com/rXZWEIB,eutVEAv#rXZWEIB')
			.click('.res-expando-box .res-step-next')
			.assert.containsText('.res-expando-box', '2 of 2')
			.assert.attributeEquals('.res-expando-box .res-gallery-pieces > div:not([hidden]) img', 'src', 'https://i.imgur.com/eutVEAv.jpg')
			.assert.attributeEquals('.res-expando-box .res-gallery-pieces > div:not([hidden]) a', 'href', 'https://imgur.com/rXZWEIB,eutVEAv#eutVEAv')
			.end();
	},
	'crosspost expando': browser => {
		browser
			.url('https://en.reddit.com/by_id/t3_7wn64k/')
			.waitForElementVisible('.expando-button[data-host]') // Look for `data-host` attribute in case RES doen't replace the native expando immediately
			.click('.expando-button')
			.waitForElementVisible('.res-expando-box')
			.assert.cssClassPresent('.crosspost-preview', 'res-crosspost-preview')
			.assert.containsText('.crosspost-preview .title', 'Image Expando 2')
			.assert.attributeContains('.crosspost-preview a.author', 'href', '/user/erikdesjardins/')
			.assert.attributeContains('.crosspost-preview a.subreddit', 'href', '/r/RESIntegrationTests/')
			.end();
	},
	'show images button': browser => {
		browser
			.url('https://en.reddit.com/by_id/t3_6346fk,t3_6346h7')
			.waitForElementVisible('.res-show-images')
			.assert.containsText('.res-show-images', 'show images')
			.assert.not.cssClassPresent('.res-show-images', 'selected')
			.click('.res-show-images')
			.assert.cssClassPresent('.res-show-images', 'selected')
			.waitForElementVisible('#thing_t3_6346fk .res-expando-box img')
			.waitForElementVisible('#thing_t3_6346h7 .res-expando-box img')
			.click('.res-show-images')
			.assert.not.cssClassPresent('.res-show-images', 'selected')
			.waitForElementNotVisible('#thing_t3_6346fk .res-expando-box img')
			.waitForElementNotVisible('#thing_t3_6346h7 .res-expando-box img')
			.end();
	},
};
