module.exports = {
	'selecting on comments page': browser => {
		if (browser.options.desiredCapabilities.browserName === 'firefox') {
			// Firefox 79.0a seemingly has a bug which prevents RES initializing during the test
			browser.end();
			return;
		}

		const selectedClass = 'RES-keyNav-activeThing';
		const parentPost = '#thing_t3_5lfy0v';
		const stickiedComment = '#thing_t1_dbvc8xr';
		const childComment1 = '#thing_t1_dbvc9il';
		const childComment2 = '#thing_t1_dbvc9kg';
		const childOfStickiedComment1 = '#thing_t1_dbvc99w';
		const childOfStickiedComment2 = '#thing_t1_dbvc9gt';
		const loadMoreComments = `${childComment2} .morecomments a`;
		const loadMoreChildrenOfSticky = `${childOfStickiedComment1} .morecomments a`;

		browser
			// Geckodriver has this wonderful issue where it doesn't support manually moving the mouse
			// (the moveTo command), but after the click command it continues to hover on the same spot
			// that was clicked.
			// In this test, that behaviour causes the user hover info to appear after loading more comments,
			// which breaks everything by covering up the comments we need to click on.
			// It's too difficult to work around, so just disable user info entirely.
			.url('https://en.reddit.com/wiki/pages#res:settings-redirect-standalone-options-page/userInfo')
			.waitForElementVisible('#RESConsoleContainer')
			.click('.moduleToggle')
			// Disable neverEndigComments, as that may auto click the "load more comments" buttons
			.url('https://en.reddit.com/wiki/pages#res:settings-redirect-standalone-options-page/neverEndingComments')
			.click('.moduleToggle')
			.pause(500) // Wait a little before navigating away from the settingsConsole, in case this doesn't save immediatly

			// Run the actual test...
			.url('https://en.reddit.com/r/RESIntegrationTests/comments/5lfy0v/selected_entry_selecting_comments/?limit=1')

			.waitForElementVisible(parentPost)
			.assert.cssClassPresent(parentPost, selectedClass)

			.click(`${stickiedComment} .usertext`) // avoid clicking "hide child comments"
			.assert.cssClassPresent(stickiedComment, selectedClass)

			.pause(1000)
			.click(loadMoreChildrenOfSticky)
			.waitForElementVisible(childOfStickiedComment2)
			.assert.cssClassPresent(childOfStickiedComment1, selectedClass)

			.click(`${childOfStickiedComment2} .md p`)
			.assert.cssClassPresent(childOfStickiedComment2, selectedClass)

			.pause(1000)
			.click(loadMoreComments)
			.waitForElementVisible(childComment1)
			.assert.cssClassPresent(childComment1, selectedClass)

			.click(childComment2)
			.assert.cssClassPresent(childComment2, selectedClass)

			.end();
	},
};
