module.exports = {
	'basic functionality': browser => {
		if (browser.options.desiredCapabilities.browserName === 'firefox') {
			// geckodriver doesn't support elementSendKeys https://github.com/mozilla/geckodriver/issues/159
			browser.end();
			return;
		}

		browser
			.url('https://en.reddit.com/r/RESIntegrationTests/comments/632wur/comment_navigator/')
			.waitForElementVisible('#RESSettingsButton')
			.execute('document.querySelector(".footer").scrollIntoView()') // scroll to bottom
			.keys(['n'])
			.assert.visible('#REScommentNavBox')
			.click('#commentNavBy [value="submitter"]')
			.assert.containsText('#REScommentNavBox', '1/2')
			.assert.visible('#thing_t1_dfqvawk')
			.click('#commentNavDown')
			.assert.containsText('#REScommentNavBox', '2/2')
			.assert.visible('#thing_t1_dfqvaz1')
			.end();
	},
};
