## [v5.4.0](https://github.com/honestbleeps/Reddit-Enhancement-Suite/releases/v5.4.0)

This release consists of changes from the 5.3.x beta releases.

### New Features

- Make more strings localizable (big thanks @wojtekmaj, @BenMcGarry, @jakewilson, @knorssman, @erikdesjardins, @larsjohnsen, @mc10)
- Translate many more strings in many languages (big thanks to our [200+ translators](https://www.transifex.com/reddit-enhancement-suite/reddit-enhancement-suite/)!)
- New Comment Quick Collapse module allowing you to double-click on comment taglines (headers) to collapse them (thanks @jakewilson, @KetillG)
  - Double-click on comment taglines (headers) to collapse/expand
  - Click anywhere along the left edge to collapse/expand (disabled by default, toggleCommentsOnClickLeftEdge option)
  - Scroll on collapse (disabled by default, scrollOnCollapse option)
- New Never Ending Comments module to automatically load more comments when you scroll to the bottom (thanks @dhensche)
- New RES Feature Throttle module to delay or disable some features when they're repeatedly ignored (thanks @andytuba)
- Expandos for YouTube livestreams of the format youtube.com/channel/CHANNELID/live (thanks @WilliamChiu)
- Expandos for spaces.archilogic.com (thanks @bnjm)
- Expandos for liveleak.com (thanks @erikdesjardins)
- New useMobileGfycat option to view lower-resolution Gfycat videos (thanks @leveneg)
- New Page Navigator button to scroll to and focus the new comment textarea (thanks @dhensche, @preethamrn)
- New defaultMinimumComments option to only enable Comment Depth when there are sufficient comments (thanks @dhensche)
- New Show Images media browse by wheel: hover on the grey widget in the floater and scroll to select the next/previous post and navigate through albums (thanks @larsjohnsen)
- New slashAll Go Mode keyboard shortcut to navigate to /r/all (thanks @corylulu)
- Hide Child Comments allows hiding children of any comment, instead of only top level comments (thanks @pltarun)
- New "adopt" scrollStyle which will keep the top of each comment in the same position as the last selected (thanks @larsjohnsen)
- New notifyEditedPosts option to show notifications when a subscribed post is edited (thanks @preethamrn)
- New custom filter for spoiler posts (thanks @preethamrn)
- Wiki page autocomplete is available when typing /w/, /wiki/, /r/sub/w/, or /r/sub/wiki/ (thanks @wojtekmaj)
- New option for automaticNightMode to adjust to sunrise/sunset times in your location (thanks @wojtekmaj)
- Orange warning candystripe on spoiler posts' expando buttons (thanks @andytuba, @roshkins)
- RES Settings Console search is updated as-you-type, performance improvements (thanks @wojtekmaj, @andytuba)
- New link icon in Account Switcher dropdown to navigate to an account's profile page
- Add short descriptions for each module in the Settings Console sidebar (thanks @dhensche)
- FilteReddit useRedditFilters now chooses the 100 most popular subreddits to sync, instead of the first 100 (thanks @erikdesjardins)
- Remove external CSS stylesheet (thanks @roshkins)
- Redesign toggle buttons to work better with other languages and improve aesthetics (thanks @WilliamChiu)
- Posts linking to i.redd.it .gifs now display the .mp4 instead of the (potentially huge) .gif (thanks @WilliamChiu)
- New Command Line "post" command to navigate to and prepopulate the submit page (thanks @andytuba)
- Add `data-host` attribute to expando buttons (thanks @larsjohnsen)

### Bug Fixes

- Fix Show Images maxWidth on comments pages (thanks @larsjohnsen)
- Fix empty custom toggles overlapping other toggles (thanks @erikdesjardins)
- Fix crash related to customFilters postAge (thanks @larsjohnsen)
- Fix comment permalinks containing non-ASCII characters being treated as post permalinks (thanks @erikdesjardins)
- Fix Account Switcher not switching accounts in new modmail (thanks @erikdesjardins)
- Fix Streamable attribution icon (thanks @BenMcGarry)
- Fix Never Ending Reddit not reselecting the last post on page 2+ (thanks @larsjohnsen)
- Fix Never Ending Reddit "return to previous page" modal sometimes not appearing (thanks @larsjohnsen)
- Fix Vote Enhancements not applying to newly loaded comments (thanks @erikdesjardins)
- Fix notifications not appearing (thanks @erikdesjardins)
- Fix X-Post Links accepting subreddit names with absurd lengths (thanks @erikdesjardins)
- Fix alignment of floating items (thanks @larsjohnsen)
- Fix Never Ending Reddit allowing further loading when no more results are found (thanks @larsjohnsen)
- Fix Keyboard Navigation automatic selection of newly loaded comments (thanks @larsjohnsen)
- Fix Comment Tools and Comment Preview not reappearing after editing comments multiple times (thanks @larsjohnsen, @erikdesjardins)
- Fix case-sensitive RegExp filters containing uppercase letters not matching anything (thanks @dhensche)
- Fix video expandos with non-default playback rate displaying the incorrect playback rate initially (thanks @WilliamChiu)
- Fix command line settings search (thanks @erikdesjardins)
- Fix reordering a table option not dirtying the settings console (thanks @erikdesjardins)
- Fix ctrl-enter to submit for link posts (thanks @erikdesjardins)
- Fix Comment Hide Persistor not working with reddit's comment link query params (thanks @andytuba)
- Fix reverse image searching reddituploads.com images (and other images with query params) (thanks @WilliamChiu)
- Fix Comment Navigator popular sorting selecting wrong posts on scroll (thanks @larsjohnsen)
- Fix key description for Go Mode commands in Keyboard Nav help (thanks @larsjohnsen)
- Fix regular hotkeys continuing to work with the Go Mode panel open (thanks @corylulu)
- Fix erroneously running on about.reddit.com (thanks @erikdesjardins)
- Fix duplicate expandos being unexpandable with keyboard shortcuts in certain situations (thanks @larsjohnsen)
- Fix Account Switcher displaying a narrow bar when loading account info fails (thanks @erikdesjardins)
- Fix Comment Hide Persistor collapsing things without visible uncollapse buttons (thanks @preethamrn)
- Fix expandoCommentRedirects "redirect" option (thanks @preethamrn)
- Fix a lot of functionality not working on domain search pages (thanks @erikdesjardins)

### Other

- Logged in user is now extracted from the profile URL, not text (which may be changed by other extensions) (thanks @preethamrn)
- Avoid forced synchronous layout when initializing Page Navigator showLink (thanks @larsjohnsen)
- Enable/disable some keyboard shortcuts based on more precise criteria (thanks @larsjohnsen)
- Comment Tools don't appear until you select the comment box, to avoid taking up unnecessary space (thanks @larsjohnsen, @alberto467)
- Comment Navigator changed to a dropdown menu, to take up less space (thanks @larsjohnsen)
- Keyboard Nav help (shift-/) only shows key commands that work on the current page (thanks @larsjohnsen)
- Enable User Tagger hardIgnore by default (thanks @jakewilson, @andytuba)
- Imgur host always loads videos over HTTPS (thanks @dhensche, @nfnty)
- Separate "new release" pages for stable and beta (thanks @BenMcGarry)
- Add unlimitedStorage permission in Edge (thanks @BenMcGarry)
- Defer adding diagnostics when submitting to /r/RESissues and similar subreddits (thanks @andytuba)
- Switch old-style filters over to a common framework (thanks @dhensche)
- Change method of watching for media resizing to reduce initialization jank (thanks @larsjohnsen)
- Gfycat videos with #?direction=reverse in the URL start reversed (thanks @WilliamChiu)
- Hide unusable voting arrows on archived posts by default (thanks @erikdesjardins)
- Add Night Mode styles for the Page Navigator showLink bar (thanks @erikdesjardins)
- Add some usage tips for Filterline (thanks @larsjohnsen)
- Clean up some options so that they do not display when overridden by other options (thanks @erikdesjardins)
- Avoid key conficts between goMode shortcuts and normal shortcuts by prompting for which behaviour to use (thanks @larsjohnsen)
- Avoid displaying the subreddit shortcuts alphabetize button when only one shortcut is present (thanks @andytuba)
- Notification with a link to show filter reasons is displayed when all posts are filtered out (thanks @larsjohnsen)

### Housekeeping

- Add ability to add additional search keywords to modules and options (thanks @wojtekmaj)
- Minor cleanup to version module (thanks @erikdesjardins)
- Update CodeClimate config (thanks @mc10)
- Cleanup ajax requests in Dashboard (thanks @mc10)
- Tweak init timing (thanks @erikdesjardins)
- Update dependencies (thanks @erikdesjardins)
- Use native Yarn on Appveyor (thanks @erikdesjardins)
- Update repo docs (thanks @erikdesjardins)
- Integration tests for many modules (thanks @erikdesjardins)
- Clean up some Show Images logic (thanks @larsjohnsen)
- Improve efficiency and ergonomics of utilities used to watch for elements (big thanks @larsjohnsen)
- Fix some table option management internals (thanks @larsjohnsen)
- Clean up build script caching (thanks @mc10)
- Clean up readme (thanks @mc10)
- Add util script for automatically localizing module options (thanks @roshkins)
- Unvendor jquery.tokeninput (thanks @wojtekmaj)
- Work around an issue with the Firefox submission API (thanks @erikdesjardins)
