## [v5.18.0](https://github.com/honestbleeps/Reddit-Enhancement-Suite/releases/v5.18.0)

### New Features

- Support for muted v.redd.it videos (thanks @erikdesjardins, @larsjohnsen)
- commentNavigator: Filters can be added for sort type "popular" (thanks @larsjohnsen)
- New module: [autoHide](https://www.reddit.com/#res:settings/autoHide) for hiding posts while scrolling (thanks @larsjohnsen)
  - Posts are hidden when the bottom button row is viewed for 2 seconds
  - By default are only comments marked viewed
- Optionally display flair emojis as text (enable [here](https://www.reddit.com/#res:settings/styleTweaks/flairEmojiAsText)) (thanks @overdodactyl)
- showImages: When a host requires optional permissions, also present a way to disable the host (thanks @larsjohnsen)
- filteReddit: New filter "user tag" (thanks @larsjohnsen)
- host PeerTube: Add support for peervideo.net (thanks @bjuergens)
- host Twitch: Add support for channel-based clip scheme (thanks @1bakedpotato)
- host ppy.sh: Add support for new osu.ppy.sh/ss scheme (thanks @mcpower)

### Bug Fixes

- Activate RES in redesign embedded iframes (thanks @creesh)
- Fix CLI command `RESStorage update` (thanks @larsjohnsen)
- Fix commentHidePersistor when using commentQuickCollapse (thanks @larsjohnsen)
- Fix storage pruning of options with default values (thanks @larsjohnsen)
- Hide subredditInfo for fake/reserved subreddits (thanks @prakhar1912)
- Run migrations in the background so that they can complete before the user opens Reddit (thanks @larsjohnsen)
- filteReddit: Filterline no longer shares state across of all /comments pages (thanks @larsjohnsen)
- host flickr: Fix embed and use (usually) high-res link src when possible (thanks @larsjohnsen)
- hover infocard: Clear header when loading (thanks @larsjohnsen)
- hover: Remove type prefix in ids and fix toggling (thanks @larsjohnsen)
- nightmode: Set background color to the `html` element to avoid FOUC in some circumstances (thanks @larsjohnsen)
- saveComments: Don't load all saved comments on every page view, and remove indication that a comment is already saved (thanks @larsjohnsen)
- showImages video: Restore playback when reopening expando (thanks @larsjohnsen)
- showImages: Expandos are marked as opened when the media is expanded (thanks @larsjohnsen)
- showImages: Prevent Reddit overriding expando button classes in self-texts (thanks @larsjohnsen)
- showImages: Try generic site modules when specific hosts fail (thanks @larsjohnsen)
- subredditInfo: Fix capitalized names not being cache invalidated (thanks @larsjohnsen)
- redesign: Add focus function to submitHelper.js (thanks @yanmahan97)

### Housekeeping / Other

- Clean-up (and remove many defunct) media hosts (thanks @larsjohnsen)
- Floater: Move to utils, add support for r2 userbar and tabmenu (thanks @andytuba, @larsjohnsen)
- Optimize generation +subscribe / +dashboard buttons to avoid potential extra reflow (thanks @larsjohnsen)
- Optimize subredditManager (thanks @larsjohnsen)
- Use jQuery as a direct dependency (thanks @larsjohnsen)
- Replace `safeHtml` with direct use of DOMPurify.santize (thanks @larsjohnsen)
- Remove jQuery dependency from utils/createElement and utils/alert (thanks @larsjohnsen)
- Remove little-used dependency $.tokenInput (thanks @larsjohnsen)
- Replace dependency numeral with Intl.FormatNumber (thanks @larsjohnsen)
- Replace jquery-sortable with sortablejs (thanks @larsjohnsen)
- Set min Firefox version to 69, and Chrome to 76 (thanks @larsjohnsen, @erikdesjardins)
- Display update notification type depending on the last version installed (thanks @larsjohnsen)
- dashboard: Build tabs only when activated, preventing unnecessary data from being loaded (thanks @larsjohnsen)
- host codepen: Retrieve iframe src instead of inserting remote HTML (thanks @larsjohnsen)
- hover: new method `watch` to invoke `begin` on `mouseover` (thanks @larsjohnsen)
- init: Log what may prevent RES from starting (thanks @larsjohnsen)
- ner: Remove option hideDupes (thanks @larsjohnsen)
- ner: Use DOMParser to parse the loaded page (thanks @larsjohnsen)
- r2 init: Tweak hiding of non-ready elements while loading (thanks @larsjohnsen)
- requestPermissions: Get optional permissions programmatically (thanks @larsjohnsen)
- showImages: Remove ResizeObserver polyfill for Firefox (thanks @larsjohnsen)
- showImages: Remove broken option convertGifstoGfycat (thanks @larsjohnsen)
- utils/PagePhases: Split from core/init (thanks @larsjohnsen)
- utils/SelectedThing: Split core functionality from selectedEntry (thanks @larsjohnsen)
- nightwatch: Log only actions which fail (thanks @larsjohnsen)
- package.json: Specify browserslist to reduce CSS autoprefixing  (thanks @larsjohnsen)
