## [v5.15.0](https://github.com/honestbleeps/Reddit-Enhancement-Suite/releases/v5.15.0)

### New Features

- Faster initialization by starting page mutations earlier (thanks @larsjohnsen)
- betteReddit: New option [restrictScrollEvents](https://www.reddit.com/#res:settings/betteReddit/restrictScrollEvents) to make Reddit use less CPU-time when scrolling (thanks @larsjohnsen)
- filteReddit: New option [hideUntilProcessed](https://www.reddit.com/#res:settings/filteReddit/hideUntilProcessed) to only show posts that have been processed through the filters, preventing FOUC (thanks @larsjohnsen)
- Support media host VLive.tv (thanks @sporksparks)

### Bug Fixes

- Prevent Reddit cloning RES elements when editing comments (thanks @larsjohnsen)
- Update subredditStyleToggle pageAction on animationFrame (thanks @larsjohnsen)
- autocomplete: Show also suggestions in the big editor (thanks @larsjohnsen)
- commentPreview eig editor: Improve open / close speed (thanks @larsjohnsen)
- commentTools autocomplete: Improve suggestion speed, refactor (thanks @larsjohnsen)
- filteReddit: Fix filter observer callback being invoked for every thing, instead of only those necessary (thanks @larsjohnsen)
- init: Don't batch loading of options (may fix FOUC issue for some Firefox users) (thanks @larsjohnsen)
- neverEndingReddit: Complete callbacks on current page before loading next page (thanks @larsjohnsen)
- redesign: Fix link to dashboard (thanks @prakhar1912)
- redesign: Make uncheckSendRepliesToInbox compatible with redesign (thanks @prakhar1912)
- redesign: Prevent duplication of user tags when navigating posts (thanks @prakhar1912)
- redesign: Fix accountSwitcher display current logged in account  (thanks @larsjohnsen)
- selectedEntry: Remove broken option selectLastThingOnLoad. To prevent initial selection of a thing should disable option setColor instead (thanks @larsjohnsen)
- selectedEntry: Try to select early if there's no previous selection (thanks @larsjohnsen)
- settingsConsole autostage: Use frameDebounce to make it react quicker (thanks @larsjohnsen)
- settingsNavigation options embed: Allow slower load without opening in new tab (thanks @larsjohnsen)
- showImages conserveMemory: Tweak IntersectionObserver setup to prevent erronous unloading on Chromium (thanks @larsjohnsen)
- showImages expando: Optimize element generation (thanks @larsjohnsen)
- subredditManager: Only run on r2 to avoid error message on redesign (thanks @larsjohnsen)
- userTagger: Rerender tags only if necessary (thanks @larsjohnsen)
- utils/string: Make `regexRegex` unicode compatible (thanks @larsjohnsen)
- neverEndingReddit: Display pause icon in widget (thanks @larsjohnsen)

### Housekeeping / Other

- CSS clean-up: Moves some rules from general stylesheet to the modules they are used. (thanks @larsjohnsen)
- New module init phase contentStart (thanks @larsjohnsen)
- Watchers use a just-in-time strategy to complete mutations (thanks @larsjohnsen)
  - Non-immediate watcher callbacks are executed when they are close to the viewport by using IntersectionObserver
  - Fewer requests to external providers are sent (e.g. expando host info is only fetched when necessary)
- Optimize showImages by avoiding checking visibility on every scroll event (thanks @larsjohnsen)
- Remove support for EdgeHTML (thanks @XenoBen)
- Update backup and restore module to be searchable for import/export terminology (thanks @honestbleeps)
- Rename init phase `loadDynamicOptions` to `onInit` (thanks @larsjohnsen)
- Replace dependency momentjs with much lighter dayjs (thanks @larsjohnsen)
- Update deps (thanks @larsjohnsen, @kevinji)
- Use interface CreateElement.fancyToggleButton to create fancy buttons (thanks @larsjohnsen)
- ava: Move config from package.json to ava.config.js (thanks @kevinji)
- betteReddit showVideoTimes: Refactor and add Host#getVideoData interface (thanks @larsjohnsen)
- packageInfo gitDescription: Use `git rev-parse HEAD` as fallback for `git describe` (thanks @larsjohnsen)
- selectedEntry is simplified; option scrollToSelectedThingOnLoad is removed  (thanks @larsjohnsen)
- storage wrapPrefix: Add option for auto batching `get` requests (thanks @larsjohnsen)
