/*
 * Copyright 2023 HM Revenue & Customs
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package uk.gov.hmrc.http

import izumi.reflect.Tag

object TypeUtil {
  object IsMap {
    def unapply[B: Tag](b: B): Option[Map[String, Seq[String]]] =
      if (Tag[B].tag =:= Tag[Map[String, String]].tag)
        Some(
          b.asInstanceOf[Map[String, String]]
            .map { case (k, v) => k -> Seq(v) }
        )
      else if (Tag[B].tag =:= Tag[Map[String, Seq[String]]].tag)
        Some(
          b.asInstanceOf[Map[String, Seq[String]]]
        )
      else
        None
  }
}
