/*
 * Copyright 2023 HM Revenue & Customs
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package uk.gov.hmrc.http

import uk.gov.hmrc.http.HttpVerbs.{DELETE => DELETE_VERB}
import uk.gov.hmrc.http.hooks.{HttpHooks, RequestData, ResponseData}
import uk.gov.hmrc.http.logging.ConnectionTracing

import scala.concurrent.{ExecutionContext, Future}

@deprecated("Use HttpClientV2", "15.0.0")
trait HttpDelete
  extends CoreDelete
     with DeleteHttpTransport
     with HttpVerb
     with ConnectionTracing
     with HttpHooks
     with Retries {

  private lazy val hcConfig = HeaderCarrier.Config.fromConfig(configuration)

  override def DELETE[O](
    url    : String,
    headers: Seq[(String, String)] = Seq.empty
  )(implicit
    rds: HttpReads[O],
    hc : HeaderCarrier,
    ec : ExecutionContext
  ): Future[O] =
    withTracing(DELETE_VERB, url) {
      val allHeaders   = HeaderCarrier.headersForUrl(hcConfig, url, headers) :+ "Http-Client-Version" -> BuildInfo.version
      val httpResponse = retryOnSslEngineClosed(DELETE_VERB, url)(doDelete(url, allHeaders))
      executeHooks(
        DELETE_VERB,
        url"$url",
        RequestData(allHeaders, None),
        httpResponse.map(ResponseData.fromHttpResponse)
      )
      mapErrors(DELETE_VERB, url, httpResponse).map(rds.read(DELETE_VERB, url, _))
    }
}
