<p align="center">
  <img src="https://github.com/hiaaryan/wora/blob/main/renderer/public/github/Header.png?raw=true" alt="Wora Logo" />
</p>

<p align="center">
  <a href="https://github.com/hiaaryan/wora"><img alt="GitHub Actions Workflow Status" src="https://img.shields.io/github/actions/workflow/status/hiaaryan/wora/release.yml"></a>
  <a href="https://github.com/hiaaryan/wora"><img src="https://img.shields.io/github/last-commit/hiaaryan/wora/main?commit" alt="Last Commit" /></a>
  <a href="LICENSE"><img src="https://img.shields.io/github/license/hiaaryan/wora?license" alt="License" /></a>
  <a href="https://discord.gg/CrAbAYMGCe"><img src="https://dcbadge.limes.pink/api/server/https://discord.gg/CrAbAYMGCe?style=flat" alt="Discord" /></a>
  <a href="https://github.com/hiaaryan/wora/stargazers"><img src="https://img.shields.io/github/stars/hiaaryan/wora?style=flat&stars" alt="GitHub Stars" /></a>
  <a href="https://github.com/hiaaryan/wora/network"><img src="https://img.shields.io/github/forks/hiaaryan/wora?style=flat&forks" alt="GitHub Forks" /></a>
  <a href="https://github.com/hiaaryan/wora/watchers"><img src="https://img.shields.io/github/watchers/hiaaryan/wora?style=flat&watchers" alt="GitHub Watchers" /></a>
</p>

## ⭐️ Description

**Wora** is a beautiful player for audiophiles (pun intended). An open-source lossless music player app that lets you organize and play your favorite tracks seamlessly. With Wora, you can:

- Create and manage playlists 🎉
- Stream FLACs, WAVs, Dolby apart from regular music extensions 🎧
- Quick play using command menu ⌨️
- View synced and unsynced lyrics 💬
- Admire the beautiful UI ✨

<p align="center">
  <img src="https://github.com/hiaaryan/wora/blob/main/renderer/public/github/Home%20Page.png?raw=true" alt="Screenshot 1" />
  <img src="https://github.com/hiaaryan/wora/blob/main/renderer/public/github/Search%20Console.png?raw=true" alt="Screenshot 2" />
  <img src="https://github.com/hiaaryan/wora/blob/main/renderer/public/github/Album%20Page.png?raw=true" alt="Screenshot 3" />
  <img src="https://github.com/hiaaryan/wora/blob/main/renderer/public/github/Synced%20Lyrics.png?raw=true" alt="Screenshot 4" />
</p>

## 🚀 Getting Started

A bit simpler process would be to download the latest build through [here](https://github.com/hiaaryan/wora/releases/). But if you want to fiddle around, then please follow the below steps which would help you get started. If you encounter any issues, support is available through our discord server 🛠️

<a href="https://discord.gg/CrAbAYMGCe"><img src="https://dcbadge.limes.pink/api/server/https://discord.gg/CrAbAYMGCe?style=flat" alt="Discord" /></a>

### 〽️ Prerequisites

- [Node.js](https://nodejs.org/) v14 or higher
- [Git](https://git-scm.com/) for obvious reasons
- [Yarn](https://yarnpkg.com/) for dependencies

### 👾 Installation

1. **Clone the repository:**

    ```sh
    git clone https://github.com/hiaaryan/wora.git
    cd wora
    ```

2. **Install the dependencies:**

    ```sh
    yarn install
    ```

4. **Start the application:**

    ```sh
    yarn dev
    ```

5. **Build the application**

    ```sh
    yarn build
    ```

## 🤝 Contributing

Contributions are always welcome! Please read the [Contributing Guide](CONTRIBUTING.md) to learn about the process and how to submit your contributions.

1. Fork the repository
2. Create a new branch (`git checkout -b feature-branch`)
3. Commit your changes (`git commit -am 'Add new feature'`)
4. Push to the branch (`git push origin feature-branch`)
5. Create a new Pull Request

## 💬 Join the Community

Join our [Discord server](https://discord.gg/CrAbAYMGCe) to connect with other users and developers.

<a href="https://discord.gg/CrAbAYMGCe"><img src="https://dcbadge.limes.pink/api/server/https://discord.gg/CrAbAYMGCe?style=flat" alt="Discord"></a>

---

MIT License. Made with ❤️ by [hiaaryan](https://github.com/hiaaryan) and contributors.
