
<p  align="center">

<img  alt="handreacting_logo"  src="./src/media/mainlogo.png"  width="250px"  />

</p>

  

# HandReacting

[![GitHub stars](https://img.shields.io/github/stars/hhhrrrttt222111/handReacting?color=ff69b4&style=flatsquare)](https://github.com/hhhrrrttt222111/handReacting/stargazers)
[![GitHub forks](https://img.shields.io/github/forks/hhhrrrttt222111/handReacting?color=blueviolet&style=flatsquare)](https://github.com/hhhrrrttt222111/handReacting/network)

  

Are you tired and fed up of the multitude of written assignments that you have to submit?

### *HandReacting* is the PERFECT solution to all your problems. It converts typed documents into handwritten ones 🖋, saving you a hella lotta time. ⏳

  

<br><br><br>

  
  

<p  align="center">

<img  alt="handreacting_image"  src="./src/media/read.svg"  width="250px"  />

</p>

## About the Project
HandReacting is an app which allows the user to generate handwritten text in the form of a downloadable image from the input given. It can be used by students to generate their assignments so that they don't have to go through the hassle of writing down everything physically.

The project has been made using React.

## Prerequisites

Required to install and run the software:

-   [npm](https://www.npmjs.com/get-npm)

## Installing and Running
From the project folder, run these commands in console (terminal) to install dependencies and run the app:
```
npm install
npm start
```
Open [http://localhost:3000](http://localhost:3000/) with your browser to see the result.

## Usage Instructions

 - Choose from 34 fonts that looks handwritten
 - Adjust font size to choose number of words in a line
 - Adjust font weight to change boldness of the text
 - Letter spacing and word spacing helps arrange words more closely
 - Change font color and paper page color to get paper like appearance
 - Adjusting line height is important when page lines are enabled
 - Page lines provide lines in the paper
 - Scan effect provides a shadow to the page
 - Page margin gives a margin to the page

## Screenshots

* Converting Text to 34 different handwritten font faces.

<p  align="center">

<img  src="./src/media/main.PNG"  alt=""/>

</p>

<br>

  

* Extracting text from images before converting to various fonts.

<p  align="center">

<img  src="./src/media/extract.PNG"  alt=""/>

</p>

<br>

  

* Converting speech to text

<p  align="center">

<img  src="./src/media/voice.PNG"  alt=""/>

</p>

  

<br  ><br  ><br  >

## Contributing

-   Refer the [CONTRIBUTING.md](https://github.com/hhhrrrttt222111/handReacting/blob/master/CONTRIBUTING.md) file for the guidelines for contributing to the project.

## Notes
HandReacting is a project made with React JS. 

**For any suggestions or bug reports, refer [CONTRIBUTING.md](https://github.com/hhhrrrttt222111/handReacting/blob/master/CONTRIBUTING.md) and raise an issue.** 

And yes, you can also thank me for making your life easier by giving a ⭐ for the HandReacting repository

## Resources

- If you are new to Git - [Git & Github for Beginners](https://www.youtube.com/watch?v=SWYqp7iY_Tc)
- For a more detailed understanding of the git flow - [Git Workflow Explained](https://medium.com/@swinkler/git-workflow-explained-a-step-by-step-guide-83c1c9247f03)
- **Before making changes, refer - [CONTRIBUTING.md](https://github.com/hhhrrrttt222111/handReacting/blob/master/CONTRIBUTING.md)**
- Writing good commit messages - [5 Useful Tips For A Better Commit Message](https://thoughtbot.com/blog/5-useful-tips-for-a-better-commit-message)



### Thank You!
