# Contributing

When contributing to this repository, **please first discuss the change you wish to make via the issue**,
email, or any other method with the owners of this repository before making a change. 

**Also, Before you start working on a issue, claim it and wait for it to be assigned to you!!!**


## Pull Request Process

- Fork Repository to your personal Github
- Clone the Repository to your local Machine
<br><br>`git clone <url to the project repo on your personal Github profile>`<br><br>

- Create a new branch for you to work on
<br><br>`git checkout -b <branch name>`<br><br>

- Set up Remote Repository to the original Repository
<br><br>`git remote add upstream <url to the organization on GitHub>`<br><br>

- Make your changes
- Pull the most recent version of the repo
<br><br>`git checkout master`
<br>`git pull upstream master`<br><br>

- Merge the master branch into the feature branch
<br><br>`git checkout feature`
<br>`git merge master`<br><br>

- Push the code to your Repo
<br><br>`git push origin feature`<br><br>

- Make a PR


## Resources

- If you are new to Git - [Git & Github for Beginners](https://www.youtube.com/watch?v=SWYqp7iY_Tc)
- For a more detailed understanding of the git flow - [Git Workflow Explained](https://medium.com/@swinkler/git-workflow-explained-a-step-by-step-guide-83c1c9247f03)
- For Installation - [README.md](https://github.com/hhhrrrttt222111/handReacting/blob/master/README.md)
