
Из языка Си в JavaScript перекочевали две операции: **инкремент** `++` и **декремент** `--`, которые очень часто встречаются вместе с циклами. Эти унарные операции увеличивают и уменьшают на единицу число, записанное в переменную:

```javascript
let i = 0;
i++; // 0
i++; // 1

i--; // 2
i--; // 1
```

Кроме постфиксной формы, у них есть и префиксная:

```javascript
let i = 0;
++i; // 1
++i; // 2

--i; // 1
--i; // 0
```

Кажется, что нет никакой разницы между постфиксной и префиксной формами. Но тут начинаются сложности.

В отличие от всех остальных операций, которые не имеют побочных эффектов и просто возвращают новое значение, инкремент и декремент не только возвращают значение, но и **изменяют** значение переменной.

При использовании префиксной нотации сначала происходит изменение переменной, а потом возврат.

При использовании постфиксной нотации — наоборот: можно считать, что сначала происходит возврат, а потом изменение переменной.

Правило работает одинаково для инкремента и декремента. Для простоты рассмотрим только инкремент:

```javascript
let x = 5;

console.log(++x); // => 6
console.log(x);   // => 6

console.log(x++); // => 6
console.log(x);   // => 7
```

https://replit.com/@hexlet/js-basic-mutators

Что происходит?

1. Вывели на экран `++x`. Это префиксный инкремент, поэтому сначала значение переменной увеличилось на 1, потом результат вернулся и вывелся на экран.
2. Так как значение изменилось, `console.log(x)` вывел 6.
3. Теперь выводим на экран `x++`. Это постфиксный инкремент, поэтому возвращено значение, содержавшееся в переменной до её увеличения на 1.
4. Так как значение изменилось, `console.log(x)` вывел 7.

---

Особенно страшным это становится тогда, когда инкремент вставляют внутрь других операций: `x = i++ - 7 + --h`. Понять такой код почти невозможно, и его написание должно рассматриваться как тяжкое преступление.

Например, в языке JavaScript линтер (программа, проверяющая код) сразу начинает ругаться, когда встречает использование инкремента или декремента.

Рекомендации по использованию:

* Никогда не мешайте в рамках одного выражения операции/функции без побочных эффектов с операциями/функциями, обладающими побочными эффектами.
* Используйте инкремент и декремент только там, где нет разницы между префиксным и постфиксным вариантом: отдельно от всего, на своей собственной строчке кода.
