
Циклы подходят не только для обработки чисел, но и при работе со строками. В первую очередь благодаря возможности получить конкретный символ по его индексу. Ниже пример кода, который распечатывает каждую букву слова на отдельной строке:

```javascript
const printNameBySymbol = (name) => {
  let i = 0;
  // Такая проверка будет выполняться до конца строки
  // включая последний символ. Его индекс `length - 1`.
  while (i < name.length) {
    // Обращаемся к символу по индексу
    console.log(name[i]);
    i = i + 1;
  }
};

const name = 'Arya';
printNameBySymbol(name);
// => A
// => r
// => y
// => a
```

https://replit.com/@hexlet/js-basic-iteration-over-string

Самое главное в этом коде, поставить правильное условие в `while`. Это можно сделать сразу двумя способами: `i < name.length` или `i <= name.length - 1`. Оба способа приводят к одному результату.
