
Программы, которые мы пишем, становятся всё сложнее и объемнее. Они все ещё очень далеки от реальных программ, где количество строк кода измеряется десятками и сотнями тысяч (а иногда и миллионами), но текущая сложность уже способна заставить напрячься людей без опыта. Начиная с этого урока, мы переходим к одной из самых сложных базовых тем в программировании – циклам.

Любые прикладные программы служат очень прагматичным целям. Они помогают управлять сотрудниками, финансами, развлекают в конце концов. Несмотря на различия, все эти программы выполняют заложенные в них алгоритмы, которые очень похожи между собой. Что это такое? Алгоритм — это последовательность действий (инструкций), которая приводит нас к некоему ожидаемому результату. В принципе, это описание подходит под любую программу, но под алгоритмами обычно понимается что-то более специфичное.

Представьте себе, что у нас есть книга и мы хотим найти внутри неё какую-то конкретную фразу. Саму фразу мы помним, но не знаем, на какой она странице. Как найти нужную страницу? Самый простой (и долгий) способ — последовательно просматривать страницы до тех пор, пока мы не найдем нужную. В худшем случае придется просмотреть все страницы, но результат мы всё равно получим. Именно этот процесс и называется алгоритмом. Он включает в себя логические проверки (нашли ли фразу) и перебор страниц. Количество страниц, которое придется посмотреть, заранее неизвестно, но сам процесс просмотра повторяется из раза в раз совершенно одинаковым образом. Для выполнения повторяющихся действий как раз и нужны циклы. Каждый повтор, в таком случае, называется итерацией.

Допустим мы хотим написать функцию, которая выводит на экран все числа от 1 до указанного (через аргументы):

```javascript
printNumbers(3);
// => 1
// => 2
// => 3
```

Эту функцию невозможно реализовать уже изученными средствами, так как количество выводов на экран заранее неизвестно. А с циклами это не составит никаких проблем:

```javascript
const printNumbers = (lastNumber) => {
  // i сокращение от index (порядковый номер)
  // используется по общему соглашению во множестве языков
  // как счетчик цикла
  let i = 1;

  while (i <= lastNumber) {
    console.log(i);
    i = i + 1;
  }
  console.log('finished!');
};

printNumbers(3);
```

<pre class='hexlet-basics-output'>
1
2
3
finished!
</pre>

https://replit.com/@hexlet/js-basics-while

В коде функции использован цикл `while`. Он состоит из трёх элементов:

* Ключевое слово `while`. Несмотря на схожесть с вызовом функций, это не вызов функции.
* Предикат. Условие, которое указывается в скобках после `while`. Это условие вычисляется и проверяется перед выполнением тела цикла на каждой итерации.
* Тело цикла. Блок кода в фигурных скобках. Этот блок аналогичен блоку кода в функциях. Всё, что определено внутри этого блока (константы или переменные), видно только внутри этого блока.

Конструкция читается так: «пока истинно условие (предикат) `i <= lastNumber` делать то, что указано в теле цикла». Разберём работу этого кода для вызова `printNumbers(3)`:

```javascript
// Инициализируется i
let i = 1;

// Предикат возвращает true, поэтому выполняется тело цикла
while (1 <= 3)
// console.log(1);
// i = 1 + 1;

// Закончилось тело цикла, поэтому происходит возврат в начало
while (2 <= 3)
// console.log(2);
// i = 2 + 1;

// Закончилось тело цикла, поэтому происходит возврат в начало
while (3 <= 3)
// console.log(3);
// i = 3 + 1;

// Предикат возвращает false, поэтому выполнение переходит за цикл
while (4 <= 3)

// console.log('finished!');
// На этом этапе i равен 4, но он нам уже не нужен
// функция завершается
```

Самое главное в цикле — завершение его работы (выход из цикла). Процесс, который порождает цикл, должен в конце концов остановиться. Ответственность за остановку полностью лежит на программисте. Обычно задача сводится к введению переменной, называемой «счётчиком цикла». Сначала счётчик инициализируется, то есть ему задаётся начальное значение. В нашем примере это инструкция `let i = 1`, выполняемая до входа в цикл. Затем в условии цикла проверяется, достиг ли счётчик своего предельного значения. И, наконец, счётчик меняет свое значение `i = i + 1`.

На этом моменте новички делают больше всего ошибок. Например, случайно забытое увеличение счётчика или неправильная проверка в предикате способны привести к зацикливанию. Это ситуация, при которой цикл работает бесконечно и программа никогда не останавливается. В таком случае приходится её завершать принудительно (кто знает, может быть когда зависают реальные программы, в этот момент внутри них выполняется бесконечный цикл).

```javascript
const printNumbers = (lastNumber) => {
  let i = 1;

  // Этот цикл никогда не остановится
  // и будет печатать всегда одно значение
  while (i <= lastNumber) {
    console.log(i);
  }
  console.log('finished!');
};
```

В некоторых случаях бесконечные циклы полезны. Здесь мы такие случаи не рассматриваем, но полезно видеть как выглядит этот код:

```javascript
while (true) {
  // Что-то делаем
}
```

Подводя итог. Когда всё же нужны циклы, а когда можно обойтись без них? Физически невозможно обойтись без циклов тогда, когда алгоритм решения задачи требует повторения каких-то действий, как в примере с книгой, и количество этих операций заранее неизвестно.
