
Наряду с конъюнкцией (И) и дизъюнкцией (ИЛИ), часто используется операция «отрицание». Отрицание меняет логическое значение на противоположное. В программировании ему соответствует унарный оператор `!`.

Если есть функция, проверяющая чётность числа, то с помощью отрицания можно выполнить проверку нечётности:

```javascript
const isEven = (number) => number % 2 === 0;

isEven(10);  // true
!isEven(10); // false
```

https://replit.com/@hexlet/js-basics-logical-negation

То есть мы просто добавили `!` слева от вызова функции и получили обратное действие.

Отрицание — мощный инструмент, который позволяет лаконично выражать задуманные правила в коде без необходимости писать новые функции.

А что если написать так `!!isEven(10)`? Внезапно, но код сработает. В логике двойное отрицание подобно отсутствию отрицания вообще.

```javascript
isEven(10);   // true
!isEven(10);  // false
!!isEven(10); // true
```
