
Логические операции — это выражения. Значит, логические операции можно комбинировать с другими выражениями.

Например, мы хотим проверить чётность числа, то есть кратность двум. В программировании используют такой подход:

* проверяют остаток от деления на 2:
  * если остаток 0, то число было чётным
  * если остаток не 0, то число было нечётным

Остаток от деления — простая, но очень важная концепция в арифметике, алгебре, и даже в теории чисел и криптографии. Идея проста: нужно разделить число на несколько равных групп, и если в конце что-то останется — это и есть остаток от деления.

Делим конфеты поровну между людьми:

- 7 конфет, 2 человека: 2 x 3 + **остаток 1**.
  Значит, 7 не кратно 2.
- 21 конфету, 3 человека: 3 x 7 + **остаток 0**.
  Значит, 21 кратно 3.
- 19 конфет, 5 человек: 5 x 3 + **остаток 4**.
  Значит, 19 не кратно 5.

Оператор `%` вычисляет остаток от деления (не путайте с делением):

```javascript
7 % 2;  // 1
21 % 3; // 0
19 % 5; // 4

// Проверка четности

10 % 2 // 10 чётное, так как остаток 0
9 % 2  // 9 нечётное, так как остаток 1
```

Напишем функцию проверки чётности:

```javascript
const isEven = (number) => number % 2 === 0;

isEven(10); // true
isEven(3);  // false
```

В одном выражении мы скомбинировали логический оператор `===` (проверка равенства) и арифметический оператор `%`.

Приоритет арифметических операций выше логических. Значит, сначала вычисляется арифметическое выражение `number % 2`, затем результат участвует в логическом сравнении.

Словами это можно расшифровать так: *«вычислить остаток от деления числа `number` на 2 и сравнить, равен ли остаток нулю; затем вернуть результат проверки равенства»*.

Другой пример: напишем функцию, которая принимает строку и проверяет, заглавная ли первая буква.

Алгоритм:

1. Получим и запишем в переменную первый символ из строки-параметра
2. Сравним, равен ли символ своей большой (заглавной) версии
3. Вернём результат

```javascript
const isFirstLetterInUpperCase = (string) => {
  const firstLetter = string[0];
  return firstLetter.toUpperCase() === firstLetter;
};

isFirstLetterInUpperCase('marmont'); // false
isFirstLetterInUpperCase('Robb');    // true
```

https://replit.com/@hexlet/js-basics-logica-operations
