
Кроме арифметических операций со школы нам известны операции сравнения. Например, `5 > 4`. Это звучит как вопрос: «5 больше 4?». В данном случае ответ «да». В других случаях ответом может быть «нет», например, для `3 < 1`.

Операции сравнения не имеют привязки к числам. Сравнивать можно практически всё что угодно, например, строки. Каждый раз, когда мы входим на какой-то сайт, внутри происходит сравнение введенных логина и пароля с теми, какие есть в базе. И только если они есть, нас пускают внутрь (авторизируют).

Языки программирования адаптировали все математические операции сравнения практически в неизменном виде. Единственное серьезное отличие – операторы равенства и неравенства. В математике для этого используется обычное равно `=`, но в программировании такое встречается не часто. Во многих языках символ `=` используется для присваивания значений переменным, поэтому для сравнения взяли `==` или `===`.

Список операций сравнения в JavaScript:

* `<` меньше
* `<=` меньше или равно
* `>` больше
* `>=` больше или равно
* `===` равно
* `!==` не равно

_Небольшая ремарка: для равенства и неравенства также существуют операторы `==` и `!=`, которые мы не будем использовать из-за потенциальной опасности. Мы поговорим об этом в будущих уроках._

Логическая операция типа `5 > 4` или `password === text` — это выражение, и его результат — специальное значение `true` («истина») или `false` («ложь»). Это новый для нас тип данных — boolean. Он содержит всего лишь два этих значения.

```javascript
const result = 5 > 4;
console.log(result); // => true
console.log('one' !== 'one'); // => false
```

Наряду со строками (string), целыми и рациональными числами (number), логический тип (boolean) — это один из примитивных типов данных в JavaScript.

---

Попробуем написать примитивную функцию, которая принимает на вход возраст ребенка и определяет, младенец ли он. Младенцами считаются дети до года:

```javascript
const isInfant = (age) => age < 1;
```

Пользуемся тем фактом, что любая операция — это выражение, поэтому единственной строчкой функции пишем «вернуть то значение, которое получится в результате сравнения `age < 1`».

В зависимости от пришедшего аргумента, сравнение будет либо истинным (`true`), либо ложным (`false`), и `return` вернёт этот результат.

```javascript
const isInfant = (age) => age < 1;

console.log(isInfant(3));
```

<pre class='hexlet-basics-output'>false</pre>

https://replit.com/@hexlet/js-basics-logic-bool-type

А теперь проверим ребенка, которому полгода:

```javascript
console.log(isInfant(0.5));
```

<pre class='hexlet-basics-output'>true</pre>
